/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.dTree;

import oracle.bali.ewt.dTree.DTree;
import oracle.bali.ewt.dTree.DTreeItem;
import oracle.bali.ewt.dTree.DTreeRange;
import oracle.bali.ewt.dTree.DTreeRootItem;

public class DTreeSelection
implements Cloneable {
    private DTreeRange[] _ranges;
    private int _itemCount;

    public final void addRange(DTreeRange dTreeRange) {
        DTreeRange[] dTreeRangeArray = new DTreeRange[]{dTreeRange};
        this.addRanges(dTreeRangeArray);
    }

    public void addRanges(DTreeRange[] dTreeRangeArray) {
        int n;
        DTreeRange[] dTreeRangeArray2 = null;
        int n2 = 0;
        int n3 = n = dTreeRangeArray == null ? 0 : dTreeRangeArray.length;
        if (this._ranges == null) {
            dTreeRangeArray2 = dTreeRangeArray;
            n2 = n;
        } else {
            int n4 = this.getCount();
            n2 = n + n4;
            dTreeRangeArray2 = new DTreeRange[n2];
            System.arraycopy(dTreeRangeArray, 0, dTreeRangeArray2, 0, n);
            System.arraycopy(this._ranges, 0, dTreeRangeArray2, n, this._ranges.length);
        }
        dTreeRangeArray2 = this._normalizeRanges(dTreeRangeArray2, n2);
        this._ranges = dTreeRangeArray2;
        this._itemCount = this._countItems();
    }

    public Object clone() {
        DTreeSelection dTreeSelection = new DTreeSelection();
        dTreeSelection.addRanges(this._ranges);
        return dTreeSelection;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof DTreeSelection)) {
            return false;
        }
        DTreeSelection dTreeSelection = (DTreeSelection)object;
        if (dTreeSelection.getCount() != this.getCount()) {
            return false;
        }
        int n = 0;
        int n2 = this.getCount();
        while (n < n2) {
            if (!this._ranges[n].equals(dTreeSelection.getRange(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public final DTreeSelection getAncestorSelection() {
        Object object;
        int n = this.getCount();
        Object object2 = new DTreeRange[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            object = this.getRange(n3);
            DTreeItem dTreeItem = ((DTreeRange)object).getParent();
            boolean bl = false;
            int n4 = 0;
            while (n4 < n3) {
                if (this.getRange(n4).isItemDescendent(dTreeItem)) {
                    bl = true;
                    break;
                }
                ++n4;
            }
            if (!bl) {
                object2[n2++] = object;
            }
            ++n3;
        }
        if (((DTreeRange[])object2).length > n2) {
            object = new DTreeRange[n2];
            System.arraycopy(object2, 0, object, 0, n2);
            object2 = object;
        }
        object = new DTreeSelection();
        ((DTreeSelection)object).addRanges((DTreeRange[])object2);
        return object;
    }

    public int getCount() {
        return this._ranges == null ? 0 : this._ranges.length;
    }

    public final DTreeItem getFirstItem() {
        if (this.getItemCount() == 0) {
            return null;
        }
        DTreeRange dTreeRange = this.getRange(0);
        return dTreeRange.getParent().getItem(dTreeRange.getStartIndex());
    }

    public final int getItemCount() {
        return this._itemCount;
    }

    public final DTreeItem[] getItems() {
        DTreeItem[] dTreeItemArray;
        DTreeItem[] dTreeItemArray2 = new DTreeItem[1];
        int n = 0;
        int n2 = 0;
        while (n2 < this.getCount()) {
            dTreeItemArray = this.getRange(n2);
            DTreeItem dTreeItem = dTreeItemArray.getParent();
            int n3 = dTreeItemArray.getStartIndex();
            int n4 = dTreeItemArray.getCount();
            int n5 = n3;
            while (n5 < n3 + n4) {
                DTreeItem dTreeItem2 = dTreeItem.getItem(n5);
                if (n == dTreeItemArray2.length) {
                    DTreeItem[] dTreeItemArray3 = new DTreeItem[n * 2];
                    System.arraycopy(dTreeItemArray2, 0, dTreeItemArray3, 0, n);
                    dTreeItemArray2 = dTreeItemArray3;
                }
                dTreeItemArray2[n] = dTreeItem2;
                ++n5;
                ++n;
            }
            ++n2;
        }
        if (n < dTreeItemArray2.length) {
            dTreeItemArray = new DTreeItem[n];
            System.arraycopy(dTreeItemArray2, 0, dTreeItemArray, 0, n);
            dTreeItemArray2 = dTreeItemArray;
        }
        return dTreeItemArray2;
    }

    public DTreeRange getRange(int n) {
        return this._ranges[n];
    }

    public final boolean isItemDescendent(DTreeItem dTreeItem) {
        int n = this.getCount();
        int n2 = 0;
        while (n2 < n) {
            if (this.getRange(n2).isItemDescendent(dTreeItem)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    void __itemsAdded(DTreeItem dTreeItem, int n, int n2) {
        int n3 = this.getCount();
        DTreeRange[] dTreeRangeArray = new DTreeRange[n3];
        int n4 = 0;
        while (n4 < n3) {
            int n5;
            DTreeRange dTreeRange = this.getRange(n4);
            DTreeItem dTreeItem2 = dTreeRange.getParent();
            if (dTreeItem == dTreeItem2 && (n5 = dTreeRange.getStartIndex()) >= n) {
                dTreeRange = new DTreeRange(dTreeItem, n5 + n2, dTreeRange.getCount());
            }
            dTreeRangeArray[n4] = dTreeRange;
            ++n4;
        }
        this._ranges = null;
        this.addRanges(dTreeRangeArray);
    }

    void __itemsRemoved(DTreeItem dTreeItem, int n, int n2) {
        DTreeRange[] dTreeRangeArray;
        int n3 = n + n2 - 1;
        DTree dTree = dTreeItem.getTree();
        DTreeRootItem dTreeRootItem = dTree.getRoot();
        int n4 = this.getCount();
        DTreeRange[] dTreeRangeArray2 = new DTreeRange[n4];
        int n5 = 0;
        int n6 = 0;
        while (n6 < n4) {
            dTreeRangeArray = this.getRange(n6);
            DTreeItem dTreeItem2 = dTreeRangeArray.getParent();
            if (dTreeItem2 == dTreeItem) {
                int n7;
                int n8 = dTreeRangeArray.getStartIndex();
                int n9 = n8 + (n7 = dTreeRangeArray.getCount()) - 1;
                if (n > n9) {
                    dTreeRangeArray2[n5++] = dTreeRangeArray;
                } else if (n3 < n8) {
                    dTreeRangeArray2[n5++] = new DTreeRange(dTreeItem, n8 - n2, n7);
                } else if (n <= n8) {
                    if (n3 < n9) {
                        dTreeRangeArray2[n5++] = new DTreeRange(dTreeItem, n, n9 - n3);
                    }
                } else {
                    int n10 = n - n8;
                    if (n3 < n9) {
                        n10 += n9 - n3;
                    }
                    dTreeRangeArray2[n5++] = new DTreeRange(dTreeItem, n8, n10);
                }
            } else if (dTreeItem2.getTree() != null && DTree.isItemDescendent(dTreeItem2, dTreeRootItem)) {
                dTreeRangeArray2[n5++] = dTreeRangeArray;
            }
            ++n6;
        }
        if (n5 < dTreeRangeArray2.length) {
            dTreeRangeArray = new DTreeRange[n5];
            System.arraycopy(dTreeRangeArray2, 0, dTreeRangeArray, 0, n5);
            dTreeRangeArray2 = dTreeRangeArray;
        }
        this._ranges = null;
        this.addRanges(dTreeRangeArray2);
    }

    private DTreeRange[] _normalizeRanges(DTreeRange[] dTreeRangeArray, int n) {
        Object object;
        DTreeRange[] dTreeRangeArray2 = new DTreeRange[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            object = dTreeRangeArray[n3];
            DTreeItem dTreeItem = ((DTreeRange)object).getParent();
            while (n4 < n2) {
                DTreeRange dTreeRange = dTreeRangeArray2[n4];
                DTreeItem dTreeItem2 = dTreeRange.getParent();
                if (dTreeItem == dTreeItem2) {
                    if (((DTreeRange)object).getStartIndex() < dTreeRange.getStartIndex()) {
                        System.arraycopy(dTreeRangeArray2, n4, dTreeRangeArray2, n4 + 1, n2 - n4);
                        dTreeRangeArray2[n4] = object;
                        ++n2;
                        break;
                    }
                } else if (DTree.isItemBefore(dTreeItem, dTreeItem2)) {
                    System.arraycopy(dTreeRangeArray2, n4, dTreeRangeArray2, n4 + 1, n2 - n4);
                    dTreeRangeArray2[n4] = object;
                    ++n2;
                    break;
                }
                ++n4;
            }
            if (n4 == n2) {
                dTreeRangeArray2[n4] = object;
                ++n2;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < n2) {
            DTreeRange dTreeRange = dTreeRangeArray2[n3];
            object = dTreeRange.getParent();
            int n5 = dTreeRange.getStartIndex();
            int n6 = dTreeRange.getCount();
            if (n6 <= 0) {
                System.arraycopy(dTreeRangeArray2, n3 + 1, dTreeRangeArray2, n3, n2 - (n3 + 1));
                --n2;
                continue;
            }
            int n7 = n3 + 1;
            while (n7 < n2 && object == dTreeRangeArray2[n7].getParent()) {
                DTreeRange dTreeRange2 = dTreeRangeArray2[n7];
                int n8 = dTreeRange2.getStartIndex();
                int n9 = dTreeRange2.getCount();
                if (n8 > n5 + n6) break;
                n6 = Math.max(n6, n8 + n9 - n5);
                dTreeRangeArray2[n3] = new DTreeRange((DTreeItem)object, n5, n6);
                System.arraycopy(dTreeRangeArray2, n7 + 1, dTreeRangeArray2, n7, n2 - (n7 + 1));
                --n2;
            }
            ++n3;
        }
        if (n2 < dTreeRangeArray2.length) {
            DTreeRange[] dTreeRangeArray3 = new DTreeRange[n2];
            System.arraycopy(dTreeRangeArray2, 0, dTreeRangeArray3, 0, n2);
            dTreeRangeArray2 = dTreeRangeArray3;
        }
        return dTreeRangeArray2;
    }

    private int _countItems() {
        int n = 0;
        int n2 = this.getCount();
        int n3 = 0;
        while (n3 < n2) {
            DTreeRange dTreeRange = this.getRange(n3);
            n += dTreeRange.getCount();
            ++n3;
        }
        return n;
    }
}

