/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.dTree;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.Icon;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import oracle.bali.ewt.dTree.DTree;
import oracle.bali.ewt.dTree.DTreeDecoration;
import oracle.bali.ewt.dTree.DTreeDragSource;
import oracle.bali.ewt.dTree.DTreeDropTarget;
import oracle.bali.ewt.dTree.DTreeItem;
import oracle.bali.ewt.dTree.DTreeItemEvent;
import oracle.bali.ewt.dTree.DTreeRange;
import oracle.bali.ewt.dTree.DTreeRootItem;
import oracle.bali.ewt.dTree.DTreeSelection;
import oracle.bali.ewt.dTree.DTreeSelectionManager;
import oracle.bali.ewt.elaf.EWTTreeUI;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.PaintContextProxy;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.util.ImmInsets;
import oracle.bali.share.nls.LocaleUtils;
import oracle.bali.share.util.IntegerUtils;

public abstract class DTreeBaseItem
extends PaintContextProxy
implements DTreeItem {
    private transient DTreeItem _parent;
    private transient int _index;
    private transient boolean _paintSelected;
    private transient boolean _paintFocused;
    private static final String _CLIENTPROP_EDITOR_KEY = "dTreeBaseItemEditor";
    static final int _ACTION_COUNT = 6;
    static final int _ACTION_ACTIVATE = 0;
    static final int _ACTION_TOGGLE_EXPAND = 1;
    static final int _ACTION_TOGGLE_SELECTED = 2;
    static final int _ACTION_EDIT = 3;
    static final int _ACTION_COMMIT_EDIT = 4;
    static final int _ACTION_CANCEL_EDIT = 5;
    static final String _ACCESSIBILITY_BUNDLE = "oracle.bali.ewt.resource.AccessibilityBundle";
    static final String _LEVEL_LABEL = "DTREEITEM_LEVEL_LABEL";
    static final String _LEVEL_TYPE_LABEL = "DTREEITEM_LEVEL_TYPE_LABEL";
    private transient AccessibleContext _accessibleContext;
    private String _accessibleType;

    public void activate() {
        DTree dTree = this.getTree();
        dTree.dispatchEvent(new DTreeItemEvent(dTree, 2004, this));
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public AccessibleContext getAccessibleContext() {
        if (this._accessibleContext == null) {
            this._accessibleContext = this.createAccessibleContext();
        }
        return this._accessibleContext;
    }

    protected AccessibleContext createAccessibleContext() {
        return new AccessibleItem();
    }

    public String getAccessibleType() {
        return this._accessibleType;
    }

    public void setAccessibleType(String string) {
        if (this._accessibleType != string) {
            String string2 = this._accessibleContext == null ? null : this._accessibleContext.getAccessibleName();
            this._accessibleType = string;
            if (this._accessibleContext != null) {
                this._accessibleContext.firePropertyChange("AccessibleName", string2, this._accessibleContext.getAccessibleName());
            }
        }
    }

    public DTreeDragSource getDragSource() {
        if (this instanceof DTreeDragSource) {
            return (DTreeDragSource)((Object)this);
        }
        return null;
    }

    public DTreeDropTarget getDropTarget() {
        if (this instanceof DTreeDropTarget) {
            return (DTreeDropTarget)((Object)this);
        }
        return null;
    }

    public Rectangle getEditBounds() {
        DTree dTree = this.getTree();
        EWTTreeUI eWTTreeUI = dTree.getUI();
        return eWTTreeUI.getEditBounds(dTree, this, this);
    }

    public abstract String getLabel();

    public Dimension getSize() {
        if (this.getParent() == null) {
            return new Dimension(0, 0);
        }
        DTree dTree = this.getTree();
        EWTTreeUI eWTTreeUI = dTree.getUI();
        Painter painter = eWTTreeUI.getItemPainter(dTree, this);
        return painter.getPreferredSize(this);
    }

    public final int getHeight() {
        return this.getSize().height;
    }

    public int getIndex() {
        return this._index;
    }

    public DTreeItem getItem(int n) {
        return null;
    }

    public DTreeItem getItemAt(int n, int n2) {
        if (n2 < this.getSize().height) {
            return this;
        }
        return null;
    }

    public int getItemCount() {
        return 0;
    }

    public DTreeItem getNextExpandedChild(DTreeItem dTreeItem) {
        return null;
    }

    public DTreeItem getParent() {
        return this._parent;
    }

    public int getSubTreeHeight() {
        return this.getSize().height;
    }

    public int getSubTreeWidth() {
        return this.getSize().width;
    }

    public int getSubTreeX() {
        return this.getX();
    }

    public int getSubTreeY() {
        return this.getY();
    }

    public DTree getTree() {
        DTreeItem dTreeItem = this.getParent();
        if (dTreeItem == null) {
            return null;
        }
        return dTreeItem.getTree();
    }

    public int getX() {
        int n = 0;
        DTreeItem dTreeItem = this.getParent();
        while (dTreeItem != null) {
            ++n;
            dTreeItem = dTreeItem.getParent();
        }
        DTree dTree = this.getTree();
        int n2 = dTree.getIndentWidth();
        int n3 = this._getRootIndentWidth(dTree, n2);
        if (n == 0) {
            return n3;
        }
        return (n - 1) * n2 + n3;
    }

    public final int getWidth() {
        return this.getSize().width;
    }

    public boolean isExpandable() {
        return this.getItemCount() > 0;
    }

    public boolean isExpanded() {
        return false;
    }

    public void itemAdded(DTreeItem dTreeItem, int n) {
        this._parent = dTreeItem;
        this._index = n;
        DTree dTree = this.getTree();
        if (dTree != null) {
            dTree.__fireAccessibleEvent("AccessibleChild", null, this);
        }
    }

    public void itemRemoved() {
        DTree dTree = this.getTree();
        if (dTree != null) {
            dTree.__fireAccessibleEvent("AccessibleChild", this, null);
        }
        this._parent = null;
    }

    public void paint(Graphics graphics, boolean bl, boolean bl2, int n, int n2) {
        DTree dTree = this.getTree();
        EWTTreeUI eWTTreeUI = dTree.getUI();
        Painter painter = eWTTreeUI.getItemPainter(dTree, this);
        this._paintSelected = bl;
        this._paintFocused = bl2;
        Font font = graphics.getFont();
        Color color = graphics.getColor();
        graphics.setColor(this.getPaintForeground());
        graphics.setFont(this.getPaintFont());
        painter.paint(this, graphics, 0, 0, n, n2);
        graphics.setColor(color);
        graphics.setFont(font);
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        switch (keyEvent.getID()) {
            case 401: {
                this.keyPressed(keyEvent);
                break;
            }
            case 402: {
                this.keyReleased(keyEvent);
            }
        }
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        switch (mouseEvent.getID()) {
            case 501: {
                this.mousePressed(mouseEvent);
            }
        }
    }

    public void setExpanded(boolean bl) {
    }

    public void setIndex(int n) {
        this._index = n;
    }

    public Component startEdit() {
        DTree dTree = this.getTree();
        if (!this.isEditable() || dTree == null) {
            return null;
        }
        JTextField jTextField = (JTextField)dTree.getClientProperty(_CLIENTPROP_EDITOR_KEY);
        if (jTextField == null) {
            jTextField = new KeyHandlerEditor();
            jTextField.setBorder(UIManager.getBorder("Tree.editorBorder"));
            jTextField.setFont(this.getPaintFont());
            dTree.putClientProperty(_CLIENTPROP_EDITOR_KEY, jTextField);
        }
        jTextField.setText(this.getLabel());
        jTextField.selectAll();
        return jTextField;
    }

    protected Icon getIcon() {
        return null;
    }

    protected boolean isEditable() {
        DTree dTree = this.getTree();
        if (dTree != null) {
            return dTree.isEditable();
        }
        return false;
    }

    protected PaintContext getPaintContext() {
        return this.getTree().getPaintContext();
    }

    protected void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 37: {
                if (!this.isExpandable() || !this.isExpanded()) break;
                this.setExpanded(false);
                keyEvent.consume();
                break;
            }
            case 39: {
                if (!this.isExpandable() || this.isExpanded()) break;
                this.setExpanded(true);
                keyEvent.consume();
                break;
            }
            case 10: {
                if (keyEvent.getModifiers() != 0) break;
                keyEvent.consume();
            }
        }
    }

    protected void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10 && keyEvent.getModifiers() == 0) {
            keyEvent.consume();
            this.activate();
            if (this.isExpandable()) {
                this.setExpanded(!this.isExpanded());
            }
        }
    }

    protected void mousePressed(MouseEvent mouseEvent) {
        DTree dTree = this.getTree();
        int n = mouseEvent.getX() + dTree.getCanvasOriginX();
        if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() % 2 == 0 && n > 0 && n < this.getSize().width) {
            this.activate();
            if (this.isExpandable()) {
                this.setExpanded(!this.isExpanded());
            }
            mouseEvent.consume();
        }
    }

    private int _getDepth() {
        if (this.getTree() == null) {
            return 0;
        }
        DTreeRootItem dTreeRootItem = this.getTree().getRoot();
        if (dTreeRootItem == null) {
            return 0;
        }
        int n = -1;
        DTreeItem dTreeItem = this;
        while (dTreeItem != dTreeRootItem && dTreeItem != null) {
            dTreeItem = dTreeItem.getParent();
            ++n;
        }
        return n;
    }

    private int _getRootIndentWidth(DTree dTree, int n) {
        DTreeDecoration dTreeDecoration = dTree.getDecoration();
        ImmInsets immInsets = dTreeDecoration.getDecorationInsets(dTree);
        if (immInsets != null) {
            return immInsets.left;
        }
        return 0;
    }

    protected AccessibleContext accessAccessibleContext() {
        return this._accessibleContext;
    }

    public float getInteriorAlignmentX() {
        return 0.0f;
    }

    public float getInteriorAlignmentY() {
        return 0.5f;
    }

    public Object getPaintData(Object object) {
        if (object == null || object == PaintContext.LABEL_KEY) {
            return this.getLabel();
        }
        if (object == PaintContext.ICON_KEY) {
            return this.getIcon();
        }
        return super.getPaintData(object);
    }

    public int getPaintState() {
        DTree dTree = this.getTree();
        PaintContext paintContext = dTree.getPaintContext();
        int n = paintContext.getPaintState();
        if (this._paintSelected) {
            n |= 0x20;
        }
        n = this._paintFocused ? (n |= 0x40) : (n &= 0xFFFFFFBF);
        return n;
    }

    public abstract void layout(int var1, int var2);

    public abstract int getY();

    public abstract boolean commitEdit(Component var1);

    private class AccessibleItem
    extends AccessibleContext
    implements AccessibleAction,
    AccessibleSelection,
    AccessibleComponent {
        private AccessibleItem() {
        }

        public String getAccessibleName() {
            String string = this.accessibleName;
            if (string == null || "".equals(string)) {
                String string2 = DTreeBaseItem.this.getAccessibleType();
                String string3 = IntegerUtils.getString((int)DTreeBaseItem.this._getDepth());
                String string4 = DTreeBaseItem.this.getLabel();
                if (string4 == null) {
                    string = null;
                } else if (string2 == null) {
                    String string5 = this._getTranslatedString(DTreeBaseItem._LEVEL_LABEL);
                    MessageFormat messageFormat = new MessageFormat(string5);
                    Object[] objectArray = new Object[]{string3, string4};
                    string = messageFormat.format(objectArray);
                } else {
                    String string6 = this._getTranslatedString(DTreeBaseItem._LEVEL_TYPE_LABEL);
                    MessageFormat messageFormat = new MessageFormat(string6);
                    Object[] objectArray = new Object[]{string3, string2, string4};
                    string = messageFormat.format(objectArray);
                }
            }
            return string;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LABEL;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = new AccessibleStateSet();
            DTree dTree = DTreeBaseItem.this.getTree();
            DTreeBaseItem dTreeBaseItem = DTreeBaseItem.this;
            DTreeItem dTreeItem = dTree == null ? null : dTree.getFocusedItem();
            accessibleStateSet.add(AccessibleState.TRANSIENT);
            accessibleStateSet.add(AccessibleState.VISIBLE);
            if (this.isShowing()) {
                accessibleStateSet.add(AccessibleState.SHOWING);
            }
            if (dTree != null && dTree.isEnabled()) {
                accessibleStateSet.add(AccessibleState.ENABLED);
            }
            accessibleStateSet.add(AccessibleState.FOCUSABLE);
            if (dTree != null && dTreeItem == dTreeBaseItem) {
                accessibleStateSet.add(AccessibleState.FOCUSED);
            }
            accessibleStateSet.add(AccessibleState.SELECTABLE);
            if (dTree != null && dTree.getSelectionManager().isSelected(dTreeBaseItem)) {
                accessibleStateSet.add(AccessibleState.SELECTED);
            }
            if (DTreeBaseItem.this.isExpandable()) {
                accessibleStateSet.add(AccessibleState.EXPANDABLE);
            }
            if (DTreeBaseItem.this.isExpanded()) {
                accessibleStateSet.add(AccessibleState.EXPANDED);
            } else if (DTreeBaseItem.this.isExpandable()) {
                accessibleStateSet.add(AccessibleState.COLLAPSED);
            }
            if (dTreeBaseItem == dTreeItem) {
                accessibleStateSet.add(AccessibleState.ACTIVE);
            }
            return accessibleStateSet;
        }

        public Accessible getAccessibleParent() {
            DTreeItem dTreeItem = DTreeBaseItem.this.getParent();
            if (dTreeItem != null) {
                return dTreeItem;
            }
            return DTreeBaseItem.this.getTree();
        }

        public int getAccessibleIndexInParent() {
            return DTreeBaseItem.this.getIndex();
        }

        public int getAccessibleChildrenCount() {
            return DTreeBaseItem.this.getItemCount();
        }

        public Accessible getAccessibleChild(int n) {
            if (n < 0 || n >= DTreeBaseItem.this.getItemCount()) {
                return null;
            }
            return DTreeBaseItem.this.getItem(n);
        }

        public Locale getLocale() {
            return DTreeBaseItem.this.getTree().getLocale();
        }

        public AccessibleAction getAccessibleAction() {
            return this;
        }

        public AccessibleComponent getAccessibleComponent() {
            return this;
        }

        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        public int getAccessibleActionCount() {
            return 6;
        }

        public String getAccessibleActionDescription(int n) {
            String string = null;
            switch (n) {
                case 0: {
                    string = "ACTIVATE";
                    break;
                }
                case 1: {
                    string = "TOGGLE_EXPAND";
                    break;
                }
                case 2: {
                    string = "TOGGLE_SELECTED";
                    break;
                }
                case 3: {
                    string = "EDIT";
                    break;
                }
                case 4: {
                    string = "COMMIT_EDIT";
                    break;
                }
                case 5: {
                    string = "CANCEL_EDIT";
                }
            }
            return string == null ? null : this._getTranslatedString(string);
        }

        public boolean doAccessibleAction(int n) {
            boolean bl = false;
            DTree dTree = DTreeBaseItem.this.getTree();
            DTreeBaseItem dTreeBaseItem = DTreeBaseItem.this;
            switch (n) {
                case 0: {
                    DTreeBaseItem.this.activate();
                    bl = true;
                    break;
                }
                case 1: {
                    if (!DTreeBaseItem.this.isExpandable()) break;
                    boolean bl2 = DTreeBaseItem.this.isExpanded();
                    DTreeBaseItem.this.setExpanded(!bl2);
                    if (DTreeBaseItem.this.isExpanded() == bl2) break;
                    bl = true;
                    break;
                }
                case 2: {
                    try {
                        dTree.getSelectionManager().toggleItem(dTreeBaseItem);
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                    break;
                }
                case 3: {
                    if (!dTree.isEditable()) break;
                    bl = dTree.startEdit(dTreeBaseItem);
                    break;
                }
                case 4: {
                    if (!dTree.isEditing()) break;
                    dTree.commitEdit();
                    bl = true;
                    break;
                }
                case 5: {
                    if (!dTree.isEditing()) break;
                    dTree.cancelEdit();
                    bl = true;
                }
            }
            return bl;
        }

        public int getAccessibleSelectionCount() {
            DTree dTree = DTreeBaseItem.this.getTree();
            DTreeBaseItem dTreeBaseItem = DTreeBaseItem.this;
            DTreeSelectionManager dTreeSelectionManager = dTree.getSelectionManager();
            DTreeSelection dTreeSelection = dTreeSelectionManager.getSelection();
            int n = dTreeSelection.getCount();
            int n2 = 0;
            int n3 = 0;
            while (n2 < n) {
                DTreeRange dTreeRange = dTreeSelection.getRange(n2);
                if (dTreeRange.getParent() == dTreeBaseItem) {
                    n3 += dTreeRange.getCount();
                } else if (n3 > 0) break;
                ++n2;
            }
            return n3;
        }

        public Accessible getAccessibleSelection(int n) {
            DTree dTree = DTreeBaseItem.this.getTree();
            DTreeBaseItem dTreeBaseItem = DTreeBaseItem.this;
            DTreeSelectionManager dTreeSelectionManager = dTree.getSelectionManager();
            DTreeSelection dTreeSelection = dTreeSelectionManager.getSelection();
            int n2 = dTreeSelection.getCount();
            int n3 = 0;
            while (n3 < n2) {
                DTreeRange dTreeRange = dTreeSelection.getRange(n3);
                if (dTreeRange.getParent() == dTreeBaseItem) {
                    int n4 = dTreeRange.getCount();
                    if (n < n4) {
                        return DTreeBaseItem.this.getItem(dTreeRange.getStartIndex() + n);
                    }
                    n -= n4;
                }
                ++n3;
            }
            return null;
        }

        public boolean isAccessibleChildSelected(int n) {
            DTree dTree = DTreeBaseItem.this.getTree();
            DTreeBaseItem dTreeBaseItem = DTreeBaseItem.this;
            DTreeSelectionManager dTreeSelectionManager = dTree.getSelectionManager();
            return dTreeSelectionManager.isSelected(DTreeBaseItem.this.getItem(n));
        }

        public void addAccessibleSelection(int n) {
            DTreeItem dTreeItem;
            DTree dTree = DTreeBaseItem.this.getTree();
            DTreeSelectionManager dTreeSelectionManager = dTree.getSelectionManager();
            if (!dTreeSelectionManager.isSelected(dTreeItem = DTreeBaseItem.this.getItem(n))) {
                try {
                    dTreeSelectionManager.toggleItem(dTreeItem);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }

        public void removeAccessibleSelection(int n) {
            DTreeItem dTreeItem;
            DTree dTree = DTreeBaseItem.this.getTree();
            DTreeSelectionManager dTreeSelectionManager = dTree.getSelectionManager();
            if (dTreeSelectionManager.isSelected(dTreeItem = DTreeBaseItem.this.getItem(n))) {
                try {
                    dTreeSelectionManager.toggleItem(dTreeItem);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }

        public void clearAccessibleSelection() {
            DTree dTree = DTreeBaseItem.this.getTree();
            DTreeBaseItem dTreeBaseItem = DTreeBaseItem.this;
            DTreeSelectionManager dTreeSelectionManager = dTree.getSelectionManager();
            DTreeSelection dTreeSelection = dTreeSelectionManager.getSelection();
            int n = dTreeSelection.getCount();
            int n2 = 0;
            DTreeSelection dTreeSelection2 = new DTreeSelection();
            while (n2 < n) {
                DTreeRange dTreeRange = dTreeSelection.getRange(n2);
                if (dTreeRange.getParent() != dTreeBaseItem) {
                    dTreeSelection2.addRange(dTreeRange);
                }
                ++n2;
            }
            try {
                dTreeSelectionManager.setSelection(dTreeSelection2);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }

        public void selectAllAccessibleSelection() {
            DTree dTree = DTreeBaseItem.this.getTree();
            DTreeSelectionManager dTreeSelectionManager = dTree.getSelectionManager();
            DTreeSelection dTreeSelection = dTreeSelectionManager.getSelection();
            DTreeRange dTreeRange = new DTreeRange(DTreeBaseItem.this, 0, DTreeBaseItem.this.getItemCount());
            dTreeSelection.addRange(dTreeRange);
            try {
                dTreeSelectionManager.setSelection(dTreeSelection);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }

        public Color getBackground() {
            return DTreeBaseItem.this.getPaintBackground();
        }

        public void setBackground(Color color) {
        }

        public Color getForeground() {
            return DTreeBaseItem.this.getPaintForeground();
        }

        public void setForeground(Color color) {
        }

        public Cursor getCursor() {
            return DTreeBaseItem.this.getTree().getCursor();
        }

        public void setCursor(Cursor cursor) {
        }

        public Font getFont() {
            return DTreeBaseItem.this.getPaintFont();
        }

        public void setFont(Font font) {
        }

        public FontMetrics getFontMetrics(Font font) {
            return DTreeBaseItem.this.getFontMetrics(font);
        }

        public boolean isEnabled() {
            return (DTreeBaseItem.this.getPaintState() & 1) == 0;
        }

        public void setEnabled(boolean bl) {
        }

        public boolean isVisible() {
            return true;
        }

        public void setVisible(boolean bl) {
        }

        public boolean isShowing() {
            DTree dTree = DTreeBaseItem.this.getTree();
            if (dTree == null) {
                return false;
            }
            return dTree.isShowing() && DTree.isItemVisible(DTreeBaseItem.this);
        }

        public boolean contains(Point point) {
            Dimension dimension = this.getSize();
            if (dimension == null) {
                return false;
            }
            return point.x >= 0 && point.x < dimension.width && point.y >= 0 && point.y < dimension.height;
        }

        public Point getLocationOnScreen() {
            if (this.isShowing()) {
                Point point = DTreeBaseItem.this.getTree().getLocationOnScreen();
                point.x += DTreeBaseItem.this.getX();
                point.y += DTreeBaseItem.this.getY();
                return point;
            }
            return null;
        }

        public Point getLocation() {
            DTreeItem dTreeItem = DTreeBaseItem.this.getParent();
            if (dTreeItem == null) {
                return new Point(0, 0);
            }
            return new Point(DTreeBaseItem.this.getX() - dTreeItem.getX(), DTreeBaseItem.this.getY() - dTreeItem.getY());
        }

        public void setLocation(Point point) {
        }

        public Rectangle getBounds() {
            if (!this.isShowing()) {
                return null;
            }
            Dimension dimension = this.getSize();
            DTreeItem dTreeItem = DTreeBaseItem.this.getParent();
            int n = 0;
            int n2 = 0;
            if (dTreeItem != null) {
                n = dTreeItem.getX();
                n2 = dTreeItem.getY();
            }
            return new Rectangle(DTreeBaseItem.this.getX() - n, DTreeBaseItem.this.getY() - n2, dimension.width, dimension.height);
        }

        public void setBounds(Rectangle rectangle) {
        }

        public Dimension getSize() {
            return DTreeBaseItem.this.getSize();
        }

        public void setSize(Dimension dimension) {
        }

        public Accessible getAccessibleAt(Point point) {
            DTree dTree = DTreeBaseItem.this.getTree();
            Point point2 = this.getLocation();
            DTreeItem dTreeItem = dTree.getItemAt(point2.x + point.x, point2.y + point.y);
            if (DTree.isItemDescendent(dTreeItem, DTreeBaseItem.this)) {
                return dTreeItem;
            }
            return null;
        }

        public boolean isFocusTraversable() {
            return true;
        }

        public void requestFocus() {
            if (this.isFocusTraversable()) {
                DTree dTree = DTreeBaseItem.this.getTree();
                dTree.requestFocus();
                dTree.setFocusedItem(DTreeBaseItem.this);
            }
        }

        public void addFocusListener(FocusListener focusListener) {
        }

        public void removeFocusListener(FocusListener focusListener) {
        }

        private String _getTranslatedString(String string) {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(DTreeBaseItem._ACCESSIBILITY_BUNDLE, LocaleUtils.getDefaultableLocale((Component)DTreeBaseItem.this.getTree()));
            return resourceBundle.getString(string);
        }
    }

    private class KeyHandlerEditor
    extends JTextField {
        private KeyHandlerEditor() {
        }

        public void processComponentKeyEvent(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 38 || keyEvent.getKeyCode() == 40) {
                keyEvent.consume();
            }
        }
    }
}

