/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.chooser.color;

import java.awt.Color;
import java.awt.event.FocusEvent;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import oracle.bali.ewt.graphics.ColorUtils;

class HexEditor
extends JTextField {
    public static final String PROPERTY_COLOR = "color";
    private static final char _HASH = '#';
    private boolean _ignoreEvent;

    public HexEditor() {
        super(null);
        this.setColumns(7);
        this.enableEvents(4L);
    }

    public void replaceSelection(String string) {
        Document document = this.getDocument();
        String string2 = null;
        int n = -1;
        int n2 = -1;
        if (document != null) {
            try {
                Caret caret = this.getCaret();
                n = Math.min(caret.getDot(), caret.getMark());
                n2 = Math.max(caret.getDot(), caret.getMark());
                if (n != n2) {
                    string2 = document.getText(n, n2 - n);
                    this._ignoreEvent = true;
                    document.remove(n, n2 - n);
                    this._ignoreEvent = false;
                }
                if (string != null && string.length() > 0) {
                    document.insertString(n, string, null);
                } else if (string2 != null) {
                    this._fireColorChanged(this.getColor());
                }
            }
            catch (BadLocationException badLocationException) {
                if (string2 != null) {
                    try {
                        this._ignoreEvent = true;
                        document.insertString(n, string2, null);
                        this.select(n, n2);
                    }
                    catch (BadLocationException badLocationException2) {
                        // empty catch block
                    }
                }
                this.getToolkit().beep();
            }
        }
        this._ignoreEvent = false;
    }

    public Color getColor() {
        String string = this.getText();
        if (string == null) {
            return null;
        }
        return ColorUtils.htmlToColor(string);
    }

    public void setColor(Color color) {
        this._ignoreEvent = true;
        this.setText(ColorUtils.colorToHTML(color));
        this._ignoreEvent = false;
    }

    protected Document createDefaultModel() {
        return new HexDocument();
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        if (focusEvent.getID() == 1005) {
            int n;
            String string = this.getText();
            int n2 = n = string == null ? 0 : string.length();
            if (n != 7) {
                this.setColor(this.getColor());
            }
        }
    }

    private boolean _validateString(String string, int n) {
        String string2 = this.getText();
        int n2 = string2.length();
        int n3 = string2.indexOf(35);
        int n4 = 0;
        int n5 = 0;
        while (n5 < string.length()) {
            n4 = n + n5;
            char c = string.charAt(n5);
            if (c >= '0' && c <= '9') {
                if (n4 == 0 && n3 >= 0) {
                    return false;
                }
            } else if (c == '#') {
                if (n4 != 0) {
                    return false;
                }
            } else if (c >= 'a' && c <= 'f') {
                if (n4 == 0 && n3 >= 0) {
                    return false;
                }
            } else if (c >= 'A' && c <= 'F') {
                if (n4 == 0 && n3 >= 0) {
                    return false;
                }
            } else {
                return false;
            }
            ++n5;
        }
        String string3 = null;
        string3 = n == 0 ? string + string2 : (n >= n2 ? string2 + string : string2.substring(0, n) + string + string2.substring(n, n2));
        int n6 = string3.length();
        if (n6 > 7) {
            return false;
        }
        return n6 != 7 || string3.indexOf(35) != -1;
    }

    private void _fireColorChanged(Color color) {
        if (!this._ignoreEvent) {
            this.firePropertyChange(PROPERTY_COLOR, null, color);
        }
    }

    private class HexDocument
    extends PlainDocument {
        private HexDocument() {
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (string == null || string.length() == 0) {
                return;
            }
            if (!HexEditor.this._validateString(string, n)) {
                throw new BadLocationException(null, n);
            }
            super.insertString(n, string, attributeSet);
        }

        protected void fireInsertUpdate(DocumentEvent documentEvent) {
            super.fireInsertUpdate(documentEvent);
            HexEditor.this._fireColorChanged(HexEditor.this.getColor());
        }

        protected void fireChangedUpdate(DocumentEvent documentEvent) {
            super.fireChangedUpdate(documentEvent);
            HexEditor.this._fireColorChanged(HexEditor.this.getColor());
        }

        protected void fireRemoveUpdate(DocumentEvent documentEvent) {
            super.fireRemoveUpdate(documentEvent);
            HexEditor.this._fireColorChanged(HexEditor.this.getColor());
        }
    }
}

