/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.chooser.color;

import java.applet.Applet;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JRootPane;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import oracle.bali.ewt.LookAndFeel;
import oracle.bali.ewt.border.BorderAdapter;
import oracle.bali.ewt.chooser.color.ColorPickerPane;
import oracle.bali.ewt.chooser.color.ColorPickerUtils;
import oracle.bali.ewt.chooser.color.CustomColorPane;
import oracle.bali.ewt.graphics.Appearance;
import oracle.bali.ewt.graphics.ColorUtils;
import oracle.bali.ewt.grid.AbstractAppearanceManager;
import oracle.bali.ewt.grid.CellInputHandler;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.GridKeyHandler;
import oracle.bali.ewt.grid.GridToolTipManager;
import oracle.bali.ewt.grid.ProxyPainter;
import oracle.bali.ewt.grid.StandardGridKeyHandler;
import oracle.bali.ewt.model.ArrayTwoDModel;
import oracle.bali.ewt.model.NullTwoDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.painter.AbstractBorderPainter;
import oracle.bali.ewt.painter.BorderPainter;
import oracle.bali.ewt.painter.NullPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.selection.Cell;
import oracle.bali.ewt.util.ImmInsets;
import oracle.bali.ewt.util.MenuUtils;
import oracle.bali.share.nls.LocaleUtils;
import oracle.bali.share.util.IntegerUtils;

public class ColorGrid
extends Grid {
    public static final int PALETTE_DEFAULT = 0;
    public static final int PALETTE_CSS_16 = 1;
    public static final int PALETTE_49_COLOR = 2;
    public static final int PALETTE_80_COLOR = 3;
    public static final int PALETTE_OLAF_96 = 4;
    public static final int PALETTE_WEBSAFE_216 = 5;
    public static final int PALETTE_16_COLOR = 6;
    public static final int PALETTE_72_COLOR = 7;
    public static final int PALETTE_143_COLOR = 8;
    public static final int PALETTE_256_COLOR = 9;
    public static final int RGB_TOOLTIP = 0;
    public static final int RGB_HEX_TOOLTIP = 1;
    public static final String PROPERTY_SELECTED_COLOR = "selectedColor";
    private static final int _STD_GRID = 0;
    private static final int _CUSTOM_GRID = 1;
    private static final int[] _COLUMN_WIDTH = new int[]{13, 16};
    private static final int[] _ROW_HEIGHT = new int[]{13, 19};
    private static final String _RESOURCE_BUNDLE = "oracle.bali.ewt.resource.JEWTBundle";
    private static final String _ACCESSIBLE_BUNDLE = "oracle.bali.ewt.resource.AccessibilityBundle";
    private static final String _KEY_TOOLTIP = "COLORPALETTE.TOOLTIP";
    private static final String _KEY_NO_COLOR = "COLORPALETTE.NO_COLOR";
    private static final Border[] _BORDER = new Border[2];
    private static final Color _DEFAULT_CUSTOM_COLOR = Color.white;
    private static final int _ARMED = 1;
    private static final int _SELECTED = 2;
    private static final BorderPainter[] _CELL_BORDER = new BorderPainter[4];
    private static final int _SELECT = 0;
    private static final int _NOT_SELECT = 1;
    private static final int _FILL_INSET = 2;
    private static final ImmInsets[] _CELL_INSET = new ImmInsets[3];
    private static Painter _sDefaultPainter;
    private static CellInputHandler _sGridInputHandler;
    private static GridKeyHandler _sGridKeyHandler;
    private static GridToolTipManager _sToolTipManager;
    private int _armedColumn = -1;
    private int _armedRow = -1;
    private int _selectedColumn = -1;
    private int _selectedRow = -1;
    private int _selectedSlotColumn = -1;
    private int _selectedSlotRow = -1;
    private int _toolTipMode = -1;
    private boolean _customGrid;
    private boolean _enableSlot;
    private TwoDModel _colorNames;

    public ColorGrid() {
        this(null, null, false);
    }

    public ColorGrid(boolean bl) {
        this(null, null, bl);
    }

    public ColorGrid(TwoDModel twoDModel, Color color) {
        this(twoDModel, color, false);
    }

    public ColorGrid(TwoDModel twoDModel, Color color, boolean bl) {
        this._customGrid = bl;
        int n = this._customGrid ? 1 : 0;
        this.setDefaultRowHeight(_ROW_HEIGHT[n]);
        this.setDefaultColumnWidth(_COLUMN_WIDTH[n]);
        if (this._customGrid) {
            this.setHorizontalSeparatorsVisible(false);
            this.setVerticalSeparatorsVisible(false);
        } else {
            this.setHorizontalSeparatorColor(Color.black);
            this.setVerticalSeparatorColor(Color.black);
        }
        this.setDrawFocusCellHighlite(false);
        this.setDefaultPainter(ColorGrid._getDefaultCellPainter());
        this.setAppearanceManager(new ColorAppearanceManager());
        this.setOverlayBorderVisible(false);
        this.setBorder(ColorGrid._getColorGridBorder(n));
        this.setGridSelectionManager(null);
        this.setDefaultInputHandler(ColorGrid._getGridInputHandler());
        this.setGridKeyHandler(ColorGrid._getGridKeyHandler());
        this.setToolTipMode(0);
        this.setToolTipManager(ColorGrid._getToolTipManager());
        this.setColorPalette(twoDModel);
        this.setSelectedColor(color);
    }

    public static TwoDModel getDefaultColorPalette() {
        return ColorGrid.getColorPalette(0);
    }

    public static TwoDModel getColorPalette(int n) {
        Color[][] colorArray;
        switch (n) {
            case 0: 
            case 9: {
                colorArray = ColorPickerUtils.get256ColorPalette();
                break;
            }
            case 1: {
                colorArray = ColorPickerUtils.getCSS16ColorPalette();
                break;
            }
            case 2: {
                colorArray = ColorPickerUtils.get49ColorPalette();
                break;
            }
            case 3: {
                colorArray = ColorPickerUtils.get80ColorPalette();
                break;
            }
            case 4: {
                colorArray = ColorPickerUtils.getOlaf96ColorPalette();
                break;
            }
            case 5: {
                colorArray = ColorPickerUtils.getWebSafe216ColorPalette();
                break;
            }
            case 6: {
                colorArray = ColorPickerUtils.get16ColorPalette();
                break;
            }
            case 7: {
                colorArray = ColorPickerUtils.get72ColorPalette();
                break;
            }
            case 8: {
                colorArray = ColorPickerUtils.get143ColorPalette();
                break;
            }
            default: {
                throw new IllegalArgumentException(n + " is not valid");
            }
        }
        return new DefaultColorPalette(n, colorArray);
    }

    public static TwoDModel getDefaultCustomColorPalette(TwoDModel twoDModel) {
        int n;
        if (twoDModel != null && (n = twoDModel.getColumnCount()) > 1) {
            return new ArrayTwoDModel(n - 1, 2);
        }
        return NullTwoDModel.getTwoDModel();
    }

    public static Color getClosestColor(TwoDModel twoDModel, Color color) {
        int n = twoDModel.getColumnCount();
        int n2 = twoDModel.getRowCount();
        int n3 = color.getRed();
        int n4 = color.getGreen();
        int n5 = color.getBlue();
        Color color2 = null;
        int n6 = Integer.MAX_VALUE;
        int n7 = 0;
        while (n7 < n) {
            int n8 = 0;
            while (n8 < n2) {
                Color color3 = (Color)twoDModel.getData(n7, n8);
                if (color3 != null) {
                    int n9;
                    int n10;
                    int n11 = n3 - color3.getRed();
                    int n12 = n11 * n11 + (n10 = n4 - color3.getGreen()) * n10 + (n9 = n5 - color3.getBlue()) * n9;
                    if (n12 == 0) {
                        return color3;
                    }
                    if (n12 < n6) {
                        n6 = n12;
                        color2 = color3;
                    }
                }
                ++n8;
            }
            ++n7;
        }
        return color2;
    }

    public boolean isCustomGrid() {
        return this._customGrid;
    }

    public void setColorPalette(TwoDModel twoDModel) {
        if (twoDModel == null && !this.isCustomGrid()) {
            twoDModel = ColorGrid.getDefaultColorPalette();
        }
        if (this.getModel() != twoDModel) {
            this.__setSelectedColor(-1, -1);
            this.__setSelectedSlot(-1, -1, true);
            this._setArmedCell(-1, -1);
            this.setModel(twoDModel);
            this.setPreferredRowsOnScreen(this.getRowCount());
            this.setPreferredColumnsOnScreen(this.getColumnCount());
            this.revalidate();
            this.repaint();
        }
    }

    public TwoDModel getColorPalette() {
        return this.getModel();
    }

    public void setSelectedColor(Color color) {
        int n;
        if (color == null) {
            this.__setSelectedColor(-1, -1);
            return;
        }
        int n2 = -1;
        int n3 = -1;
        TwoDModel twoDModel = this.getModel();
        int n4 = twoDModel.getColumnCount();
        int n5 = twoDModel.getRowCount();
        int n6 = 0;
        while (n6 < n4) {
            int n7 = 0;
            while (n7 < n5) {
                Color color2 = (Color)twoDModel.getData(n6, n7);
                if (color2 == null) {
                    if (n2 == -1) {
                        n2 = n6;
                        n3 = n7;
                    }
                } else if (color.equals(color2)) {
                    this.__setSelectedColor(n6, n7);
                    return;
                }
                ++n7;
            }
            ++n6;
        }
        if (this.isCustomGrid() && _DEFAULT_CUSTOM_COLOR.equals(color) && n2 != -1) {
            this.__setSelectedColor(n2, n3);
            return;
        }
        Container container = this.getParent();
        while (container != null) {
            if (container instanceof CustomColorPane || container instanceof ColorPickerPane) {
                throw new IllegalArgumentException("Color not found " + color);
            }
            container = container.getParent();
        }
        if (twoDModel instanceof DefaultColorPalette && ColorPickerUtils.isColorInOldPalettes(n = ((DefaultColorPalette)twoDModel).getPaletteType(), color)) {
            this.setSelectedColor(ColorGrid.getClosestColor(twoDModel, color));
            return;
        }
        throw new IllegalArgumentException("Color not found " + color);
    }

    public Color getSelectedColor() {
        int n = this.__getSelectedColumn();
        int n2 = this.__getSelectedRow();
        if (n == -1 || n2 == -1) {
            return null;
        }
        return (Color)this.getModel().getData(n, n2);
    }

    public Color getClosestColor(Color color) {
        return ColorGrid.getClosestColor(this.getColorPalette(), color);
    }

    public void setToolTipMode(int n) {
        this._toolTipMode = n;
    }

    public int getToolTipMode() {
        return this._toolTipMode;
    }

    public void updateUI() {
        super.updateUI();
        this.setOverlayBorderVisible(false);
        Color color = this.getBackground();
        if (color == null || color instanceof UIResource) {
            this.setBackground(this.getUIDefaults().getColor(LookAndFeel.CONTROL));
        }
    }

    public void removeNotify() {
        if (this.getFocusCell() != null) {
            int n = this.__getSelectedColumn();
            int n2 = this.__getSelectedRow();
            if (n == -1 || n2 == -1) {
                n = this.getNextVisibleColumn(-1);
                n2 = this.getNextVisibleRow(-1);
            }
            if (n != -1 && n2 != -1) {
                this.requestFocus(n, n2, null);
            }
        }
        this._setArmedCell(-1, -1);
        this.__setSelectedSlot(-1, -1, true);
        super.removeNotify();
    }

    public Point getToolTipLocation(MouseEvent mouseEvent) {
        Container container;
        Cloneable cloneable;
        Object object;
        if (this.getToolTipManager() == null) {
            return super.getToolTipLocation(mouseEvent);
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        Point point = this.convertOuterToCanvas(mouseEvent.getX(), mouseEvent.getY());
        int n3 = this.getColumnAt(point.x);
        int n4 = this.getRowAt(point.y);
        if (n3 < 0 || n4 < 0) {
            return super.getToolTipLocation(mouseEvent);
        }
        Rectangle rectangle = this.getBounds();
        rectangle.setLocation(this.getLocationOnScreen());
        GraphicsDevice[] graphicsDeviceArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        Object object2 = null;
        int n5 = 0;
        while (n5 < graphicsDeviceArray.length) {
            object = graphicsDeviceArray[n5].getDefaultConfiguration();
            cloneable = ((GraphicsConfiguration)object).getBounds();
            if (((Rectangle)cloneable).contains(n + rectangle.x, n2 + rectangle.y)) {
                object2 = object;
                break;
            }
            ++n5;
        }
        if (object2 == null) {
            return super.getToolTipLocation(mouseEvent);
        }
        object = ((GraphicsConfiguration)object2).getBounds();
        cloneable = MenuUtils.getScreenInsets((GraphicsConfiguration)object2);
        ((Rectangle)object).x += ((Insets)cloneable).left;
        ((Rectangle)object).y += ((Insets)cloneable).top;
        ((Rectangle)object).width -= ((Insets)cloneable).left + ((Insets)cloneable).right;
        ((Rectangle)object).height -= ((Insets)cloneable).top + ((Insets)cloneable).bottom;
        Container container2 = container = this.getParent();
        while (container != null) {
            container2 = container.getParent();
            if (container instanceof JRootPane && container2 != null && (container2 instanceof Window || container2 instanceof Applet)) {
                Rectangle rectangle2 = container.getBounds();
                rectangle2.setLocation(container.getLocationOnScreen());
                SwingUtilities.computeIntersection(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, (Rectangle)object);
                break;
            }
            container = container2;
        }
        int n6 = this.getRowPosition(n4);
        int n7 = this.getColumnPosition(n3);
        int n8 = this.getRowHeight(n4);
        int n9 = this.getColumnWidth(n3);
        int n10 = this.getDefaultRowHeight() / 2;
        int n11 = this.getDefaultColumnWidth() / 2;
        Dimension dimension = new Dimension(((Rectangle)object).width, ((Rectangle)object).y + ((Rectangle)object).height - (rectangle.y + n6 + n8 + n10));
        Dimension dimension2 = new Dimension(((Rectangle)object).width, rectangle.y + n6 - (((Rectangle)object).y + n10));
        Dimension dimension3 = new Dimension(((Rectangle)object).x + ((Rectangle)object).width - (rectangle.x + n7 + n9 + n11), ((Rectangle)object).height);
        Dimension dimension4 = new Dimension(rectangle.x + n7 - (((Rectangle)object).x + n11), ((Rectangle)object).height);
        JToolTip jToolTip = this.createToolTip();
        jToolTip.setTipText(this.getToolTipText(mouseEvent));
        Dimension dimension5 = jToolTip.getPreferredSize();
        int n12 = -1;
        int n13 = -1;
        if (dimension5.width <= dimension.width && dimension5.height <= dimension.height) {
            n12 = n7;
            n13 = n6 + n8 + 8;
        } else if (dimension5.width <= dimension3.width && dimension5.height <= dimension3.height) {
            n12 = n7 + n9 + 8;
            n13 = n6;
        } else if (dimension5.width <= dimension2.width && dimension5.height <= dimension2.height) {
            n12 = n7;
            n13 = n6 - (8 + dimension5.height);
        } else if (dimension5.width <= dimension4.width && dimension5.height <= dimension4.height) {
            n12 = n7 - (8 + dimension5.width);
            n13 = n6;
        }
        if (n12 == -1 || n13 == -1) {
            return super.getToolTipLocation(mouseEvent);
        }
        if (n12 + rectangle.x < ((Rectangle)object).x) {
            n12 = ((Rectangle)object).x - rectangle.x;
        } else if (n12 + rectangle.x - ((Rectangle)object).x + dimension5.width > ((Rectangle)object).width) {
            n12 = ((Rectangle)object).x + Math.max(0, ((Rectangle)object).width - dimension5.width) - rectangle.x;
        }
        if (n13 + rectangle.y < ((Rectangle)object).y) {
            n13 = ((Rectangle)object).y - rectangle.y;
        } else if (n13 + rectangle.y - ((Rectangle)object).y + dimension5.height > ((Rectangle)object).height) {
            n13 = ((Rectangle)object).y + Math.max(0, ((Rectangle)object).height - dimension5.height) - rectangle.y;
        }
        return new Point(n12, n13);
    }

    protected String getAccessibleName(int n, int n2, Color color) {
        return this._colorToString(n, n2, color, true);
    }

    protected Grid.AccessibleGrid createAccessibleGrid() {
        return new Access();
    }

    protected void paintOverChildren(Graphics graphics) {
        super.paintOverChildren(graphics);
        if (this.isCustomGrid()) {
            return;
        }
        int n = this._getArmedColumn();
        int n2 = this._getArmedRow();
        if (n != -1 && n2 != -1) {
            Rectangle rectangle = this.getCellBounds(n, n2, n, n2);
            rectangle.setLocation(this.convertInteriorToOuter(rectangle.x, rectangle.y));
            --rectangle.x;
            --rectangle.y;
            rectangle.width += 2;
            rectangle.height += 2;
            graphics.setColor(Color.white);
            graphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
        }
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        try {
            this.freezeRepaints();
            super.processMouseMotionEvent(mouseEvent);
            Object var3_2 = null;
            this.unfreezeRepaints();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.unfreezeRepaints();
            throw throwable;
        }
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        int n = focusEvent.getID();
        if (n == 1004) {
            Cell cell = this.getFocusCell();
            if (cell != null) {
                this._setArmedCell(cell.column, cell.row);
            }
        } else if (n == 1005) {
            this._setArmedCell(-1, -1);
        }
    }

    void __setSelectedColor(int n, int n2) {
        int n3 = this._selectedColumn;
        int n4 = this._selectedRow;
        if (n3 != n || n4 != n2) {
            try {
                this.freezeRepaints();
                TwoDModel twoDModel = this.getModel();
                Color color = n3 != -1 && n4 != -1 ? (Color)twoDModel.getData(n3, n4) : null;
                this._selectedColumn = n;
                this._selectedRow = n2;
                boolean bl = this._selectedColumn != -1 && this._selectedRow != -1;
                Color color2 = null;
                if (bl) {
                    color2 = (Color)twoDModel.getData(this._selectedColumn, this._selectedRow);
                    if (this.isCustomGrid() && color2 == null) {
                        color2 = new Color(_DEFAULT_CUSTOM_COLOR.getRGB());
                        twoDModel.setData(this._selectedColumn, this._selectedRow, color2);
                    }
                }
                if (n3 != -1 && n4 != -1) {
                    this.repaintCell(n3, n4);
                }
                if (!bl) {
                    n = this.getNextVisibleColumn(-1);
                    n2 = this.getNextVisibleRow(-1);
                }
                if (n != -1 && n2 != -1) {
                    this.requestFocus(n, n2, null);
                    if (!this.hasFocus()) {
                        this._setArmedCell(-1, -1);
                    }
                    this.repaintCell(n, n2);
                }
                this.firePropertyChange(PROPERTY_SELECTED_COLOR, color, color2);
                Object var10_9 = null;
                this.unfreezeRepaints();
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                this.unfreezeRepaints();
                throw throwable;
            }
        }
    }

    int __getSelectedColumn() {
        return this._selectedColumn;
    }

    int __getSelectedRow() {
        return this._selectedRow;
    }

    void __setSelectedSlotEnabled(boolean bl) {
        this._enableSlot = bl;
    }

    void __setSelectedSlot(int n, int n2, boolean bl) {
        if (!this._enableSlot) {
            return;
        }
        int n3 = this._selectedSlotColumn;
        int n4 = this._selectedSlotRow;
        if (n3 != n || n4 != n2) {
            this._selectedSlotColumn = n;
            this._selectedSlotRow = n2;
            if (n3 != -1 && n4 != -1) {
                this.repaintCell(n3, n4);
            }
            if (this._selectedSlotColumn != -1 && this._selectedSlotRow != -1) {
                this.repaintCell(this._selectedSlotColumn, this._selectedSlotRow);
            }
            if (bl) {
                this.firePropertyChange("slotChanged", null, null);
            }
        }
    }

    int __getSelectedSlotColumn() {
        return this._selectedSlotColumn;
    }

    int __getSelectedSlotRow() {
        return this._selectedSlotRow;
    }

    boolean __replaceSelectedSlotColor(Color color) {
        int n = this.__getSelectedSlotColumn();
        int n2 = this.__getSelectedSlotRow();
        if (n != -1 && n2 != -1) {
            this.getModel().setData(n, n2, color);
            this.__setSelectedColor(n, n2);
            return true;
        }
        return false;
    }

    void __setColorNames(TwoDModel twoDModel) {
        this._colorNames = twoDModel;
    }

    TwoDModel __getColorNames() {
        return this._colorNames;
    }

    private static Painter _getDefaultCellPainter() {
        if (_sDefaultPainter == null) {
            _sDefaultPainter = new GridCellPainter();
        }
        return _sDefaultPainter;
    }

    private static Border _getColorGridBorder(int n) {
        Border border = _BORDER[n];
        if (border == null) {
            border = n == 1 ? BorderFactory.createEmptyBorder(0, 1, 0, 1) : new BorderAdapter(new ColorGridBorderPainter());
            ColorGrid._BORDER[n] = border;
        }
        return border;
    }

    private static GridToolTipManager _getToolTipManager() {
        if (_sToolTipManager == null) {
            _sToolTipManager = new ToolTip();
        }
        return _sToolTipManager;
    }

    private static CellInputHandler _getGridInputHandler() {
        if (_sGridInputHandler == null) {
            _sGridInputHandler = new ColorGridInputHandler();
        }
        return _sGridInputHandler;
    }

    private static GridKeyHandler _getGridKeyHandler() {
        if (_sGridKeyHandler == null) {
            _sGridKeyHandler = new ColorGridKeyHandler();
        }
        return _sGridKeyHandler;
    }

    private void _setArmedCell(int n, int n2) {
        int n3 = this._armedColumn;
        int n4 = this._armedRow;
        if (n3 != n || n4 != n2) {
            this._armedColumn = n;
            this._armedRow = n2;
            if (n3 != -1 && n4 != -1) {
                this._paintCell(n3, n4);
            }
            if (this._armedColumn != -1 && this._armedRow != -1) {
                this._paintCell(this._armedColumn, this._armedRow);
            }
        }
    }

    private int _getArmedColumn() {
        return this._armedColumn;
    }

    private int _getArmedRow() {
        return this._armedRow;
    }

    private void _paintCell(int n, int n2) {
        Rectangle rectangle = this.getCellBounds(n, n2, n, n2);
        rectangle.setLocation(this.convertInteriorToOuter(rectangle.x, rectangle.y));
        --rectangle.x;
        --rectangle.y;
        rectangle.width += 2;
        rectangle.height += 2;
        this.paintImmediately(rectangle);
    }

    private String _colorToString(int n, int n2, Color color, boolean bl) {
        Object object;
        Object object2;
        int n3;
        TwoDModel twoDModel = this.__getColorNames();
        if (twoDModel != null) {
            n3 = twoDModel.getColumnCount();
            int n4 = twoDModel.getRowCount();
            if (n < n3 && n2 < n4 && (object2 = twoDModel.getData(n, n2)) instanceof String && ((String)(object = object2.toString())).length() > 0) {
                return object;
            }
        }
        if (this.isCustomGrid() && color == null) {
            color = _DEFAULT_CUSTOM_COLOR;
        }
        n3 = this.getToolTipMode();
        Locale locale = LocaleUtils.getDefaultableLocale((Component)this);
        if (color != null && n3 == 1) {
            return ColorUtils.colorToHTML(color).toUpperCase(locale);
        }
        object2 = bl ? _ACCESSIBLE_BUNDLE : _RESOURCE_BUNDLE;
        object = ResourceBundle.getBundle((String)object2, locale);
        if (color == null) {
            return ((ResourceBundle)object).getString(_KEY_NO_COLOR);
        }
        String string = ((ResourceBundle)object).getString(_KEY_TOOLTIP);
        Object[] objectArray = new Object[]{IntegerUtils.getInteger((int)color.getRed()), IntegerUtils.getInteger((int)color.getGreen()), IntegerUtils.getInteger((int)color.getBlue())};
        return MessageFormat.format(string, objectArray);
    }

    private class Access
    extends Grid.AccessibleGrid {
        private Access() {
        }

        public String getAccessibleName(int n, int n2, Object object) {
            return ColorGrid.this.getAccessibleName(n, n2, (Color)object);
        }
    }

    private class ColorAppearanceManager
    extends AbstractAppearanceManager {
        private Appearance _appearance;

        private ColorAppearanceManager() {
        }

        public Appearance getCellPaintingAppearance(int n, int n2) {
            if (this._appearance == null) {
                this._appearance = new Appearance();
            }
            int n3 = ColorGrid.this.__getSelectedColumn();
            int n4 = ColorGrid.this.__getSelectedRow();
            Color color = (Color)ColorGrid.this.getModel().getData(n, n2);
            if (ColorGrid.this.isCustomGrid() && color == null) {
                color = _DEFAULT_CUSTOM_COLOR;
            }
            if (n == n3 && n2 == n4) {
                if (color == null) {
                    color = Color.white;
                }
                this._appearance.setBackground(Color.white);
                this._appearance.setForeground(color);
            } else {
                this._appearance.setForeground(null);
                this._appearance.setBackground(color);
            }
            if (ColorGrid.this.isCustomGrid()) {
                int n5 = 0;
                int n6 = ColorGrid.this._getArmedColumn();
                int n7 = ColorGrid.this._getArmedRow();
                if (n == n6 && n2 == n7) {
                    ++n5;
                }
                int n8 = ColorGrid.this.__getSelectedSlotColumn();
                int n9 = ColorGrid.this.__getSelectedSlotRow();
                if (n == n8 && n2 == n9) {
                    n5 += 2;
                }
                this._appearance.setBorderPainter(this._getBorderPainter(n5));
            }
            return this._appearance;
        }

        private BorderPainter _getBorderPainter(int n) {
            BorderPainter borderPainter = _CELL_BORDER[n];
            if (borderPainter == null) {
                _CELL_BORDER[n] = borderPainter = new CustomCellBorderPainter((n & 1) != 0, (n & 2) != 0);
            }
            return borderPainter;
        }

        private class CustomCellBorderPainter
        extends AbstractBorderPainter {
            private boolean _armed;
            private boolean _selectedSlot;

            public CustomCellBorderPainter(boolean bl, boolean bl2) {
                this._armed = bl;
                this._selectedSlot = bl2;
            }

            protected boolean isBorderTransparent(PaintContext paintContext) {
                return true;
            }

            protected void paintBorder(PaintContext paintContext, Graphics graphics, int n, int n2, int n3, int n4) {
                Color color = graphics.getColor();
                int n5 = n + n3 - 1;
                int n6 = n2 + n4 - 1;
                if (this._armed) {
                    graphics.setColor(Color.black);
                    graphics.drawLine(n + 2, n2, n + 4, n2);
                    graphics.drawLine(n + 7, n2, n + 10, n2);
                    graphics.drawLine(n + 13, n2, n + 15, n2);
                    graphics.drawLine(n + 2, n6, n + 4, n6);
                    graphics.drawLine(n + 7, n6, n + 10, n6);
                    graphics.drawLine(n + 13, n6, n + 15, n6);
                }
                n += 2;
                n2 += 2;
                n6 -= 2;
                Color color2 = paintContext.getPaintBackground();
                Color color3 = Color.black;
                if ((paintContext.getPaintState() & 1) != 0) {
                    color3 = paintContext.getPaintUIDefaults().getColor(LookAndFeel.CONTROL_SHADOW);
                }
                if (this._selectedSlot) {
                    graphics.setColor(color3);
                    graphics.drawLine(n, n2, n5, n2);
                    graphics.drawLine(n, n2, n, n6);
                    graphics.setColor(color2);
                    graphics.drawLine(n + 1, n6, n5, n6);
                } else {
                    graphics.setColor(color3);
                    graphics.drawLine(n, n6, n5, n6);
                    graphics.drawLine(n5, n2, n5, n6);
                    graphics.setColor(color2);
                    graphics.drawLine(n, n2, n5 - 1, n2);
                }
                graphics.setColor(color);
            }

            protected ImmInsets getOwnInsets(PaintContext paintContext) {
                return this._selectedSlot ? this._getInsets(0) : this._getInsets(1);
            }

            protected ImmInsets getOwnFillInsets(PaintContext paintContext) {
                return this._getInsets(2);
            }

            private ImmInsets _getInsets(int n) {
                ImmInsets immInsets = _CELL_INSET[n];
                if (immInsets == null) {
                    switch (n) {
                        case 0: {
                            immInsets = new ImmInsets(3, 3, 3, 0);
                            break;
                        }
                        case 1: {
                            immInsets = new ImmInsets(3, 2, 3, 1);
                            break;
                        }
                        case 2: {
                            immInsets = new ImmInsets(2, 2, 2, 0);
                        }
                    }
                    _CELL_INSET[n] = immInsets;
                }
                return immInsets;
            }
        }
    }

    private static class DefaultColorPalette
    extends ArrayTwoDModel {
        private int _paletteType;

        public DefaultColorPalette(int n, Color[][] colorArray) {
            super(colorArray);
            this._paletteType = n;
        }

        public int getPaletteType() {
            return this._paletteType;
        }
    }

    private static class ColorGridInputHandler
    extends CellInputHandler {
        private ColorGridInputHandler() {
        }

        public void mouseEntered(MouseEvent mouseEvent, Grid grid, int n, int n2) {
            grid.requestFocus(n, n2, null);
            ((ColorGrid)grid)._setArmedCell(n, n2);
            mouseEvent.consume();
        }

        public void mouseExited(MouseEvent mouseEvent, Grid grid, int n, int n2) {
            ColorGrid colorGrid = (ColorGrid)grid;
            int n3 = mouseEvent.getModifiers();
            if ((n3 & 0x10) == 0 && (n3 & 8) == 0 && (n3 & 4) == 0) {
                int n4 = -1;
                int n5 = -1;
                if (colorGrid.isCustomGrid()) {
                    n4 = colorGrid.__getSelectedSlotColumn();
                    n5 = colorGrid.__getSelectedSlotRow();
                }
                if (n4 == -1 || n5 == -1) {
                    n4 = colorGrid.__getSelectedColumn();
                    n5 = colorGrid.__getSelectedRow();
                }
                if (n4 == -1 || n5 == -1) {
                    n4 = colorGrid.getNextVisibleColumn(-1);
                    n5 = colorGrid.getNextVisibleRow(-1);
                }
                colorGrid.requestFocus(n4, n5, null);
                mouseEvent.consume();
            }
            if (!grid.hasFocus()) {
                colorGrid._setArmedCell(-1, -1);
            }
        }

        public void mousePressed(MouseEvent mouseEvent, Grid grid, int n, int n2) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                super.mousePressed(mouseEvent, grid, n, n2);
                ((ColorGrid)grid).__setSelectedColor(n, n2);
                ((ColorGrid)grid).__setSelectedSlot(n, n2, true);
                mouseEvent.consume();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent, Grid grid, int n, int n2) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                int n3 = mouseEvent.getX();
                int n4 = mouseEvent.getY();
                Point point = grid.convertOuterToCanvas(n3, n4);
                point.x += grid.getColumnPosition(n);
                point.y += grid.getRowPosition(n2);
                n = grid.getColumnAt(point.x);
                n2 = grid.getRowAt(point.y);
                if (n != -1 && n2 != -1) {
                    ((ColorGrid)grid).__setSelectedColor(n, n2);
                    ((ColorGrid)grid).__setSelectedSlot(n, n2, true);
                    mouseEvent.consume();
                }
            }
        }

        public void keyPressed(KeyEvent keyEvent, Grid grid, int n, int n2) {
            if (keyEvent.getModifiers() == 0 && keyEvent.getKeyCode() == 32) {
                ((ColorGrid)grid).__setSelectedColor(n, n2);
                ((ColorGrid)grid).__setSelectedSlot(n, n2, true);
                keyEvent.consume();
            }
        }

        public void focusGained(AWTEvent aWTEvent, Grid grid, int n, int n2) {
            ((ColorGrid)grid)._setArmedCell(n, n2);
        }

        public void focusLost(AWTEvent aWTEvent, Grid grid, int n, int n2) {
            ((ColorGrid)grid)._setArmedCell(-1, -1);
        }
    }

    private static class ColorGridKeyHandler
    extends StandardGridKeyHandler {
        private ColorGridKeyHandler() {
        }

        protected Cell enter(Grid grid, Cell cell, KeyEvent keyEvent, boolean bl) {
            return cell;
        }
    }

    private static class ToolTip
    implements GridToolTipManager {
        private ToolTip() {
        }

        public String getCellToolTipValue(Grid grid, int n, int n2) {
            Color color = (Color)grid.getModel().getData(n, n2);
            String string = ((ColorGrid)grid)._colorToString(n, n2, color, false);
            return string;
        }
    }

    private static class ColorGridBorderPainter
    extends AbstractBorderPainter {
        private static final ImmInsets _INSET = new ImmInsets(1, 1, 1, 1);

        private ColorGridBorderPainter() {
        }

        protected boolean isBorderTransparent(PaintContext paintContext) {
            return false;
        }

        protected ImmInsets getOwnInsets(PaintContext paintContext) {
            return _INSET;
        }

        protected void paintBorder(PaintContext paintContext, Graphics graphics, int n, int n2, int n3, int n4) {
            Color color = graphics.getColor();
            int n5 = n2 + n4 - 1;
            int n6 = n + n3 - 1;
            if ((paintContext.getPaintState() & 1) != 0) {
                graphics.setColor(paintContext.getPaintUIDefaults().getColor(LookAndFeel.CONTROL_SHADOW));
            } else {
                graphics.setColor(Color.black);
            }
            graphics.drawLine(n, n2, n, n5 - 1);
            graphics.drawLine(n + 1, n2, n6 - 1, n2);
            graphics.setColor(Color.white);
            graphics.drawLine(n6, n2, n6, n5);
            graphics.drawLine(n, n5, n6 - 1, n5);
            graphics.setColor(color);
        }
    }

    private static class GridCellPainter
    extends ProxyPainter {
        public GridCellPainter() {
            super(NullPainter.getPainter());
        }

        public Painter getPainter(Grid grid, int n, int n2) {
            ColorGrid colorGrid = (ColorGrid)grid;
            if (n == colorGrid.__getSelectedColumn() && n2 == colorGrid.__getSelectedRow()) {
                return ColorPickerUtils.getSelectedColorPainter();
            }
            return super.getPainter(grid, n, n2);
        }
    }
}

