/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.chooser.color;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.image.ImageFilter;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.BorderFactory;
import javax.swing.DefaultButtonModel;
import javax.swing.FocusManager;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JToggleButton;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.plaf.UIResource;
import oracle.bali.ewt.chooser.color.ColorChoiceListener;
import oracle.bali.ewt.chooser.color.ColorGrid;
import oracle.bali.ewt.chooser.color.ColorPalettePane;
import oracle.bali.ewt.chooser.color.ColorPickerPane;
import oracle.bali.ewt.chooser.color.ColorPickerUtils;
import oracle.bali.ewt.chooser.color.CustomColorPane;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.model.ArrayTwoDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.statusBar.StatusBar;
import oracle.bali.ewt.util.FocusUtils;
import oracle.bali.ewt.util.MenuUtils;
import oracle.bali.ewt.util.WindowUtils;
import oracle.bali.share.nls.LocaleUtils;
import oracle.bali.share.util.IntegerUtils;

public class ColorChoice
extends JButton {
    public static final int RGB_TOOLTIP = 0;
    public static final int RGB_HEX_TOOLTIP = 1;
    public static final String PROPERTY_COLOR_PALETTE = "customColorPalette";
    public static final String PROPERTY_CUSTOM_COLOR_NAMES = "customColorNames";
    public static final String PROPERTY_SELECTED_COLOR = "selectedColor";
    public static final String PROPERTY_DEFAULT_SELECTED = "defaultSelected";
    public static final String PROPERTY_AUTOMATIC_SELECTED = "automaticSelected";
    public static final String PROPERTY_POPUP_VISIBLE = "popupVisible";
    private static final String _ACCESS_RESOURCE_FILE = "oracle.bali.ewt.resource.AccessibilityBundle";
    private static final String _KEY_ACCESS_NAME = "COLORCHOICE.ACCESSIBLE_NAME";
    private static final String _KEY_FULL_ACCESS_NAME = "COLORCHOICE.FULL_ACCESSIBLE_NAME";
    private static final String _KEY_COLOR_VALUE = "COLORPALETTE.TOOLTIP";
    private static final String _KEY_NO_COLOR = "COLORPALETTE.NO_COLOR";
    private static final String _IMAGE_NO_COLOR = "images/trans.gif";
    private static final String _IMAGE_AUTO = "images/auto.gif";
    private static final String _IMAGE_DEFAULT = "images/color.gif";
    private static final long _VISIBLE_MILLIS = 400L;
    private static final int _BOTTOM = 0;
    private static final int _TOP = 1;
    private static final int _RIGHT = 2;
    private static final int _LEFT = 3;
    private static boolean _sShowCustomColorPane = false;
    private static Image _sDefaultImage;
    private static Color _sDefaultColorToChange;
    private static ImageIcon _sAutomaticIcon;
    private static ImageIcon _sDisabledAutomaticIcon;
    private static ImageIcon _sTransparentIcon;
    private static ImageIcon _sDisabledTransparentIcon;
    private Image _image;
    private Color _colorToChange;
    private ImageFilter _filter;
    private ColorPalettePane _colorPalettePane;
    private ColorPickerPane _colorPickerPane;
    private ColorPopup _colorPopup;
    private boolean _customDialogVisible;
    private long _popMillis;
    private ColorChoiceListener _listener;
    static /* synthetic */ Class class$oracle$bali$ewt$chooser$color$ColorChoice;

    public ColorChoice() {
        this._init(null, null, null, null);
    }

    public ColorChoice(String string) {
        this._init(string, null, null, null);
    }

    public ColorChoice(Icon icon) {
        this._init(null, icon, null, null);
    }

    public ColorChoice(String string, TwoDModel twoDModel, Color color) {
        this._init(string, null, twoDModel, color);
    }

    public ColorChoice(Icon icon, TwoDModel twoDModel, Color color) {
        this._init(null, icon, twoDModel, color);
    }

    public static boolean isColorInPalette(TwoDModel twoDModel, Color color) {
        if (twoDModel == null) {
            return false;
        }
        if (color == null) {
            return true;
        }
        int n = twoDModel.getColumnCount();
        int n2 = twoDModel.getRowCount();
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                if (color.equals(twoDModel.getData(n3, n4))) {
                    return true;
                }
                ++n4;
            }
            ++n3;
        }
        return false;
    }

    public static final void setCustomColorPaneSupported(boolean bl) {
        _sShowCustomColorPane = bl;
    }

    public static final boolean isCustomColorPaneSupported() {
        return _sShowCustomColorPane;
    }

    public void setImage(Image image, Color color) {
        if (this._image != image) {
            if (image == null) {
                image = ColorChoice._getDefaultColorImage();
                color = _sDefaultColorToChange;
            }
            this._image = image;
            this._filter = null;
            this._colorToChange = color;
            this._updateButtonIcon();
        }
    }

    public Image getImage() {
        return this._image;
    }

    public Color getColorToChange() {
        return this._colorToChange;
    }

    public void setDefaultAllowed(boolean bl) {
        this._colorPickerPane.setDefaultAllowed(bl);
    }

    public boolean isDefaultAllowed() {
        return this._colorPickerPane.isDefaultAllowed();
    }

    public void setDefaultColor(Color color) {
        this._colorPickerPane.setDefaultColor(color);
    }

    public Color getDefaultColor() {
        return this._colorPickerPane.getDefaultColor();
    }

    public void setDefaultSelected(boolean bl) {
        this._colorPickerPane.setDefaultSelected(bl);
    }

    public boolean isDefaultSelected() {
        return this._colorPickerPane.isDefaultSelected();
    }

    public void setAutomaticAllowed(boolean bl) {
        this._colorPickerPane.setAutomaticAllowed(bl);
    }

    public boolean isAutomaticAllowed() {
        return this._colorPickerPane.isAutomaticAllowed();
    }

    public void setAutomaticSelected(boolean bl) {
        this._colorPickerPane.setAutomaticSelected(bl);
    }

    public boolean isAutomaticSelected() {
        return this._colorPickerPane.isAutomaticSelected();
    }

    public void setTransparentAllowed(boolean bl) {
        if (bl != this.isTransparentAllowed()) {
            this._colorPickerPane.setTransparentAllowed(bl);
            if (this.getSelectedColor() == null && !this.isAutomaticSelected()) {
                this._updateButtonIcon();
            }
        }
    }

    public boolean isTransparentAllowed() {
        return this._colorPickerPane.isTransparentAllowed();
    }

    public void setTransparentLabelUsed(boolean bl) {
        this._colorPickerPane.setTransparentLabelUsed(bl);
    }

    public boolean isTransparentLabelUsed() {
        return this._colorPickerPane.isTransparentLabelUsed();
    }

    public void setEditAllowed(boolean bl) {
        this._colorPickerPane.setCustomizationAllowed(bl);
    }

    public boolean isEditAllowed() {
        return this._colorPickerPane.isCustomizationAllowed();
    }

    public void setColorPalette(TwoDModel twoDModel) {
        this._colorPickerPane.setColorPalette(twoDModel);
        this.setEnabled(this.isEnabled());
    }

    public TwoDModel getColorPalette() {
        return this._colorPickerPane.getColorPalette();
    }

    public void setCustomColorPalette(TwoDModel twoDModel) {
        this._colorPickerPane.setCustomColorPalette(twoDModel);
    }

    public TwoDModel getCustomColorPalette() {
        return this._colorPickerPane.getCustomColorPalette();
    }

    public void setCustomColorNames(TwoDModel twoDModel) {
        this._colorPickerPane.setCustomColorNames(twoDModel);
    }

    public TwoDModel getCustomColorNames() {
        return this._colorPickerPane.getCustomColorNames();
    }

    public String getCustomColorName() {
        return this._colorPickerPane.getCustomColorName();
    }

    public void setSelectedColor(Color color) {
        this._colorPickerPane.setSelectedColor(color);
    }

    public Color getSelectedColor() {
        return this._colorPickerPane.getSelectedColor();
    }

    public void setSelectedColor(Color color, boolean bl) {
        this.setSelectedColor(color);
    }

    public boolean isCustomColorSelected() {
        ColorGrid colorGrid = this._colorPickerPane.__getCustomGrid();
        return colorGrid.isVisible() && colorGrid.__getSelectedColumn() != -1 && colorGrid.__getSelectedRow() != -1;
    }

    public Color getClosestColor(Color color) {
        return this.getClosestColor(color, false);
    }

    public Color getClosestColor(Color color, boolean bl) {
        TwoDModel twoDModel = bl ? this.getCustomColorPalette() : this.getColorPalette();
        return ColorGrid.getClosestColor(twoDModel, color);
    }

    public void setToolTipMode(int n) {
        this._colorPickerPane.setToolTipMode(n);
    }

    public int getToolTipMode() {
        return this._colorPickerPane.getToolTipMode();
    }

    public ColorPalettePane getColorPalettePane() {
        if (this._colorPalettePane == null) {
            this._colorPalettePane = new ColorPalettePane();
            this._initPane(this._colorPalettePane);
        }
        return this._colorPalettePane;
    }

    public CustomColorPane getCustomColorPane() {
        return this._colorPickerPane.getCustomColorPane();
    }

    public boolean isPopupVisible() {
        return this.__isDropDownVisible() || this._customDialogVisible;
    }

    public void dispose() {
        if (this._colorPickerPane == null) {
            return;
        }
        if (this._colorPopup != null) {
            this.__setDropDownVisible(false);
            this._colorPopup = null;
        }
        if (this._colorPalettePane != null) {
            this._colorPalettePane.dispose();
            this._colorPalettePane = null;
        }
        this._colorPickerPane.dispose();
        this._colorPickerPane = null;
        this._listener.unregisterColorChoice();
        this._listener = null;
    }

    public void setIcon(Icon icon) {
        super.setIcon(icon);
        this._clearImage();
    }

    public void setDisabledIcon(Icon icon) {
        super.setDisabledIcon(icon);
        this._clearImage();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl && this._isDropDownAllowed());
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        if (this._colorPickerPane != null) {
            this._colorPickerPane.setLocale(locale);
        }
    }

    public void removeNotify() {
        this.__setDropDownVisible(false);
        super.removeNotify();
    }

    public void updateUI() {
        super.updateUI();
        if (this.getMargin() == null || this.getMargin() instanceof UIResource) {
            this.setMargin(ColorPickerUtils.getDefaultButtonMargin());
        }
        if (this._colorPopup != null) {
            SwingUtilities.updateComponentTreeUI(this._colorPopup);
        } else if (this._colorPickerPane != null) {
            SwingUtilities.updateComponentTreeUI(this._colorPickerPane);
        }
        if (this._colorPalettePane != null) {
            SwingUtilities.updateComponentTreeUI(this._colorPalettePane);
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new Access();
        }
        return this.accessibleContext;
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (PROPERTY_SELECTED_COLOR.equals(string)) {
            this._updateButtonIcon();
        }
        super.firePropertyChange(string, object, object2);
    }

    boolean __isDropDownVisible() {
        return this._colorPopup != null && this._colorPopup.isVisible();
    }

    void __setDropDownVisible(boolean bl) {
        if (bl != this.__isDropDownVisible()) {
            if (bl) {
                this._getColorPopup().showPopup();
            } else {
                this._getColorPopup().hidePopup();
            }
        }
    }

    boolean __canDispatchMouseEventToGrid() {
        long l = System.currentTimeMillis();
        return l - this._popMillis >= 400L;
    }

    void __setCustomDialogVisible(boolean bl) {
        this._customDialogVisible = bl;
    }

    ColorPickerPane __getColorPickerPane() {
        return this._colorPickerPane;
    }

    void __fireAccessibleEvent(String string) {
        if (this.accessibleContext != null) {
            this._colorPopup.fireAccessibleEvent(string);
        }
    }

    private static Image _getDefaultColorImage() {
        if (_sDefaultImage == null) {
            _sDefaultImage = ImageUtils.getImageResource(class$oracle$bali$ewt$chooser$color$ColorChoice == null ? (class$oracle$bali$ewt$chooser$color$ColorChoice = ColorChoice.class$("oracle.bali.ewt.chooser.color.ColorChoice")) : class$oracle$bali$ewt$chooser$color$ColorChoice, _IMAGE_DEFAULT);
            _sDefaultColorToChange = new Color(100, 100, 100);
        }
        return _sDefaultImage;
    }

    private void _init(String string, Icon icon, TwoDModel twoDModel, Color color) {
        this._listener = new ColorChoiceListener(this);
        this._colorPickerPane = new ColorChoicePane(twoDModel, color);
        this.setText(string);
        if (string == null) {
            if (icon != null) {
                this.setIcon(icon);
            } else {
                Image image = ColorChoice._getDefaultColorImage();
                this.setImage(image, _sDefaultColorToChange);
            }
        }
        this.setModel(new Model());
    }

    private void _initPane(ColorPalettePane colorPalettePane) {
        boolean bl;
        colorPalettePane.setLocale(LocaleUtils.getDefaultableLocale((Component)this));
        colorPalettePane.setColorPalette(this.getColorPalette());
        TwoDModel twoDModel = this.getCustomColorPalette();
        boolean bl2 = bl = twoDModel != null && twoDModel.getColumnCount() > 0 && twoDModel.getRowCount() > 0;
        if (bl) {
            int n = twoDModel.getColumnCount();
            int n2 = twoDModel.getRowCount();
            ArrayTwoDModel arrayTwoDModel = new ArrayTwoDModel(n, n2);
            int n3 = 0;
            while (n3 < n) {
                int n4 = 0;
                while (n4 < n2) {
                    arrayTwoDModel.setData(n3, n4, twoDModel.getData(n3, n4));
                    ++n4;
                }
                ++n3;
            }
            colorPalettePane.setCustomColorPalette(arrayTwoDModel);
        }
        colorPalettePane.setCustomColorsVisible(bl);
        colorPalettePane.setEditVisible(bl);
        if (!this.isDefaultSelected()) {
            try {
                colorPalettePane.setSelectedColor(this.getSelectedColor(), this.isCustomColorSelected());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                colorPalettePane.setSelectedColor(null);
            }
        } else {
            colorPalettePane.setSelectedColor(null);
        }
    }

    private void _updateButtonIcon() {
        Image image = this.getImage();
        if (image == null) {
            return;
        }
        if (this.isAutomaticSelected()) {
            this._setAutomaticIcons();
            return;
        }
        Color color = this.getSelectedColor();
        if (color == null && this.isTransparentAllowed()) {
            this._setTransparentIcons();
        } else {
            this._setSelectedColorIcon(image, color);
        }
    }

    private void _setAutomaticIcons() {
        if (_sAutomaticIcon == null) {
            Image image = ImageUtils.getImageResource(class$oracle$bali$ewt$chooser$color$ColorChoice == null ? (class$oracle$bali$ewt$chooser$color$ColorChoice = ColorChoice.class$("oracle.bali.ewt.chooser.color.ColorChoice")) : class$oracle$bali$ewt$chooser$color$ColorChoice, _IMAGE_AUTO);
            _sAutomaticIcon = new ImageIcon(image);
            _sDisabledAutomaticIcon = new ImageIcon(ImageUtils.createDisabledImage(image));
        }
        super.setIcon(_sAutomaticIcon);
        super.setDisabledIcon(_sDisabledAutomaticIcon);
    }

    private void _setTransparentIcons() {
        if (_sTransparentIcon == null) {
            Image image = ImageUtils.getImageResource(class$oracle$bali$ewt$chooser$color$ColorChoice == null ? (class$oracle$bali$ewt$chooser$color$ColorChoice = ColorChoice.class$("oracle.bali.ewt.chooser.color.ColorChoice")) : class$oracle$bali$ewt$chooser$color$ColorChoice, _IMAGE_NO_COLOR);
            _sTransparentIcon = new ImageIcon(image);
            _sDisabledTransparentIcon = new ImageIcon(ImageUtils.createDisabledImage(image));
        }
        super.setIcon(_sTransparentIcon);
        super.setDisabledIcon(_sDisabledTransparentIcon);
    }

    private void _setSelectedColorIcon(Image image, Color color) {
        if (this._filter == null) {
            this._filter = ColorPickerUtils.createColorFilter(this.getColorToChange());
        }
        image = ColorPickerUtils.createFilteredImage(image, this._filter, color);
        ImageIcon imageIcon = new ImageIcon(image);
        super.setIcon(imageIcon);
        image = ImageUtils.createDisabledImage(image);
        super.setDisabledIcon(new ImageIcon(image));
    }

    private void _clearImage() {
        this._image = null;
        this._colorToChange = null;
        this._filter = null;
    }

    private ColorPopup _getColorPopup() {
        if (this._colorPopup == null) {
            this._colorPopup = new ColorPopup();
        }
        return this._colorPopup;
    }

    private boolean _isDropDownAllowed() {
        TwoDModel twoDModel = this.getColorPalette();
        return twoDModel != null && twoDModel.getColumnCount() > 0 && twoDModel.getRowCount() > 0;
    }

    private String _getAccessTranslatedString(String string) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(_ACCESS_RESOURCE_FILE, LocaleUtils.getDefaultableLocale((Component)this));
        return resourceBundle.getString(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class Access
    extends JButton.AccessibleJButton {
        private MessageFormat _format;

        private Access() {
            super(ColorChoice.this);
        }

        public String getAccessibleName() {
            Object[] objectArray;
            String string = super.getAccessibleName();
            if (string == null || "".equals(string)) {
                string = ColorChoice.this._getAccessTranslatedString(ColorChoice._KEY_ACCESS_NAME);
            } else {
                this._applyPattern(ColorChoice.this._getAccessTranslatedString(ColorChoice._KEY_FULL_ACCESS_NAME));
                objectArray = new Object[]{string};
                string = this._format.format(objectArray);
            }
            objectArray = ColorChoice.this.getSelectedColor();
            String string2 = null;
            if (objectArray != null) {
                this._applyPattern(ColorChoice.this._getAccessTranslatedString(ColorChoice._KEY_COLOR_VALUE));
                Object[] objectArray2 = new Object[]{IntegerUtils.getInteger((int)objectArray.getRed()), IntegerUtils.getInteger((int)objectArray.getGreen()), IntegerUtils.getInteger((int)objectArray.getBlue())};
                string2 = this._format.format(objectArray2);
            } else {
                string2 = ColorChoice.this._getAccessTranslatedString(ColorChoice._KEY_NO_COLOR);
            }
            string = string == null ? string2 : string + " " + string2;
            return string;
        }

        public int getAccessibleChildrenCount() {
            return 1;
        }

        public Accessible getAccessibleChild(int n) {
            if (n == 0) {
                return ColorChoice.this._getColorPopup();
            }
            return null;
        }

        public boolean doAccessibleAction(int n) {
            if (n == 0) {
                ColorChoice.this.__setDropDownVisible(!ColorChoice.this.__isDropDownVisible());
                return true;
            }
            return false;
        }

        private void _applyPattern(String string) {
            if (this._format == null) {
                this._format = new MessageFormat(string);
            } else {
                this._format.applyPattern(string);
            }
        }
    }

    private class ColorPopup
    extends JPopupMenu {
        private FocusManager _prevFocusManager;
        private Component _prevFocussed;
        private Window _nonFocusableWindow;
        private StatusBar _statusBar;
        private AccessibleJLabel _statusBarLabel;

        public ColorPopup() {
            Border border = LineBorder.createBlackLineBorder();
            Border border2 = BorderFactory.createEmptyBorder(3, 3, 3, 3);
            this.setBorder(new CompoundBorder(border, border2));
            FocusUtils.setFocusable(this, false);
            this.setLayout(new BorderLayout());
            this.add(ColorChoice.this._colorPickerPane);
        }

        public void showPopup() {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Rectangle rectangle;
            Object object5;
            Rectangle rectangle2 = ColorChoice.this.getBounds();
            rectangle2.setLocation(ColorChoice.this.getLocationOnScreen());
            Rectangle rectangle3 = null;
            GraphicsDevice[] graphicsDeviceArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
            int n = 0;
            while (n < graphicsDeviceArray.length) {
                object5 = graphicsDeviceArray[n].getDefaultConfiguration();
                rectangle = ((GraphicsConfiguration)object5).getBounds();
                object4 = MenuUtils.getScreenInsets((GraphicsConfiguration)object5);
                rectangle.x += ((Insets)object4).left;
                rectangle.y += ((Insets)object4).top;
                rectangle.width -= ((Insets)object4).left + ((Insets)object4).right;
                rectangle.height -= ((Insets)object4).top + ((Insets)object4).bottom;
                if (rectangle.contains(rectangle2.x, rectangle2.y)) {
                    rectangle3 = rectangle;
                    break;
                }
                if (rectangle.intersects(rectangle2)) {
                    rectangle3 = rectangle;
                }
                ++n;
            }
            if (rectangle3 == null) {
                return;
            }
            object5 = this.getPreferredSize();
            rectangle = new Rectangle(rectangle3);
            if (!FocusUtils.areNewFocusAPIsAvailable()) {
                object3 = object4 = ColorChoice.this.getParent();
                while (object4 != null) {
                    object3 = ((Component)object4).getParent();
                    if (object4 instanceof JRootPane && (object3 instanceof Window || object3 instanceof Applet)) {
                        object2 = ((Component)object4).getBounds();
                        ((Rectangle)object2).setLocation(((Component)object4).getLocationOnScreen());
                        SwingUtilities.computeIntersection(((Rectangle)object2).x, ((Rectangle)object2).y, ((Rectangle)object2).width, ((Rectangle)object2).height, rectangle3);
                        break;
                    }
                    object4 = object3;
                }
            }
            if (rectangle3.intersects(rectangle2)) {
                SwingUtilities.computeIntersection(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, rectangle2);
            }
            object4 = this._calculateBounds(rectangle3, rectangle2);
            object3 = object4[0];
            object2 = object4[1];
            Object object6 = object4[2];
            Object object7 = object4[3];
            if (!FocusUtils.areNewFocusAPIsAvailable()) {
                object = this.getMinimumSize();
                if (!(((Dimension)object3).width >= ((Dimension)object).width && ((Dimension)object3).height >= ((Dimension)object).height || ((Dimension)object2).width >= ((Dimension)object).width && ((Dimension)object2).height >= ((Dimension)object).height || ((Dimension)object6).width >= ((Dimension)object).width && ((Dimension)object6).height >= ((Dimension)object).height || ((Dimension)object7).width >= ((Dimension)object).width && ((Dimension)object7).height >= ((Dimension)object).height)) {
                    object4 = this._calculateBounds(rectangle, rectangle2);
                    object3 = object4[0];
                    object2 = object4[1];
                    object6 = object4[2];
                    object7 = object4[3];
                }
            }
            object = new int[4];
            object[0] = Math.min(((Dimension)object3).width, ((Dimension)object5).width) * Math.min(((Dimension)object3).height, ((Dimension)object5).height);
            object[1] = Math.min(((Dimension)object2).width, ((Dimension)object5).width) * Math.min(((Dimension)object2).height, ((Dimension)object5).height);
            object[2] = Math.min(((Dimension)object6).width, ((Dimension)object5).width) * Math.min(((Dimension)object6).height, ((Dimension)object5).height);
            object[3] = Math.min(((Dimension)object7).width, ((Dimension)object5).width) * Math.min(((Dimension)object7).height, ((Dimension)object5).height);
            Object object8 = object[0];
            int n2 = 0;
            int n3 = 1;
            while (n3 < ((Object)object).length) {
                if (object8 < object[n3]) {
                    object8 = object[n3];
                    n2 = n3;
                }
                ++n3;
            }
            switch (n2) {
                case 0: {
                    ((Dimension)object5).width = Math.min(((Dimension)object5).width, ((Dimension)object3).width);
                    ((Dimension)object5).height = Math.min(((Dimension)object5).height, ((Dimension)object3).height);
                    break;
                }
                case 1: {
                    ((Dimension)object5).width = Math.min(((Dimension)object5).width, ((Dimension)object2).width);
                    ((Dimension)object5).height = Math.min(((Dimension)object5).height, ((Dimension)object2).height);
                    break;
                }
                case 2: {
                    ((Dimension)object5).width = Math.min(((Dimension)object5).width, ((Dimension)object6).width);
                    ((Dimension)object5).height = Math.min(((Dimension)object5).height, ((Dimension)object6).height);
                    break;
                }
                case 3: {
                    ((Dimension)object5).width = Math.min(((Dimension)object5).width, ((Dimension)object7).width);
                    ((Dimension)object5).height = Math.min(((Dimension)object5).height, ((Dimension)object7).height);
                }
            }
            this.setPreferredSize((Dimension)object5);
            int n4 = 0;
            int n5 = 0;
            if (n2 == 0 || n2 == 1) {
                int n6;
                int n7 = Math.min(((Dimension)object6).width + rectangle2.width, ((Dimension)object5).width);
                n4 = n7 >= (n6 = Math.min(((Dimension)object7).width + rectangle2.width, ((Dimension)object5).width)) ? n7 - ((Dimension)object5).width : rectangle2.width - n6;
                n5 += n2 == 0 ? rectangle2.height : -((Dimension)object5).height;
            } else {
                n4 += n2 == 2 ? rectangle2.width : -((Dimension)object5).width;
                int n8 = Math.min(((Dimension)object3).height + rectangle2.height, ((Dimension)object5).height);
                int n9 = Math.min(((Dimension)object2).height + rectangle2.height, ((Dimension)object5).height);
                n5 = n8 >= n9 ? n8 - ((Dimension)object5).height : rectangle2.height - n9;
            }
            this.show(ColorChoice.this, n4, n5);
        }

        public void hidePopup() {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            int n = 0;
            while (n < menuElementArray.length) {
                if (menuElementArray[n] == this) {
                    menuSelectionManager.clearSelectedPath();
                    break;
                }
                ++n;
            }
            ColorChoice.this.requestFocus();
        }

        public void fireAccessibleEvent(String string) {
            if (this._statusBarLabel != null) {
                this._statusBarLabel.setText(string);
            }
        }

        public Color getBackground() {
            if (ColorChoice.this != null) {
                return ColorChoice.this.getBackground();
            }
            return super.getBackground();
        }

        public void setVisible(boolean bl) {
            boolean bl2 = this.isVisible();
            if (bl != bl2) {
                Object object;
                super.setVisible(bl);
                Component component = null;
                if (this.isVisible()) {
                    ColorChoice.this._popMillis = System.currentTimeMillis();
                    if (FocusUtils.areNewFocusAPIsAvailable()) {
                        if (!FocusUtils.isFocusable(ColorChoice.this)) {
                            List list;
                            object = SwingUtilities.getRoot(ColorChoice.this);
                            if (object != null) {
                                this._prevFocussed = SwingUtilities.findFocusOwner((Component)object);
                            }
                            if ((list = ColorChoice.this._colorPickerPane.__getFocusCycle()).size() > 0) {
                                component = (Component)list.get(0);
                            }
                        }
                        if ((object = WindowUtils.getWindow(this)) != null && !FocusUtils.getFocusableWindowState((Window)object)) {
                            FocusUtils.setFocusableWindowState((Window)object, true);
                            this._nonFocusableWindow = object;
                        }
                        FocusUtils.setFocusTraversalKeysEnabled(ColorChoice.this, false);
                        FocusUtils.setFocusTraversalKeysEnabled(this, false, true);
                    } else {
                        this._prevFocusManager = FocusManager.getCurrentManager();
                        FocusManager.disableSwingFocusManager();
                    }
                } else {
                    ColorChoice.this._popMillis = 0L;
                    this.setPreferredSize(null);
                    if (FocusUtils.areNewFocusAPIsAvailable()) {
                        if (this._prevFocussed != null) {
                            component = this._prevFocussed;
                            this._prevFocussed = null;
                        }
                        if (this._nonFocusableWindow != null) {
                            FocusUtils.setFocusableWindowState(this._nonFocusableWindow, false);
                            this._nonFocusableWindow = null;
                        }
                        FocusUtils.setFocusTraversalKeysEnabled(ColorChoice.this, true);
                    } else {
                        FocusManager.setCurrentManager(this._prevFocusManager);
                    }
                    object = ToolTipManager.sharedInstance();
                    boolean bl3 = ((ToolTipManager)object).isEnabled();
                    ((ToolTipManager)object).setEnabled(false);
                    ((ToolTipManager)object).setEnabled(bl3);
                }
                if (component != null) {
                    object = component;
                    SwingUtilities.invokeLater(new Runnable((Component)object){
                        private final /* synthetic */ Component val$temp;
                        {
                            this.val$temp = component;
                        }

                        public void run() {
                            this.val$temp.requestFocus();
                        }
                    });
                }
                if (!ColorChoice.this._customDialogVisible) {
                    ColorChoice.this.firePropertyChange(ColorChoice.PROPERTY_POPUP_VISIBLE, !bl, bl);
                }
                ColorChoice.this.repaint();
            }
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = super.getAccessibleContext();
                this.accessibleContext.setAccessibleParent(ColorChoice.this);
                this._statusBar = new StatusBar();
                this._statusBarLabel = new AccessibleJLabel();
                this._statusBar.add(this._statusBarLabel);
                this._statusBar.setPreferredSize(new Dimension(0, 0));
                this.add((Component)this._statusBar, "South");
            }
            return this.accessibleContext;
        }

        private Dimension[] _calculateBounds(Rectangle rectangle, Rectangle rectangle2) {
            Dimension[] dimensionArray = new Dimension[]{new Dimension(rectangle.width, rectangle.y + rectangle.height - (rectangle2.y + rectangle2.height)), new Dimension(rectangle.width, rectangle2.y - rectangle.y), new Dimension(rectangle.x + rectangle.width - (rectangle2.x + rectangle2.width), rectangle.height), new Dimension(rectangle2.x - rectangle.x, rectangle.height)};
            return dimensionArray;
        }

        private class AccessibleJLabel
        extends JLabel {
            private AccessibleJLabel() {
            }

            public void setText(String string) {
                String string2 = this.getText();
                super.setText(string);
                if (this.accessibleContext != null) {
                    this.accessibleContext.firePropertyChange("AccessibleName", string2, string);
                }
            }
        }
    }

    private class ColorChoicePane
    extends ColorPickerPane {
        public ColorChoicePane(TwoDModel twoDModel, Color color) {
            super(twoDModel, null, color);
            ColorChoice.this._listener.registerColorGrid(this.__getStandardGrid());
            ColorChoice.this._listener.registerColorGrid(this.__getCustomGrid());
            ColorChoice.this._listener.registerColorPickerPane(this);
            FocusUtils.setFocusable(this, false);
        }

        public void dispose() {
            ColorGrid colorGrid;
            ColorGrid colorGrid2 = this.__getStandardGrid();
            if (colorGrid2 != null) {
                ColorChoice.this._listener.unregisterColorGrid(colorGrid2);
            }
            if ((colorGrid = this.__getCustomGrid()) != null) {
                ColorChoice.this._listener.unregisterColorGrid(colorGrid);
            }
            ColorChoice.this._listener.unregisterColorPickerPane(this);
            super.dispose();
        }

        JLabel __createColorLabel() {
            return null;
        }

        void __registerButtonActions(JToggleButton jToggleButton) {
            super.__registerButtonActions(jToggleButton);
            ColorChoice.this._listener.registerToggleButtons(jToggleButton);
        }

        void __unregisterButtonActions(JToggleButton jToggleButton) {
            super.__unregisterButtonActions(jToggleButton);
            ColorChoice.this._listener.unregisterToggleButtons(jToggleButton);
        }

        void __registerCustomButtonActions(JButton jButton) {
            super.__registerCustomButtonActions(jButton);
            ColorChoice.this._listener.registerCustomButton(jButton);
        }

        void __unregisterCustomButtonActions(JButton jButton) {
            super.__unregisterCustomButtonActions(jButton);
            ColorChoice.this._listener.unregisterCustomButton(jButton);
        }

        CustomColorPane __getCustomColorPane() {
            return ColorChoice.this.getCustomColorPane();
        }

        void __launchCustomColorPane() {
            if (ColorChoice.isCustomColorPaneSupported()) {
                super.__launchCustomColorPane();
            } else {
                ColorPalettePane colorPalettePane = ColorChoice.this.getColorPalettePane();
                ColorChoice.this._initPane(colorPalettePane);
                ColorChoice.this._listener.showColorPalettePane(colorPalettePane);
            }
        }

        boolean __showPaneInDialog(CustomColorPane customColorPane) {
            return ColorChoice.this._listener.showCustomColorPane(customColorPane);
        }
    }

    private class Model
    extends DefaultButtonModel {
        private Model() {
        }

        public boolean isArmed() {
            return ColorChoice.this.__isDropDownVisible();
        }

        public boolean isPressed() {
            return ColorChoice.this.__isDropDownVisible();
        }
    }
}

