/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.chooser.color;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.chooser.color.BaseColorEditor;
import oracle.bali.ewt.graphics.ColorUtils;
import oracle.bali.ewt.spinBox.NumericSpinBox;
import oracle.bali.share.nls.StringUtils;

class CMYComponent
extends BaseColorEditor {
    private static final String _KEY_CYAN = "COLORCHOOSER.CYAN_LABEL";
    private static final String _KEY_MAGENTA = "COLORCHOOSER.MAGENTA_LABEL";
    private static final String _KEY_YELLOW = "COLORCHOOSER.YELLOW_LABEL";
    private static final String _KEY_CYAN_DESC = "COLORCHOOSER.CYAN_DESCRIPTION";
    private static final String _KEY_MAGENTA_DESC = "COLORCHOOSER.MAGENTA_DESCRIPTION";
    private static final String _KEY_YELLOW_DESC = "COLORCHOOSER.YELLOW_DESCRIPTION";
    private static final String _CYAN_NAME = "Cyan_Box";
    private static final String _MAGENTA_NAME = "Magenta_Box";
    private static final String _YELLOW_NAME = "Yellow_Box";
    private boolean _ignoreEvents;
    private JLabel _cyanLabel;
    private JLabel _magentaLabel;
    private JLabel _yellowLabel;
    private NumericSpinBox _cyan;
    private NumericSpinBox _magenta;
    private NumericSpinBox _yellow;

    public CMYComponent() {
        Insets insets;
        Listener listener = new Listener();
        this._cyan = new NumericSpinBox(0, 100);
        this._cyan.addChangeListener(listener);
        this._cyan.setName(_CYAN_NAME);
        this._magenta = new NumericSpinBox(0, 100);
        this._magenta.addChangeListener(listener);
        this._magenta.setName(_MAGENTA_NAME);
        this._yellow = new NumericSpinBox(0, 100);
        this._yellow.addChangeListener(listener);
        this._yellow.setName(_YELLOW_NAME);
        this._cyanLabel = new JLabel(" ");
        this._cyanLabel.setLabelFor(this._cyan);
        this._magentaLabel = new JLabel(" ");
        this._magentaLabel.setLabelFor(this._magenta);
        this._yellowLabel = new JLabel(" ");
        this._yellowLabel.setLabelFor(this._yellow);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = insets = new Insets(0, 0, 3, 12);
        this.setLayout(gridBagLayout);
        gridBagConstraints.gridwidth = -1;
        gridBagLayout.setConstraints(this._cyanLabel, gridBagConstraints);
        this.add(this._cyanLabel);
        gridBagConstraints.gridwidth = 0;
        insets.right = 0;
        gridBagLayout.setConstraints(this._cyan, gridBagConstraints);
        this.add(this._cyan);
        gridBagConstraints.gridwidth = -1;
        insets.right = 12;
        gridBagLayout.setConstraints(this._magentaLabel, gridBagConstraints);
        this.add(this._magentaLabel);
        gridBagConstraints.gridwidth = 0;
        insets.right = 0;
        gridBagLayout.setConstraints(this._magenta, gridBagConstraints);
        this.add(this._magenta);
        gridBagConstraints.gridwidth = -1;
        insets.bottom = 0;
        insets.right = 12;
        gridBagLayout.setConstraints(this._yellowLabel, gridBagConstraints);
        this.add(this._yellowLabel);
        gridBagConstraints.gridwidth = 0;
        insets.right = 0;
        gridBagLayout.setConstraints(this._yellow, gridBagConstraints);
        this.add(this._yellow);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this._cyanLabel.setEnabled(bl);
        this._magentaLabel.setEnabled(bl);
        this._yellowLabel.setEnabled(bl);
        this._cyan.setEnabled(bl);
        this._magenta.setEnabled(bl);
        this._yellow.setEnabled(bl);
    }

    protected void updateLabels(Locale locale) {
        String string = BaseColorEditor.__getTranslatedString(locale, _KEY_CYAN);
        this._cyanLabel.setText(StringUtils.stripMnemonic((String)string));
        this._cyanLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        string = BaseColorEditor.__getTranslatedString(locale, _KEY_MAGENTA);
        this._magentaLabel.setText(StringUtils.stripMnemonic((String)string));
        this._magentaLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        string = BaseColorEditor.__getTranslatedString(locale, _KEY_YELLOW);
        this._yellowLabel.setText(StringUtils.stripMnemonic((String)string));
        this._yellowLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)string));
    }

    protected void updateAccessibleNames() {
        String string = this.__getTranslatedString(_KEY_CYAN_DESC);
        this._cyan.getAccessibleContext().setAccessibleName(string);
        string = this.__getTranslatedString(_KEY_YELLOW_DESC);
        this._yellow.getAccessibleContext().setAccessibleName(string);
        string = this.__getTranslatedString(_KEY_MAGENTA_DESC);
        this._magenta.getAccessibleContext().setAccessibleName(string);
    }

    protected void colorChanged(Color color) {
        this._ignoreEvents = true;
        int[] nArray = ColorUtils.colorToCMY(color);
        this._cyan.setIntValue(nArray[0]);
        this._magenta.setIntValue(nArray[1]);
        this._yellow.setIntValue(nArray[2]);
        this._ignoreEvents = false;
    }

    private void _updateColor() {
        int n = this._cyan.getIntValue();
        int n2 = this._magenta.getIntValue();
        int n3 = this._yellow.getIntValue();
        this.storeColor(ColorUtils.cmyToColor(n, n2, n3));
    }

    private class Listener
    implements ChangeListener {
        private Listener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (!CMYComponent.this._ignoreEvents) {
                CMYComponent.this._updateColor();
            }
        }
    }
}

