/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.button;

import java.awt.LayoutManager;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.button.ArrowKeyHandler;
import oracle.bali.ewt.layout.EqualColumnLayout;
import oracle.bali.ewt.layout.EqualLayout;
import oracle.bali.ewt.layout.EqualRowLayout;

public class ButtonBar
extends LWComponent
implements Accessible {
    private int _alignment;
    private int _orientation;

    public ButtonBar() {
        this(0);
    }

    public ButtonBar(int n) {
        this._setOrientation(n);
        ArrowKeyHandler.registerActions(this);
    }

    public void setOrientation(int n) {
        if (this._orientation != n) {
            int n2 = this._orientation;
            this._setOrientation(n);
            this._setAlignment(this.getAlignment());
            this.firePropertyChange("orientation", n2, n);
            this.revalidate();
        }
    }

    public int getOrientation() {
        return this._orientation;
    }

    public int getAlignment() {
        return this._alignment;
    }

    public void setAlignment(int n) {
        if (n != this._alignment) {
            int n2 = this._alignment;
            this._alignment = n;
            this._setAlignment(n);
            this.firePropertyChange("alignment", n2, n);
            this.revalidate();
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleTitledPane();
        }
        return this.accessibleContext;
    }

    private void _setAlignment(int n) {
        LayoutManager layoutManager = this.getLayout();
        if (layoutManager instanceof EqualLayout) {
            switch (n) {
                case 1: 
                case 2: 
                case 10: {
                    n = 0;
                    break;
                }
                case 3: 
                case 4: 
                case 11: {
                    n = 2;
                    break;
                }
                case 0: {
                    n = 1;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            ((EqualLayout)layoutManager).setLayoutAlignment(n);
        }
    }

    private void _setOrientation(int n) {
        this._orientation = n;
        switch (n) {
            case 0: {
                this.setLayout(new EqualRowLayout(5));
                break;
            }
            case 1: {
                this.setLayout(new EqualColumnLayout(3));
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    protected class AccessibleTitledPane
    extends JComponent.AccessibleJComponent {
        protected AccessibleTitledPane() {
            super(ButtonBar.this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PANEL;
        }
    }
}

