/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert.ext;

import java.io.IOException;
import java.io.InputStream;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.cert.PKIX;
import oracle.security.crypto.cert.X509Extension;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class SubjectKeyIDExtension
extends X509Extension {
    private static final ASN1ObjectID TYPE = PKIX.id_ce_subjectKeyIdentifier;
    private byte[] keyID = null;

    public SubjectKeyIDExtension() {
        super(TYPE);
    }

    public SubjectKeyIDExtension(byte[] keyID) {
        this(keyID, false);
    }

    public SubjectKeyIDExtension(byte[] keyID, boolean critical) {
        super(TYPE, critical);
        this.keyID = keyID;
        this.setValue(this.toByteArray());
    }

    public SubjectKeyIDExtension(InputStream is) throws IOException {
        super(is);
    }

    public byte[] getSubjectKeyID() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.keyID;
    }

    private byte[] toByteArray() {
        byte[] b = Utils.toBytes((Streamable)new ASN1OctetString(this.keyID));
        this.isDecoded = true;
        return b;
    }

    private void decodeValue() {
        try {
            this.keyID = ASN1OctetString.inputValue((InputStream)new UnsyncByteArrayInputStream(this.getValue()));
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex.toString());
        }
        this.isDecoded = true;
    }

    public String toString() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return "subjectKeyIDExtension {oid = " + TYPE.toStringCompact() + ", critical = " + this.getCritical() + ", value = " + (this.getSubjectKeyID() != null ? Utils.toHexString((byte[])this.getSubjectKeyID()) : "") + "}";
    }
}

