/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert.ext;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.cert.PKIX;
import oracle.security.crypto.cert.X509Extension;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class DeltaCRLIndicatorExtension
extends X509Extension {
    private static final ASN1ObjectID TYPE = PKIX.id_ce_deltaCRLIndicator;
    private BigInteger baseCRLNumber = null;

    public DeltaCRLIndicatorExtension() {
        super(TYPE);
    }

    public DeltaCRLIndicatorExtension(BigInteger baseCRLNumber) {
        this(baseCRLNumber, true);
    }

    private DeltaCRLIndicatorExtension(BigInteger baseCRLNumber, boolean critical) {
        super(TYPE, critical);
        this.baseCRLNumber = baseCRLNumber;
        this.setValue(this.toByteArray());
    }

    public DeltaCRLIndicatorExtension(InputStream is) throws IOException {
        super(is);
    }

    public BigInteger getBaseCRLNumber() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.baseCRLNumber;
    }

    private byte[] toByteArray() {
        byte[] b = Utils.toBytes((Streamable)new ASN1Integer(this.baseCRLNumber));
        this.isDecoded = true;
        return b;
    }

    private void decodeValue() {
        try {
            this.baseCRLNumber = ASN1Integer.inputValue((InputStream)new UnsyncByteArrayInputStream(this.getValue()));
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex.toString());
        }
        this.isDecoded = true;
    }

    public String toString() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return "deltaCRLIndicatorExtension {oid = " + TYPE.toStringCompact() + ", critical = " + this.getCritical() + ", value = " + this.getBaseCRLNumber() + "}";
    }
}

