/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Enumeration;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1ConstructedInputStream;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1GenericConstructed;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.cert.PKCS12Safe;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.core.AuthenticationException;
import oracle.security.crypto.core.CipherException;
import oracle.security.crypto.core.DigestInfo;
import oracle.security.crypto.core.HMAC;
import oracle.security.crypto.core.MessageDigest;
import oracle.security.crypto.core.PKCS12PBE;
import oracle.security.crypto.core.RandomBitsSource;
import oracle.security.crypto.core.SymmetricKey;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.StreamableOutputException;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class PKCS12
implements ASN1Object,
Externalizable {
    private Vector authSafes = new Vector();
    private String passwd;
    private AlgorithmIdentifier macAlg;
    private byte[] macBytes;
    private byte[] macSalt;
    private BigInteger iterations;
    private ASN1Sequence contents;

    public PKCS12() {
    }

    public PKCS12(InputStream is) throws IOException {
        this();
        this.input(is);
    }

    public PKCS12(String passwd, InputStream is) throws IOException {
        this();
        this.setPassword(passwd);
        this.input(is);
    }

    public PKCS12(String passwd, ASN1Sequence s) throws IOException {
        this();
        this.setPassword(passwd);
        this.input(s);
    }

    void reset() {
        this.contents = null;
        this.macBytes = null;
    }

    public void input(InputStream is) throws IOException {
        this.reset();
        ASN1SequenceInputStream pfxIS = new ASN1SequenceInputStream(is);
        int ver = ASN1Integer.inputValue((InputStream)pfxIS).intValue();
        if (ver != 3) {
            throw new ASN1FormatException("Expecting version 3, got version " + ver);
        }
        ASN1SequenceInputStream ciIS = new ASN1SequenceInputStream((InputStream)pfxIS);
        ASN1ObjectID ct = new ASN1ObjectID((InputStream)ciIS);
        if (ct.equals(ASN1Utils.pkcsID, 7, 1)) {
            if (ciIS.hasMoreData()) {
                ASN1ConstructedInputStream cIS = new ASN1ConstructedInputStream((InputStream)ciIS, 0);
                byte[] data = ASN1OctetString.inputValue((InputStream)cIS);
                cIS.terminate();
                ASN1SequenceInputStream asIS = new ASN1SequenceInputStream((InputStream)new UnsyncByteArrayInputStream(data));
                while (asIS.hasMoreData()) {
                    this.addAuthSafe(new PKCS12Safe(this, new ASN1Sequence((InputStream)asIS)));
                }
                asIS.terminate();
            }
        } else {
            if (ct.equals(ASN1Utils.pkcsID, 7, 2)) {
                throw new ASN1FormatException("Public-key integrity mode not supported");
            }
            throw new ASN1FormatException("Invalid integrity mode OID " + ct.toStringCompact());
        }
        ciIS.terminate();
        if (pfxIS.hasMoreData()) {
            ASN1SequenceInputStream mdIS = new ASN1SequenceInputStream((InputStream)pfxIS);
            DigestInfo mac = new DigestInfo((InputStream)mdIS);
            this.macAlg = mac.getDigestAlgID();
            this.macBytes = mac.getDigest();
            this.macSalt = ASN1OctetString.inputValue((InputStream)mdIS);
            this.iterations = mdIS.hasMoreData() ? ASN1Integer.inputValue((InputStream)mdIS) : BigInteger.valueOf(1L);
            mdIS.terminate();
        } else {
            this.macAlg = null;
            this.macBytes = null;
            this.macSalt = null;
            this.iterations = null;
        }
        pfxIS.terminate();
    }

    public void input(ASN1Sequence s) throws IOException {
        this.input(Utils.toStream((Streamable)s));
    }

    public void output(OutputStream os) throws IOException {
        this.toASN1().output(os);
    }

    private ASN1Sequence toASN1() {
        if (this.contents != null) {
            return this.contents;
        }
        ASN1Sequence s = new ASN1Sequence();
        s.addElement((ASN1Object)new ASN1Integer(3L));
        ASN1Sequence ci = new ASN1Sequence();
        ci.addElement((ASN1Object)new ASN1ObjectID(ASN1Utils.pkcsID, 7, 1));
        byte[] data = Utils.toBytes((Streamable)new ASN1Sequence(this.authSafes));
        ci.addElement((ASN1Object)new ASN1GenericConstructed((ASN1Object)new ASN1OctetString(data), 0));
        s.addElement((ASN1Object)ci);
        ASN1Sequence md = new ASN1Sequence();
        if (this.macBytes == null) {
            try {
                this.computeMAC();
            }
            catch (AlgorithmIdentifierException ex) {
                throw new StreamableOutputException(ex.toString());
            }
            catch (CipherException ex) {
                throw new StreamableOutputException(ex.toString());
            }
        }
        md.addElement((ASN1Object)new DigestInfo(this.macAlg, this.macBytes));
        md.addElement((ASN1Object)new ASN1OctetString(this.macSalt));
        if (this.iterations.intValue() != 1) {
            md.addElement((ASN1Object)new ASN1Integer(this.iterations));
        }
        s.addElement((ASN1Object)md);
        this.contents = s;
        return s;
    }

    private void computeMAC() throws AlgorithmIdentifierException, CipherException {
        if (this.macAlg == null) {
            this.macAlg = AlgID.sha_1;
        }
        if (this.macSalt == null) {
            this.macSalt = RandomBitsSource.getDefault().randomBytes(new byte[8]);
        }
        if (this.iterations == null) {
            this.iterations = BigInteger.valueOf(1024L);
        }
        byte[] macKey = PKCS12PBE.createPKCS12MacKey((AlgorithmIdentifier)this.macAlg, (String)this.passwd, (byte[])this.macSalt, (int)this.iterations.intValue(), (int)MessageDigest.getInstance((AlgorithmIdentifier)this.macAlg).getDigestLength());
        HMAC hmac = new HMAC(this.macAlg, new SymmetricKey(macKey));
        byte[] data = Utils.toBytes((Streamable)new ASN1Sequence(this.authSafes));
        this.macBytes = hmac.computeDigest(data);
    }

    public int length() {
        return this.toASN1().length();
    }

    public String getPassword() {
        return this.passwd;
    }

    public void setPassword(String pw) {
        if (this.passwd != null && !this.passwd.equals(pw)) {
            this.reset();
        }
        this.passwd = pw;
    }

    public Vector getAuthSafes() {
        return this.authSafes;
    }

    public void setAuthSafes(Vector authSafes) {
        this.authSafes = authSafes;
        this.reset();
    }

    public void addAuthSafe(PKCS12Safe s) {
        this.authSafes.addElement(s);
        this.reset();
    }

    public boolean verify() throws AuthenticationException {
        try {
            if (this.macBytes == null) {
                this.computeMAC();
            }
            byte[] macKey = PKCS12PBE.createPKCS12MacKey((AlgorithmIdentifier)this.macAlg, (String)this.passwd, (byte[])this.macSalt, (int)this.iterations.intValue(), (int)MessageDigest.getInstance((AlgorithmIdentifier)this.macAlg).getDigestLength());
            HMAC hmac = new HMAC(this.macAlg, new SymmetricKey(macKey));
            byte[] data = Utils.toBytes((Streamable)new ASN1Sequence(this.authSafes));
            byte[] newMacBytes = hmac.computeDigest(data);
            return Utils.areEqual((byte[])this.macBytes, (byte[])newMacBytes);
        }
        catch (CipherException ex) {
            throw new AuthenticationException(ex.toString());
        }
        catch (AlgorithmIdentifierException ex) {
            throw new AuthenticationException(ex.toString());
        }
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append('{');
        boolean mid = false;
        Enumeration e = this.authSafes.elements();
        while (e.hasMoreElements()) {
            if (mid) {
                s.append(", ");
            }
            s.append('[');
            s.append(e.nextElement().toString());
            s.append(']');
            mid = true;
        }
        s.append('}');
        return s.toString();
    }

    public void writeExternal(ObjectOutput os) throws IOException {
        os.writeObject(Utils.toBytes((Streamable)this));
    }

    public void readExternal(ObjectInput is) throws IOException, ClassNotFoundException {
        byte[] data;
        try {
            data = (byte[])is.readObject();
        }
        catch (ClassCastException ex) {
            throw new InvalidInputException((Exception)ex);
        }
        this.input((InputStream)new UnsyncByteArrayInputStream(data));
    }
}

