/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.textui;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.ResourceBundle;
import javax.security.auth.x500.X500Principal;
import oracle.security.pki.OraclePKIDebug;
import oracle.security.pki.OraclePKIRSAPrivateKey;
import oracle.security.pki.OraclePKIX509CertImpl;
import oracle.security.pki.OracleSecretStore;
import oracle.security.pki.OracleSecretStoreException;
import oracle.security.pki.OracleWallet;
import oracle.security.pki.internal.OraclePKIX509CertHelper;
import oracle.security.pki.internal.OraclePKIX509CertReqHelper;
import oracle.security.pki.textui.OraclePKIGenFunc;
import oracle.security.wallet.NZException;
import oracle.security.wallet.NZWallet;

public class OracleWalletTextUI {
    static String b;
    static ResourceBundle c;

    public static void display(String[] stringArray) {
        KeyStore keyStore;
        OracleWallet oracleWallet;
        boolean bl = true;
        boolean bl2 = false;
        String string = null;
        String string2 = null;
        boolean bl3 = false;
        if (stringArray.length == 0) {
            System.out.println(b);
            return;
        }
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-wallet")) {
                    string = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-summary")) {
                    bl = true;
                    ++i;
                    continue;
                }
                if (stringArray[i].equals("-complete")) {
                    bl2 = true;
                    ++i;
                    continue;
                }
                if (stringArray[i].equals("-pwd")) {
                    string2 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-obpwd")) {
                    bl3 = true;
                    continue;
                }
                System.out.println(c.getString("INVALID_COMMAND_ERROR") + stringArray[i]);
                System.out.println(b);
                return;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(b);
            return;
        }
        try {
            oracleWallet = OraclePKIGenFunc.openAWallet(string, string2, bl3);
            keyStore = oracleWallet.getKeyStore();
            OracleSecretStore oracleSecretStore = oracleWallet.getSecretStore();
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            if (OraclePKIDebug.getDebugFlag()) {
                exception.printStackTrace();
            }
            return;
        }
        if (bl) {
            try {
                Object object;
                Object object2;
                System.out.println("Requested Certificates: ");
                Enumeration<String> enumeration = keyStore.aliases();
                while (enumeration.hasMoreElements()) {
                    object2 = enumeration.nextElement();
                    if (!keyStore.isKeyEntry((String)object2) || keyStore.getCertificate((String)object2) != null || (object = ((OraclePKIRSAPrivateKey)keyStore.getKey((String)object2, null)).getCertificateRequest()) == null) continue;
                    System.out.println("Subject:        " + object.getSubject());
                }
                System.out.println("User Certificates:");
                enumeration = keyStore.aliases();
                while (enumeration.hasMoreElements()) {
                    object2 = enumeration.nextElement();
                    if (!keyStore.isKeyEntry((String)object2) || (object = (OraclePKIX509CertImpl)keyStore.getCertificate((String)object2)) == null) continue;
                    System.out.println("Subject:        " + ((OraclePKIX509CertImpl)object).getSubjectDN());
                }
                object2 = oracleWallet.getSecretStore().internalAliases();
                if (object2.hasMoreElements()) {
                    System.out.println(c.getString("ENTRIES_LIST"));
                }
                while (object2.hasMoreElements()) {
                    System.out.println(object2.nextElement());
                }
                System.out.println("Trusted Certificates: ");
                enumeration = keyStore.aliases();
                while (enumeration.hasMoreElements()) {
                    object = enumeration.nextElement();
                    if (!keyStore.isCertificateEntry((String)object)) continue;
                    OraclePKIX509CertImpl oraclePKIX509CertImpl = (OraclePKIX509CertImpl)keyStore.getCertificate((String)object);
                    System.out.println("Subject:        " + oraclePKIX509CertImpl.getSubjectDN());
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.out.println(c.getString("GEN_UNKNOWN_ERROR") + string);
                return;
            }
        }
    }

    public static void command(String[] stringArray) {
        if (stringArray.length == 0) {
            System.out.println(b);
            return;
        }
        if (stringArray[0].equals("help")) {
            System.out.println(b);
            return;
        }
        if (stringArray[0].equals("display")) {
            String[] stringArray2 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray2, 0, stringArray2.length);
            OracleWalletTextUI.display(stringArray2);
        } else if (stringArray[0].equals("create")) {
            String[] stringArray3 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray3, 0, stringArray3.length);
            OracleWalletTextUI.create(stringArray3);
        } else if (stringArray[0].equals("remove")) {
            String[] stringArray4 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray4, 0, stringArray4.length);
            OracleWalletTextUI.remove(stringArray4);
        } else if (stringArray[0].equals("test_api")) {
            String[] stringArray5 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray5, 0, stringArray5.length);
            OracleWalletTextUI.test_api(stringArray5);
        } else if (stringArray[0].equals("change_pwd")) {
            String[] stringArray6 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray6, 0, stringArray6.length);
            OracleWalletTextUI.change_pwd(stringArray6);
        } else if (stringArray[0].equals("add")) {
            String[] stringArray7 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray7, 0, stringArray7.length);
            OracleWalletTextUI.add(stringArray7);
        } else if (stringArray[0].equals("p11_add")) {
            String[] stringArray8 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray8, 0, stringArray8.length);
            OracleWalletTextUI.p11_add(stringArray8);
        } else if (stringArray[0].equals("p11_verify")) {
            String[] stringArray9 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray9, 0, stringArray9.length);
            OracleWalletTextUI.p11_verify(stringArray9);
        } else if (stringArray[0].equals("export")) {
            String[] stringArray10 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray10, 0, stringArray10.length);
            OracleWalletTextUI.export(stringArray10);
        } else if (stringArray[0].equals("export_trust_chain")) {
            String[] stringArray11 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray11, 0, stringArray11.length);
            OracleWalletTextUI.exportchain(stringArray11);
        } else if (stringArray[0].equals("is_tcert_used_in_chain")) {
            String[] stringArray12 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray12, 0, stringArray12.length);
            OracleWalletTextUI.isTrustedCertUsedInChain(stringArray12);
        } else if (stringArray[0].equals("get_certreq_info")) {
            String[] stringArray13 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray13, 0, stringArray13.length);
            OracleWalletTextUI.getCertreqInfo(stringArray13);
        } else if (stringArray[0].equals("get_certreq_count_dns")) {
            String[] stringArray14 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray14, 0, stringArray14.length);
            OracleWalletTextUI.getCertReqCountDNs(stringArray14);
        } else if (stringArray[0].equals("validate_pswd")) {
            String[] stringArray15 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray15, 0, stringArray15.length);
            OracleWalletTextUI.isValidPassword(stringArray15);
        } else if (stringArray[0].equals("get_keysizes")) {
            String[] stringArray16 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray16, 0, stringArray16.length);
            OracleWalletTextUI.getKeysizes(stringArray16);
        } else if (stringArray[0].equals("jks_to_pkcs12")) {
            String[] stringArray17 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray17, 0, stringArray17.length);
            OracleWalletTextUI.migrateJKStoPKCS12(stringArray17);
        } else if (stringArray[0].equals("list_aliases")) {
            String[] stringArray18 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray18, 0, stringArray18.length);
            OracleWalletTextUI.listAliases(stringArray18);
        } else {
            System.out.println(c.getString("INVALID_COMMAND_ERROR") + stringArray[0]);
            System.out.println(b);
            return;
        }
    }

    public static void p11_verify(String[] stringArray) {
        String string = null;
        String string2 = null;
        boolean bl = false;
        if (stringArray.length == 0) {
            System.out.println(b);
            return;
        }
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-wallet")) {
                    string = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-pwd")) {
                    string2 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-obpwd")) {
                    bl = true;
                    continue;
                }
                System.out.println(c.getString("INVALID_COMMAND_ERROR") + stringArray[i]);
                System.out.println(b);
                return;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(b);
            return;
        }
        char[] cArray = OraclePKIGenFunc.getPassword(string2, bl, "WALLET_PASSWORD_PROMPT");
        NZWallet nZWallet = null;
        try {
            nZWallet = NZWallet.getPersonasWithTypeOld((String)("file:" + string), (String)new String(cArray));
            nZWallet.setWRL("file:" + string);
            nZWallet.setPersonaTypes(new String(cArray));
        }
        catch (Exception exception) {
            System.out.println(c.getString("WALLET_LOAD_ERROR") + string);
            return;
        }
        try {
            nZWallet.verifyPkcs11Credentials();
        }
        catch (NZException nZException) {
            System.out.println("Error: " + nZException.getExceptionId());
        }
    }

    public static void test_bug5610097(String[] stringArray) {
        String string = "/scratch/rchahal/temp/dgoswami/wall1";
        try {
            OracleWallet oracleWallet = new OracleWallet();
            oracleWallet.createSSO();
            oracleWallet.saveAs(string);
            OracleWallet oracleWallet2 = new OracleWallet();
            oracleWallet2.open(string, null);
            OracleSecretStore oracleSecretStore = oracleWallet2.getSecretStore();
            if (oracleSecretStore != null && oracleWallet2 != null) {
                oracleSecretStore.setSecret(new String("alias"), "secret".toCharArray());
                oracleWallet2.setSecretStore(oracleSecretStore);
            }
            if (oracleWallet2 != null) {
                oracleWallet2.save();
            }
            if (oracleWallet2 != null) {
                oracleSecretStore.setSecret(new String("alias2"), "secret2".toCharArray());
                oracleWallet2.setSecretStore(oracleSecretStore);
            }
            if (oracleWallet2 != null) {
                oracleWallet2.save();
            }
            if (oracleWallet2 != null) {
                oracleWallet2.save();
            }
        }
        catch (IOException iOException) {
            System.out.println(c.getString("GEN_UNKNOWN_ERROR") + string);
            iOException.printStackTrace();
            return;
        }
        catch (OracleSecretStoreException oracleSecretStoreException) {
            oracleSecretStoreException.printStackTrace();
            return;
        }
    }

    public static void remove(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        if (stringArray.length == 0) {
            System.out.println(b);
            return;
        }
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-wallet")) {
                    string = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-dn")) {
                    string2 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-trusted_cert_all")) {
                    bl = true;
                    bl2 = false;
                    bl3 = false;
                    bl4 = false;
                    continue;
                }
                if (stringArray[i].equals("-trusted_cert")) {
                    bl = false;
                    bl2 = true;
                    bl3 = false;
                    bl4 = false;
                    continue;
                }
                if (stringArray[i].equals("-user_cert")) {
                    bl = false;
                    bl2 = false;
                    bl3 = true;
                    bl4 = false;
                    continue;
                }
                if (stringArray[i].equals("-cert_req")) {
                    bl = false;
                    bl2 = false;
                    bl3 = false;
                    bl4 = true;
                    continue;
                }
                if (stringArray[i].equals("-pwd")) {
                    string3 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-obpwd")) {
                    bl5 = true;
                    continue;
                }
                if (stringArray[i].equals("-auto_login_only")) {
                    bl6 = true;
                    continue;
                }
                System.out.println(c.getString("INVALID_COMMAND_ERROR") + stringArray[i]);
                System.out.println(b);
                return;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(b);
            return;
        }
        try {
            OracleWallet oracleWallet;
            try {
                oracleWallet = OraclePKIGenFunc.openAWallet(string, string3, bl5);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.out.println(c.getString("WALLET_LOAD_ERROR") + string);
                return;
            }
            if (oracleWallet.isAutoLoginOnly() && !bl6 || !oracleWallet.isAutoLoginOnly() && bl6) {
                System.out.println(b);
                return;
            }
            if (bl) {
                try {
                    oracleWallet.removeTrustpoints();
                }
                catch (Exception exception) {
                    System.out.println(exception.getMessage());
                    if (OraclePKIDebug.getDebugFlag()) {
                        exception.printStackTrace();
                    }
                    return;
                }
            } else if (bl2) {
                try {
                    oracleWallet.removeTrustpoint(new X500Principal(string2));
                }
                catch (Exception exception) {
                    System.out.println(exception.getMessage());
                    if (OraclePKIDebug.getDebugFlag()) {
                        exception.printStackTrace();
                    }
                    return;
                }
            } else if (bl3) {
                try {
                    oracleWallet.deleteCert(new X500Principal(string2));
                }
                catch (Exception exception) {
                    System.out.println(exception.getMessage());
                    if (OraclePKIDebug.getDebugFlag()) {
                        exception.printStackTrace();
                    }
                    return;
                }
            } else if (bl4) {
                try {
                    oracleWallet.deleteCertReq(new X500Principal(string2));
                }
                catch (Exception exception) {
                    System.out.println(exception.getMessage());
                    if (OraclePKIDebug.getDebugFlag()) {
                        exception.printStackTrace();
                    }
                    return;
                }
            } else {
                System.out.println(b);
                return;
            }
            try {
                oracleWallet.saveAs(string);
            }
            catch (IOException iOException) {
                System.out.println("Wallet save failed.");
                iOException.printStackTrace();
            }
            return;
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            return;
        }
    }

    public static void listAliases(String[] stringArray) {
        String string = null;
        String string2 = null;
        if (stringArray.length == 0) {
            System.out.println("wallet:\nlist_aliases [-wallet [wallet]] [-pwd [pwd]]\nhelp");
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-wallet")) {
                string = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-pwd")) {
                string2 = stringArray[++i];
                continue;
            }
            System.out.println("wallet:\nlist_aliases [-wallet [wallet]] [-pwd [pwd]]\nhelp");
            return;
        }
        try {
            OracleWallet oracleWallet = OraclePKIGenFunc.openAWallet(string, string2, false);
            Enumeration enumeration = oracleWallet.listAliases();
            while (enumeration.hasMoreElements()) {
                System.out.println("alias : " + enumeration.nextElement());
            }
        }
        catch (Exception exception) {
            System.out.println("Exception : " + exception);
        }
    }

    private static char[] a() {
        boolean bl;
        char[] cArray = null;
        char[] cArray2 = null;
        do {
            bl = (cArray = OraclePKIGenFunc.getPassword("ENTER_PASSWORD")).length == (cArray2 = OraclePKIGenFunc.getPassword("ENTER_PASSWORD_AGAIN")).length;
            for (int i = 0; i < cArray.length && bl; ++i) {
                bl = cArray[i] == cArray2[i];
            }
            if (bl) continue;
            System.out.println(c.getString("PASSWORD_NOT_MATCH_EERROR"));
        } while (!bl);
        return cArray;
    }

    public static void getCertreqInfo(String[] stringArray) {
        String string = null;
        String string2 = null;
        if (stringArray.length == 0) {
            System.out.println("wallet:\nget_certreq_info [-wallet [wallet]] [-pwd [pwd]]\nhelp");
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-wallet")) {
                string = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-pwd")) {
                string2 = stringArray[++i];
                continue;
            }
            System.out.println("wallet:\nget_certreq_info [-wallet [wallet]] [-pwd [pwd]]\nhelp");
            return;
        }
        try {
            OracleWallet oracleWallet = OraclePKIGenFunc.openAWallet(string, string2, false);
            String[] stringArray2 = oracleWallet.getCertReqInfo(0, 0);
            System.out.println("DN      : " + stringArray2[0]);
            System.out.println("keySize : " + stringArray2[1]);
            System.out.println("keyType : " + stringArray2[2]);
            System.out.println("alias   : " + stringArray2[3]);
        }
        catch (Exception exception) {
            System.out.println("Exception in getCertreqInfo : " + exception);
        }
    }

    public static void migrateJKStoPKCS12(String[] stringArray) {
        String string = null;
        String string2 = null;
        char[] cArray = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String[] stringArray2 = null;
        if (stringArray.length == 0) {
            System.out.println("wallet:\njks_to_pkcs12 [-wallet [wallet]] [-pwd [pwd]] [-keystore [keystore]] [-jkspwd [jkspwd]] [-aliases [alias:alias....]]\nhelp");
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-wallet")) {
                string3 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-pwd")) {
                string4 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-keystore")) {
                string = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-jkspwd")) {
                string2 = stringArray[++i];
                cArray = string2.toCharArray();
                continue;
            }
            if (stringArray[i].equals("-aliases")) {
                string5 = stringArray[++i];
                stringArray2 = string5.split(":");
                continue;
            }
            System.out.println("wallet:\njks_to_pkcs12 [-wallet [wallet]] [-pwd [pwd]] [-keystore [keystore]] [-jkspwd [jkspwd]] [-aliases [alias:alias....]]\nhelp");
            return;
        }
        try {
            OracleWallet oracleWallet = OraclePKIGenFunc.openAWallet(string3, string4, false);
            KeyStore keyStore = KeyStore.getInstance("JKS");
            FileInputStream fileInputStream = new FileInputStream(string);
            keyStore.load(fileInputStream, cArray);
            oracleWallet.migrateJKStoPKCS12(keyStore, cArray, stringArray2);
            oracleWallet.save();
            fileInputStream.close();
        }
        catch (Exception exception) {
            System.out.println("Exception : " + exception);
        }
    }

    public static void export(String[] stringArray) {
        OracleWallet oracleWallet;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        boolean bl = false;
        X500Principal x500Principal = null;
        if (stringArray.length == 0) {
            System.out.println(b);
            return;
        }
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-wallet")) {
                    string = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-dn")) {
                    string2 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-request")) {
                    string3 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-cert")) {
                    string4 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-pwd")) {
                    string5 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-obpwd")) {
                    bl = true;
                    continue;
                }
                System.out.println(c.getString("INVALID_COMMAND_ERROR") + stringArray[i]);
                System.out.println(b);
                return;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(b);
            return;
        }
        try {
            x500Principal = new X500Principal(string2);
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("Please provide : -dn [dn]");
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println("Please provide proper DN.");
            return;
        }
        try {
            oracleWallet = OraclePKIGenFunc.openAWallet(string, string5, bl);
            KeyStore keyStore = oracleWallet.getKeyStore();
        }
        catch (Exception exception) {
            System.out.println(c.getString("WALLET_LOAD_ERROR"));
            return;
        }
        if (string4 != null) {
            try {
                String string6 = oracleWallet.exportCertB64(x500Principal);
                if (string6 == null) {
                    System.out.println("Please check DN, could not found certificate with matching DN.");
                    return;
                }
                FileWriter fileWriter = new FileWriter(string4);
                fileWriter.write(string6);
                fileWriter.flush();
                InputStream inputStream = oracleWallet.exportCert(x500Principal);
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
                return;
            }
        }
        if (string3 != null) {
            try {
                String string7 = oracleWallet.exportCertReqB64(x500Principal);
                if (string7 == null) {
                    System.out.println("Please check DN, could not found certificate request with matching DN.");
                    return;
                }
                FileWriter fileWriter = new FileWriter(string3);
                fileWriter.write(string7);
                fileWriter.flush();
                InputStream inputStream = oracleWallet.exportCertReq(x500Principal);
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
                return;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void add(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        String string7 = null;
        boolean bl4 = false;
        boolean bl5 = false;
        String string8 = null;
        String string9 = null;
        BigInteger bigInteger = null;
        boolean bl6 = false;
        if (stringArray.length == 0) {
            System.out.println(b);
            return;
        }
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-wallet")) {
                    string = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-dn")) {
                    string2 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-keysize")) {
                    string3 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-validity")) {
                    string4 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-self_signed")) {
                    bl = true;
                    continue;
                }
                if (stringArray[i].equals("-request")) {
                    string5 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-cert")) {
                    string6 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-trusted_cert")) {
                    bl2 = true;
                    bl3 = false;
                    continue;
                }
                if (stringArray[i].equals("-user_cert")) {
                    bl2 = false;
                    bl3 = true;
                    continue;
                }
                if (stringArray[i].equals("-pwd")) {
                    string7 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-obpwd")) {
                    bl4 = true;
                    continue;
                }
                if (stringArray[i].equals("-auto_login_only")) {
                    bl5 = true;
                    continue;
                }
                if (stringArray[i].equals("-serial_file")) {
                    string8 = stringArray[++i];
                    bigInteger = OraclePKIGenFunc.getSerialNum(string8);
                    bigInteger = bigInteger.add(BigInteger.ONE);
                    bl6 = true;
                    continue;
                }
                if (stringArray[i].equals("-serial_num")) {
                    string9 = stringArray[++i];
                    bigInteger = new BigInteger(string9);
                    bl6 = true;
                    continue;
                }
                System.out.println(c.getString("INVALID_COMMAND_ERROR") + stringArray[i]);
                System.out.println(b);
                return;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(b);
            return;
        }
        if (bl && bl6 && bigInteger == null) {
            System.out.println("Serial number should not be null....");
            return;
        }
        try {
            OracleWallet oracleWallet;
            try {
                oracleWallet = OraclePKIGenFunc.openAWallet(string, string7, bl4);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.out.println(c.getString("WALLET_LOAD_ERROR") + string);
                return;
            }
            if (oracleWallet.isAutoLoginOnly() && !bl5 || !oracleWallet.isAutoLoginOnly() && bl5) {
                System.out.println(b);
                return;
            }
            if (bl) {
                int n = 0;
                try {
                    n = Integer.parseInt(string3);
                    if (n != 512 && n != 1024 && n != 2048 && n != 4096) {
                        throw new NumberFormatException("");
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Keysize must be 512 or 1024 or 2048 or 4096");
                    return;
                }
                int n2 = 0;
                if (bl) {
                    if (string4 == null) {
                        System.out.println("Please provide : -validity [days]");
                        return;
                    }
                    n2 = 0;
                    try {
                        n2 = Integer.parseInt(string4);
                        if (n2 <= 0) {
                            throw new NumberFormatException("");
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("Validity must be a positive integer.");
                        return;
                    }
                }
                if (!bl) return;
                try {
                    if (!bl6) {
                        oracleWallet.createSelfSigned(new X500Principal(string2), n, n2);
                    } else {
                        oracleWallet.createSelfSigned(new X500Principal(string2), n, n2, bigInteger);
                    }
                    oracleWallet.save();
                    if (string8 == null) return;
                    OraclePKIGenFunc.updateSerialNum(string8, bigInteger);
                    return;
                }
                catch (Exception exception) {
                    System.out.println(exception.getMessage());
                    if (!OraclePKIDebug.getDebugFlag()) return;
                    exception.printStackTrace();
                    return;
                }
            }
            if (string6 != null) {
                try {
                    block56: {
                        InputStream inputStream;
                        try {
                            inputStream = new URL(string6).openStream();
                        }
                        catch (MalformedURLException malformedURLException) {
                            inputStream = new FileInputStream(string6);
                        }
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        int n = inputStream.read();
                        while (n != -1) {
                            byteArrayOutputStream.write((byte)n);
                            n = inputStream.read();
                        }
                        if (bl2) {
                            try {
                                oracleWallet.importCert(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()), true);
                            }
                            catch (Exception exception) {
                                System.out.println("Could not install trusted cert at" + string6);
                                System.out.println(exception.getMessage());
                                if (OraclePKIDebug.getDebugFlag()) {
                                    exception.printStackTrace();
                                }
                                break block56;
                            }
                        }
                        if (bl3) {
                            try {
                                oracleWallet.importCert(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()), false);
                            }
                            catch (Exception exception) {
                                System.out.println("Could not install user cert at" + string6);
                                System.out.println("Please add all trusted certificates before adding the user certificate");
                            }
                        }
                    }
                    oracleWallet.saveAs(string);
                    return;
                }
                catch (IOException iOException) {
                    System.out.println("Unable to read certificate at " + string6);
                }
                return;
            }
            if (string2 != null) {
                int n = 0;
                try {
                    n = Integer.parseInt(string3);
                    if (n != 512 && n != 1024 && n != 2048 && n != 4096) {
                        throw new NumberFormatException("");
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Keysize must be 512 or 1024 or 2048 or 4096");
                    return;
                }
                try {
                    oracleWallet.addCertRequest(new X500Principal(string2), n);
                    oracleWallet.saveAs(string);
                    return;
                }
                catch (Exception exception) {
                    System.out.println(c.getString("GEN_UNKNOWN_ERROR"));
                    return;
                }
            }
            if (string6 == null) return;
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }

    public static void change_pwd(String[] stringArray) {
        char[] cArray;
        String string = null;
        String string2 = null;
        String string3 = null;
        boolean bl = false;
        boolean bl2 = false;
        if (stringArray.length == 0) {
            System.out.println(b);
            return;
        }
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-wallet")) {
                    string = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-oldpwd")) {
                    string2 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-newpwd")) {
                    string3 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-obpwd_old")) {
                    bl = true;
                    continue;
                }
                if (stringArray[i].equals("-obpwd_new")) {
                    bl2 = true;
                    continue;
                }
                System.out.println(c.getString("INVALID_COMMAND_ERROR") + stringArray[i]);
                System.out.println(b);
                return;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(b);
            return;
        }
        char[] cArray2 = OraclePKIGenFunc.getPassword(string2, bl, "WALLET_PASSWORD_PROMPT");
        if (string3 == null) {
            System.out.println("New password:");
        }
        if (!OracleWallet.isValidPassword(cArray = OraclePKIGenFunc.getPassword(string3, bl2, "WALLET_PASSWORD_PROMPT"))) {
            System.out.println("Invalid Password....");
            System.out.println("PASSWORD_POLICY : Passwords must have a minimum length of eight characters and \ncontain alphabetic characters combined with numbers or special characters.");
            return;
        }
        if (Arrays.equals(cArray2, cArray)) {
            System.out.println("Unable to change the password, old and new password should not be same.");
            return;
        }
        OracleWallet oracleWallet = new OracleWallet();
        try {
            oracleWallet.open(string, cArray2);
            oracleWallet.changePassword(cArray);
            oracleWallet.saveAs(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println(c.getString("WALLET_LOAD_ERROR") + string);
            return;
        }
    }

    public static void isTrustedCertUsedInChain(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        if (stringArray.length == 0) {
            System.out.println("wallet:\nis_tcert_used_in_chain [-wallet [wallet]] [-pwd [pwd]] [-dn [dn]]\nhelp");
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-wallet")) {
                string = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-pwd")) {
                string2 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-dn")) {
                string3 = stringArray[++i];
                continue;
            }
            System.out.println("wallet:\nis_tcert_used_in_chain [-wallet [wallet]] [-pwd [pwd]] [-dn [dn]]\nhelp");
            return;
        }
        try {
            OracleWallet oracleWallet = OraclePKIGenFunc.openAWallet(string, string2, false);
            System.out.println("Result of isTrustedCertUsedInChain = " + oracleWallet.isTrustedCertUsedInChain(new X500Principal(string3)));
        }
        catch (Exception exception) {
            System.out.println("Exception in isTrustedCertUsedInChain : " + exception);
        }
    }

    public static void create(String[] stringArray) {
        boolean bl;
        boolean bl2 = false;
        boolean bl3 = false;
        String string = null;
        String string2 = null;
        boolean bl4 = false;
        if (stringArray.length == 0) {
            System.out.println(b);
            return;
        }
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-wallet")) {
                    string = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-auto_login")) {
                    bl2 = true;
                    continue;
                }
                if (stringArray[i].equals("-auto_login_only")) {
                    bl3 = true;
                    continue;
                }
                if (stringArray[i].equals("-pwd")) {
                    if (OracleWallet.isValidPassword((string2 = stringArray[++i]).toCharArray())) continue;
                    System.out.println("Invalid password....");
                    System.out.println("PASSWORD_POLICY : Passwords must have a minimum length of eight characters and contain alphabetic characters combined with numbers or special characters.");
                    return;
                }
                if (stringArray[i].equals("-obpwd")) {
                    bl4 = true;
                    continue;
                }
                System.out.println(c.getString("INVALID_COMMAND_ERROR") + stringArray[i]);
                System.out.println(b);
                return;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(b);
            return;
        }
        if (bl2 && bl3) {
            System.out.println(b);
            return;
        }
        if (string2 != null && bl3) {
            System.out.println(b);
            return;
        }
        OracleWallet oracleWallet = new OracleWallet();
        try {
            OracleWallet oracleWallet2 = new OracleWallet();
            oracleWallet2.create(new char[]{'a', '2', 'v', 'b', 'n', '9', '8', 'z'});
            bl = oracleWallet2.exists(string);
        }
        catch (IOException iOException) {
            System.out.println(c.getString("GEN_UNKNOWN_ERROR") + string);
            return;
        }
        if (bl && !bl2) {
            System.out.println(c.getString("WALLET_EXISTS_ERROR") + string);
            return;
        }
        if (bl && bl2) {
            try {
                oracleWallet.open(string, OraclePKIGenFunc.getPassword(string2, bl4, "WALLET_PASSWORD_PROMPT"));
            }
            catch (Exception exception) {
                System.out.println(c.getString("WALLET_LOAD_ERROR") + string);
                return;
            }
        }
        if (!bl3) {
            try {
                oracleWallet.create(OraclePKIGenFunc.getCreatePassword(string2, bl4));
                oracleWallet.saveAs(string);
            }
            catch (IOException iOException) {
                System.out.println("Unable to save wallet at " + string);
                return;
            }
        }
        if (bl2) {
            try {
                oracleWallet.saveSSO();
            }
            catch (IOException iOException) {
                System.out.println("Unable to save wallet at " + string);
                return;
            }
        }
        if (bl3) {
            try {
                oracleWallet.createSSO();
                oracleWallet.saveAs(string);
            }
            catch (IOException iOException) {
                System.out.println("Unable to create auto-login-only wallet: " + iOException.toString());
                iOException.printStackTrace();
                return;
            }
        }
    }

    public static void test_api(String[] stringArray) {
        boolean bl = false;
        String string = null;
        String string2 = null;
        boolean bl2 = false;
        if (stringArray.length == 0) {
            System.out.println(b);
            return;
        }
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-wallet")) {
                    string = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-auto_login")) {
                    bl = true;
                    continue;
                }
                if (stringArray[i].equals("-pwd")) {
                    string2 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-obpwd")) {
                    bl2 = true;
                    continue;
                }
                System.out.println(c.getString("INVALID_COMMAND_ERROR") + stringArray[i]);
                System.out.println(b);
                return;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(b);
            return;
        }
        try {
            Object object;
            OracleWallet oracleWallet;
            OracleWallet oracleWallet2 = OraclePKIGenFunc.openAWallet(string, string2, bl2);
            InputStream inputStream = null;
            InputStream inputStream2 = null;
            if (string2 != null) {
                inputStream = oracleWallet2.getWalletArray(false);
                inputStream2 = oracleWallet2.getWalletArray(true);
            } else {
                inputStream2 = oracleWallet2.getWalletArray(true);
            }
            if (string2 != null) {
                oracleWallet = new OracleWallet();
                oracleWallet.setWalletArray(inputStream, string2.toCharArray());
            }
            oracleWallet = new OracleWallet();
            oracleWallet.setWalletArray(inputStream2, null);
            boolean bl3 = oracleWallet.isAutoLoginOnly();
            if (bl3) {
                System.out.println("Wallet is auto login only (ALO).");
            } else {
                System.out.println("Wallet is not auto login only (ALO).");
            }
            int n = oracleWallet.getPersonaCount();
            X500Principal[] x500PrincipalArray = oracleWallet.getCertReqDNs(0);
            System.out.println("Number of certificate requests in wallet:" + oracleWallet.getCertReqCount(0));
            for (int i = 0; i < x500PrincipalArray.length; ++i) {
                String[] stringArray2 = oracleWallet.getCertReqInfo(0, i);
                System.out.println("   DN:" + stringArray2[0] + ", keysize:" + stringArray2[1] + " bytes, " + " keytype:" + stringArray2[2]);
            }
            X500Principal[] x500PrincipalArray2 = oracleWallet.getCertDNs(0);
            System.out.println("Number of certs in wallet:" + oracleWallet.getCertCount(0));
            for (int i = 0; i < x500PrincipalArray2.length; ++i) {
                X509Certificate x509Certificate = oracleWallet.getCert(0, i);
                System.out.println("  " + x509Certificate.getSubjectX500Principal());
            }
            X500Principal[] x500PrincipalArray3 = oracleWallet.getTrustpointDNs(0);
            System.out.println("Number of trusted certs in wallet:" + oracleWallet.getTrustpointCount(0));
            for (int i = 0; i < x500PrincipalArray3.length; ++i) {
                object = oracleWallet.getTrustpoint(0, i);
                System.out.println("  " + ((X509Certificate)object).getSubjectX500Principal());
            }
            X509Certificate x509Certificate = oracleWallet.getSSLCert(false);
            if (x509Certificate != null) {
                System.out.println("During SSL cert with DN \"" + x509Certificate.getSubjectDN() + "\" will be used");
            } else {
                System.out.println("No SSL cert found in wallet.");
            }
            object = "-----BEGIN CERTIFICATE-----\nMIIBKzCB1gIBADANBgkqhkiG9w0BAQQFADAhMQswCQYDVQQGEwJVUzESMBAGA1UEAwwJcm9vdF90\nZXN0MB4XDTA2MDQyNzE5MTM1N1oXDTE2MDQyNDE5MTM1N1owITELMAkGA1UEBhMCVVMxEjAQBgNV\nBAMMCXRlc3RfdGVzdDBcMA0GCSqGSIb3DQEBAQUAA0sAMEgCQQCd8QhmcTRmq9/GN+xATEZsQC7C\nnvkOl8Mfy5qXClyU/UdMFBZPC3oCylxjdekg286Kjlf3UPKHYkMg8EHk6ULZAgMBAAEwDQYJKoZI\nhvcNAQEEBQADQQBlEVBYPyavz07/8NrgbEMYJpQ/r1D517w1eVx6XqUpW64rEYV1aBYh73yyTleN\n4FTnoda3JkKujFFaYVBWAogA\n-----END CERTIFICATE-----";
            String string3 = OraclePKIX509CertHelper.removeCertHeaderFooter((String)object);
            String string4 = OraclePKIX509CertHelper.addCertHeaderFooter(string3);
            OracleWallet oracleWallet3 = new OracleWallet();
            oracleWallet3.createSSO();
            oracleWallet3.importCert(new ByteArrayInputStream(string4.getBytes()), true);
            String string5 = "-----BEGIN NEW CERTIFICATE REQUEST-----\nMIHbMIGGAgEAMCExCzAJBgNVBAYTAlVTMRIwEAYDVQQDDAl0ZXN0X3Rlc3QwXDANBgkqhkiG9w0B\nAQEFAANLADBIAkEAnfEIZnE0ZqvfxjfsQExGbEAuwp75DpfDH8ualwpclP1HTBQWTwt6AspcY3Xp\nINvOio5X91Dyh2JDIPBB5OlC2QIDAQABoAAwDQYJKoZIhvcNAQEEBQADQQAo3oNVwcYy4yhXMHIc\n7u8E2u8zJkTYRgZ7S7W1D0QutglTMbvB+wmeMkgQEPqM4M3NUg3z0VsgVxA0eizUhCWt\n-----END NEW CERTIFICATE REQUEST-----";
            String string6 = OraclePKIX509CertReqHelper.removeCertReqHeaderFooter(string5);
            String string7 = OraclePKIX509CertReqHelper.addCertReqHeaderFooter(string6);
            OraclePKIX509CertReqHelper.readB64CertReqFrom(new StringReader(string7));
        }
        catch (Exception exception) {
            System.out.println("test_api failed: " + exception.toString());
            return;
        }
    }

    public static void getKeysizes(String[] stringArray) {
        if (stringArray.length == 0) {
            int[] nArray = OracleWallet.getKeysizes();
            System.out.print("Supported keysizes : ");
            for (int i = 0; i < nArray.length; ++i) {
                System.out.print("\t" + nArray[i]);
            }
            System.out.println();
        } else {
            System.out.println("wallet:\nget_keysizes\nhelp");
        }
    }

    public static void getCertReqCountDNs(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        if (stringArray.length == 0) {
            System.out.println("wallet:\nget_certreq_count_dns [-wallet [wallet]] [-pwd [pwd]] [-isNonissuedCertOnly [true|false]]\nhelp");
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-wallet")) {
                string = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-pwd")) {
                string2 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-isNonissuedCertOnly")) {
                string3 = stringArray[++i];
                continue;
            }
            System.out.println("wallet:\nget_certreq_count_dns [-wallet [wallet]] [-pwd [pwd]] [-isNonissuedCertOnly [true|false]]\nhelp");
            return;
        }
        try {
            Boolean bl = Boolean.valueOf(string3);
            boolean bl2 = bl;
            OracleWallet oracleWallet = OraclePKIGenFunc.openAWallet(string, string2, false);
            int n = oracleWallet.getCertReqCount(0, bl2);
            System.out.println("Certificate Request Count = " + n);
            X500Principal[] x500PrincipalArray = oracleWallet.getCertReqDNs(0, bl2);
            System.out.println("Certificate Request DNs info : ");
            for (int i = 0; i < x500PrincipalArray.length; ++i) {
                System.out.println("Subject : " + x500PrincipalArray[i]);
            }
        }
        catch (Exception exception) {
            System.out.println("Exception in getCertReqCountDNs : " + exception);
        }
    }

    public static void p11_add(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        boolean bl = false;
        if (stringArray.length == 0) {
            System.out.println(b);
            return;
        }
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-wallet")) {
                    string = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-p11_lib")) {
                    string2 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-p11_tokenlabel")) {
                    string3 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-p11_tokenpw")) {
                    string4 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-p11_certlabel")) {
                    string5 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-pwd")) {
                    string6 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-obpwd")) {
                    bl = true;
                    continue;
                }
                System.out.println(c.getString("INVALID_COMMAND_ERROR") + stringArray[i]);
                System.out.println(b);
                return;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(b);
            return;
        }
        char[] cArray = OraclePKIGenFunc.getPassword(string6, bl, "WALLET_PASSWORD_PROMPT");
        NZWallet nZWallet = null;
        try {
            nZWallet = NZWallet.getPersonasWithTypeOld((String)("file:" + string), (String)new String(cArray));
            nZWallet.setWRL("file:" + string);
            nZWallet.setPersonaTypes(new String(cArray));
        }
        catch (Exception exception) {
            System.out.println(c.getString("WALLET_LOAD_ERROR") + string);
            return;
        }
        try {
            nZWallet.addPkcs11Info(string2, string3, string4, string5);
        }
        catch (NZException nZException) {
            System.out.println("Error: " + nZException.getExceptionId());
        }
        try {
            nZWallet.storeWallet();
            OracleWallet oracleWallet = new OracleWallet();
            oracleWallet.open(string, cArray);
            oracleWallet.save();
        }
        catch (NZException nZException) {
            System.out.println("Error: " + nZException.getExceptionId());
        }
        catch (Exception exception) {
            System.out.println(c.getString("GEN_UNKNOWN_ERROR"));
            return;
        }
    }

    static {
        c = ResourceBundle.getBundle("oracle.security.pki.resources.OraclePKIMsg");
        b = "wallet: \ncreate [-wallet [wallet]] [[-pwd <pwd>] [-auto_login]] [-auto_login_only] \ndisplay [-wallet [wallet]] <-summary> [-pwd <pwd>]\nchange_pwd [-wallet [wallet]] [-oldpwd <oldpwd>] [-newpwd <newpwd>]\nadd [-wallet [wallet]] <[-keysize [512|1024|2048|4096]] [-dn [dn]] \n     <-self_signed [-validity [days] [-serial_file [file_loc]] | [-serial_num [serial_num]]>\n     <[-cert [filename]] [-trusted_cert|-user_cert]> [-pwd <pwd>] [-auto_login_only]\nremove [-wallet [wallet]] [-dn [dn]] [-trusted_cert_all|-trusted_cert|-user_cert|-cert_req]> [-pwd <pwd>] [-auto_login_only] \nexport [-wallet [wallet]] [-dn [dn]] <-cert [filename]> <-request [filename]> [-pwd <pwd>] \nexport_trust_chain [-wallet <wlt>] -certchain <filename> [-dn <user cert dn>] [-pwd <pwd>]\np11_add [-wallet <wallet>] -p11_lib <pkcs11Lib> [-p11_tokenlabel <tokenLabel>] [-p11_tokenpw <tokenPassphrase>] [-p11_certlabel <certlabel>] [-pwd <pwd>]\np11_verify [-wallet <wallet>] [-pwd <pwd>]\nhelp\n";
    }

    public static void exportchain(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        boolean bl = false;
        if (stringArray.length == 0) {
            System.out.println(b);
            return;
        }
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-wallet")) {
                    string = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-dn")) {
                    string2 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-certchain")) {
                    string3 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-pwd")) {
                    string4 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-obpwd")) {
                    bl = true;
                    continue;
                }
                System.out.println(c.getString("INVALID_COMMAND_ERROR") + stringArray[i]);
                System.out.println(b);
                return;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(b);
            return;
        }
        String string5 = null;
        try {
            OracleWallet oracleWallet = OraclePKIGenFunc.openAWallet(string, string4, bl);
            string5 = oracleWallet.exportCertChainB64(new X500Principal(string2));
        }
        catch (Exception exception) {
            System.out.println(c.getString("WALLET_LOAD_ERROR"));
            return;
        }
        try {
            FileWriter fileWriter = new FileWriter(string3);
            fileWriter.write(string5);
            fileWriter.flush();
        }
        catch (IOException iOException) {
            System.out.println("Unable to export trust chain.");
            iOException.printStackTrace();
            return;
        }
    }

    public static void isValidPassword(String[] stringArray) {
        String string = null;
        if (stringArray.length == 0) {
            System.out.println("wallet:\nvalidate_pswd [-pwd [pwd]]\nhelp");
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-pwd")) {
                System.out.println("wallet:\nvalidate_pswd [-pwd [pwd]]\nhelp");
                return;
            }
            string = stringArray[++i];
        }
        if (OracleWallet.isValidPassword(string.toCharArray())) {
            System.out.println("Result : Valid Password");
        } else {
            System.out.println("Result : Invalid Password");
            System.out.println("PASSWORD_POLICY : Passwords must have a minimum length of eight characters and \ncontain alphabetic characters combined with numbers or special characters");
        }
    }
}

