/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.textui;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.cert.CRL;
import oracle.security.crypto.cert.CertificateRequest;
import oracle.security.crypto.cert.PKCS7;
import oracle.security.crypto.cert.X509;
import oracle.security.misc.Checksum;
import oracle.security.pki.OraclePKIX509CertImpl;
import oracle.security.pki.OraclePKIX509CrlHelper;
import oracle.security.pki.OracleWallet;
import oracle.security.pki.internal.OraclePKIX509CertHelper;
import oracle.security.pki.internal.OraclePKIX509CertReqHelper;

public class OraclePKIGenFunc {
    static ResourceBundle f;
    private static BufferedReader g;
    public static final int RETRY_COUNT = 2;

    public static CertificateRequest readCertRequestAt(String string) throws IOException {
        try {
            return new CertificateRequest(new URL(string).openStream());
        }
        catch (MalformedURLException malformedURLException) {
            try {
                return new CertificateRequest((InputStream)new FileInputStream(string));
            }
            catch (IOException iOException) {
                return OraclePKIX509CertReqHelper.readB64CertReqFrom(new FileReader(string));
            }
        }
        catch (IOException iOException) {
            return OraclePKIX509CertReqHelper.readB64CertReqFrom(new InputStreamReader(new URL(string).openStream()));
        }
    }

    public static char[] getCreatePassword() {
        return OraclePKIGenFunc.c("ENTER_PASSWORD", "ENTER_PASSWORD_AGAIN", "PASSWORD_NOT_MATCH_EERROR");
    }

    public static BigInteger getSerialNum(String string) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            String string2 = bufferedReader.readLine();
            bufferedReader.close();
            BigInteger bigInteger = new BigInteger(string2);
            return bigInteger;
        }
        catch (Exception exception) {
            System.out.println("Exception in getSerialNum : " + exception);
            return null;
        }
    }

    public static char[] getPassword(String string, boolean bl, String string2) {
        String string3 = null;
        if (string != null) {
            if (bl) {
                try {
                    string3 = OraclePKIGenFunc.a(string);
                }
                catch (IOException iOException) {
                    return null;
                }
            } else {
                string3 = string;
            }
            return string3.toCharArray();
        }
        return OraclePKIGenFunc.getPassword(string2);
    }

    public static OracleWallet openAWallet(String string, String string2, boolean bl) throws IOException {
        OracleWallet oracleWallet = new OracleWallet();
        String string3 = null;
        if (string2 != null) {
            string3 = bl ? OraclePKIGenFunc.a(string2) : string2;
            oracleWallet.open(string, string3.toCharArray());
            return oracleWallet;
        }
        try {
            oracleWallet.open(string, null);
            return oracleWallet;
        }
        catch (IOException iOException) {
            oracleWallet.open(string, OraclePKIGenFunc.getPassword("WALLET_PASSWORD_PROMPT"));
            return oracleWallet;
        }
    }

    private static String a(String string) throws IOException {
        String string2 = null;
        try {
            byte[] byArray = OraclePKIGenFunc.b(string);
            byte[] byArray2 = Checksum.SHA((byte[])byArray, null);
            string2 = new String(byArray2);
            return string2;
        }
        catch (Exception exception) {
            System.out.println("Deobfuscation exception: " + exception.toString());
            throw new IOException("deobfuscation error");
        }
    }

    public static OraclePKIX509CertImpl[] readCertsAt(String string) throws IOException {
        Vector vector = null;
        try {
            OraclePKIX509CertImpl oraclePKIX509CertImpl = new OraclePKIX509CertImpl(new X509(new URL(string)));
            return new OraclePKIX509CertImpl[]{oraclePKIX509CertImpl};
        }
        catch (MalformedURLException malformedURLException) {
            try {
                OraclePKIX509CertImpl oraclePKIX509CertImpl = new OraclePKIX509CertImpl(new X509(new File(string)));
                return new OraclePKIX509CertImpl[]{oraclePKIX509CertImpl};
            }
            catch (IOException iOException) {
                try {
                    OraclePKIX509CertImpl oraclePKIX509CertImpl = new OraclePKIX509CertImpl(OraclePKIX509CertHelper.readB64X509CertFrom(new FileReader(string)));
                    return new OraclePKIX509CertImpl[]{oraclePKIX509CertImpl};
                }
                catch (IOException iOException2) {
                    try {
                        vector = new PKCS7((InputStream)new FileInputStream(string)).getCertificates();
                    }
                    catch (IOException iOException3) {
                        vector = OraclePKIX509CertHelper.readB64X509PKCS7From(new FileReader(string));
                    }
                }
            }
        }
        catch (IOException iOException) {
            try {
                OraclePKIX509CertImpl oraclePKIX509CertImpl = new OraclePKIX509CertImpl(OraclePKIX509CertHelper.readB64X509CertFrom(new InputStreamReader(new URL(string).openStream())));
                return new OraclePKIX509CertImpl[]{oraclePKIX509CertImpl};
            }
            catch (IOException iOException4) {
                try {
                    vector = new PKCS7(new URL(string).openStream()).getCertificates();
                }
                catch (IOException iOException5) {
                    vector = OraclePKIX509CertHelper.readB64X509PKCS7From(new InputStreamReader(new URL(string).openStream()));
                }
            }
        }
        OraclePKIX509CertImpl[] oraclePKIX509CertImplArray = new OraclePKIX509CertImpl[vector.size()];
        for (int i = 0; i < oraclePKIX509CertImplArray.length; ++i) {
            oraclePKIX509CertImplArray[i] = new OraclePKIX509CertImpl((X509)vector.elementAt(i));
        }
        return oraclePKIX509CertImplArray;
    }

    private static byte[] b(String string) {
        if (string == null) {
            return new byte[0];
        }
        int n = string.length();
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[n / 2];
        for (int i = 0; i < n / 2; ++i) {
            byArray[i] = (byte)(OraclePKIGenFunc.e(cArray[2 * i]) << 4 & 0xF0 | OraclePKIGenFunc.e(cArray[2 * i + 1]) & 0xF);
        }
        return byArray;
    }

    public static char[] getCreatePassword(String string, boolean bl) {
        String string2 = null;
        if (string != null) {
            if (bl) {
                try {
                    string2 = OraclePKIGenFunc.a(string);
                }
                catch (IOException iOException) {
                    return null;
                }
            } else {
                string2 = string;
            }
            return string2.toCharArray();
        }
        return OraclePKIGenFunc.getCreatePassword();
    }

    public static OraclePKIX509CertImpl[] readCertsAt(InputStream inputStream) throws IOException {
        Vector vector = null;
        try {
            OraclePKIX509CertImpl oraclePKIX509CertImpl = new OraclePKIX509CertImpl(new X509(inputStream));
            return new OraclePKIX509CertImpl[]{oraclePKIX509CertImpl};
        }
        catch (ASN1FormatException aSN1FormatException) {
            try {
                inputStream.reset();
                OraclePKIX509CertImpl oraclePKIX509CertImpl = new OraclePKIX509CertImpl(OraclePKIX509CertHelper.readB64X509CertFrom(new InputStreamReader(inputStream)));
                return new OraclePKIX509CertImpl[]{oraclePKIX509CertImpl};
            }
            catch (IOException iOException) {
                try {
                    inputStream.reset();
                    vector = new PKCS7(inputStream).getCertificates();
                }
                catch (IOException iOException2) {
                    inputStream.reset();
                    vector = OraclePKIX509CertHelper.readB64X509PKCS7From(new InputStreamReader(inputStream));
                }
                OraclePKIX509CertImpl[] oraclePKIX509CertImplArray = new OraclePKIX509CertImpl[vector.size()];
                for (int i = 0; i < oraclePKIX509CertImplArray.length; ++i) {
                    oraclePKIX509CertImplArray[i] = new OraclePKIX509CertImpl((X509)vector.elementAt(i));
                }
                return oraclePKIX509CertImplArray;
            }
        }
    }

    static {
        g = new BufferedReader(new InputStreamReader(System.in));
        f = ResourceBundle.getBundle("oracle.security.pki.resources.OraclePKIMsg");
    }

    public static char[] getPassword(String string) {
        char[] cArray = null;
        try {
            System.out.print(f.getString(string) + "  ");
            cArray = OraclePKIGenFunc.d();
        }
        catch (IOException iOException) {
            System.out.print(f.getString("UNKNOWN_ERROR") + iOException);
            return null;
        }
        return cArray;
    }

    private static char[] c(String string, String string2, String string3) {
        int n = 0;
        while (true) {
            char[] cArray;
            if (n >= 2) {
                System.exit(1);
            }
            if (!OracleWallet.isValidPassword(cArray = OraclePKIGenFunc.getPassword(string))) {
                System.out.println("Invalid Password....");
                System.out.println("PASSWORD_POLICY : Passwords must have a minimum length of eight characters and \ncontain alphabetic characters combined with numbers or special characters.");
                ++n;
                continue;
            }
            char[] cArray2 = OraclePKIGenFunc.getPassword(string2);
            boolean bl = cArray.length == cArray2.length;
            for (int i = 0; i < cArray.length && bl; ++i) {
                bl = cArray[i] == cArray2[i];
            }
            if (bl) {
                return cArray;
            }
            System.out.println(f.getString(string3));
        }
    }

    public static CRL readCRLAt(String string) throws IOException {
        try {
            return new CRL(new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            try {
                return new CRL(new File(string));
            }
            catch (IOException iOException) {
                return OraclePKIX509CrlHelper.readB64CRLFrom(new FileReader(string));
            }
        }
        catch (IOException iOException) {
            return OraclePKIX509CrlHelper.readB64CRLFrom(new InputStreamReader(new URL(string).openStream()));
        }
    }

    public static void updateSerialNum(String string, BigInteger bigInteger) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
            String string2 = bigInteger.toString();
            bufferedWriter.write(string2, 0, string2.length());
            bufferedWriter.close();
        }
        catch (Exception exception) {
            System.out.println("Exception in updateSerialNum : " + exception);
        }
    }

    public static char[] getSecret() {
        return OraclePKIGenFunc.c("ENTER_SECRET", "ENTER_SECRET_AGAIN", "SECRET_NOT_MATCH_ERROR");
    }

    private static char[] d() throws IOException {
        char[] cArray = new char[1024];
        ConsoleEraser consoleEraser = new ConsoleEraser();
        consoleEraser.start();
        String string = g.readLine();
        consoleEraser.interrupt();
        try {
            consoleEraser.join();
            cArray = string.toCharArray();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println();
        return cArray;
    }

    private static byte e(char c) {
        if ('0' <= c && c <= '9') {
            return (byte)((byte)c - 48);
        }
        if ('a' <= c && c <= 'f') {
            return (byte)((byte)c - 97 + 10);
        }
        if ('A' <= c && c <= 'F') {
            return (byte)((byte)c - 65 + 10);
        }
        return -1;
    }

    static class ConsoleEraser
    extends Thread {
        public void run() {
            while (!ConsoleEraser.interrupted()) {
                System.out.print("\b\b\b   ");
            }
        }

        ConsoleEraser() {
        }
    }
}

