/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.textui;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.KeyStore;
import java.util.ResourceBundle;
import oracle.security.crypto.cert.CertificateRequest;
import oracle.security.pki.OraclePKIDebug;
import oracle.security.pki.OraclePKIX509CertImpl;
import oracle.security.pki.OracleWallet;
import oracle.security.pki.textui.OraclePKIGenFunc;

public class OracleCertTextUI {
    static String a;
    static ResourceBundle b;

    public static void display(String[] stringArray) {
        String string = null;
        boolean bl = false;
        boolean bl2 = false;
        if (stringArray.length == 0) {
            System.out.println(a);
            return;
        }
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-cert")) {
                    string = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-summary")) {
                    bl2 = true;
                    continue;
                }
                if (stringArray[i].equals("-complete")) {
                    bl = true;
                    continue;
                }
                System.out.println(b.getString("INVALID_COMMAND_ERROR") + stringArray[i]);
                System.out.println(a);
                return;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(a);
            return;
        }
        OraclePKIX509CertImpl[] oraclePKIX509CertImplArray = null;
        try {
            oraclePKIX509CertImplArray = OraclePKIGenFunc.readCertsAt(string);
        }
        catch (IOException iOException) {
            System.out.println("Unable to read certificate at " + string);
            iOException.printStackTrace();
            return;
        }
        if (bl) {
            for (int i = 0; i < oraclePKIX509CertImplArray.length; ++i) {
                System.out.println(oraclePKIX509CertImplArray[i]);
            }
        } else {
            for (int i = 0; i < oraclePKIX509CertImplArray.length; ++i) {
                System.out.println("Subject:        " + oraclePKIX509CertImplArray[i].getSubjectDN());
                System.out.println(b.getString("GEN_ISSUER_OUT") + oraclePKIX509CertImplArray[i].getIssuerDN());
                System.out.println("Valid Until:    " + oraclePKIX509CertImplArray[i].getNotAfter());
            }
        }
    }

    public static void command(String[] stringArray) {
        if (stringArray.length == 0) {
            System.out.println(a);
            return;
        }
        if (stringArray[0].equals("help")) {
            System.out.println(a);
            return;
        }
        if (stringArray[0].equals("display")) {
            String[] stringArray2 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray2, 0, stringArray2.length);
            OracleCertTextUI.display(stringArray2);
        } else if (stringArray[0].equals("create")) {
            String[] stringArray3 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray3, 0, stringArray3.length);
            OracleCertTextUI.create(stringArray3);
        } else {
            System.out.println(b.getString("INVALID_COMMAND_ERROR") + stringArray[0]);
            System.out.println(a);
            return;
        }
    }

    static {
        b = ResourceBundle.getBundle("oracle.security.pki.resources.OraclePKIMsg");
        a = "cert:\ndisplay [-cert [url|filename]] <-summary> <-complete>\ncreate [-wallet [wallet]] [-request [url|filename]] [-cert [filename]\n       [-serial_file [file_loc]] | [-serial_num [serial_num]]\n       [-validity [days]] <-summary> [-pwd <pwd>]\nhelp\n";
    }

    public static void create(String[] stringArray) {
        String string = null;
        boolean bl = false;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        boolean bl2 = false;
        String string6 = null;
        String string7 = null;
        BigInteger bigInteger = null;
        boolean bl3 = false;
        if (stringArray.length == 0) {
            System.out.println(a);
            return;
        }
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-cert")) {
                    string = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-request")) {
                    string2 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-wallet")) {
                    string3 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-validity")) {
                    string4 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-summary")) {
                    bl = true;
                    continue;
                }
                if (stringArray[i].equals("-pwd")) {
                    string5 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-obpwd")) {
                    bl2 = true;
                    continue;
                }
                if (stringArray[i].equals("-serial_file")) {
                    string6 = stringArray[++i];
                    bigInteger = OraclePKIGenFunc.getSerialNum(string6);
                    bigInteger = bigInteger.add(BigInteger.ONE);
                    bl3 = true;
                    continue;
                }
                if (stringArray[i].equals("-serial_num")) {
                    string7 = stringArray[++i];
                    bigInteger = new BigInteger(string7);
                    bl3 = true;
                    continue;
                }
                System.out.println(b.getString("INVALID_COMMAND_ERROR") + stringArray[i]);
                System.out.println(a);
                return;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(a);
            return;
        }
        if (bl3 && bigInteger == null) {
            System.out.println("Serial number should not be null....");
            return;
        }
        OracleWallet oracleWallet = null;
        KeyStore keyStore = null;
        CertificateRequest certificateRequest = null;
        int n = 0;
        try {
            if (string4 == null) {
                System.out.println("Please provide : -validity [days]");
                return;
            }
            n = Integer.parseInt(string4);
            if (n <= 0) {
                throw new NumberFormatException("");
            }
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Validity must be a positive integer");
            return;
        }
        try {
            oracleWallet = OraclePKIGenFunc.openAWallet(string3, string5, bl2);
            keyStore = oracleWallet.getKeyStore();
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            if (OraclePKIDebug.getDebugFlag()) {
                exception.printStackTrace();
            }
            return;
        }
        try {
            certificateRequest = OraclePKIGenFunc.readCertRequestAt(string2);
        }
        catch (Exception exception) {
            System.out.println("Unable to read certificate request at " + string2);
            return;
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            certificateRequest.output((OutputStream)byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            ByteArrayInputStream byteArrayInputStream = null;
            ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(byArray);
            byteArrayInputStream = !bl3 ? (ByteArrayInputStream)oracleWallet.createCert(byteArrayInputStream2, n) : (ByteArrayInputStream)oracleWallet.createCert(byteArrayInputStream2, n, bigInteger);
            int n2 = byteArrayInputStream.available();
            byte[] byArray2 = new byte[n2];
            byteArrayInputStream.read(byArray2);
            FileWriter fileWriter = new FileWriter(string);
            fileWriter.write(new String(byArray2));
            fileWriter.flush();
            if (string6 != null) {
                OraclePKIGenFunc.updateSerialNum(string6, bigInteger);
            }
        }
        catch (IOException iOException) {
            System.out.println("Unable to save certificate at " + string);
            System.out.println(iOException.toString());
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
    }
}

