/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.textui;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NoPermissionException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import oracle.ldap.util.jndi.ConnectionUtil;
import oracle.security.crypto.cert.CRL;
import oracle.security.crypto.core.AuthenticationException;
import oracle.security.crypto.core.PublicKey;
import oracle.security.crypto.core.RSAPublicKey;
import oracle.security.pki.OracleCRL;
import oracle.security.pki.OraclePKIPrincipalImpl;
import oracle.security.pki.OraclePKIX509CrlFileStore;
import oracle.security.pki.OracleWallet;
import oracle.security.pki.textui.OraclePKIGenFunc;

public class OracleCRLTextUI {
    static ResourceBundle d = ResourceBundle.getBundle("oracle.security.pki.resources.OraclePKIMsg");

    private static BasicAttributes a(String string) {
        BasicAttribute basicAttribute = new BasicAttribute("objectclass");
        basicAttribute.add("orclPKICRL");
        basicAttribute.add("cRLDistributionPoint");
        basicAttribute.add("top");
        BasicAttributes basicAttributes = new BasicAttributes(true);
        basicAttributes.put(basicAttribute);
        basicAttributes.put(new BasicAttribute("x509issuer", string));
        return basicAttributes;
    }

    static {
        System.setProperty("java.protocol.handler.pkgs", "oracle.security.pki");
    }

    public static void list(String[] stringArray) {
        Object var1_1 = null;
        String string = null;
        Object var3_3 = null;
        Object var4_4 = null;
        String string2 = "389";
        boolean bl = false;
        if (stringArray.length == 0) {
            System.out.println(d.getString("CRL_USE_STRING"));
            return;
        }
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-ldap")) {
                    int n;
                    if ((n = stringArray[++i].indexOf(58)) > 0) {
                        string = stringArray[i].substring(0, n);
                        string2 = stringArray[i].substring(n + 1);
                        continue;
                    }
                    string = stringArray[i];
                    continue;
                }
                System.out.println(d.getString("INVALID_COMMAND_ERROR") + stringArray[i]);
                System.out.println(d.getString("CRL_USE_STRING"));
                return;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(d.getString("CRL_USE_STRING"));
            return;
        }
        try {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            if (hashtable.get("java.naming.factory.initial") == null) {
                hashtable.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            }
            hashtable.put("java.naming.provider.url", "ldap://" + string + ":" + string2 + "/");
            InitialLdapContext initialLdapContext = null;
            try {
                initialLdapContext = ConnectionUtil.getDefaultDirCtx((String)string, (String)string2, (String)"", (String)"");
            }
            catch (Exception exception) {
                initialLdapContext = ConnectionUtil.getSSLDirCtx((String)string, (String)string2, (String)"", (String)"");
            }
            new InitialLdapContext(hashtable, null);
            BasicAttributes basicAttributes = OracleCRLTextUI.a(null);
            NamingEnumeration<SearchResult> namingEnumeration = initialLdapContext.search("cn=CRLValidation,cn=Validation,cn=PKI,cn=Products,cn=OracleContext", (Attributes)basicAttributes);
            if (!namingEnumeration.hasMore()) {
                System.out.println(d.getString("CRLS_NOT_PRESENT") + string + ":" + string2);
                return;
            }
            System.out.println();
            while (namingEnumeration.hasMore()) {
                SearchResult searchResult = namingEnumeration.next();
                Attributes attributes = searchResult.getAttributes();
                System.out.println(d.getString("GEN_ISSUER_OUT") + attributes.get("x509issuer").get());
                System.out.println(d.getString("GEN_LOCATION_OUT") + "ldap://" + string + ":" + string2 + "/" + "cn=CRLValidation,cn=Validation,cn=PKI,cn=Products,cn=OracleContext" + "?" + "certificaterevocationlist" + "?one?" + "x509issuer" + "=" + attributes.get("x509issuer").get());
                System.out.println();
            }
        }
        catch (javax.naming.AuthenticationException authenticationException) {
            System.out.println(d.getString("LDAP_LOGIN_ERROR"));
            return;
        }
        catch (NameNotFoundException nameNotFoundException) {
            System.out.println(d.getString("LDAP_SUBTREE_ERROR") + "cn=CRLValidation,cn=Validation,cn=PKI,cn=Products,cn=OracleContext");
            return;
        }
        catch (NoPermissionException noPermissionException) {
            System.out.println(d.getString("LDAP_ACCESS_RIGHTS_ERROR"));
            return;
        }
        catch (NamingException namingException) {
            System.out.println(d.getString("GEN_UNKNOWN_ERROR") + namingException);
            return;
        }
    }

    public static void hashName(String[] stringArray) {
        CRL cRL;
        String string = null;
        String string2 = null;
        String string3 = null;
        boolean bl = false;
        boolean bl2 = false;
        int n = -1;
        String string4 = null;
        boolean bl3 = false;
        if (stringArray.length == 0) {
            System.out.println(d.getString("CRL_USE_STRING"));
            return;
        }
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-crl")) {
                    string = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-wallet")) {
                    string2 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-symlink")) {
                    ++i;
                    bl = true;
                    bl2 = false;
                    if (n == -1) {
                        n = 0;
                    }
                    string3 = stringArray[i];
                    continue;
                }
                if (stringArray[i].equals("-copy")) {
                    ++i;
                    bl2 = true;
                    bl = false;
                    if (n == -1) {
                        n = 0;
                    }
                    string3 = stringArray[i];
                    continue;
                }
                if (stringArray[i].equals("-summary")) {
                    n = 1;
                    continue;
                }
                if (stringArray[i].equals("-pwd")) {
                    string4 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-obpwd")) {
                    bl3 = true;
                    continue;
                }
                System.out.println(d.getString("INVALID_COMMAND_ERROR") + stringArray[i]);
                System.out.println(d.getString("CRL_USE_STRING"));
                return;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(d.getString("CRL_USE_STRING"));
            return;
        }
        Object var10_12 = null;
        try {
            cRL = OraclePKIGenFunc.readCRLAt(string);
        }
        catch (Exception exception) {
            System.out.println(d.getString("CRL_PARSE_ERROR") + string);
            return;
        }
        String string5 = OraclePKIX509CrlFileStore.hashName(cRL.getIssuer());
        if (n != 0) {
            System.out.println(d.getString("GEN_ISSUER_OUT") + cRL.getIssuer());
            System.out.println(d.getString("GEN_HASH_OUT") + string5);
        }
        try {
            OracleCRLTextUI.b(string2, cRL, string4, bl3);
        }
        catch (Exception exception) {
            return;
        }
        if (bl2 || bl) {
            File file = new File(string3);
            if (!file.exists()) {
                System.out.println(string3 + d.getString("GEN_DIR_NOT_EXIST_ERROR"));
                return;
            }
            if (!file.isDirectory()) {
                System.out.println(string3 + d.getString("GEN_NOT_A_DIR_ERROR"));
                return;
            }
            File file2 = new File(file, string5);
            if (bl) {
                String string6 = new File(string).getAbsolutePath();
                String string7 = file2.getAbsolutePath();
                Process process = null;
                try {
                    process = Runtime.getRuntime().exec("ln -s " + string6 + " " + string7);
                    process.waitFor();
                }
                catch (Exception exception) {
                    int n2 = process.exitValue();
                    System.out.println(d.getString("CRL_SYMLINK_ERROR") + n2);
                    return;
                }
                int n3 = process.exitValue();
                if (n3 != 0) {
                    System.out.println(d.getString("CRL_SYMLINK_ERROR") + n3);
                    return;
                }
            } else if (bl2) {
                try {
                    file2.createNewFile();
                    cRL.output((OutputStream)new FileOutputStream(file2));
                }
                catch (IOException iOException) {
                    System.out.println(d.getString("CRL_SAVE_ERROR"));
                    return;
                }
            }
        }
    }

    private static void b(String string, CRL cRL, String string2, boolean bl) throws Exception {
        if (string != null) {
            OracleWallet oracleWallet;
            try {
                oracleWallet = OraclePKIGenFunc.openAWallet(string, string2, bl);
            }
            catch (Exception exception) {
                System.out.println(d.getString("WALLET_LOAD_ERROR") + string);
                throw exception;
            }
            try {
                OracleCRLTextUI.c(cRL, oracleWallet);
                System.out.println(d.getString("CRL_VERIFY_OK"));
            }
            catch (AuthenticationException authenticationException) {
                System.out.println(d.getString("CRL_VERIFY_ERROR"));
                throw authenticationException;
            }
        }
    }

    public static void display(String[] stringArray) {
        CRL cRL;
        String string = null;
        String string2 = null;
        Object var3_3 = null;
        boolean bl = false;
        boolean bl2 = false;
        String string3 = null;
        boolean bl3 = false;
        if (stringArray.length == 0) {
            System.out.println(d.getString("CRL_USE_STRING"));
            return;
        }
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-crl")) {
                    string = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-wallet")) {
                    string2 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-summary")) {
                    bl2 = true;
                    continue;
                }
                if (stringArray[i].equals("-complete")) {
                    bl = true;
                    continue;
                }
                if (stringArray[i].equals("-pwd")) {
                    string3 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-obpwd")) {
                    bl3 = true;
                    continue;
                }
                System.out.println(d.getString("INVALID_COMMAND_ERROR") + stringArray[i]);
                System.out.println(d.getString("CRL_USE_STRING"));
                return;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(d.getString("CRL_USE_STRING"));
            return;
        }
        Object var9_11 = null;
        try {
            cRL = OraclePKIGenFunc.readCRLAt(string);
        }
        catch (Exception exception) {
            System.out.println(d.getString("CRL_PARSE_ERROR") + string);
            return;
        }
        if (!bl || bl2) {
            System.out.println(d.getString("GEN_ISSUER_OUT") + cRL.getIssuer());
            System.out.println(d.getString("GEN_DATE_OUT") + cRL.getDate());
            System.out.println(d.getString("CRL_NEXT_DATE_OUT") + cRL.getNextDate());
        }
        if (bl) {
            System.out.println(cRL);
        }
        try {
            OracleCRLTextUI.b(string2, cRL, string3, bl3);
        }
        catch (Exception exception) {
            return;
        }
    }

    public static void command(String[] stringArray) {
        if (stringArray.length == 0) {
            System.out.println(d.getString("CRL_USE_STRING"));
            return;
        }
        if (stringArray[0].equals("help")) {
            System.out.println(d.getString("CRL_USE_STRING"));
            return;
        }
        if (stringArray[0].equals("hash")) {
            String[] stringArray2 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray2, 0, stringArray2.length);
            OracleCRLTextUI.hashName(stringArray2);
        } else if (stringArray[0].equals("upload")) {
            String[] stringArray3 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray3, 0, stringArray3.length);
            OracleCRLTextUI.upload(stringArray3);
        } else if (stringArray[0].equals("delete")) {
            String[] stringArray4 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray4, 0, stringArray4.length);
            OracleCRLTextUI.delete(stringArray4);
        } else if (stringArray[0].equals("list")) {
            String[] stringArray5 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray5, 0, stringArray5.length);
            OracleCRLTextUI.list(stringArray5);
        } else if (stringArray[0].equals("display")) {
            String[] stringArray6 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray6, 0, stringArray6.length);
            OracleCRLTextUI.display(stringArray6);
        } else {
            System.out.println(d.getString("INVALID_COMMAND_ERROR") + stringArray[0]);
            System.out.println(d.getString("CRL_USE_STRING"));
            return;
        }
    }

    public static void delete(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = "389";
        String string4 = null;
        boolean bl = false;
        if (stringArray.length == 0) {
            System.out.println(d.getString("CRL_USE_STRING"));
            return;
        }
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-issuer")) {
                    string4 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-ldap")) {
                    int n;
                    if ((n = stringArray[++i].indexOf(58)) > 0) {
                        string = stringArray[i].substring(0, n);
                        string3 = stringArray[i].substring(n + 1);
                        continue;
                    }
                    string = stringArray[i];
                    continue;
                }
                if (stringArray[i].equals("-user")) {
                    string2 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-summary")) {
                    bl = true;
                    continue;
                }
                System.out.println(d.getString("INVALID_COMMAND_ERROR") + stringArray[i]);
                System.out.println(d.getString("CRL_USE_STRING"));
                return;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(d.getString("CRL_USE_STRING"));
            return;
        }
        try {
            InitialLdapContext initialLdapContext = ConnectionUtil.getSSLDirCtx(string, (String)string3, string2, (String)new String(OraclePKIGenFunc.getPassword("LDAP_PASSWORD_PROMPT")));
            BasicAttributes basicAttributes = OracleCRLTextUI.a(string4);
            NamingEnumeration<SearchResult> namingEnumeration = initialLdapContext.search("cn=CRLValidation,cn=Validation,cn=PKI,cn=Products,cn=OracleContext", (Attributes)basicAttributes);
            if (namingEnumeration.hasMore()) {
                SearchResult searchResult = namingEnumeration.next();
                String string5 = searchResult.getName() + "," + "cn=CRLValidation,cn=Validation,cn=PKI,cn=Products,cn=OracleContext";
                BasicAttributes basicAttributes2 = new BasicAttributes();
                initialLdapContext.unbind(string5);
                if (bl) {
                    System.out.println(d.getString("LDAP_CRL_DELETED") + string5);
                }
            } else if (bl) {
                System.out.println(d.getString("CRLS_NOT_FOUND_FOR_ISSUER_ERROR") + string4);
            }
        }
        catch (javax.naming.AuthenticationException authenticationException) {
            System.out.println(d.getString("LDAP_LOGIN_ERROR"));
            return;
        }
        catch (NameNotFoundException nameNotFoundException) {
            System.out.println(d.getString("LDAP_SUBTREE_ERROR") + "cn=CRLValidation,cn=Validation,cn=PKI,cn=Products,cn=OracleContext");
        }
        catch (NoPermissionException noPermissionException) {
            System.out.println(d.getString("LDAP_ACCESS_RIGHTS_ERROR"));
            return;
        }
        catch (NamingException namingException) {
            System.out.println(d.getString("GEN_UNKNOWN_ERROR") + namingException);
            return;
        }
    }

    public static void upload(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = "";
        String string5 = "389";
        char[] cArray = null;
        boolean bl = false;
        String string6 = null;
        boolean bl2 = false;
        InputStream inputStream = null;
        if (stringArray.length == 0) {
            System.out.println(d.getString("CRL_USE_STRING"));
            return;
        }
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-crl")) {
                    string = stringArray[++i];
                    try {
                        inputStream = new URL(string).openStream();
                        continue;
                    }
                    catch (MalformedURLException malformedURLException) {
                        try {
                            inputStream = new FileInputStream(string);
                            continue;
                        }
                        catch (IOException iOException) {
                            System.out.println("File not found : " + string);
                            return;
                        }
                    }
                    catch (IOException iOException) {
                        System.out.println("Found valid URL but invalid CRL there.");
                        return;
                    }
                }
                if (stringArray[i].equals("-ldap")) {
                    int n;
                    if ((n = stringArray[++i].indexOf(58)) > 0) {
                        string2 = stringArray[i].substring(0, n);
                        string5 = stringArray[i].substring(n + 1);
                        continue;
                    }
                    string2 = stringArray[i];
                    continue;
                }
                if (stringArray[i].equals("-ldappwd")) {
                    cArray = stringArray[++i].toCharArray();
                    continue;
                }
                if (stringArray[i].equals("-user")) {
                    string4 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-wallet")) {
                    string3 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-summary")) {
                    bl = true;
                    continue;
                }
                if (stringArray[i].equals("-pwd")) {
                    string6 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-obpwd")) {
                    bl2 = true;
                    continue;
                }
                System.out.println(d.getString("INVALID_COMMAND_ERROR") + stringArray[i]);
                System.out.println(d.getString("CRL_USE_STRING"));
                return;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(d.getString("CRL_USE_STRING"));
            return;
        }
        if (cArray == null) {
            cArray = OraclePKIGenFunc.getPassword("LDAP_PASSWORD_PROMPT");
        }
        try {
            OracleCRL.uploadCRL(string3, string6.toCharArray(), bl2, inputStream, string2, string5, string4, cArray, bl);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            System.out.println("Could not upload CRL to the directory.");
        }
    }

    private static void c(CRL cRL, OracleWallet oracleWallet) throws AuthenticationException {
        OraclePKIPrincipalImpl oraclePKIPrincipalImpl = new OraclePKIPrincipalImpl(cRL.getIssuer());
        KeyStore keyStore = null;
        Enumeration<String> enumeration = null;
        if (!cRL.verifyDate()) {
            throw new AuthenticationException("CRL expired/not yet valid");
        }
        try {
            keyStore = oracleWallet.getKeyStore();
            enumeration = keyStore.aliases();
        }
        catch (Exception exception) {
            throw new AuthenticationException();
        }
        while (enumeration.hasMoreElements()) {
            try {
                Certificate certificate = keyStore.getCertificate(enumeration.nextElement());
                if (!(certificate instanceof X509Certificate) || !oraclePKIPrincipalImpl.equals(((X509Certificate)certificate).getSubjectDN()) || !certificate.getPublicKey().getAlgorithm().equals("RSA")) continue;
                cRL.setPublicKey((PublicKey)new RSAPublicKey(certificate.getPublicKey().getEncoded()));
                if (!cRL.verify()) continue;
                return;
            }
            catch (KeyStoreException keyStoreException) {
                break;
            }
            catch (IOException iOException) {
                // empty catch block
                break;
            }
        }
        throw new AuthenticationException("Could not find signer for CRL");
    }
}

