/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.ssl;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.security.KeyStore;
import java.security.Security;
import javax.net.ServerSocketFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import oracle.security.pki.OraclePKIProvider;
import oracle.security.pki.ssl.ClassServer;

public class ClassFileServer14
extends ClassServer {
    private String c;
    private int d = 0;
    private static int e = 2001;
    private int f;

    public ClassFileServer14(ServerSocket serverSocket, String string, int n) throws IOException {
        super(serverSocket);
        this.c = string;
        this.f = n;
    }

    public synchronized void waitForCompletion() {
        while (this.d > 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected synchronized void newListener() {
        if (this.f > 0) {
            ++this.d;
            --this.f;
            super.newListener();
        }
    }

    public void run() {
        super.run();
        this.a();
    }

    public byte[] getBytes(String string) throws IOException {
        System.out.println("reading: " + string);
        File file = new File(this.c + File.separator + string);
        int n = (int)file.length();
        if (n == 0) {
            throw new IOException("File length is zero: " + string);
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        DataInputStream dataInputStream = new DataInputStream(fileInputStream);
        byte[] byArray = new byte[n];
        dataInputStream.readFully(byArray);
        return byArray;
    }

    private synchronized void a() {
        --this.d;
        this.notifyAll();
    }

    private static ServerSocketFactory b(String string) {
        if (string.equals("TLS")) {
            SSLServerSocketFactory sSLServerSocketFactory = null;
            try {
                Object object;
                Security.insertProviderAt(new OraclePKIProvider(), 1);
                KeyStore keyStore = KeyStore.getInstance(System.getProperty("javax.net.ssl.trustStoreType"), "OraclePKI");
                FileInputStream fileInputStream = new FileInputStream(System.getProperty("javax.net.ssl.trustStore"));
                keyStore.load(fileInputStream, System.getProperty("javax.net.ssl.trustStorePassword", "").toCharArray());
                String string2 = System.getProperty("test.trustmanager.algorithm", TrustManagerFactory.getDefaultAlgorithm());
                System.out.println("Using TrustManagerFactory =" + string2);
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(string2);
                trustManagerFactory.init(keyStore);
                TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
                KeyManager[] keyManagerArray = null;
                if (System.getProperty("javax.net.ssl.keyStore") != null) {
                    object = KeyStore.getInstance(System.getProperty("javax.net.ssl.keyStoreType"), "OraclePKI");
                    FileInputStream fileInputStream2 = new FileInputStream(System.getProperty("javax.net.ssl.keyStore"));
                    ((KeyStore)object).load(fileInputStream2, System.getProperty("javax.net.ssl.keyStorePassword", "").toCharArray());
                    String string3 = System.getProperty("test.keymanager.algorithm", KeyManagerFactory.getDefaultAlgorithm());
                    System.out.println("Using KeyManagerFactory = " + string3);
                    KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(string3);
                    keyManagerFactory.init((KeyStore)object, System.getProperty("javax.net.ssl.trustStorePassword", "").toCharArray());
                    keyManagerArray = keyManagerFactory.getKeyManagers();
                }
                object = SSLContext.getInstance("SSL");
                ((SSLContext)object).init(keyManagerArray, trustManagerArray, null);
                sSLServerSocketFactory = ((SSLContext)object).getServerSocketFactory();
                return sSLServerSocketFactory;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            return ServerSocketFactory.getDefault();
        }
        return null;
    }

    public static void main(String[] stringArray) {
        System.out.println("USAGE: java ClassFileServer port docroot numOfConns [TLS [true]]");
        System.out.println("");
        System.out.println("If the third argument is TLS, it will start as\na TLS/SSL file server, otherwise, it will be\nan ordinary file server. \nIf the fourth argument is true,it will require\nclient authentication as well.");
        int n = e;
        String string = "";
        int n2 = 1;
        if (stringArray.length >= 1) {
            n = Integer.parseInt(stringArray[0]);
        }
        if (stringArray.length >= 2) {
            string = stringArray[1];
        }
        if (stringArray.length >= 3) {
            n2 = Integer.parseInt(stringArray[2]);
        }
        String string2 = "PlainSocket";
        if (stringArray.length >= 4) {
            string2 = stringArray[3];
        }
        try {
            ServerSocketFactory serverSocketFactory = ClassFileServer14.b(string2);
            ServerSocket serverSocket = serverSocketFactory.createServerSocket(n);
            if (stringArray.length >= 4 && stringArray[4].equals("true")) {
                ((SSLServerSocket)serverSocket).setNeedClientAuth(true);
            }
            ClassFileServer14 classFileServer14 = new ClassFileServer14(serverSocket, string, n2);
            classFileServer14.start();
            classFileServer14.waitForCompletion();
        }
        catch (IOException iOException) {
            System.out.println("Unable to start ClassServer: " + iOException.getMessage());
            iOException.printStackTrace(System.out);
        }
    }
}

