/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.ssl;

import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import oracle.security.crypto.cert.CRL;
import oracle.security.crypto.cert.X509;
import oracle.security.pki.OraclePKIX509CertImpl;
import oracle.security.pki.ssl.OracleSSLDebug;

final class C18 {
    private Map a = Collections.synchronizedMap(new HashMap());

    public void storeCRL(CRL cRL) {
        OracleSSLDebug.c("OracleSSLCrlCache: storing crl " + cRL.getIssuer().toString());
        this.a.put(cRL.getIssuer().getName(), cRL);
    }

    public CRL getCRLFor(X509Certificate x509Certificate) {
        OracleSSLDebug.c("OracleSSLCrlCache: getCRLFor entry");
        X509 x509 = null;
        try {
            x509 = x509Certificate instanceof OraclePKIX509CertImpl ? ((OraclePKIX509CertImpl)x509Certificate).getX509() : new X509(x509Certificate.getEncoded());
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Invalid Cert");
        }
        String string = x509.getIssuer().toString();
        OracleSSLDebug.c("OracleSSLCrlCache: looking for CRL for " + string);
        CRL cRL = (CRL)this.a.get(string);
        if (cRL != null && cRL.verifyDate()) {
            this.a.remove(string);
            return null;
        }
        return cRL;
    }
}

