/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Security;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.security.auth.x500.X500Principal;
import oracle.security.crypto.cert.CertificateRequest;
import oracle.security.crypto.cert.PKCS12;
import oracle.security.crypto.cert.PKCS12Safe;
import oracle.security.crypto.cert.PKCS7;
import oracle.security.crypto.cert.X500Name;
import oracle.security.crypto.cert.X509;
import oracle.security.crypto.core.AuthenticationException;
import oracle.security.crypto.core.KeyPair;
import oracle.security.crypto.core.RSAKeyPairGenerator;
import oracle.security.crypto.core.RSAPrivateKey;
import oracle.security.crypto.core.RSAPublicKey;
import oracle.security.crypto.core.RandomBitsSource;
import oracle.security.crypto.core.SHA1RandomBitsSource;
import oracle.security.crypto.core.SignatureException;
import oracle.security.pki.C02;
import oracle.security.pki.C05;
import oracle.security.pki.C07;
import oracle.security.pki.C13;
import oracle.security.pki.C18;
import oracle.security.pki.OracleKeyStoreSpi;
import oracle.security.pki.OraclePKIDebug;
import oracle.security.pki.OraclePKIPrincipalImpl;
import oracle.security.pki.OraclePKIProvider;
import oracle.security.pki.OraclePKIRSAPrivateKey;
import oracle.security.pki.OraclePKIX509CertImpl;
import oracle.security.pki.OracleSSOKeyStoreSpi;
import oracle.security.pki.OracleSecretStore;
import oracle.security.pki.OracleSecretStoreException;
import oracle.security.pki.OracleWalletPersona;
import oracle.security.pki.textui.OraclePKIGenFunc;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class OracleWallet {
    private static String n;
    private static final String o = "-----END CERTIFICATE-----";
    private static final String p = "-----END NEW CERTIFICATE REQUEST-----";
    private byte[] q = null;
    public static final String ENTRUST_GLOBAL_CERT = "MIIElTCCA/6gAwIBAgIEOJsRPDANBgkqhkiG9w0BAQQFADCBujEUMBIGA1UEChMLRW50cnVzdC5uZXQxPzA9BgNVBAsUNnd3dy5lbnRydXN0Lm5ldC9TU0xfQ1BTIGluY29ycC4gYnkgcmVmLiAobGltaXRzIGxpYWIuKTElMCMGA1UECxMcKGMpIDIwMDAgRW50cnVzdC5uZXQgTGltaXRlZDE6MDgGA1UEAxMxRW50cnVzdC5uZXQgU2VjdXJlIFNlcnZlciBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTAeFw0wMDAyMDQxNzIwMDBaFw0yMDAyMDQxNzUwMDBaMIG6MRQwEgYDVQQKEwtFbnRydXN0Lm5ldDE/MD0GA1UECxQ2d3d3LmVudHJ1c3QubmV0L1NTTF9DUFMgaW5jb3JwLiBieSByZWYuIChsaW1pdHMgbGlhYi4pMSUwIwYDVQQLExwoYykgMjAwMCBFbnRydXN0Lm5ldCBMaW1pdGVkMTowOAYDVQQDEzFFbnRydXN0Lm5ldCBTZWN1cmUgU2VydmVyIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDHwV9OcfHO8GCGD9JYf9Mzly0XonUwtZZkJi9ow0SrqHXmAGc0V55lxyKbc+bT3QgON1WqJUaBbL3+qPZ1V1eMkGxKwz6LS0MKyRFWmponIpnPVZ5h2QLifLZ8OAfc439PmrkDQYC2dWcTC5/oVzbIXQA23mYU2m52H083jIITiQIDAQABo4IBpDCCAaAwEQYJYIZIAYb4QgEBBAQDAgAHMIHjBgNVHR8EgdswgdgwgdWggdKggc+kgcwwgckxFDASBgNVBAoTC0VudHJ1c3QubmV0MT8wPQYDVQQLFDZ3d3cuZW50cnVzdC5uZXQvU1NMX0NQUyBpbmNvcnAuIGJ5IHJlZi4gKGxpbWl0cyBsaWFiLikxJTAjBgNVBAsTHChjKSAyMDAwIEVudHJ1c3QubmV0IExpbWl0ZWQxOjA4BgNVBAMTMUVudHJ1c3QubmV0IFNlY3VyZSBTZXJ2ZXIgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkxDTALBgNVBAMTBENSTDEwKwYDVR0QBCQwIoAPMjAwMDAyMDQxNzIwMDBagQ8yMDIwMDIwNDE3NTAwMFowCwYDVR0PBAQDAgEGMB8GA1UdIwQYMBaAFMtswGvjuz7L/CKc/vuLkpyw8m4iMB0GA1UdDgQWBBTLbMBr47s+y/winP77i5KcsPJuIjAMBgNVHRMEBTADAQH/MB0GCSqGSIb2fQdBAAQQMA4bCFY1LjA6NC4wAwIEkDANBgkqhkiG9w0BAQQFAAOBgQBi24GRzsiad0Iv7L0no1MPUBvqTpLwqa+poLpIYcvvyQbvH9X07t9WLebKahlzqlO+krNQAraFJnJj2HVQYnUUt7NQGj/KEQALhUVpbbalrlHhStyCP2yMNLJ3a9kC9n8O6mUE8c1UyrrJzOCE98g+EZfTYAkYvAX/bIkz8OwVDw==";
    private String r = null;
    static /* synthetic */ Class s;
    public static final String GTE_CYBERTRUSTGLOBAL_CERT = "MIICWjCCAcMCAgGlMA0GCSqGSIb3DQEBBAUAMHUxCzAJBgNVBAYTAlVTMRgwFgYDVQQKEw9HVEUgQ29ycG9yYXRpb24xJzAlBgNVBAsTHkdURSBDeWJlclRydXN0IFNvbHV0aW9ucywgSW5jLjEjMCEGA1UEAxMaR1RFIEN5YmVyVHJ1c3QgR2xvYmFsIFJvb3QwHhcNOTgwODEzMDAyOTAwWhcNMTgwODEzMjM1OTAwWjB1MQswCQYDVQQGEwJVUzEYMBYGA1UEChMPR1RFIENvcnBvcmF0aW9uMScwJQYDVQQLEx5HVEUgQ3liZXJUcnVzdCBTb2x1dGlvbnMsIEluYy4xIzAhBgNVBAMTGkdURSBDeWJlclRydXN0IEdsb2JhbCBSb290MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCVD6C28FCc6HrHiM3dFw4usJTQGz0O9pTAipTHBsiQl8i4ZBp6fmw8U+E3KHNgf7KXUwefU/ltWJTSr41tiGeA5u2ylc9yMcqlHHK6XALnZELn+aks1joNrI1CqiQBOeacPwGFVw1Yh0X404Wqk2kmhXBIgD8SFcd5tB8FLztimQIDAQABMA0GCSqGSIb3DQEBBAUAA4GBAG3rGwnpXtlR22ciYaQqPEh346B8pt5zohQDhT37qw4wxYMWM4ETCJ57NE7fQMh017l93PR2VX2bY1QY6fDq81yx2YtCHrnAlU66+tXifPVoYb+O7AWXX1uw16OFNMQkpw0PlZPvy5TYnh+dXIVtx6quTx8itc2VrbqnzPmrC3p/";
    private static String t;
    private static final String u = "-----BEGIN CERTIFICATE-----";
    private static final String v = "-----BEGIN NEW CERTIFICATE REQUEST-----";
    private static final String w = "reg:";
    private static final String x = "file:";
    private char[] y = null;
    private static String z;
    private C18 A = null;
    private static String B;
    private char[] C = null;
    static ResourceBundle D;
    public static final String ENTRUST_PREMIUM_CERT = "MIIEXDCCA0SgAwIBAgIEOGO5ZjANBgkqhkiG9w0BAQUFADCBtDEUMBIGA1UEChMLRW50cnVzdC5uZXQxQDA+BgNVBAsUN3d3dy5lbnRydXN0Lm5ldC9DUFNfMjA0OCBpbmNvcnAuIGJ5IHJlZi4gKGxpbWl0cyBsaWFiLikxJTAjBgNVBAsTHChjKSAxOTk5IEVudHJ1c3QubmV0IExpbWl0ZWQxMzAxBgNVBAMTKkVudHJ1c3QubmV0IENlcnRpZmljYXRpb24gQXV0aG9yaXR5ICgyMDQ4KTAeFw05OTEyMjQxNzUwNTFaFw0xOTEyMjQxODIwNTFaMIG0MRQwEgYDVQQKEwtFbnRydXN0Lm5ldDFAMD4GA1UECxQ3d3d3LmVudHJ1c3QubmV0L0NQU18yMDQ4IGluY29ycC4gYnkgcmVmLiAobGltaXRzIGxpYWIuKTElMCMGA1UECxMcKGMpIDE5OTkgRW50cnVzdC5uZXQgTGltaXRlZDEzMDEGA1UEAxMqRW50cnVzdC5uZXQgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkgKDIwNDgpMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEArU1LqRKGsuqjIAcVFmQqK0vRvwtKTY7tgHalZ7d4QMBzQshowNtTK91euHaYNZOLGp18EzoOH1u3Hs/lJBQesYGpjX24zGtLA/ECDNyrpUAkAH90lKGdCCmziAv1h3edVc3kw37XamSrhRSGlVuXMlBvPci6Zgzj/L24ScF2iUkZ/cCovYmjZy/Gn7xxGWC4LeksyZB2ZnuU4q941mVTXTzWnLLPKQP5L6RQstRIzgUyVYr9smRMDuSYB3Xbf9+5CFVghTAp+XtIpGmG4zU/HoZdenoVve8AjhUiVBcAkCaTvA5JaJG/+EfTnZVCwQ5N328mz8MYIWJmQ3DW1cAH4QIDAQABo3QwcjARBglghkgBhvhCAQEEBAMCAAcwHwYDVR0jBBgwFoAUVeSB0RGAvtiJuQijMfmhJAkWuXAwHQYDVR0OBBYEFFXkgdERgL7YibkIozH5oSQJFrlwMB0GCSqGSIb2fQdBAAQQMA4bCFY1LjA6NC4wAwIEkDANBgkqhkiG9w0BAQUFAAOCAQEAWUesIYSKF8mciVMeuoCFGsY8Tj6xnLZ8xpJdGGQC49MGCBFhfGPjK50xA3B20qMooPS7mmNz7W3lKtvtFKkrxjYR0CvrB4ul2p5cGZ1WEvVUKcgF7bISKo30Axv/55IQh7A6tcOdBTcSo8f0FbnVpDkWm1M6I5HxqIKiaohowXkCIryqptau37AUX7iH0N18f3v/rxzP5tsHrV7bhZ3QKw0z2wTR5klAEyt2+z7pnIkPFc4YsIV4IU9rTw76NmfNB/L/CNDi3tm/Kq+4h4YhPATKt5Rof8886ZjXOP/swNlQ8C5LWK5Gb9Auw2DaclVyvUxFnmG6v4SBkgPR0ml8xQ==";
    static /* synthetic */ Class E;
    public static final String ENTRUST_MAIN_CERT = "MIIE2DCCBEGgAwIBAgIEN0rSQzANBgkqhkiG9w0BAQUFADCBwzELMAkGA1UEBhMCVVMxFDASBgNVBAoTC0VudHJ1c3QubmV0MTswOQYDVQQLEzJ3d3cuZW50cnVzdC5uZXQvQ1BTIGluY29ycC4gYnkgcmVmLiAobGltaXRzIGxpYWIuKTElMCMGA1UECxMcKGMpIDE5OTkgRW50cnVzdC5uZXQgTGltaXRlZDE6MDgGA1UEAxMxRW50cnVzdC5uZXQgU2VjdXJlIFNlcnZlciBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTAeFw05OTA1MjUxNjA5NDBaFw0xOTA1MjUxNjM5NDBaMIHDMQswCQYDVQQGEwJVUzEUMBIGA1UEChMLRW50cnVzdC5uZXQxOzA5BgNVBAsTMnd3dy5lbnRydXN0Lm5ldC9DUFMgaW5jb3JwLiBieSByZWYuIChsaW1pdHMgbGlhYi4pMSUwIwYDVQQLExwoYykgMTk5OSBFbnRydXN0Lm5ldCBMaW1pdGVkMTowOAYDVQQDEzFFbnRydXN0Lm5ldCBTZWN1cmUgU2VydmVyIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MIGdMA0GCSqGSIb3DQEBAQUAA4GLADCBhwKBgQDNKIM0VBuJ8w+vN5Ex/68xYMmo6LIQaO2f55M28Qpku0f1BBc/I0dNxScZgSYMVHINiC3ZH5oSn7yzcdOAGT9HZnuMNSjSuQrfJNqc1lB5gXpa0zf3wkrYKZImZNHkmGw6AIr1NJtl+O3jEP/9uElY3KDegjlrgbEWGWG5VLbmQwIBA6OCAdcwggHTMBEGCWCGSAGG+EIBAQQEAwIABzCCARkGA1UdHwSCARAwggEMMIHeoIHboIHYpIHVMIHSMQswCQYDVQQGEwJVUzEUMBIGA1UEChMLRW50cnVzdC5uZXQxOzA5BgNVBAsTMnd3dy5lbnRydXN0Lm5ldC9DUFMgaW5jb3JwLiBieSByZWYuIChsaW1pdHMgbGlhYi4pMSUwIwYDVQQLExwoYykgMTk5OSBFbnRydXN0Lm5ldCBMaW1pdGVkMTowOAYDVQQDEzFFbnRydXN0Lm5ldCBTZWN1cmUgU2VydmVyIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MQ0wCwYDVQQDEwRDUkwxMCmgJ6AlhiNodHRwOi8vd3d3LmVudHJ1c3QubmV0L0NSTC9uZXQxLmNybDArBgNVHRAEJDAigA8xOTk5MDUyNTE2MDk0MFqBDzIwMTkwNTI1MTYwOTQwWjALBgNVHQ8EBAMCAQYwHwYDVR0jBBgwFoAU8BdiE1U9s/8KAGv7UISX8+1i0BowHQYDVR0OBBYEFPAXYhNVPbP/CgBr+1CEl/PtYtAaMAwGA1UdEwQFMAMBAf8wGQYJKoZIhvZ9B0EABAwwChsEVjQuMAMCBJAwDQYJKoZIhvcNAQEFBQADgYEAkNwwAvpkdMKnCqV8IY00F6j7Rw7/JXyNEwr75Ji174z4xRAN95K+8cPV1ZVqBLssziY2ZcgxxufuP+NXdYR6Ee9GTxj005i7qIcyunL2POI9n9cd2cNgQ4xYDiKWL2KjLB+6rQXvqzJ4h6BUcxm1XAX5Uj5tLUUL9wqT6u0G+bI=";
    private int F = 0;
    private static final char G = ':';

    public void deleteCertReq(X500Principal x500Principal) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        if (!this.e()) {
            throw new IOException("Cannot modify AL wallet.");
        }
        if (this.y == null) {
            this.C = this.d();
        }
        this.internalRemoveCertReq(x500Principal);
        if (this.y == null) {
            this.C = this.m(this.C);
        }
    }

    public void internalRemoveTrustedCert(X500Principal x500Principal) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.b("OracleWallet: internalRemoveTrustedCert");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.q != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.q);
        }
        oracleKeyStoreSpi = this.y != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.y);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        this.q = oracleKeyStoreSpi.f((InputStream)byteArrayInputStream, this.y, x500Principal);
    }

    public String[] getTrustpointInfo(int n, String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        String[] stringArray = new String[12];
        Vector vector = new Vector();
        if (n != 0) {
            throw new IOException("No persona with index=" + n + " in wallet.");
        }
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = null;
        enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            OraclePKIX509CertImpl oraclePKIX509CertImpl;
            String string2 = enumeration.nextElement();
            if (!keyStore.isCertificateEntry(string2) || (oraclePKIX509CertImpl = (OraclePKIX509CertImpl)keyStore.getCertificate(string2)) == null || !string.equals(string2)) continue;
            stringArray[0] = ((Object)oraclePKIX509CertImpl.getSubjectDN()).toString();
            stringArray[1] = ((Object)oraclePKIX509CertImpl.getIssuerDN()).toString();
            stringArray[2] = Integer.toString(oraclePKIX509CertImpl.getVersion());
            stringArray[3] = oraclePKIX509CertImpl.getSerialNumber().toString();
            stringArray[4] = Integer.toString((int)(oraclePKIX509CertImpl.getNotBefore().getTime() / 1000L));
            stringArray[5] = Integer.toString((int)(oraclePKIX509CertImpl.getNotAfter().getTime() / 1000L));
            stringArray[6] = new Integer(((java.security.interfaces.RSAPublicKey)oraclePKIX509CertImpl.getPublicKey()).getModulus().bitLength()).toString();
            stringArray[7] = this.a(oraclePKIX509CertImpl.getKeyUsage());
            stringArray[8] = oraclePKIX509CertImpl.getSigAlgName();
            stringArray[9] = "MD5Digest";
            stringArray[10] = "SHADigest";
            stringArray[11] = Integer.toString(this.internalGetTCertCompNum(string));
            break;
        }
        return stringArray;
    }

    public String[] getCertInfo(int n, String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        String[] stringArray = new String[12];
        Vector vector = new Vector();
        if (n != 0) {
            throw new IOException("No persona with index=" + n + " in wallet.");
        }
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = null;
        enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            OraclePKIX509CertImpl oraclePKIX509CertImpl;
            String string2 = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string2) || (oraclePKIX509CertImpl = (OraclePKIX509CertImpl)keyStore.getCertificate(string2)) == null || !string.equals(string2)) continue;
            stringArray[0] = ((Object)oraclePKIX509CertImpl.getSubjectDN()).toString();
            stringArray[1] = ((Object)oraclePKIX509CertImpl.getIssuerDN()).toString();
            stringArray[2] = Integer.toString(oraclePKIX509CertImpl.getVersion());
            stringArray[3] = oraclePKIX509CertImpl.getSerialNumber().toString();
            stringArray[4] = Integer.toString((int)(oraclePKIX509CertImpl.getNotBefore().getTime() / 1000L));
            stringArray[5] = Integer.toString((int)(oraclePKIX509CertImpl.getNotAfter().getTime() / 1000L));
            stringArray[6] = new Integer(((java.security.interfaces.RSAPublicKey)oraclePKIX509CertImpl.getPublicKey()).getModulus().bitLength()).toString();
            stringArray[7] = this.a(oraclePKIX509CertImpl.getKeyUsage());
            stringArray[8] = oraclePKIX509CertImpl.getSigAlgName();
            stringArray[9] = "MD5Digest";
            stringArray[10] = "SHADigest";
            stringArray[11] = Integer.toString(this.internalGetCertCompNum(string));
            break;
        }
        return stringArray;
    }

    static {
        D = ResourceBundle.getBundle("oracle.security.pki.resources.OraclePKIMsg");
        z = "MIICNDCCAaECEAKtZn5ORf5eV288mBle3cAwDQYJKoZIhvcNAQECBQAwXzELMAkGA1UEBhMCVVMxIDAeBgNVBAoTF1JTQSBEYXRhIFNlY3VyaXR5LCBJbmMuMS4wLAYDVQQLEyVTZWN1cmUgU2VydmVyIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTk0MTEwOTAwMDAwMFoXDTEwMDEwNzIzNTk1OVowXzELMAkGA1UEBhMCVVMxIDAeBgNVBAoTF1JTQSBEYXRhIFNlY3VyaXR5LCBJbmMuMS4wLAYDVQQLEyVTZWN1cmUgU2VydmVyIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MIGbMA0GCSqGSIb3DQEBAQUAA4GJADCBhQJ+AJLOesGugz5aqomDV6wlAXYMra6OLDfO6zV4ZFQD5YRAUcm/jwjiioII0haGN1XpsSECrXZogZoFokvJSyVmIlZsiAeP94FZbYQHZXATcXY+m3dM41CJVphIuR2nKRoTLkoRWZweFdVJVCxzOmmCsZc5nG1wZ0jl3S3WyB57AgMBAAEwDQYJKoZIhvcNAQECBQADfgBl3X7hsuyw4jrg7HFGmhkRuNPHoLQDQCYCPgmc4RKz0Vr2N6W3YQO2WxZpO8ZECAyIUwxrl0nHPjXcbLm7qt9cuzovk2C2qUtN8iD3zV9/ZHuO3ABc1/p3yjkWWW8O6tO1g39NTUJWdrTJXwT4OPjr0l91X817/OWOgHz8UA==";
        B = "MIICPDCCAaUCEDJQM89Q0VbzXIGtZVxPyCUwDQYJKoZIhvcNAQECBQAwXzELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMTcwNQYDVQQLEy5DbGFzcyAxIFB1YmxpYyBQcmltYXJ5IENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTk2MDEyOTAwMDAwMFoXDTIwMDEwNzIzNTk1OVowXzELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMTcwNQYDVQQLEy5DbGFzcyAxIFB1YmxpYyBQcmltYXJ5IENlcnRpZmljYXRpb24gQXV0aG9yaXR5MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDlGb9to1ZhLZlIcfZn3rmN67eehoAKkQ76OCWvRoiC5XOooJskXQ0fzGVuDLDQVoQYh5oGmxChc9+0WDlrbsH2FdWoqD+qEgaNMax/sDTXjzRniAnNFBHiTkVWaR94AoDa3EeRKbs2yWNcxeDXLYd7obcysHswuiovMaruo2fa2wIDAQABMA0GCSqGSIb3DQEBAgUAA4GBAEtEZmBoZOSYG/OwcuaViXzde7OVwB0u2NgZ0C00PcZQmhCGjKo/O6gE/DdSlcPZydvN8oYGxLEb8IKIMEKOF1AcZHq4PplJdJf8rAJD+5YMVgQlDHx8h50kp9jwMim1pN9dokzFFjKoQvZFprY2ueC/ZTaTwtLXa9zeWdaiNfhF";
        t = "MIICPDCCAaUCEC0b/EoXjaOR6+f/9YtFvgswDQYJKoZIhvcNAQECBQAwXzELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMTcwNQYDVQQLEy5DbGFzcyAyIFB1YmxpYyBQcmltYXJ5IENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTk2MDEyOTAwMDAwMFoXDTI4MDgwMTIzNTk1OVowXzELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMTcwNQYDVQQLEy5DbGFzcyAyIFB1YmxpYyBQcmltYXJ5IENlcnRpZmljYXRpb24gQXV0aG9yaXR5MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQC2WoujDWojg4BrzzmH9CETMwZMJaLtVRKXxaeAufqDwSCg+i8VDXyhYGt+eSz6Bg86rvYbb7HS/y8oUl+DfUvEerf4Zh+AVPy3wo5ZShRXRtGak75BkQO7FYCTXOvnzAhsPz6zSvz/S2wj1VCCJkQZjiPDceoZJEcEnnW/yKYAHwIDAQABMA0GCSqGSIb3DQEBAgUAA4GBAIobK/o5wXTXXtgZZKJYSi034DNHD6zt96rbHuSLBlxgJ8pFUs4W7z8GZOeUaHxgMxURaa+dYo2jA1Rrpr7l7gUYYAS/QoD90KioHgE796Ncr6Pc5iaAIzy4RHT3Cq5Ji2F4zCS/iIqnDupzGUH9TQPwiNHleI2lKk/2lw0Xd8rY";
        n = "MIICPDCCAaUCEHC65B0Q2Sk0tjjKewPMur8wDQYJKoZIhvcNAQECBQAwXzELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMTcwNQYDVQQLEy5DbGFzcyAzIFB1YmxpYyBQcmltYXJ5IENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTk2MDEyOTAwMDAwMFoXDTI4MDgwMTIzNTk1OVowXzELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMTcwNQYDVQQLEy5DbGFzcyAzIFB1YmxpYyBQcmltYXJ5IENlcnRpZmljYXRpb24gQXV0aG9yaXR5MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDJXFme8huKARS0EN8EQNvjV69qRUCPhAwL0TPZ2RHP7gJYHyX3KqhEBarsAx94f56TuZoAqiN91qyFomNFx3InzPRMxnVx0jnvT0Lwdd8KkMaOIG+YD/isI19wKTakyYbnsZogy1Olhec9vn2a/iRFM9x2Fe0PonFkTGUugWhFpwIDAQABMA0GCSqGSIb3DQEBAgUAA4GBALtMEivPLCYATxQT3ab7/AoRhIzzKBxnki98tsX63/Dolbwdj2wsqFHMc9ikwFPwTtYmwHYBV4GSXiHx0bH/59AhWM1pF+NEHJwZRDmJXNycAA9WjQKZ7aKQRUzkuxCkPfAyAw7xzvjoyVGM5mKf5p/AfbdynMk2OmufTqj/ZA1k";
    }

    public static String getDefaultLocation() {
        return null;
    }

    public InputStream createCert(InputStream inputStream, int n) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        return this.createCert(inputStream, n, BigInteger.ZERO);
    }

    public void setLocation(String string) {
        this.r = string;
    }

    public OracleWallet() {
        this.g();
    }

    public void save() throws IOException {
        OraclePKIDebug.b("OracleWallet: saving " + this.q.length + " bytes.");
        String string = this.r;
        if (string == null) {
            string = this.A.e();
        }
        this.saveAs(string);
    }

    public int internalGetTCertCompNum(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.b("OracleWallet: internalGetCRCompNum");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.q != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.q);
        }
        oracleKeyStoreSpi = this.y != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.y);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        return oracleKeyStoreSpi.f((InputStream)byteArrayInputStream, this.y, string);
    }

    public void internalAddTrustedCert(OraclePKIX509CertImpl oraclePKIX509CertImpl, String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.b("OracleWallet: internalAddTrustedCert");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.q != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.q);
        }
        oracleKeyStoreSpi = this.y != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.y);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        this.q = oracleKeyStoreSpi.h(byteArrayInputStream, this.y, oraclePKIX509CertImpl, string);
    }

    public void migrateJKStoPKCS12(KeyStore keyStore, char[] cArray, String[] stringArray) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateEncodingException, CertificateException, UnrecoverableEntryException {
        OraclePKIDebug.b("OracleWallet: migrateJKStoPKCS12");
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                if (keyStore.entryInstanceOf(string, E == null ? OracleWallet.class$("java.security.KeyStore$PrivateKeyEntry") : E)) {
                    this.f(keyStore, cArray, string);
                    continue;
                }
                if (keyStore.entryInstanceOf(string, s == null ? OracleWallet.class$("java.security.KeyStore$TrustedCertificateEntry") : s)) {
                    this.j(keyStore, string);
                    continue;
                }
                if (keyStore.containsAlias(string)) continue;
                throw new IOException("Invalid alias : " + string);
            }
        } else {
            Enumeration<String> enumeration = keyStore.aliases();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                if (keyStore.entryInstanceOf(string, E == null ? OracleWallet.class$("java.security.KeyStore$PrivateKeyEntry") : E)) {
                    this.f(keyStore, cArray, string);
                    continue;
                }
                if (keyStore.entryInstanceOf(string, s == null ? OracleWallet.class$("java.security.KeyStore$TrustedCertificateEntry") : s)) {
                    this.j(keyStore, string);
                    continue;
                }
                if (keyStore.containsAlias(string)) continue;
                throw new IOException("Invalid alias : " + string);
            }
        }
    }

    public void importCertB64(String string, boolean bl) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        this.importCert(byteArrayInputStream, bl);
    }

    public int getCertReqCount(int n, boolean bl) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        int n2 = 0;
        if (n != 0) {
            throw new IOException("No persona with index=" + n + " in wallet.");
        }
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = null;
        enumeration = keyStore.aliases();
        boolean bl2 = false;
        while (enumeration.hasMoreElements()) {
            CertificateRequest certificateRequest;
            String string = enumeration.nextElement();
            if (bl) {
                if (!keyStore.isKeyEntry(string) || keyStore.getCertificate(string) != null || (certificateRequest = ((OraclePKIRSAPrivateKey)keyStore.getKey(string, null)).getCertificateRequest()) == null) continue;
                ++n2;
                continue;
            }
            if (!keyStore.isKeyEntry(string) || (certificateRequest = ((OraclePKIRSAPrivateKey)keyStore.getKey(string, null)).getCertificateRequest()) == null) continue;
            ++n2;
        }
        return n2;
    }

    public void saveAs(String string) throws IOException {
        if (string == null) {
            throw new IOException("wrl not specified.");
        }
        boolean bl = false;
        if (this.y == null) {
            this.y = new char[]{'t', 'e', 's', 't'};
            bl = true;
        }
        C18 c18 = this.b(string);
        if (bl) {
            Object object;
            Object object2;
            OraclePKIDebug.b("OracleWallet: saving sso (ALO) " + this.q.length + " bytes.");
            char[] cArray = null;
            try {
                object2 = new C05();
                object = new ByteArrayInputStream(this.q);
                boolean bl2 = ((C05)object2).c((InputStream)object);
                if (bl2) {
                    ((ByteArrayInputStream)object).reset();
                    cArray = ((C05)object2).k((InputStream)object);
                    if (this.C == null) {
                        this.C = cArray;
                    }
                    PKCS12 pKCS12 = new PKCS12(new String(cArray), (InputStream)object);
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(pKCS12.length());
                    pKCS12.output((OutputStream)byteArrayOutputStream);
                    this.q = byteArrayOutputStream.toByteArray();
                }
            }
            catch (IOException iOException) {
                throw new IOException(iOException.getMessage());
            }
            c18.d(this.q, this.C, true);
            this.y = null;
            object2 = null;
            try {
                object = new C05();
                object2 = ((C05)object).h(this.C, true);
            }
            catch (IOException iOException) {
                throw new IOException(iOException.getMessage());
            }
            object = new ByteArrayOutputStream(((Object)object2).length + this.q.length);
            ((OutputStream)object).write((byte[])object2);
            ((OutputStream)object).write(this.q);
            this.q = ((ByteArrayOutputStream)object).toByteArray();
        } else {
            OraclePKIDebug.b("OracleWallet: saving p12 (& sso (AL)) " + this.q.length + " bytes.");
            c18.f(this.q, this.y);
        }
        this.A = c18;
    }

    public Enumeration listAliases() throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.b("OracleWallet: listAliases");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.q != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.q);
        }
        oracleKeyStoreSpi = this.y != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.y);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        return oracleKeyStoreSpi.engineAliases();
    }

    public void deleteWallet() throws IOException {
        this.A.b();
    }

    private String a(boolean[] blArray) {
        return "SSL";
    }

    public InputStream getWalletArray(boolean bl) throws IOException {
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.y != null && !bl) {
            byteArrayInputStream = new ByteArrayInputStream(this.q);
        } else if (this.y != null && bl) {
            C05 c05 = new C05();
            ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(this.q);
            boolean bl2 = c05.j(byteArrayInputStream2);
            byteArrayInputStream = bl2 ? new ByteArrayInputStream(this.q) : (ByteArrayInputStream)this.i(false);
        } else if (this.y == null && bl) {
            byteArrayInputStream = new ByteArrayInputStream(this.q);
        } else {
            throw new IOException("Cannot create p12 without password.");
        }
        return byteArrayInputStream;
    }

    private C18 b(String string) throws IOException {
        if (string.indexOf(58) < 2) {
            string = x + string;
        }
        if (string.toLowerCase().startsWith(x)) {
            if (this.y == null) {
                return new C07(string.substring(x.length()));
            }
            return new C02(string.substring(x.length()));
        }
        throw new IOException("Unsupported WRL type" + string);
    }

    public X500Principal[] getCertReqDNs(int n, boolean bl) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        X500Principal[] x500PrincipalArray;
        Vector<X500Principal> vector = new Vector<X500Principal>();
        if (n != 0) {
            throw new IOException("No persona with index=" + n + " in wallet.");
        }
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = null;
        enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            CertificateRequest certificateRequest;
            x500PrincipalArray = enumeration.nextElement();
            if (bl) {
                if (!keyStore.isKeyEntry((String)x500PrincipalArray) || keyStore.getCertificate((String)x500PrincipalArray) != null || (certificateRequest = ((OraclePKIRSAPrivateKey)keyStore.getKey((String)x500PrincipalArray, null)).getCertificateRequest()) == null) continue;
                vector.add(new X500Principal(certificateRequest.getSubject().toString()));
                continue;
            }
            if (!keyStore.isKeyEntry((String)x500PrincipalArray) || (certificateRequest = ((OraclePKIRSAPrivateKey)keyStore.getKey((String)x500PrincipalArray, null)).getCertificateRequest()) == null) continue;
            vector.add(new X500Principal(certificateRequest.getSubject().toString()));
        }
        x500PrincipalArray = new X500Principal[vector.size()];
        int n2 = 0;
        Enumeration enumeration2 = vector.elements();
        while (enumeration2.hasMoreElements()) {
            x500PrincipalArray[n2] = (X500Principal)enumeration2.nextElement();
            ++n2;
        }
        return x500PrincipalArray;
    }

    public int getCertReqCount(int n) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        int n2 = 0;
        if (n != 0) {
            throw new IOException("No persona with index=" + n + " in wallet.");
        }
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = null;
        enumeration = keyStore.aliases();
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            CertificateRequest certificateRequest;
            String string = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string) || (certificateRequest = ((OraclePKIRSAPrivateKey)keyStore.getKey(string, null)).getCertificateRequest()) == null) continue;
            ++n2;
        }
        return n2;
    }

    public KeyStore getKeyStore() throws IOException {
        KeyStore keyStore = null;
        try {
            if (null == Security.getProvider("OraclePKI")) {
                Security.insertProviderAt(new OraclePKIProvider(), 1);
            }
            keyStore = this.y != null ? KeyStore.getInstance("PKCS12", "OraclePKI") : KeyStore.getInstance("SSO", "OraclePKI");
            ByteArrayInputStream byteArrayInputStream = null;
            if (this.q != null) {
                byteArrayInputStream = new ByteArrayInputStream(this.q);
            }
            keyStore.load(byteArrayInputStream, this.y);
        }
        catch (GeneralSecurityException generalSecurityException) {
            return null;
        }
        return keyStore;
    }

    public void addCertRequest(X500Principal x500Principal, int n) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        if (!this.e()) {
            throw new IOException("Cannot modify AL wallet.");
        }
        RSAKeyPairGenerator rSAKeyPairGenerator = new RSAKeyPairGenerator();
        rSAKeyPairGenerator.initialize(n, (RandomBitsSource)new SHA1RandomBitsSource());
        KeyPair keyPair = rSAKeyPairGenerator.generateKeyPair();
        RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)keyPair.getPrivate();
        RSAPublicKey rSAPublicKey = (RSAPublicKey)keyPair.getPublic();
        X500Name x500Name = new X500Name(x500Principal.toString());
        CertificateRequest certificateRequest = new CertificateRequest(x500Name, keyPair);
        if (this.y == null) {
            this.C = this.d();
        }
        this.internalAddCertReq(certificateRequest, rSAPrivateKey, null);
        if (this.y == null) {
            this.C = this.m(this.C);
        }
    }

    public InputStream exportCertReq(X500Principal x500Principal) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        String string = this.exportCertReqB64(x500Principal);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        return byteArrayInputStream;
    }

    public void setSecretStore(OracleSecretStore oracleSecretStore) throws IOException, OracleSecretStoreException {
        OraclePKIDebug.b("OracleWallet: setSecretStore");
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.q != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.q);
        }
        this.q = oracleSecretStore.setStoreInWallet(byteArrayInputStream, this.y);
    }

    OraclePKIX509CertImpl[] c(OraclePKIX509CertImpl[] oraclePKIX509CertImplArray) throws IOException {
        int n;
        int n2;
        int n3;
        OraclePKIX509CertImpl[] oraclePKIX509CertImplArray2 = new OraclePKIX509CertImpl[oraclePKIX509CertImplArray.length];
        Vector<OraclePKIX509CertImpl> vector = new Vector<OraclePKIX509CertImpl>(oraclePKIX509CertImplArray.length);
        Vector vector2 = new Vector(oraclePKIX509CertImplArray.length);
        for (n3 = 0; n3 < oraclePKIX509CertImplArray.length; ++n3) {
            vector.addElement(oraclePKIX509CertImplArray[n3]);
        }
        n3 = 0;
        for (n2 = 0; n2 < oraclePKIX509CertImplArray.length; ++n2) {
            OraclePKIPrincipalImpl oraclePKIPrincipalImpl;
            OraclePKIPrincipalImpl oraclePKIPrincipalImpl2 = (OraclePKIPrincipalImpl)((OraclePKIX509CertImpl)vector.get(n2)).getIssuerDN();
            if (!oraclePKIPrincipalImpl2.equals(oraclePKIPrincipalImpl = (OraclePKIPrincipalImpl)((OraclePKIX509CertImpl)vector.get(n2)).getSubjectDN())) continue;
            System.out.println("Added as self-signed: SubjectDN=" + ((OraclePKIPrincipalImpl)((OraclePKIX509CertImpl)vector.get(n2)).getSubjectDN()).toString());
            System.out.println("                    : IssuerDN=" + ((OraclePKIPrincipalImpl)((OraclePKIX509CertImpl)vector.get(n2)).getIssuerDN()).toString());
            n3 = 1;
            vector2.addElement(vector.get(n2));
            vector.remove(n2);
            break;
        }
        if (n3 == 0) {
            throw new IOException("No self-signed cert in chain.");
        }
        n2 = 0;
        block2: do {
            n2 = 0;
            for (n = 0; n < vector.size(); ++n) {
                if (!((Object)((OraclePKIX509CertImpl)vector.get(n)).getIssuerDN()).equals(((OraclePKIX509CertImpl)vector2.lastElement()).getSubjectDN())) continue;
                System.out.println("Added as trustpoint: SubjectDN=" + ((OraclePKIPrincipalImpl)((OraclePKIX509CertImpl)vector.get(n)).getSubjectDN()).toString());
                System.out.println("                   : IssuerDN=" + ((OraclePKIPrincipalImpl)((OraclePKIX509CertImpl)vector.get(n)).getIssuerDN()).toString());
                n2 = 1;
                vector2.addElement(vector.get(n));
                vector.remove(n);
                continue block2;
            }
        } while (n2 != 0);
        if (vector.size() != 0 || vector2.size() != oraclePKIX509CertImplArray.length) {
            throw new IOException("Could not form complete chain.");
        }
        for (n = 0; n < oraclePKIX509CertImplArray.length; ++n) {
            oraclePKIX509CertImplArray2[n] = (OraclePKIX509CertImpl)vector2.get(n);
        }
        return oraclePKIX509CertImplArray2;
    }

    public byte[] getPPvtBytes(int n, String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, CertificateException {
        byte[] byArray = null;
        if (n != 0) {
            throw new IOException("No persona with index=" + n + " in wallet.");
        }
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = null;
        Object var6_6 = null;
        enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            OraclePKIRSAPrivateKey oraclePKIRSAPrivateKey;
            String string2 = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string2) || (oraclePKIRSAPrivateKey = (OraclePKIRSAPrivateKey)keyStore.getKey(string2, null)) == null || !string.equals(string2)) continue;
            byArray = oraclePKIRSAPrivateKey.getEncoded();
            break;
        }
        return new String("").getBytes();
    }

    public void openDefault(char[] cArray) throws IOException {
        String string = "";
        this.open(string, cArray);
        throw new IOException("not implemented");
    }

    private char[] d() throws IOException {
        char[] cArray = null;
        if (this.y == null) {
            C05 c05 = new C05();
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.q);
                cArray = c05.k(byteArrayInputStream);
            }
            catch (IOException iOException) {
                this.g();
                throw new IOException(iOException.getMessage());
            }
        }
        return cArray;
    }

    public String[] getPPvtInfo(int n, String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, CertificateException {
        String[] stringArray = new String[2];
        Vector vector = new Vector();
        if (n != 0) {
            throw new IOException("No persona with index=" + n + " in wallet.");
        }
        int n2 = this.internalGetCRCompNum(string);
        stringArray[0] = Integer.toString(n2);
        stringArray[1] = Integer.toString(-1);
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = null;
        Object var8_8 = null;
        enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            CertificateRequest certificateRequest;
            String string2 = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string2) || (certificateRequest = ((OraclePKIRSAPrivateKey)keyStore.getKey(string2, null)).getCertificateRequest()) == null || !string.equals(string2)) continue;
            OraclePKIX509CertImpl oraclePKIX509CertImpl = (OraclePKIX509CertImpl)keyStore.getCertificate(string2);
            if (oraclePKIX509CertImpl != null) {
                stringArray[1] = Integer.toString(2);
                break;
            }
            stringArray[1] = Integer.toString(1);
            break;
        }
        return stringArray;
    }

    public String exportCertB64(X500Principal x500Principal) throws IOException, KeyStoreException, CertificateEncodingException {
        String string = null;
        KeyStore keyStore = this.getKeyStore();
        X500Name x500Name = new X500Name(x500Principal.toString());
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            String string2;
            String string3 = enumeration.nextElement();
            OraclePKIX509CertImpl oraclePKIX509CertImpl = (OraclePKIX509CertImpl)keyStore.getCertificate(string3);
            if (oraclePKIX509CertImpl == null || !(string2 = ((Object)oraclePKIX509CertImpl.getSubjectDN()).toString().toUpperCase()).startsWith(x500Name.toString().toUpperCase())) continue;
            BASE64Encoder bASE64Encoder = new BASE64Encoder();
            byte[] byArray = oraclePKIX509CertImpl.getEncoded();
            string = "-----BEGIN CERTIFICATE-----\n" + bASE64Encoder.encodeBuffer(byArray) + o;
            break;
        }
        return string;
    }

    public void create(char[] cArray) throws IOException {
        this.g();
        if (cArray != null) {
            this.y = new char[cArray.length];
            System.arraycopy(cArray, 0, this.y, 0, cArray.length);
        }
        this.q = null;
        this.A = new C13();
        KeyStore keyStore = this.getKeyStore();
        this.k(keyStore);
    }

    private boolean e() throws IOException {
        boolean bl = true;
        if (this.y == null) {
            try {
                C05 c05 = new C05();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.q);
                boolean bl2 = c05.c(byteArrayInputStream);
                if (!bl2) {
                    bl = false;
                }
            }
            catch (IOException iOException) {
                throw new IOException(iOException.getMessage());
            }
        }
        return bl;
    }

    public int internalGetCRCompNum(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        OraclePKIDebug.b("OracleWallet: internalGetCRCompNum");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.q != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.q);
        }
        oracleKeyStoreSpi = this.y != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.y);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        return oracleKeyStoreSpi.w(byteArrayInputStream, this.y, string);
    }

    public void removeTrustpoint(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        if (!this.e()) {
            throw new IOException("Cannot modify AL wallet.");
        }
        if (this.y == null) {
            this.C = this.d();
        }
        this.internalRemoveTrustedCert(string);
        if (this.y == null) {
            this.C = this.m(this.C);
        }
    }

    public void removeTrustpoint(X500Principal x500Principal) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        if (!this.e()) {
            throw new IOException("Cannot modify AL wallet.");
        }
        if (this.y == null) {
            this.C = this.d();
        }
        this.internalRemoveTrustedCert(x500Principal);
        if (this.y == null) {
            this.C = this.m(this.C);
        }
    }

    public void setWalletRioType(int n) {
        this.F = n;
    }

    public void deleteCert(X500Principal x500Principal) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        if (!this.e()) {
            throw new IOException("Cannot modify AL wallet.");
        }
        if (this.y == null) {
            this.C = this.d();
        }
        this.internalRemoveUserCert(x500Principal);
        if (this.y == null) {
            this.C = this.m(this.C);
        }
    }

    public String exportTrustedB64(String string) throws IOException, KeyStoreException, CertificateEncodingException {
        String string2 = null;
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            OraclePKIX509CertImpl oraclePKIX509CertImpl;
            String string3 = enumeration.nextElement();
            if (!keyStore.isCertificateEntry(string3) || (oraclePKIX509CertImpl = (OraclePKIX509CertImpl)keyStore.getCertificate(string3)) == null || !string.equals(string3)) continue;
            BASE64Encoder bASE64Encoder = new BASE64Encoder();
            byte[] byArray = oraclePKIX509CertImpl.getEncoded();
            string2 = "-----BEGIN CERTIFICATE-----\n" + bASE64Encoder.encodeBuffer(byArray) + o;
            break;
        }
        return string2;
    }

    void f(KeyStore keyStore, char[] cArray, String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateEncodingException, CertificateException, UnrecoverableEntryException {
        if (!this.e()) {
            throw new IOException("Cannot modify AL wallet.");
        }
        if (this.y == null) {
            this.C = this.d();
        }
        KeyStore.PasswordProtection passwordProtection = new KeyStore.PasswordProtection(cArray);
        KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(string, passwordProtection);
        PrivateKey privateKey = privateKeyEntry.getPrivateKey();
        X509Certificate x509Certificate = (X509Certificate)privateKeyEntry.getCertificate();
        X509Certificate[] x509CertificateArray = (X509Certificate[])privateKeyEntry.getCertificateChain();
        PublicKey publicKey = x509Certificate.getPublicKey();
        RSAPrivateKey rSAPrivateKey = new RSAPrivateKey(privateKey.getEncoded());
        RSAPublicKey rSAPublicKey = new RSAPublicKey(publicKey.getEncoded());
        KeyPair keyPair = new KeyPair((oracle.security.crypto.core.PublicKey)rSAPublicKey, (oracle.security.crypto.core.PrivateKey)rSAPrivateKey);
        OraclePKIX509CertImpl[] oraclePKIX509CertImplArray = new OraclePKIX509CertImpl[x509CertificateArray.length];
        for (int i = 0; i < x509CertificateArray.length; ++i) {
            oraclePKIX509CertImplArray[i] = new OraclePKIX509CertImpl(new X509(x509CertificateArray[i].getEncoded()));
        }
        OraclePKIX509CertImpl[] oraclePKIX509CertImplArray2 = this.c(oraclePKIX509CertImplArray);
        if (oraclePKIX509CertImplArray2.length > 1) {
            for (int i = 0; i < oraclePKIX509CertImplArray2.length - 1; ++i) {
                try {
                    String string2 = keyStore.getCertificateAlias(oraclePKIX509CertImplArray2[i]);
                    this.internalAddTrustedCert(oraclePKIX509CertImplArray2[i], string2);
                    if (this.y != null) continue;
                    this.C = this.m(this.C);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            X500Principal x500Principal = x509Certificate.getSubjectX500Principal();
            this.l(x500Principal, keyPair, rSAPrivateKey, string);
            this.internalAddUserCert(oraclePKIX509CertImplArray2[oraclePKIX509CertImplArray2.length - 1], string);
            if (this.y == null) {
                this.C = this.m(this.C);
            }
        } else {
            try {
                this.internalAddTrustedCert(oraclePKIX509CertImplArray[0], string);
                if (this.y == null) {
                    this.C = this.m(this.C);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            X500Principal x500Principal = x509Certificate.getSubjectX500Principal();
            int n = 1;
            string = string + ' ' + Integer.toString(n);
            this.l(x500Principal, keyPair, rSAPrivateKey, string);
            this.internalAddUserCert(oraclePKIX509CertImplArray[0], string);
            if (this.y == null) {
                this.C = this.m(this.C);
            }
        }
    }

    public String[] getPPvtAliases(int n) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        String[] stringArray;
        Vector<String[]> vector = new Vector<String[]>();
        if (n != 0) {
            throw new IOException("No persona with index=" + n + " in wallet.");
        }
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = null;
        enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            CertificateRequest certificateRequest;
            stringArray = enumeration.nextElement();
            if (!keyStore.isKeyEntry((String)stringArray) || (certificateRequest = ((OraclePKIRSAPrivateKey)keyStore.getKey((String)stringArray, null)).getCertificateRequest()) == null) continue;
            vector.add(stringArray);
        }
        stringArray = new String[vector.size()];
        int n2 = 0;
        Enumeration enumeration2 = vector.elements();
        while (enumeration2.hasMoreElements()) {
            stringArray[n2] = (String)enumeration2.nextElement();
            ++n2;
        }
        return stringArray;
    }

    public String[] getCertReqInfo(int n, int n2) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        String[] stringArray = new String[4];
        if (n != 0) {
            throw new IOException("No persona with index=" + n + " in wallet.");
        }
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = null;
        enumeration = keyStore.aliases();
        int n3 = 0;
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string)) continue;
            CertificateRequest certificateRequest = ((OraclePKIRSAPrivateKey)keyStore.getKey(string, null)).getCertificateRequest();
            if (certificateRequest != null && n2 == n3) {
                stringArray[0] = certificateRequest.getSubject().toString();
                stringArray[1] = new Integer(((RSAPublicKey)certificateRequest.getPublicKey()).modulusLength() * 8).toString();
                stringArray[2] = new String(certificateRequest.getPublicKey().getAlgorithm());
                stringArray[3] = new String(string);
                break;
            }
            ++n3;
        }
        return stringArray;
    }

    public X500Principal[] getTrustpointDNs(int n) throws IOException, KeyStoreException {
        X500Principal[] x500PrincipalArray;
        Vector<X500Principal> vector = new Vector<X500Principal>();
        if (n != 0) {
            throw new IOException("No persona with index=" + n + " in wallet.");
        }
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            OraclePKIX509CertImpl oraclePKIX509CertImpl;
            x500PrincipalArray = enumeration.nextElement();
            if (!keyStore.isCertificateEntry((String)x500PrincipalArray) || (oraclePKIX509CertImpl = (OraclePKIX509CertImpl)keyStore.getCertificate((String)x500PrincipalArray)) == null) continue;
            vector.add(new X500Principal(((Object)oraclePKIX509CertImpl.getSubjectDN()).toString()));
        }
        x500PrincipalArray = new X500Principal[vector.size()];
        int n2 = 0;
        Enumeration enumeration2 = vector.elements();
        while (enumeration2.hasMoreElements()) {
            x500PrincipalArray[n2] = (X500Principal)enumeration2.nextElement();
            ++n2;
        }
        return x500PrincipalArray;
    }

    public void deleteCert(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        if (!this.e()) {
            throw new IOException("Cannot modify AL wallet.");
        }
        if (this.y == null) {
            this.C = this.d();
        }
        this.internalRemoveUserCert(string);
        if (this.y == null) {
            this.C = this.m(this.C);
        }
    }

    private void g() {
        this.y = null;
        this.r = null;
        this.q = null;
        this.A = null;
    }

    public void setKeyStore(KeyStore keyStore) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.b("OracleWallet: setKeyStore");
        OracleKeyStoreSpi oracleKeyStoreSpi = new OracleKeyStoreSpi();
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.q != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.q);
        }
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.y);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        this.q = oracleKeyStoreSpi.d(byteArrayInputStream, keyStore, this.y);
    }

    public void internalRemoveCertReq(X500Principal x500Principal) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        OraclePKIDebug.b("OracleWallet: internalRemoveUserCertReq");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.q != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.q);
        }
        oracleKeyStoreSpi = this.y != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.y);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        this.q = oracleKeyStoreSpi.c(byteArrayInputStream, this.y, x500Principal);
    }

    public void removeTrustpoints() throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        if (!this.e()) {
            throw new IOException("Cannot modify AL wallet.");
        }
        if (this.y == null) {
            this.C = this.d();
        }
        this.internalRemoveAllTrusted();
        if (this.y == null) {
            this.C = this.m(this.C);
        }
    }

    public InputStream exportCertChain(X500Principal x500Principal) throws IOException, KeyStoreException, CertificateException {
        String string = this.exportCertChainB64(x500Principal);
        return new ByteArrayInputStream(string.getBytes());
    }

    public String[] getTrustpointAliases(int n) throws IOException, KeyStoreException {
        String[] stringArray;
        Vector<String[]> vector = new Vector<String[]>();
        if (n != 0) {
            throw new IOException("No persona with index=" + n + " in wallet.");
        }
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            OraclePKIX509CertImpl oraclePKIX509CertImpl;
            stringArray = enumeration.nextElement();
            if (!keyStore.isCertificateEntry((String)stringArray) || (oraclePKIX509CertImpl = (OraclePKIX509CertImpl)keyStore.getCertificate((String)stringArray)) == null) continue;
            vector.add(stringArray);
        }
        stringArray = new String[vector.size()];
        int n2 = 0;
        Enumeration enumeration2 = vector.elements();
        while (enumeration2.hasMoreElements()) {
            stringArray[n2] = (String)enumeration2.nextElement();
            ++n2;
        }
        return stringArray;
    }

    public void open(String string, char[] cArray) throws IOException {
        this.g();
        if (cArray != null) {
            this.y = new char[cArray.length];
            System.arraycopy(cArray, 0, this.y, 0, cArray.length);
        }
        try {
            this.A = this.b(string);
            this.q = this.A.g();
            OraclePKIDebug.b("Oracle Wallet: wallet size " + this.q.length);
            if (this.y == null) {
                C05 c05 = new C05();
                try {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.q);
                    this.C = c05.k(byteArrayInputStream);
                }
                catch (IOException iOException) {
                    this.g();
                    throw new IOException(iOException.getMessage());
                }
            }
            try {
                this.getSecretStore();
            }
            catch (Throwable throwable) {
                OraclePKIDebug.b("OracleWallet: " + throwable.toString());
                this.g();
                throw new IOException("Check password");
            }
        }
        catch (Throwable throwable) {
            this.g();
            throw new IOException("Could not open wallet. " + throwable.getMessage());
        }
    }

    private C18 h() throws IOException {
        if (this.y == null) {
            return new C07(null);
        }
        return new C02(null);
    }

    public int getPersonaCount() {
        return 1;
    }

    public X500Principal[] getCertDNs(int n) throws IOException, KeyStoreException {
        X500Principal[] x500PrincipalArray;
        Vector<X500Principal> vector = new Vector<X500Principal>();
        if (n != 0) {
            throw new IOException("No persona with index=" + n + " in wallet.");
        }
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = null;
        enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            OraclePKIX509CertImpl oraclePKIX509CertImpl;
            x500PrincipalArray = enumeration.nextElement();
            if (!keyStore.isKeyEntry((String)x500PrincipalArray) || (oraclePKIX509CertImpl = (OraclePKIX509CertImpl)keyStore.getCertificate((String)x500PrincipalArray)) == null) continue;
            vector.add(new X500Principal(((Object)oraclePKIX509CertImpl.getSubjectDN()).toString()));
        }
        x500PrincipalArray = new X500Principal[vector.size()];
        int n2 = 0;
        Enumeration enumeration2 = vector.elements();
        while (enumeration2.hasMoreElements()) {
            x500PrincipalArray[n2] = (X500Principal)enumeration2.nextElement();
            ++n2;
        }
        return x500PrincipalArray;
    }

    public X509Certificate getSSLCert(boolean bl) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        X509Certificate x509Certificate = null;
        String string = null;
        KeyStore keyStore = null;
        keyStore = this.getKeyStore();
        String string2 = "OracleX509";
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(string2);
        keyManagerFactory.init(keyStore, this.y);
        KeyManager[] keyManagerArray = keyManagerFactory.getKeyManagers();
        String[] stringArray = new String[]{"RSA"};
        Principal[] principalArray = this.getTrustpointDNs(0);
        string = bl ? ((X509KeyManager)keyManagerArray[0]).chooseServerAlias(stringArray[0], principalArray, null) : ((X509KeyManager)keyManagerArray[0]).chooseClientAlias(stringArray, principalArray, null);
        x509Certificate = (X509Certificate)keyStore.getCertificate(string);
        return x509Certificate;
    }

    public void internalRemoveTrustedCert(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.b("OracleWallet: internalRemoveTrustedCert");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.q != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.q);
        }
        oracleKeyStoreSpi = this.y != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.y);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        this.q = oracleKeyStoreSpi.e((InputStream)byteArrayInputStream, this.y, string);
    }

    private InputStream i(boolean bl) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.q);
        char[] cArray = null;
        byte[] byArray = new byte[1024];
        byte[] byArray2 = null;
        C05 c05 = new C05();
        try {
            cArray = c05.e(byArray);
            byArray2 = c05.h(cArray, bl);
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
        byteArrayOutputStream.write(byArray2);
        PKCS12 pKCS12 = new PKCS12(new String(this.y), (InputStream)byteArrayInputStream);
        pKCS12.setPassword(new String(cArray));
        Vector vector = pKCS12.getAuthSafes();
        for (int i = 0; i < vector.size(); ++i) {
            ((PKCS12Safe)vector.elementAt(i)).setPassword(new String(cArray));
        }
        try {
            pKCS12.output((OutputStream)byteArrayOutputStream);
            OraclePKIDebug.b("Verifying wallet " + pKCS12.verify());
        }
        catch (AuthenticationException authenticationException) {
            OraclePKIDebug.b("Verifying wallet failed" + (Object)((Object)authenticationException));
            throw new IOException("Could not create SSO wallet from p12" + (Object)((Object)authenticationException));
        }
        byte[] byArray3 = byteArrayOutputStream.toByteArray();
        return new ByteArrayInputStream(byArray3);
    }

    void j(KeyStore keyStore, String string) throws IOException, KeyStoreException, CertificateEncodingException {
        if (!this.e()) {
            throw new IOException("Cannot modify AL wallet.");
        }
        if (this.y == null) {
            this.C = this.d();
        }
        X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(string);
        OraclePKIX509CertImpl oraclePKIX509CertImpl = new OraclePKIX509CertImpl(new X509(x509Certificate.getEncoded()));
        try {
            this.internalAddTrustedCert(oraclePKIX509CertImpl, string);
            if (this.y == null) {
                this.C = this.m(this.C);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void k(KeyStore keyStore) throws IOException {
        OraclePKIX509CertImpl oraclePKIX509CertImpl = new OraclePKIX509CertImpl(new X509(new BASE64Decoder().decodeBuffer(B)));
        OraclePKIX509CertImpl oraclePKIX509CertImpl2 = new OraclePKIX509CertImpl(new X509(new BASE64Decoder().decodeBuffer(t)));
        OraclePKIX509CertImpl oraclePKIX509CertImpl3 = new OraclePKIX509CertImpl(new X509(new BASE64Decoder().decodeBuffer(n)));
        OraclePKIX509CertImpl oraclePKIX509CertImpl4 = new OraclePKIX509CertImpl(new X509(new BASE64Decoder().decodeBuffer(z)));
        OraclePKIX509CertImpl oraclePKIX509CertImpl5 = new OraclePKIX509CertImpl(new X509(new BASE64Decoder().decodeBuffer(GTE_CYBERTRUSTGLOBAL_CERT)));
        OraclePKIX509CertImpl oraclePKIX509CertImpl6 = new OraclePKIX509CertImpl(new X509(new BASE64Decoder().decodeBuffer(ENTRUST_PREMIUM_CERT)));
        OraclePKIX509CertImpl oraclePKIX509CertImpl7 = new OraclePKIX509CertImpl(new X509(new BASE64Decoder().decodeBuffer(ENTRUST_GLOBAL_CERT)));
        OraclePKIX509CertImpl oraclePKIX509CertImpl8 = new OraclePKIX509CertImpl(new X509(new BASE64Decoder().decodeBuffer(ENTRUST_MAIN_CERT)));
        try {
            keyStore.setCertificateEntry(oraclePKIX509CertImpl4.getSubjectDN().getName(), oraclePKIX509CertImpl4);
            keyStore.setCertificateEntry(oraclePKIX509CertImpl.getSubjectDN().getName(), oraclePKIX509CertImpl);
            keyStore.setCertificateEntry(oraclePKIX509CertImpl2.getSubjectDN().getName(), oraclePKIX509CertImpl2);
            keyStore.setCertificateEntry(oraclePKIX509CertImpl3.getSubjectDN().getName(), oraclePKIX509CertImpl3);
            keyStore.setCertificateEntry(oraclePKIX509CertImpl5.getSubjectDN().getName(), oraclePKIX509CertImpl5);
            keyStore.setCertificateEntry(oraclePKIX509CertImpl6.getSubjectDN().getName(), oraclePKIX509CertImpl6);
            keyStore.setCertificateEntry(oraclePKIX509CertImpl7.getSubjectDN().getName(), oraclePKIX509CertImpl7);
            keyStore.setCertificateEntry(oraclePKIX509CertImpl8.getSubjectDN().getName(), oraclePKIX509CertImpl8);
            this.setKeyStore(keyStore);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new IOException();
        }
    }

    public InputStream createCert(InputStream inputStream, int n, BigInteger bigInteger) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        Object object;
        CertificateRequest certificateRequest = new CertificateRequest(inputStream);
        KeyStore keyStore = this.getKeyStore();
        RSAPrivateKey rSAPrivateKey = null;
        X509 x509 = null;
        X509 x5092 = null;
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            if (!keyStore.isKeyEntry((String)object)) continue;
            rSAPrivateKey = new RSAPrivateKey(keyStore.getKey((String)object, null).getEncoded());
            x509 = ((OraclePKIX509CertImpl)keyStore.getCertificate((String)object)).getX509();
            break;
        }
        if (rSAPrivateKey == null || x509 == null) {
            throw new IOException("No valid key/certificate found in wallet");
        }
        try {
            x5092 = new X509(certificateRequest, x509, rSAPrivateKey, bigInteger, n);
        }
        catch (SignatureException signatureException) {
            IOException iOException = new IOException("Unable to create certificate");
            iOException.initCause(signatureException);
            throw iOException;
        }
        object = null;
        BASE64Encoder bASE64Encoder = new BASE64Encoder();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        x5092.output((OutputStream)byteArrayOutputStream);
        String string = "-----BEGIN CERTIFICATE-----\n" + bASE64Encoder.encodeBuffer(byteArrayOutputStream.toByteArray()) + o;
        byte[] byArray = string.getBytes();
        object = new ByteArrayInputStream(byArray);
        return object;
    }

    public void deleteCertReq(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        if (!this.e()) {
            throw new IOException("Cannot modify AL wallet.");
        }
        if (this.y == null) {
            this.C = this.d();
        }
        this.internalRemoveCertReq(string);
        if (this.y == null) {
            this.C = this.m(this.C);
        }
    }

    public void importCert(InputStream inputStream, boolean bl) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        if (!this.e()) {
            throw new IOException(D.getString("AL_MODIFY_ERROR"));
        }
        if (this.y == null) {
            this.C = this.d();
        }
        OraclePKIX509CertImpl[] oraclePKIX509CertImplArray = OraclePKIGenFunc.readCertsAt(inputStream);
        if (bl) {
            for (int i = 0; i < oraclePKIX509CertImplArray.length; ++i) {
                this.internalAddTrustedCert(oraclePKIX509CertImplArray[i], null);
            }
        } else if (oraclePKIX509CertImplArray.length > 1) {
            OraclePKIX509CertImpl[] oraclePKIX509CertImplArray2 = this.c(oraclePKIX509CertImplArray);
            for (int i = 0; i < oraclePKIX509CertImplArray2.length - 1; ++i) {
                this.internalAddTrustedCert(oraclePKIX509CertImplArray2[i], null);
            }
            this.internalAddUserCert(oraclePKIX509CertImplArray2[oraclePKIX509CertImplArray2.length - 1], null);
        } else {
            this.internalAddUserCert(oraclePKIX509CertImplArray[0], null);
        }
        if (this.y == null) {
            this.C = this.m(this.C);
        }
    }

    public String[] getCertReqAliases(int n) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        String[] stringArray;
        Vector<String[]> vector = new Vector<String[]>();
        if (n != 0) {
            throw new IOException("No persona with index=" + n + " in wallet.");
        }
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = null;
        enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            CertificateRequest certificateRequest;
            stringArray = enumeration.nextElement();
            if (!keyStore.isKeyEntry((String)stringArray) || (certificateRequest = ((OraclePKIRSAPrivateKey)keyStore.getKey((String)stringArray, null)).getCertificateRequest()) == null) continue;
            vector.add(stringArray);
        }
        stringArray = new String[vector.size()];
        int n2 = 0;
        Enumeration enumeration2 = vector.elements();
        while (enumeration2.hasMoreElements()) {
            stringArray[n2] = (String)enumeration2.nextElement();
            ++n2;
        }
        return stringArray;
    }

    public X500Principal[] getCertReqDNs(int n) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        X500Principal[] x500PrincipalArray;
        Vector<X500Principal> vector = new Vector<X500Principal>();
        if (n != 0) {
            throw new IOException("No persona with index=" + n + " in wallet.");
        }
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = null;
        enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            CertificateRequest certificateRequest;
            x500PrincipalArray = enumeration.nextElement();
            if (!keyStore.isKeyEntry((String)x500PrincipalArray) || (certificateRequest = ((OraclePKIRSAPrivateKey)keyStore.getKey((String)x500PrincipalArray, null)).getCertificateRequest()) == null) continue;
            vector.add(new X500Principal(certificateRequest.getSubject().toString()));
        }
        x500PrincipalArray = new X500Principal[vector.size()];
        int n2 = 0;
        Enumeration enumeration2 = vector.elements();
        while (enumeration2.hasMoreElements()) {
            x500PrincipalArray[n2] = (X500Principal)enumeration2.nextElement();
            ++n2;
        }
        return x500PrincipalArray;
    }

    public Enumeration getWalletPersonas() {
        Hashtable<String, OracleWalletPersona> hashtable = new Hashtable<String, OracleWalletPersona>();
        OracleWalletPersona oracleWalletPersona = new OracleWalletPersona(this);
        hashtable.put("one", oracleWalletPersona);
        return hashtable.elements();
    }

    public void internalRemoveUserCert(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.b("OracleWallet: internalRemoveUserCert");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.q != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.q);
        }
        oracleKeyStoreSpi = this.y != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.y);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        this.q = oracleKeyStoreSpi.o(byteArrayInputStream, this.y, string);
    }

    public void internalRemoveUserCert(X500Principal x500Principal) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.b("OracleWallet: internalRemoveUserCert");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.q != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.q);
        }
        oracleKeyStoreSpi = this.y != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.y);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        this.q = oracleKeyStoreSpi.e((InputStream)byteArrayInputStream, this.y, x500Principal);
    }

    public static boolean isValidPassword(char[] cArray) {
        String string = new String(cArray);
        int n = 8;
        boolean bl = false;
        boolean bl2 = false;
        if (string == null || string.length() <= 0) {
            return false;
        }
        if (string.length() < 8) {
            return false;
        }
        int n2 = string.length();
        Character c = new Character('i');
        for (int i = 0; !(i >= n2 || bl && bl2); ++i) {
            if (Character.isLetter(string.charAt(i))) {
                bl = true;
                continue;
            }
            bl2 = true;
        }
        return bl && bl2;
    }

    public X509Certificate getTrustpoint(int n, int n2) throws IOException, KeyStoreException, CertificateException {
        if (n != 0) {
            throw new IOException("No persona with index=" + n + " in wallet.");
        }
        Object var3_3 = null;
        X509Certificate x509Certificate = null;
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        int n3 = 0;
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            if (!keyStore.isCertificateEntry(string)) continue;
            OraclePKIX509CertImpl oraclePKIX509CertImpl = (OraclePKIX509CertImpl)keyStore.getCertificate(string);
            if (oraclePKIX509CertImpl != null && n2 == n3) {
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(oraclePKIX509CertImpl.getEncoded()));
                break;
            }
            ++n3;
        }
        return x509Certificate;
    }

    public void internalAddUserCert(OraclePKIX509CertImpl oraclePKIX509CertImpl, String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.b("OracleWallet: internalAddUserCert");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.q != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.q);
        }
        oracleKeyStoreSpi = this.y != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.y);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        this.q = oracleKeyStoreSpi.j(byteArrayInputStream, this.y, oraclePKIX509CertImpl, string);
    }

    public boolean isTrustedCertUsedInChain(X500Principal x500Principal) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.b("OracleWallet: isTrustedCertUsedInChain");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.q != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.q);
        }
        oracleKeyStoreSpi = this.y != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.y);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        return oracleKeyStoreSpi.y(x500Principal);
    }

    public void createSelfSigned(X500Principal x500Principal, int n, int n2, BigInteger bigInteger) throws IOException {
        if (!this.e()) {
            throw new IOException("Cannot modify AL wallet.");
        }
        RSAKeyPairGenerator rSAKeyPairGenerator = new RSAKeyPairGenerator();
        rSAKeyPairGenerator.initialize(n, (RandomBitsSource)new SHA1RandomBitsSource());
        KeyPair keyPair = rSAKeyPairGenerator.generateKeyPair();
        RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)keyPair.getPrivate();
        RSAPublicKey rSAPublicKey = (RSAPublicKey)keyPair.getPublic();
        X500Name x500Name = new X500Name(x500Principal.toString());
        CertificateRequest certificateRequest = new CertificateRequest(x500Name, keyPair);
        OraclePKIX509CertImpl oraclePKIX509CertImpl = null;
        try {
            oraclePKIX509CertImpl = new OraclePKIX509CertImpl(new X509(x500Name, (oracle.security.crypto.core.PublicKey)rSAPublicKey, x500Name, (oracle.security.crypto.core.PrivateKey)rSAPrivateKey, bigInteger, n2));
        }
        catch (Exception exception) {
            IOException iOException = new IOException();
            throw (IOException)iOException.initCause(exception);
        }
        try {
            if (oraclePKIX509CertImpl != null) {
                if (this.y == null) {
                    this.C = this.d();
                }
                this.internalAddCertReq(certificateRequest, rSAPrivateKey, null);
                if (this.y == null) {
                    this.C = this.m(this.C);
                }
                this.internalAddTrustedCert(oraclePKIX509CertImpl, null);
                if (this.y == null) {
                    this.C = this.m(this.C);
                }
                this.internalAddUserCert(oraclePKIX509CertImpl, null);
                if (this.y == null) {
                    this.C = this.m(this.C);
                }
            }
        }
        catch (Exception exception) {
            IOException iOException = new IOException();
            throw (IOException)iOException.initCause(exception);
        }
    }

    public void internalAddCertReq(CertificateRequest certificateRequest, RSAPrivateKey rSAPrivateKey, String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.b("OracleWallet: internalAddCertReq");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.q != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.q);
        }
        oracleKeyStoreSpi = this.y != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.y);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        this.q = oracleKeyStoreSpi.a(byteArrayInputStream, this.y, certificateRequest, rSAPrivateKey, string);
    }

    public String exportCertB64(String string) throws IOException, KeyStoreException, CertificateEncodingException {
        String string2 = null;
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            String string3 = enumeration.nextElement();
            OraclePKIX509CertImpl oraclePKIX509CertImpl = (OraclePKIX509CertImpl)keyStore.getCertificate(string3);
            if (oraclePKIX509CertImpl == null || !string.equals(string3)) continue;
            BASE64Encoder bASE64Encoder = new BASE64Encoder();
            byte[] byArray = oraclePKIX509CertImpl.getEncoded();
            string2 = "-----BEGIN CERTIFICATE-----\n" + bASE64Encoder.encodeBuffer(byArray) + o;
            break;
        }
        return string2;
    }

    public void createSelfSigned(X500Principal x500Principal, int n, int n2) throws IOException {
        this.createSelfSigned(x500Principal, n, n2, BigInteger.ZERO);
    }

    public void changePassword(char[] cArray) throws IOException {
        if (cArray == null) {
            throw new IOException("Password cannot be null string.");
        }
        if (this.y == null) {
            throw new IOException("Cannot modify SSO wallet password.");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.q);
        PKCS12 pKCS12 = new PKCS12(new String(this.y), (InputStream)byteArrayInputStream);
        pKCS12.setPassword(new String(cArray));
        Vector vector = pKCS12.getAuthSafes();
        for (int i = 0; i < vector.size(); ++i) {
            ((PKCS12Safe)vector.elementAt(i)).setPassword(new String(cArray));
        }
        try {
            OraclePKIDebug.b("Verifying wallet " + pKCS12.verify());
        }
        catch (AuthenticationException authenticationException) {
            OraclePKIDebug.b("Verifying wallet failed" + (Object)((Object)authenticationException));
            throw new IOException("Could not verify wallet " + (Object)((Object)authenticationException));
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(pKCS12.length());
        pKCS12.output((OutputStream)byteArrayOutputStream);
        this.q = byteArrayOutputStream.toByteArray();
        this.y = cArray;
    }

    public OracleSecretStore getSecretStore() throws IOException, OracleSecretStoreException {
        OracleSecretStore oracleSecretStore = new OracleSecretStore();
        OraclePKIDebug.b("OracleWallet: getSecretStore");
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.q != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.q);
        }
        oracleSecretStore.load(byteArrayInputStream, this.y);
        return oracleSecretStore;
    }

    public String exportCertReqB64(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        String string2 = null;
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            CertificateRequest certificateRequest;
            String string3 = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string3) || (certificateRequest = ((OraclePKIRSAPrivateKey)keyStore.getKey(string3, null)).getCertificateRequest()) == null || !string.equals(string3)) continue;
            BASE64Encoder bASE64Encoder = new BASE64Encoder();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            certificateRequest.output((OutputStream)byteArrayOutputStream);
            string2 = "-----BEGIN NEW CERTIFICATE REQUEST-----\n" + bASE64Encoder.encodeBuffer(byteArrayOutputStream.toByteArray()) + p;
            break;
        }
        return string2;
    }

    public void internalRemoveAllTrusted() throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.b("OracleWallet: internalRemoveAllTrusted");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.q != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.q);
        }
        oracleKeyStoreSpi = this.y != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.y);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        this.q = oracleKeyStoreSpi.i(byteArrayInputStream, this.y);
    }

    public void internalRemoveCertReq(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        OraclePKIDebug.b("OracleWallet: internalRemoveUserCertReq");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.q != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.q);
        }
        oracleKeyStoreSpi = this.y != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.y);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        this.q = oracleKeyStoreSpi.b(byteArrayInputStream, this.y, string);
    }

    public int getTrustpointCount(int n) throws IOException, KeyStoreException, CertificateException {
        int n2 = 0;
        if (n != 0) {
            throw new IOException("No persona with index=" + n + " in wallet.");
        }
        Object var3_3 = null;
        Object var4_4 = null;
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            OraclePKIX509CertImpl oraclePKIX509CertImpl;
            String string = enumeration.nextElement();
            if (!keyStore.isCertificateEntry(string) || (oraclePKIX509CertImpl = (OraclePKIX509CertImpl)keyStore.getCertificate(string)) == null) continue;
            ++n2;
        }
        return n2;
    }

    public int internalGetCertCompNum(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.b("OracleWallet: internalGetCRCompNum");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.q != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.q);
        }
        oracleKeyStoreSpi = this.y != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.y);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        return oracleKeyStoreSpi.h(byteArrayInputStream, this.y, string);
    }

    public static int[] getKeysizes() {
        return new int[]{512, 768, 1024, 2048, 4096};
    }

    public void setWalletArray(InputStream inputStream, char[] cArray) throws IOException {
        this.g();
        if (cArray != null) {
            this.y = new char[cArray.length];
            System.arraycopy(cArray, 0, this.y, 0, cArray.length);
        }
        try {
            int n = inputStream.available();
            this.A = this.h();
            this.q = new byte[n];
            inputStream.read(this.q);
            OraclePKIDebug.b("Oracle Wallet: wallet size " + this.q.length);
            try {
                this.getSecretStore();
            }
            catch (Throwable throwable) {
                OraclePKIDebug.b("OracleWallet: " + throwable.toString());
                this.g();
                throw new IOException("Check password");
            }
        }
        catch (Throwable throwable) {
            this.g();
            throw new IOException("Could not open wallet. " + throwable.getMessage());
        }
    }

    public void createSSO_OLD() throws IOException {
        if (this.y == null && this.A == null) {
            this.y = new char[]{'t', 'e', 's', 't'};
            KeyStore keyStore = this.getKeyStore();
            this.k(keyStore);
            this.A = this.b(this.r);
            OraclePKIDebug.b("OracleWallet: saving sso (ALO) " + this.q.length + " bytes.");
            this.A.d(this.q, this.y, true);
        } else {
            OraclePKIDebug.b("OracleWallet: saving sso (AL) " + this.q.length + " bytes.");
            this.A.d(this.q, this.y, false);
        }
    }

    public String exportCertReqB64(X500Principal x500Principal) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        String string = null;
        KeyStore keyStore = this.getKeyStore();
        X500Name x500Name = new X500Name(x500Principal.toString());
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            CertificateRequest certificateRequest;
            String string2;
            String string3 = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string3) || !(string2 = (certificateRequest = ((OraclePKIRSAPrivateKey)keyStore.getKey(string3, null)).getCertificateRequest()).getSubject().toString().toUpperCase()).startsWith(x500Name.toString().toUpperCase())) continue;
            BASE64Encoder bASE64Encoder = new BASE64Encoder();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            certificateRequest.output((OutputStream)byteArrayOutputStream);
            string = "-----BEGIN NEW CERTIFICATE REQUEST-----\n" + bASE64Encoder.encodeBuffer(byteArrayOutputStream.toByteArray()) + p;
            break;
        }
        return string;
    }

    public InputStream exportCert(X500Principal x500Principal) throws IOException, KeyStoreException, CertificateEncodingException {
        String string = this.exportCertB64(x500Principal);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        return byteArrayInputStream;
    }

    public int getCertCount(int n) throws IOException, KeyStoreException, CertificateException {
        int n2 = 0;
        if (n != 0) {
            throw new IOException("No persona with index=" + n + " in wallet.");
        }
        Object var3_3 = null;
        Object var4_4 = null;
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = null;
        enumeration = keyStore.aliases();
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            OraclePKIX509CertImpl oraclePKIX509CertImpl;
            String string = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string) || (oraclePKIX509CertImpl = (OraclePKIX509CertImpl)keyStore.getCertificate(string)) == null) continue;
            ++n2;
        }
        return n2;
    }

    public void createSSO() throws IOException {
        if (this.y == null && this.A == null) {
            this.y = new char[]{'t', 'e', 's', 't'};
            KeyStore keyStore = this.getKeyStore();
            this.k(keyStore);
            ByteArrayInputStream byteArrayInputStream = (ByteArrayInputStream)this.i(true);
            this.g();
            this.q = new byte[((InputStream)byteArrayInputStream).available()];
            byteArrayInputStream.read(this.q);
            OraclePKIDebug.b("OracleWallet: created ALO " + this.q.length + " bytes.");
        }
    }

    public boolean isAutoLoginOnly() throws IOException {
        ByteArrayInputStream byteArrayInputStream = null;
        boolean bl = false;
        try {
            this.getSecretStore();
        }
        catch (Exception exception) {
            this.g();
            IOException iOException = new IOException("Could not get secret store");
            iOException.initCause(exception);
            throw iOException;
        }
        if (this.q == null) {
            throw new IOException("Wallet array is null.");
        }
        byteArrayInputStream = new ByteArrayInputStream(this.q);
        if (this.y != null) {
            return false;
        }
        C05 c05 = new C05();
        try {
            bl = c05.c(byteArrayInputStream);
        }
        catch (IOException iOException) {
            OraclePKIDebug.b("OracleWallet: isAutoLoginOnly(): " + iOException.toString());
            throw new IOException(iOException.getMessage());
        }
        return bl;
    }

    void l(X500Principal x500Principal, KeyPair keyPair, RSAPrivateKey rSAPrivateKey, String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        if (!this.e()) {
            throw new IOException("Cannot modify AL wallet.");
        }
        X500Name x500Name = new X500Name(x500Principal.toString());
        CertificateRequest certificateRequest = new CertificateRequest(x500Name, keyPair);
        if (this.y == null) {
            this.C = this.d();
        }
        this.internalAddCertReq(certificateRequest, rSAPrivateKey, string);
        if (this.y == null) {
            this.C = this.m(this.C);
        }
    }

    public boolean exists(String string) throws IOException {
        C18 c18 = this.b(string);
        return c18.a();
    }

    public String getLocation() {
        return this.r;
    }

    private char[] m(char[] cArray) throws IOException {
        if (this.y != null) {
            throw new IOException("");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.q);
        char[] cArray2 = null;
        byte[] byArray = new byte[1024];
        byte[] byArray2 = null;
        C05 c05 = new C05();
        try {
            cArray2 = c05.e(byArray);
            byArray2 = c05.h(cArray2, true);
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
        byteArrayOutputStream.write(byArray2);
        PKCS12 pKCS12 = new PKCS12(new String(cArray), (InputStream)byteArrayInputStream);
        pKCS12.setPassword(new String(cArray2));
        Vector vector = pKCS12.getAuthSafes();
        for (int i = 0; i < vector.size(); ++i) {
            ((PKCS12Safe)vector.elementAt(i)).setPassword(new String(cArray2));
        }
        try {
            pKCS12.output((OutputStream)byteArrayOutputStream);
            OraclePKIDebug.b("Verifying wallet " + pKCS12.verify());
        }
        catch (AuthenticationException authenticationException) {
            OraclePKIDebug.b("Verifying wallet failed" + (Object)((Object)authenticationException));
            throw new IOException("Could not create SSO wallet from p12" + (Object)((Object)authenticationException));
        }
        this.q = byteArrayOutputStream.toByteArray();
        return cArray2;
    }

    public void saveSSO() throws IOException {
        OraclePKIDebug.b("OracleWallet: saving sso (AL) " + this.q.length + " bytes.");
        this.A.d(this.q, this.y, false);
    }

    public X509Certificate getCert(int n, int n2) throws IOException, KeyStoreException, CertificateException {
        if (n != 0) {
            throw new IOException("No persona with index=" + n + " in wallet.");
        }
        Object var3_3 = null;
        X509Certificate x509Certificate = null;
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = null;
        enumeration = keyStore.aliases();
        int n3 = 0;
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string)) continue;
            OraclePKIX509CertImpl oraclePKIX509CertImpl = (OraclePKIX509CertImpl)keyStore.getCertificate(string);
            if (oraclePKIX509CertImpl != null && n2 == n3) {
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(oraclePKIX509CertImpl.getEncoded()));
                break;
            }
            ++n3;
        }
        return x509Certificate;
    }

    public String[] getCertAliases(int n) throws IOException, KeyStoreException {
        String[] stringArray;
        Vector<String[]> vector = new Vector<String[]>();
        if (n != 0) {
            throw new IOException("No persona with index=" + n + " in wallet.");
        }
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = null;
        enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            OraclePKIX509CertImpl oraclePKIX509CertImpl;
            stringArray = enumeration.nextElement();
            if (!keyStore.isKeyEntry((String)stringArray) || (oraclePKIX509CertImpl = (OraclePKIX509CertImpl)keyStore.getCertificate((String)stringArray)) == null) continue;
            vector.add(stringArray);
        }
        stringArray = new String[vector.size()];
        int n2 = 0;
        Enumeration enumeration2 = vector.elements();
        while (enumeration2.hasMoreElements()) {
            stringArray[n2] = (String)enumeration2.nextElement();
            ++n2;
        }
        return stringArray;
    }

    public String[] getCertReqInfo(int n, String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        String[] stringArray = new String[3];
        if (n != 0) {
            throw new IOException("No persona with index=" + n + " in wallet.");
        }
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = null;
        enumeration = keyStore.aliases();
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            CertificateRequest certificateRequest;
            String string2 = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string2) || (certificateRequest = ((OraclePKIRSAPrivateKey)keyStore.getKey(string2, null)).getCertificateRequest()) == null || !string.equals(string2)) continue;
            stringArray[0] = certificateRequest.getSubject().toString();
            stringArray[1] = new Integer(((RSAPublicKey)certificateRequest.getPublicKey()).modulusLength() * 8).toString();
            stringArray[2] = new String(certificateRequest.getPublicKey().getAlgorithm());
            break;
        }
        return stringArray;
    }

    public void deleteSSOWallet() throws IOException {
        this.A.c();
    }

    public String exportCertChainB64(X500Principal x500Principal) throws IOException, KeyStoreException, CertificateException {
        Object object;
        Enumeration<String> enumeration;
        Certificate[] certificateArray;
        String string = null;
        String string2 = null;
        boolean bl = false;
        KeyStore keyStore = this.getKeyStore();
        if (x500Principal != null) {
            certificateArray = new X500Name(x500Principal.toString());
            enumeration = keyStore.aliases();
            while (enumeration.hasMoreElements()) {
                String string3;
                string2 = enumeration.nextElement();
                object = (OraclePKIX509CertImpl)keyStore.getCertificate(string2);
                if (object == null || !keyStore.isKeyEntry(string2) || !(string3 = ((Object)((OraclePKIX509CertImpl)object).getSubjectDN()).toString().toUpperCase()).startsWith(certificateArray.toString().toUpperCase())) continue;
                bl = true;
                break;
            }
            if (!bl) {
                OraclePKIDebug.b("No certificate with matching DN found in wallet.");
                return string;
            }
        } else {
            enumeration = keyStore.aliases();
            while (enumeration.hasMoreElements()) {
                string2 = enumeration.nextElement();
                if (!keyStore.isKeyEntry(string2)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                OraclePKIDebug.b("No user certificate found in wallet.");
                return string;
            }
        }
        certificateArray = keyStore.getCertificateChain(string2);
        object = new PKCS7();
        OraclePKIDebug.b("Found cert chain of length = " + certificateArray.length);
        if (certificateArray.length > 1) {
            for (int i = 1; i < certificateArray.length; ++i) {
                object.addCertificate(new X509(((OraclePKIX509CertImpl)certificateArray[i]).getEncoded()));
            }
        } else if (certificateArray.length == 1) {
            object.addCertificate(new X509(((OraclePKIX509CertImpl)certificateArray[0]).getEncoded()));
        } else {
            OraclePKIDebug.b("Certificate chain length is zero");
            return string;
        }
        BASE64Encoder bASE64Encoder = new BASE64Encoder();
        byte[] byArray = object.getEncoded();
        string = "-----BEGIN CERTIFICATE-----\n" + bASE64Encoder.encodeBuffer(byArray) + o;
        return string;
    }
}

