/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki;

import java.security.Provider;
import java.security.Security;
import oracle.security.pki.OraclePKIDebug;

public final class OraclePKIProvider
extends Provider {
    public OraclePKIProvider() {
        super("OraclePKI", 1.0, "Oracle PKI provider v1.0, implements KeyStore interface for Oracle Wallets, and support for JSSE 1.0.3 and later");
        OraclePKIDebug.b("Using OraclePKI Provider");
        this.put("KeyStore.PKCS12", "oracle.security.pki.OracleKeyStoreSpi");
        this.put("KeyStore.SSO", "oracle.security.pki.OracleSSOKeyStoreSpi");
        Security.addProvider(new OracleJSSE14Provider());
        Security.addProvider(new OracleJSSE103Provider());
    }

    class OracleJSSE14Provider
    extends Provider {
        public OracleJSSE14Provider() {
            super("OracleJSSE", 1.0, "Oracle PKI provider v1.0, implements support forJSSE");
            try {
                Class.forName("javax.net.ssl.TrustManagerFactory");
                OraclePKIDebug.b("javax.net.ssl.TrustManagerFactory supported");
                this.put("TrustManagerFactory.OracleX509", "oracle.security.pki.ssl.OracleSSLX509TrustManagerFactory14");
            }
            catch (ClassNotFoundException classNotFoundException) {
                OraclePKIDebug.b("javax.net.ssl.TrustManagerFactory not supported");
            }
            try {
                Class.forName("javax.net.ssl.KeyManagerFactory");
                OraclePKIDebug.b("javax.net.ssl.KeyManagerFactory supported");
                this.put("KeyManagerFactory.OracleX509", "oracle.security.pki.ssl.OracleSSLX509KeyManagerFactory14");
            }
            catch (ClassNotFoundException classNotFoundException) {
                OraclePKIDebug.b("javax.net.ssl.KeyManagerFactory not supported");
            }
        }
    }

    class OracleJSSE103Provider
    extends Provider {
        public OracleJSSE103Provider() {
            super("OracleJSSE103", 1.0, "Oracle PKI provider v1.0, implements support forJSSE 1.0.3");
            OraclePKIDebug.b("Using OracleJSSE103 Provider");
            this.put("TrustManagerFactory.OracleX509", "oracle.security.pki.ssl.OracleSSLX509TrustManagerFactory103");
            this.put("KeyManagerFactory.OracleX509", "oracle.security.pki.ssl.OracleSSLX509KeyManagerFactory103");
        }
    }
}

