/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.Collator;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.cert.CertificateRequest;
import oracle.security.crypto.cert.PKCS12;
import oracle.security.crypto.cert.PKCS12Bag;
import oracle.security.crypto.cert.PKCS12CertBag;
import oracle.security.crypto.cert.PKCS12KeyBag;
import oracle.security.crypto.cert.PKCS12Safe;
import oracle.security.crypto.cert.PKCS12SecretBag;
import oracle.security.crypto.cert.PKCS12ShroudedKeyBag;
import oracle.security.crypto.cert.X500Name;
import oracle.security.crypto.cert.X509;
import oracle.security.crypto.core.AuthenticationException;
import oracle.security.crypto.core.PrivateKey;
import oracle.security.crypto.core.RSAPrivateKey;
import oracle.security.crypto.core.RSAPublicKey;
import oracle.security.pki.C00;
import oracle.security.pki.C01;
import oracle.security.pki.C10;
import oracle.security.pki.C12;
import oracle.security.pki.C20;
import oracle.security.pki.OracleLocalKeyId;
import oracle.security.pki.OraclePKIDebug;
import oracle.security.pki.OraclePKIRSAPrivateKey;
import oracle.security.pki.OraclePKIX509CertImpl;
import oracle.security.pki.OracleSecretStoreException;
import oracle.security.pki.OracleWalletPermission;

public class OracleKeyStoreSpi
extends KeyStoreSpi {
    static ResourceBundle z = ResourceBundle.getBundle("oracle.security.pki.resources.OraclePKIMsg");
    private Hashtable A = new Hashtable();
    public static final String CREDENTIAL_USERNAME = "oracle.security.client.username";
    private PKCS12 B = null;
    public static final String CREDENTIAL_CONNECT_STRING = "oracle.security.client.connect_string";
    public static final String CREDENTIAL_PASSWORD = "oracle.security.client.password";
    private Hashtable C = new Hashtable();

    private static Vector a(PKCS12 pKCS12) {
        Vector vector = pKCS12.getAuthSafes();
        Vector<PKCS12Bag> vector2 = new Vector<PKCS12Bag>();
        for (int i = 0; i < vector.size(); ++i) {
            PKCS12Safe pKCS12Safe = (PKCS12Safe)vector.elementAt(i);
            OraclePKIDebug.b("OracleKeyStoreSpi: Opening safe " + i);
            Vector vector3 = pKCS12Safe.getBags();
            for (int j = 0; j < vector3.size(); ++j) {
                PKCS12Bag pKCS12Bag = (PKCS12Bag)vector3.elementAt(j);
                if (!OracleKeyStoreSpi.v(pKCS12Bag)) continue;
                OraclePKIDebug.b("OracleKeyStoreSpi: found secret store bag");
                vector2.addElement(pKCS12Bag);
                vector3.removeElementAt(j);
                --j;
            }
            pKCS12Safe.setBags(vector3);
        }
        return vector2;
    }

    private static Vector b(PKCS12 pKCS12) {
        Vector vector = pKCS12.getAuthSafes();
        Vector<PKCS12Bag> vector2 = new Vector<PKCS12Bag>();
        for (int i = 0; i < vector.size(); ++i) {
            PKCS12Safe pKCS12Safe = (PKCS12Safe)vector.elementAt(i);
            OraclePKIDebug.b("OracleKeyStoreSpi: Opening safe " + i);
            Vector vector3 = pKCS12Safe.getBags();
            for (int j = 0; j < vector3.size(); ++j) {
                PKCS12Bag pKCS12Bag = (PKCS12Bag)vector3.elementAt(j);
                if (!OracleKeyStoreSpi.j(pKCS12Bag)) continue;
                OraclePKIDebug.b("OracleKeyStoreSpi: found cert bag");
                vector2.addElement(pKCS12Bag);
                vector3.removeElementAt(j);
                --j;
            }
            pKCS12Safe.setBags(vector3);
        }
        return vector2;
    }

    boolean c(C01 c01, OraclePKIRSAPrivateKey oraclePKIRSAPrivateKey) {
        boolean bl = false;
        BigInteger bigInteger = oraclePKIRSAPrivateKey.getPublicExponent();
        BigInteger bigInteger2 = oraclePKIRSAPrivateKey.getModulus();
        if (bigInteger.equals(c01.getPublicExponent()) && bigInteger2.equals(c01.getModulus())) {
            bl = true;
        }
        return bl;
    }

    byte[] c(InputStream inputStream, char[] cArray, X500Principal x500Principal) throws IOException, KeyStoreException, CertificateEncodingException, NoSuchAlgorithmException, UnrecoverableKeyException {
        ASN1Object aSN1Object;
        PKCS12Safe pKCS12Safe;
        Object object;
        Object object2;
        Object object3;
        CertificateRequest certificateRequest = null;
        boolean bl = false;
        X500Name x500Name = new X500Name(x500Principal.toString());
        Enumeration enumeration = this.engineAliases();
        while (enumeration.hasMoreElements()) {
            object3 = (String)enumeration.nextElement();
            if (!this.engineIsKeyEntry((String)object3) || (certificateRequest = ((OraclePKIRSAPrivateKey)this.engineGetKey((String)object3, null)).getCertificateRequest()) == null || !((String)(object2 = (Object)certificateRequest.getSubject().toString().toUpperCase())).startsWith(x500Name.toString().toUpperCase())) continue;
            object = (OraclePKIX509CertImpl)this.engineGetCertificate((String)object3);
            if (object != null) {
                throw new IOException("User cert is in wallet. Cannot remove cert request with DN:" + x500Name.toString());
            }
            bl = true;
            break;
        }
        if (!bl) {
            OraclePKIDebug.b("internalRemoveCertReq: No cert request in wallet with matching DN.");
            throw new IOException("No cert request in wallet with matching DN.");
        }
        object3 = new ByteArrayOutputStream();
        certificateRequest.output((OutputStream)object3);
        object2 = ((ByteArrayOutputStream)object3).toByteArray();
        object = null;
        PKCS12 pKCS12 = new PKCS12();
        pKCS12.setPassword(new String(cArray));
        if (inputStream != null) {
            pKCS12Safe = new PKCS12(new String(cArray), inputStream);
            pKCS12.setAuthSafes(pKCS12Safe.getAuthSafes());
        }
        OraclePKIDebug.b("OracleKeyStoreSpi: using safe 0");
        pKCS12Safe = (PKCS12Safe)pKCS12.getAuthSafes().elementAt(0);
        Vector vector = pKCS12Safe.getBags();
        OraclePKIDebug.b("OracleKeyStoreSpi: safe has " + vector.size() + " bags");
        for (int i = 0; i < vector.size(); ++i) {
            byte[] byArray;
            boolean bl2;
            PKCS12Bag pKCS12Bag = (PKCS12Bag)vector.elementAt(i);
            if (!OracleKeyStoreSpi.u(pKCS12Bag) || !(bl2 = Arrays.equals((byte[])object2, byArray = ((ASN1OctetString)(aSN1Object = ((PKCS12SecretBag)pKCS12Bag).getSecretValue())).getValue()))) continue;
            object = pKCS12Bag.getLocalKeyID();
            vector.removeElementAt(i);
            break;
        }
        byte[] byArray = OracleLocalKeyId.h(OracleLocalKeyId.f((byte[])object), OracleLocalKeyId.a((byte[])object));
        for (int i = 0; i < vector.size(); ++i) {
            aSN1Object = (PKCS12Bag)vector.elementAt(i);
            if (!OracleKeyStoreSpi.r((PKCS12Bag)aSN1Object) || !this.i(aSN1Object.getLocalKeyID(), byArray)) continue;
            vector.removeElementAt(i);
            break;
        }
        pKCS12Safe.setBags(vector);
        if (vector.size() > 0 && pKCS12.getAuthSafes().size() == 0) {
            pKCS12.addAuthSafe(pKCS12Safe);
        }
        OraclePKIDebug.b("OracleKeyStoreSpi: wallet has " + pKCS12.getAuthSafes().size() + " safes");
        OraclePKIDebug.b("OracleKeyStoreSpi: wallet size " + pKCS12.length());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(pKCS12.length());
        pKCS12.output((OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    byte[] d(InputStream inputStream, KeyStore keyStore, char[] cArray) throws IOException, KeyStoreException, CertificateException {
        PKCS12 pKCS12;
        PKCS12 pKCS122 = new PKCS12();
        pKCS122.setPassword(new String(cArray));
        if (inputStream != null) {
            pKCS12 = new PKCS12(new String(cArray), inputStream);
            pKCS122.setAuthSafes(pKCS12.getAuthSafes());
            OracleKeyStoreSpi.t(pKCS122);
            OracleKeyStoreSpi.b(pKCS122);
            OracleKeyStoreSpi.g(pKCS122);
        }
        pKCS12 = null;
        if (pKCS122.getAuthSafes().size() == 0) {
            OraclePKIDebug.b("OracleKeyStoreSpi: creating new key store");
            pKCS12 = new PKCS12Safe(pKCS122);
            pKCS12.setMode(3);
        } else {
            OraclePKIDebug.b("OracleKeyStoreSpi: using safe 0");
            pKCS12 = (PKCS12Safe)pKCS122.getAuthSafes().elementAt(0);
        }
        Vector vector = pKCS12.getBags();
        OraclePKIDebug.b("OracleKeyStoreSpi: safe has " + vector.size() + " bags");
        Object object = keyStore.aliases();
        while (object.hasMoreElements()) {
            int n = 0;
            String string = object.nextElement();
            if (keyStore.isCertificateEntry(string)) {
                X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(string);
                X509 x509 = x509Certificate instanceof OraclePKIX509CertImpl ? ((OraclePKIX509CertImpl)x509Certificate).getX509() : new X509(x509Certificate.getEncoded());
                PKCS12CertBag pKCS12CertBag = new PKCS12CertBag((PKCS12Safe)pKCS12, x509);
                pKCS12CertBag.setLocalKeyID(OracleLocalKeyId.l(0, n));
                vector.insertElementAt(pKCS12CertBag, 0);
                OraclePKIDebug.b("OracleWallet: added cert bag");
                continue;
            }
            if (!keyStore.isKeyEntry(string)) continue;
            throw new IOException("Not Implemented for private keys");
        }
        pKCS12.setBags(vector);
        if (vector.size() > 0 && pKCS122.getAuthSafes().size() == 0) {
            pKCS122.addAuthSafe((PKCS12Safe)pKCS12);
        }
        OraclePKIDebug.b("OracleWallet: wallet has " + pKCS122.getAuthSafes().size() + " safes");
        OraclePKIDebug.b("OracleWallet: wallet size " + pKCS122.length());
        object = new ByteArrayOutputStream(pKCS122.length());
        pKCS122.output((OutputStream)object);
        return ((ByteArrayOutputStream)object).toByteArray();
    }

    byte[] e(InputStream inputStream, char[] cArray, String string) throws IOException, KeyStoreException, CertificateEncodingException {
        PKCS12Safe pKCS12Safe;
        String string2;
        OraclePKIX509CertImpl oraclePKIX509CertImpl = null;
        boolean bl = false;
        Enumeration enumeration = this.engineAliases();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            if (!this.engineIsCertificateEntry(string2) || (oraclePKIX509CertImpl = (OraclePKIX509CertImpl)this.engineGetCertificate(string2)) == null || !string.equals(string2)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            OraclePKIDebug.b("internalRemoveTrustedCert: No trusted cert in wallet with matching DN.");
            throw new IOException("No trusted cert in wallet with matching DN.");
        }
        if (this.n(oraclePKIX509CertImpl)) {
            OraclePKIDebug.b("internalRemoveTrustedCert: Trusted cert is used in cert chain.");
            throw new IOException("Trusted cert is used in cert chain.");
        }
        string2 = new PKCS12();
        string2.setPassword(new String(cArray));
        if (inputStream != null) {
            pKCS12Safe = new PKCS12(new String(cArray), inputStream);
            string2.setAuthSafes(pKCS12Safe.getAuthSafes());
        }
        OraclePKIDebug.b("OracleKeyStoreSpi: using safe 0");
        pKCS12Safe = (PKCS12Safe)string2.getAuthSafes().elementAt(0);
        Vector vector = pKCS12Safe.getBags();
        Vector<Object> vector2 = new Vector<Object>(vector.size());
        OraclePKIDebug.b("OracleKeyStoreSpi: safe has " + vector.size() + " bags");
        int n = 0;
        for (int i = 0; i < vector.size(); ++i) {
            PKCS12Bag pKCS12Bag = (PKCS12Bag)vector.elementAt(i);
            if (OracleKeyStoreSpi.j(pKCS12Bag) && OracleLocalKeyId.i(pKCS12Bag.getLocalKeyID())) {
                X509 x509 = ((PKCS12CertBag)pKCS12Bag).getCert();
                X509 x5092 = new X509(oraclePKIX509CertImpl.getEncoded());
                if (x5092.equals((Object)x509)) continue;
                PKCS12CertBag pKCS12CertBag = new PKCS12CertBag(pKCS12Safe, x509);
                pKCS12CertBag.setLocalKeyID(OracleLocalKeyId.l(0, n));
                vector2.addElement(pKCS12CertBag);
                OraclePKIDebug.b("OracleWallet: added cert bag " + n);
                ++n;
                continue;
            }
            vector2.addElement(pKCS12Bag);
        }
        pKCS12Safe.setBags(vector2);
        if (vector2.size() > 0 && string2.getAuthSafes().size() == 0) {
            string2.addAuthSafe(pKCS12Safe);
        }
        OraclePKIDebug.b("OracleKeyStoreSpi: wallet has " + string2.getAuthSafes().size() + " safes");
        OraclePKIDebug.b("OracleKeyStoreSpi: wallet size " + string2.length());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(string2.length());
        string2.output((OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    byte[] j(InputStream inputStream, char[] cArray, OraclePKIX509CertImpl oraclePKIX509CertImpl, String string) throws IOException, KeyStoreException {
        Object object;
        PKCS12 pKCS12;
        ((ByteArrayInputStream)inputStream).mark(((ByteArrayInputStream)inputStream).available());
        byte[] byArray = this.p(inputStream, cArray, oraclePKIX509CertImpl);
        ((ByteArrayInputStream)inputStream).reset();
        PKCS12 pKCS122 = new PKCS12();
        pKCS122.setPassword(new String(cArray));
        if (inputStream != null) {
            pKCS12 = new PKCS12(new String(cArray), inputStream);
            pKCS122.setAuthSafes(pKCS12.getAuthSafes());
        }
        pKCS12 = null;
        if (pKCS122.getAuthSafes().size() == 0) {
            OraclePKIDebug.b("OracleKeyStoreSpi: creating new key store");
            pKCS12 = new PKCS12Safe(pKCS122);
            pKCS12.setMode(3);
        } else {
            OraclePKIDebug.b("OracleKeyStoreSpi: using safe 0");
            pKCS12 = (PKCS12Safe)pKCS122.getAuthSafes().elementAt(0);
        }
        Vector vector = pKCS12.getBags();
        OraclePKIDebug.b("OracleKeyStoreSpi: safe has " + vector.size() + " bags");
        int n = 0;
        for (int i = 0; i < vector.size(); ++i) {
            object = (PKCS12Bag)vector.elementAt(i);
            if (!OracleKeyStoreSpi.j((PKCS12Bag)object) || !OracleLocalKeyId.d(object.getLocalKeyID())) continue;
            OraclePKIDebug.b("OracleKeyStoreSpi: found cert bag");
            ++n;
        }
        PKCS12CertBag pKCS12CertBag = new PKCS12CertBag((PKCS12Safe)pKCS12, oraclePKIX509CertImpl.getX509());
        pKCS12CertBag.setLocalKeyID(byArray);
        if (string != null) {
            pKCS12CertBag.setFriendlyName(string);
        }
        vector.addElement(pKCS12CertBag);
        OraclePKIDebug.b("OracleWallet: added key bag " + n);
        pKCS12.setBags(vector);
        if (vector.size() > 0 && pKCS122.getAuthSafes().size() == 0) {
            pKCS122.addAuthSafe((PKCS12Safe)pKCS12);
        }
        OraclePKIDebug.b("OracleKeyStoreSpi: wallet has " + pKCS122.getAuthSafes().size() + " safes");
        OraclePKIDebug.b("OracleKeyStoreSpi: wallet size " + pKCS122.length());
        object = new ByteArrayOutputStream(pKCS122.length());
        pKCS122.output((OutputStream)object);
        return ((ByteArrayOutputStream)object).toByteArray();
    }

    public Certificate engineGetCertificate(String string) {
        OraclePKIDebug.b("OracleKeyStoreSpi: getCertificate alias \"" + (null == string ? "null" : string) + "\"");
        if (this.engineContainsAlias(string)) {
            return ((C00)this.A.get(string)).e();
        }
        return null;
    }

    int f(InputStream inputStream, char[] cArray, String string) throws IOException, KeyStoreException, CertificateEncodingException {
        PKCS12Safe pKCS12Safe;
        String string2;
        OraclePKIX509CertImpl oraclePKIX509CertImpl = null;
        boolean bl = false;
        Enumeration enumeration = this.engineAliases();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            if (!this.engineIsCertificateEntry(string2) || (oraclePKIX509CertImpl = (OraclePKIX509CertImpl)this.engineGetCertificate(string2)) == null || !string.equals(string2)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            OraclePKIDebug.b("internalGetTCertCompNum: No trusted cert in wallet with matching DN.");
            throw new IOException("No trusted cert in wallet with matching DN.");
        }
        string2 = new PKCS12();
        string2.setPassword(new String(cArray));
        if (inputStream != null) {
            pKCS12Safe = new PKCS12(new String(cArray), inputStream);
            string2.setAuthSafes(pKCS12Safe.getAuthSafes());
        }
        OraclePKIDebug.b("OracleKeyStoreSpi: using safe 0");
        pKCS12Safe = (PKCS12Safe)string2.getAuthSafes().elementAt(0);
        Vector vector = pKCS12Safe.getBags();
        Vector vector2 = new Vector(vector.size());
        OraclePKIDebug.b("OracleKeyStoreSpi: safe has " + vector.size() + " bags");
        boolean bl2 = false;
        for (int i = 0; i < vector.size(); ++i) {
            PKCS12Bag pKCS12Bag = (PKCS12Bag)vector.elementAt(i);
            if (!OracleKeyStoreSpi.j(pKCS12Bag) || !OracleLocalKeyId.i(pKCS12Bag.getLocalKeyID())) continue;
            X509 x509 = ((PKCS12CertBag)pKCS12Bag).getCert();
            X509 x5092 = new X509(oraclePKIX509CertImpl.getEncoded());
            if (!x5092.equals((Object)x509)) continue;
            byte[] byArray = pKCS12Bag.getLocalKeyID();
            return OracleLocalKeyId.a(byArray);
        }
        throw new IOException("Check wallet.");
    }

    public void engineSetCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
        if (this.engineContainsAlias(string) && !((C00)this.A.get(string)).d()) {
            throw new KeyStoreException("Not a certificate entry");
        }
        C10 c10 = new C10(certificate);
        this.A.put(string, c10);
    }

    byte[] f(InputStream inputStream, char[] cArray, X500Principal x500Principal) throws IOException, KeyStoreException, CertificateEncodingException {
        String string;
        String string2;
        OraclePKIX509CertImpl oraclePKIX509CertImpl = null;
        boolean bl = false;
        X500Name x500Name = new X500Name(x500Principal.toString());
        Enumeration enumeration = this.engineAliases();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            if (!this.engineIsCertificateEntry(string2) || (oraclePKIX509CertImpl = (OraclePKIX509CertImpl)this.engineGetCertificate(string2)) == null || !(string = ((Object)oraclePKIX509CertImpl.getSubjectDN()).toString().toUpperCase()).startsWith(x500Name.toString().toUpperCase())) continue;
            bl = true;
            break;
        }
        if (!bl) {
            OraclePKIDebug.b("internalRemoveTrustedCert: No trusted cert in wallet with matching DN.");
            throw new IOException("No trusted cert in wallet with matching DN.");
        }
        if (this.n(oraclePKIX509CertImpl)) {
            OraclePKIDebug.b("internalRemoveTrustedCert: Trusted cert is used in cert chain.");
            throw new IOException("Trusted cert is used in cert chain.");
        }
        string2 = new PKCS12();
        string2.setPassword(new String(cArray));
        if (inputStream != null) {
            string = new PKCS12(new String(cArray), inputStream);
            string2.setAuthSafes(string.getAuthSafes());
        }
        OraclePKIDebug.b("OracleKeyStoreSpi: using safe 0");
        string = (PKCS12Safe)string2.getAuthSafes().elementAt(0);
        Vector vector = string.getBags();
        Vector<Object> vector2 = new Vector<Object>(vector.size());
        OraclePKIDebug.b("OracleKeyStoreSpi: safe has " + vector.size() + " bags");
        int n = 0;
        for (int i = 0; i < vector.size(); ++i) {
            PKCS12Bag pKCS12Bag = (PKCS12Bag)vector.elementAt(i);
            if (OracleKeyStoreSpi.j(pKCS12Bag) && OracleLocalKeyId.i(pKCS12Bag.getLocalKeyID())) {
                X509 x509 = ((PKCS12CertBag)pKCS12Bag).getCert();
                X509 x5092 = new X509(oraclePKIX509CertImpl.getEncoded());
                if (x5092.equals((Object)x509)) continue;
                PKCS12CertBag pKCS12CertBag = new PKCS12CertBag((PKCS12Safe)string, x509);
                pKCS12CertBag.setLocalKeyID(OracleLocalKeyId.l(0, n));
                vector2.addElement(pKCS12CertBag);
                OraclePKIDebug.b("OracleWallet: added cert bag " + n);
                ++n;
                continue;
            }
            vector2.addElement(pKCS12Bag);
        }
        string.setBags(vector2);
        if (vector2.size() > 0 && string2.getAuthSafes().size() == 0) {
            string2.addAuthSafe((PKCS12Safe)string);
        }
        OraclePKIDebug.b("OracleKeyStoreSpi: wallet has " + string2.getAuthSafes().size() + " safes");
        OraclePKIDebug.b("OracleKeyStoreSpi: wallet size " + string2.length());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(string2.length());
        string2.output((OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public void secretStoreListCredential() throws OracleSecretStoreException {
        Enumeration enumeration = new Vector(this.C.values()).elements();
        System.out.println("List credential (index: connect_string username)");
        while (enumeration.hasMoreElements()) {
            C12 c12 = (C12)enumeration.nextElement();
            String string = new String(c12.a());
            String string2 = c12.d();
            if (!string2.startsWith(CREDENTIAL_CONNECT_STRING)) continue;
            String string3 = string2.substring(CREDENTIAL_CONNECT_STRING.length());
            System.out.println(string3 + ": " + string + " " + new String(this.secretStoreGetSecret(CREDENTIAL_USERNAME + string3)));
        }
    }

    private static Vector g(PKCS12 pKCS12) {
        Vector vector = pKCS12.getAuthSafes();
        Vector<PKCS12Bag> vector2 = new Vector<PKCS12Bag>();
        for (int i = 0; i < vector.size(); ++i) {
            PKCS12Safe pKCS12Safe = (PKCS12Safe)vector.elementAt(i);
            OraclePKIDebug.b("OracleKeyStoreSpi: Opening safe " + i);
            Vector vector3 = pKCS12Safe.getBags();
            for (int j = 0; j < vector3.size(); ++j) {
                PKCS12Bag pKCS12Bag = (PKCS12Bag)vector3.elementAt(j);
                if (!OracleKeyStoreSpi.u(pKCS12Bag)) continue;
                OraclePKIDebug.b("OracleKeyStoreSpi: found cert req bag");
                vector2.addElement(pKCS12Bag);
                vector3.removeElementAt(j);
                --j;
            }
            pKCS12Safe.setBags(vector3);
        }
        return vector2;
    }

    public void secretStoreDeleteCredential(char[] cArray) throws OracleSecretStoreException {
        boolean bl = false;
        Enumeration enumeration = new Vector(this.C.values()).elements();
        System.out.println("Delete credential ");
        while (enumeration.hasMoreElements()) {
            C12 c12 = (C12)enumeration.nextElement();
            String string = new String(c12.a());
            String string2 = c12.d();
            if (!string2.startsWith(CREDENTIAL_CONNECT_STRING) || !string.equalsIgnoreCase(new String(cArray))) continue;
            String string3 = string2.substring(CREDENTIAL_CONNECT_STRING.length());
            System.out.println("Delete " + string3);
            this.secretStoreDeleteSecret(string2);
            this.secretStoreDeleteSecret(CREDENTIAL_USERNAME + string3);
            this.secretStoreDeleteSecret(CREDENTIAL_PASSWORD + string3);
            bl = true;
            break;
        }
        if (!bl) {
            throw new OracleSecretStoreException("Credential does not exists");
        }
    }

    int h(InputStream inputStream, char[] cArray, String string) throws IOException, KeyStoreException, CertificateEncodingException {
        PKCS12Safe pKCS12Safe;
        String string2;
        OraclePKIX509CertImpl oraclePKIX509CertImpl = null;
        boolean bl = false;
        Enumeration enumeration = this.engineAliases();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            if (!this.engineIsKeyEntry(string2) || (oraclePKIX509CertImpl = (OraclePKIX509CertImpl)this.engineGetCertificate(string2)) == null || !string.equals(string2)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            OraclePKIDebug.b("internalGetCertCompNum: No user cert in wallet with matching alias.");
            throw new IOException("No user cert in wallet with matching alias.");
        }
        string2 = new PKCS12();
        string2.setPassword(new String(cArray));
        if (inputStream != null) {
            pKCS12Safe = new PKCS12(new String(cArray), inputStream);
            string2.setAuthSafes(pKCS12Safe.getAuthSafes());
        }
        OraclePKIDebug.b("OracleKeyStoreSpi: using safe 0");
        pKCS12Safe = (PKCS12Safe)string2.getAuthSafes().elementAt(0);
        Vector vector = pKCS12Safe.getBags();
        Vector vector2 = new Vector(vector.size());
        OraclePKIDebug.b("OracleKeyStoreSpi: safe has " + vector.size() + " bags");
        for (int i = 0; i < vector.size(); ++i) {
            PKCS12Bag pKCS12Bag = (PKCS12Bag)vector.elementAt(i);
            if (!OracleKeyStoreSpi.j(pKCS12Bag) || !OracleLocalKeyId.d(pKCS12Bag.getLocalKeyID())) continue;
            X509 x509 = ((PKCS12CertBag)pKCS12Bag).getCert();
            X509 x5092 = new X509(oraclePKIX509CertImpl.getEncoded());
            if (!x5092.equals((Object)x509)) continue;
            byte[] byArray = pKCS12Bag.getLocalKeyID();
            return OracleLocalKeyId.a(byArray);
        }
        throw new IOException("Check wallet.");
    }

    private boolean i(byte[] byArray, byte[] byArray2) {
        if (byArray == null | byArray2 == null) {
            return false;
        }
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    private static boolean j(PKCS12Bag pKCS12Bag) {
        return pKCS12Bag instanceof PKCS12CertBag;
    }

    public boolean secretStoreContainsAlias(String string) throws OracleSecretStoreException {
        return this.C.containsKey(string);
    }

    Enumeration k() {
        TreeSet<Object> treeSet = new TreeSet<Object>(Collator.getInstance());
        treeSet.addAll(this.C.keySet());
        return new Vector<Object>(treeSet).elements();
    }

    public void secretStoreDeleteSecret(String string) throws OracleSecretStoreException {
        if (!this.secretStoreContainsAlias(string)) {
            throw new OracleSecretStoreException("No such alias in secret store");
        }
        this.C.remove(string);
    }

    int l() {
        return this.C.size();
    }

    byte[] a(InputStream inputStream, char[] cArray, CertificateRequest certificateRequest, RSAPrivateKey rSAPrivateKey, String string) throws IOException, KeyStoreException {
        byte[] byArray;
        Object object;
        PKCS12 pKCS12;
        PKCS12 pKCS122 = new PKCS12();
        pKCS122.setPassword(new String(cArray));
        if (inputStream != null) {
            pKCS12 = new PKCS12(new String(cArray), inputStream);
            pKCS122.setAuthSafes(pKCS12.getAuthSafes());
        }
        pKCS12 = null;
        if (pKCS122.getAuthSafes().size() == 0) {
            OraclePKIDebug.b("OracleKeyStoreSpi: creating new key store");
            pKCS12 = new PKCS12Safe(pKCS122);
            pKCS12.setMode(3);
        } else {
            OraclePKIDebug.b("OracleKeyStoreSpi: using safe 0");
            pKCS12 = (PKCS12Safe)pKCS122.getAuthSafes().elementAt(0);
        }
        Vector vector = pKCS12.getBags();
        OraclePKIDebug.b("OracleKeyStoreSpi: safe has " + vector.size() + " bags");
        int n = 0;
        for (int i = 0; i < vector.size(); ++i) {
            object = (PKCS12Bag)vector.elementAt(i);
            if (!OracleKeyStoreSpi.r((PKCS12Bag)object)) continue;
            OraclePKIDebug.b("OracleKeyStoreSpi: found key bag");
            byArray = object.getLocalKeyID();
            int n2 = OracleLocalKeyId.a(byArray);
            if (n2 == n) {
                ++n;
                continue;
            }
            if (n2 <= n) continue;
            n = n2 + 1;
        }
        PKCS12KeyBag pKCS12KeyBag = new PKCS12KeyBag((PKCS12Safe)pKCS12, (PrivateKey)rSAPrivateKey);
        pKCS12KeyBag.setLocalKeyID(OracleLocalKeyId.h(0, n));
        if (string != null) {
            pKCS12KeyBag.setFriendlyName(string);
        }
        vector.addElement(pKCS12KeyBag);
        OraclePKIDebug.b("OracleWallet: added key bag " + n);
        object = new ByteArrayOutputStream();
        certificateRequest.output((OutputStream)object);
        byArray = ((ByteArrayOutputStream)object).toByteArray();
        ASN1OctetString aSN1OctetString = new ASN1OctetString(byArray);
        PKCS12SecretBag pKCS12SecretBag = new PKCS12SecretBag((PKCS12Safe)pKCS12, new ASN1ObjectID("42.134.72.134.247.13.1.10"), (ASN1Object)aSN1OctetString);
        pKCS12SecretBag.setLocalKeyID(OracleLocalKeyId.j(0, n));
        if (string != null) {
            pKCS12SecretBag.setFriendlyName(string);
        }
        vector.addElement(pKCS12SecretBag);
        OraclePKIDebug.b("OracleKeyStoreSpi: added req bag " + n);
        pKCS12.setBags(vector);
        if (vector.size() > 0 && pKCS122.getAuthSafes().size() == 0) {
            pKCS122.addAuthSafe((PKCS12Safe)pKCS12);
        }
        OraclePKIDebug.b("OracleKeyStoreSpi: wallet has " + pKCS122.getAuthSafes().size() + " safes");
        OraclePKIDebug.b("OracleKeyStoreSpi: wallet size " + pKCS122.length());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(pKCS122.length());
        pKCS122.output((OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    boolean m(OraclePKIX509CertImpl oraclePKIX509CertImpl) throws IOException {
        boolean bl = false;
        Set set = this.A.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Serializable serializable;
            Map.Entry entry = iterator.next();
            if (!((C00)entry.getValue() instanceof C10)) continue;
            X509Certificate x509Certificate = (X509Certificate)((C00)entry.getValue()).e();
            X509 x509 = null;
            try {
                x509 = new X509(x509Certificate.getEncoded());
            }
            catch (CertificateEncodingException certificateEncodingException) {
                serializable = new IOException("Cert getEncoded failed.");
                ((Throwable)serializable).initCause(certificateEncodingException);
                throw serializable;
            }
            RSAPublicKey rSAPublicKey = (RSAPublicKey)x509.getPublicKey();
            serializable = (C01)oraclePKIX509CertImpl.getPublicKey();
            BigInteger bigInteger = rSAPublicKey.getExponent();
            BigInteger bigInteger2 = rSAPublicKey.getModulus();
            if (!bigInteger.equals(((C01)serializable).getPublicExponent()) || !bigInteger2.equals(((C01)serializable).getModulus())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public char[] secretStoreGetSecret(String string) throws OracleSecretStoreException {
        if (this.secretStoreContainsAlias(string)) {
            return ((C12)this.C.get(string)).a();
        }
        return null;
    }

    boolean n(OraclePKIX509CertImpl oraclePKIX509CertImpl) throws IOException {
        boolean bl = false;
        Set set = this.A.entrySet();
        Iterator iterator = set.iterator();
        block0: while (iterator.hasNext() && !bl) {
            Certificate[] certificateArray;
            Map.Entry entry = iterator.next();
            if (!((C00)entry.getValue() instanceof C20) || (certificateArray = ((C20)entry.getValue()).f()) == null) continue;
            for (int i = 0; i < certificateArray.length; ++i) {
                if (!oraclePKIX509CertImpl.equals(certificateArray[i])) continue;
                bl = true;
                continue block0;
            }
        }
        return bl;
    }

    public String engineGetCertificateAlias(Certificate certificate) {
        Set set = this.A.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!((C00)entry.getValue()).e().equals(certificate)) continue;
            return (String)entry.getKey();
        }
        return null;
    }

    public boolean engineIsCertificateEntry(String string) {
        if (this.engineContainsAlias(string)) {
            return ((C00)this.A.get(string)).d();
        }
        return false;
    }

    public void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        throw new KeyStoreException("Not Implemented");
    }

    byte[] o(InputStream inputStream, char[] cArray, String string) throws IOException, KeyStoreException, CertificateEncodingException {
        PKCS12Safe pKCS12Safe;
        String string2;
        OraclePKIX509CertImpl oraclePKIX509CertImpl = null;
        boolean bl = false;
        Enumeration enumeration = this.engineAliases();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            if (!this.engineIsKeyEntry(string2) || (oraclePKIX509CertImpl = (OraclePKIX509CertImpl)this.engineGetCertificate(string2)) == null || !string.equals(string2)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            OraclePKIDebug.b("internalRemoveUserCert: No user cert in wallet with matching DN.");
            throw new IOException("No user cert in wallet with matching DN.");
        }
        string2 = new PKCS12();
        string2.setPassword(new String(cArray));
        if (inputStream != null) {
            pKCS12Safe = new PKCS12(new String(cArray), inputStream);
            string2.setAuthSafes(pKCS12Safe.getAuthSafes());
        }
        OraclePKIDebug.b("OracleKeyStoreSpi: using safe 0");
        pKCS12Safe = (PKCS12Safe)string2.getAuthSafes().elementAt(0);
        Vector vector = pKCS12Safe.getBags();
        Vector<PKCS12Bag> vector2 = new Vector<PKCS12Bag>(vector.size());
        OraclePKIDebug.b("OracleKeyStoreSpi: safe has " + vector.size() + " bags");
        for (int i = 0; i < vector.size(); ++i) {
            PKCS12Bag pKCS12Bag = (PKCS12Bag)vector.elementAt(i);
            if (OracleKeyStoreSpi.j(pKCS12Bag) && OracleLocalKeyId.d(pKCS12Bag.getLocalKeyID())) {
                X509 x509 = ((PKCS12CertBag)pKCS12Bag).getCert();
                X509 x5092 = new X509(oraclePKIX509CertImpl.getEncoded());
                if (x5092.equals((Object)x509)) continue;
                vector2.addElement(pKCS12Bag);
                continue;
            }
            vector2.addElement(pKCS12Bag);
        }
        pKCS12Safe.setBags(vector2);
        if (vector2.size() > 0 && string2.getAuthSafes().size() == 0) {
            string2.addAuthSafe(pKCS12Safe);
        }
        OraclePKIDebug.b("OracleKeyStoreSpi: wallet has " + string2.getAuthSafes().size() + " safes");
        OraclePKIDebug.b("OracleKeyStoreSpi: wallet size " + string2.length());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(string2.length());
        string2.output((OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public boolean engineIsKeyEntry(String string) {
        if (this.engineContainsAlias(string)) {
            return ((C00)this.A.get(string)).a();
        }
        return false;
    }

    byte[] p(InputStream inputStream, char[] cArray, OraclePKIX509CertImpl oraclePKIX509CertImpl) throws IOException {
        byte[] byArray = null;
        Set set = this.A.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!((C00)entry.getValue() instanceof C20)) continue;
            OraclePKIRSAPrivateKey oraclePKIRSAPrivateKey = (OraclePKIRSAPrivateKey)((C00)entry.getValue()).g();
            C01 c01 = (C01)oraclePKIX509CertImpl.getPublicKey();
            if (!this.c(c01, oraclePKIRSAPrivateKey)) continue;
            byArray = ((C20)entry.getValue()).h();
            if (((C20)entry.getValue()).e() != null) {
                throw new IOException(z.getString("UCERT_EXISTS_ERROR"));
            }
            if (oraclePKIRSAPrivateKey.getCertificateRequest() == null) {
                throw new IOException(z.getString("CERT_REQ_NOT_FOUND_ERROR"));
            }
            PKCS12 pKCS12 = new PKCS12(new String(cArray), inputStream);
            Vector vector = OracleKeyStoreSpi.b(pKCS12);
            Vector<OraclePKIX509CertImpl> vector2 = new Vector<OraclePKIX509CertImpl>(vector.size());
            vector2.addElement(oraclePKIX509CertImpl);
            X509Certificate x509Certificate = (X509Certificate)vector2.lastElement();
            while (!((Object)x509Certificate.getIssuerDN()).equals(x509Certificate.getSubjectDN())) {
                boolean bl = false;
                for (int i = 0; i < vector.size(); ++i) {
                    PKCS12CertBag pKCS12CertBag = (PKCS12CertBag)vector.elementAt(i);
                    if (!((Object)x509Certificate.getIssuerDN()).equals(pKCS12CertBag.getCert().getSubject())) continue;
                    bl = true;
                    vector2.addElement(new OraclePKIX509CertImpl(pKCS12CertBag.getCert()));
                    x509Certificate = (X509Certificate)vector2.lastElement();
                    break;
                }
                if (bl) continue;
                OraclePKIDebug.b("OracleKeyStoreSpi: Cert chain incomplete for cert ");
                throw new IOException(z.getString("CERT_CHAIN_INCOMPLETE_ERROR"));
            }
            OraclePKIDebug.b("OracleKeyStoreSpi: Cert chain determined");
            break;
        }
        if (byArray == null) {
            OraclePKIDebug.b("OracleKeyStoreSpi: No matching private key for cert");
            throw new IOException(z.getString("UNMATCHED_PRIVKEY_ERROR"));
        }
        return byArray;
    }

    static void q(InputStream inputStream, char[] cArray, OutputStream outputStream, char[] cArray2) throws IOException {
        PKCS12 pKCS12 = new PKCS12(new String(cArray), inputStream);
        boolean bl = cArray.length == cArray2.length;
        for (int i = 0; bl && i < cArray.length; ++i) {
            if (cArray[i] == cArray2[i]) continue;
            bl = false;
        }
        if (!bl) {
            pKCS12.setPassword(new String(cArray2));
            Vector vector = pKCS12.getAuthSafes();
            for (int i = 0; i < vector.size(); ++i) {
                ((PKCS12Safe)vector.elementAt(i)).setPassword(new String(cArray2));
            }
        }
        try {
            pKCS12.output(outputStream);
            OraclePKIDebug.b("Verifying wallet " + pKCS12.verify());
        }
        catch (AuthenticationException authenticationException) {
            OraclePKIDebug.b("Verifying wallet failed" + (Object)((Object)authenticationException));
            throw new IOException("Could not store wallet " + (Object)((Object)authenticationException));
        }
    }

    public boolean engineContainsAlias(String string) {
        return this.A.containsKey(string);
    }

    private static boolean r(PKCS12Bag pKCS12Bag) {
        return pKCS12Bag instanceof PKCS12KeyBag || pKCS12Bag instanceof PKCS12ShroudedKeyBag;
    }

    byte[] i(InputStream inputStream, char[] cArray) throws IOException, KeyStoreException, CertificateEncodingException {
        OraclePKIX509CertImpl oraclePKIX509CertImpl;
        String string;
        Enumeration enumeration = this.engineAliases();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            if (!this.engineIsCertificateEntry(string) || (oraclePKIX509CertImpl = (OraclePKIX509CertImpl)this.engineGetCertificate(string)) == null || !this.n(oraclePKIX509CertImpl)) continue;
            OraclePKIDebug.b("Trusted cert is used in cert chain.");
            throw new IOException("Trusted cert:" + ((Object)oraclePKIX509CertImpl.getSubjectDN()).toString() + " is used in cert chain.");
        }
        string = new PKCS12();
        string.setPassword(new String(cArray));
        if (inputStream != null) {
            oraclePKIX509CertImpl = new PKCS12(new String(cArray), inputStream);
            string.setAuthSafes(oraclePKIX509CertImpl.getAuthSafes());
        }
        OraclePKIDebug.b("OracleKeyStoreSpi: using safe 0");
        oraclePKIX509CertImpl = (PKCS12Safe)string.getAuthSafes().elementAt(0);
        Vector vector = oraclePKIX509CertImpl.getBags();
        Vector<PKCS12Bag> vector2 = new Vector<PKCS12Bag>(vector.size());
        OraclePKIDebug.b("OracleKeyStoreSpi: safe has " + vector.size() + " bags");
        for (int i = 0; i < vector.size(); ++i) {
            PKCS12Bag pKCS12Bag = (PKCS12Bag)vector.elementAt(i);
            if (OracleKeyStoreSpi.j(pKCS12Bag) && OracleLocalKeyId.i(pKCS12Bag.getLocalKeyID())) continue;
            vector2.addElement(pKCS12Bag);
        }
        oraclePKIX509CertImpl.setBags(vector2);
        if (vector2.size() > 0 && string.getAuthSafes().size() == 0) {
            string.addAuthSafe((PKCS12Safe)oraclePKIX509CertImpl);
        }
        OraclePKIDebug.b("OracleKeyStoreSpi: wallet has " + string.getAuthSafes().size() + " safes");
        OraclePKIDebug.b("OracleKeyStoreSpi: wallet size " + string.length());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(string.length());
        string.output((OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    byte[] e(InputStream inputStream, char[] cArray, X500Principal x500Principal) throws IOException, KeyStoreException, CertificateEncodingException {
        String string;
        String string2;
        OraclePKIX509CertImpl oraclePKIX509CertImpl = null;
        boolean bl = false;
        X500Name x500Name = new X500Name(x500Principal.toString());
        Enumeration enumeration = this.engineAliases();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            if (!this.engineIsKeyEntry(string2) || (oraclePKIX509CertImpl = (OraclePKIX509CertImpl)this.engineGetCertificate(string2)) == null || !(string = ((Object)oraclePKIX509CertImpl.getSubjectDN()).toString().toUpperCase()).startsWith(x500Name.toString().toUpperCase())) continue;
            bl = true;
            break;
        }
        if (!bl) {
            OraclePKIDebug.b("internalRemoveUserCert: No user cert in wallet with matching DN.");
            throw new IOException("No user cert in wallet with matching DN.");
        }
        string2 = new PKCS12();
        string2.setPassword(new String(cArray));
        if (inputStream != null) {
            string = new PKCS12(new String(cArray), inputStream);
            string2.setAuthSafes(string.getAuthSafes());
        }
        OraclePKIDebug.b("OracleKeyStoreSpi: using safe 0");
        string = (PKCS12Safe)string2.getAuthSafes().elementAt(0);
        Vector vector = string.getBags();
        Vector<PKCS12Bag> vector2 = new Vector<PKCS12Bag>(vector.size());
        OraclePKIDebug.b("OracleKeyStoreSpi: safe has " + vector.size() + " bags");
        for (int i = 0; i < vector.size(); ++i) {
            PKCS12Bag pKCS12Bag = (PKCS12Bag)vector.elementAt(i);
            if (OracleKeyStoreSpi.j(pKCS12Bag) && OracleLocalKeyId.d(pKCS12Bag.getLocalKeyID())) {
                X509 x509 = ((PKCS12CertBag)pKCS12Bag).getCert();
                X509 x5092 = new X509(oraclePKIX509CertImpl.getEncoded());
                if (x5092.equals((Object)x509)) continue;
                vector2.addElement(pKCS12Bag);
                continue;
            }
            vector2.addElement(pKCS12Bag);
        }
        string.setBags(vector2);
        if (vector2.size() > 0 && string2.getAuthSafes().size() == 0) {
            string2.addAuthSafe((PKCS12Safe)string);
        }
        OraclePKIDebug.b("OracleKeyStoreSpi: wallet has " + string2.getAuthSafes().size() + " safes");
        OraclePKIDebug.b("OracleKeyStoreSpi: wallet size " + string2.length());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(string2.length());
        string2.output((OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    byte[] d(InputStream inputStream, char[] cArray) throws IOException, OracleSecretStoreException {
        Object object;
        PKCS12 pKCS12;
        PKCS12 pKCS122 = null;
        pKCS122 = new PKCS12();
        pKCS122.setPassword(new String(cArray));
        if (inputStream != null) {
            pKCS12 = new PKCS12(new String(cArray), inputStream);
            pKCS122.setAuthSafes(pKCS12.getAuthSafes());
            OracleKeyStoreSpi.a(pKCS122);
        }
        pKCS12 = null;
        if (pKCS122.getAuthSafes().size() == 0) {
            OraclePKIDebug.b("OracleKeyStoreSpi: creating new secret store");
            pKCS12 = new PKCS12Safe(pKCS122);
            pKCS12.setMode(3);
        } else {
            OraclePKIDebug.b("OracleKeyStoreSpi: using safe 0");
            pKCS12 = (PKCS12Safe)pKCS122.getAuthSafes().elementAt(0);
        }
        Vector vector = pKCS12.getBags();
        OraclePKIDebug.b("OracleKeyStoreSpi: safe has " + vector.size() + "bags");
        if (this.C.size() > 0) {
            object = this.C.entrySet();
            Iterator iterator = object.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                C12 c12 = (C12)iterator.next().getValue();
                PKCS12SecretBag pKCS12SecretBag = new PKCS12SecretBag((PKCS12Safe)pKCS12);
                c12.b(pKCS12SecretBag);
                pKCS12SecretBag.setLocalKeyID(OracleLocalKeyId.b(0, n));
                vector.insertElementAt(pKCS12SecretBag, 0);
                ++n;
                OraclePKIDebug.b("OracleWallet: added secret bag");
            }
        }
        pKCS12.setBags(vector);
        if (vector.size() > 0 && pKCS122.getAuthSafes().size() == 0) {
            pKCS122.addAuthSafe((PKCS12Safe)pKCS12);
        }
        OraclePKIDebug.b("OracleWallet: wallet has " + pKCS122.getAuthSafes().size() + " safes");
        OraclePKIDebug.b("OracleWallet: wallet size " + pKCS122.length());
        object = new ByteArrayOutputStream(pKCS122.length());
        pKCS122.output((OutputStream)object);
        return ((ByteArrayOutputStream)object).toByteArray();
    }

    public void engineLoad(InputStream inputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        PKCS12 pKCS12 = null;
        OraclePKIDebug.b("OracleKeyStoreSpi: Loading wallet from stream");
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new OracleWalletPermission("load"));
        }
        if (inputStream == null) {
            pKCS12 = new PKCS12();
            pKCS12.setPassword(new String(cArray));
        } else {
            pKCS12 = new PKCS12(new String(cArray), inputStream);
        }
        boolean bl = false;
        try {
            bl = pKCS12.verify();
        }
        catch (AuthenticationException authenticationException) {
            bl = false;
        }
        if (!bl) {
            throw new IOException("Invalid MAC for Wallet");
        }
        this.s(pKCS12);
        OraclePKIDebug.b("OracleKeyStoreSpi: Keystore Loaded");
    }

    void s(PKCS12 pKCS12) throws NoSuchAlgorithmException, CertificateException, IOException {
        int n;
        String string;
        PKCS12Bag pKCS12Bag;
        String string2;
        Object object;
        int n2;
        Vector vector = OracleKeyStoreSpi.t(pKCS12);
        Vector vector2 = OracleKeyStoreSpi.b(pKCS12);
        Vector vector3 = OracleKeyStoreSpi.a(pKCS12);
        Vector vector4 = OracleKeyStoreSpi.g(pKCS12);
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>(vector.size() + vector2.size());
        Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>(vector3.size());
        for (n2 = 0; n2 < vector.size(); ++n2) {
            OraclePKIDebug.b("Processing identity " + n2);
            object = new C20((PKCS12Bag)vector.elementAt(n2), vector2, vector4);
            string2 = null;
            pKCS12Bag = (PKCS12Bag)vector.elementAt(n2);
            string = pKCS12Bag.getFriendlyName();
            if (string != null) {
                string2 = string;
            } else {
                string2 = ((C00)object).c();
                n = 1;
                while (hashtable.containsKey(string2)) {
                    string2 = string2 + ' ' + Integer.toString(n);
                    ++n;
                }
            }
            OraclePKIDebug.b("Storing identity " + n2 + " as " + string2);
            hashtable.put(string2, object);
        }
        for (n2 = 0; n2 < vector2.size(); ++n2) {
            OraclePKIDebug.b("Processing TP " + n2);
            object = new C10((PKCS12CertBag)vector2.elementAt(n2));
            string2 = null;
            pKCS12Bag = (PKCS12Bag)vector2.elementAt(n2);
            string = pKCS12Bag.getFriendlyName();
            if (string != null) {
                string2 = string;
            } else {
                string2 = ((C00)object).c();
                n = 1;
                while (hashtable.containsKey(string2)) {
                    string2 = ((C00)object).c() + ' ' + Integer.toString(n);
                    ++n;
                }
            }
            OraclePKIDebug.b("Storing TP " + n2 + " as " + string2);
            hashtable.put(string2, object);
        }
        try {
            for (n2 = 0; n2 < vector3.size(); ++n2) {
                OraclePKIDebug.b("OracleKeyStoreSpi: Storing Secret" + n2);
                object = new C12((PKCS12SecretBag)vector3.elementAt(n2));
                hashtable2.put(((C12)object).d(), object);
            }
        }
        catch (OracleSecretStoreException oracleSecretStoreException) {
            throw new IOException(oracleSecretStoreException.toString());
        }
        this.A = hashtable;
        this.C = hashtable2;
    }

    private static Vector t(PKCS12 pKCS12) {
        Vector vector = pKCS12.getAuthSafes();
        Vector<PKCS12Bag> vector2 = new Vector<PKCS12Bag>();
        for (int i = 0; i < vector.size(); ++i) {
            PKCS12Safe pKCS12Safe = (PKCS12Safe)vector.elementAt(i);
            OraclePKIDebug.b("OracleKeyStoreSpi: Opening safe " + i);
            Vector vector3 = pKCS12Safe.getBags();
            for (int j = 0; j < vector3.size(); ++j) {
                PKCS12Bag pKCS12Bag = (PKCS12Bag)vector3.elementAt(j);
                if (!OracleKeyStoreSpi.r(pKCS12Bag)) continue;
                OraclePKIDebug.b("OracleKeyStoreSpi: found key bag");
                vector2.addElement(pKCS12Bag);
                vector3.removeElementAt(j);
                --j;
            }
            pKCS12Safe.setBags(vector3);
        }
        return vector2;
    }

    public void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        throw new KeyStoreException("Not Implemented");
    }

    byte[] b(InputStream inputStream, char[] cArray, String string) throws IOException, KeyStoreException, CertificateEncodingException, NoSuchAlgorithmException, UnrecoverableKeyException {
        ASN1Object aSN1Object;
        PKCS12Safe pKCS12Safe;
        Object object;
        Object object2;
        CertificateRequest certificateRequest = null;
        boolean bl = false;
        Enumeration enumeration = this.engineAliases();
        while (enumeration.hasMoreElements()) {
            object2 = (String)enumeration.nextElement();
            if (!this.engineIsKeyEntry((String)object2) || !string.equals(object2) || (certificateRequest = ((OraclePKIRSAPrivateKey)this.engineGetKey((String)object2, null)).getCertificateRequest()) == null) continue;
            object = (OraclePKIX509CertImpl)this.engineGetCertificate((String)object2);
            if (object != null) {
                throw new IOException("User cert is in wallet. Cannot remove cert request with DN:" + certificateRequest.getSubject().toString());
            }
            bl = true;
            break;
        }
        if (!bl) {
            OraclePKIDebug.b("internalRemoveCertReq: No cert request in wallet with matching alias.");
            throw new IOException("No cert request in wallet with matching alias.");
        }
        object2 = new ByteArrayOutputStream();
        certificateRequest.output((OutputStream)object2);
        object = ((ByteArrayOutputStream)object2).toByteArray();
        byte[] byArray = null;
        PKCS12 pKCS12 = new PKCS12();
        pKCS12.setPassword(new String(cArray));
        if (inputStream != null) {
            pKCS12Safe = new PKCS12(new String(cArray), inputStream);
            pKCS12.setAuthSafes(pKCS12Safe.getAuthSafes());
        }
        OraclePKIDebug.b("OracleKeyStoreSpi: using safe 0");
        pKCS12Safe = (PKCS12Safe)pKCS12.getAuthSafes().elementAt(0);
        Vector vector = pKCS12Safe.getBags();
        OraclePKIDebug.b("OracleKeyStoreSpi: safe has " + vector.size() + " bags");
        for (int i = 0; i < vector.size(); ++i) {
            byte[] byArray2;
            boolean bl2;
            PKCS12Bag pKCS12Bag = (PKCS12Bag)vector.elementAt(i);
            if (!OracleKeyStoreSpi.u(pKCS12Bag) || !(bl2 = Arrays.equals(object, byArray2 = ((ASN1OctetString)(aSN1Object = ((PKCS12SecretBag)pKCS12Bag).getSecretValue())).getValue()))) continue;
            byArray = pKCS12Bag.getLocalKeyID();
            vector.removeElementAt(i);
            break;
        }
        byte[] byArray3 = OracleLocalKeyId.h(OracleLocalKeyId.f(byArray), OracleLocalKeyId.a(byArray));
        for (int i = 0; i < vector.size(); ++i) {
            aSN1Object = (PKCS12Bag)vector.elementAt(i);
            if (!OracleKeyStoreSpi.r((PKCS12Bag)aSN1Object) || !this.i(aSN1Object.getLocalKeyID(), byArray3)) continue;
            vector.removeElementAt(i);
            break;
        }
        pKCS12Safe.setBags(vector);
        if (vector.size() > 0 && pKCS12.getAuthSafes().size() == 0) {
            pKCS12.addAuthSafe(pKCS12Safe);
        }
        OraclePKIDebug.b("OracleKeyStoreSpi: wallet has " + pKCS12.getAuthSafes().size() + " safes");
        OraclePKIDebug.b("OracleKeyStoreSpi: wallet size " + pKCS12.length());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(pKCS12.length());
        pKCS12.output((OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public Certificate[] engineGetCertificateChain(String string) {
        OraclePKIDebug.b("OracleKeyStoreSpi: getCertificateChain alias \"" + (null == string ? "null" : string) + "\"");
        if (this.engineContainsAlias(string)) {
            return ((C00)this.A.get(string)).f();
        }
        return null;
    }

    public void engineStore(OutputStream outputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
    }

    public Key engineGetKey(String string, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        if (this.engineContainsAlias(string)) {
            return ((C00)this.A.get(string)).g();
        }
        return null;
    }

    private static boolean u(PKCS12Bag pKCS12Bag) {
        if (!(pKCS12Bag instanceof PKCS12SecretBag)) {
            return false;
        }
        return OracleLocalKeyId.c(pKCS12Bag.getLocalKeyID());
    }

    public void secretStoreModifyCredential(char[] cArray, char[] cArray2, char[] cArray3) throws OracleSecretStoreException {
        boolean bl = false;
        Enumeration enumeration = new Vector(this.C.values()).elements();
        System.out.println("Modify credential ");
        while (enumeration.hasMoreElements()) {
            C12 c12 = (C12)enumeration.nextElement();
            String string = new String(c12.a());
            String string2 = c12.d();
            if (!string2.startsWith(CREDENTIAL_CONNECT_STRING) || !string.equalsIgnoreCase(new String(cArray))) continue;
            String string3 = string2.substring(CREDENTIAL_CONNECT_STRING.length());
            System.out.println("Modify " + string3);
            this.secretStoreDeleteSecret(CREDENTIAL_USERNAME + string3);
            this.secretStoreSetSecret(CREDENTIAL_USERNAME + string3, cArray2);
            this.secretStoreDeleteSecret(CREDENTIAL_PASSWORD + string3);
            this.secretStoreSetSecret(CREDENTIAL_PASSWORD + string3, cArray3);
            bl = true;
            break;
        }
        if (!bl) {
            throw new OracleSecretStoreException("Credential does not exists");
        }
    }

    private static boolean v(PKCS12Bag pKCS12Bag) {
        if (!(pKCS12Bag instanceof PKCS12SecretBag)) {
            return false;
        }
        return OracleLocalKeyId.k(pKCS12Bag.getLocalKeyID());
    }

    int w(InputStream inputStream, char[] cArray, String string) throws IOException, KeyStoreException, CertificateEncodingException, NoSuchAlgorithmException, UnrecoverableKeyException {
        PKCS12Safe pKCS12Safe;
        Object object;
        CertificateRequest certificateRequest = null;
        boolean bl = false;
        Enumeration enumeration = this.engineAliases();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (!this.engineIsKeyEntry((String)object) || !string.equals(object) || (certificateRequest = ((OraclePKIRSAPrivateKey)this.engineGetKey((String)object, null)).getCertificateRequest()) == null) continue;
            bl = true;
            break;
        }
        if (!bl) {
            OraclePKIDebug.b("internalGetCRCompNum: No cert request in wallet with matching alias.");
            throw new IOException("No cert request in wallet with matching alias.");
        }
        object = new ByteArrayOutputStream();
        certificateRequest.output((OutputStream)object);
        byte[] byArray = ((ByteArrayOutputStream)object).toByteArray();
        byte[] byArray2 = null;
        PKCS12 pKCS12 = new PKCS12();
        pKCS12.setPassword(new String(cArray));
        if (inputStream != null) {
            pKCS12Safe = new PKCS12(new String(cArray), inputStream);
            pKCS12.setAuthSafes(pKCS12Safe.getAuthSafes());
        }
        OraclePKIDebug.b("OracleKeyStoreSpi: using safe 0");
        pKCS12Safe = (PKCS12Safe)pKCS12.getAuthSafes().elementAt(0);
        Vector vector = pKCS12Safe.getBags();
        OraclePKIDebug.b("OracleKeyStoreSpi: safe has " + vector.size() + " bags");
        for (int i = 0; i < vector.size(); ++i) {
            ASN1Object aSN1Object;
            byte[] byArray3;
            boolean bl2;
            PKCS12Bag pKCS12Bag = (PKCS12Bag)vector.elementAt(i);
            if (!OracleKeyStoreSpi.u(pKCS12Bag) || !(bl2 = Arrays.equals(byArray, byArray3 = ((ASN1OctetString)(aSN1Object = ((PKCS12SecretBag)pKCS12Bag).getSecretValue())).getValue()))) continue;
            byArray2 = pKCS12Bag.getLocalKeyID();
            return OracleLocalKeyId.a(byArray2);
        }
        throw new IOException("Check wallet.");
    }

    void x(PKCS12 pKCS12) {
        System.out.println("-------------------");
        PKCS12Safe pKCS12Safe = (PKCS12Safe)pKCS12.getAuthSafes().elementAt(0);
        Vector vector = pKCS12Safe.getBags();
        for (int i = 0; i < vector.size(); ++i) {
            PKCS12Bag pKCS12Bag = (PKCS12Bag)vector.elementAt(i);
            byte[] byArray = pKCS12Bag.getLocalKeyID();
            if (OracleKeyStoreSpi.u(pKCS12Bag)) {
                System.out.println("CertReqBag = " + OracleLocalKeyId.a(byArray));
            }
            if (OracleKeyStoreSpi.j(pKCS12Bag) && OracleLocalKeyId.d(byArray)) {
                System.out.println("User CertBag = " + OracleLocalKeyId.a(byArray));
            }
            if (OracleKeyStoreSpi.j(pKCS12Bag) && OracleLocalKeyId.i(pKCS12Bag.getLocalKeyID())) {
                System.out.println("Trusted CertBag = " + OracleLocalKeyId.a(byArray));
            }
            if (OracleKeyStoreSpi.r(pKCS12Bag)) {
                System.out.println("KeyBag = " + OracleLocalKeyId.a(byArray));
            }
            if (!OracleKeyStoreSpi.v(pKCS12Bag)) continue;
            System.out.println("SecretStoreBag = " + OracleLocalKeyId.a(byArray));
        }
    }

    public void secretStoreCreateCredential(char[] cArray, char[] cArray2, char[] cArray3) throws OracleSecretStoreException {
        int n = 1;
        Enumeration enumeration = new Vector(this.C.values()).elements();
        System.out.print("Create credential ");
        while (enumeration.hasMoreElements()) {
            C12 c12 = (C12)enumeration.nextElement();
            String string = new String(c12.a());
            String string2 = c12.d();
            if (!string2.startsWith(CREDENTIAL_CONNECT_STRING) || !string.equalsIgnoreCase(new String(cArray))) continue;
            throw new OracleSecretStoreException("Credential already exists");
        }
        while (this.secretStoreContainsAlias(CREDENTIAL_CONNECT_STRING + n)) {
            ++n;
        }
        System.out.println(CREDENTIAL_CONNECT_STRING + n);
        this.secretStoreSetSecret(CREDENTIAL_CONNECT_STRING + n, cArray);
        this.secretStoreSetSecret(CREDENTIAL_USERNAME + n, cArray2);
        this.secretStoreSetSecret(CREDENTIAL_PASSWORD + n, cArray3);
    }

    public void engineDeleteEntry(String string) throws KeyStoreException {
        if (!this.engineContainsAlias(string)) {
            throw new KeyStoreException("No such alias in KeyStore");
        }
        this.A.remove(string);
    }

    public void secretStoreSetSecret(String string, char[] cArray) throws OracleSecretStoreException {
        if (this.secretStoreContainsAlias(string)) {
            C12 c12 = (C12)this.C.get(string);
            c12.c(cArray);
        } else {
            C12 c12 = new C12(string, cArray);
            this.C.put(c12.d(), c12);
        }
    }

    public Enumeration engineAliases() {
        return new Vector(this.A.keySet()).elements();
    }

    public Date engineGetCreationDate(String string) {
        if (this.engineContainsAlias(string)) {
            return ((C00)this.A.get(string)).b();
        }
        return null;
    }

    public int engineSize() {
        return this.A.size();
    }

    byte[] h(InputStream inputStream, char[] cArray, OraclePKIX509CertImpl oraclePKIX509CertImpl, String string) throws IOException, KeyStoreException {
        Object object;
        PKCS12 pKCS12;
        if (this.m(oraclePKIX509CertImpl)) {
            throw new KeyStoreException(z.getString("TCERT_EXISTS_ERROR"));
        }
        PKCS12 pKCS122 = new PKCS12();
        pKCS122.setPassword(new String(cArray));
        if (inputStream != null) {
            pKCS12 = new PKCS12(new String(cArray), inputStream);
            pKCS122.setAuthSafes(pKCS12.getAuthSafes());
        }
        pKCS12 = null;
        if (pKCS122.getAuthSafes().size() == 0) {
            OraclePKIDebug.b("OracleKeyStoreSpi: creating new key store");
            pKCS12 = new PKCS12Safe(pKCS122);
            pKCS12.setMode(3);
        } else {
            OraclePKIDebug.b("OracleKeyStoreSpi: using safe 0");
            pKCS12 = (PKCS12Safe)pKCS122.getAuthSafes().elementAt(0);
        }
        Vector vector = pKCS12.getBags();
        OraclePKIDebug.b("OracleKeyStoreSpi: safe has " + vector.size() + " bags");
        int n = 0;
        for (int i = 0; i < vector.size(); ++i) {
            object = (PKCS12Bag)vector.elementAt(i);
            if (!OracleKeyStoreSpi.j((PKCS12Bag)object) || !OracleLocalKeyId.i(object.getLocalKeyID())) continue;
            OraclePKIDebug.b("OracleKeyStoreSpi: found cert bag");
            ++n;
        }
        PKCS12CertBag pKCS12CertBag = new PKCS12CertBag((PKCS12Safe)pKCS12, oraclePKIX509CertImpl.getX509());
        pKCS12CertBag.setLocalKeyID(OracleLocalKeyId.l(0, n));
        if (string != null) {
            pKCS12CertBag.setFriendlyName(string);
        }
        vector.addElement(pKCS12CertBag);
        OraclePKIDebug.b("OracleWallet: added key bag " + n);
        pKCS12.setBags(vector);
        if (vector.size() > 0 && pKCS122.getAuthSafes().size() == 0) {
            pKCS122.addAuthSafe((PKCS12Safe)pKCS12);
        }
        OraclePKIDebug.b("OracleKeyStoreSpi: wallet has " + pKCS122.getAuthSafes().size() + " safes");
        OraclePKIDebug.b("OracleKeyStoreSpi: wallet size " + pKCS122.length());
        object = new ByteArrayOutputStream(pKCS122.length());
        pKCS122.output((OutputStream)object);
        return ((ByteArrayOutputStream)object).toByteArray();
    }

    boolean y(X500Principal x500Principal) throws IOException, KeyStoreException, CertificateEncodingException {
        OraclePKIX509CertImpl oraclePKIX509CertImpl = null;
        boolean bl = false;
        X500Name x500Name = new X500Name(x500Principal.toString());
        Enumeration enumeration = this.engineAliases();
        while (enumeration.hasMoreElements()) {
            String string;
            String string2 = (String)enumeration.nextElement();
            if (!this.engineIsCertificateEntry(string2) || (oraclePKIX509CertImpl = (OraclePKIX509CertImpl)this.engineGetCertificate(string2)) == null || !(string = ((Object)oraclePKIX509CertImpl.getSubjectDN()).toString().toUpperCase()).startsWith(x500Name.toString().toUpperCase())) continue;
            bl = true;
            break;
        }
        if (!bl) {
            OraclePKIDebug.b("internalIsTrustedCertUsedInChain: No trusted cert in wallet with matching DN.");
            throw new IOException("No trusted cert in wallet with matching DN.");
        }
        return this.n(oraclePKIX509CertImpl);
    }
}

