/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.ResourceBundle;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NoPermissionException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import oracle.ldap.util.jndi.ConnectionUtil;
import oracle.security.crypto.cert.CRL;
import oracle.security.crypto.core.AuthenticationException;
import oracle.security.crypto.core.PublicKey;
import oracle.security.crypto.core.RSAPublicKey;
import oracle.security.pki.OraclePKIDebug;
import oracle.security.pki.OraclePKIPrincipalImpl;
import oracle.security.pki.OraclePKIX509CrlFileStore;
import oracle.security.pki.OraclePKIX509CrlHelper;
import oracle.security.pki.OracleWallet;
import oracle.security.pki.textui.OraclePKIGenFunc;

public class OracleCRL {
    static ResourceBundle d = ResourceBundle.getBundle("oracle.security.pki.resources.OraclePKIMsg");

    private static void a(String string, CRL cRL, String string2, boolean bl, boolean bl2) throws AuthenticationException, KeyStoreException, IOException {
        if (string != null) {
            OracleWallet oracleWallet = OraclePKIGenFunc.openAWallet(string, string2, bl);
            OracleCRL.c(cRL, oracleWallet);
            if (bl2) {
                System.out.println(d.getString("CRL_VERIFY_OK"));
            }
        }
    }

    private static BasicAttributes b(String string) {
        BasicAttribute basicAttribute = new BasicAttribute("objectclass");
        basicAttribute.add("orclPKICRL");
        basicAttribute.add("cRLDistributionPoint");
        basicAttribute.add("top");
        BasicAttributes basicAttributes = new BasicAttributes(true);
        basicAttributes.put(basicAttribute);
        basicAttributes.put(new BasicAttribute("x509issuer", string));
        return basicAttributes;
    }

    public static void uploadCRL(String string, char[] cArray, boolean bl, InputStream inputStream, String string2, String string3, String string4, char[] cArray2, boolean bl2) throws AuthenticationException, KeyStoreException, NameNotFoundException, NoPermissionException, NamingException, IOException {
        OraclePKIDebug.b("OracleCRL: uploadCRL");
        CRL cRL = OraclePKIX509CrlHelper.readB64CRLFrom(new InputStreamReader(inputStream));
        if (string != null && cArray != null) {
            OracleCRL.a(string, cRL, new String(cArray), bl, bl2);
        }
        if (cArray2 == null) {
            throw new NullPointerException("Ldap password should not be null.");
        }
        InitialLdapContext initialLdapContext = ConnectionUtil.getSSLDirCtx((String)string2, (String)string3, (String)string4, (String)new String(cArray2));
        BasicAttributes basicAttributes = OracleCRL.b(cRL.getIssuer().toString());
        NamingEnumeration<SearchResult> namingEnumeration = initialLdapContext.search("cn=CRLValidation,cn=Validation,cn=PKI,cn=Products,cn=OracleContext", (Attributes)basicAttributes);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        cRL.output((OutputStream)byteArrayOutputStream);
        BasicAttribute basicAttribute = new BasicAttribute("certificaterevocationlist", byteArrayOutputStream.toByteArray());
        if (bl2) {
            System.out.println(d.getString("GEN_ISSUER_OUT") + cRL.getIssuer());
        }
        if (namingEnumeration.hasMore()) {
            SearchResult searchResult = namingEnumeration.next();
            String string5 = searchResult.getName() + "," + "cn=CRLValidation,cn=Validation,cn=PKI,cn=Products,cn=OracleContext";
            BasicAttributes basicAttributes2 = new BasicAttributes();
            basicAttributes2.put(basicAttribute);
            initialLdapContext.modifyAttributes(searchResult.getName() + "," + "cn=CRLValidation,cn=Validation,cn=PKI,cn=Products,cn=OracleContext", 2, (Attributes)basicAttributes2);
            if (bl2) {
                System.out.println(d.getString("LDAP_CRL_UPDATED") + string5);
            }
        } else {
            basicAttributes.put(basicAttribute);
            String string6 = cRL.getIssuer().getCommonName() + " " + OraclePKIX509CrlFileStore.hashName(cRL.getIssuer());
            if (string6.equals("")) {
                string6 = cRL.getIssuer().getOrgUnitName();
            }
            string6 = "cn=" + string6 + "," + "cn=CRLValidation,cn=Validation,cn=PKI,cn=Products,cn=OracleContext";
            initialLdapContext.createSubcontext(string6, (Attributes)basicAttributes);
            if (bl2) {
                System.out.println(d.getString("LDAP_CRL_CREATED") + string6);
            }
        }
    }

    private static void c(CRL cRL, OracleWallet oracleWallet) throws AuthenticationException, KeyStoreException, IOException {
        OraclePKIPrincipalImpl oraclePKIPrincipalImpl = new OraclePKIPrincipalImpl(cRL.getIssuer());
        KeyStore keyStore = null;
        Enumeration<String> enumeration = null;
        if (!cRL.verifyDate()) {
            throw new AuthenticationException("CRL expired/not yet valid");
        }
        keyStore = oracleWallet.getKeyStore();
        enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            Certificate certificate = keyStore.getCertificate(enumeration.nextElement());
            if (!(certificate instanceof X509Certificate) || !oraclePKIPrincipalImpl.equals(((X509Certificate)certificate).getSubjectDN()) || !certificate.getPublicKey().getAlgorithm().equals("RSA")) continue;
            cRL.setPublicKey((PublicKey)new RSAPublicKey(certificate.getPublicKey().getEncoded()));
            if (!cRL.verify()) continue;
            return;
        }
        throw new AuthenticationException("Could not find signer for CRL");
    }
}

