/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki;

import java.io.IOException;
import java.security.Key;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.cert.CertificateRequest;
import oracle.security.crypto.cert.PKCS12Bag;
import oracle.security.crypto.cert.PKCS12CertBag;
import oracle.security.crypto.cert.PKCS12KeyBag;
import oracle.security.crypto.cert.PKCS12SecretBag;
import oracle.security.crypto.cert.PKCS12ShroudedKeyBag;
import oracle.security.crypto.core.DSAPrivateKey;
import oracle.security.crypto.core.PrivateKey;
import oracle.security.crypto.core.RSAPrivateKey;
import oracle.security.pki.C00;
import oracle.security.pki.OracleLocalKeyId;
import oracle.security.pki.OraclePKIDebug;
import oracle.security.pki.OraclePKIRSAPrivateKey;
import oracle.security.pki.OraclePKIX509CertImpl;

class C20
extends C00 {
    final PKCS12Bag i;
    Certificate[] j;
    private CertificateRequest k;

    C20(PKCS12Bag pKCS12Bag, Vector vector, Vector vector2) {
        Object object;
        if (!(pKCS12Bag instanceof PKCS12KeyBag) && !(pKCS12Bag instanceof PKCS12ShroudedKeyBag)) {
            throw new IllegalArgumentException("Incorrect bag type" + pKCS12Bag);
        }
        this.i = pKCS12Bag;
        byte[] byArray = this.i.getLocalKeyID();
        Vector<OraclePKIX509CertImpl> vector3 = new Vector<OraclePKIX509CertImpl>(vector.size());
        for (int i = 0; i < vector.size(); ++i) {
            PKCS12CertBag pKCS12CertBag = (PKCS12CertBag)vector.elementAt(i);
            if (!this.a(pKCS12CertBag.getLocalKeyID(), byArray)) continue;
            vector3.addElement(new OraclePKIX509CertImpl(pKCS12CertBag.getCert()));
            vector.removeElementAt(i);
            OraclePKIDebug.b("Found certificate " + pKCS12CertBag.getCert());
            break;
        }
        byte[] byArray2 = OracleLocalKeyId.j(OracleLocalKeyId.f(byArray), OracleLocalKeyId.a(byArray));
        for (int i = 0; i < vector2.size(); ++i) {
            ASN1Object aSN1Object;
            PKCS12SecretBag pKCS12SecretBag = (PKCS12SecretBag)vector2.elementAt(i);
            if (!this.a(pKCS12SecretBag.getLocalKeyID(), byArray2) || !((aSN1Object = pKCS12SecretBag.getSecretValue()) instanceof ASN1OctetString)) continue;
            try {
                object = ((ASN1OctetString)aSN1Object).getValue();
                this.k = new CertificateRequest(object);
                OraclePKIDebug.b("Found cert req " + this.k);
                break;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (vector3.size() == 0) {
            OraclePKIDebug.b("No certificate found for key " + this.i.getLocalKeyID());
            this.j = null;
        } else {
            X509Certificate x509Certificate = (X509Certificate)vector3.lastElement();
            while (!((Object)x509Certificate.getIssuerDN()).equals(x509Certificate.getSubjectDN())) {
                boolean bl = false;
                for (int i = 0; i < vector.size(); ++i) {
                    object = (PKCS12CertBag)vector.elementAt(i);
                    if (!((Object)x509Certificate.getIssuerDN()).equals(object.getCert().getSubject())) continue;
                    bl = true;
                    vector3.addElement(new OraclePKIX509CertImpl(object.getCert()));
                    x509Certificate = (X509Certificate)vector3.lastElement();
                    break;
                }
                if (bl) continue;
                OraclePKIDebug.b("Cert chain incomplete for key " + this.i);
                break;
            }
            OraclePKIDebug.b("Cert chain determined");
            this.j = new Certificate[vector3.size()];
            this.j = vector3.toArray(this.j);
        }
    }

    boolean a() {
        return true;
    }

    private boolean a(byte[] byArray, byte[] byArray2) {
        if (byArray == null | byArray2 == null) {
            return false;
        }
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    byte[] h() {
        return this.i.getLocalKeyID();
    }

    String c() {
        Certificate certificate = this.e();
        if (certificate instanceof X509Certificate) {
            OraclePKIDebug.b("Certificate for private key is " + certificate);
            return ((X509Certificate)certificate).getSubjectDN().getName();
        }
        return "";
    }

    Certificate e() {
        if (this.j == null) {
            return null;
        }
        return this.j[0];
    }

    Certificate[] f() {
        if (this.j == null) {
            return null;
        }
        return (Certificate[])this.j.clone();
    }

    Key g() {
        PrivateKey privateKey = null;
        if (this.i instanceof PKCS12KeyBag) {
            privateKey = ((PKCS12KeyBag)this.i).getPrivateKey();
        } else if (this.i instanceof PKCS12ShroudedKeyBag) {
            privateKey = ((PKCS12ShroudedKeyBag)this.i).getPrivateKey();
        }
        if (privateKey instanceof RSAPrivateKey) {
            return new OraclePKIRSAPrivateKey((RSAPrivateKey)privateKey, this.k);
        }
        if (privateKey instanceof DSAPrivateKey) {
            OraclePKIDebug.b("DSA Keys not supported");
            return null;
        }
        return null;
    }
}

