/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.Collator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import oracle.security.pki.OraclePKIProvider;

public class KeyStoreTest {
    private char[] k;
    private KeyStore l = KeyStore.getInstance(n, m);
    static String m;
    static String n;
    static String o;

    private Enumeration a(Enumeration enumeration) {
        TreeSet<Object> treeSet = new TreeSet<Object>(Collator.getInstance());
        while (enumeration.hasMoreElements()) {
            treeSet.add(enumeration.nextElement());
        }
        Iterator<Object> iterator = treeSet.iterator();
        Vector<Object> vector = new Vector<Object>(treeSet.size());
        int n = 0;
        while (iterator.hasNext()) {
            vector.add(iterator.next());
            ++n;
        }
        return vector.elements();
    }

    private void b(KeyStore keyStore) throws KeyStoreException {
        String string;
        System.out.println("Printing information about KeyStore:");
        System.out.println("KeyStore contains " + keyStore.size() + " entries.");
        System.out.println("Before the entry deletion...");
        Enumeration enumeration = this.a(keyStore.aliases());
        int n = 0;
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            System.out.println("Entry[" + n + "]");
            System.out.println("  Alias: \"" + string + "\"");
            System.out.println("  Created At: " + keyStore.getCreationDate(string));
            System.out.println();
            ++n;
        }
        System.out.println();
        String string2 = "CN=akoyfman-sun,OU=DAS,O=Oracle Corp.,L=Redwood Shores,ST=CA,C=US";
        string = "CN=akoyfman-sun,OU=DAS,O=Oracle Corp.,L=Redwood Shores,ST=CA,C=US";
        keyStore.deleteEntry(string2);
        System.out.println("After the entry deletion...");
        Enumeration enumeration2 = this.a(keyStore.aliases());
        int n2 = 0;
        while (enumeration2.hasMoreElements()) {
            String string3 = (String)enumeration2.nextElement();
            System.out.println("Entry[" + n2 + "]");
            System.out.println("  Alias: \"" + string3 + "\"");
            System.out.println("  Created At: " + keyStore.getCreationDate(string3));
            System.out.println();
            ++n2;
        }
    }

    private void c(KeyStore keyStore) throws KeyStoreException {
        Enumeration enumeration = this.a(keyStore.aliases());
        String string = "CN=JavaSSL Test,OU=DAS,O=Oracle,L=Redwood Shores,ST=CA,C=US";
        String string2 = "CN=JavaSSL Test, OU=DAS, O=Oracle, L=Redwood Shores, ST=CA, C=US";
        String string3 = "CN=JavaSSL Test,OU=DAS,O=oracle,L=redwood shores,ST=Ca,C=Us";
        String string4 = "CN=JavaSSL Test,OU=DAS,O=Oracle,L=Redwood Shores,ST=CA,C=TW";
        String string5 = (String)enumeration.nextElement();
        System.out.println("Alias 1: " + string);
        if (keyStore.containsAlias(string)) {
            System.out.println("IS in the KeyStore");
        } else {
            System.out.println("IS NOT in the KeyStore");
        }
        System.out.println();
        System.out.println("Alias 2: " + string2);
        if (keyStore.containsAlias(string2)) {
            System.out.println("IS in the KeyStore");
        } else {
            System.out.println("IS NOT in the KeyStore");
        }
        System.out.println();
        System.out.println("Alias 3: " + string3);
        if (keyStore.containsAlias(string3)) {
            System.out.println("IS in the KeyStore");
        } else {
            System.out.println("IS NOT in the KeyStore");
        }
        System.out.println();
        System.out.println("Alias 4: " + string4);
        if (keyStore.containsAlias(string4)) {
            System.out.println("IS in the KeyStore");
        } else {
            System.out.println("IS NOT in the KeyStore");
        }
        System.out.println();
        System.out.println("Alias 5: " + string5);
        if (keyStore.containsAlias(string5)) {
            System.out.println("IS in the KeyStore");
        } else {
            System.out.println("IS NOT in the KeyStore");
        }
        System.out.println();
    }

    private void d(KeyStore keyStore) throws KeyStoreException {
        String string = "CN=akoyfman-sun,OU=DAS,O=Oracle Corp.,L=Redwood Shores,ST=CA,C=US";
        String string2 = "CN=JavaSSL Test,OU=DAS,O=Oracle,L=Redwood Shores,ST=CA,C=US";
        String string3 = "CN=JavaSSL Test,OU=DAS,O=Oracle,L=Redwood Shores,ST=AZ,C=US";
        System.out.println();
        System.out.println("Testing isCertEntry");
        if (keyStore.isCertificateEntry(string)) {
            System.out.println("Good- it passed");
        } else {
            System.out.println("Bad- the test failed");
        }
        if (keyStore.isCertificateEntry(string2)) {
            System.out.println("Bad- the test failed");
        } else {
            System.out.println("Good- it passed");
        }
        if (keyStore.isCertificateEntry(string3)) {
            System.out.println("Bad- the test failed");
        } else {
            System.out.println("Good- it passed");
        }
    }

    static {
        o = "Usage: java [-DKeyStoreType={PKCS12|JKS|SSO}] [-D KeyStoreProvider=provider]KeyStoreTest [ -help ] [ -loadfile file ] [ -loadpass pass ] [ -tests <> ] ";
        n = System.getProperty("KeyStoreType", "PKCS12");
        m = System.getProperty("KeyStoreProvider", "OraclePKI");
    }

    private void e(KeyStore keyStore) throws KeyStoreException {
        String string = "CN=akoyfman-sun,OU=DAS,O=Oracle Corp.,L=Redwood Shores,ST=CA,C=US";
        String string2 = "CN=JavaSSL Test,OU=DAS,O=Oracle,L=Redwood Shores,ST=CA,C=US";
        String string3 = "CN=JavaSSL Test,OU=DAS,O=Oracle,L=Redwood Shores,ST=AZ,C=US";
        System.out.println("Testing isKeyEntry");
        if (keyStore.isKeyEntry(string)) {
            System.out.println("Bad- the test failed");
        } else {
            System.out.println("Good- it passed");
        }
        if (keyStore.isKeyEntry(string2)) {
            System.out.println("Good- it passed");
        } else {
            System.out.println("Bad- the test failed");
        }
        if (keyStore.isKeyEntry(string3)) {
            System.out.println("Bad- the test failed");
        } else {
            System.out.println("Good- it passed");
        }
    }

    private void f(KeyStore keyStore) throws KeyStoreException {
        System.out.println("Using type " + keyStore.getType());
        System.out.println();
    }

    private void g(KeyStore keyStore) throws KeyStoreException {
        String string;
        String string2 = "CN=JavaSSL Test,OU=DAS,O=Oracle,L=Redwood Shores,ST=CA,C=US";
        String string3 = "CN=JavaSSL Test, OU=DAS, O=Oracle, L=Redwood Shores, ST=CA, C=US";
        String string4 = "CN=JavaSSL Test,OU=DAS,O=Oracle,L=Redwood Shores,ST=CA,C=TW";
        try {
            Certificate certificate = keyStore.getCertificate(string2);
            string = keyStore.getCertificateAlias(certificate);
            System.out.println();
            System.out.println("Certificate 1:");
            System.out.println(string);
        }
        catch (Exception exception) {
            System.out.println("Get 1st certificate Failed");
            exception.printStackTrace();
        }
        try {
            Certificate certificate = keyStore.getCertificate(string3);
            string = keyStore.getCertificateAlias(certificate);
            System.out.println();
            System.out.println("Certificate2:");
            System.out.println(string);
        }
        catch (Exception exception) {
            System.out.println("Get 2nd certificate Failed");
            exception.printStackTrace();
        }
        try {
            Certificate certificate = keyStore.getCertificate(string4);
            string = keyStore.getCertificateAlias(certificate);
            System.out.println();
            System.out.println("Certificate 3:");
            System.out.println(string);
        }
        catch (Exception exception) {
            System.out.println("Get 3rd certificate Failed");
            exception.printStackTrace();
        }
        System.out.println();
        System.out.println("Having 2nd & 3rd certificate NULL is fine.");
    }

    public static void main(String[] stringArray) {
        String string = null;
        String string2 = "welcome1";
        String string3 = "";
        Security.addProvider(new OraclePKIProvider());
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-help")) {
                System.out.println(o);
                continue;
            }
            if (stringArray[i].equals("-loadfile")) {
                string = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-loadpass")) {
                string2 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-tests")) {
                string3 = stringArray[++i];
                continue;
            }
            System.out.println("Unknown option " + stringArray[i]);
            System.out.println(o);
            System.exit(-1);
        }
        KeyStoreTest keyStoreTest = null;
        try {
            keyStoreTest = new KeyStoreTest(string, string2);
        }
        catch (Exception exception) {
            System.out.println("Could not create/load keystore");
            exception.printStackTrace();
            System.exit(-1);
        }
        try {
            keyStoreTest.runTest(string3);
        }
        catch (Throwable throwable) {
            System.out.println("Error occured during tests");
            System.exit(-1);
        }
        System.out.println("Success!");
    }

    private void h(KeyStore keyStore) throws KeyStoreException {
        System.out.println();
        System.out.println("Using provider " + keyStore.getProvider());
        System.out.println();
    }

    public KeyStoreTest(String string, String string2) throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException, NoSuchProviderException {
        System.out.println("--------------------------------------------");
        System.out.println("Created KeyStore of type " + n + " using provider " + this.l.getProvider());
        FileInputStream fileInputStream = null;
        if (string != null) {
            fileInputStream = new FileInputStream(string);
        }
        this.k = string2.toCharArray();
        this.l.load(fileInputStream, this.k);
        System.out.println("Loaded KeyStore from " + string + " with password " + string2);
        System.out.println("--------------------------------------------");
    }

    public void runTest(String string) throws KeyStoreException {
        System.out.println();
        System.out.println("---------------------------------------------");
        System.out.println("Printing information about the KeyStore:");
        System.out.println("KeyStore is of type " + this.l.getType() + ".");
        System.out.println("KeyStore provider is " + this.l.getProvider());
        System.out.println("KeyStore contains " + this.l.size() + " entries.");
        System.out.println("---------------------------------------------");
        System.out.println();
        block29: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case 'a': {
                    try {
                        this.h(this.l);
                    }
                    catch (KeyStoreException keyStoreException) {
                        System.out.println("Print provider Test Failed");
                        keyStoreException.printStackTrace();
                    }
                    continue block29;
                }
                case 'b': {
                    try {
                        this.d(this.l);
                    }
                    catch (KeyStoreException keyStoreException) {
                        System.out.println("Certificate Entry Test Failed");
                        keyStoreException.printStackTrace();
                    }
                    continue block29;
                }
                case 'c': {
                    try {
                        this.e(this.l);
                    }
                    catch (KeyStoreException keyStoreException) {
                        System.out.println("Key Entry Test Failed");
                        keyStoreException.printStackTrace();
                    }
                    continue block29;
                }
                case 'd': {
                    try {
                        this.f(this.l);
                    }
                    catch (KeyStoreException keyStoreException) {
                        System.out.println("Print Type Test Failed");
                        keyStoreException.printStackTrace();
                    }
                    continue block29;
                }
                case 'e': {
                    try {
                        this.j(this.l);
                    }
                    catch (KeyStoreException keyStoreException) {
                        System.out.println("Print Size Test Failed");
                        keyStoreException.printStackTrace();
                    }
                    continue block29;
                }
                case 'f': {
                    try {
                        this.c(this.l);
                    }
                    catch (KeyStoreException keyStoreException) {
                        System.out.println("Alias Test Failed");
                        keyStoreException.printStackTrace();
                    }
                    continue block29;
                }
                case 'g': {
                    try {
                        this.b(this.l);
                    }
                    catch (KeyStoreException keyStoreException) {
                        System.out.println("DeleteEntry Test Failed");
                        keyStoreException.printStackTrace();
                    }
                    continue block29;
                }
                case 'h': {
                    try {
                        this.g(this.l);
                    }
                    catch (KeyStoreException keyStoreException) {
                        System.out.println("GetCertificate Test Failed");
                        keyStoreException.printStackTrace();
                    }
                    continue block29;
                }
                case 'p': {
                    try {
                        this.i();
                    }
                    catch (GeneralSecurityException generalSecurityException) {
                        System.out.println("PrintTest Failed");
                        generalSecurityException.printStackTrace();
                    }
                    continue block29;
                }
                default: {
                    System.out.println("Unknown test " + string.charAt(i) + ", ignoring");
                }
            }
        }
    }

    private void i() throws GeneralSecurityException {
        System.out.println("Printing information about KeyStore:");
        System.out.println("KeyStore is of type " + this.l.getType() + ".");
        System.out.println("KeyStore provider is " + this.l.getProvider());
        System.out.println("KeyStore contains " + this.l.size() + " entries.");
        Enumeration enumeration = this.a(this.l.aliases());
        int n = 0;
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            System.out.println("Entry[" + n + "]");
            System.out.println("  Alias: \"" + string + "\"");
            System.out.println("  Created At: " + this.l.getCreationDate(string));
            if (this.l.isKeyEntry(string)) {
                System.out.println("Private key " + this.l.getKey(string, this.k));
                if (this.l.getCertificate(string) != null) {
                    System.out.println("User certificate:\n" + CertificateTest.certToPrettyString(this.l.getCertificate(string)));
                    Certificate[] certificateArray = this.l.getCertificateChain(string);
                    for (int i = 1; i < certificateArray.length; ++i) {
                        System.out.println(" Signed by: ");
                        if (certificateArray[i] instanceof X509Certificate) {
                            System.out.println(((X509Certificate)certificateArray[i]).getSubjectDN());
                            continue;
                        }
                        System.out.println(certificateArray[i]);
                    }
                } else {
                    System.out.println("No public certificate present");
                }
            } else if (this.l.isCertificateEntry(string)) {
                System.out.println("Trusted certificate\n" + CertificateTest.certToPrettyString(this.l.getCertificate(string)));
            } else {
                System.out.println("Unknown entry type for alias: " + string);
            }
            ++n;
        }
    }

    private void j(KeyStore keyStore) throws KeyStoreException {
        System.out.println("Size of KeyStore is " + keyStore.size());
        System.out.println();
    }
}

