/*
 * Decompiled with CFR 0.152.
 */
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;

public class CertificateTest {
    public static String boolAToKeyUsage(boolean[] blArray) {
        if (blArray == null || blArray.length < 9) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append("DigitalSignature ").append(blArray[0]).append("\n");
        stringBuffer.append("NonRepudiation   ").append(blArray[1]).append("\n");
        stringBuffer.append("KeyEncipherment  ").append(blArray[2]).append("\n");
        stringBuffer.append("DataEncipherment ").append(blArray[3]).append("\n");
        stringBuffer.append("KeyAgreement     ").append(blArray[4]).append("\n");
        stringBuffer.append("KeyCertSign      ").append(blArray[5]).append("\n");
        stringBuffer.append("CRLSign          ").append(blArray[6]).append("\n");
        stringBuffer.append("EncipherOnly     ").append(blArray[7]).append("\n");
        stringBuffer.append("DecipherOnly     ").append(blArray[8]).append("\n");
        for (int i = 9; i < blArray.length; ++i) {
            stringBuffer.append("Unknown          ").append(blArray[i]).append("\n");
        }
        return stringBuffer.toString();
    }

    public static String byteAToPrettyString(byte[] byArray) {
        if (byArray == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 3 + 16);
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == 0) {
                stringBuffer.append("00");
            } else if (byArray[i] < 0) {
                stringBuffer.append(Integer.toHexString(256 + byArray[i]));
            } else if (byArray[i] < 16) {
                stringBuffer.append("0");
                stringBuffer.append(Integer.toHexString(byArray[i]));
            } else {
                stringBuffer.append(Integer.toHexString(byArray[i]));
            }
            stringBuffer.append(":");
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        return stringBuffer.toString().toUpperCase();
    }

    public static String certToPrettyString(Certificate certificate) {
        if (!(certificate instanceof X509Certificate)) {
            return certificate.toString();
        }
        X509Certificate x509Certificate = (X509Certificate)certificate;
        StringBuffer stringBuffer = new StringBuffer(8192);
        stringBuffer.append("Version X509v").append(x509Certificate.getVersion());
        stringBuffer.append("\n");
        stringBuffer.append("Serial #:     ");
        stringBuffer.append(CertificateTest.byteAToPrettyString(x509Certificate.getSerialNumber().toByteArray()));
        stringBuffer.append("\n");
        stringBuffer.append("Subject Name: ").append(x509Certificate.getSubjectDN().getName());
        stringBuffer.append("\n");
        stringBuffer.append("Issued By:    ").append(x509Certificate.getIssuerDN().getName());
        stringBuffer.append("\n");
        stringBuffer.append("Valid from:   ").append(x509Certificate.getNotBefore());
        stringBuffer.append("\n");
        stringBuffer.append("Valid until:  ").append(x509Certificate.getNotAfter());
        stringBuffer.append("\n");
        stringBuffer.append("KeyUsage:     \n");
        stringBuffer.append(CertificateTest.boolAToKeyUsage(x509Certificate.getKeyUsage())).append("\n");
        stringBuffer.append("Basic Constr: ");
        stringBuffer.append(x509Certificate.getBasicConstraints()).append("\n");
        return stringBuffer.toString();
    }
}

