/*
 * Decompiled with CFR 0.152.
 */
package org.xmlpull.mxp1_serializer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.xmlpull.v1.XmlSerializer;

public class MXSerializer
implements XmlSerializer {
    protected static final String XML_URI = "http://www.w3.org/XML/1998/namespace";
    protected static final String XMLNS_URI = "http://www.w3.org/2000/xmlns/";
    private static final boolean TRACE_SIZING = false;
    protected final String FEATURE_SERIALIZER_ATTVALUE_USE_APOSTROPHE = "http://xmlpull.org/v1/doc/features.html#serializer-attvalue-use-apostrophe";
    protected final String FEATURE_NAMES_INTERNED = "http://xmlpull.org/v1/doc/features.html#names-interned";
    protected final String PROPERTY_SERIALIZER_INDENTATION = "http://xmlpull.org/v1/doc/properties.html#serializer-indentation";
    protected final String PROPERTY_SERIALIZER_LINE_SEPARATOR = "http://xmlpull.org/v1/doc/properties.html#serializer-line-separator";
    protected boolean namesInterned;
    protected boolean attributeUseApostrophe;
    protected String indentationString = null;
    protected String lineSeparator = "\n";
    protected Writer out;
    protected int autoDeclaredPrefixes;
    protected int depth = 0;
    protected String[] elNamespace = new String[2];
    protected String[] elName = new String[this.elNamespace.length];
    protected int[] elNamespaceCount = new int[this.elNamespace.length];
    protected int namespaceEnd = 0;
    protected String[] namespacePrefix = new String[8];
    protected String[] namespaceUri = new String[this.namespacePrefix.length];
    protected boolean finished;
    protected boolean pastRoot;
    protected boolean setPrefixCalled;
    protected boolean startTagIncomplete;
    protected boolean doIndent;
    protected boolean seenTag;
    protected static final String[] precomputedPrefixes = new String[10];
    protected int offsetNewLine;
    protected int indentationJump;
    protected char[] indentationBuf;
    protected int maxIndentLevel;
    protected boolean writeLineSepartor;
    protected boolean writeIndentation;

    protected void reset() {
        this.out = null;
        this.autoDeclaredPrefixes = 0;
        this.depth = 0;
        int i = 0;
        while (i < this.elNamespaceCount.length) {
            this.elName[i] = null;
            this.elNamespace[i] = null;
            this.elNamespaceCount[i] = 2;
            ++i;
        }
        this.namespaceEnd = 0;
        this.namespacePrefix[this.namespaceEnd] = "xmlns";
        this.namespaceUri[this.namespaceEnd] = XMLNS_URI;
        ++this.namespaceEnd;
        this.namespacePrefix[this.namespaceEnd] = "xml";
        this.namespaceUri[this.namespaceEnd] = XML_URI;
        ++this.namespaceEnd;
        this.finished = false;
        this.pastRoot = false;
        this.setPrefixCalled = false;
        this.startTagIncomplete = false;
        this.seenTag = false;
    }

    protected void ensureElementsCapacity() {
        int elStackSize = this.elName.length;
        int newSize = (this.depth >= 7 ? 2 * this.depth : 8) + 2;
        boolean needsCopying = elStackSize > 0;
        String[] arr = null;
        arr = new String[newSize];
        if (needsCopying) {
            System.arraycopy(this.elName, 0, arr, 0, elStackSize);
        }
        this.elName = arr;
        arr = new String[newSize];
        if (needsCopying) {
            System.arraycopy(this.elNamespace, 0, arr, 0, elStackSize);
        }
        this.elNamespace = arr;
        int[] iarr = new int[newSize];
        if (needsCopying) {
            System.arraycopy(this.elNamespaceCount, 0, iarr, 0, elStackSize);
        } else {
            iarr[0] = 0;
        }
        this.elNamespaceCount = iarr;
    }

    protected void ensureNamespacesCapacity() {
        int newSize = this.namespaceEnd > 7 ? 2 * this.namespaceEnd : 8;
        String[] newNamespacePrefix = new String[newSize];
        String[] newNamespaceUri = new String[newSize];
        if (this.namespacePrefix != null) {
            System.arraycopy(this.namespacePrefix, 0, newNamespacePrefix, 0, this.namespaceEnd);
            System.arraycopy(this.namespaceUri, 0, newNamespaceUri, 0, this.namespaceEnd);
        }
        this.namespacePrefix = newNamespacePrefix;
        this.namespaceUri = newNamespaceUri;
    }

    public void setFeature(String name, boolean state) throws IllegalArgumentException, IllegalStateException {
        if (name == null) {
            throw new IllegalArgumentException("feature name can not be null");
        }
        if ("http://xmlpull.org/v1/doc/features.html#names-interned".equals(name)) {
            this.namesInterned = state;
        } else if ("http://xmlpull.org/v1/doc/features.html#serializer-attvalue-use-apostrophe".equals(name)) {
            this.attributeUseApostrophe = state;
        } else {
            throw new IllegalStateException("unsupported feature " + name);
        }
    }

    public boolean getFeature(String name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("feature name can not be null");
        }
        if ("http://xmlpull.org/v1/doc/features.html#names-interned".equals(name)) {
            return this.namesInterned;
        }
        if ("http://xmlpull.org/v1/doc/features.html#serializer-attvalue-use-apostrophe".equals(name)) {
            return this.attributeUseApostrophe;
        }
        return false;
    }

    protected void rebuildIndentationBuf() {
        int i;
        if (!this.doIndent) {
            return;
        }
        int maxIndent = 65;
        int bufSize = 0;
        this.offsetNewLine = 0;
        if (this.writeLineSepartor) {
            this.offsetNewLine = this.lineSeparator.length();
            bufSize += this.offsetNewLine;
        }
        this.maxIndentLevel = 0;
        if (this.writeIndentation) {
            this.indentationJump = this.indentationString.length();
            this.maxIndentLevel = 65 / this.indentationJump;
            bufSize += this.maxIndentLevel * this.indentationJump;
        }
        if (this.indentationBuf == null || this.indentationBuf.length < bufSize) {
            this.indentationBuf = new char[bufSize + 8];
        }
        int bufPos = 0;
        if (this.writeLineSepartor) {
            i = 0;
            while (i < this.lineSeparator.length()) {
                this.indentationBuf[bufPos++] = this.lineSeparator.charAt(i);
                ++i;
            }
        }
        if (this.writeIndentation) {
            i = 0;
            while (i < this.maxIndentLevel) {
                int j = 0;
                while (j < this.indentationString.length()) {
                    this.indentationBuf[bufPos++] = this.indentationString.charAt(j);
                    ++j;
                }
                ++i;
            }
        }
    }

    protected void writeIndent() throws IOException {
        int start = this.writeLineSepartor ? 0 : this.offsetNewLine;
        int level = this.depth > this.maxIndentLevel ? this.maxIndentLevel : this.depth;
        this.out.write(this.indentationBuf, start, level * this.indentationJump + this.offsetNewLine);
    }

    public void setProperty(String name, Object value) throws IllegalArgumentException, IllegalStateException {
        if (name == null) {
            throw new IllegalArgumentException("property name can not be null");
        }
        if ("http://xmlpull.org/v1/doc/properties.html#serializer-indentation".equals(name)) {
            this.indentationString = (String)value;
        } else if ("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator".equals(name)) {
            this.lineSeparator = (String)value;
        } else {
            throw new IllegalStateException("unsupported property " + name);
        }
        this.writeLineSepartor = this.lineSeparator != null && this.lineSeparator.length() > 0;
        this.writeIndentation = this.indentationString != null && this.indentationString.length() > 0;
        this.doIndent = this.indentationString != null && (this.writeLineSepartor || this.writeIndentation);
        this.rebuildIndentationBuf();
        this.seenTag = false;
    }

    public Object getProperty(String name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("property name can not be null");
        }
        if ("http://xmlpull.org/v1/doc/properties.html#serializer-indentation".equals(name)) {
            return this.indentationString;
        }
        if ("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator".equals(name)) {
            return this.lineSeparator;
        }
        return null;
    }

    public void setOutput(Writer writer) {
        this.reset();
        this.out = writer;
    }

    public void setOutput(OutputStream os, String encoding) throws IOException {
        if (os == null) {
            throw new IllegalArgumentException("output stream can not be null");
        }
        this.reset();
        this.out = encoding != null ? new OutputStreamWriter(os, encoding) : new OutputStreamWriter(os);
    }

    public void startDocument(String encoding, Boolean standalone) throws IOException {
        this.out.write("<?xml version=\"1.0\"");
        if (encoding != null) {
            this.out.write(" encoding='");
            this.out.write(encoding);
            this.out.write("'");
        }
        if (standalone != null) {
            if (standalone.booleanValue()) {
                this.out.write(" standalone='yes'");
            } else {
                this.out.write(" standalone='no'");
            }
        }
        this.out.write("?>");
    }

    public void endDocument() throws IOException {
        while (this.depth > 0) {
            this.endTag(this.elNamespace[this.depth], this.elName[this.depth]);
        }
        this.startTagIncomplete = true;
        this.pastRoot = true;
        this.finished = true;
        this.out.flush();
    }

    public void setPrefix(String prefix, String namespace) throws IOException {
        int start;
        if (this.startTagIncomplete) {
            this.closeStartTag();
        }
        prefix = prefix.intern();
        int i = start = this.elNamespaceCount[this.depth];
        while (i < this.namespaceEnd) {
            if (prefix == this.namespacePrefix[i]) {
                throw new IllegalStateException("duplicated prefix " + MXSerializer.printable(prefix));
            }
            ++i;
        }
        namespace = namespace.intern();
        if (this.namespaceEnd >= this.namespacePrefix.length) {
            this.ensureNamespacesCapacity();
        }
        this.namespacePrefix[this.namespaceEnd] = prefix;
        this.namespaceUri[this.namespaceEnd] = namespace;
        ++this.namespaceEnd;
        this.setPrefixCalled = true;
    }

    protected String lookupOrDeclarePrefix(String namespace) {
        return this.getPrefix(namespace, true);
    }

    public String getPrefix(String namespace, boolean generatePrefix) {
        if (!this.namesInterned) {
            namespace = namespace.intern();
        }
        int i = this.namespaceEnd - 1;
        while (i >= 0) {
            if (namespace == this.namespaceUri[i]) {
                String prefix = this.namespacePrefix[i];
                int p = this.namespaceEnd - 1;
                while (p > i) {
                    if (prefix == this.namespacePrefix[p]) {
                        // empty if block
                    }
                    --p;
                }
                return prefix;
            }
            --i;
        }
        if (!generatePrefix) {
            return null;
        }
        return this.generatePrefix(namespace);
    }

    private String generatePrefix(String namespace) {
        ++this.autoDeclaredPrefixes;
        String prefix = this.autoDeclaredPrefixes < precomputedPrefixes.length ? precomputedPrefixes[this.autoDeclaredPrefixes] : ("n" + this.autoDeclaredPrefixes).intern();
        int i = this.namespaceEnd - 1;
        while (i >= 0) {
            if (prefix == this.namespacePrefix[i]) {
                // empty if block
            }
            --i;
        }
        if (this.namespaceEnd >= this.namespacePrefix.length) {
            this.ensureNamespacesCapacity();
        }
        this.namespacePrefix[this.namespaceEnd] = prefix;
        this.namespaceUri[this.namespaceEnd] = namespace;
        ++this.namespaceEnd;
        return prefix;
    }

    public int getDepth() {
        return this.depth;
    }

    public String getNamespace() {
        return this.elNamespace[this.depth];
    }

    public String getName() {
        return this.elName[this.depth];
    }

    public XmlSerializer startTag(String namespace, String name) throws IOException {
        if (this.startTagIncomplete) {
            this.closeStartTag();
        }
        if (this.doIndent && this.depth > 0 && this.seenTag) {
            this.writeIndent();
        }
        this.seenTag = true;
        this.setPrefixCalled = false;
        this.startTagIncomplete = true;
        ++this.depth;
        if (this.depth + 1 >= this.elName.length) {
            this.ensureElementsCapacity();
        }
        this.elNamespace[this.depth] = namespace;
        this.elName[this.depth] = name;
        this.out.write(60);
        if (namespace != null) {
            if (namespace.length() > 0) {
                String prefix = this.lookupOrDeclarePrefix(namespace);
                if (prefix.length() > 0) {
                    this.out.write(prefix);
                    this.out.write(58);
                }
            } else {
                int i = this.namespaceEnd - 1;
                while (i >= 0) {
                    if (this.namespacePrefix[i] == "") {
                        String uri = this.namespaceUri[i];
                        if (uri == null) {
                            this.setPrefix("", "");
                            break;
                        }
                        if (uri.length() <= 0) break;
                        throw new IllegalStateException("start tag can not be written in empty default namespace as default namespace is currently bound to '" + uri + "'");
                    }
                    --i;
                }
            }
        }
        this.out.write(name);
        return this;
    }

    public XmlSerializer attribute(String namespace, String name, String value) throws IOException {
        if (!this.startTagIncomplete) {
            throw new IllegalArgumentException("startTag() must be called before attribute()");
        }
        this.out.write(32);
        if (namespace != null && namespace.length() > 0) {
            String prefix = this.lookupOrDeclarePrefix(namespace = namespace.intern());
            if (prefix.length() == 0) {
                prefix = this.generatePrefix(namespace);
            }
            this.out.write(prefix);
            this.out.write(58);
        }
        this.out.write(name);
        this.out.write(61);
        this.out.write(this.attributeUseApostrophe ? 39 : 34);
        this.writeAttributeValue(value, this.out);
        this.out.write(this.attributeUseApostrophe ? 39 : 34);
        return this;
    }

    protected void closeStartTag() throws IOException {
        if (this.finished) {
            throw new IllegalArgumentException("trying to write past already finished output");
        }
        if (this.setPrefixCalled) {
            throw new IllegalArgumentException("startTag() must be called immediately after setPrefix()");
        }
        if (!this.startTagIncomplete) {
            throw new IllegalArgumentException("trying to close start tag that is not opened");
        }
        this.writeNamespaceDeclarations();
        this.out.write(62);
        this.elNamespaceCount[this.depth] = this.namespaceEnd;
        this.startTagIncomplete = false;
    }

    private void writeNamespaceDeclarations() throws IOException {
        int start;
        int i = start = this.elNamespaceCount[this.depth - 1];
        while (i < this.namespaceEnd) {
            if (this.namespacePrefix[i] != "") {
                this.out.write(" xmlns:");
                this.out.write(this.namespacePrefix[i]);
                this.out.write(61);
            } else {
                this.out.write(" xmlns=");
            }
            this.out.write(this.attributeUseApostrophe ? 39 : 34);
            this.writeAttributeValue(this.namespaceUri[i], this.out);
            this.out.write(this.attributeUseApostrophe ? 39 : 34);
            ++i;
        }
    }

    public XmlSerializer endTag(String namespace, String name) throws IOException {
        if (namespace != null) {
            namespace = namespace.intern();
        }
        if (namespace != this.elNamespace[this.depth]) {
            throw new IllegalArgumentException("expected namespace " + MXSerializer.printable(this.elNamespace[this.depth]) + " and not " + MXSerializer.printable(namespace));
        }
        if (name != null && !name.equals(this.elName[this.depth]) || name != this.elName[this.depth]) {
            throw new IllegalArgumentException("expected element name " + MXSerializer.printable(this.elName[this.depth]) + " and not '" + MXSerializer.printable(name));
        }
        if (this.startTagIncomplete) {
            this.writeNamespaceDeclarations();
            this.out.write("/>");
            --this.depth;
        } else {
            String prefix;
            --this.depth;
            if (this.doIndent && this.seenTag) {
                this.writeIndent();
            }
            this.out.write("</");
            if (namespace != null && namespace.length() > 0 && (prefix = this.lookupOrDeclarePrefix(namespace)).length() > 0) {
                this.out.write(prefix);
                this.out.write(58);
            }
            this.out.write(name);
            this.out.write(62);
        }
        this.namespaceEnd = this.elNamespaceCount[this.depth];
        this.startTagIncomplete = false;
        this.seenTag = true;
        return this;
    }

    public XmlSerializer text(String text) throws IOException {
        if (this.startTagIncomplete || this.setPrefixCalled) {
            this.closeStartTag();
        }
        if (this.doIndent && this.seenTag) {
            this.seenTag = false;
        }
        this.writeElementContent(text, this.out);
        return this;
    }

    public XmlSerializer text(char[] buf, int start, int len) throws IOException {
        if (this.startTagIncomplete || this.setPrefixCalled) {
            this.closeStartTag();
        }
        if (this.doIndent && this.seenTag) {
            this.seenTag = false;
        }
        this.writeElementContent(buf, start, len, this.out);
        return this;
    }

    public void cdsect(String text) throws IOException {
        if (this.startTagIncomplete || this.setPrefixCalled) {
            this.closeStartTag();
        }
        if (this.doIndent && this.seenTag) {
            this.seenTag = false;
        }
        this.out.write("<![CDATA[");
        this.out.write(text);
        this.out.write("]]>");
    }

    public void entityRef(String text) throws IOException {
        if (this.startTagIncomplete || this.setPrefixCalled) {
            this.closeStartTag();
        }
        if (this.doIndent && this.seenTag) {
            this.seenTag = false;
        }
        this.out.write(38);
        this.out.write(text);
        this.out.write(59);
    }

    public void processingInstruction(String text) throws IOException {
        if (this.startTagIncomplete || this.setPrefixCalled) {
            this.closeStartTag();
        }
        if (this.doIndent && this.seenTag) {
            this.seenTag = false;
        }
        this.out.write("<?");
        this.out.write(text);
        this.out.write("?>");
    }

    public void comment(String text) throws IOException {
        if (this.startTagIncomplete || this.setPrefixCalled) {
            this.closeStartTag();
        }
        if (this.doIndent && this.seenTag) {
            this.seenTag = false;
        }
        this.out.write("<!--");
        this.out.write(text);
        this.out.write("-->");
    }

    public void docdecl(String text) throws IOException {
        if (this.startTagIncomplete || this.setPrefixCalled) {
            this.closeStartTag();
        }
        if (this.doIndent && this.seenTag) {
            this.seenTag = false;
        }
        this.out.write("<!DOCTYPE");
        this.out.write(text);
        this.out.write(">");
    }

    public void ignorableWhitespace(String text) throws IOException {
        if (this.startTagIncomplete || this.setPrefixCalled) {
            this.closeStartTag();
        }
        if (this.doIndent && this.seenTag) {
            this.seenTag = false;
        }
        this.out.write(text);
    }

    public void flush() throws IOException {
        if (this.startTagIncomplete) {
            this.closeStartTag();
        }
        this.out.flush();
    }

    protected void writeAttributeValue(String value, Writer out) throws IOException {
        block9: {
            int quot = this.attributeUseApostrophe ? 39 : 34;
            String quotEntity = this.attributeUseApostrophe ? "&apos;" : "&quot;";
            int posLt = value.indexOf(60);
            int posAmp = value.indexOf(38);
            int posQuot = value.indexOf(quot);
            int pos = 0;
            while (true) {
                if (posLt == -1 && posAmp == -1 && posQuot == -1) {
                    if (pos > 0) {
                        out.write(value.substring(pos));
                    } else {
                        out.write(value);
                    }
                    break block9;
                }
                if (posQuot != -1 && (posAmp == -1 || posAmp != -1 && posQuot < posAmp) && (posLt == -1 || posLt != -1 && posQuot < posLt)) {
                    if (pos < posQuot) {
                        out.write(value.substring(pos, posQuot));
                    }
                    out.write(quotEntity);
                    pos = posQuot + 1;
                    posQuot = value.indexOf(quot, pos);
                    continue;
                }
                if (posAmp != -1 && (posQuot == -1 || posQuot != -1 && posAmp < posQuot) && (posLt == -1 || posLt != -1 && posAmp < posLt)) {
                    if (pos < posAmp) {
                        out.write(value.substring(pos, posAmp));
                    }
                    out.write("&amp;");
                    pos = posAmp + 1;
                    posAmp = value.indexOf(38, pos);
                    continue;
                }
                if (posLt == -1 || posQuot != -1 && (posQuot == -1 || posLt >= posQuot) || posAmp != -1 && (posAmp == -1 || posLt >= posAmp)) break;
                if (pos < posLt) {
                    out.write(value.substring(pos, posLt));
                }
                out.write("&lt;");
                pos = posLt + 1;
                posLt = value.indexOf(60, pos);
            }
            throw new IllegalStateException("wrong state #1 posLt=" + posLt + " posAmp=" + posAmp + " posQuot=" + posQuot + " for " + value);
        }
    }

    protected void writeElementContent(String text, Writer out) throws IOException {
        int pos;
        block4: {
            int posLt = text.indexOf(60);
            int posAmp = text.indexOf(38);
            pos = 0;
            while (true) {
                if (posLt == -1 && posAmp == -1) break block4;
                if (posLt == -1 || posLt != -1 && posAmp != -1 && posAmp < posLt) {
                    if (pos < posAmp) {
                        out.write(text.substring(pos, posAmp));
                    }
                    out.write("&amp;");
                    pos = posAmp + 1;
                    posAmp = text.indexOf(38, pos);
                    continue;
                }
                if (posAmp != -1 && (posLt == -1 || posAmp == -1 || posLt >= posAmp)) break;
                if (pos < posLt) {
                    out.write(text.substring(pos, posLt));
                }
                out.write("&lt;");
                pos = posLt + 1;
                posLt = text.indexOf(60, pos);
            }
            throw new IllegalStateException("wrong state posLt=" + posLt + " posAmp=" + posAmp + " for " + text);
        }
        out.write(text.substring(pos));
    }

    protected void writeElementContent(char[] buf, int off, int len, Writer out) throws IOException {
        int end = off + len;
        int pos = off;
        int i = off;
        while (i < end) {
            char ch = buf[i];
            if (ch == '&') {
                if (i > pos) {
                    out.write(buf, pos, i - pos);
                }
                out.write("&amp;");
                pos = i + 1;
            } else if (ch == '<') {
                if (i > pos) {
                    out.write(buf, pos, i - pos);
                }
                out.write("&lt;");
                pos = i + 1;
            }
            ++i;
        }
        if (end > pos) {
            out.write(buf, pos, end - pos);
        }
    }

    protected static final String printable(String s) {
        if (s == null) {
            return "null";
        }
        StringBuffer retval = new StringBuffer(s.length() + 16);
        retval.append("'");
        int i = 0;
        while (i < s.length()) {
            MXSerializer.addPrintable(retval, s.charAt(i));
            ++i;
        }
        retval.append("'");
        return retval.toString();
    }

    protected static final String printable(char ch) {
        StringBuffer retval = new StringBuffer();
        MXSerializer.addPrintable(retval, ch);
        return retval.toString();
    }

    private static void addPrintable(StringBuffer retval, char ch) {
        switch (ch) {
            case '\b': {
                retval.append("\\b");
                break;
            }
            case '\t': {
                retval.append("\\t");
                break;
            }
            case '\n': {
                retval.append("\\n");
                break;
            }
            case '\f': {
                retval.append("\\f");
                break;
            }
            case '\r': {
                retval.append("\\r");
                break;
            }
            case '\"': {
                retval.append("\\\"");
                break;
            }
            case '\'': {
                retval.append("\\'");
                break;
            }
            case '\\': {
                retval.append("\\\\");
                break;
            }
            default: {
                if (ch < ' ' || ch > '~') {
                    String ss = "0000" + Integer.toString(ch, 16);
                    retval.append("\\u" + ss.substring(ss.length() - 4, ss.length()));
                    break;
                }
                retval.append(ch);
            }
        }
    }

    static {
        int i = 0;
        while (i < precomputedPrefixes.length) {
            MXSerializer.precomputedPrefixes[i] = ("n" + i).intern();
            ++i;
        }
    }
}

