/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.topicDisplay.popup;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.bali.ewt.model.ArrayOneDModel;
import oracle.bali.ewt.model.OneDListModel;
import oracle.bali.ewt.model.OneDModel;
import oracle.bali.ewt.util.WindowUtils;
import oracle.help.common.AssociativeLink;
import oracle.help.common.Topic;
import oracle.help.common.util.java.StaticLocaleContext;
import oracle.help.java.util.MnemonicUtils;

public class ALinkPopup
extends JDialog
implements ActionListener,
MouseListener {
    private static String GENERIC_RESOURCE_BUNDLE = "oracle.help.resource.Generic";
    private static String ALINK_POPUP_TITLE = "topicDisplay.aLinkPopup.title";
    private static String ALINK_POPUP_PROMPT = "topicDisplay.aLinkPopup.prompt";
    private static String ALINK_POPUP_DISPLAY = "topicDisplay.aLinkPopup.display";
    private static String ALINK_POPUP_CANCEL = "topicDisplay.aLinkPopup.cancel";
    private static String ALINK_POPUP_NOTOPICS = "topicDisplay.aLinkPopup.notopics";
    private Topic _selectedTopic;
    private String _noTopicsString;
    private JButton _cancelButton;
    private JButton _displayButton;
    private JList _list;
    private ArrayOneDModel _dataModel;

    public ALinkPopup(AssociativeLink associativeLink, Point point, Component component) {
        super(WindowUtils.parentFrame((Component)component), true);
        ResourceBundle resourceBundle = ResourceBundle.getBundle(GENERIC_RESOURCE_BUNDLE, StaticLocaleContext.getLocale());
        this.setTitle(resourceBundle.getString(ALINK_POPUP_TITLE));
        this._noTopicsString = resourceBundle.getString(ALINK_POPUP_NOTOPICS);
        this._selectedTopic = null;
        this.getContentPane().setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new EmptyBorder(8, 8, 8, 8));
        jPanel.setLayout(new BorderLayout(10, 10));
        this._createDataSource(associativeLink);
        this._list = new JList(new OneDListModel((OneDModel)this._dataModel));
        this._list.setVisibleRowCount(4);
        this._list.addMouseListener(this);
        this._list.setSelectedIndex(0);
        JScrollPane jScrollPane = new JScrollPane(this._list);
        jPanel.add((Component)jScrollPane, "Center");
        JLabel jLabel = MnemonicUtils.createLabel(resourceBundle.getString(ALINK_POPUP_PROMPT), this._list);
        jPanel.add((Component)jLabel, "North");
        DialogButtonBar dialogButtonBar = new DialogButtonBar();
        this._displayButton = MnemonicUtils.createButton(resourceBundle.getString(ALINK_POPUP_DISPLAY));
        this._displayButton.addActionListener(this);
        dialogButtonBar.add(this._displayButton);
        this._cancelButton = MnemonicUtils.createButton(resourceBundle.getString(ALINK_POPUP_CANCEL));
        this._cancelButton.addActionListener(this);
        dialogButtonBar.add(this._cancelButton);
        jPanel.add((Component)dialogButtonBar, "South");
        this.getContentPane().add((Component)jPanel, "Center");
        this.addWindowListener(WindowUtils.getWindowCloser());
        this.pack();
        WindowUtils.centerWindow((Window)this, (Component)component);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent != null) {
            ((Component)this).setVisible(false);
            if (actionEvent.getSource() == this._displayButton || actionEvent.getSource() == this._list) {
                ALinkListItem aLinkListItem = null;
                int n = this._list.getSelectedIndex();
                if (n != -1) {
                    aLinkListItem = (ALinkListItem)this._dataModel.getData(n);
                }
                this._selectedTopic = aLinkListItem != null ? aLinkListItem.getTopic() : null;
            } else if (actionEvent.getSource() == this._cancelButton) {
                this._selectedTopic = null;
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n;
        if (mouseEvent.getSource() == this._list && mouseEvent.getClickCount() == 2 && (n = this._list.locationToIndex(mouseEvent.getPoint())) != -1) {
            this.actionPerformed(new ActionEvent(this._list, 1001, "LIST"));
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public Topic getSelectedTopic() {
        return this._selectedTopic;
    }

    private void _createDataSource(AssociativeLink associativeLink) {
        Topic[] topicArray;
        ArrayList<ALinkListItem> arrayList = new ArrayList<ALinkListItem>();
        if (associativeLink != null && (topicArray = associativeLink.getTopics()) != null) {
            int n = 0;
            while (n < topicArray.length) {
                Topic topic = topicArray[n];
                ALinkListItem aLinkListItem = new ALinkListItem(topic.getLabel(), topic);
                arrayList.add(aLinkListItem);
                ++n;
            }
        }
        if (arrayList.size() == 0) {
            ALinkListItem aLinkListItem = new ALinkListItem(this._noTopicsString, null);
            arrayList.add(aLinkListItem);
            this._displayButton.setEnabled(false);
        }
        Object[] objectArray = new ALinkListItem[arrayList.size()];
        arrayList.toArray(objectArray);
        this._dataModel = new ArrayOneDModel(objectArray);
    }

    private class ALinkListItem {
        private String _label;
        private Topic _topic;

        public ALinkListItem(String string, Topic topic) {
            this._label = string;
            this._topic = topic;
        }

        public String getLabel() {
            return this._label;
        }

        public Topic getTopic() {
            return this._topic;
        }

        public String toString() {
            return this._label;
        }
    }
}

