/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.topicDisplay;

import java.util.HashMap;
import oracle.help.CustomProtocolHandler;
import oracle.help.htmlBrowser.HTMLBrowser;
import oracle.help.htmlBrowser.ProtocolEvent;
import oracle.help.htmlBrowser.ProtocolListener;

public class CustomProtocolRegistry {
    private HashMap _customProtocolHandlers;
    private CustomProtocolListener _customProtocolListener;

    public CustomProtocolRegistry() {
    }

    public CustomProtocolRegistry(HTMLBrowser hTMLBrowser) {
        this.attachBrowser(hTMLBrowser);
    }

    public void attachBrowser(HTMLBrowser hTMLBrowser) {
        hTMLBrowser.addProtocolListener(new CustomProtocolListener());
    }

    public void registerCustomProtocolHandler(String string, CustomProtocolHandler customProtocolHandler) {
        if (this._customProtocolHandlers == null) {
            this._customProtocolHandlers = new HashMap();
        }
        if (string.indexOf(":") != -1) {
            throw new IllegalArgumentException("customProtocol string must not contain \":\"");
        }
        this._customProtocolHandlers.put(string, customProtocolHandler);
    }

    private class CustomProtocolListener
    implements ProtocolListener {
        private CustomProtocolListener() {
        }

        public void protocolReceived(ProtocolEvent protocolEvent) {
            String string;
            int n;
            if (2003 == protocolEvent.getLinkType() && (n = (string = protocolEvent.getLinkID()).indexOf(":")) != -1 && n != string.length() - 1) {
                CustomProtocolHandler customProtocolHandler;
                String string2 = string.substring(0, n);
                String string3 = string.substring(n + 1);
                if (CustomProtocolRegistry.this._customProtocolHandlers != null && (customProtocolHandler = (CustomProtocolHandler)CustomProtocolRegistry.this._customProtocolHandlers.get(string2)) != null) {
                    customProtocolHandler.handleValue(string3);
                }
            }
        }
    }
}

