/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.library.helpset;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import oracle.help.common.TopicNameConvention;
import oracle.help.common.util.Canonicalizer;
import oracle.help.common.util.LocaleUtils;
import oracle.help.common.xml.Parser;
import oracle.help.common.xml.ParserFactory;
import oracle.help.common.xml.XMLNode;
import oracle.help.common.xml.XMLParseException;

public class XMLMapParser {
    public static final String TAG_MAP = "map";
    public static final String TAG_MAPID = "mapid";
    public static final String PARAM_TARGET = "target";
    public static final String PARAM_URL = "url";
    public static final String PARAM_WINTYPE = "wintype";
    public static final String TAG_TOPIC_NAME_CONVENTION = "topicNameConvention";
    public static final String TAG_TEXT = "text";
    public static final String TAG_FILENAME = "filename";
    public static final String PARAM_URLBASE = "urlBase";
    public static final String PARAM_SEPARATOR = "separator";
    private byte[] buffer = new byte[256];
    private final int BUF_SIZE = 256;

    public static void getMappingTables(URL uRL, String string, HashMap hashMap, HashMap hashMap2) {
        XMLMapParser.getMappingTables(uRL, string, hashMap, hashMap2, null);
    }

    public static void getMappingTables(URL uRL, String string, HashMap hashMap, HashMap hashMap2, TopicNameConvention topicNameConvention) {
        XMLMapParser xMLMapParser = new XMLMapParser();
        try {
            InputStream inputStream = XMLMapParser.openInputStream(uRL);
            String string2 = uRL.toString();
            Canonicalizer.fixSeparators(string2);
            string2 = string2.substring(0, string2.lastIndexOf(47) + 1);
            if (topicNameConvention != null) {
                topicNameConvention.setURLBase(string2);
            }
            BufferedReader bufferedReader = new BufferedReader(LocaleUtils.createInputStreamReader(inputStream, string));
            xMLMapParser.parseMap(bufferedReader, string2, hashMap, hashMap2, topicNameConvention);
            bufferedReader.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private XMLMapParser() {
    }

    void parseMap(BufferedReader bufferedReader, String string, HashMap hashMap, HashMap hashMap2) throws IOException, XMLParseException {
        this.parseMap(bufferedReader, string, hashMap, hashMap2, null);
    }

    void parseMap(BufferedReader bufferedReader, String string, HashMap hashMap, HashMap hashMap2, TopicNameConvention topicNameConvention) throws IOException, XMLParseException {
        boolean bl = true;
        String string2 = "";
        bufferedReader.mark(1024);
        string2 = bufferedReader.readLine();
        while (string2 != null) {
            if (string2.length() != 0) break;
            string2 = bufferedReader.readLine();
        }
        if (string2 == null) {
            return;
        }
        bl = string2.toLowerCase().indexOf("<?xml") != -1;
        bufferedReader.reset();
        if (bl) {
            Parser parser = ParserFactory.createParser(bufferedReader, string);
            XMLNode xMLNode = parser.getRoot();
            this._handleMap(xMLNode.getFirstChild(), string, hashMap, hashMap2, topicNameConvention);
        } else {
            this.parseOldFormat(bufferedReader, string, hashMap, hashMap2);
        }
    }

    private void _handleMap(XMLNode xMLNode, String string, HashMap hashMap, HashMap hashMap2, TopicNameConvention topicNameConvention) throws XMLParseException {
        if (!xMLNode.getTokenValue().equalsIgnoreCase(TAG_MAP)) {
            throw new XMLParseException("Toplevel tag is not MAP: " + xMLNode.getTokenValue());
        }
        xMLNode = xMLNode.getFirstChild();
        while (xMLNode != null) {
            if (xMLNode.getTokenValue().equalsIgnoreCase(TAG_TOPIC_NAME_CONVENTION)) {
                this._handleTopicConvention(xMLNode, topicNameConvention);
            }
            if (xMLNode.getTokenValue().equalsIgnoreCase(TAG_MAPID)) {
                String string2;
                URL uRL = null;
                String string3 = xMLNode.getTokenProperty(PARAM_URL);
                if (string3 != null) {
                    try {
                        uRL = Canonicalizer.getAbsoluteURL(string, string3);
                    }
                    catch (MalformedURLException malformedURLException) {
                        uRL = null;
                    }
                }
                if (uRL != null && (string2 = xMLNode.getTokenProperty(PARAM_TARGET)) != null) {
                    String string4 = xMLNode.getTokenProperty(PARAM_WINTYPE);
                    if (string4 != null) {
                        hashMap2.put(uRL, string4);
                    }
                    hashMap.put(string2, uRL);
                }
            }
            xMLNode = xMLNode.getNextSibling();
        }
    }

    private static InputStream openInputStream(URL uRL) throws IOException {
        InputStream inputStream = null;
        if (uRL.getProtocol().equals("file")) {
            try {
                inputStream = new FileInputStream(uRL.getFile());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (inputStream == null) {
            inputStream = uRL.openStream();
        }
        return inputStream;
    }

    private void parseOldFormat(BufferedReader bufferedReader, String string, HashMap hashMap, HashMap hashMap2) throws IOException {
        while (true) {
            int n;
            String string2 = "";
            String string3 = "";
            String string4 = "";
            URL uRL = null;
            string2 = bufferedReader.readLine();
            if (string2 == null) break;
            if (string2.length() == 0 || string2.charAt(0) == ';' || (n = string2.indexOf(61)) == -1) continue;
            string3 = string2.substring(0, n).trim();
            if (string3.charAt(0) == '\"') {
                string3 = string3.substring(1, string3.length() - 1);
            }
            string4 = string2.substring(n + 1).trim();
            int n2 = string3.indexOf(58);
            if (n2 != -1) {
                string4 = string4.substring(0, n2).trim();
            }
            if (string4.charAt(0) == '\"') {
                string4 = string4.substring(1, string4.length() - 1);
            }
            if (string4.length() > 0) {
                try {
                    uRL = Canonicalizer.getAbsoluteURL(string, string4);
                }
                catch (MalformedURLException malformedURLException) {
                    uRL = null;
                }
            }
            if (uRL == null) continue;
            hashMap.put(string3, uRL);
        }
    }

    private void _handleTopicConvention(XMLNode xMLNode, TopicNameConvention topicNameConvention) {
        String string = xMLNode.getTokenProperty(PARAM_URLBASE);
        if (string != null && !string.equals("")) {
            topicNameConvention.setURLBase(string);
        }
        try {
            String string2 = null;
            XMLNode xMLNode2 = xMLNode.getFirstChild();
            do {
                String string3 = xMLNode2.getTokenValue();
                String string4 = xMLNode2.getString();
                if (string3.equals(TAG_TEXT)) {
                    topicNameConvention.setBeginningText(string4);
                } else {
                    string2 = string3;
                    topicNameConvention.setFirst(string3);
                    this._considerFileSeparator(xMLNode2, topicNameConvention);
                }
                xMLNode2 = xMLNode2.getNextSibling();
            } while (string2 == null);
            topicNameConvention.setMiddleText(xMLNode2.getString());
            xMLNode2 = xMLNode2.getNextSibling();
            this._considerFileSeparator(xMLNode2, topicNameConvention);
            xMLNode2 = xMLNode2.getNextSibling();
            if (xMLNode2 != null) {
                topicNameConvention.setEndingText(xMLNode2.getString());
            }
        }
        catch (TopicNameConvention.MalformedConventionException malformedConventionException) {
            malformedConventionException.printStackTrace();
        }
    }

    private void _considerFileSeparator(XMLNode xMLNode, TopicNameConvention topicNameConvention) {
        String string;
        if (TAG_FILENAME.equals(xMLNode.getTokenValue()) && (string = xMLNode.getTokenProperty(PARAM_SEPARATOR)) != null && !string.equals("")) {
            topicNameConvention.setFileSeparator(string);
        }
    }
}

