/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.library.helpbook;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import oracle.help.common.AssociativeLink;
import oracle.help.common.View;
import oracle.help.common.WindowType;
import oracle.help.common.util.Canonicalizer;
import oracle.help.common.util.java.StaticLocaleContext;
import oracle.help.engine.DataEngine;
import oracle.help.library.Book;
import oracle.help.library.helpbook.HelpBookException;
import oracle.help.library.helpbook.OhtParser;

public class HelpBook
implements Book {
    private String _baseURL = null;
    private String _baseName = null;
    private String _title = null;
    private String _controlFileEncoding = null;
    private ArrayList _views = new ArrayList();
    private HashMap _topicHash = null;
    private static final String TYPE_DEFAULT_ORACLE_TOC = "oracle.help.navigator.tocNavigator.TOCNavigator";
    private static final String TYPE_DEFAULT_ORACLE_KEYWORD = "oracle.help.navigator.keywordNavigator.KeywordNavigator";
    private static final String TYPE_DEFAULT_ORACLE_SEARCH = "oracle.help.navigator.searchNavigator.SearchNavigator";
    private static final String ENGINE_ORACLE_HHC_NEW = "oracle.help.engine.HHCEngine";
    private static final String ENGINE_ORACLE_TOC_NEW = "oracle.help.engine.TOCEngine";
    private static final String ENGINE_ORACLE_HHK_NEW = "oracle.help.engine.HHKEngine";
    private static final String ENGINE_ORACLE_TOK_NEW = "oracle.help.engine.TOKEngine";
    private static final String ENGINE_ORACLE_SEARCH_NEW = "oracle.help.engine.SearchEngine";

    public HelpBook() {
    }

    public HelpBook(Class clazz, String string, String string2, String string3) throws HelpBookException {
        this(clazz, string, string2, string3, StaticLocaleContext.getEncoding());
    }

    public HelpBook(Class clazz, String string, String string2, String string3, String string4) throws HelpBookException {
        this();
        if (clazz == null || string2 == null) {
            throw new HelpBookException("HelpBook:  NULL parameters passed to constructor");
        }
        if (string2.equals("")) {
            throw new HelpBookException("HelpBook:  EMPTY parameters passed to constructor");
        }
        String string5 = this._constructDirectoryURL(clazz, string, string2.concat(".toc"));
        if (string5 == null && (string5 = this._constructDirectoryURL(clazz, string, string2.concat(".tok"))) == null && (string5 = this._constructDirectoryURL(clazz, string, string2.concat(".idx"))) == null && (string5 = this._constructDirectoryURL(clazz, string, string2.concat(".hhc"))) == null && (string5 = this._constructDirectoryURL(clazz, string, string2.concat(".hhk"))) == null) {
            string5 = this._constructDirectoryURL(clazz, string, string2.concat(".oht"));
        }
        if (string5 == null) {
            throw new HelpBookException("HelpBook:  Cannot find any " + string2 + "help files at the specified location" + clazz + string);
        }
        this._initHelpBook(string5, string2, string3, string4);
    }

    public HelpBook(String string, String string2, String string3) throws HelpBookException {
        this(string, string2, string3, StaticLocaleContext.getEncoding());
    }

    public HelpBook(String string, String string2, String string3, String string4) throws HelpBookException {
        this();
        if (string == null || string2 == null) {
            throw new HelpBookException("HelpBook:  NULL parameters passed to constructor");
        }
        if (string.equals("") || string2.equals("")) {
            throw new HelpBookException("HelpBook:  EMPTY parameters passed to constructor");
        }
        this._initHelpBook(string, string2, string3, string4);
    }

    public String getBookTitle() {
        return this._title;
    }

    public View[] getViewsByType(String string) {
        View[] viewArray = null;
        ArrayList<View> arrayList = new ArrayList<View>();
        if (string == null) {
            return null;
        }
        int n = 0;
        while (n < this._views.size()) {
            View view = (View)this._views.get(n);
            if (view.getType().equals(string)) {
                arrayList.add(view);
            }
            ++n;
        }
        if (arrayList.size() > 0) {
            viewArray = new View[arrayList.size()];
            arrayList.toArray(viewArray);
        }
        return viewArray;
    }

    public View[] getAllViews() {
        View[] viewArray = null;
        if (this._views.size() > 0) {
            viewArray = new View[this._views.size()];
            this._views.toArray(viewArray);
        }
        return viewArray;
    }

    public WindowType[] getWindowTypes() {
        return null;
    }

    public AssociativeLink[] getAssociativeLinks() {
        return null;
    }

    public URL mapIDToURL(String string) {
        URL uRL = null;
        String string2 = null;
        if (this._topicHash != null) {
            string2 = (String)this._topicHash.get(string);
        }
        if (string2 != null) {
            try {
                uRL = Canonicalizer.getAbsoluteURL(this._baseURL, string2);
            }
            catch (MalformedURLException malformedURLException) {
                uRL = null;
            }
        }
        return uRL;
    }

    public String mapURLToWindowTypeName(URL uRL) {
        return null;
    }

    public String getBaseURL() {
        return this._baseURL;
    }

    public String getBaseName() {
        return this._baseName;
    }

    public String getTitle() {
        return this._title;
    }

    private void _initHelpBook(String string, String string2, String string3, String string4) throws HelpBookException {
        this._baseURL = Canonicalizer.fixSeparators(string);
        this._baseName = string2;
        this._title = string3;
        this._controlFileEncoding = string4;
        try {
            this._checkForTOC();
            this._checkForIndex();
            this._checkForSearch();
            this._checkForTopicHash();
            if (this._views.size() == 0 && this._topicHash == null) {
                throw new HelpBookException("HelpBook:  Unable to find any valid control files");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new HelpBookException("Unknown error when parsing hs file: " + exception.getMessage());
        }
    }

    private void _checkForTOC() {
        String string = null;
        URL uRL = null;
        try {
            uRL = new URL(Canonicalizer.appendFileToPath(this._baseURL, this._baseName + ".toc"));
            InputStream inputStream = uRL.openStream();
            inputStream.close();
            string = ENGINE_ORACLE_TOC_NEW;
        }
        catch (Exception exception) {
            try {
                uRL = new URL(Canonicalizer.appendFileToPath(this._baseURL, this._baseName + ".hhc"));
                InputStream inputStream = uRL.openStream();
                inputStream.close();
                string = ENGINE_ORACLE_HHC_NEW;
            }
            catch (Exception exception2) {
                uRL = null;
                string = null;
            }
        }
        if (uRL != null && string != null) {
            this._addView(TYPE_DEFAULT_ORACLE_TOC, string, uRL);
        }
    }

    private void _checkForIndex() {
        String string = null;
        URL uRL = null;
        try {
            uRL = new URL(Canonicalizer.appendFileToPath(this._baseURL, this._baseName + ".tok"));
            InputStream inputStream = uRL.openStream();
            inputStream.close();
            string = ENGINE_ORACLE_TOK_NEW;
        }
        catch (Exception exception) {
            try {
                uRL = new URL(Canonicalizer.appendFileToPath(this._baseURL, this._baseName + ".hhk"));
                InputStream inputStream = uRL.openStream();
                inputStream.close();
                string = ENGINE_ORACLE_HHK_NEW;
            }
            catch (Exception exception2) {
                uRL = null;
                string = null;
            }
        }
        if (uRL != null && string != null) {
            this._addView(TYPE_DEFAULT_ORACLE_KEYWORD, string, uRL);
        }
    }

    private void _checkForSearch() {
        String string = null;
        URL uRL = null;
        try {
            uRL = new URL(Canonicalizer.appendFileToPath(this._baseURL, this._baseName + ".idx"));
            InputStream inputStream = uRL.openStream();
            inputStream.close();
            string = ENGINE_ORACLE_SEARCH_NEW;
        }
        catch (Exception exception) {
            uRL = null;
            string = null;
        }
        if (uRL != null && string != null) {
            this._addView(TYPE_DEFAULT_ORACLE_SEARCH, string, uRL);
        }
    }

    private void _checkForTopicHash() {
        try {
            URL uRL = new URL(Canonicalizer.appendFileToPath(this._baseURL, this._baseName + ".oht"));
            this._topicHash = OhtParser.getTopicsHashMap(uRL, this._controlFileEncoding);
        }
        catch (Exception exception) {
            this._topicHash = null;
        }
    }

    private void _addView(String string, String string2, URL uRL) {
        View view = null;
        DataEngine dataEngine = null;
        try {
            Class<?> clazz = Class.forName(string2);
            if (clazz != null) {
                dataEngine = (DataEngine)clazz.newInstance();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Could not find specified engine class.  Make sure " + string2 + "is on your class path.");
        }
        catch (ClassCastException classCastException) {
            System.err.println("Specified engine " + string2 + " not a subclass of oracle.help.engine.DataEngine");
        }
        catch (Exception exception) {
            System.err.println("Unable to create specified engine " + string2);
        }
        if (dataEngine != null) {
            view = new View(this, this._baseURL, string, dataEngine, uRL, this._controlFileEncoding, this._title, null, null);
            this._views.add(view);
        }
    }

    private String _constructDirectoryURL(Class clazz, String string, String string2) {
        String string3 = null;
        String string4 = null;
        String string5 = string;
        if (string5 == null) {
            string5 = ".";
        }
        string4 = (string5 = Canonicalizer.fixSeparators(string5)).equals(".") || string5.equals("./") || string5.equals("") ? string2 : Canonicalizer.appendFileToPath(string5, string2);
        try {
            URL uRL = clazz.getResource(string4);
            if (uRL != null) {
                string3 = uRL.toString();
                string3 = string3.substring(0, string3.lastIndexOf(47) + 1);
            }
        }
        catch (Exception exception) {
            string3 = null;
        }
        return string3;
    }
}

