/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.engine;

import java.io.BufferedReader;
import java.io.IOException;
import java.net.URL;
import java.util.StringTokenizer;
import oracle.help.common.KeywordTopicTreeNode;
import oracle.help.common.SimpleTopic;
import oracle.help.common.SimpleURLTarget;
import oracle.help.common.TopicTree;
import oracle.help.common.TopicTreeNode;
import oracle.help.common.View;
import oracle.help.engine.DataEngine;
import oracle.help.library.Book;

public class TOKEngine
extends DataEngine {
    private static final String TOK_LINE_BRANCH = "BRANCH";
    private static final String TOK_LINE_LEAF = "LEAF";
    private Book _book = null;
    private View _view = null;
    private boolean _foundFakeIndenting = false;

    public Object createDataObject(View view, String string, URL uRL, String string2) throws IOException {
        if (uRL == null) {
            throw new IllegalArgumentException("Null parameter passed to DataEngine constructor");
        }
        BufferedReader bufferedReader = this._getBufferedReader(uRL, string2);
        return this.createDataObject(view, string, bufferedReader);
    }

    public Object createDataObject(View view, String string, BufferedReader bufferedReader) throws IOException {
        Book book = null;
        if (view != null) {
            book = view.getBook();
        }
        TopicTree topicTree = new TopicTree(book, string);
        TopicTreeNode topicTreeNode = topicTree.getRoot();
        this.parseTOK(book, view, bufferedReader, topicTreeNode);
        return topicTree;
    }

    protected void parseTOK(Book book, View view, BufferedReader bufferedReader, TopicTreeNode topicTreeNode) {
        int n = 0;
        String string = "";
        this._book = book;
        this._view = view;
        KeywordTopicTreeNode keywordTopicTreeNode = null;
        TopicTreeNode topicTreeNode2 = null;
        while (true) {
            try {
                string = bufferedReader.readLine();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                string = null;
            }
            if (string == null) break;
            if (string.equals("") || string.charAt(0) == '#') continue;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|", true);
            try {
                n = Integer.parseInt(stringTokenizer.nextToken().trim());
                if (!stringTokenizer.nextToken().trim().equals("|")) {
                }
            }
            catch (Exception exception) {}
            continue;
            KeywordTopicTreeNode keywordTopicTreeNode2 = this._parseLine(stringTokenizer, n);
            if (keywordTopicTreeNode2 == null) continue;
            if (n == 1) {
                if (!this._foundFakeIndenting || topicTreeNode2 == null) {
                    topicTreeNode.addChild(keywordTopicTreeNode2);
                    keywordTopicTreeNode = keywordTopicTreeNode2;
                    topicTreeNode2 = keywordTopicTreeNode2;
                } else {
                    topicTreeNode2.addChild(keywordTopicTreeNode2);
                    keywordTopicTreeNode = keywordTopicTreeNode2;
                }
            }
            if (n <= 1 || keywordTopicTreeNode2.isBranch() || keywordTopicTreeNode == null) continue;
            keywordTopicTreeNode.addEntry(keywordTopicTreeNode2);
        }
    }

    private KeywordTopicTreeNode _parseLine(StringTokenizer stringTokenizer, int n) {
        KeywordTopicTreeNode keywordTopicTreeNode = null;
        try {
            String string = stringTokenizer.nextToken().trim();
            if (!stringTokenizer.nextToken().trim().equals("|")) {
                return null;
            }
            if (string.equals(TOK_LINE_BRANCH)) {
                keywordTopicTreeNode = this._parseBranch(stringTokenizer, n);
                if (keywordTopicTreeNode == null) {
                    return null;
                }
            } else if (string.equals(TOK_LINE_LEAF)) {
                keywordTopicTreeNode = this._parseLeaf(stringTokenizer, n);
                if (keywordTopicTreeNode == null) {
                    return null;
                }
            } else {
                keywordTopicTreeNode = null;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            keywordTopicTreeNode = null;
        }
        return keywordTopicTreeNode;
    }

    private KeywordTopicTreeNode _parseBranch(StringTokenizer stringTokenizer, int n) {
        KeywordTopicTreeNode keywordTopicTreeNode = null;
        SimpleTopic simpleTopic = null;
        SimpleURLTarget simpleURLTarget = null;
        String string = stringTokenizer.nextToken().trim();
        if (!string.equals("|") && !stringTokenizer.nextToken().trim().equals("|")) {
            return null;
        }
        String string2 = stringTokenizer.nextToken();
        if (string2 != null) {
            simpleTopic = new SimpleTopic(string2, this._book);
            this._foundFakeIndenting = string2.startsWith(" ");
        }
        if (stringTokenizer.hasMoreTokens() && stringTokenizer.nextToken().trim().equals("|") && stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken().trim();
            simpleURLTarget = new SimpleURLTarget(this._view, string3);
            simpleTopic.setTarget(simpleURLTarget);
        }
        keywordTopicTreeNode = new KeywordTopicTreeNode(this._view, simpleTopic);
        return keywordTopicTreeNode;
    }

    private KeywordTopicTreeNode _parseLeaf(StringTokenizer stringTokenizer, int n) {
        KeywordTopicTreeNode keywordTopicTreeNode = null;
        SimpleTopic simpleTopic = null;
        SimpleURLTarget simpleURLTarget = null;
        String string = "";
        String string2 = "";
        String string3 = stringTokenizer.nextToken().trim();
        if (!string3.equals("|") && !stringTokenizer.nextToken().trim().equals("|")) {
            return null;
        }
        string = stringTokenizer.nextToken();
        if (!stringTokenizer.nextToken().trim().equals("|")) {
            return null;
        }
        string2 = stringTokenizer.nextToken().trim();
        if (string != null) {
            simpleTopic = new SimpleTopic(string, this._book);
            this._foundFakeIndenting = string.startsWith(" ");
        }
        simpleURLTarget = new SimpleURLTarget(this._view, string2);
        simpleTopic.setTarget(simpleURLTarget);
        keywordTopicTreeNode = new KeywordTopicTreeNode(this._view, simpleTopic);
        return keywordTopicTreeNode;
    }
}

