/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.engine;

import java.io.BufferedReader;
import java.io.IOException;
import java.net.URL;
import java.util.StringTokenizer;
import oracle.help.common.SimpleTopic;
import oracle.help.common.SimpleURLTarget;
import oracle.help.common.TopicTree;
import oracle.help.common.TopicTreeNode;
import oracle.help.common.View;
import oracle.help.engine.DataEngine;
import oracle.help.library.Book;

public class TOCEngine
extends DataEngine {
    private static final String TOC_LINE_BRANCH = "BRANCH";
    private static final String TOC_LINE_LEAF = "LEAF";
    private Book _book = null;
    private View _view = null;

    public Object createDataObject(View view, String string, URL uRL, String string2) throws IOException {
        if (uRL == null) {
            throw new IllegalArgumentException("Null parameter passed to DataEngine constructor");
        }
        BufferedReader bufferedReader = this._getBufferedReader(uRL, string2);
        return this.createDataObject(view, string, bufferedReader);
    }

    public Object createDataObject(View view, String string, BufferedReader bufferedReader) throws IOException {
        Book book = null;
        if (view != null) {
            book = view.getBook();
        }
        TopicTree topicTree = new TopicTree(book, string);
        TopicTreeNode topicTreeNode = topicTree.getRoot();
        this.parseTOC(book, view, bufferedReader, topicTreeNode);
        return topicTree;
    }

    protected void parseTOC(Book book, View view, BufferedReader bufferedReader, TopicTreeNode topicTreeNode) {
        int n = 0;
        int n2 = 0;
        String string = "";
        this._book = book;
        this._view = view;
        while (true) {
            try {
                string = bufferedReader.readLine();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                string = null;
            }
            if (string == null) break;
            if (string.equals("") || string.charAt(0) == '#') continue;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|", true);
            try {
                n = Integer.parseInt(stringTokenizer.nextToken().trim());
                if (!stringTokenizer.nextToken().trim().equals("|")) {
                }
            }
            catch (Exception exception) {}
            continue;
            TopicTreeNode topicTreeNode2 = this._parseLine(stringTokenizer, n);
            if (topicTreeNode2 == null) continue;
            if (n2 == 0 && n != 1) {
                n2 = n;
            }
            if (n == n2) {
                topicTreeNode.addChild(topicTreeNode2);
            } else if (n == n2 + 1) {
                if (topicTreeNode.getNumChildren() > 0) {
                    topicTreeNode = topicTreeNode.getChildByIndex(topicTreeNode.getNumChildren() - 1);
                }
                topicTreeNode.addChild(topicTreeNode2);
            } else {
                if (n >= n2) continue;
                int n3 = n2;
                while (n3 > n) {
                    topicTreeNode = topicTreeNode.getParent();
                    --n3;
                }
                topicTreeNode.addChild(topicTreeNode2);
            }
            n2 = n;
        }
    }

    private TopicTreeNode _parseLine(StringTokenizer stringTokenizer, int n) {
        TopicTreeNode topicTreeNode = null;
        try {
            String string = stringTokenizer.nextToken().trim();
            if (!stringTokenizer.nextToken().trim().equals("|")) {
                return null;
            }
            if (string.equals(TOC_LINE_BRANCH)) {
                topicTreeNode = this._parseBranch(stringTokenizer, n);
                if (topicTreeNode == null) {
                    return null;
                }
            } else if (string.equals(TOC_LINE_LEAF)) {
                topicTreeNode = this._parseLeaf(stringTokenizer, n);
                if (topicTreeNode == null) {
                    return null;
                }
            } else {
                topicTreeNode = null;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            topicTreeNode = null;
        }
        return topicTreeNode;
    }

    private TopicTreeNode _parseBranch(StringTokenizer stringTokenizer, int n) {
        TopicTreeNode topicTreeNode = null;
        SimpleTopic simpleTopic = null;
        SimpleURLTarget simpleURLTarget = null;
        String string = stringTokenizer.nextToken().trim();
        if (!string.equals("|") && !stringTokenizer.nextToken().trim().equals("|")) {
            return null;
        }
        String string2 = stringTokenizer.nextToken().trim();
        simpleTopic = new SimpleTopic(string2, this._book);
        if (stringTokenizer.hasMoreTokens() && stringTokenizer.nextToken().trim().equals("|") && stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken().trim();
            simpleURLTarget = new SimpleURLTarget(this._view, string3);
            simpleTopic.setTarget(simpleURLTarget);
        }
        topicTreeNode = new TopicTreeNode(this._view, simpleTopic);
        return topicTreeNode;
    }

    private TopicTreeNode _parseLeaf(StringTokenizer stringTokenizer, int n) {
        TopicTreeNode topicTreeNode = null;
        SimpleTopic simpleTopic = null;
        SimpleURLTarget simpleURLTarget = null;
        String string = "";
        String string2 = "";
        String string3 = stringTokenizer.nextToken().trim();
        if (!string3.equals("|") && !stringTokenizer.nextToken().trim().equals("|")) {
            return null;
        }
        string = stringTokenizer.nextToken().trim();
        if (!stringTokenizer.nextToken().trim().equals("|")) {
            return null;
        }
        string2 = stringTokenizer.nextToken().trim();
        simpleTopic = new SimpleTopic(string, this._book);
        simpleURLTarget = new SimpleURLTarget(this._view, string2);
        simpleTopic.setTarget(simpleURLTarget);
        topicTreeNode = new TopicTreeNode(this._view, simpleTopic);
        return topicTreeNode;
    }
}

