/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.common.xml;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import oracle.help.common.xml.XMLParseException;
import oracle.help.common.xml.XMLToken;

public class XMLNode {
    private XMLNode _parent;
    private XMLToken _token;
    private String _string;
    private XMLNode _firstChild;
    private XMLNode _lastChild;
    private XMLNode _previousSibling;
    private XMLNode _nextSibling;
    private int _lineNumber = 0;

    XMLNode() {
        this._parent = null;
        this._token = null;
    }

    XMLNode(XMLToken xMLToken, XMLNode xMLNode) throws XMLParseException {
        this._parent = xMLNode;
        this._token = xMLToken;
        this._firstChild = null;
        this._lastChild = null;
        this._previousSibling = null;
        this._nextSibling = null;
        if (this._token.getType() != 1) {
            throw new XMLParseException("Creating a node with a type that isn't OPEN_TAG");
        }
        this._parent._addChild(this);
    }

    public XMLNode getParent() {
        return this._parent;
    }

    public String getTokenValue() {
        return this._token.getTokenValue();
    }

    public HashMap getTokenProperties() {
        return this._token.getProperties();
    }

    public String getTokenProperty(String string) {
        if (this._token.getProperties() != null) {
            return (String)this._token.getProperties().get(string);
        }
        return null;
    }

    public String getString() {
        if (this._string != null) {
            return this._string.trim();
        }
        return null;
    }

    public void setString(String string) throws XMLParseException {
        if (this._string != null) {
            throw new XMLParseException("Setting a second string on a node. Old string: " + this._string + "  New string: " + string);
        }
        this._string = string;
    }

    public boolean tokenEquals(String string) {
        return this.getTokenValue().equalsIgnoreCase(string);
    }

    public XMLNode getFirstChild() {
        return this._firstChild;
    }

    public XMLNode getLastChild() {
        return this._lastChild;
    }

    public XMLNode getPreviousSibling() {
        return this._previousSibling;
    }

    public XMLNode getNextSibling() {
        return this._nextSibling;
    }

    public int getLineNumber() {
        return this._lineNumber;
    }

    public void setLineNumber(int n) {
        this._lineNumber = n;
    }

    public String toString() {
        String string = super.toString() + ": Token is " + this._token + ", string is " + this._string;
        return string;
    }

    public void print() {
        this._printTree("");
    }

    void _printTree(String string) {
        if (this.getParent() != null) {
            System.out.print(string + "<" + this.getTokenValue());
            HashMap hashMap = this.getTokenProperties();
            if (hashMap != null) {
                Set set = hashMap.keySet();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    System.out.print(" " + string2 + "=\"" + hashMap.get(string2) + "\"");
                }
            }
            System.out.print(">");
            if (this.getString() != null) {
                System.out.print(this.getString());
            }
            if (this.getFirstChild() != null) {
                System.out.println("");
                this.getFirstChild()._printTree(string + "  ");
                System.out.println(string + "</" + this.getTokenValue() + ">");
            } else {
                System.out.println("</" + this.getTokenValue() + ">");
            }
            if (this.getNextSibling() != null) {
                this.getNextSibling()._printTree(string);
            }
        } else if (this.getFirstChild() != null) {
            this.getFirstChild()._printTree(string);
        } else {
            System.out.println(string + "EMPTY ROOT NODE");
        }
    }

    void _clearString() {
        this._string = null;
    }

    void _setTokenProperty(String string, String string2) {
        HashMap<String, String> hashMap = this.getTokenProperties();
        if (hashMap == null) {
            XMLToken xMLToken;
            hashMap = new HashMap<String, String>(7);
            this._token = xMLToken = new XMLToken(this._token.getTokenValue(), this._token.getType(), hashMap);
        }
        hashMap.put(string, string2);
    }

    private void _addChild(XMLNode xMLNode) {
        if (this._firstChild == null) {
            this._firstChild = this._lastChild = xMLNode;
        } else {
            this._lastChild._nextSibling = xMLNode;
            xMLNode._previousSibling = this._lastChild;
            this._lastChild = xMLNode;
        }
    }
}

