/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.common.search;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.help.common.SimpleTopic;
import oracle.help.common.SimpleURLTarget;
import oracle.help.common.Topic;
import oracle.help.common.View;
import oracle.help.common.search.QueryHandler;
import oracle.help.common.search.QueryResult;
import oracle.help.common.search.SearchException;
import oracle.help.common.search.SearchExpression;
import oracle.help.common.search.StringExpression;

public class IndexFileQueryHandler
extends QueryHandler {
    private URL _url;
    private View _view;
    private char[] _alphabet;
    private long[] _alphaOffsets;
    private long _eowOffset;
    private long _fsOffset;
    private String _productTitle;
    private int _version;
    private String _encoding;
    private boolean _fileCase;
    private boolean _scoreAvailable;
    private boolean _titlesAvailable;
    private String _rootPath;
    private String _sourceIdentifier;
    private boolean _stopSearch = false;
    private boolean _needToParseHeader = true;
    private static final int VERSION_10 = 10;
    private static final int VERSION_11 = 11;
    private static final int VERSION_20 = 20;
    static final String INDEX_VERSION = "OIN-INDEX-VERSION";
    static final String CHARACTER_SET = "CHARACTER-SET";
    static final String PRODUCT_TITLE = "PRODUCT-TITLE";
    static final String CASESENSITIVE = "CASESENSITIVE";
    static final String TITLES = "TITLES";
    static final String BLOCK_SIZE = "BLOCK-SIZE";
    static final String SCORES = "SCORES";
    static final String ROOT_PATH = "ROOTPATH";
    static final String TRUE = "TRUE";

    public static IndexFileQueryHandler getInstance(View view, String string, URL uRL) {
        IndexFileQueryHandler indexFileQueryHandler = null;
        try {
            indexFileQueryHandler = new IndexFileQueryHandler(view, string, uRL);
            return indexFileQueryHandler;
        }
        catch (Exception exception) {
            System.out.println("Invalid IDX file URL.  IOException when accessing " + uRL.toString());
            exception.printStackTrace();
            return null;
        }
    }

    public URL getIndexFileUrl() {
        return this._url;
    }

    public void stopSearch() {
        this._stopSearch = true;
    }

    public boolean supportsCaseSensitiveSearches() {
        return true;
    }

    public Set getSupportedSources() {
        if (this._sourceIdentifier == null) {
            return Collections.EMPTY_SET;
        }
        return Collections.singleton(this._sourceIdentifier);
    }

    public String productTitle() {
        return this._productTitle;
    }

    public synchronized List executeQuery(String[] stringArray, boolean bl, boolean bl2, Set set) throws SearchException {
        this._stopSearch = false;
        this._checkSources(set);
        if (this._needToParseHeader) {
            this._parseHeader();
        }
        List list = null;
        try {
            list = this._executeStringQuery(stringArray, bl, bl2);
        }
        catch (SearchInterruptedError searchInterruptedError) {
            list = Collections.EMPTY_LIST;
        }
        return list;
    }

    public synchronized List executeQuery(SearchExpression searchExpression, Set set) throws SearchException {
        this._stopSearch = false;
        this._checkSources(set);
        if (this._needToParseHeader) {
            this._parseHeader();
        }
        List list = null;
        try {
            list = this._executeBooleanQuery(searchExpression);
        }
        catch (SearchInterruptedError searchInterruptedError) {
            list = Collections.EMPTY_LIST;
        }
        return list;
    }

    private void _checkSources(Set set) throws SearchException {
        if (set != null && !set.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (string.equals(this._sourceIdentifier)) continue;
                throw new SearchException("IndexFileQueryHandler: " + this._url + "/n" + "Called with unsupported source: " + string);
            }
        }
    }

    private void _checkStopSearch() {
        if (this._stopSearch) {
            throw new SearchInterruptedError("Search Interrupted");
        }
    }

    private List _executeStringQuery(String[] stringArray, boolean bl, boolean bl2) throws SearchException {
        String[] stringArray2;
        if (stringArray != null && stringArray.length > 0 && (stringArray2 = this._filter(stringArray)).length > 0) {
            if (this._fileCase && !bl2) {
                return this._executeComplexStringQuery(stringArray2, bl);
            }
            return this._executeSimpleStringQuery(stringArray, bl);
        }
        return Collections.EMPTY_LIST;
    }

    /*
     * Unable to fully structure code
     */
    private List _executeSimpleStringQuery(String[] var1_1, boolean var2_2) throws SearchException {
        block46: {
            var3_3 = new ArrayList<E>();
            var4_4 = null;
            try {
                block45: {
                    var5_5 = new String[var1_1.length];
                    if (this._fileCase) {
                        var7_7 = 0;
                        while (var7_7 < var1_1.length) {
                            var5_5[var7_7] = var1_1[var7_7];
                            ++var7_7;
                        }
                    } else {
                        var7_7 = 0;
                        while (var7_7 < var1_1.length) {
                            var5_5[var7_7] = var1_1[var7_7].toLowerCase();
                            ++var7_7;
                        }
                    }
                    this._bubbleSort(var5_5);
                    var10_8 = 0;
                    var11_9 = new byte[1000];
                    var12_10 = 0;
                    var13_11 = 0;
                    var14_12 = 0;
                    var15_13 = new byte[512];
                    var18_14 = 0;
                    var20_15 = false;
                    var6_16 = new long[var5_5.length];
                    var4_4 = this._openInputStream(this._url);
                    var23_17 = new InputStreamWrapper(var4_4);
                    var21_18 = !var2_2;
                    while (!var20_15) {
                        var16_20 = var17_21 = var10_8;
                        var7_7 = var10_8;
                        while (var7_7 < var5_5.length) {
                            if (var5_5[var10_8].charAt(0) != var5_5[var7_7].charAt(0)) break;
                            ++var17_21;
                            ++var7_7;
                        }
                        if ((var24_24 = this._getAlphabetIndex(var5_5[var16_20].charAt(0))) == -1) {
                            if (var2_2) {
                                var21_18 = true;
                                break;
                            }
                            var7_7 = var16_20;
                            while (var7_7 < var17_21) {
                                var6_16[var7_7] = 0L;
                                ++var7_7;
                            }
                            var10_8 = var17_21;
                            if (var17_21 != var5_5.length) continue;
                            var20_15 = true;
                            continue;
                        }
                        var25_25 = this._alphaOffsets[var24_24];
                        var27_26 = var24_24 == this._alphabet.length - 1 ? this._eowOffset : this._alphaOffsets[var24_24 + 1];
                        var23_17.skipToOffset(var25_25);
                        var19_22 = false;
                        while (!var20_15 && !var19_22) {
                            block44: {
                                var29_27 = 0;
                                if ((long)var13_11 + (var27_26 - var23_17.getPosition()) > (long)var11_9.length) {
                                    var12_10 = var11_9.length - var13_11;
                                } else {
                                    var12_10 = (int)(var27_26 - var23_17.getPosition());
                                    var19_22 = true;
                                }
                                var23_17.read(var11_9, var13_11, var12_10);
                                var14_12 = var12_10 + var13_11;
                                var13_11 = 0;
                                try {
                                    var18_14 = var16_20;
                                    var30_28 = 0;
                                    var31_30 = 0;
                                    var32_31 = null;
                                    do {
                                        var22_23 = 0;
                                        var29_27 = var30_28;
                                        if (this._version < 20) {
                                            while ((var15_13[var22_23++] = var11_9[var30_28++]) != 32) {
                                            }
                                            var32_31 = new String(var15_13, 0, var22_23 - 1);
                                        } else {
                                            var31_30 = var11_9[var30_28++];
                                            while (var31_30 != 0) {
                                                var15_13[var22_23++] = var11_9[var30_28++];
                                                --var31_30;
                                            }
                                            var32_31 = this._bytesToString(var15_13, 0, var22_23);
                                        }
                                        if (var5_5[var18_14].equals(var32_31)) {
                                            var8_19 = 0;
                                            while (var8_19 < 4) {
                                                var33_32 = var11_9[var30_28 + var8_19];
                                                if (var33_32 < 0) {
                                                    var33_32 = 256 + var33_32;
                                                }
                                                v0 = var18_14;
                                                var6_16[v0] = var6_16[v0] | (long)(var33_32 << 8 * (3 - var8_19));
                                                ++var8_19;
                                            }
                                            ++var18_14;
                                            if (!var2_2) {
                                                var21_18 = false;
                                            }
                                        } else if (var5_5[var18_14].compareTo(var32_31) < 0) {
                                            var6_16[var18_14] = 0L;
                                            ++var18_14;
                                            if (var2_2) {
                                                var21_18 = true;
                                                var20_15 = true;
                                                break block44;
                                            }
                                        }
                                        if ((var30_28 += 4) <= var14_12) continue;
                                        throw new IndexOutOfBoundsException();
                                    } while (var18_14 != var17_21);
                                    break block44;
                                }
                                catch (IndexOutOfBoundsException var30_29) {
                                    var13_11 = var14_12 - var29_27;
                                    var7_7 = 0;
                                    ** while (var7_7 < var13_11)
                                }
lbl-1000:
                                // 1 sources

                                {
                                    var11_9[var7_7] = var11_9[var29_27 + var7_7];
                                    ++var7_7;
                                    continue;
                                }
                            }
                            if (var18_14 == var5_5.length) {
                                var20_15 = true;
                            }
                            if (var18_14 == var17_21) break;
                        }
                        var10_8 = var17_21;
                        this._checkStopSearch();
                    }
                    if (var21_18) break block45;
                    var7_7 = 0;
                    while (var7_7 < var5_5.length) {
                        if (var6_16[var7_7] != 0L) {
                            var23_17.skipToOffset(var6_16[var7_7]);
                            if (var7_7 == 0) {
                                this._readFileIndices(var23_17, var3_3, true);
                            } else if (var2_2) {
                                this._readFileIndices(var23_17, var3_3, false);
                                if (var3_3.size() == 0) {
                                    break;
                                }
                            } else {
                                this._readFileIndices(var23_17, var3_3, true);
                            }
                            this._checkStopSearch();
                        }
                        ++var7_7;
                    }
                    if (var3_3.size() <= 0) break block45;
                    var23_17.skipToOffset(this._fsOffset);
                    this._readFileNames(var23_17, var3_3, var11_9);
                    var3_3.trimToSize();
                    if (!this._scoreAvailable) break block45;
                    IndexFileQueryHandler._quickSort(var3_3, 0, var3_3.size() - 1);
                }
                var35_33 = null;
                ** if (var4_4 == null) goto lbl-1000
            }
            catch (Throwable var34_37) {
                var35_34 = null;
                if (var4_4 != null) {
                    try {
                        var4_4.close();
                        var4_4 = null;
                    }
                    catch (Exception var36_36) {
                        // empty catch block
                    }
                }
                throw var34_37;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    var4_4.close();
                    var4_4 = null;
                }
                catch (Exception var36_35) {}
            }
lbl-1000:
            // 2 sources

            {
                break block46;
                catch (Exception var5_6) {
                    throw new SearchException("Error encountered executing search: " + var5_6.getMessage(), var5_6);
                }
            }
        }
        return var3_3;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List _executeComplexStringQuery(String[] var1_1, boolean var2_2) throws SearchException {
        var3_3 = new ArrayList<ResultObject>();
        var4_4 = null;
        var6_5 = new ArrayList<String>();
        var7_6 = new ArrayList<Long>();
        try {
            block52: {
                try {
                    block56: {
                        block57: {
                            var5_7 = new String[var1_1.length];
                            var9_8 = 0;
                            while (var9_8 < var1_1.length) {
                                var5_7[var9_8] = var1_1[var9_8].toLowerCase();
                                ++var9_8;
                            }
                            this._bubbleSort(var5_7);
                            var14_9 = 0;
                            var15_11 = new byte[1000];
                            var16_12 = 0;
                            var17_13 = 0;
                            var18_14 = 0;
                            var19_15 = new byte[512];
                            var22_16 = 0;
                            var24_17 = false;
                            var4_4 = this._openInputStream(this._url);
                            var27_18 = new InputStreamWrapper(var4_4);
                            var25_19 = var2_2 == false;
                            var28_20 = 0;
                            while (var28_20 < 2) {
                                var14_9 = 0;
                                var24_17 = false;
                                while (!var24_17) {
                                    block54: {
                                        block53: {
                                            var20_24 = var21_25 = var14_9;
                                            if (var28_20 != 0) break block53;
                                            var30_30 = Character.toUpperCase(var5_7[var14_9].charAt(0));
                                            var9_8 = var14_9;
                                            ** GOTO lbl42
                                        }
                                        var30_30 = var5_7[var14_9].charAt(0);
                                        var9_8 = var14_9;
                                        ** GOTO lbl50
                                        while (var30_30 == Character.toUpperCase(var5_7[var9_8].charAt(0))) {
                                            ++var21_25;
                                            ++var9_8;
lbl42:
                                            // 2 sources

                                            if (var9_8 < var5_7.length) continue;
                                        }
                                        var8_21 = new Character(var30_30).toString();
                                        var8_21 = var8_21.concat(var5_7[var21_25 - 1].substring(1));
                                        var29_28 = this._getAlphabetIndex(var30_30);
                                        break block54;
                                        while (var30_30 == var5_7[var9_8].charAt(0)) {
                                            ++var21_25;
                                            ++var9_8;
lbl50:
                                            // 2 sources

                                            if (var9_8 < var5_7.length) continue;
                                        }
                                        var8_21 = var5_7[var21_25 - 1];
                                        var29_28 = this._getAlphabetIndex(var30_30);
                                    }
                                    if (var29_28 == -1) {
                                        var14_9 = var21_25;
                                        if (var21_25 != var5_7.length) continue;
                                        var24_17 = true;
                                        continue;
                                    }
                                    var12_23 = this._alphaOffsets[var29_28];
                                    if (var27_18.getPosition() > var12_23) {
                                        var14_9 = var21_25;
                                        if (var21_25 != var5_7.length) continue;
                                        var24_17 = true;
                                        continue;
                                    }
                                    var30_31 = var29_28 == this._alphabet.length - 1 ? this._eowOffset : this._alphaOffsets[var29_28 + 1];
                                    var27_18.skipToOffset(var12_23);
                                    var23_26 = false;
                                    block18: while (!var24_17 && !var23_26) {
                                        var32_33 = 0;
                                        if ((long)var17_13 + (var30_31 - var27_18.getPosition()) > (long)var15_11.length) {
                                            var16_12 = var15_11.length - var17_13;
                                        } else {
                                            var16_12 = (int)(var30_31 - var27_18.getPosition());
                                            var23_26 = true;
                                        }
                                        var27_18.read(var15_11, var17_13, var16_12);
                                        var18_14 = var16_12 + var17_13;
                                        var17_13 = 0;
                                        try {
                                            var22_16 = var20_24;
                                            var33_37 = 0;
                                            var34_39 = null;
                                            do {
                                                block55: {
                                                    var26_27 = 0;
                                                    var32_33 = var33_37;
                                                    if (this._version < 20) {
                                                        while ((var19_15[var26_27++] = var15_11[var33_37++]) != 32) {
                                                        }
                                                        var34_39 = new String(var19_15, 0, var26_27 - 1);
                                                    } else {
                                                        var36_41 = var15_11[var33_37++];
                                                        while (var36_41 != 0) {
                                                            var19_15[var26_27++] = var15_11[var33_37++];
                                                            --var36_41;
                                                        }
                                                        try {
                                                            var34_39 = new String(var19_15, 0, var26_27, this._encoding);
                                                        }
                                                        catch (UnsupportedEncodingException var37_42) {
                                                            var34_39 = new String(var19_15, 0, var26_27);
                                                        }
                                                    }
                                                    var35_40 = true;
                                                    var9_8 = var20_24;
                                                    while (var9_8 < var21_25) {
                                                        if (var34_39.equalsIgnoreCase(var5_7[var9_8])) {
                                                            var35_40 = false;
                                                            break;
                                                        }
                                                        ++var9_8;
                                                    }
                                                    if (var35_40) break block55;
                                                    var37_43 = 0L;
                                                    var10_22 = 0;
                                                    if (true) ** GOTO lbl121
                                                }
                                                if (var8_21.compareTo(var34_39) >= 0) continue;
                                                var23_26 = true;
                                                continue block18;
                                                do {
                                                    if ((var39_44 = var15_11[var33_37 + var10_22]) < 0) {
                                                        var39_44 = 256 + var39_44;
                                                    }
                                                    var37_43 |= (long)(var39_44 << 8 * (3 - var10_22));
                                                    ++var10_22;
lbl121:
                                                    // 2 sources

                                                } while (var10_22 < 4);
                                                var6_5.add(var34_39);
                                                var7_6.add(new Long(var37_43));
                                            } while ((var33_37 += 4) <= var18_14);
                                            throw new IndexOutOfBoundsException();
                                        }
                                        catch (IndexOutOfBoundsException var33_38) {
                                            var17_13 = var18_14 - var32_33;
                                            var9_8 = 0;
                                            ** while (var9_8 < var17_13)
                                        }
lbl-1000:
                                        // 1 sources

                                        {
                                            var15_11[var9_8] = var15_11[var32_33 + var9_8];
                                            ++var9_8;
                                            continue;
lbl135:
                                            // 1 sources

                                        }
                                    }
                                    if (var21_25 == var5_7.length) {
                                        var24_17 = true;
                                    }
                                    var14_9 = var21_25;
                                    this._checkStopSearch();
                                }
                                ++var28_20;
                            }
                            if (var6_5.size() == 0 || var2_2 && var6_5.size() < var5_7.length) {
                                var29_29 = Collections.EMPTY_LIST;
                                var41_45 = null;
                                if (var4_4 == null) return var29_29;
                                var4_4.close();
                                return var29_29;
                            }
                            var30_32 = new ArrayList[var5_7.length];
                            var9_8 = 0;
                            if (true) ** GOTO lbl171
                            catch (Exception var42_49) {
                                // empty catch block
                            }
                            return var29_29;
                            do {
                                var10_22 = 0;
                                while (var10_22 < var5_7.length) {
                                    if (var5_7[var10_22].equalsIgnoreCase((String)var6_5.get(var9_8))) break;
                                    ++var10_22;
                                }
                                var12_23 = (Long)var7_6.get(var9_8);
                                if (var12_23 != 0L) {
                                    if (var30_32[var10_22] == null) {
                                        var30_32[var10_22] = new ArrayList<E>();
                                    }
                                    var27_18.skipToOffset(var12_23);
                                    this._readFileIndices(var27_18, var30_32[var10_22], true);
                                    this._checkStopSearch();
                                }
                                ++var9_8;
lbl171:
                                // 2 sources

                            } while (var9_8 < var6_5.size());
                            if (var2_2) {
                                var9_8 = 0;
                                while (var9_8 < var5_7.length) {
                                    if (var30_32[var9_8] == null) {
                                        var31_53 = Collections.EMPTY_LIST;
                                        var41_46 = null;
                                        if (var4_4 == null) return var31_53;
                                        ** try [egrp 4[TRYBLOCK] [4 : 1462->1473)] { 
lbl181:
                                        // 1 sources

                                        var4_4.close();
                                        return var31_53;
                                    }
                                    ++var9_8;
                                }
                            }
                            if ((var3_3 = var30_32[0]) == null) {
                                var3_3 = new ArrayList<ResultObject>();
                            }
                            if (var1_1.length <= 1) break block56;
                            if (!var2_2) break block57;
                            var9_8 = 0;
                            if (true) ** GOTO lbl211
                        }
                        var9_8 = 1;
                        if (true) ** GOTO lbl231
lbl194:
                        // 1 sources

                        catch (Exception var42_50) {
                            // empty catch block
                        }
                        return var31_53;
                        do {
                            var31_54 = (ResultObject)var3_3.get(var9_8);
                            var31_54.useful = true;
                            var10_22 = 1;
                            while (var10_22 < var1_1.length) {
                                var32_35 = this._findFileIndex(var30_32[var10_22], var31_54.fileno);
                                if (var32_35 == null) {
                                    var31_54.useful = false;
                                } else {
                                    var31_54.setHitNumber(var31_54.getHitNumber() + var32_35.getHitNumber());
                                }
                                this._checkStopSearch();
                                ++var10_22;
                            }
                            ++var9_8;
lbl211:
                            // 2 sources

                        } while (var9_8 < var3_3.size());
                        this._filterResults(var3_3);
                        break block56;
                        do {
                            if (var30_32[var9_8] != null) {
                                var10_22 = 0;
                                while (var10_22 < var30_32[var9_8].size()) {
                                    var31_55 = (ResultObject)var30_32[var9_8].get(var10_22);
                                    var32_36 = this._findFileIndex(var3_3, var31_55.fileno);
                                    if (var32_36 == null) {
                                        var3_3.add(var31_55);
                                    } else {
                                        var32_36.setHitNumber(var32_36.getHitNumber() + var31_55.getHitNumber());
                                        var31_55.useful = false;
                                    }
                                    ++var10_22;
                                }
                                this._filterResults(var30_32[var9_8]);
                            }
                            this._checkStopSearch();
                            ++var9_8;
lbl231:
                            // 2 sources

                        } while (var9_8 < var1_1.length);
                    }
                    if (var3_3.size() <= 0) break block52;
                    var27_18.skipToOffset(this._fsOffset);
                    this._readFileNames(var27_18, var3_3, var15_11);
                    var3_3.trimToSize();
                    if (!this._scoreAvailable) break block52;
                    IndexFileQueryHandler._quickSort(var3_3, 0, var3_3.size() - 1);
                }
                catch (Exception var14_10) {
                    throw new SearchException("Error encountered executing search: " + var14_10.getMessage(), var14_10);
                }
            }
            var41_47 = null;
            if (var4_4 == null) return var3_3;
            try {}
            catch (Exception var42_51) {
                return var3_3;
            }
            var4_4.close();
            var4_4 = null;
            return var3_3;
        }
        catch (Throwable var40_56) {
            var41_48 = null;
            if (var4_4 == null) throw var40_56;
            ** try [egrp 4[TRYBLOCK] [4 : 1462->1473)] { 
lbl256:
            // 1 sources

            var4_4.close();
            var4_4 = null;
            throw var40_56;
lbl259:
            // 1 sources

            catch (Exception var42_52) {
                // empty catch block
            }
            throw var40_56;
        }
    }

    private List _executeBooleanQuery(SearchExpression searchExpression) throws SearchException {
        if (searchExpression.getOperator() == 0) {
            return this._executeStringQuery(searchExpression.getData(), true, searchExpression.isCaseSensitive());
        }
        List list = Collections.EMPTY_LIST;
        SearchExpression searchExpression2 = searchExpression.getExpression1();
        if (searchExpression2 != null) {
            list = this._executeBooleanQuery(searchExpression2);
        }
        if (list.isEmpty() && searchExpression.getOperator() == 4) {
            return Collections.EMPTY_LIST;
        }
        if (searchExpression.getOperator() == 3) {
            return this._evaluateNOT(list);
        }
        List list2 = Collections.EMPTY_LIST;
        SearchExpression searchExpression3 = searchExpression.getExpression2();
        if (searchExpression3 != null) {
            list2 = this._executeBooleanQuery(searchExpression3);
        }
        if (list2.isEmpty() && searchExpression.getOperator() == 1 && searchExpression3 instanceof StringExpression) {
            StringExpression stringExpression = (StringExpression)searchExpression3;
            String[] stringArray = stringExpression.getData();
            if (stringArray != null && (stringArray = this._filter(stringArray)).length == 0) {
                return list;
            }
            return Collections.EMPTY_LIST;
        }
        if (list.isEmpty() && searchExpression.getOperator() == 1 && searchExpression2 instanceof StringExpression) {
            StringExpression stringExpression = (StringExpression)searchExpression2;
            String[] stringArray = stringExpression.getData();
            if (stringArray != null && (stringArray = this._filter(stringArray)).length == 0) {
                return list2;
            }
            return Collections.EMPTY_LIST;
        }
        if (searchExpression.getOperator() == 1) {
            ArrayList<ResultObject> arrayList = new ArrayList<ResultObject>();
            Iterator iterator = list.iterator();
            block0: while (iterator.hasNext()) {
                ResultObject resultObject = (ResultObject)iterator.next();
                Iterator iterator2 = list2.iterator();
                while (iterator2.hasNext()) {
                    ResultObject resultObject2 = (ResultObject)iterator2.next();
                    if (resultObject.fileno != resultObject2.fileno) continue;
                    arrayList.add(resultObject);
                    continue block0;
                }
            }
            return arrayList;
        }
        if (searchExpression.getOperator() == 2) {
            if (list.isEmpty()) {
                return list2;
            }
            if (list2.isEmpty()) {
                return list;
            }
            ArrayList<ResultObject> arrayList = new ArrayList<ResultObject>(list.size() + list2.size());
            arrayList.addAll(list);
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                ResultObject resultObject = (ResultObject)iterator.next();
                boolean bl = false;
                Iterator iterator3 = list.iterator();
                while (iterator3.hasNext()) {
                    ResultObject resultObject3 = (ResultObject)iterator3.next();
                    if (resultObject.fileno != resultObject3.fileno) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                arrayList.add(resultObject);
            }
            return arrayList;
        }
        if (searchExpression.getOperator() == 4) {
            if (list2.isEmpty()) {
                return list;
            }
            ArrayList<ResultObject> arrayList = new ArrayList<ResultObject>(list.size());
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ResultObject resultObject = (ResultObject)iterator.next();
                boolean bl = false;
                Iterator iterator4 = list2.iterator();
                while (iterator4.hasNext()) {
                    ResultObject resultObject4 = (ResultObject)iterator4.next();
                    if (resultObject.fileno != resultObject4.fileno) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                arrayList.add(resultObject);
            }
            return arrayList;
        }
        return Collections.EMPTY_LIST;
    }

    private String _bytesToString(byte[] byArray, int n, int n2) {
        try {
            return new String(byArray, n, n2, this._encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(byArray, n, n2);
        }
    }

    private IndexFileQueryHandler(View view, String string, URL uRL) {
        this._url = uRL;
        this._view = view;
        String string2 = this._view.getTitle();
        this._sourceIdentifier = string2 != null && string2.length() > 0 ? string2 : null;
    }

    private InputStream _openInputStream(URL uRL) throws IOException {
        InputStream inputStream = null;
        if (uRL.getProtocol().equals("file")) {
            try {
                inputStream = new FileInputStream(uRL.getFile());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (inputStream == null) {
            inputStream = uRL.openStream();
        }
        return inputStream;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void _parseHeader() throws SearchException {
        this._needToParseHeader = false;
        InputStream inputStream = null;
        try {
            try {
                inputStream = this._openInputStream(this._url);
                InputStreamWrapper inputStreamWrapper = new InputStreamWrapper(inputStream);
                String string = inputStreamWrapper.readLine();
                if (!string.startsWith(INDEX_VERSION)) {
                    throw new SearchException("Illegal Index File");
                }
                if (string.equals("OIN-INDEX-VERSION 1.0")) {
                    this._version = 10;
                } else if (string.equals("OIN-INDEX-VERSION 1.1")) {
                    this._version = 11;
                } else {
                    if (!string.equals("OIN-INDEX-VERSION 2.0")) throw new SearchException(string + "END");
                    this._version = 20;
                }
                string = inputStreamWrapper.readLine();
                if (this._version >= 20) {
                    this._encoding = string.substring(CHARACTER_SET.length() + 1);
                }
                if (!(string = inputStreamWrapper.readLine()).startsWith(PRODUCT_TITLE)) {
                    throw new SearchException("Corrupted Index File :" + string);
                }
                this._productTitle = string.substring(PRODUCT_TITLE.length() + 1);
                string = inputStreamWrapper.readLine();
                if (!string.startsWith(TITLES)) {
                    throw new SearchException("Corrupted Index File");
                }
                this._titlesAvailable = string.endsWith(TRUE);
                string = inputStreamWrapper.readLine();
                if (!string.startsWith(CASESENSITIVE)) {
                    throw new SearchException("Corrupted Index File");
                }
                this._fileCase = string.endsWith(TRUE);
                inputStreamWrapper.readLine();
                if (this._version > 10) {
                    string = inputStreamWrapper.readLine();
                    if (!string.startsWith(SCORES)) {
                        throw new SearchException("Corrupted Index File");
                    }
                    this._scoreAvailable = string.endsWith(TRUE);
                }
                if (!(string = inputStreamWrapper.readLine()).startsWith(ROOT_PATH)) {
                    throw new SearchException("Corrupted Index File");
                }
                this._rootPath = string.substring(ROOT_PATH.length() + 1);
                int n = inputStreamWrapper.readUb2();
                this._alphabet = new char[n];
                this._alphaOffsets = new long[n];
                byte[] byArray = new byte[16];
                int n2 = 0;
                while (true) {
                    if (n2 >= n) {
                        this._eowOffset = inputStreamWrapper.readUb4();
                        this._fsOffset = inputStreamWrapper.readUb4();
                        break;
                    }
                    if (this._version < 20) {
                        this._alphabet[n2] = (char)inputStreamWrapper.readUb1();
                    } else {
                        int n3 = inputStreamWrapper.readUb1();
                        if (n3 > 16) {
                            throw new SearchException("Oracle Help Indexer does not support encodings requiring more than 16 bytes to specify a character");
                        }
                        int n4 = 0;
                        while (true) {
                            if (n4 >= n3) {
                                String string2 = new String(byArray, 0, n3, this._encoding);
                                this._alphabet[n2] = string2.charAt(0);
                                break;
                            }
                            byArray[n4] = (byte)inputStreamWrapper.readUb1();
                            ++n4;
                        }
                    }
                    this._alphaOffsets[n2] = inputStreamWrapper.readUb4();
                    ++n2;
                }
            }
            catch (IOException iOException) {
                throw new SearchException("Error encountered parsing IDX file header:  " + this._url + iOException.getMessage(), iOException);
            }
            Object var12_11 = null;
            if (inputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                inputStream = null;
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        inputStream.close();
        return;
    }

    private int _getAlphabetIndex(char c) {
        int n = 0;
        while (n < this._alphabet.length) {
            if (this._alphabet[n] == c) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private void _readFileIndices(InputStreamWrapper inputStreamWrapper, ArrayList arrayList, boolean bl) throws IOException {
        int n;
        ResultObject resultObject;
        int n2 = 0;
        Iterator iterator = ((AbstractList)arrayList).iterator();
        while (iterator.hasNext()) {
            resultObject = (ResultObject)iterator.next();
            resultObject.useful = bl;
        }
        while ((n = inputStreamWrapper.readUb2()) != 65535) {
            if (this._scoreAvailable) {
                n2 = inputStreamWrapper.readUb1();
            }
            if ((resultObject = this._findFileIndex(arrayList, n)) == null) {
                if (!bl) continue;
                resultObject = new ResultObject();
                resultObject.view = this._view;
                resultObject.fileno = n;
                resultObject.useful = true;
                resultObject.label = null;
                resultObject.urlName = null;
                resultObject.setHitNumber(n2);
                arrayList.add(resultObject);
                continue;
            }
            resultObject.useful = true;
            resultObject.setHitNumber(resultObject.getHitNumber() + n2);
        }
        this._filterResults(arrayList);
    }

    private void _readFileNames(InputStreamWrapper inputStreamWrapper, ArrayList arrayList, byte[] byArray) throws IOException {
        int n = inputStreamWrapper.readUb2();
        int n2 = 0;
        while (n2 < n) {
            int n3 = inputStreamWrapper.readUb1();
            inputStreamWrapper.read(byArray, 0, n3);
            ResultObject resultObject = this._findFileIndex(arrayList, n2);
            if (resultObject != null) {
                resultObject.view = this._view;
                resultObject.urlName = this._version < 20 ? new String(byArray, 0, n3) : this._bytesToString(byArray, 0, n3);
            }
            if (this._titlesAvailable) {
                n3 = inputStreamWrapper.readUb1();
                inputStreamWrapper.read(byArray, 0, n3);
                if (resultObject != null) {
                    resultObject.label = this._version < 20 ? new String(byArray, 0, n3) : this._bytesToString(byArray, 0, n3);
                }
            }
            if (n2 % 20 == 0) {
                this._checkStopSearch();
            }
            ++n2;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List _evaluateNOT(List var1_1) throws SearchException {
        block18: {
            block17: {
                var2_2 = Collections.EMPTY_LIST;
                var3_3 = new byte[256];
                var4_4 = null;
                try {
                    try {
                        var4_4 = this._openInputStream(this._url);
                        var5_5 = new InputStreamWrapper(var4_4);
                        var5_5.skipToOffset(this._fsOffset);
                        var6_7 = var5_5.readUb2();
                        var7_8 = var1_1.size();
                        if (var7_8 >= var6_7) {
                            var8_9 = Collections.EMPTY_LIST;
                            var14_11 = null;
                            break block17;
                        }
                        var2_2 = new ArrayList<ResultObject>(var6_7 - var7_8);
                        var8_10 = 0;
                        while (var8_10 < var6_7) {
                            var9_17 = false;
                            var10_18 = 0;
                            while (var10_18 < var7_8) {
                                var11_20 = (ResultObject)var1_1.get(var10_18);
                                if (var11_20.fileno == var8_10) {
                                    var9_17 = true;
                                    break;
                                }
                                ++var10_18;
                            }
                            var11_19 = var5_5.readUb1();
                            var5_5.read(var3_3, 0, var11_19);
                            var12_21 = null;
                            if (!var9_17) {
                                var12_21 = new ResultObject();
                                var12_21.fileno = var8_10;
                                var12_21.setHitNumber(0);
                                var12_21.view = this._view;
                                var12_21.urlName = this._version < 20 ? new String(var3_3, 0, var11_19) : this._bytesToString(var3_3, 0, var11_19);
                            }
                            if (this._titlesAvailable) {
                                var11_19 = var5_5.readUb1();
                                var5_5.read(var3_3, 0, var11_19);
                                if (var12_21 != null) {
                                    var12_21.label = this._version < 20 ? new String(var3_3, 0, var11_19) : this._bytesToString(var3_3, 0, var11_19);
                                }
                            }
                            if (var12_21 != null) {
                                var2_2.add(var12_21);
                            }
                            ++var8_10;
                        }
                        break block18;
                    }
                    catch (Exception var5_6) {
                        throw new SearchException("Error encountered executing NOT boolean search: " + var5_6.getMessage(), var5_6);
                    }
                }
                catch (Throwable var13_22) {
                    var14_13 = null;
                    try {
                        var4_4.close();
                        var4_4 = null;
                        throw var13_22;
                    }
                    catch (Exception var15_16) {
                        // empty catch block
                    }
                    throw var13_22;
                }
            }
            ** try [egrp 2[TRYBLOCK] [2 : 386->397)] { 
lbl62:
            // 1 sources

            var4_4.close();
            return var8_9;
lbl64:
            // 1 sources

            catch (Exception var15_14) {
                // empty catch block
            }
            return var8_9;
        }
        var14_12 = null;
        try {}
        catch (Exception var15_15) {}
        var4_4.close();
        var4_4 = null;
        return var2_2;
        return var2_2;
    }

    private void _filterResults(List list) {
        int n = list.size() - 1;
        while (n >= 0) {
            ResultObject resultObject = (ResultObject)list.get(n);
            if (!resultObject.useful) {
                list.remove(n);
            }
            --n;
        }
    }

    private ResultObject _findFileIndex(List list, int n) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ResultObject resultObject = (ResultObject)iterator.next();
            if (resultObject.fileno != n) continue;
            return resultObject;
        }
        return null;
    }

    private void _bubbleSort(String[] stringArray) {
        if (stringArray.length == 1) {
            return;
        }
        if (stringArray.length == 2) {
            if (stringArray[0].compareTo(stringArray[1]) > 0) {
                String string = stringArray[1];
                stringArray[1] = stringArray[0];
                stringArray[0] = string;
            }
            return;
        }
        int n = stringArray.length - 1;
        while (n >= 1) {
            int n2 = 1;
            while (n2 <= n) {
                if (stringArray[n2 - 1].compareTo(stringArray[n2]) > 0) {
                    String string = stringArray[n2 - 1];
                    stringArray[n2 - 1] = stringArray[n2];
                    stringArray[n2] = string;
                }
                ++n2;
            }
            --n;
        }
    }

    private String[] _filter(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].length() > 1) {
                arrayList.add(stringArray[n]);
            }
            ++n;
        }
        String[] stringArray2 = new String[arrayList.size()];
        arrayList.toArray(stringArray2);
        return stringArray2;
    }

    private static void _quickSort(List list, int n, int n2) {
        if (n2 > n) {
            int n3 = ((ResultObject)list.get(n2)).getHitNumber();
            int n4 = n - 1;
            int n5 = n2;
            while (true) {
                if (((ResultObject)list.get(++n4)).getHitNumber() > n3) {
                    continue;
                }
                while (((ResultObject)list.get(--n5)).getHitNumber() < n3 && n5 > 0) {
                }
                if (n4 >= n5) break;
                IndexFileQueryHandler._swapObject(list, n4, n5);
            }
            IndexFileQueryHandler._swapObject(list, n4, n2);
            IndexFileQueryHandler._quickSort(list, n, n4 - 1);
            IndexFileQueryHandler._quickSort(list, n4 + 1, n2);
        }
    }

    private static void _swapObject(List list, int n, int n2) {
        ResultObject resultObject = (ResultObject)list.get(n);
        list.set(n, list.get(n2));
        list.set(n2, resultObject);
    }

    private class SearchInterruptedError
    extends Error {
        public SearchInterruptedError(String string) {
            super(string);
        }
    }

    private class InputStreamWrapper {
        private InputStream _inStream;
        private long _pos;

        public InputStreamWrapper(InputStream inputStream) {
            this._inStream = inputStream;
            this._pos = 0L;
        }

        public long readUb4() throws IOException {
            long l = 0L;
            l = (long)this.readUb1() << 24 | (long)this.readUb1() << 16 | (long)this.readUb1() << 8 | (long)this.readUb1();
            return l;
        }

        public int readUb2() throws IOException {
            int n = this.readUb1() << 8 | this.readUb1();
            return n;
        }

        public int readUb1() throws IOException {
            int n = this._inStream.read();
            if (n < 0) {
                n += 256;
            }
            ++this._pos;
            return n;
        }

        public void skipToOffset(long l) throws IOException {
            long l2 = l - this._pos;
            while (l2 > 0L) {
                long l3 = this._inStream.skip(l2);
                if (l3 != -1L) {
                    l2 -= l3;
                    this._pos += l3;
                    continue;
                }
                throw new IOException("IndexFileQueryHandler attempting to skip past end of file: " + IndexFileQueryHandler.this._url);
            }
        }

        public String readLine() throws IOException {
            char c;
            int n = 40;
            StringBuffer stringBuffer = new StringBuffer(n);
            while ((c = (char)this._inStream.read()) != '\n') {
                if (stringBuffer.length() == n) {
                    stringBuffer.setLength(n += 40);
                }
                stringBuffer.append(c);
                ++this._pos;
            }
            ++this._pos;
            return stringBuffer.toString();
        }

        public void read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = 0;
            while (n3 != n2) {
                int n4 = this._inStream.read(byArray, n + n3, n2 - n3);
                if (n4 == -1) {
                    throw new IOException();
                }
                n3 += n4;
                this._pos += (long)n4;
            }
        }

        public long getPosition() {
            return this._pos;
        }
    }

    private class ResultObject
    implements QueryResult {
        public int fileno = -1;
        public String urlName = null;
        public String label = null;
        public boolean useful = false;
        public View view = null;
        private int _hitNumber = 0;

        private ResultObject() {
        }

        public Topic getResultTopic() {
            SimpleURLTarget simpleURLTarget = new SimpleURLTarget(this.view, this.urlName);
            SimpleTopic simpleTopic = new SimpleTopic(this.label, simpleURLTarget);
            return simpleTopic;
        }

        public int getResultScore() {
            return this._hitNumber;
        }

        public String getResultSource() {
            return IndexFileQueryHandler.this._sourceIdentifier;
        }

        public int getHitNumber() {
            return this._hitNumber;
        }

        public void setHitNumber(int n) {
            this._hitNumber = n;
        }
    }
}

