/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.common.navigator.tocNavigator;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import oracle.help.common.SimpleTopic;
import oracle.help.common.Target;
import oracle.help.common.Topic;
import oracle.help.common.TopicTree;
import oracle.help.common.TopicTreeNode;
import oracle.help.common.View;
import oracle.help.common.navigator.tocNavigator.TOCUtils;
import oracle.help.common.util.IndexedListListener;

public class MergingTopicTreeNode
extends TopicTreeNode {
    private ArrayList _baseNodes;
    private ArrayList _tocViews;
    private boolean _hasMergedChildren = false;

    public MergingTopicTreeNode() {
    }

    public MergingTopicTreeNode(TopicTreeNode topicTreeNode) {
        this._addBaseNode(topicTreeNode);
    }

    public MergingTopicTreeNode(View[] viewArray) {
        if (viewArray != null) {
            int n = 0;
            while (n < viewArray.length) {
                this.addView(viewArray[n]);
                ++n;
            }
        }
    }

    public synchronized ArrayList getChildren() {
        if (!this._hasMergedChildren) {
            int n;
            if (this._baseNodes != null) {
                n = 0;
                while (n < this._baseNodes.size()) {
                    this._reallyAddBaseNode((TopicTreeNode)this._baseNodes.get(n));
                    ++n;
                }
            }
            if (this._tocViews != null) {
                n = 0;
                while (n < this._tocViews.size()) {
                    this._reallyAddView((View)this._tocViews.get(n));
                    ++n;
                }
            }
            this._hasMergedChildren = true;
        }
        return this._getRealChildren();
    }

    public View getView() {
        if (this._getBaseNode() != null) {
            return this._getBaseNode().getView();
        }
        return null;
    }

    public TopicTreeNode getParent() {
        if (this._getBaseNode() != null) {
            return this._getBaseNode().getParent();
        }
        return null;
    }

    public void setParent(TopicTreeNode topicTreeNode) {
        if (this._baseNodes != null) {
            int n = 0;
            while (n < this._baseNodes.size()) {
                TopicTreeNode topicTreeNode2 = (TopicTreeNode)this._baseNodes.get(n);
                topicTreeNode2.setParent(topicTreeNode);
                ++n;
            }
        }
    }

    public Topic getTopic() {
        if (this._baseNodes != null) {
            int n = 0;
            while (n < this._baseNodes.size()) {
                TopicTreeNode topicTreeNode = (TopicTreeNode)this._baseNodes.get(n);
                Topic topic = topicTreeNode.getTopic();
                if (topic != null && topic.hasTarget()) {
                    return topic;
                }
                ++n;
            }
        }
        if (this._getBaseNode() != null) {
            return this._getBaseNode().getTopic();
        }
        return null;
    }

    public boolean isTraversable() {
        boolean bl = true;
        if (this._baseNodes != null) {
            int n = 0;
            while (n < this._baseNodes.size()) {
                bl = bl && ((TopicTreeNode)this._baseNodes.get(n)).isTraversable();
                ++n;
            }
        }
        return bl;
    }

    public boolean allowsChildMerging() {
        boolean bl = true;
        if (this._baseNodes != null) {
            int n = 0;
            while (n < this._baseNodes.size()) {
                bl = bl && ((TopicTreeNode)this._baseNodes.get(n)).allowsChildMerging();
                ++n;
            }
        }
        return bl;
    }

    public Object getClientData() {
        if (this._getBaseNode() != null) {
            return this._getBaseNode().getClientData();
        }
        return null;
    }

    public void setClientData(Object object) {
        if (this._baseNodes != null) {
            int n = 0;
            while (n < this._baseNodes.size()) {
                ((TopicTreeNode)this._baseNodes.get(n)).setClientData(object);
                ++n;
            }
        }
    }

    public void addView(View view) {
        if (this._tocViews == null) {
            this._tocViews = new ArrayList();
        }
        if (!this._tocViews.contains(view)) {
            this._tocViews.add(view);
            if (this._hasMergedChildren) {
                this._reallyAddView(view);
            }
        }
    }

    public void removeView(View view) {
        if (this._hasMergedChildren) {
            this._reallyRemoveView(view);
        }
        if (this._tocViews != null && this._tocViews.contains(view)) {
            ((AbstractCollection)this._tocViews).remove(view);
        }
        if (this._baseNodes != null) {
            int n = this._baseNodes.size() - 1;
            while (n >= 0) {
                TopicTreeNode topicTreeNode = (TopicTreeNode)this._baseNodes.get(n);
                if (topicTreeNode.getView() == view) {
                    this._baseNodes.remove(n);
                }
                --n;
            }
        }
    }

    public List getContributingViews() {
        if (this._tocViews != null) {
            return this._tocViews;
        }
        if (this._baseNodes != null) {
            ArrayList<View> arrayList = new ArrayList<View>();
            int n = 0;
            while (n < this._baseNodes.size()) {
                TopicTreeNode topicTreeNode = (TopicTreeNode)this._baseNodes.get(n);
                View view = topicTreeNode.getView();
                if (view != null) {
                    arrayList.add(view);
                }
                ++n;
            }
            return arrayList;
        }
        return Collections.EMPTY_LIST;
    }

    private void _fireModelEvent(int n, int n2) {
        Enumeration enumeration;
        if (this.getListenerManager() != null && this._hasMergedChildren && (enumeration = this.getListenerManager().getListeners()) != null) {
            while (enumeration.hasMoreElements()) {
                IndexedListListener indexedListListener = (IndexedListListener)enumeration.nextElement();
                if (n2 == 0) {
                    indexedListListener.itemAdded(n);
                    continue;
                }
                if (n2 != 1) continue;
                indexedListListener.itemRemoved(n);
            }
        }
    }

    private void _fireCurrentEvent() {
        Enumeration enumeration = this.getListenerManager().getListeners();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                IndexedListListener indexedListListener = (IndexedListListener)enumeration.nextElement();
                indexedListListener.fireCurrentEvent();
            }
        }
    }

    private void _addBaseNode(TopicTreeNode topicTreeNode) {
        if (this._baseNodes == null) {
            this._baseNodes = new ArrayList();
        }
        if (!this._baseNodes.contains(topicTreeNode)) {
            this._baseNodes.add(topicTreeNode);
            if (this._hasMergedChildren) {
                this._reallyAddBaseNode(topicTreeNode);
            }
        }
    }

    private void _reallyAddBaseNode(TopicTreeNode topicTreeNode) {
        ArrayList arrayList;
        if (topicTreeNode != null && (arrayList = topicTreeNode.getChildren()) != null) {
            int n = 0;
            while (n < arrayList.size()) {
                this._addChildNode((TopicTreeNode)arrayList.get(n));
                ++n;
            }
        }
    }

    private void _reallyAddView(View view) {
        ArrayList arrayList = this._createTopicTreeNodes(view);
        int n = 0;
        while (n < arrayList.size()) {
            this._addChildNode((TopicTreeNode)arrayList.get(n));
            ++n;
        }
        this._fireCurrentEvent();
    }

    private void _reallyRemoveView(View view) {
        if (this.getContributingViews().contains(view)) {
            int n = this._getRealChildren().size() - 1;
            while (n >= 0) {
                MergingTopicTreeNode mergingTopicTreeNode = (MergingTopicTreeNode)this._getRealChildren().get(n);
                if (mergingTopicTreeNode.getContributingViews().contains(view)) {
                    mergingTopicTreeNode.removeView(view);
                    this._getRealChildren().remove(n);
                    this._fireModelEvent(n, 1);
                    if (mergingTopicTreeNode.getContributingViews().size() > 0) {
                        this._getRealChildren().add(n, mergingTopicTreeNode);
                        this._fireModelEvent(n, 0);
                    }
                }
                --n;
            }
            this._fireCurrentEvent();
        }
    }

    private void _addChildNode(TopicTreeNode topicTreeNode) {
        if (this.allowsChildMerging() && !this._tryToMergeNode(topicTreeNode)) {
            this._getRealChildren().add(new MergingTopicTreeNode(topicTreeNode));
            this._fireModelEvent(this._getRealChildren().size() - 1, 0);
        }
    }

    private ArrayList _createTopicTreeNodes(View view) {
        ArrayList<TopicTreeNode> arrayList = new ArrayList<TopicTreeNode>();
        TopicTree topicTree = TOCUtils.getTopicTree(view);
        if (topicTree != null) {
            Object object;
            TopicTreeNode topicTreeNode = null;
            if (view.getTitle() != null) {
                object = new SimpleTopic(view.getTitle(), null, view.getBook(), view.getTitleImage(), null);
                topicTreeNode = new TopicTreeNode(view, (Topic)object);
                arrayList.add(topicTreeNode);
            }
            if ((object = topicTree.getRoot().getChildren()) != null) {
                int n = 0;
                while (n < ((ArrayList)object).size()) {
                    TopicTreeNode topicTreeNode2 = (TopicTreeNode)((ArrayList)object).get(n);
                    if (topicTreeNode != null) {
                        topicTreeNode.addChild(topicTreeNode2);
                    } else {
                        arrayList.add(topicTreeNode2);
                    }
                    ++n;
                }
            }
        }
        return arrayList;
    }

    private boolean _tryToMergeNode(TopicTreeNode topicTreeNode) {
        Topic topic = topicTreeNode.getTopic();
        if (topic != null) {
            int n = 0;
            while (n < this._getRealChildren().size()) {
                MergingTopicTreeNode mergingTopicTreeNode = (MergingTopicTreeNode)this._getRealChildren().get(n);
                Topic topic2 = mergingTopicTreeNode.getTopic();
                if (topic2 != null && this._sameLabel(topic2, topic) && (!topic.hasTarget() || !topic2.hasTarget() || this._sameTarget(topic2, topic))) {
                    mergingTopicTreeNode._addBaseNode(topicTreeNode);
                    this._getRealChildren().remove(n);
                    this._fireModelEvent(n, 1);
                    this._getRealChildren().add(n, mergingTopicTreeNode);
                    this._fireModelEvent(n, 0);
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    private boolean _sameTarget(Topic topic, Topic topic2) {
        Target target = topic.getTarget();
        URL uRL = null;
        if (target != null) {
            try {
                uRL = target.getURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        Target target2 = topic2.getTarget();
        URL uRL2 = null;
        if (target2 != null) {
            try {
                uRL2 = target2.getURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (uRL != null && uRL2 != null) {
            return uRL.sameFile(uRL2);
        }
        return uRL == uRL2;
    }

    private boolean _sameLabel(Topic topic, Topic topic2) {
        return topic.getLabel().equals(topic2.getLabel());
    }

    private ArrayList _getRealChildren() {
        return super.getChildren();
    }

    private TopicTreeNode _getBaseNode() {
        if (this._baseNodes != null && this._baseNodes.size() > 0) {
            return (TopicTreeNode)this._baseNodes.get(0);
        }
        return null;
    }
}

