/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.common;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;

public class WindowCoordinate {
    private int _value;
    private boolean _isNegative;
    private boolean _isPercent;
    private boolean _horizontal;

    public WindowCoordinate(int n, boolean bl, boolean bl2, boolean bl3) {
        this._value = n;
        this._isNegative = bl;
        this._isPercent = bl2;
        this._horizontal = bl3;
    }

    public int getValue(int n, Component component) {
        int n2;
        Dimension dimension;
        Toolkit toolkit;
        int n3 = this._value;
        if (this._isPercent) {
            toolkit = component.getToolkit();
            dimension = toolkit.getScreenSize();
            n2 = this._horizontal ? dimension.width : dimension.height;
            double d = (double)n3 / 100.0;
            n3 = (int)((double)n2 * d);
        }
        if (this._isNegative) {
            toolkit = Toolkit.getDefaultToolkit();
            dimension = toolkit.getScreenSize();
            n2 = this._horizontal ? dimension.width : dimension.height;
            n3 = n2 - n3 - n;
        }
        return n3;
    }

    public int getOriginalValue() {
        return this._value;
    }

    public boolean isNegative() {
        return this._isNegative;
    }

    public boolean isPercent() {
        return this._isPercent;
    }

    public String getTextValue() {
        String string = this._isNegative ? "-" : "";
        string = string + this._value;
        if (this._isPercent) {
            string = string + "%";
        }
        return string;
    }
}

