/*
 * Decompiled with CFR 0.152.
 */
package oracle.charts.piechart;

import java.awt.Color;
import oracle.charts.internal.Errorfcn;
import oracle.charts.internal.MsgUtil;
import oracle.charts.piechart.PieChart;
import oracle.charts.types.ChartException;

public class PieChartInteractive
extends PieChart {
    int LastSliceIndex = -1;

    public int getSliceIndex(int x, int y) throws ChartException {
        String fcn = "getSliceIndex()";
        if (this.SliceDesc == null) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-001"));
        }
        if (x < this.XOffset || x > this.XOffset + this.PieDiameter) {
            return -1;
        }
        if (y < this.YOffset || y > this.YOffset + this.PieDiameter) {
            return -1;
        }
        if (this.Arc == null) {
            return -1;
        }
        int i = 0;
        while (i < this.SliceDesc.length) {
            if (this.Arc.length < i) break;
            if (this.Arc[i].contains(x, y)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean getSliceEntered(int x, int y) throws ChartException {
        int currentSliceIndex;
        String fcn = "getSliceEntered()";
        if (this.SliceDesc == null) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-001"));
        }
        if ((currentSliceIndex = this.getSliceIndex(x, y)) == -1) {
            this.LastSliceIndex = -1;
            return false;
        }
        if (currentSliceIndex != this.LastSliceIndex) {
            this.LastSliceIndex = currentSliceIndex;
            return true;
        }
        this.LastSliceIndex = currentSliceIndex;
        return false;
    }

    public boolean getSliceExited(int x, int y) throws ChartException {
        String fcn = "getSliceExited()";
        if (this.SliceDesc == null) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-001"));
        }
        int currentSliceIndex = this.getSliceIndex(x, y);
        if (this.LastSliceIndex != -1 && currentSliceIndex == -1) {
            this.LastSliceIndex = currentSliceIndex;
            return true;
        }
        return this.LastSliceIndex != -1 && currentSliceIndex != this.LastSliceIndex;
    }

    public void setSliceUnHighlight() throws ChartException {
        this.HilightIndex = -1;
    }

    public void setSliceLabelUnHighlight() throws ChartException {
        this.HilightLabelIndex = -1;
    }

    public void setSliceHighlight(int sliceIndex, Color c) throws ChartException {
        String fcn = "setSliceHighlight()";
        if (sliceIndex < -1) {
            throw new ChartException(MsgUtil.getMsg("CHT-004"));
        }
        this.HilightColor = c;
        this.HilightIndex = sliceIndex;
    }

    public void setSliceLabelHighlight(int sliceIndex, Color c) throws ChartException {
        String fcn = "setSliceLabelHighlight()";
        if (sliceIndex < -1) {
            throw new ChartException(MsgUtil.getMsg("CHT-004"));
        }
        this.HilightLabelColor = c;
        this.HilightLabelIndex = sliceIndex;
    }
}

