/*
 * Decompiled with CFR 0.152.
 */
package oracle.charts.legendchart;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.Locale;
import oracle.charts.Chart;
import oracle.charts.internal.Errorfcn;
import oracle.charts.internal.MsgUtil;
import oracle.charts.internal.Precision;
import oracle.charts.legendchart.LegendChartElementDesc;
import oracle.charts.svg.SVGXLinkArrayDesc;
import oracle.charts.types.ChartException;
import oracle.charts.types.ImageMapAreaDesc;

public class LegendChart
extends Chart {
    private final int ORDER_NORMAL = 0;
    private final int ORDER_REVERSED = 1;
    private int LegendElementOrder = 0;
    BufferedImage BI = null;
    int displayHeight = super.getHeight();
    int displayWidth = super.getWidth();
    private boolean fontMetricsGot = false;
    private Font font = new Font("sansserif", 1, 12);
    private FontMetrics fontmet;
    boolean drawBackgroundRect = true;
    SVGXLinkArrayDesc SVGXLinkArrayD = null;
    LegendChartElementDesc[] Elements;
    boolean genImageMapCoords = false;
    int[][] ImageMapCoords;
    int ImageMapShape = 1;
    boolean DrawBufferCalled = false;
    RenderingHints RHOriginal = null;
    boolean SizeChanged = false;

    public LegendChart() {
        this.initLegendChart();
    }

    protected void initLegendChart() {
        try {
            this.L2.getLegendDesc().setLegendAlignment(-1);
            this.L2.resetLegendAlignment();
        }
        catch (ChartException e) {
            // empty catch block
        }
        this.L2.setPieChartType(true);
        this.L2.setMaximumSize(this.getWidth(), this.getHeight());
        this.L2.setBorders(this.getBorderLeft(), this.getBorderRight(), this.getBorderTop(), this.getBorderBottom());
    }

    public void setChartLocale(Locale Locale2) {
        this.ChartLocale = Locale2;
    }

    public Locale getChartLocale() {
        return this.ChartLocale;
    }

    public void setFont(Font f) {
        this.font = f;
        this.fontMetricsGot = false;
    }

    private void getFMetrics(Graphics2D g2) {
        if (this.fontMetricsGot) {
            return;
        }
        this.fontmet = g2.getFontMetrics(this.font);
        this.fontMetricsGot = true;
    }

    public void setBackgroundRectOff() {
        this.drawBackgroundRect = false;
    }

    public void setSVGAttributes(SVGXLinkArrayDesc desc) throws ChartException {
        String fcn = "setSVGAttributes()";
        if (desc == null) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-240"));
        } else {
            this.SVGXLinkArrayD = desc;
        }
    }

    public void setLegendElements(LegendChartElementDesc[] element) throws ChartException {
        this.Elements = element;
        if (this.genImageMapCoords) {
            this.ImageMapCoords = new int[this.Elements.length][0];
        }
    }

    public void drawBuffer(Graphics2D g2) throws ChartException {
        String fcn = "drawBuffer()";
        this.DrawBufferCalled = true;
        if (this.svgChartGraphics.getEnableSVG()) {
            this.svgChartGraphics.setGraphicsBuffer(g2);
            g2 = this.svgChartGraphics;
        }
        if (this.Elements == null) {
            Errorfcn.chartError("drawBuffer()", MsgUtil.getMsg("CHT-000"));
        }
        if (this.Elements.length <= 0) {
            return;
        }
        super.getTitle().setFontMetrics(g2);
        super.getSubtitle().setFontMetrics(g2);
        super.getFootnote().setFontMetrics(g2);
        int tempBordertop = 0;
        if (super.getTitle().getText() != "") {
            tempBordertop += super.getTitle().getHeight();
            super.getTitle().setLocation(0, 0);
            super.getTitle().setWidth(this.displayWidth);
        }
        if (super.getSubtitle().getText() != "") {
            tempBordertop += super.getSubtitle().getHeight();
            if (super.getTitle().getText() != "") {
                super.getSubtitle().setLocation(0, super.getTitle().getHeight());
            } else {
                super.getSubtitle().setLocation(0, 0);
            }
            super.getSubtitle().setWidth(this.displayWidth);
        }
        if (tempBordertop != 0) {
            this.setBorderTopInternal(tempBordertop);
        }
        if (super.getFootnote().getText() != "") {
            int footnoteHeight = super.getFootnote().getHeight();
            int footnoteYOffset = (int)Math.round(1.5 * (double)footnoteHeight);
            super.getFootnote().setLocation(0, this.displayHeight - footnoteYOffset);
            super.getFootnote().setWidth(this.displayWidth);
            int padding = 10;
            super.setBorderBottomInternal(footnoteHeight + padding);
        }
        g2.setFont(this.font);
        this.getFMetrics(g2);
        this.addLegend();
        this.drawBackground(g2);
        this.L2.drawLegendBuffer(g2, this.svgChartGraphics, this.genImageMapCoords);
        if (this.isSetRenderingHintsChart()) {
            g2.setRenderingHints(super.getRenderingHintsChart());
        }
    }

    private void setSliceRenderingHints(Graphics2D g2) {
        if (this.isSetRenderingHintsChart()) {
            g2.setRenderingHints(super.getRenderingHintsChart());
        } else {
            this.RHOriginal = g2.getRenderingHints();
            RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            hints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            hints.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
            g2.setRenderingHints(hints);
        }
    }

    public void setEnableImageMapArea() throws ChartException {
        this.genImageMapCoords = true;
        if (this.Elements != null) {
            this.ImageMapCoords = new int[this.Elements.length][0];
        }
    }

    public ImageMapAreaDesc getImageMapAreaDesc() {
        ImageMapAreaDesc imap = new ImageMapAreaDesc();
        imap.setCoords(this.ImageMapCoords);
        imap.setShape(this.ImageMapShape);
        return imap;
    }

    public void setBounds(int x, int y, int w, int h) {
        if (w > 0 || h > 0) {
            this.setSize(w, h);
        }
        super.setBounds(x, y, w, h);
    }

    public void setBounds(Rectangle rect) {
        if (rect.width > 0 || rect.height > 0) {
            this.setSize(rect.width, rect.height);
        }
        super.setBounds(rect);
    }

    public void setSize(Dimension d) {
        if (d.width > 0 || d.height > 0) {
            this.setSize(d.height, d.width);
        }
    }

    public void setSize(int width, int height) {
        if (width <= 0 && height <= 0) {
            return;
        }
        this.SizeChanged = true;
        if (width == 0) {
            this.setHeightInternal(height);
        } else if (height == 0) {
            this.setWidthInternal(width);
        } else {
            super.setSizeInternal(width, height);
        }
        this.displayHeight = super.getHeight();
        this.displayWidth = super.getWidth();
    }

    private void drawBackground(Graphics2D g2) {
        if (this.drawBackgroundRect) {
            if (this.svgChartGraphics.getEnableSVG()) {
                this.svgChartGraphics.startGroup("cb_background");
            }
            g2.setColor(super.getBackground());
            g2.fillRect(0, 0, this.displayWidth, this.displayHeight);
            g2.setColor(this.getEdgeColor());
            g2.drawRect(0, 0, this.displayWidth - 1, this.displayHeight - 1);
            if (this.svgChartGraphics.getEnableSVG()) {
                this.svgChartGraphics.endGroup();
            }
        }
        if (this.svgChartGraphics.getEnableSVG()) {
            this.svgChartGraphics.startGroup("cb_titles");
        }
        super.getTitle().drawBuffer(g2);
        super.getSubtitle().drawBuffer(g2);
        super.getFootnote().drawBuffer(g2);
        if (this.svgChartGraphics.getEnableSVG()) {
            this.svgChartGraphics.endGroup();
        }
    }

    private void addLegend() {
        this.L2.clearLegend();
        this.L2.resetLegendReduce();
        int i = 0;
        while (i < this.Elements.length) {
            int j = this.LegendElementOrder == 1 ? this.Elements.length - i - 1 : i;
            String label = this.Elements[j].getLabel();
            String href = null;
            if (this.SVGXLinkArrayD != null && this.SVGXLinkArrayD.getHRef().length > i) {
                href = this.SVGXLinkArrayD.getHRef()[i];
            }
            this.L2.setAddLegendItem(label, this.Elements[j].getLabelColor());
            this.L2.setUpdateLegendItemXLink(label, href);
            ++i;
        }
        this.L2.setLegendColumns(1);
        this.L2.getLegendHeight();
        this.L2.getLegendWidth();
        this.L2.setPieChartType(true);
        int numCols = this.countLegendColumns(this.getWidth());
        this.L2.setLegendColumns(numCols);
        int legendWidth = this.L2.getLegendWidth();
        int legendHeight = this.L2.getLegendHeight();
        int xWhiteSpace = this.getWidth() - super.getBorderRight() - legendWidth;
        boolean yWhiteSpace = false;
        int xOffsetLegend = super.getBorderLeft() + xWhiteSpace / 2;
        int yOffsetLegend = super.getBorderTop();
        this.L2.setLegendLocation(xOffsetLegend, yOffsetLegend);
    }

    protected int countLegendColumns(int width) {
        int maxCols;
        int legWidth = this.L2.getLegendColumnWidth();
        int numItems = this.L2.getLegendNumItems();
        if (numItems < (maxCols = width / legWidth)) {
            return numItems;
        }
        int numRows = Precision.IntCeil(numItems, maxCols);
        int numCols = Precision.IntCeil(numItems, numRows);
        return numCols;
    }

    public void paint(Graphics g) {
        if (this.BI == null || this.SizeChanged) {
            this.SizeChanged = false;
            this.displayWidth = this.getWidth();
            this.displayHeight = this.getHeight();
            this.BI = new BufferedImage(this.displayWidth, this.displayHeight, 1);
        }
        Graphics2D g2 = this.BI.createGraphics();
        try {
            this.drawBuffer(g2);
        }
        catch (ChartException e) {
            System.out.println(e.getMessage());
        }
        g.drawImage(this.BI, 0, 0, this);
    }
}

