/*
 * Decompiled with CFR 0.152.
 */
package oracle.charts.legend;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.TextLayout;
import java.text.AttributedString;
import java.util.Vector;
import oracle.charts.internal.Button;
import oracle.charts.internal.Errorfcn;
import oracle.charts.internal.LineMarker;
import oracle.charts.internal.MsgUtil;
import oracle.charts.types.ButtonDesc;
import oracle.charts.types.ChartException;
import oracle.charts.types.LabelDesc;
import oracle.charts.types.LegendDesc;
import oracle.viz.util.svg.SVGChartGraphics;
import oracle.viz.util.svg.SVGGraphics;

public class Legend2
extends Component {
    int yBaseline = 0;
    boolean drawLegendInternal = true;
    int maxLabelWidth = 0;
    int labelHeight = 0;
    LineMarker LM = new LineMarker();
    BasicStroke DefaultStroke = new BasicStroke(1.0f, 0, 2);
    int maxHeight = -1;
    private LegendDesc LDesc = new LegendDesc();
    int Width = 0;
    int Height = 0;
    int BorderRight = 0;
    int BorderLeft = 0;
    int BorderTop = 0;
    int BorderBottom = 0;
    boolean UseReducedStrings = false;
    boolean isPieChart = false;
    Vector items = new Vector();
    Vector drawableItems = new Vector();
    private boolean legendOrderReverse = false;
    private boolean fontMetricsGot = false;
    private FontMetrics fontmet;
    int originX = 0;
    int originY = 0;
    int x_length = 15;
    int columns = 1;

    public void setYBaseline(int yBaseline) {
        this.yBaseline = yBaseline;
    }

    public void setLegendDesc(LegendDesc lDesc) {
        this.LDesc = lDesc;
    }

    public LegendDesc getLegendDesc() {
        return this.LDesc;
    }

    public void setMaximumSize(int width, int height) {
        this.Width = width;
        this.Height = height;
    }

    public void setBorders(int borderLeft, int borderRight, int borderTop, int borderBottom) {
        this.BorderLeft = borderLeft;
        this.BorderRight = borderRight;
        this.BorderTop = borderTop;
        this.BorderBottom = borderBottom;
    }

    public void setPieChartType(boolean isPieChart) {
        this.isPieChart = isPieChart;
    }

    private void computeLabelHeight(Graphics2D g2) {
        this.getLegendLabelHeight(g2);
    }

    public int getLegendLabelHeight(Graphics2D g2) {
        if (this.LDesc.getLegendTextAttributes() == null) {
            FontMetrics fontmet = this.getFontMetrics(this.LDesc.getLegendFont());
            this.labelHeight = fontmet.getHeight();
        } else {
            AttributedString attrStr = new AttributedString("Temp", this.LDesc.getLegendTextAttributes());
            TextLayout layout = new TextLayout(attrStr.getIterator(), g2.getFontRenderContext());
            this.labelHeight = Math.round(layout.getAscent() + layout.getDescent());
        }
        return this.labelHeight;
    }

    public void setLegendOrderReverse() {
        this.legendOrderReverse = true;
    }

    public void setFontMetrics(Graphics2D g2) {
        if (this.fontMetricsGot) {
            return;
        }
        this.fontmet = g2.getFontMetrics(this.LDesc.getLegendFont());
        this.fontMetricsGot = true;
    }

    protected FontMetrics getFontMetrics() {
        return this.fontmet;
    }

    public void clearLegend() {
        this.UseReducedStrings = false;
        this.items.clear();
        this.drawableItems.clear();
    }

    public void setLegendDisableInternal() {
        this.drawLegendInternal = false;
    }

    public boolean getLegendDisableInternal() {
        return !this.drawLegendInternal;
    }

    public void setLegendEnableInternal() {
        this.drawLegendInternal = true;
    }

    public void setLegendMaxHeight(int height) {
        if (height > 0) {
            this.maxHeight = height;
        }
    }

    public void resetLegendAlignment() throws ChartException {
        this.setConfigureLegendAlignment(this.LDesc.getLegendAlignment());
    }

    public void resetLegendAlignment(Graphics2D g2) throws ChartException {
        this.setConfigureLegendAlignment(g2, this.LDesc.getLegendAlignment());
    }

    public void setLegendLocation(int x, int y) {
        this.originX = x;
        this.originY = y;
    }

    public int getLegendX() {
        return this.originX;
    }

    public int getLegendY() {
        return this.originY;
    }

    public void setConfigureLegendAlignment(int alignment) throws ChartException {
        String fcn = "setConfigureLegendAlignment";
        if (this.isPieChart) {
            switch (alignment) {
                case -1: 
                case 2: 
                case 3: 
                case 4: 
                case 7: 
                case 10: 
                case 11: {
                    break;
                }
                default: {
                    Errorfcn.chartError("setAlignment()", MsgUtil.getMsg("CHT-300"));
                    break;
                }
            }
        } else if (!this.LDesc.getLegendInside()) {
            switch (alignment) {
                case 3: 
                case 4: 
                case 10: 
                case 11: {
                    break;
                }
                default: {
                    Errorfcn.chartError("setAlignment()", MsgUtil.getMsg("CHT-301"));
                    break;
                }
            }
        } else {
            switch (alignment) {
                case -1: 
                case 0: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    break;
                }
                default: {
                    Errorfcn.chartError("setAlignment()", MsgUtil.getMsg("CHT-302"));
                }
            }
        }
        switch (alignment) {
            case 8: {
                if (!this.LDesc.getLegendInside()) break;
                this.originX = this.Width - this.getLegendWidth() - this.BorderRight + this.LDesc.getLegendOffsetX();
                this.originY = this.BorderTop + this.LDesc.getLegendOffsetY();
                break;
            }
            case 9: {
                if (this.LDesc.getLegendInside()) {
                    this.originX = this.BorderLeft + this.LDesc.getLegendOffsetX();
                    this.originY = this.BorderTop + this.LDesc.getLegendOffsetY();
                    break;
                }
                this.originX = this.LDesc.getLegendOffsetX();
                this.originY = this.LDesc.getLegendOffsetY();
                break;
            }
            case 7: {
                this.originX = this.BorderLeft + this.LDesc.getLegendOffsetX() + (this.Width - this.BorderLeft - this.BorderRight - this.getLegendWidth()) / 2;
                this.originY = this.BorderTop + this.LDesc.getLegendOffsetY();
                break;
            }
            case 5: {
                if (this.LDesc.getLegendInside()) {
                    this.originX = this.Width - this.getLegendWidth() - this.BorderRight + this.LDesc.getLegendOffsetX();
                    this.originY = this.Height - this.getLegendHeight() - this.BorderBottom + this.LDesc.getLegendOffsetY();
                    break;
                }
                this.originX = this.Width - this.getLegendWidth() + this.LDesc.getLegendOffsetX();
                this.originY = this.Height - this.getLegendHeight() + this.LDesc.getLegendOffsetY();
                break;
            }
            case 11: {
                this.originX = this.Width - this.getLegendWidth() + this.LDesc.getLegendOffsetX();
                this.originY = this.LDesc.getLegendOffsetY() + (this.Height - this.getLegendHeight()) / 2;
                break;
            }
            case 10: {
                this.originX = this.Width - this.getLegendWidth() + this.LDesc.getLegendOffsetX();
                if (this.Height - this.getLegendHeight() >= this.BorderBottom) {
                    this.originY = this.LDesc.getLegendOffsetY() + this.Height - this.getLegendHeight() - this.BorderBottom;
                    break;
                }
                this.originY = this.LDesc.getLegendOffsetY() + (this.Height - this.getLegendHeight()) / 2;
                break;
            }
            case 3: {
                if (this.LDesc.getLegendInside()) {
                    this.originX = this.Width - this.getLegendWidth() - this.BorderRight + this.LDesc.getLegendOffsetX();
                    this.originY = this.LDesc.getLegendOffsetY() + (this.Height - this.getLegendHeight()) / 2;
                    break;
                }
                this.originX = this.Width - this.getLegendWidth() + this.LDesc.getLegendOffsetX();
                this.originY = this.LDesc.getLegendOffsetY() + (this.Height - this.getLegendHeight()) / 2;
                break;
            }
            case 6: {
                if (!this.LDesc.getLegendInside()) break;
                this.originX = this.BorderLeft + this.LDesc.getLegendOffsetX();
                this.originY = this.Height - this.getLegendHeight() - this.BorderBottom + this.LDesc.getLegendOffsetY();
                break;
            }
            case 4: {
                if (this.LDesc.getLegendInside()) {
                    this.originX = this.BorderLeft + this.LDesc.getLegendOffsetX() + (this.Width - this.BorderLeft - this.BorderRight - this.getLegendWidth()) / 2;
                    this.originY = this.Height - this.getLegendHeight() - this.BorderBottom + this.LDesc.getLegendOffsetY();
                    break;
                }
                int hspace = this.Width - this.BorderRight - this.BorderLeft;
                if (this.getLegendWidth() > hspace) {
                    this.originX = (this.Width - this.getLegendWidth()) / 2;
                    if (this.originX < 0) {
                        this.originX = 0;
                    }
                } else {
                    this.originX = this.BorderLeft + this.LDesc.getLegendOffsetX() + (this.Width - this.BorderLeft - this.BorderRight - this.getLegendWidth()) / 2;
                }
                this.originY = this.Height - this.getLegendHeight() + this.LDesc.getLegendOffsetY();
                break;
            }
            case 0: {
                break;
            }
            case 2: {
                if (!this.LDesc.getLegendInside()) break;
                this.originX = this.BorderLeft + this.LDesc.getLegendOffsetX();
                this.originY = this.LDesc.getLegendOffsetY() + (this.Height - this.getLegendHeight()) / 2;
                break;
            }
            case -1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("improper alignment: " + alignment);
            }
        }
    }

    public void setConfigureLegendAlignment(Graphics2D g2, int alignment) throws ChartException {
        String fcn = "setConfigureLegendAlignmentg2 ";
        if (this.isPieChart) {
            switch (alignment) {
                case -1: 
                case 2: 
                case 3: 
                case 4: 
                case 7: 
                case 10: 
                case 11: {
                    break;
                }
                default: {
                    Errorfcn.chartError("setAlignment()", MsgUtil.getMsg("CHT-300"));
                    break;
                }
            }
        } else if (!this.LDesc.getLegendInside()) {
            switch (alignment) {
                case 3: 
                case 4: 
                case 10: 
                case 11: {
                    break;
                }
                default: {
                    Errorfcn.chartError("setAlignment()", MsgUtil.getMsg("CHT-301"));
                    break;
                }
            }
        } else {
            switch (alignment) {
                case -1: 
                case 0: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    break;
                }
                default: {
                    Errorfcn.chartError("setAlignment()", MsgUtil.getMsg("CHT-302"));
                }
            }
        }
        switch (alignment) {
            case 8: {
                if (!this.LDesc.getLegendInside()) break;
                this.originX = this.Width - this.getLegendWidth(g2) - this.BorderRight + this.LDesc.getLegendOffsetX();
                this.originY = this.BorderTop + this.LDesc.getLegendOffsetY();
                break;
            }
            case 9: {
                if (this.LDesc.getLegendInside()) {
                    this.originX = this.BorderLeft + this.LDesc.getLegendOffsetX();
                    this.originY = this.BorderTop + this.LDesc.getLegendOffsetY();
                    break;
                }
                this.originX = this.LDesc.getLegendOffsetX();
                this.originY = this.LDesc.getLegendOffsetY();
                break;
            }
            case 7: {
                this.originX = this.BorderLeft + this.LDesc.getLegendOffsetX() + (this.Width - this.BorderLeft - this.BorderRight - this.getLegendWidth(g2)) / 2;
                this.originY = this.BorderTop + this.LDesc.getLegendOffsetY();
                break;
            }
            case 5: {
                if (this.LDesc.getLegendInside()) {
                    this.originX = this.Width - this.getLegendWidth(g2) - this.BorderRight + this.LDesc.getLegendOffsetX();
                    this.originY = this.Height - this.getLegendHeight() - this.BorderBottom + this.LDesc.getLegendOffsetY();
                    break;
                }
                this.originX = this.Width - this.getLegendWidth(g2) + this.LDesc.getLegendOffsetX();
                this.originY = this.Height - this.getLegendHeight() + this.LDesc.getLegendOffsetY();
                break;
            }
            case 11: {
                this.originX = this.Width - this.getLegendWidth(g2) + this.LDesc.getLegendOffsetX();
                this.originY = this.LDesc.getLegendOffsetY() + (this.Height - this.getLegendHeight()) / 2;
                break;
            }
            case 10: {
                this.originX = this.Width - this.getLegendWidth(g2) + this.LDesc.getLegendOffsetX();
                if (this.Height - this.getLegendHeight() >= this.BorderBottom) {
                    this.originY = this.LDesc.getLegendOffsetY() + this.Height - this.getLegendHeight() - this.BorderBottom;
                    break;
                }
                this.originY = this.LDesc.getLegendOffsetY() + (this.Height - this.getLegendHeight()) / 2;
                break;
            }
            case 3: {
                if (this.LDesc.getLegendInside()) {
                    this.originX = this.Width - this.getLegendWidth(g2) - this.BorderRight + this.LDesc.getLegendOffsetX();
                    this.originY = this.LDesc.getLegendOffsetY() + (this.Height - this.getLegendHeight()) / 2;
                    break;
                }
                this.originX = this.Width - this.getLegendWidth(g2) + this.LDesc.getLegendOffsetX();
                this.originY = this.LDesc.getLegendOffsetY() + (this.Height - this.getLegendHeight()) / 2;
                break;
            }
            case 6: {
                if (!this.LDesc.getLegendInside()) break;
                this.originX = this.BorderLeft + this.LDesc.getLegendOffsetX();
                this.originY = this.Height - this.getLegendHeight() - this.BorderBottom + this.LDesc.getLegendOffsetY();
                break;
            }
            case 4: {
                if (this.LDesc.getLegendInside()) {
                    this.originX = this.BorderLeft + this.LDesc.getLegendOffsetX() + (this.Width - this.BorderLeft - this.BorderRight - this.getLegendWidth(g2)) / 2;
                    this.originY = this.Height - this.getLegendHeight() - this.BorderBottom + this.LDesc.getLegendOffsetY();
                    break;
                }
                int hspace = this.Width - this.BorderRight - this.BorderLeft;
                if (this.getLegendWidth(g2) > hspace) {
                    this.originX = (this.Width - this.getLegendWidth(g2)) / 2;
                    if (this.originX < 0) {
                        this.originX = 0;
                    }
                } else {
                    this.originX = this.BorderLeft + this.LDesc.getLegendOffsetX() + (this.Width - this.BorderLeft - this.BorderRight - this.getLegendWidth(g2)) / 2;
                }
                this.originY = this.Height - this.getLegendHeight() + this.LDesc.getLegendOffsetY();
                break;
            }
            case 0: {
                break;
            }
            case 2: {
                if (!this.LDesc.getLegendInside()) break;
                this.originX = this.BorderLeft + this.LDesc.getLegendOffsetX();
                this.originY = this.LDesc.getLegendOffsetY() + (this.Height - this.getLegendHeight()) / 2;
                break;
            }
            case -1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("improper alignment: " + alignment);
            }
        }
    }

    public void setAddLegendItem(String label, Color color) {
        this.items.addElement(new LegendElement(label, color));
    }

    public void setAddLegendItem(String label, Color color, int markerType, Color markerColor, BasicStroke lineStroke) {
        this.items.addElement(new LegendElement(label, color, markerType, markerColor, lineStroke));
    }

    public void setDeleteLegendItem(String label) {
        int i = 0;
        while (i < this.items.size()) {
            LegendElement oneItem = (LegendElement)this.items.elementAt(i);
            String itemLabel = oneItem.label;
            if (itemLabel.equals(label)) {
                this.items.removeElement(oneItem);
            }
            ++i;
        }
    }

    public void setUpdateLegendItemXLink(String label, String xLink) {
        int i = 0;
        while (i < this.items.size()) {
            LegendElement oneItem = (LegendElement)this.items.elementAt(i);
            String itemLabel = oneItem.label;
            if (itemLabel.equals(label)) {
                oneItem.svgXLink = xLink;
            }
            ++i;
        }
    }

    private void copyDrawable() {
        int i = 0;
        while (i < this.items.size()) {
            LegendElement oneItem = (LegendElement)this.items.elementAt(i);
            if (oneItem.drawElement) {
                this.drawableItems.addElement(oneItem);
            }
            ++i;
        }
    }

    public void setLegendItemColor(String label, Color color) {
        int i = 0;
        while (i < this.items.size()) {
            LegendElement oneItem = (LegendElement)this.items.elementAt(i);
            String itemLabel = oneItem.label;
            if (itemLabel.equals(label)) {
                oneItem.color = color;
            }
            ++i;
        }
    }

    public void setLegendSVGScript(String label, String userSVGScript) {
        int i = 0;
        while (i < this.items.size()) {
            LegendElement oneItem = (LegendElement)this.items.elementAt(i);
            String itemLabel = oneItem.label;
            if (itemLabel.equals(label)) {
                oneItem.userSVGScript = userSVGScript;
            }
            ++i;
        }
    }

    public void setLegendLabelColor(String label, Color color) {
        int i = 0;
        while (i < this.items.size()) {
            LegendElement oneItem = (LegendElement)this.items.elementAt(i);
            String itemLabel = oneItem.label;
            if (itemLabel.equals(label)) {
                oneItem.labelColor = color;
            }
            ++i;
        }
    }

    public void setLegendItemMarker(String label, Color color, int markerType, Color markerColor, BasicStroke lineStroke) {
        int i = 0;
        while (i < this.items.size()) {
            LegendElement oneItem = (LegendElement)this.items.elementAt(i);
            String itemLabel = oneItem.label;
            if (itemLabel.equals(label)) {
                oneItem.color = color;
                oneItem.markerType = markerType;
                oneItem.markerColor = markerColor;
                oneItem.lineStroke = lineStroke;
            }
            ++i;
        }
    }

    public boolean setLegendReduceWidth(int maxLegendWidth) {
        int minLegendWidth = this.getLegendWidthNoText();
        if (maxLegendWidth <= minLegendWidth) {
            return false;
        }
        int maxTextWidth = maxLegendWidth - minLegendWidth;
        this.maxLabelWidth = 0;
        FontMetrics fontmet = this.getFontMetrics(this.LDesc.getLegendFont());
        int i = 0;
        while (i < this.items.size()) {
            LegendElement oneItem = (LegendElement)this.items.elementAt(i);
            if (oneItem.drawElement) {
                if (fontmet.stringWidth(oneItem.label) > maxTextWidth) {
                    this.UseReducedStrings = true;
                    String tempLabel = "";
                    int j = oneItem.label.length() - 1;
                    while (j >= 0) {
                        tempLabel = oneItem.label.substring(0, j - 1);
                        int tempLabelWidth = fontmet.stringWidth(tempLabel);
                        if (tempLabelWidth <= maxTextWidth) break;
                        --j;
                    }
                    oneItem.labelReduced = j == 0 ? "" : tempLabel;
                } else {
                    oneItem.labelReduced = oneItem.label;
                }
            }
            ++i;
        }
        return true;
    }

    private void getMaxLabelWidth() {
        this.maxLabelWidth = 0;
        FontMetrics fontmet = this.getFontMetrics(this.LDesc.getLegendFont());
        int i = 0;
        while (i < this.items.size()) {
            LegendElement oneItem = (LegendElement)this.items.elementAt(i);
            if (oneItem.drawElement) {
                if (!this.UseReducedStrings) {
                    if (this.maxLabelWidth < fontmet.stringWidth(oneItem.label)) {
                        this.maxLabelWidth = fontmet.stringWidth(oneItem.label);
                    }
                } else if (oneItem.labelReduced != null && this.maxLabelWidth < fontmet.stringWidth(oneItem.labelReduced)) {
                    this.maxLabelWidth = fontmet.stringWidth(oneItem.labelReduced);
                }
            }
            ++i;
        }
    }

    public void setLegendOffsetYInternal(int offsetY) {
        this.LDesc.setLegendOffsetYInternal(offsetY);
    }

    public void setLegendOffsetXInternal(int offsetX) {
        this.LDesc.setLegendOffsetXInternal(offsetX);
    }

    private int getXLeftOffset() {
        return this.labelHeight / 3;
    }

    private int getXRightOffset() {
        return this.labelHeight / 3;
    }

    private int getXTextEndOffset() {
        return this.labelHeight / 3;
    }

    private int getLegendWidthNoText() {
        return this.x_length + this.getXLeftOffset() + this.getXRightOffset() + this.getXTextEndOffset();
    }

    public int getLegendWidth() {
        if (!this.drawLegendInternal || this.LDesc.getLegendDisable()) {
            return 0;
        }
        this.getMaxLabelWidth();
        int w = this.columns * (this.getLegendWidthNoText() + this.maxLabelWidth);
        return w;
    }

    public int getLegendWidth(Graphics2D g2) {
        if (!this.drawLegendInternal || this.LDesc.getLegendDisable()) {
            return 0;
        }
        this.getMaxLabelWidth();
        int w = this.columns * (this.getLegendWidthNoText() + this.maxLabelWidth);
        if (this.getButtonBarWidth(g2) > w) {
            w = this.getButtonBarWidth(g2);
        }
        return w;
    }

    public int getLegendColumnWidth() {
        this.getMaxLabelWidth();
        return this.getLegendWidthNoText() + this.maxLabelWidth;
    }

    public int getLegendNumItems() {
        return this.items.size();
    }

    private int getLegendNumItems2() {
        int count = 0;
        int j = 0;
        while (j < this.items.size()) {
            LegendElement oneItem = (LegendElement)this.items.elementAt(j);
            if (oneItem.drawElement) {
                ++count;
            }
            ++j;
        }
        return count;
    }

    private int getRowCeil() {
        int itemCount = this.getLegendNumItems2();
        if (this.columns == 1) {
            return itemCount;
        }
        int rows = itemCount / this.columns;
        if (itemCount % this.columns != 0) {
            ++rows;
        }
        return rows;
    }

    public int getRowCeilProjected(int numColumns) {
        if (numColumns == 0) {
            return 0;
        }
        if (numColumns == 1) {
            return this.items.size();
        }
        int rows = this.items.size() / numColumns;
        if (this.items.size() % numColumns != 0) {
            ++rows;
        }
        return rows;
    }

    private int getTitleHeight(int labelHeight) {
        if (this.LDesc.getLegendTitle() == null) {
            return 0;
        }
        if (this.LDesc.getLegendTitle() == "") {
            return 0;
        }
        return 1 * labelHeight;
    }

    public int getLegendHeight() {
        if (!this.drawLegendInternal || this.LDesc.getLegendDisable()) {
            return 0;
        }
        FontMetrics fontmet = this.getFontMetrics(this.LDesc.getLegendFont());
        this.labelHeight = fontmet.getHeight();
        int titleHeight = this.getTitleHeight(this.labelHeight);
        int rows = this.getRowCeil();
        int height = rows * this.labelHeight + this.labelHeight / 2;
        return titleHeight + height;
    }

    public boolean reduceLegendElements() {
        if (this.maxHeight == -1) {
            return false;
        }
        int actualHeight = this.getLegendHeight();
        int j = this.items.size() - 1;
        if (actualHeight > this.maxHeight) {
            LegendElement oneItem;
            j = this.items.size() - 1;
            while (j >= 0) {
                oneItem = (LegendElement)this.items.elementAt(j);
                if (oneItem.drawElement) break;
                --j;
            }
            while (actualHeight > this.maxHeight && j >= 0) {
                oneItem = (LegendElement)this.items.elementAt(j);
                oneItem.drawElement = false;
                actualHeight = this.getLegendHeight();
                --j;
            }
            return j < this.items.size() - 1;
        }
        return false;
    }

    public void resetLegendReduce() {
        this.UseReducedStrings = false;
        int j = this.items.size() - 1;
        while (j >= 0) {
            LegendElement oneItem = (LegendElement)this.items.elementAt(j);
            oneItem.drawElement = true;
            --j;
        }
    }

    public int getLegendHeightProjected(int numColumns) {
        FontMetrics fontmet = this.getFontMetrics(this.LDesc.getLegendFont());
        int rows = this.getRowCeilProjected(numColumns);
        int height = rows * this.labelHeight + this.labelHeight / 2;
        int titleHeight = this.getTitleHeight(this.labelHeight);
        return height + titleHeight;
    }

    public Dimension getLegendSize() {
        return new Dimension(this.getLegendWidth(), this.getLegendHeight());
    }

    public void setLegendColumns(int columns) {
        if (columns > 0) {
            this.columns = columns;
        }
    }

    public void drawLegendBuffer(Graphics2D g2, SVGChartGraphics svgG, boolean genImageMapCoords) {
        this.copyDrawable();
        if (this.LDesc.getLegendDisable()) {
            return;
        }
        if (svgG.getEnableSVG()) {
            svgG.startGroup("cb_legend");
        }
        g2.setFont(this.LDesc.getLegendFont());
        FontMetrics fontmet = this.getFontMetrics(this.LDesc.getLegendFont());
        this.computeLabelHeight(g2);
        int x_start_line = this.originX + this.getXLeftOffset();
        int x_end_line = x_start_line + this.x_length;
        int titleHeight = this.getTitleHeight(this.labelHeight);
        int y_location = this.originY + 2 * this.labelHeight / 3 + titleHeight;
        int height = this.getLegendHeight();
        int width = this.getLegendWidth(g2);
        if (this.LDesc.getLegendInside() || this.LDesc.getLegendBackgroundEnabled()) {
            g2.setColor(this.LDesc.getLegendBackground());
            g2.fillRect(this.originX, this.originY, width, height);
        }
        if (this.LDesc.getLegendInside() && !this.LDesc.getLegendDisable()) {
            g2.setColor(this.LDesc.getLegendEdgeColor());
            g2.drawRect(this.originX, this.originY, width, height);
        } else if (!this.LDesc.getLegendInside() && this.LDesc.isEdgeColorSet()) {
            g2.setColor(this.LDesc.getLegendEdgeColor());
            g2.drawRect(this.originX, this.originY, width, height);
        }
        int skip_height = this.labelHeight;
        int rect_width = x_end_line - x_start_line;
        int shave = 2;
        int shaveHalf = shave / 2;
        int skip_width = this.getLegendColumnWidth();
        int rows = this.getRowCeil();
        int itemNumber = 0;
        this.LDesc.imageMapCoords = new int[this.drawableItems.size()][0];
        if (titleHeight > 0) {
            int x = x_start_line;
            int y = this.originY + titleHeight;
            g2.drawString(this.LDesc.getLegendTitle(), x, y);
        }
        int s = 0;
        while (s < this.getRowCeil()) {
            int t = 0;
            while (t < this.columns) {
                itemNumber = rows > this.columns ? t * rows + s : s * this.columns + t;
                if (itemNumber < this.drawableItems.size()) {
                    LegendElement oneItem = this.legendOrderReverse ? (LegendElement)this.drawableItems.elementAt(this.drawableItems.size() - itemNumber - 1) : (LegendElement)this.drawableItems.elementAt(itemNumber);
                    if (svgG.getEnableSVG() && oneItem.svgXLink != null) {
                        svgG.setStartATagLink(oneItem.svgXLink);
                    }
                    int xCorner0 = x_start_line + t * skip_width;
                    int yCorner0 = y_location + s * skip_height - skip_height / 2;
                    if (svgG.getEnableSVG() && oneItem.userSVGScript != null) {
                        g2.setColor(Color.yellow);
                        RenderingHints rectHints = new RenderingHints(SVGGraphics.SVG_PRIMITIVE_ID, oneItem.label + "_legend_highlight");
                        g2.setRenderingHints(rectHints);
                        svgG.fillRectInvisible(xCorner0, yCorner0, skip_width - 2 * shave, skip_height);
                    }
                    g2.setColor(Color.green);
                    if (oneItem.markerType == -1) {
                        g2.setColor(oneItem.color);
                        g2.fillRect(x_start_line + shave + t * skip_width, y_location + s * skip_height - skip_height / 2 + shave, rect_width - 2 * shave, skip_height - 2 * shave);
                        g2.setColor(Color.black);
                        g2.drawRect(x_start_line + shave + t * skip_width, y_location + s * skip_height - skip_height / 2 + shave, rect_width - 2 * shave, skip_height - 2 * shave);
                    } else {
                        g2.setStroke(oneItem.lineStroke);
                        g2.setColor(oneItem.color);
                        int ymid = y_location + s * skip_height + shaveHalf;
                        int xmid = x_start_line + shave + t * skip_width + rect_width / 2 - shave;
                        RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        hints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
                        RenderingHints RHOriginal = g2.getRenderingHints();
                        g2.setRenderingHints(hints);
                        g2.drawLine(x_start_line + shave + t * skip_width, ymid, x_start_line + shave + t * skip_width + rect_width - 2 * shave, ymid);
                        g2.setStroke(this.LM.getLineMarkerStroke(oneItem.markerType));
                        g2.setColor(oneItem.markerColor);
                        this.LM.drawMarker(g2, oneItem.markerType, 1.0, xmid, ymid);
                        g2.setStroke(this.DefaultStroke);
                        g2.setRenderingHints(RHOriginal);
                    }
                    int x_start_label = x_end_line + this.getXRightOffset() + t * skip_width;
                    int y_start_label = y_location + s * skip_height + skip_height / 3;
                    AttributedString attrStr = null;
                    String itemString = oneItem.label;
                    if (this.UseReducedStrings) {
                        itemString = oneItem.labelReduced;
                    }
                    if (this.LDesc.getLegendTextAttributes() != null) {
                        attrStr = new AttributedString(itemString, this.LDesc.getLegendTextAttributes());
                        TextLayout layout = new TextLayout(attrStr.getIterator(), g2.getFontRenderContext());
                        String tempStr = layout.toString();
                        if (svgG.getEnableSVG() && oneItem.userSVGScript != null) {
                            RenderingHints rectHints = new RenderingHints(SVGGraphics.USER_SCRIPT, oneItem.userSVGScript);
                            g2.setRenderingHints(rectHints);
                        }
                        layout.draw(g2, x_start_label, y_start_label);
                    } else {
                        if (oneItem.labelColor != null) {
                            g2.setColor(oneItem.labelColor);
                        } else {
                            g2.setColor(this.LDesc.getLegendForeground());
                        }
                        if (svgG.getEnableSVG() && oneItem.userSVGScript != null) {
                            RenderingHints rectHints = new RenderingHints(SVGGraphics.USER_SCRIPT, oneItem.userSVGScript);
                            g2.setRenderingHints(rectHints);
                        }
                        g2.drawString(itemString, x_start_label, y_start_label);
                    }
                    if (genImageMapCoords) {
                        int legendItem = this.legendOrderReverse ? this.drawableItems.size() - itemNumber - 1 : itemNumber;
                        xCorner0 = x_start_line + t * skip_width;
                        int xCorner1 = xCorner0 + skip_width - 2 * shave;
                        yCorner0 = y_location + s * skip_height - skip_height / 2;
                        int yCorner1 = yCorner0 + skip_height;
                        this.LDesc.imageMapCoords[legendItem] = new int[4];
                        this.LDesc.imageMapCoords[legendItem][0] = xCorner0;
                        this.LDesc.imageMapCoords[legendItem][1] = yCorner0;
                        this.LDesc.imageMapCoords[legendItem][2] = xCorner1;
                        this.LDesc.imageMapCoords[legendItem][3] = yCorner1;
                    }
                    if (svgG.getEnableSVG() && oneItem.svgXLink != null) {
                        svgG.setEndATag();
                    }
                }
                ++t;
            }
            ++s;
        }
        if (this.LDesc.getLegendButtons() != null && !this.LDesc.getLegendInside()) {
            switch (this.LDesc.getLegendAlignment()) {
                case 3: 
                case 10: 
                case 11: {
                    RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    hints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
                    RenderingHints RHOriginal = g2.getRenderingHints();
                    g2.setRenderingHints(hints);
                    ButtonDesc[] b = this.LDesc.getLegendButtons();
                    int x_offset = 3;
                    int neededWidth = 0;
                    int z = 0;
                    while (z < b.length) {
                        Dimension d = Button.getButtonDimensions(g2, b[z]);
                        neededWidth = (int)((double)neededWidth + d.getWidth());
                        ++z;
                    }
                    int x_displacement = 0;
                    int button_x = x_start_line;
                    if ((neededWidth += (b.length - 1) * x_offset) < width) {
                        x_displacement = (width - neededWidth) / 2;
                        button_x += x_displacement;
                    }
                    this.LDesc.imageMapCoordsButton = new int[b.length][0];
                    int z2 = 0;
                    while (z2 < b.length) {
                        LabelDesc lab = b[z2].getLabelDesc();
                        Dimension d = Button.drawButton(g2, svgG, button_x, this.yBaseline, b[z2]);
                        if (genImageMapCoords) {
                            this.LDesc.imageMapCoordsButton[z2] = new int[4];
                            this.LDesc.imageMapCoordsButton[z2][0] = button_x;
                            this.LDesc.imageMapCoordsButton[z2][1] = this.yBaseline;
                            this.LDesc.imageMapCoordsButton[z2][2] = button_x + (int)d.getWidth();
                            this.LDesc.imageMapCoordsButton[z2][3] = this.yBaseline + (int)d.getHeight();
                        }
                        button_x = (int)((double)button_x + (d.getWidth() + (double)x_offset));
                        ++z2;
                    }
                    g2.setRenderingHints(RHOriginal);
                }
            }
        }
        if (svgG.getEnableSVG()) {
            svgG.endGroup();
        }
    }

    private int getButtonBarWidth(Graphics2D g2) {
        int pad = 13;
        if (this.LDesc.getLegendButtons() != null && !this.LDesc.getLegendInside()) {
            switch (this.LDesc.getLegendAlignment()) {
                case 3: 
                case 10: 
                case 11: {
                    ButtonDesc[] b = this.LDesc.getLegendButtons();
                    int x_offset = 3;
                    int neededWidth = 0;
                    int z = 0;
                    while (z < b.length) {
                        Dimension d = Button.getButtonDimensions(g2, b[z]);
                        neededWidth = (int)((double)neededWidth + d.getWidth());
                        ++z;
                    }
                    neededWidth += b.length * x_offset;
                    return neededWidth += pad;
                }
            }
        }
        return 0;
    }

    protected class LegendElement {
        String label;
        public String userSVGScript;
        String labelReduced;
        Color color;
        Color labelColor = null;
        int markerType;
        Color markerColor;
        BasicStroke lineStroke;
        String svgXLink = null;
        boolean drawElement = true;

        public LegendElement(String label, Color color) {
            this.label = label;
            this.color = color;
            this.markerType = -1;
        }

        public LegendElement(String label, Color color, int markerType, Color markerColor) {
            this.label = label;
            this.color = color;
            this.markerType = markerType;
            this.markerColor = markerColor;
        }

        public LegendElement(String label, Color color, int markerType, Color markerColor, BasicStroke lineStroke) {
            this.label = label;
            this.color = color;
            this.markerType = markerType;
            this.markerColor = markerColor;
            this.lineStroke = lineStroke;
        }
    }
}

