/*
 * Decompiled with CFR 0.152.
 */
package oracle.charts.io;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import oracle.charts.internal.Errorfcn;
import oracle.charts.types.ChartException;

public class TimeSeriesFileReader {
    Date[] dateArray;
    double[] obsArray;
    Vector vDates = new Vector();
    Vector vObs = new Vector();
    public static final int DERIVED = -1;
    boolean ParseEconomic = false;
    static DateFormat dateForm = DateFormat.getDateTimeInstance();
    static DateFormat[] dateFormArray = new DateFormat[]{DateFormat.getDateTimeInstance(2, 3), DateFormat.getDateTimeInstance(2, 2), DateFormat.getDateTimeInstance(3, 3), DateFormat.getDateTimeInstance(3, 2), DateFormat.getDateTimeInstance(1, 1), DateFormat.getDateTimeInstance(0, 0), DateFormat.getDateInstance(3), DateFormat.getDateInstance(2), DateFormat.getDateInstance(1), DateFormat.getDateInstance(0)};
    ParsePosition parsePos = new ParsePosition(0);
    NumberFormat numForm = NumberFormat.getInstance();
    int FirstDateParseIndex = 0;
    int AfterFirstDateParseIndex = 0;
    double[][] obsArray2;
    int ObservationCount = 0;

    /*
     * WARNING - void declaration
     */
    public void readFile(String fileName) throws ChartException {
        StringBuffer sbuf = new StringBuffer();
        try {
            String line;
            BufferedReader rd = new BufferedReader(new FileReader(fileName));
            while ((line = rd.readLine()) != null) {
                void var4_5;
                sbuf.append((String)var4_5);
                sbuf.append("\n");
            }
            rd.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.convert(new String(sbuf));
    }

    public void read(InputStream stream) throws ChartException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            int count;
            byte[] array = new byte[1];
            while ((count = stream.read(array)) > 0) {
                bout.write(array);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.convert(bout.toString());
    }

    private void setParseModeEconomic() throws ChartException {
        this.ParseEconomic = true;
    }

    public Date[] getDates() {
        Date[] ud = new Date[this.vDates.size()];
        int i = 0;
        while (i < this.vDates.size()) {
            ud[i] = (Date)this.vDates.elementAt(i);
            ++i;
        }
        return ud;
    }

    public double[] getObservations() {
        if (this.ObservationCount == 1) {
            return this.obsArray;
        }
        return this.obsArray2[0];
    }

    public double[] getObservations(int seriesIndex) throws ChartException {
        if (seriesIndex >= this.ObservationCount) {
            Errorfcn.chartError("getObservations()", "Series index out of bounds");
        }
        if (this.ObservationCount == 1) {
            return this.obsArray;
        }
        return this.obsArray2[seriesIndex];
    }

    public int getObservationCount() {
        return this.ObservationCount;
    }

    private DateFormat getDateStyle(String str) {
        int beginParseIndex = 0;
        int endParseIndex = 0;
        Date d = null;
        Object num = null;
        int i = 0;
        while (i < dateFormArray.length) {
            dateFormArray[i].setLenient(false);
            ++i;
        }
        boolean foundDate = false;
        int i2 = 0;
        while (this.parsePos.getIndex() < str.length() && !foundDate) {
            beginParseIndex = this.parsePos.getIndex();
            i2 = 0;
            while (i2 < dateFormArray.length) {
                d = dateFormArray[i2].parse(str, this.parsePos);
                if (d != null) {
                    foundDate = true;
                    break;
                }
                ++i2;
            }
            endParseIndex = this.parsePos.getIndex();
            this.parsePos.setIndex(endParseIndex + 1);
        }
        if (foundDate) {
            this.FirstDateParseIndex = beginParseIndex;
            this.AfterFirstDateParseIndex = endParseIndex;
            return dateFormArray[i2];
        }
        this.parsePos.setIndex(0);
        return null;
    }

    private void getFirstNumber(String str) {
        int beginParseIndex = 0;
        int endParseIndex = 0;
        Number num = null;
        boolean foundNum = false;
        while (this.parsePos.getIndex() < str.length() && !foundNum) {
            beginParseIndex = this.parsePos.getIndex();
            num = this.numForm.parse(str, this.parsePos);
            if (num != null) {
                foundNum = true;
            }
            endParseIndex = this.parsePos.getIndex();
            this.parsePos.setIndex(endParseIndex + 1);
        }
        if (foundNum) {
            int lastNewline = str.lastIndexOf(10, endParseIndex);
            String econDate = str.substring(beginParseIndex, endParseIndex);
            SimpleDateFormat f1 = new SimpleDateFormat("yyyy.mm");
            try {
                Date d1 = f1.parse(econDate);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            this.FirstDateParseIndex = lastNewline;
            this.AfterFirstDateParseIndex = endParseIndex;
        } else {
            this.parsePos.setIndex(0);
        }
    }

    /*
     * Unable to fully structure code
     */
    private int getObservationCount(String str) throws ChartException {
        block8: {
            beginParseIndex = 0;
            endParseIndex = 0;
            d = null;
            num = null;
            if (this.ParseEconomic) {
                this.getFirstNumber(str);
            } else {
                TimeSeriesFileReader.dateForm = this.getDateStyle(str);
            }
            if (TimeSeriesFileReader.dateForm == null) {
                Errorfcn.chartError("readFile()", "File does not contain any dates");
            }
            this.parsePos.setIndex(this.AfterFirstDateParseIndex);
            observationCount = 0;
            if (!this.ParseEconomic) ** GOTO lbl33
            nextNewline = str.lastIndexOf(10, endParseIndex);
            while (this.parsePos.getIndex() < nextNewline) {
                beginParseIndex = this.parsePos.getIndex();
                num = this.numForm.parse(str, this.parsePos);
                if (num != null) {
                    ++observationCount;
                }
                endParseIndex = this.parsePos.getIndex();
                this.parsePos.setIndex(endParseIndex + 1);
            }
            break block8;
lbl-1000:
            // 1 sources

            {
                beginParseIndex = this.parsePos.getIndex();
                d = TimeSeriesFileReader.dateForm.parse(str, this.parsePos);
                if (d != null) {
                    return observationCount;
                }
                num = this.numForm.parse(str, this.parsePos);
                if (num != null) {
                    ++observationCount;
                }
                endParseIndex = this.parsePos.getIndex();
                this.parsePos.setIndex(endParseIndex + 1);
lbl33:
                // 2 sources

                ** while (this.parsePos.getIndex() < str.length())
            }
        }
        this.parsePos.setIndex(0);
        return observationCount;
    }

    private void convert(String str) throws ChartException {
        block16: {
            Number num;
            block15: {
                Date d = null;
                num = null;
                this.ObservationCount = this.getObservationCount(str);
                if (this.ObservationCount <= 0) {
                    Errorfcn.chartError("readFile()", "File contains missing observations");
                    return;
                }
                this.parsePos.setIndex(this.FirstDateParseIndex);
                double[] doubleArray = null;
                while (this.parsePos.getIndex() < str.length()) {
                    int endParseIndex;
                    d = dateForm.parse(str, this.parsePos);
                    if (d != null) {
                        this.vDates.addElement(d);
                        endParseIndex = this.parsePos.getIndex();
                        this.parsePos.setIndex(endParseIndex + 1);
                        int currentObsCount = 0;
                        if (this.ObservationCount > 1) {
                            doubleArray = new double[this.ObservationCount];
                        }
                        while (currentObsCount < this.ObservationCount && this.parsePos.getIndex() < str.length()) {
                            num = this.numForm.parse(str, this.parsePos);
                            if (num != null) {
                                if (this.ObservationCount == 1) {
                                    this.vObs.addElement(num);
                                } else {
                                    doubleArray[currentObsCount] = num.doubleValue();
                                }
                                ++currentObsCount;
                            } else {
                                d = dateForm.parse(str, this.parsePos);
                                if (d != null) {
                                    Errorfcn.chartError("readFile()", "File contains unexpected date");
                                }
                            }
                            endParseIndex = this.parsePos.getIndex();
                            this.parsePos.setIndex(endParseIndex + 1);
                        }
                        if (currentObsCount != this.ObservationCount) {
                            Errorfcn.chartError("readFile()", "File contains missing observations");
                        }
                        if (this.ObservationCount <= 1) continue;
                        this.vObs.addElement(doubleArray);
                        continue;
                    }
                    endParseIndex = this.parsePos.getIndex();
                    this.parsePos.setIndex(endParseIndex + 1);
                }
                this.parsePos.setIndex(0);
                if (this.ObservationCount <= 1) break block15;
                this.obsArray2 = new double[this.ObservationCount][];
                int j = 0;
                while (j < this.ObservationCount) {
                    this.obsArray2[j] = new double[this.vDates.size()];
                    ++j;
                }
                int i = 0;
                while (i < this.vDates.size()) {
                    doubleArray = (double[])this.vObs.elementAt(i);
                    int j2 = 0;
                    while (j2 < this.ObservationCount) {
                        this.obsArray2[j2][i] = doubleArray[j2];
                        ++j2;
                    }
                    ++i;
                }
                break block16;
            }
            if (this.ObservationCount != 1) break block16;
            this.obsArray = new double[this.vDates.size()];
            int i = 0;
            while (i < this.vDates.size()) {
                num = (Number)this.vObs.elementAt(i);
                this.obsArray[i] = num.doubleValue();
                ++i;
            }
        }
    }
}

