/*
 * Decompiled with CFR 0.152.
 */
package oracle.charts.axischart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.MediaTracker;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import oracle.charts.axischart.AxisCore;
import oracle.charts.axischart.internal.LineDescription;
import oracle.charts.axischart.internal.NumAxisRenderer;
import oracle.charts.axischart.internal.NumericalFormat;
import oracle.charts.axischart.internal.TimeAxisContinuous;
import oracle.charts.internal.Errorfcn;
import oracle.charts.internal.MsgUtil;
import oracle.charts.svg.SVGXLinkArrayDesc;
import oracle.charts.svg.SVGXLinkDesc;
import oracle.charts.types.AnnotationDesc;
import oracle.charts.types.AreaDesc;
import oracle.charts.types.AxisChartStyleDesc;
import oracle.charts.types.AxisTitleDesc;
import oracle.charts.types.BarDesc;
import oracle.charts.types.CandlestickDesc;
import oracle.charts.types.ChartException;
import oracle.charts.types.DateString;
import oracle.charts.types.GridDesc;
import oracle.charts.types.HiLoCloseDesc;
import oracle.charts.types.ImageMapAreaDesc;
import oracle.charts.types.LineDesc;
import oracle.charts.types.MarkerDesc;
import oracle.charts.types.NumAxisDesc;
import oracle.charts.types.NumBandDesc;
import oracle.charts.types.NumThresholdDesc;
import oracle.charts.types.SubChartSeparatorStyleDesc;
import oracle.charts.types.TimeAxisDesc;
import oracle.charts.types.TimeIntervalDesc;
import oracle.charts.types.TimeIntervalVisualDesc;

public class AxisChart
extends AxisCore {
    public static final int POINT = 0;
    public static final int LINE = 1;
    public static final int AREA = 2;
    public static final int AREA_CUMULATIVE = 3;
    public static final int BAR = 4;
    public static final int BAR_STACKED = 5;
    public static final int HILOCLOSE = 7;
    public static final int OPENHILOCLOSE = 8;
    public static final int CANDLESTICK = 9;
    public static final int HORIZONTAL = 1;
    public static final int VERTICAL = 0;
    private final MediaTracker sTracker = new MediaTracker(this);

    public void setChartLocale(Locale Locale2) {
        this.ChartLocale = Locale2;
        this.xl.setChartLocale(Locale2);
        this.InitFreqDimPre();
    }

    public Locale getChartLocale() {
        return this.ChartLocale;
    }

    public void setChartOrientation(int orientation) throws ChartException {
        String fcn = "setChartOrientation()";
        switch (orientation) {
            case 1: {
                if (this.Ch.containsTStamps) {
                    Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-162"));
                }
                this.Ch.vertical = false;
                if (this.SubChZero.L2.getLegendDesc().getLegendInside()) {
                    this.SubChZero.L2.getLegendDesc().setLegendAlignment(5);
                } else {
                    this.SubChZero.L2.getLegendDesc().setLegendAlignment(4);
                }
                if (!this.PlotBackgroundSet) {
                    this.PlotBackground = super.getBackground();
                }
                if (this.PlotEdgeColorSet) break;
                this.PlotEdgeColor = super.getBackground();
                break;
            }
            case 0: {
                this.Ch.vertical = true;
                break;
            }
            default: {
                Errorfcn.chartError("setChartOrientation()", MsgUtil.getMsg("CHT-161"));
            }
        }
    }

    public void setRenderingHintsLine(RenderingHints hints) {
        this.RHLine = hints;
    }

    public RenderingHints getRenderingHintsLine() {
        return this.RHLine;
    }

    public void setSeriesBarIcons(String seriesName, BufferedImage[] barIcons) throws ChartException {
        block5: {
            int s;
            String fcn = "setSeriesBarIcons()";
            if (!this.Ch.containsTStamps && !this.Ch.containsXLabels) {
                Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-114"));
            }
            if ((s = this.LookupSeries(seriesName)) <= -1) {
                this.chartErrorSeriesNotFound(fcn, seriesName);
            }
            if (s < 0) break block5;
            LineDescription line = (LineDescription)this.SubCh.plotLineDes.elementAt(s);
            line.containsBarIcons = true;
            line.barIcons = barIcons;
            this.SubCh.containsBarIcons = true;
            int id = 0;
            int i = 0;
            while (i < barIcons.length) {
                this.sTracker.addImage(line.barIcons[i], id++);
                ++i;
            }
            try {
                this.sTracker.waitForAll();
            }
            catch (InterruptedException ie) {}
        }
    }

    public void setSeriesPointLabels(String seriesName, String[] pointLabels) throws ChartException {
        String fcn = "setSeriesPointLabels()";
        if (!this.Ch.containsTStamps && !this.Ch.containsXLabels) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-114"));
        }
        int length = pointLabels.length;
        int s = this.LookupSeries(seriesName);
        if (s <= -1) {
            this.chartErrorSeriesNotFound(fcn, seriesName);
        }
        if (s >= 0) {
            LineDescription line = (LineDescription)this.SubCh.plotLineDes.elementAt(s);
            line.pointLabelsOn = true;
            line.pointLabels = new String[length];
            int i = 0;
            while (i < length) {
                line.pointLabels[i] = pointLabels[i];
                ++i;
            }
            this.SubCh.containsPointLabels = true;
        }
    }

    public void setSeriesPointLabels(String seriesName) throws ChartException {
        this.setSeriesPointLabelsInternal(seriesName);
    }

    private void setSeriesPointLabelsInternal(String seriesName) throws ChartException {
        int s = this.LookupSeries(seriesName);
        if (s <= -1) {
            this.chartErrorSeriesNotFound("setSeriesPointLabels()", seriesName);
        }
        LineDescription line = (LineDescription)this.SubCh.plotLineDes.elementAt(s);
        line.pointLabelsOn = true;
        this.SubCh.containsPointLabels = true;
        int length = line.num_points;
        line.pointLabels = new String[length];
        NumAxisRenderer yAxis = this.SubCh.YAxis1;
        int i = 0;
        while (i < length) {
            Double tempDouble = new Double(line.yval[i]);
            line.pointLabels[i] = NumericalFormat.formatPointLabel(this.ChartLocale, yAxis.yl.numAxisD, tempDouble);
            ++i;
        }
    }

    public void setXSeries(int frequency, java.util.Date startDate, java.util.Date endDate) throws ChartException {
        this.setXSeriesFrequency(frequency, startDate, endDate, 1);
        this.TimeAxisCont = new TimeAxisContinuous(this.Ch.TStamps[0], this.Ch.TStamps[this.Ch.TStampsCount - 1]);
        this.loadAxisTimeBandsVector();
    }

    public void setXSeries(int frequency, java.util.Date startDate, java.util.Date endDate, int units) throws ChartException {
        super.setXSeriesFrequency(frequency, startDate, endDate, units);
        this.TimeAxisCont = new TimeAxisContinuous(this.Ch.TStamps[0], this.Ch.TStamps[this.Ch.TStampsCount - 1]);
        this.loadAxisTimeBandsVector();
    }

    public void setXSeries(java.util.Date[] tstamps) throws ChartException {
        if (tstamps == null) {
            Errorfcn.chartError("setXSeries", MsgUtil.getMsg("CHT-150"));
        }
        this.setXSeriesInternal(tstamps, tstamps.length);
    }

    public void setXSeries(java.util.Date[] tstamps, int length) throws ChartException {
        if (tstamps == null) {
            Errorfcn.chartError("setXSeries", MsgUtil.getMsg("CHT-150"));
        }
        int length2 = length;
        if (tstamps.length < length) {
            length2 = tstamps.length;
        }
        this.setXSeriesInternal(tstamps, length2);
    }

    public void setXSeries(java.util.Date startDate, java.util.Date endDate) throws ChartException {
        super.setXSeriesContinuous(startDate, endDate, false);
    }

    public void setSeriesAnnotations(java.util.Date[] tstamps, String[] yannotations) throws ChartException {
        if (this.SubCh.plotLineDes.isEmpty()) {
            this.chartErrorSeriesNotFound("setSeriesAnnotations()", "");
        }
        LineDescription line = (LineDescription)this.SubCh.plotLineDes.elementAt(0);
        super.setSeriesAnnotationsInternal(line, tstamps, yannotations);
    }

    public void setSeriesAnnotations(String seriesName, java.util.Date[] tstamps, String[] yannotations) throws ChartException {
        int s = this.LookupSeries(seriesName);
        if (s <= -1) {
            this.chartErrorSeriesNotFound("setSeriesAnnotations()", seriesName);
        }
        if (s >= 0) {
            LineDescription line = (LineDescription)this.SubCh.plotLineDes.elementAt(s);
            super.setSeriesAnnotationsInternal(line, tstamps, yannotations);
        }
    }

    public void setSeriesAnnotations(String seriesName, int[] indicies, String[] yannotations) throws ChartException {
        int s = this.LookupSeries(seriesName);
        if (s <= -1) {
            this.chartErrorSeriesNotFound("setSeriesAnnotations()", seriesName);
        }
        if (s >= 0) {
            LineDescription line = (LineDescription)this.SubCh.plotLineDes.elementAt(s);
            super.setSeriesAnnotationsInternal(line, indicies, yannotations);
        }
    }

    public void setSeriesAnnotations(String seriesName, double[] xAxisValues, String[] yannotations) throws ChartException {
        int s = this.LookupSeries(seriesName);
        if (s <= -1) {
            this.chartErrorSeriesNotFound("setSeriesAnnotations()", seriesName);
        }
        if (s >= 0) {
            LineDescription line = (LineDescription)this.SubCh.plotLineDes.elementAt(s);
            super.setSeriesAnnotationsInternal(line, xAxisValues, yannotations);
        }
    }

    private String wrapDate(java.util.Date d) {
        StringBuffer sbuf = new StringBuffer();
        if (d == null) {
            sbuf.append("java.sql.Date.valueOf(\"\")");
            return sbuf.toString();
        }
        if (d instanceof Date) {
            sbuf.append("java.sql.Date.valueOf(\"");
            sbuf.append(d);
        } else if (d instanceof Timestamp) {
            sbuf.append("java.sql.Timestamp.valueOf(\"");
            sbuf.append(d);
        } else {
            Timestamp sqlTime = new Timestamp(d.getTime());
            sbuf.append("java.sql.Timestamp.valueOf(\"");
            sbuf.append(sqlTime);
        }
        sbuf.append("\")");
        return sbuf.toString();
    }

    private String wrapDateArray(java.util.Date[] d) {
        StringBuffer sbuf = new StringBuffer();
        if (d == null) {
            sbuf.append("new java.util.Date[] {}");
            return sbuf.toString();
        }
        if (d.length == 0) {
            sbuf.append("new java.util.Date[] {}");
            return sbuf.toString();
        }
        if (d[0] instanceof Date) {
            sbuf.append("new java.sql.Date[] {");
        } else if (d[0] instanceof Timestamp) {
            sbuf.append("new java.sql.Timestamp[] {");
        } else {
            sbuf.append("new java.util.Date[] {");
        }
        if (d != null) {
            int i = 0;
            while (i < d.length) {
                sbuf.append(this.wrapDate(d[i]));
                if (i < d.length - 1) {
                    sbuf.append(", ");
                }
                ++i;
            }
        }
        sbuf.append("}");
        return sbuf.toString();
    }

    private String wrapdoubleArray(double[] d) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("new double[] {");
        if (d != null) {
            int i = 0;
            while (i < d.length) {
                sbuf.append(d[i]);
                if (i < d.length - 1) {
                    sbuf.append(", ");
                }
                ++i;
            }
        }
        sbuf.append("}");
        return sbuf.toString();
    }

    protected String emitColor(Color c) {
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        int a = c.getAlpha();
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("setColor(");
        sbuf.append(r);
        sbuf.append(",");
        sbuf.append(g);
        sbuf.append(",");
        sbuf.append(b);
        sbuf.append(",");
        sbuf.append(a);
        sbuf.append(")");
        return sbuf.toString();
    }

    protected String emitNewColor(Color c) {
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        int a = c.getAlpha();
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("new Color(");
        sbuf.append(r);
        sbuf.append(",");
        sbuf.append(g);
        sbuf.append(",");
        sbuf.append(b);
        sbuf.append(",");
        sbuf.append(a);
        sbuf.append(")");
        return sbuf.toString();
    }

    public String getChartState() {
        LineDescription line;
        Object f;
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(this.emitVersion());
        sbuf.append(this.emitBackground());
        sbuf.append(this.emitEdgeColor());
        sbuf.append(this.emitSize());
        sbuf.append(this.emitTitle());
        sbuf.append(this.emitBorders());
        if (this.AxisT.titleDescX.getTitle() != "") {
            sbuf.append("// X Axis Title \n");
            AxisTitleDesc xAxisTD = this.AxisT.titleDescX;
            sbuf.append("AxisTitleDesc axisTitleD = new AxisTitleDesc();\n");
            sbuf.append("axisTitleD.");
            sbuf.append(this.emitFont(xAxisTD.getFont()));
            sbuf.append("axisTitleD.setTitle(\"");
            sbuf.append(xAxisTD.getTitle());
            sbuf.append("\");\n");
            sbuf.append("chs.setChartAttributes(AxisChart.XAXIS, axisTitleD);\n");
        }
        if (this.AxisT.titleDescY.getTitle() != "") {
            sbuf.append("// Y Axis Title \n");
            AxisTitleDesc yAxisTD = this.AxisT.titleDescY;
            sbuf.append("AxisTitleDesc axisTitleD = new AxisTitleDesc();\n");
            sbuf.append("axisTitleD.");
            sbuf.append(this.emitFont(yAxisTD.getFont()));
            sbuf.append("axisTitleD.setTitle(\"");
            sbuf.append(yAxisTD.getTitle());
            sbuf.append("\");\n");
            sbuf.append("chs.setChartAttributes(AxisChart.YAXIS, axisTitleD);\n");
        }
        TimeAxisDesc tad = this.xl.timeAxisD;
        sbuf.append("// Time Axis Desc \n");
        sbuf.append("TimeAxisDesc timeAxisD = new TimeAxisDesc();\n");
        sbuf.append("timeAxisD.");
        sbuf.append(this.emitFont(tad.getFont()));
        sbuf.append("chs.setChartAttributes(timeAxisD);\n");
        NumAxisRenderer yAxis = this.SubCh.YAxis1;
        NumAxisDesc nad = yAxis.yl.numAxisD;
        sbuf.append("// Numerical Axis Desc \n");
        sbuf.append("NumAxisDesc yAxisD = new NumAxisDesc();\n");
        sbuf.append("yAxisD.");
        sbuf.append(this.emitFont(nad.getFont()));
        if (nad.getExtentMin() != Double.MAX_VALUE || nad.getExtentMax() != Double.MIN_VALUE) {
            if (nad.getExtentMin() != Double.MAX_VALUE) {
                sbuf.append("yAxisD.setExtentMin(");
                sbuf.append(nad.getExtentMin());
                sbuf.append(");\n");
            }
            if (nad.getExtentMax() != Double.MIN_VALUE) {
                sbuf.append("yAxisD.setExtentMax(");
                sbuf.append(nad.getExtentMax());
                sbuf.append(");\n");
            }
        }
        if (nad.getFixedColumnWidthYMin() != Double.MAX_VALUE || nad.getFixedColumnWidthYMax() != Double.MIN_VALUE) {
            sbuf.append("yAxisD.setFixedColumnWidthYMin(");
            sbuf.append(nad.getFixedColumnWidthYMin());
            sbuf.append(", ");
            sbuf.append(nad.getFixedColumnWidthYMax());
            sbuf.append(");\n");
        }
        if (nad.getFixedColumnWidthPixels() != -1) {
            sbuf.append("yAxisD.setFixedColumnWidthPixels(");
            sbuf.append(nad.getFixedColumnWidthPixels());
            sbuf.append(");\n");
        }
        if (!nad.getAutoSpacing()) {
            sbuf.append("yAxisD.setLabelIncrement(");
            sbuf.append(nad.getLabelIncrement());
            sbuf.append(");\n");
        }
        if (nad.getNumberFormat() != null) {
            sbuf.append("yAxisD.setNumberFormat(");
            sbuf.append(nad.getNumberFormat());
            sbuf.append(");\n");
        }
        if (nad.getUserDefinedFormat() != null) {
            sbuf.append("yAxisD.setUserDefinedFormat(");
            sbuf.append(nad.getUserDefinedFormat());
            sbuf.append(");\n");
        }
        sbuf.append("chs.setChartAttributes(yAxisD);\n");
        sbuf.append("// X Series \n");
        sbuf.append("chs.setXSeries(");
        if (this.Ch.xAxisStartVal != 0.0 || this.Ch.xAxisEndVal != 0.0) {
            sbuf.append(this.Ch.xAxisStartVal);
            sbuf.append(", ");
            sbuf.append(this.Ch.xAxisEndVal);
            sbuf.append(", ");
            f = this.Ch.numXAxisNF;
            if (f instanceof DecimalFormat) {
                sbuf.append("DecimalFormat.getInstance()");
            } else {
                sbuf.append("NumberFormat.getInstance()");
            }
            sbuf.append(");\n");
        } else if (this.Ch.continuousTimeXAxis) {
            sbuf.append(this.wrapDate(this.TimeAxisCont.startTStamp));
            sbuf.append(", ");
            sbuf.append(this.wrapDate(this.TimeAxisCont.endTStamp));
            sbuf.append(");\n");
        } else {
            if (this.Ch.units > 0) {
                f = "freq";
                switch (this.Ch.frequency) {
                    case 1: {
                        f = "Calendar.YEAR";
                        break;
                    }
                    case 2: {
                        f = "Calendar.MONTH";
                        break;
                    }
                    case 5: {
                        f = "Calendar.DAY_OF_MONTH";
                        break;
                    }
                    case 10: {
                        f = "Calendar.HOUR";
                        break;
                    }
                    case 12: {
                        f = "Calendar.MINUTE";
                        break;
                    }
                    case 13: {
                        f = "Calendar.SECOND";
                    }
                }
                sbuf.append((String)f);
                sbuf.append(", ");
                sbuf.append(this.wrapDate(this.TimeAxisCont.startTStamp));
                sbuf.append(", ");
                sbuf.append(this.wrapDate(this.TimeAxisCont.endTStamp));
                sbuf.append(");\n");
            } else if (this.Ch.containsTStamps) {
                sbuf.append(this.wrapDateArray(this.Ch.TStamps));
            }
            sbuf.append(");\n");
        }
        if (this.UserTimeBand != null) {
            int i;
            if (this.UserTimeBand.getTimeBandIntervals() != null) {
                sbuf.append("// Time Bands \n");
                sbuf.append("TimeBandDesc tband = new TimeBandDesc();\n");
                TimeIntervalDesc[] bandIntervals = this.UserTimeBand.getTimeBandIntervals();
                sbuf.append("TimeIntervalDesc tiViz[] = ");
                sbuf.append("new TimeIntervalDesc[] {");
                i = 0;
                while (i < bandIntervals.length) {
                    if (bandIntervals[i] != null) {
                        sbuf.append("\n  new TimeIntervalDesc(");
                        sbuf.append("\n    ");
                        sbuf.append(this.wrapDate(bandIntervals[i].getStartDate()));
                        sbuf.append(", ");
                        sbuf.append("\n    ");
                        sbuf.append(this.wrapDate(bandIntervals[i].getEndDate()));
                        sbuf.append(")");
                        if (i < bandIntervals.length - 1) {
                            sbuf.append(",");
                        }
                    }
                    ++i;
                }
                sbuf.append("};");
                sbuf.append("\n");
                sbuf.append("tband.setTimeBandIntervals(tiViz);\n");
                sbuf.append("chs.setChartAttributes(tband);\n");
            } else if (this.UserTimeBand.getTimeBandIntervalsVisual() != null) {
                sbuf.append("// Time Bands \n");
                TimeIntervalVisualDesc[] bandVisual = this.UserTimeBand.getTimeBandIntervalsVisual();
                sbuf.append("TimeIntervalVisualDesc tiViz[] = ");
                sbuf.append("new TimeIntervalVisualDesc[] {");
                i = 0;
                while (i < bandVisual.length) {
                    if (bandVisual[i] != null && bandVisual[i].getTimeIntervalDesc() != null) {
                        sbuf.append("\n  new TimeIntervalVisualDesc(");
                        sbuf.append("new TimeIntervalDesc(");
                        sbuf.append("\n    ");
                        sbuf.append(this.wrapDate(bandVisual[i].getTimeIntervalDesc().getStartDate()));
                        sbuf.append(", ");
                        sbuf.append("\n    ");
                        sbuf.append(this.wrapDate(bandVisual[i].getTimeIntervalDesc().getEndDate()));
                        sbuf.append("))");
                        if (i < bandVisual.length - 1) {
                            sbuf.append(",");
                        }
                    }
                    ++i;
                }
                sbuf.append("};");
                sbuf.append("\n");
                sbuf.append("TimeBandDesc tband = new TimeBandDesc();\n");
                sbuf.append("tband.setTimeBandIntervalsVisual(tiViz);\n");
                sbuf.append("chs.setChartAttributes(tband);\n");
            }
        }
        sbuf.append("// Y Series \n");
        int k = 0;
        while (k < this.Ch.SC.size()) {
            AxisCore.SubChartDescription sc = (AxisCore.SubChartDescription)this.Ch.SC.elementAt(k);
            if (k > 0) {
                sbuf.append("chs.setSubChart(\"");
                sbuf.append(sc.subchart_name);
                sbuf.append("\");\n");
            }
            int s = 0;
            while (s < sc.plotLineDes.size()) {
                line = (LineDescription)sc.plotLineDes.elementAt(s);
                if (this.Ch.continuousTimeXAxis) {
                    sbuf.append("chs.setYSeriesSparse(");
                    sbuf.append("\"" + line.seriesName + "\"");
                    sbuf.append(", ");
                    sbuf.append(this.wrapDateArray(line.contDates));
                    sbuf.append(", ");
                    sbuf.append(this.wrapdoubleArray(line.yval));
                    sbuf.append(");\n");
                } else if (this.Ch.containsTStamps) {
                    if (line.subFrequency) {
                        if (!this.isStockType(line.lineType)) {
                            sbuf.append("chs.setYSeriesSparse(");
                            sbuf.append(this.emitSeriesName(line));
                            sbuf.append(this.wrapDateArray(line.contDates));
                            sbuf.append(", ");
                            sbuf.append(this.wrapdoubleArray(line.yval));
                            sbuf.append(");\n");
                        } else {
                            switch (line.lineType) {
                                case 7: {
                                    sbuf.append("chs.setHiLoCloseSeriesSparse(");
                                    break;
                                }
                                case 8: {
                                    sbuf.append("chs.setOpenHiLoCloseSeriesSparse(");
                                    break;
                                }
                                case 9: {
                                    sbuf.append("chs.setCandlestickSeriesSparse(");
                                }
                            }
                            sbuf.append(this.emitSeriesName(line));
                            sbuf.append(this.wrapDateArray(line.contDates));
                            sbuf.append(", ");
                            sbuf.append(this.emitYValsStock(line));
                        }
                    } else if (!this.isStockType(line.lineType)) {
                        sbuf.append("chs.setYSeries(");
                        sbuf.append(this.emitSeriesName(line));
                        sbuf.append(this.wrapdoubleArray(line.yval));
                        sbuf.append(");\n");
                    } else {
                        switch (line.lineType) {
                            case 7: {
                                sbuf.append("chs.setHiLoCloseSeries(");
                                break;
                            }
                            case 8: {
                                sbuf.append("chs.setOpenHiLoCloseSeries(");
                                break;
                            }
                            case 9: {
                                sbuf.append("chs.setCandlestickSeries(");
                            }
                        }
                        sbuf.append(this.emitSeriesName(line));
                        sbuf.append(this.emitYValsStock(line));
                    }
                } else {
                    sbuf.append("chs.setYSeries(");
                    sbuf.append(this.emitSeriesName(line));
                    sbuf.append(this.wrapdoubleArray(line.xval_orig));
                    sbuf.append(", ");
                    sbuf.append(this.wrapdoubleArray(line.yval));
                    sbuf.append(");\n");
                }
                sbuf.append(this.emitLineType(line));
                switch (line.lineType) {
                    case 1: 
                    case 4: {
                        sbuf.append("// Series Color \n");
                        sbuf.append("chs.setSeriesColor(");
                        sbuf.append(this.emitSeriesName(line));
                        sbuf.append(this.emitColor(line.color));
                        sbuf.append(");\n");
                        break;
                    }
                    case 2: 
                    case 3: {
                        sbuf.append("\n");
                        sbuf.append("//\n");
                        sbuf.append("// Area Descriptor \n");
                        String desc = "desc_" + Integer.toString(k) + "_" + Integer.toString(s);
                        sbuf.append("AreaDesc ");
                        sbuf.append(desc);
                        sbuf.append(" = new AreaDesc();\n");
                        sbuf.append(desc);
                        sbuf.append(".setLineColor(");
                        sbuf.append(this.emitNewColor(line.color));
                        sbuf.append(");\n");
                        sbuf.append(desc);
                        sbuf.append(".setAreaColor(");
                        sbuf.append(this.emitNewColor(line.color2));
                        sbuf.append(");\n");
                        sbuf.append(desc);
                        sbuf.append(".setLineWidth(");
                        sbuf.append(line.width);
                        sbuf.append(");\n");
                        sbuf.append("chs.setSeriesGraphic(");
                        sbuf.append(this.emitSeriesName(line));
                        sbuf.append(desc);
                        sbuf.append(");\n");
                        sbuf.append("\n");
                    }
                }
                ++s;
            }
            ++k;
        }
        if (this.AnnoV != null && this.AnnoV.size() > 0) {
            sbuf.append("// Annotations \n");
            sbuf.append("int length = 0;\n");
            AxisCore.AnnoElement A = (AxisCore.AnnoElement)this.AnnoV.elementAt(0);
            int k2 = 0;
            while (k2 < this.Ch.SC.size()) {
                AxisCore.SubChartDescription sc = (AxisCore.SubChartDescription)this.Ch.SC.elementAt(k2);
                int s = 0;
                while (s < sc.plotLineDes.size()) {
                    line = (LineDescription)sc.plotLineDes.elementAt(s);
                    boolean seriesCount = false;
                    int count = 0;
                    int i = 0;
                    while (i < this.AnnoV.size()) {
                        A = (AxisCore.AnnoElement)this.AnnoV.elementAt(i);
                        if (line.seriesName == A.lineD.seriesName) {
                            ++count;
                        }
                        ++i;
                    }
                    if (count != 0) {
                        sbuf.append("length = ");
                        sbuf.append(count);
                        sbuf.append(";\n");
                        A = (AxisCore.AnnoElement)this.AnnoV.elementAt(0);
                        String annoDateName = "annoDate" + Integer.toString(s);
                        String annoValName = "annoVal" + Integer.toString(s);
                        if (A.tstamp != null) {
                            sbuf.append("java.util.Date " + annoDateName + "[] = new java.util.Date[length];\n");
                        } else if (A.xval != -1.0) {
                            sbuf.append("double " + annoValName + "[] = new double[length];\n");
                        } else if (A.index != -1) {
                            sbuf.append("int " + annoValName + "[] = new int[length];\n");
                        }
                        String labelAnnoName = "labelAnno" + Integer.toString(s);
                        sbuf.append("String " + labelAnnoName + "[] = new String[length];\n");
                        count = 0;
                        int i2 = 0;
                        while (i2 < this.AnnoV.size()) {
                            A = (AxisCore.AnnoElement)this.AnnoV.elementAt(i2);
                            if (line.seriesName == A.lineD.seriesName) {
                                if (A.tstamp != null) {
                                    sbuf.append(annoDateName + "[");
                                    sbuf.append(count);
                                    sbuf.append("] = ");
                                    sbuf.append(this.wrapDate(A.tstamp));
                                    sbuf.append(";\n");
                                } else if (A.xval != -1.0) {
                                    sbuf.append(annoValName + "[");
                                    sbuf.append(count);
                                    sbuf.append("] = ");
                                    sbuf.append(A.xval);
                                    sbuf.append(";\n");
                                } else if (A.index != -1) {
                                    sbuf.append(annoValName + "[");
                                    sbuf.append(count);
                                    sbuf.append("] = ");
                                    sbuf.append(A.index);
                                    sbuf.append("\";\n");
                                }
                                sbuf.append(labelAnnoName + "[");
                                sbuf.append(count);
                                sbuf.append("] = ");
                                sbuf.append("\"");
                                sbuf.append(A.text);
                                sbuf.append("\";\n");
                                ++count;
                            }
                            ++i2;
                        }
                        sbuf.append("chs.setSeriesAnnotations(");
                        sbuf.append("\"");
                        sbuf.append(line.seriesName);
                        sbuf.append("\", ");
                        A = (AxisCore.AnnoElement)this.AnnoV.elementAt(0);
                        if (A.tstamp != null) {
                            sbuf.append(annoDateName + ", ");
                        } else if (A.xval != -1.0) {
                            sbuf.append(annoValName + ", ");
                        } else if (A.index != -1) {
                            sbuf.append(annoValName + ", ");
                        }
                        sbuf.append(labelAnnoName);
                        sbuf.append(");\n");
                    }
                    ++s;
                }
                ++k2;
            }
        }
        sbuf.append("chs.getLegendDesc().setLegendAlignment(");
        int legAlign = this.SubChZero.L2.getLegendDesc().getLegendAlignment();
        switch (legAlign) {
            case -1: {
                sbuf.append("LegendDesc.DERIVED");
                break;
            }
            case 7: {
                sbuf.append("LegendDesc.NORTH");
                break;
            }
            case 9: {
                sbuf.append("LegendDesc.NORTHWEST");
                break;
            }
            case 8: {
                sbuf.append("LegendDesc.NORTHEAST");
                break;
            }
            case 4: {
                sbuf.append("LegendDesc.SOUTH");
                break;
            }
            case 6: {
                sbuf.append("LegendDesc.SOUTHWEST");
                break;
            }
            case 5: {
                sbuf.append("LegendDesc.SOUTHEAST");
                break;
            }
            case 3: {
                sbuf.append("LegendDesc.EAST");
                break;
            }
            case 2: {
                sbuf.append("LegendDesc.WEST");
                break;
            }
            case 10: {
                sbuf.append("LegendDesc.EASTBASELINE");
                break;
            }
            case 0: {
                sbuf.append("LegendDesc.USERDEFINED");
            }
        }
        sbuf.append(");\n");
        return sbuf.toString();
    }

    private String emitYValsStock(LineDescription line) {
        StringBuffer sbuf = new StringBuffer();
        switch (line.lineType) {
            case 7: {
                break;
            }
            case 8: {
                sbuf.append(this.wrapdoubleArray(line.yopen));
                sbuf.append(", ");
                break;
            }
            case 9: {
                sbuf.append(this.wrapdoubleArray(line.yopen));
                sbuf.append(", ");
            }
        }
        sbuf.append(this.wrapdoubleArray(line.yhigh));
        sbuf.append(", ");
        sbuf.append(this.wrapdoubleArray(line.ylow));
        sbuf.append(", ");
        sbuf.append(this.wrapdoubleArray(line.yclose));
        sbuf.append(");\n");
        return sbuf.toString();
    }

    private String emitSeriesName(LineDescription line) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("\"" + line.seriesName + "\"");
        sbuf.append(", ");
        return sbuf.toString();
    }

    private String emitLineType(LineDescription line) {
        StringBuffer sbuf = new StringBuffer();
        if (this.Ch.vertical) {
            switch (line.lineType) {
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 9: {
                    sbuf.append("chs.setSeriesGraphType(");
                    sbuf.append("\"" + line.seriesName + "\"");
                    sbuf.append(", ");
                }
            }
            switch (line.lineType) {
                case 7: {
                    break;
                }
                case 8: {
                    break;
                }
                case 9: {
                    sbuf.append("AxisChart.CANDLESTICK");
                    break;
                }
                case 4: {
                    sbuf.append("AxisChart.BAR");
                    break;
                }
                case 5: {
                    sbuf.append("AxisChart.BAR_STACKED");
                    break;
                }
                case 3: {
                    sbuf.append("AxisChart.AREA_CUMULATIVE");
                    break;
                }
                case 2: {
                    sbuf.append("AxisChart.AREA");
                    break;
                }
                case 0: {
                    break;
                }
            }
            switch (line.lineType) {
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 9: {
                    sbuf.append(")\n");
                }
            }
        }
        return sbuf.toString();
    }

    public AnnotationDesc getAnnotationDesc() {
        return super.getAnnotationDesc();
    }

    protected void setXSeriesInternal(java.util.Date[] tstamps, int length) throws ChartException {
        String fcn = "setXSeries()";
        if (!this.Ch.vertical) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-162"));
        }
        if (this.Ch.labelXCount != 0 || this.Ch.TStampsCount != 0) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-149"));
        }
        if (tstamps.length == 0) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-150"));
        }
        if (tstamps[0] == null) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-146"));
        }
        this.Ch.TStamps = new java.util.Date[length];
        this.Ch.TStamps[0] = tstamps[0];
        this.checkAscendingDatesAndCopy(fcn, tstamps, length);
        this.Ch.TStampsCount = length;
        this.Ch.containsTStamps = true;
        if (this.Ch.XAxisCount == 0 || this.Ch.XAxisCount < this.Ch.TStampsCount) {
            this.Ch.XAxisCount = length;
        }
        this.initChartX();
        this.TimeAxisCont = new TimeAxisContinuous(tstamps[0], tstamps[length - 1]);
        this.loadAxisTimeBandsVector();
    }

    public void setXSeries(String[] labels) throws ChartException {
        String fcn = "setXSeries()";
        if (this.Ch.labelXCount != 0 || this.Ch.TStampsCount != 0) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-149"));
        }
        if (labels == null) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-151"));
        }
        if (labels.length == 0) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-151"));
        }
        this.Ch.labelXCount = labels.length;
        if (this.Ch.genImageMapCoords) {
            this.Ch.imageMapCoords = new int[this.Ch.labelXCount][0];
        }
        if (this.Ch.XAxisCount == 0 || this.Ch.XAxisCount < this.Ch.labelXCount) {
            this.Ch.XAxisCount = this.Ch.labelXCount;
        }
        this.Ch.containsXLabels = true;
        this.Ch.XStringLabel = new String[this.Ch.labelXCount];
        int i = 0;
        while (i < this.Ch.labelXCount) {
            this.Ch.XStringLabel[i] = labels[i];
            ++i;
        }
        this.xval = new double[this.Ch.labelXCount];
        i = 0;
        while (i < this.Ch.labelXCount) {
            this.xval[i] = i;
            ++i;
        }
        this.initChartLabelX(labels[0]);
    }

    public void setUserXLabel(DateString[] dateString) throws ChartException {
        this.Ch.UserXLabel = new DateString[dateString.length];
        this.Ch.UserXLabelSet = true;
        java.util.Date[] tempDates = new java.util.Date[dateString.length];
        int i = 0;
        while (i < dateString.length) {
            tempDates[i] = dateString[i].tstamp;
            ++i;
        }
        this.checkAscendingDates("setUserXLabel()", tempDates, dateString.length);
        i = 0;
        while (i < dateString.length) {
            this.Ch.UserXLabel[i] = new DateString(dateString[i].tstamp, dateString[i].str);
            ++i;
        }
    }

    protected void initChartLabelX(String firstLabel) {
        this.xval_int = new int[this.Ch.labelXCount];
        this.xval_dbl = new double[this.Ch.labelXCount];
        this.xval_int_temp = new int[this.Ch.labelXCount];
        NumAxisRenderer yAxis = this.SubCh.YAxis1;
        if (!this.SubCh.YAxis1.userDefinedDescriptorSet) {
            try {
                if (this.isNotNumerical(firstLabel.toCharArray())) {
                    yAxis.yl.numAxisD.setLabelJustify(0);
                }
            }
            catch (ChartException e) {
                // empty catch block
            }
            this.copyNumAxisDescToGrid(yAxis, yAxis.yl.numAxisD);
        }
    }

    public void setSeriesDisableZeroSeries(boolean disable) {
        this.Ch.disableZeroSeries = disable;
    }

    public boolean getSeriesDisableZeroSeries() {
        return this.Ch.disableZeroSeries;
    }

    public void setYSeries(String seriesName, double[] yvalues) throws ChartException {
        String fcn = "setYSeries()";
        if (this.Ch.continuousTimeXAxis) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-255"));
        }
        if (yvalues == null) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-140"));
        }
        this.checkTimeStampsAndValues(yvalues.length);
        if (this.Ch.TStampsCount != 0) {
            this.setYSeries(seriesName, yvalues, this.Ch.TStamps[0], yvalues.length);
        } else {
            this.setYSeries(seriesName, yvalues, 0, yvalues.length);
        }
    }

    public void setYSeriesMultiColor(String seriesName, Color[] yColors) throws ChartException {
        String fcn = "setYSeriesMultiColor()";
        int s = this.LookupSeries(seriesName);
        if (s <= -1) {
            this.chartErrorSeriesNotFound(fcn, seriesName);
        }
        LineDescription line = (LineDescription)this.SubCh.plotLineDes.elementAt(s);
        line.multiColor = yColors;
    }

    public void setYSeries(String seriesName, double[] yvalues, int length) throws ChartException {
        String fcn = "setYSeries()";
        if (this.Ch.continuousTimeXAxis) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-255"));
        }
        if (yvalues == null) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-140"));
        }
        if (length > yvalues.length || length < 0) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-134"));
        }
        this.checkTimeStampsAndValues(yvalues.length);
        if (this.Ch.TStampsCount != 0) {
            this.setYSeries(seriesName, yvalues, this.Ch.TStamps[0], length);
        } else {
            this.setYSeries(seriesName, yvalues, 0, yvalues.length);
        }
    }

    public void setYSeries(String seriesName, double[] yvalues, java.util.Date startDate) throws ChartException {
        this.setYSeries(seriesName, yvalues, startDate, yvalues.length);
        System.out.println("Check Y values");
    }

    public void setYSeries(String seriesName, double[] yvalues, java.util.Date startDate, int length) throws ChartException {
        String fcn = "setYSeries()";
        if (this.Ch.continuousTimeXAxis) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-255"));
        }
        if (yvalues == null) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-140"));
        }
        this.checkTimeStampsAndValues(yvalues.length);
        this.checkDuplicateSeries(fcn, seriesName);
        if (this.checkLength(fcn, seriesName, length)) {
            LineDescription line = new LineDescription(seriesName, this.Ch.TStamps, this.Ch.genImageMapCoords, yvalues, startDate, length);
            this.initYSeries(seriesName, line);
        }
        this.Ch.regularFrequency = true;
    }

    protected void initYSeries(String seriesName, LineDescription line) throws ChartException {
        line.MinMax();
        this.SubCh.YAxis1.yAxisMet.assignGlobalMinMax(line.ymin, line.ymax);
        this.SubCh.plotLineDes.addElement(line);
        this.copyLineDesc(line, new LineDesc());
        if (!this.Ch.vertical) {
            if (!line.userDefinedDescriptorSet) {
                this.copyBarDesc(line, new BarDesc());
                this.SubChZero.L2.setLegendItemColor(seriesName, line.color);
            }
            this.checkNeg();
        }
        if (!this.SubChZero.L2.getLegendDesc().getLegendDisable()) {
            if (this.Ch.perSubchartLegend) {
                this.SubCh.L2.setAddLegendItem(seriesName, line.color);
            } else {
                this.SubChZero.L2.setAddLegendItem(seriesName, line.color);
            }
        }
    }

    private void setYSeries(String seriesName, double[] yvalues, int startDateIndex, int length) throws ChartException {
        String fcn = "setYSeries()";
        if (this.Ch.continuousTimeXAxis) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-255"));
        }
        if (this.Ch.labelXCount == 0) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-115"));
        }
        if (yvalues == null) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-140"));
        }
        if (yvalues.length == 0) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-140"));
        }
        this.checkDuplicateSeries(fcn, seriesName);
        if (this.checkLength2("setYSeries()", seriesName, length)) {
            LineDescription line = new LineDescription(seriesName, this.Ch.labelXCount, this.Ch.genImageMapCoords, yvalues, startDateIndex, length);
            this.initYSeries(seriesName, line);
        }
    }

    public void setYSeriesEmpty(String seriesName) throws ChartException {
        this.checkDuplicateSeries("setYSeries()", seriesName);
        LineDescription line = new LineDescription(seriesName, this.Ch.genImageMapCoords);
        this.initYSeries(seriesName, line);
        AxisCore.SubChartDescription sc = (AxisCore.SubChartDescription)this.Ch.SC.elementAt(0);
        sc.emptyYSeries = true;
    }

    public void setYSeriesEmpty(String seriesName, int lineType) throws ChartException {
        this.checkDuplicateSeries("setYSeries()", seriesName);
        LineDescription line = new LineDescription(seriesName, this.Ch.genImageMapCoords);
        this.initYSeries(seriesName, line);
        AxisCore.SubChartDescription sc = (AxisCore.SubChartDescription)this.Ch.SC.elementAt(0);
        sc.emptyYSeries = true;
        if (this.isBarType(lineType)) {
            System.out.println(" ** setYSeriesEmpty() isBarType ");
            this.SubCh.containsBarType = true;
            this.Ch.containsBarType = true;
        }
    }

    public void setXSeries(double minVal, double maxVal, NumberFormat nf) throws ChartException {
        String fcn = "setXSeries()";
        if (this.Ch.labelXCount != 0 || this.Ch.TStampsCount != 0 || this.Ch.xAxisSpanVal != -1.0) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-149"));
        }
        if (minVal > maxVal) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-098"));
        }
        if (nf != null) {
            this.Ch.numXAxisNF = nf;
        }
        this.Ch.xAxisStartVal = minVal;
        this.Ch.xAxisEndVal = maxVal;
        this.Ch.xAxisSpanVal = maxVal - minVal;
        this.Ch.NumXAxis.yAxisMet.Ymin = minVal;
        this.Ch.NumXAxis.yAxisMet.Ymax = maxVal;
        this.Ch.NumXAxis.yAxisMet.Ymin_non_adjusted = minVal;
        this.Ch.NumXAxis.yAxisMet.Ymax_non_adjusted = maxVal;
        this.Ch.NumXAxis.yAxisMet.y_coordinate_spread = this.Ch.xAxisSpanVal;
        this.Ch.NumXAxis.yAxisMet.AutoExtentMin = false;
        this.Ch.NumXAxis.yAxisMet.AutoExtentMax = false;
    }

    public void setYSeries(String seriesName, double[] xvalues, double[] yvalues) throws ChartException {
        String fcn = "setYSeries()";
        if (this.Ch.xAxisSpanVal == -1.0) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-142"));
        }
        if (xvalues == null) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-139"));
        }
        if (yvalues == null) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-140"));
        }
        if (xvalues.length != yvalues.length) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-138"));
        }
        this.checkDuplicateSeries(fcn, seriesName);
        LineDescription line = new LineDescription(seriesName, this.Ch.genImageMapCoords, yvalues, yvalues.length);
        line.MinMax();
        this.SubCh.YAxis1.yAxisMet.assignGlobalMinMax(line.ymin, line.ymax);
        line.createContinuousNumerical(xvalues, this.Ch.xAxisStartVal, this.Ch.xAxisSpanVal);
        this.initYSeries(seriesName, line);
        this.Ch.continuousNumXAxis = true;
    }

    public void setYSeriesAxis2(String seriesName) throws ChartException {
        int s;
        String fcn = "setYSeriesAxis2()";
        if (!this.Ch.containsTStamps && !this.Ch.containsXLabels) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-114"));
        }
        if ((s = this.LookupSeries(seriesName)) <= -1) {
            this.chartErrorSeriesNotFound(fcn, seriesName);
        }
        if (s >= 0) {
            LineDescription line = (LineDescription)this.SubCh.plotLineDes.elementAt(s);
            line.axisPrimary = false;
            this.SubCh.YAxis2.yAxisMet.assignGlobalMinMax(line.ymin, line.ymax);
            this.SubCh.dualAxis = true;
            this.Ch.dualAxis = true;
            if (!this.SubCh.YAxis2.userDefinedDescriptorSet) {
                this.SubCh.YAxis2.yl.numAxisD.setColor(this.getForeground());
            }
            this.SubCh.YAxis2.yl.numAxisD.setLabelLocation(1);
            boolean firstPrimary = true;
            int i = 0;
            while (i < this.SubCh.plotLineDes.size()) {
                line = (LineDescription)this.SubCh.plotLineDes.elementAt(i);
                if (line.axisPrimary) {
                    if (firstPrimary) {
                        this.SubCh.YAxis1.yAxisMet.initGlobalMinMax();
                    }
                    this.SubCh.YAxis1.yAxisMet.assignGlobalMinMax(line.ymin, line.ymax);
                    firstPrimary = false;
                }
                ++i;
            }
        }
    }

    public void setHiLoCloseSeries(String seriesName, double[] yhigh, double[] ylow, double[] yclose) throws ChartException {
        if (this.Ch.TStampsCount != 0) {
            this.setHiLoCloseSeries(seriesName, yhigh, ylow, yclose, this.Ch.TStamps[0]);
        } else {
            this.setHiLoCloseSeries(seriesName, yhigh, ylow, yclose, 0);
        }
    }

    public void setOpenHiLoCloseSeries(String seriesName, double[] yopen, double[] yhigh, double[] ylow, double[] yclose) throws ChartException {
        if (this.Ch.TStampsCount != 0) {
            this.setOpenHiLoCloseSeries(seriesName, yopen, yhigh, ylow, yclose, this.Ch.TStamps[0], 8);
        } else {
            this.setOpenHiLoCloseSeriesSeq(seriesName, yopen, yhigh, ylow, yclose, 0, 8);
        }
    }

    public void setCandlestickSeries(String seriesName, double[] yopen, double[] yhigh, double[] ylow, double[] yclose) throws ChartException {
        if (this.Ch.TStampsCount != 0) {
            this.setOpenHiLoCloseSeries(seriesName, yopen, yhigh, ylow, yclose, this.Ch.TStamps[0], 9);
        } else {
            this.setOpenHiLoCloseSeriesSeq(seriesName, yopen, yhigh, ylow, yclose, 0, 9);
        }
    }

    public void setHiLoCloseSeries(String seriesName, double[] yhigh, double[] ylow, double[] yclose, java.util.Date startDate) throws ChartException {
        String fcn = "setHiLoCloseSeries()";
        this.checkDuplicateSeries(fcn, seriesName);
        if (yhigh.length == 0) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-140"));
        }
        this.checkHLCEqualLength(fcn, seriesName, yhigh.length, ylow.length, yclose.length);
        if (this.checkLength(fcn, seriesName, yhigh.length)) {
            LineDescription line = new LineDescription(seriesName, this.Ch.TStamps, this.Ch.genImageMapCoords, yhigh, ylow, yclose, startDate, yhigh.length);
            this.initHiLoCloseSeries(seriesName, line);
        }
    }

    public void setOpenHiLoCloseSeries(String seriesName, double[] yopen, double[] yhigh, double[] ylow, double[] yclose, java.util.Date startDate) throws ChartException {
        this.setOpenHiLoCloseSeries(seriesName, yopen, yhigh, ylow, yclose, startDate, 8);
    }

    public void setCandlestickSeries(String seriesName, double[] yopen, double[] yhigh, double[] ylow, double[] yclose, java.util.Date startDate) throws ChartException {
        this.setOpenHiLoCloseSeries(seriesName, yopen, yhigh, ylow, yclose, startDate, 9);
    }

    private void setHiLoCloseSeries(String seriesName, double[] yhigh, double[] ylow, double[] yclose, int startDateIndex) throws ChartException {
        String fcn = "setHiLoCloseSeries()";
        this.checkHLCEqualLength(fcn, seriesName, yhigh.length, ylow.length, yclose.length);
        if (this.Ch.labelXCount == 0) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-115"));
        }
        if (yhigh.length == 0) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-140"));
        }
        this.checkDuplicateSeries(fcn, seriesName);
        if (this.checkLength2(fcn, seriesName, yhigh.length)) {
            LineDescription line = new LineDescription(seriesName, this.Ch.TStamps, this.Ch.genImageMapCoords, yhigh, ylow, yclose, startDateIndex, yhigh.length);
            this.initHiLoCloseSeries(seriesName, line);
        }
    }

    protected void initHiLoCloseSeries(String seriesName, LineDescription line) throws ChartException {
        line.lineType = 7;
        line.MinMaxStock();
        this.SubCh.YAxis1.yAxisMet.assignGlobalMinMax(line.ymin, line.ymax);
        this.SubCh.plotLineDes.addElement(line);
        this.copyHiLoCloseDesc(line, new HiLoCloseDesc());
        if (!this.SubChZero.L2.getLegendDesc().getLegendDisable()) {
            this.SubChZero.L2.setAddLegendItem(seriesName, line.color);
        }
    }

    private void setOpenHiLoCloseSeries(String seriesName, double[] yopen, double[] yhigh, double[] ylow, double[] yclose, java.util.Date startDate, int lineType) throws ChartException {
        String fcn = lineType == 8 ? "setOpenHiLoCloseSeries()" : "setCandlestickSeries()";
        if (!this.Ch.vertical) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-162"));
        }
        this.checkDuplicateSeries(fcn, seriesName);
        this.checkOHLCEqualLength(fcn, seriesName, yopen.length, yhigh.length, ylow.length, yclose.length);
        if (this.checkLength(fcn, seriesName, yhigh.length)) {
            LineDescription line = new LineDescription(seriesName, this.Ch.TStamps, this.Ch.genImageMapCoords, yopen, yhigh, ylow, yclose, startDate, yhigh.length);
            line.lineType = lineType;
            this.initOpenHiLoCloseSeries(seriesName, line);
        }
        this.Ch.regularFrequency = true;
    }

    private void setOpenHiLoCloseSeriesSeq(String seriesName, double[] yopen, double[] yhigh, double[] ylow, double[] yclose, int startDateIndex, int lineType) throws ChartException {
        String fcn = "setOpenHiLoCloseSeries()";
        this.checkDuplicateSeries(fcn, seriesName);
        if (this.checkLength2(fcn, seriesName, yopen.length)) {
            LineDescription line = new LineDescription(seriesName, this.Ch.labelXCount, this.Ch.genImageMapCoords, yopen, yhigh, ylow, yclose, startDateIndex, yopen.length);
            line.lineType = lineType;
            this.initOpenHiLoCloseSeries(seriesName, line);
        }
        this.Ch.regularFrequency = true;
    }

    protected void initOpenHiLoCloseSeries(String seriesName, LineDescription line) throws ChartException {
        switch (line.lineType) {
            case 9: {
                this.copyCandlestickDesc(line, new CandlestickDesc());
                break;
            }
            case 8: {
                this.copyHiLoCloseDesc(line, new HiLoCloseDesc());
                break;
            }
        }
        line.MinMaxStock();
        this.SubCh.YAxis1.yAxisMet.assignGlobalMinMax(line.ymin, line.ymax);
        this.SubCh.plotLineDes.addElement(line);
        if (!this.SubChZero.L2.getLegendDesc().getLegendDisable()) {
            this.SubChZero.L2.setAddLegendItem(seriesName, line.color);
        }
    }

    public void setYSeriesSparse(String seriesName, java.util.Date[] tstamps, double[] yvalues) throws ChartException {
        String fcn = "setYSeriesSparse()";
        if (yvalues == null) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-140"));
        }
        this.checkDuplicateSeries(fcn, seriesName);
        if (tstamps.length != yvalues.length) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-131"));
        }
        int length = tstamps.length;
        this.checkAscendingDates(fcn, tstamps, length);
        if (!this.Ch.continuousTimeXAxis) {
            this.sparseErrorCheck(fcn, seriesName, tstamps, yvalues.length);
        }
        LineDescription line = !this.Ch.continuousTimeXAxis ? new LineDescription(seriesName, this.Ch.TStamps, this.Ch.genImageMapCoords, yvalues, tstamps[0], length) : new LineDescription(seriesName, this.Ch.genImageMapCoords, yvalues, yvalues.length);
        line.MinMax();
        this.SubCh.YAxis1.yAxisMet.assignGlobalMinMax(line.ymin, line.ymax);
        this.SubCh.plotLineDes.addElement(line);
        if (!this.SubChZero.L2.getLegendDesc().getLegendDisable()) {
            this.SubChZero.L2.setAddLegendItem(seriesName, line.color);
        }
        if (!this.Ch.continuousTimeXAxis) {
            line.createSparse(this.Ch.TStamps, tstamps);
            this.Ch.subFrequency = true;
        } else {
            line.createContinuous(tstamps, this.TimeAxisCont.xAxisStartMillis, this.TimeAxisCont.xAxisSpanMillis, this.TimeAxisCont.millisC);
        }
    }

    private void sparseErrorCheck(String fcn, String seriesName, java.util.Date[] tstamps, int yvalueLength) throws ChartException {
        this.checkTimeStampsAndValues(fcn, yvalueLength);
        int length = tstamps.length;
        if (this.Ch.TStampsCount < length) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-174"));
        }
        if (tstamps[length - 1].after(this.Ch.TStamps[this.Ch.TStampsCount - 1])) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-170"));
        }
        if (tstamps[0].before(this.Ch.TStamps[0])) {
            String error = MsgUtil.getMsg("CHT-171") + tstamps[0] + " " + MsgUtil.getMsg("CHT-175") + " " + this.Ch.TStamps[0] + ")";
            Errorfcn.chartError(fcn, error);
        }
        this.checkLength(fcn, seriesName, length);
        int sparseIndex = 0;
        int i = 0;
        while (i < this.Ch.TStampsCount) {
            if (!tstamps[sparseIndex].after(this.Ch.TStamps[i])) {
                ++sparseIndex;
            }
            if (sparseIndex >= length) break;
            if (!tstamps[sparseIndex].after(this.Ch.TStamps[i])) {
                Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-173") + tstamps[sparseIndex - 1] + ", " + tstamps[sparseIndex]);
            }
            ++i;
        }
    }

    public void setHiLoCloseSeriesSparse(String seriesName, java.util.Date[] tstamps, double[] yhigh, double[] ylow, double[] yclose) throws ChartException {
        String fcn = "setHiLoCloseSeriesSparse()";
        this.checkDuplicateSeries(fcn, seriesName);
        if (yhigh.length == 0) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-140"));
        }
        this.checkHLCEqualLength(fcn, seriesName, yhigh.length, ylow.length, yclose.length);
        if (tstamps.length != yhigh.length) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-131"));
        }
        int length = tstamps.length;
        this.checkAscendingDates(fcn, tstamps, length);
        if (!this.Ch.continuousTimeXAxis) {
            this.sparseErrorCheck(fcn, seriesName, tstamps, yhigh.length);
        }
        if (!this.Ch.continuousTimeXAxis) {
            if (this.checkLength(fcn, seriesName, yhigh.length)) {
                LineDescription line = new LineDescription(seriesName, this.Ch.TStamps, this.Ch.genImageMapCoords, yhigh, ylow, yclose, this.Ch.TStamps[0], yhigh.length);
                this.initHiLoCloseSeries(seriesName, line);
                line.createSparse(this.Ch.TStamps, tstamps);
                this.Ch.subFrequency = true;
            }
        } else {
            LineDescription line = new LineDescription(seriesName, this.Ch.genImageMapCoords, yhigh, ylow, yclose, yhigh.length);
            this.initHiLoCloseSeries(seriesName, line);
            line.createContinuous(tstamps, this.TimeAxisCont.xAxisStartMillis, this.TimeAxisCont.xAxisSpanMillis, this.TimeAxisCont.millisC);
        }
    }

    public void setOpenHiLoCloseSeriesSparse(String seriesName, java.util.Date[] tstamps, double[] yopen, double[] yhigh, double[] ylow, double[] yclose) throws ChartException {
        this.setOpenHiLoCloseSeriesSparse(seriesName, tstamps, yopen, yhigh, ylow, yclose, 8);
    }

    public void setCandlestickSeriesSparse(String seriesName, java.util.Date[] tstamps, double[] yopen, double[] yhigh, double[] ylow, double[] yclose) throws ChartException {
        this.setOpenHiLoCloseSeriesSparse(seriesName, tstamps, yopen, yhigh, ylow, yclose, 9);
    }

    private void setOpenHiLoCloseSeriesSparse(String seriesName, java.util.Date[] tstamps, double[] yopen, double[] yhigh, double[] ylow, double[] yclose, int lineType) throws ChartException {
        String fcn = lineType == 8 ? "setOpenHiLoCloseSeries()" : "setCandlestickSeries()";
        this.checkDuplicateSeries(fcn, seriesName);
        if (yhigh.length == 0) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-140"));
        }
        this.checkOHLCEqualLength(fcn, seriesName, yopen.length, yhigh.length, ylow.length, yclose.length);
        if (tstamps.length != yhigh.length) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-131"));
        }
        int length = tstamps.length;
        this.checkAscendingDates(fcn, tstamps, length);
        if (!this.Ch.continuousTimeXAxis) {
            this.sparseErrorCheck(fcn, seriesName, tstamps, yhigh.length);
        }
        if (!this.Ch.continuousTimeXAxis) {
            if (this.checkLength(fcn, seriesName, yhigh.length)) {
                LineDescription line = new LineDescription(seriesName, this.Ch.TStamps, this.Ch.genImageMapCoords, yopen, yhigh, ylow, yclose, this.Ch.TStamps[0], yhigh.length);
                line.lineType = lineType;
                this.initOpenHiLoCloseSeries(seriesName, line);
                line.createSparse(this.Ch.TStamps, tstamps);
                this.Ch.subFrequency = true;
            }
        } else {
            LineDescription line = new LineDescription(seriesName, this.Ch.genImageMapCoords, yopen, yhigh, ylow, yclose, yhigh.length);
            line.lineType = lineType;
            this.initOpenHiLoCloseSeries(seriesName, line);
            line.createContinuous(tstamps, this.TimeAxisCont.xAxisStartMillis, this.TimeAxisCont.xAxisSpanMillis, this.TimeAxisCont.millisC);
        }
    }

    public void setSubchartLegendLayout(boolean perSubchartLegend) {
        this.Ch.perSubchartLegend = true;
    }

    public boolean getSubchartLegendLayout() {
        return this.Ch.perSubchartLegend;
    }

    public void setSubChartHeightFraction(String subchartName, double fract) throws ChartException {
        int s = this.LookupSubChart(subchartName);
        if (s <= -1) {
            this.chartErrorSubchartNotFound("setSubChartHeightFraction()", subchartName);
        }
        if (fract < 0.0 || fract > 1.0) {
            return;
        }
        AxisCore.SubChartDescription sc = (AxisCore.SubChartDescription)this.Ch.SC.elementAt(s);
        sc.heightFraction = fract;
        if (this.Ch.SC.size() == 2) {
            int t = s == 0 ? 1 : 0;
            sc = (AxisCore.SubChartDescription)this.Ch.SC.elementAt(t);
            sc.heightFraction = 1.0 - fract;
        }
        this.resetDisplaySize();
    }

    public void setSubChartSeparatorHeight(int height) {
        if (height > -1 && height < this.Ch.displayHeight) {
            this.Ch.subchartSeparatorHeight = height;
        }
    }

    public void setSubChart(String subchartName) {
        if (this.Ch.vertical) {
            int s = this.LookupSubChart(subchartName);
            if (s >= 0) {
                this.SubCh = (AxisCore.SubChartDescription)this.Ch.SC.elementAt(s);
                return;
            }
            AxisCore.SubChartDescription sc = new AxisCore.SubChartDescription();
            this.Ch.SC.addElement(sc);
            this.SCIndex = this.Ch.SC.size() - 1;
            sc.subchart_name = subchartName;
            this.SubCh = sc;
            this.copyDefaultDesc(this.SubCh);
            if (this.SCIndex > 0) {
                int i = 0;
                while (i < this.Ch.SC.size()) {
                    sc = (AxisCore.SubChartDescription)this.Ch.SC.elementAt(i);
                    sc.heightFraction = 1.0 / (double)this.Ch.SC.size();
                    ++i;
                }
            }
            this.resetDisplaySize();
        }
    }

    public String[] getSubChartNames() {
        String[] allSubcharts = new String[this.Ch.SC.size()];
        int k = 0;
        while (k < this.Ch.SC.size()) {
            AxisCore.SubChartDescription sc = (AxisCore.SubChartDescription)this.Ch.SC.elementAt(k);
            allSubcharts[k] = sc.subchart_name;
            ++k;
        }
        return allSubcharts;
    }

    public String[] getSeriesNames(String subChartName) {
        AxisCore.SubChartDescription sc = this.getSubChart(subChartName);
        if (sc == null) {
            return null;
        }
        int numNames = sc.plotLineDes.size();
        String[] seriesNames = new String[numNames];
        int s = 0;
        while (s < numNames) {
            LineDescription line = (LineDescription)sc.plotLineDes.elementAt(s);
            seriesNames[s] = line.seriesName;
            ++s;
        }
        return seriesNames;
    }

    public String[] getSeriesNames() {
        AxisCore.SubChartDescription sc;
        int seriesCount = 0;
        int k = 0;
        while (k < this.Ch.SC.size()) {
            sc = (AxisCore.SubChartDescription)this.Ch.SC.elementAt(k);
            int s = 0;
            while (s < sc.plotLineDes.size()) {
                ++seriesCount;
                ++s;
            }
            ++k;
        }
        String[] seriesNames = new String[seriesCount];
        int seriesIndex = 0;
        int k2 = 0;
        while (k2 < this.Ch.SC.size()) {
            sc = (AxisCore.SubChartDescription)this.Ch.SC.elementAt(k2);
            int s = 0;
            while (s < sc.plotLineDes.size()) {
                LineDescription line = (LineDescription)sc.plotLineDes.elementAt(s);
                seriesNames[seriesIndex++] = line.seriesName;
                ++s;
            }
            ++k2;
        }
        return seriesNames;
    }

    private void printSubChart() {
        int i = 0;
        while (i < this.Ch.SC.size()) {
            AxisCore.SubChartDescription sc = (AxisCore.SubChartDescription)this.Ch.SC.elementAt(i);
            System.out.println("Subchart " + sc.subchart_name + " " + sc.heightFraction);
            System.out.println("Subchart YO " + sc.YOrigin);
            ++i;
        }
    }

    protected void chartErrorSeriesNotFound(String functionName, String seriesName) throws ChartException {
        throw new ChartException(MsgUtil.getMsg("CHT-500") + functionName + ": " + MsgUtil.getMsg("CHT-100") + " \"" + seriesName + "\" " + MsgUtil.getMsg("CHT-101"));
    }

    protected void checkDuplicateSubchart(String functionName, String subchartName) throws ChartException {
        int s = this.LookupSubChart(subchartName);
        if (s != -1) {
            throw new ChartException(MsgUtil.getMsg("CHT-500") + functionName + " " + MsgUtil.getMsg("CHT-112") + "\"" + subchartName + "\"");
        }
    }

    protected void checkDuplicateSeries(String functionName, String seriesName) throws ChartException {
        int s = this.LookupSeries(seriesName);
        if (s != -1) {
            throw new ChartException(MsgUtil.getMsg("CHT-500") + functionName + " " + MsgUtil.getMsg("CHT-111") + "\"" + seriesName + "\"");
        }
    }

    protected void checkTimeStampsAndValues(int yvaluesLength) throws ChartException {
        if (this.Ch.TStampsCount == 0 && this.Ch.labelXCount == 0) {
            Errorfcn.chartError("setYSeries()", MsgUtil.getMsg("CHT-114"));
        }
        if (yvaluesLength == 0) {
            Errorfcn.chartError("setYSeries()", MsgUtil.getMsg("CHT-140"));
        }
    }

    protected void checkTimeStampsAndValues(String fcn, int yvaluesLength) throws ChartException {
        if (this.Ch.TStampsCount == 0 && this.Ch.labelXCount == 0) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-114"));
        }
        if (yvaluesLength == 0) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-140"));
        }
    }

    protected boolean checkLength(String fcn, String seriesName, int ylength) throws ChartException {
        if (ylength > this.Ch.TStampsCount) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-100") + " \"" + seriesName + "\" " + MsgUtil.getMsg("CHT-230") + " (" + ylength + " > " + this.Ch.TStampsCount + ")");
        }
        return true;
    }

    protected boolean checkLength2(String fcn, String seriesName, int ylength) throws ChartException {
        if (ylength > this.Ch.labelXCount) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-100") + " \"" + seriesName + "\" " + MsgUtil.getMsg("CHT-231") + " (" + ylength + " > " + this.Ch.labelXCount + ")");
        }
        return true;
    }

    protected void checkOHLCEqualLength(String fcn, String seriesName, int yopen_length, int yhigh_length, int ylow_length, int yclose_length) throws ChartException {
        if (yopen_length != yhigh_length || ylow_length != yclose_length || yopen_length != ylow_length) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-100") + " \"" + seriesName + "\" " + MsgUtil.getMsg("CHT-190"));
        }
    }

    protected void checkHLCEqualLength(String fcn, String seriesName, int yhigh_length, int ylow_length, int yclose_length) throws ChartException {
        if (yhigh_length != ylow_length || yhigh_length != yclose_length) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-100") + " \"" + seriesName + "\" " + MsgUtil.getMsg("CHT-191"));
        }
    }

    public void setSubChartBoundaryColor(Color c) {
        this.SubChartBoundaryColor = c;
        this.subChartBoundaryColorSet = true;
    }

    public Color getSubChartBoundaryColor() {
        return this.SubChartBoundaryColor;
    }

    public void setSubChartBoundaryEdgeColor(Color c) {
        this.SubChartBoundaryEdgeColor = c;
        this.subChartBoundaryEdgeColorSet = true;
    }

    public Color getSubChartBoundaryEdgeColor() {
        return this.SubChartBoundaryEdgeColor;
    }

    public void setSeriesColor(String seriesName, Color c) throws ChartException {
        int s = this.LookupSeries(seriesName);
        if (s <= -1) {
            this.chartErrorSeriesNotFound("setSeriesColor()", seriesName);
        }
        if (s >= 0) {
            LineDescription line = (LineDescription)this.SubCh.plotLineDes.elementAt(s);
            line.color = c;
            line.colorSelectivelySet = true;
            if (this.Ch.perSubchartLegend) {
                this.SubCh.L2.setLegendItemColor(seriesName, c);
            } else {
                this.SubChZero.L2.setLegendItemColor(seriesName, c);
            }
        }
    }

    public Color getSeriesColor(String seriesName) throws ChartException {
        int s = this.LookupSeries(seriesName);
        if (s <= -1) {
            this.chartErrorSeriesNotFound("getSeriesColor()", seriesName);
        }
        if (s >= 0) {
            LineDescription line = (LineDescription)this.SubCh.plotLineDes.elementAt(s);
            return line.color;
        }
        return null;
    }

    public void setSeriesColorPalette(Color[] c) throws ChartException {
        this.Ch.seriesColors = c;
    }

    public void setSeriesWidth(String seriesName, int k) throws ChartException {
        int s = this.LookupSeries(seriesName);
        if (s <= -1) {
            this.chartErrorSeriesNotFound("setSeriesWidth()", seriesName);
        }
        if (s >= 0) {
            LineDescription line = (LineDescription)this.SubCh.plotLineDes.elementAt(s);
            line.width = k;
            line.lineStroke = new BasicStroke(k, 0, 2);
            line.userDefinedThickness = true;
            line.widthSelectivelySet = true;
        }
    }

    public void setSeriesInLegend(String seriesName, boolean include) throws ChartException {
        int s = this.LookupSeries(seriesName);
        if (s <= -1) {
            this.chartErrorSeriesNotFound("setSeriesInLegend()", seriesName);
        }
        if (s >= 0) {
            LineDescription line = (LineDescription)this.SubCh.plotLineDes.elementAt(s);
            line.includeInLegend = include;
            if (!include) {
                this.SubChZero.L2.setDeleteLegendItem(line.seriesName);
            } else {
                this.SubChZero.L2.setAddLegendItem(line.seriesName, line.color);
            }
        }
    }

    public boolean getSeriesInLegend(String seriesName) throws ChartException {
        int s = this.LookupSeries(seriesName);
        if (s <= -1) {
            this.chartErrorSeriesNotFound("getSeriesInLegend()", seriesName);
        }
        if (s >= 0) {
            LineDescription line = (LineDescription)this.SubCh.plotLineDes.elementAt(s);
            return line.includeInLegend;
        }
        return false;
    }

    public void setSeriesGraphType(String seriesName, int lineType) throws ChartException {
        String fcn = "setSeriesGraphType()";
        int s = this.LookupSeries(seriesName);
        if (s <= -1) {
            this.chartErrorSeriesNotFound(fcn, seriesName);
        }
        if (s >= 0) {
            LineDescription line = (LineDescription)this.SubCh.plotLineDes.elementAt(s);
            if (this.isStockType(line.lineType) && !this.isStockType(lineType)) {
                Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-270"));
                return;
            }
            line.lineType = lineType;
            if (this.Ch.continuousTimeXAxis) {
                switch (lineType) {
                    case 5: {
                        break;
                    }
                }
            }
            switch (lineType) {
                case 2: {
                    if (line.userDefinedDescriptorSet) break;
                    this.copyAreaDesc(line, new AreaDesc());
                    this.SubChZero.L2.setLegendItemColor(seriesName, line.color2);
                    break;
                }
                case 3: {
                    this.SubCh.containsAreaCume = true;
                    this.Ch.containsAreaCume = true;
                    if (line.userDefinedDescriptorSet) break;
                    this.copyAreaDesc(line, new AreaDesc());
                    this.SubChZero.L2.setLegendItemColor(seriesName, line.color2);
                    break;
                }
                case 0: 
                case 1: {
                    if (line.userDefinedDescriptorSet) break;
                    this.copyLineDesc(line, new LineDesc());
                    this.SubChZero.L2.setLegendItemColor(seriesName, line.color);
                    if (line.lineType != 0) break;
                    line.markerType = 1;
                    line.lineStroke = this.LM.getLineStroke(line.lineStyle, 0.0f);
                    this.SubChZero.L2.setLegendItemMarker(seriesName, line.color, line.markerType, line.color3, line.lineStroke);
                    break;
                }
                case 4: 
                case 5: {
                    if (lineType == 5) {
                        this.SubCh.containsStackedBar = true;
                        this.Ch.containsStackedBar = true;
                    }
                    if (!line.userDefinedDescriptorSet) {
                        this.copyBarDesc(line, new BarDesc());
                        this.SubChZero.L2.setLegendItemColor(seriesName, line.color);
                    }
                    if (this.Ch.vertical) break;
                    this.checkNeg();
                }
            }
        }
        if (this.isBarType(lineType)) {
            this.SubCh.containsBarType = true;
            this.Ch.containsBarType = true;
        }
    }

    public int getSeriesGraphType(String seriesName) throws ChartException {
        String fcn = "getSeriesGraphType()";
        int s = this.LookupSeries(seriesName);
        if (s <= -1) {
            this.chartErrorSeriesNotFound(fcn, seriesName);
        }
        if (s >= 0) {
            LineDescription line = (LineDescription)this.SubCh.plotLineDes.elementAt(s);
            return line.lineType;
        }
        return -1;
    }

    public void setSeriesGraphic(String seriesName, AreaDesc desc) throws ChartException {
        String fcn = "setSeriesGraphic()";
        int s = this.LookupSeries(seriesName);
        if (s <= -1) {
            this.chartErrorSeriesNotFound(fcn, seriesName);
        }
        if (desc == null) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-240"));
        }
        if (s >= 0) {
            LineDescription line = (LineDescription)this.SubCh.plotLineDes.elementAt(s);
            this.copyAreaDesc(line, desc);
            line.userDefinedDescriptorSet = true;
            line.lineType = 2;
            this.SubChZero.L2.setLegendItemColor(seriesName, line.color2);
        }
    }

    public AreaDesc getSeriesAreaDesc(String seriesName) throws ChartException {
        String fcn = "getSeriesAreaDesc()";
        int s = this.LookupSeries(seriesName);
        if (s <= -1) {
            this.chartErrorSeriesNotFound(fcn, seriesName);
        }
        AreaDesc desc = new AreaDesc();
        if (s >= 0) {
            LineDescription line = (LineDescription)this.SubCh.plotLineDes.elementAt(s);
            this.copyBackAreaDesc(desc, line);
        }
        return desc;
    }

    public void setSeriesGraphic(String seriesName, BarDesc desc) throws ChartException {
        String fcn = "setSeriesGraphic()";
        int s = this.LookupSeries(seriesName);
        if (s <= -1) {
            this.chartErrorSeriesNotFound(fcn, seriesName);
        }
        if (desc == null) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-240"));
        }
        if (s >= 0) {
            LineDescription line = (LineDescription)this.SubCh.plotLineDes.elementAt(s);
            this.copyBarDesc(line, desc);
            line.userDefinedDescriptorSet = true;
            if (!this.isBarType(line.lineType)) {
                line.lineType = 4;
            }
            this.SubChZero.L2.setLegendItemColor(seriesName, line.color);
        }
    }

    public void setSubChartSeparatorStyleDesc(SubChartSeparatorStyleDesc scStyle) {
        this.subChartSeparatorStyleDesc = scStyle;
        this.Ch.subchartSeparatorHeight = scStyle.getHeight();
    }

    public SubChartSeparatorStyleDesc getSubChartSeparatorStyleDesc() {
        return this.subChartSeparatorStyleDesc;
    }

    public BarDesc getSeriesBarDesc(String seriesName) throws ChartException {
        String fcn = "getSeriesBarDesc()";
        int s = this.LookupSeries(seriesName);
        if (s <= -1) {
            this.chartErrorSeriesNotFound(fcn, seriesName);
        }
        BarDesc desc = new BarDesc();
        if (s >= 0) {
            LineDescription line = (LineDescription)this.SubCh.plotLineDes.elementAt(s);
            this.copyBackBarDesc(desc, line);
        }
        return desc;
    }

    public void setSeriesGraphic(String seriesName, CandlestickDesc desc) throws ChartException {
        String fcn = "setSeriesGraphic()";
        int s = this.LookupSeries(seriesName);
        if (s <= -1) {
            this.chartErrorSeriesNotFound(fcn, seriesName);
        }
        if (desc == null) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-240"));
        }
        if (s >= 0) {
            LineDescription line = (LineDescription)this.SubCh.plotLineDes.elementAt(s);
            line.userDefinedDescriptorSet = true;
            this.copyCandlestickDesc(line, desc);
            this.SubChZero.L2.setLegendItemColor(seriesName, line.color);
        }
    }

    public CandlestickDesc getSeriesCandlestickDesc(String seriesName) throws ChartException {
        String fcn = "getSeriesCandelestickDesc()";
        int s = this.LookupSeries(seriesName);
        if (s <= -1) {
            this.chartErrorSeriesNotFound(fcn, seriesName);
        }
        CandlestickDesc desc = new CandlestickDesc();
        if (s >= 0) {
            LineDescription line = (LineDescription)this.SubCh.plotLineDes.elementAt(s);
            this.copyBackCandlestickDesc(desc, line);
        }
        return desc;
    }

    public void setSeriesGraphic(String seriesName, HiLoCloseDesc desc) throws ChartException {
        String fcn = "setSeriesGraphic()";
        int s = this.LookupSeries(seriesName);
        if (s <= -1) {
            this.chartErrorSeriesNotFound(fcn, seriesName);
        }
        if (desc == null) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-240"));
        }
        if (s >= 0) {
            LineDescription line = (LineDescription)this.SubCh.plotLineDes.elementAt(s);
            line.userDefinedDescriptorSet = true;
            this.copyHiLoCloseDesc(line, desc);
            this.SubChZero.L2.setLegendItemColor(seriesName, line.color);
        }
    }

    public HiLoCloseDesc getSeriesHiLoCloseDesc(String seriesName) throws ChartException {
        String fcn = "getSeriesHiLoCloseDesc()";
        int s = this.LookupSeries(seriesName);
        if (s <= -1) {
            this.chartErrorSeriesNotFound(fcn, seriesName);
        }
        HiLoCloseDesc desc = new HiLoCloseDesc();
        if (s >= 0) {
            LineDescription line = (LineDescription)this.SubCh.plotLineDes.elementAt(s);
            this.copyBackHiLoCloseDesc(desc, line);
        }
        return desc;
    }

    public void setSeriesGraphic(String seriesName, LineDesc desc) throws ChartException {
        String fcn = "setSeriesGraphic()";
        int s = this.LookupSeries(seriesName);
        if (s <= -1) {
            this.chartErrorSeriesNotFound(fcn, seriesName);
        }
        if (desc == null) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-240"));
        }
        if (s >= 0) {
            LineDescription line = (LineDescription)this.SubCh.plotLineDes.elementAt(s);
            this.copyLineDesc(line, desc);
            line.userDefinedDescriptorSet = true;
            line.lineType = 1;
            if (this.isIntervalGraphic(line.lineType)) {
                this.SubChZero.L2.setLegendItemColor(seriesName, line.color);
            } else {
                this.SubChZero.L2.setLegendItemMarker(seriesName, line.color, line.markerType, line.color3, line.lineStroke);
            }
        }
    }

    public LineDesc getSeriesLineDesc(String seriesName) throws ChartException {
        String fcn = "getSeriesLineDesc()";
        int s = this.LookupSeries(seriesName);
        if (s <= -1) {
            this.chartErrorSeriesNotFound(fcn, seriesName);
        }
        LineDesc desc = new LineDesc();
        if (s >= 0) {
            LineDescription line = (LineDescription)this.SubCh.plotLineDes.elementAt(s);
            this.copyBackLineDesc(desc, line);
        }
        return desc;
    }

    public void setSVGAttributesSeries(String seriesName, SVGXLinkArrayDesc desc) throws ChartException {
        String fcn = "setSeriesSVGAttributes()";
        int s = this.LookupSeries(seriesName);
        if (s <= -1) {
            this.chartErrorSeriesNotFound(fcn, seriesName);
        }
        if (desc == null) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-240"));
        }
        if (s >= 0) {
            LineDescription line = (LineDescription)this.SubCh.plotLineDes.elementAt(s);
            line.svgSeriesD = desc;
        }
    }

    public void setSVGScriptLegend(String seriesName, String userScript) throws ChartException {
        String fcn = "setSVGScriptLegend()";
        int s = this.LookupSeries(seriesName);
        if (s <= -1) {
            this.chartErrorSeriesNotFound(fcn, seriesName);
        }
        if (userScript == null) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-240"));
        }
        if (s >= 0) {
            LineDescription line = (LineDescription)this.SubCh.plotLineDes.elementAt(s);
            this.SubChZero.L2.setLegendSVGScript(seriesName, userScript);
        }
    }

    public void setSVGScriptSeries(String seriesName, String userScript) throws ChartException {
        String fcn = "setSVGScriptSeries()";
        int s = this.LookupSeries(seriesName);
        if (s <= -1) {
            this.chartErrorSeriesNotFound(fcn, seriesName);
        }
        if (userScript == null) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-240"));
        }
        if (s >= 0) {
            LineDescription line = (LineDescription)this.SubCh.plotLineDes.elementAt(s);
            line.svgSeriesScript = userScript;
        }
    }

    public void setSVGAttributesSeries(String seriesName, SVGXLinkDesc desc) throws ChartException {
        String fcn = "setSeriesSVGAttributes()";
        int s = this.LookupSeries(seriesName);
        if (s <= -1) {
            this.chartErrorSeriesNotFound(fcn, seriesName);
        }
        if (desc == null) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-240"));
        }
        if (s >= 0) {
            LineDescription line = (LineDescription)this.SubCh.plotLineDes.elementAt(s);
            line.svgSeriesNameD = desc;
            if (line.svgSeriesNameD != null) {
                String href = line.svgSeriesNameD.getHRef();
                this.SubChZero.L2.setUpdateLegendItemXLink(seriesName, href);
            }
        }
    }

    public void setSVGAttributesStringLabels(SVGXLinkArrayDesc desc) throws ChartException {
        String fcn = "setSVGAttributesStringLabels()";
        this.Ch.svgXLinksStringLabel = desc;
    }

    public void setSeriesGraphic(String seriesName, MarkerDesc desc) throws ChartException {
        String fcn = "setSeriesGraphic()";
        int s = this.LookupSeries(seriesName);
        if (s <= -1) {
            this.chartErrorSeriesNotFound(fcn, seriesName);
        }
        if (desc == null) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-240"));
        }
        if (s >= 0) {
            LineDescription line = (LineDescription)this.SubCh.plotLineDes.elementAt(s);
            this.copyMarkerDesc(line, desc);
            line.userDefinedDescriptorSet = true;
            line.lineType = 0;
            this.SubChZero.L2.setLegendItemMarker(seriesName, line.color, line.markerType, line.color3, line.lineStroke);
        }
    }

    public MarkerDesc getSeriesMarkerDesc(String seriesName) throws ChartException {
        String fcn = "getSeriesMarkerDesc()";
        int s = this.LookupSeries(seriesName);
        if (s <= -1) {
            this.chartErrorSeriesNotFound(fcn, seriesName);
        }
        MarkerDesc desc = new MarkerDesc();
        if (s >= 0) {
            LineDescription line = (LineDescription)this.SubCh.plotLineDes.elementAt(s);
            this.copyBackMarkerDesc(desc, line);
        }
        return desc;
    }

    void copyCandlestickDesc(LineDescription line, CandlestickDesc desc) {
        if (!line.colorSelectivelySet) {
            line.color = desc.getShadowColor();
        }
        line.color2 = desc.getRealBodyColorDown();
        line.color3 = desc.getRealBodyColorUp();
        if (!line.widthSelectivelySet) {
            line.width = desc.getRealBodyWidth();
        }
        if (line.width == 0.0) {
            line.userDefinedThickness = false;
            line.BarThicknessPct = desc.getRealBodyWidthFraction();
        } else {
            line.userDefinedThickness = true;
        }
        line.width2 = desc.getShadowWidth();
    }

    void copyBackCandlestickDesc(CandlestickDesc desc, LineDescription line) {
        desc.setShadowColor(line.color);
        desc.setRealBodyColorDown(line.color2);
        desc.setRealBodyColorUp(line.color3);
        if (!line.userDefinedThickness) {
            desc.setRealBodyWidthFraction(line.BarThicknessPct);
        } else {
            desc.setRealBodyWidth((int)line.width);
        }
        desc.setShadowWidth(line.width2);
    }

    void checkNeg() {
        int hBars = 0;
        int s = 0;
        while (s < this.SubCh.plotLineDes.size()) {
            LineDescription line = (LineDescription)this.SubCh.plotLineDes.elementAt(s);
            if (line.lineType == 4) {
                ++hBars;
            }
            ++s;
        }
        if (hBars > 1) {
            int s2 = 0;
            while (s2 < this.SubCh.plotLineDes.size()) {
                LineDescription line = (LineDescription)this.SubCh.plotLineDes.elementAt(s2);
                if (line.lineType == 4) {
                    line.negativeColor = false;
                }
                ++s2;
            }
        }
    }

    public void setYAxisLabelsOff() throws ChartException {
        this.setYAxisLabelsOffInternal();
    }

    private void setYAxisLabelsOffInternal() throws ChartException {
        if (this.Ch.SC.size() < 1) {
            this.chartErrorSubchartNotFound("setYAxisLabelsOff()", "");
        }
        AxisCore.SubChartDescription sc = (AxisCore.SubChartDescription)this.Ch.SC.elementAt(0);
        this.setYAxisLabelsOffInternal(sc.subchart_name);
    }

    public void setYAxisLabelsOff(String subchartName) throws ChartException {
        if (this.Ch.vertical) {
            this.setYAxisLabelsOffInternal(subchartName);
        } else {
            Errorfcn.chartError("setYAxisLabelsOff()", MsgUtil.getMsg("CHT-232"));
        }
    }

    protected void setYAxisLabelsOffInternal(String subchartName) throws ChartException {
        int s = this.LookupSubChart(subchartName);
        if (s <= -1) {
            this.chartErrorSubchartNotFound("setYAxisLabelsOff()", subchartName);
        }
        AxisCore.SubChartDescription sc = (AxisCore.SubChartDescription)this.Ch.SC.elementAt(s);
        sc.YAxis1.yl.numAxisD.setDrawLabelOff();
        sc.YAxis2.yl.numAxisD.setDrawLabelOff();
    }

    public void setNumBand(NumBandDesc userNumBand) throws ChartException {
        if (this.Ch.SC.size() < 1) {
            this.chartErrorSubchartNotFound("setChartAttributes()", "");
        }
        AxisCore.SubChartDescription sc = (AxisCore.SubChartDescription)this.Ch.SC.elementAt(0);
        this.setNumBand(sc.subchart_name, userNumBand);
    }

    public void setNumBand(String subchartName, NumBandDesc userNumBand) {
        this.SubCh.plotNumBandDesc.addElement(userNumBand);
    }

    public void setNumThreshold(NumThresholdDesc userNumThreshold) throws ChartException {
        if (this.Ch.SC.size() < 1) {
            this.chartErrorSubchartNotFound("setChartAttributes()", "");
        }
        AxisCore.SubChartDescription sc = (AxisCore.SubChartDescription)this.Ch.SC.elementAt(0);
        this.setNumThreshold(sc.subchart_name, userNumThreshold);
    }

    public void setNumThreshold(String subchartName, NumThresholdDesc userNumThreshold) {
        this.SubCh.plotNumThresholdDesc.addElement(userNumThreshold);
    }

    public void setChartAttributes(NumAxisDesc userNumAxis) throws ChartException {
        if (this.Ch.SC.size() < 1) {
            this.chartErrorSubchartNotFound("setChartAttributes()", "");
        }
        AxisCore.SubChartDescription sc = (AxisCore.SubChartDescription)this.Ch.SC.elementAt(0);
        this.setChartAttributes(sc.subchart_name, userNumAxis);
    }

    public NumAxisDesc getNumAxisDesc() throws ChartException {
        if (this.Ch.SC.size() < 1) {
            this.chartErrorSubchartNotFound("setChartAttributes()", "");
        }
        AxisCore.SubChartDescription sc = (AxisCore.SubChartDescription)this.Ch.SC.elementAt(0);
        NumAxisRenderer yAxis = sc.YAxis1;
        return yAxis.yl.numAxisD;
    }

    public void setChartAttributes(String subchartName, NumAxisDesc userNumAxis) throws ChartException {
        NumAxisRenderer yAxis;
        int s = this.LookupSubChart(subchartName);
        if (s <= -1) {
            this.chartErrorSubchartNotFound("setChartAttributes()", subchartName);
        }
        AxisCore.SubChartDescription sc = (AxisCore.SubChartDescription)this.Ch.SC.elementAt(s);
        if (userNumAxis.getSecondAxis()) {
            yAxis = sc.YAxis2;
            sc.YAxis2.userDefinedDescriptorSet = true;
        } else {
            yAxis = sc.YAxis1;
            sc.YAxis1.userDefinedDescriptorSet = true;
        }
        this.copyNumAxisDesc(yAxis, userNumAxis);
    }

    public void setChartAttributesXAxis(NumAxisDesc userNumAxis) throws ChartException {
        this.copyNumAxisDesc(this.Ch.NumXAxis, userNumAxis);
    }

    public NumAxisDesc getChartAttributesXAxis() {
        return this.Ch.NumXAxis.yl.numAxisD;
    }

    public NumAxisDesc getNumAxisDesc(String subchartName) throws ChartException {
        int s = this.LookupSubChart(subchartName);
        if (s <= -1) {
            this.chartErrorSubchartNotFound("setChartAttributes()", subchartName);
        }
        AxisCore.SubChartDescription sc = (AxisCore.SubChartDescription)this.Ch.SC.elementAt(s);
        NumAxisRenderer yAxis = sc.YAxis1;
        return yAxis.yl.numAxisD;
    }

    public void setChartAttributes(String subchartName, GridDesc userGrid) throws ChartException {
        int s = this.LookupSubChart(subchartName);
        if (s <= -1) {
            this.chartErrorSubchartNotFound("setChartAttributes()", subchartName);
        }
        AxisCore.SubChartDescription sc = (AxisCore.SubChartDescription)this.Ch.SC.elementAt(s);
        this.copyYGridDesc(sc, userGrid);
    }

    public GridDesc getGridDesc(String subchartName) throws ChartException {
        int s = this.LookupSubChart(subchartName);
        if (s <= -1) {
            this.chartErrorSubchartNotFound("getGridDesc()", subchartName);
        }
        AxisCore.SubChartDescription sc = (AxisCore.SubChartDescription)this.Ch.SC.elementAt(s);
        return sc.YAxis1.yg.gridD;
    }

    public void setChartAttributes(AxisChartStyleDesc axisChartStyle) throws ChartException {
        this.Ch.axisChartStyle = axisChartStyle;
    }

    public void setEnableImageMapArea() throws ChartException {
        this.Ch.genImageMapCoords = true;
        if (this.Ch.labelXCount > 0) {
            this.Ch.imageMapCoords = new int[this.Ch.labelXCount][0];
        }
        int k = 0;
        while (k < this.Ch.SC.size()) {
            AxisCore.SubChartDescription sc = (AxisCore.SubChartDescription)this.Ch.SC.elementAt(k);
            if (sc.plotLineDes.size() != 0) {
                int s = 0;
                while (s < sc.plotLineDes.size()) {
                    LineDescription line = (LineDescription)sc.plotLineDes.elementAt(s);
                    int numpoints = 0;
                    numpoints = line.lineType == 9 || line.lineType == 8 || line.lineType == 7 ? line.yhigh.length : line.yval.length;
                    line.imageMapCoords = new int[numpoints][0];
                    line.imageMapCoordsBarIcon = new int[numpoints][0];
                    ++s;
                }
            }
            ++k;
        }
    }

    public ImageMapAreaDesc getSeriesImageMapAreaDesc(String seriesName) throws ChartException {
        String fcn = "getSeriesImageMapAreaDesc()";
        int s = this.LookupSeries(seriesName);
        if (s <= -1) {
            this.chartErrorSeriesNotFound(fcn, seriesName);
        }
        ImageMapAreaDesc imap = new ImageMapAreaDesc();
        LineDescription line = (LineDescription)this.SubCh.plotLineDes.elementAt(s);
        imap.setCoords(line.imageMapCoords);
        imap.setShape(line.imageMapShape);
        return imap;
    }

    public void setEnableTimeBandImageMapArea(boolean enable) throws ChartException {
        this.AxisTimeBandHolder.genImageMapCoords = enable;
    }

    public ImageMapAreaDesc getTimeBandImageMapAreaDesc() throws ChartException {
        String fcn = "getTimeBandImageMapAreaDesc()";
        ImageMapAreaDesc imap = new ImageMapAreaDesc();
        imap.setCoords(this.AxisTimeBandHolder.imageMapCoords);
        imap.setShape(this.AxisTimeBandHolder.imageMapShape);
        return imap;
    }

    public ImageMapAreaDesc getTimeBandSideImageMapAreaDesc() throws ChartException {
        String fcn = "getTimeBandSideImageMapAreaDesc()";
        ImageMapAreaDesc imap = new ImageMapAreaDesc();
        imap.setCoords(this.AxisTimeBandHolder.imageMapCoordsSide);
        imap.setShape(this.AxisTimeBandHolder.imageMapShape);
        return imap;
    }

    public ImageMapAreaDesc getSeriesBarIconImageMapAreaDesc(String seriesName) throws ChartException {
        String fcn = "getSeriesImageMapAreaDesc()";
        int s = this.LookupSeries(seriesName);
        if (s <= -1) {
            this.chartErrorSeriesNotFound(fcn, seriesName);
        }
        ImageMapAreaDesc imap = new ImageMapAreaDesc();
        LineDescription line = (LineDescription)this.SubCh.plotLineDes.elementAt(s);
        imap.setCoords(line.imageMapCoordsBarIcon);
        imap.setShape(line.imageMapShapeBarIcon);
        return imap;
    }

    public ImageMapAreaDesc getSeriesAreaChartImageMapAreaDesc(String seriesName) throws ChartException {
        String fcn = "getSeriesAreaChartImageMapAreaChartDesc()";
        int s = this.LookupSeries(seriesName);
        if (s <= -1) {
            this.chartErrorSeriesNotFound(fcn, seriesName);
        }
        ImageMapAreaDesc imap = new ImageMapAreaDesc();
        LineDescription line = (LineDescription)this.SubCh.plotLineDes.elementAt(s);
        if (line.lineType != 2 && line.lineType != 3) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-265"));
        }
        imap.setCoords(line.imageMapCoordsAreaC);
        imap.setShape(line.imageMapShapeAreaC);
        return imap;
    }

    public ImageMapAreaDesc getStringAxisImageMapAreaDesc() throws ChartException {
        String fcn = "getStringAxisImageMapAreaDesc()";
        ImageMapAreaDesc imap = new ImageMapAreaDesc();
        if (this.Ch.labelXCount < 0) {
            this.chartErrorSeriesNotFound(fcn, "");
        }
        imap.setCoords(this.Ch.imageMapCoords);
        imap.setShape(this.Ch.imageMapShape);
        return imap;
    }

    public void setAlignClusterBarLineGraph(boolean enable) {
        this.AlignClusterBarLineGraph = enable;
    }

    public boolean getAlignClusterBarLineGraph(boolean enable) {
        return this.AlignClusterBarLineGraph;
    }

    private int LookupSubChart(String subChartName) {
        int s = 0;
        while (s < this.Ch.SC.size()) {
            AxisCore.SubChartDescription subchart = (AxisCore.SubChartDescription)this.Ch.SC.elementAt(s);
            if (subchart.subchart_name.equals(subChartName)) {
                return s;
            }
            ++s;
        }
        return -1;
    }

    private AxisCore.SubChartDescription getSubChart(String subChartName) {
        int s = 0;
        while (s < this.Ch.SC.size()) {
            AxisCore.SubChartDescription subchart = (AxisCore.SubChartDescription)this.Ch.SC.elementAt(s);
            if (subchart.subchart_name.equals(subChartName)) {
                return subchart;
            }
            ++s;
        }
        return null;
    }

    private AxisCore.SubChartDescription getSubChartFromSeriesName(String seriesName) {
        int s = 0;
        while (s < this.Ch.SC.size()) {
            this.SubCh = (AxisCore.SubChartDescription)this.Ch.SC.elementAt(s);
            int index = this.LookupSeries(seriesName);
            if (index >= 0) {
                return this.SubCh;
            }
            ++s;
        }
        return null;
    }
}

