/*
 * Decompiled with CFR 0.152.
 */
package oracle.charts.annotation;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.Vector;

public class Annotation {
    static final int BalloonStringWidth = 10;
    public int xoffset = 5;
    public int yoffset = 1;
    protected FontMetrics annotationFontMetrics;
    protected Font annotationFont = new Font("Times", 1, 11);
    protected boolean fontMetricsGot = false;
    int xmin;
    int xmax;
    int ymin;
    int ymax;
    int LabelHeight = 0;
    int LabelAscent = 0;
    public static final short UPPER = 0;
    public static final short LOWER = 2;
    public static final short RECTLEFT = 0;
    public static final short RECTRIGHT = 1;
    public static final short RECTCENTERVERTICAL = 2;
    public static final short RECTLEFTCENTER = 3;
    public static final short RECTRIGHTCENTER = 4;
    Vector AnnoLines = new Vector();
    int maxCharsPerLine = 20;

    public int getxmin() {
        return this.xmin;
    }

    public int getymin() {
        return this.ymin;
    }

    public int getxmax() {
        return this.xmax;
    }

    public int getymax() {
        return this.ymax;
    }

    public void init() {
    }

    public void setFont(Font f) {
        this.annotationFont = f;
        this.fontMetricsGot = false;
    }

    public void getFMetrics(Graphics g) {
        if (this.fontMetricsGot) {
            return;
        }
        this.annotationFontMetrics = g.getFontMetrics(this.annotationFont);
        this.fontMetricsGot = true;
    }

    public int getRectWidth(String annotation) {
        int labelWidth = this.annotationFontMetrics.stringWidth(annotation);
        return labelWidth + 2 * this.xoffset;
    }

    public int getRectWidth() {
        int maxwidth = 0;
        int width = 0;
        int i = 0;
        while (i < this.AnnoLines.size()) {
            String s = (String)this.AnnoLines.elementAt(i);
            width = this.annotationFontMetrics.stringWidth(s);
            if (width > maxwidth) {
                maxwidth = width;
            }
            ++i;
        }
        return maxwidth + 2 * this.xoffset;
    }

    public int getRectHeight() {
        int labelHeight = this.annotationFontMetrics.getHeight();
        int labelAscent = this.annotationFontMetrics.getAscent();
        return labelHeight + (this.AnnoLines.size() - 1) * labelAscent + 2 * this.yoffset;
    }

    private short getQuadrant(int xmouth, int ymouth, int x, int y) {
        if (ymouth < y) {
            return 0;
        }
        return 2;
    }

    private short getQuadrant2(int xmouth, int ymouth, int x, int y) {
        if (ymouth >= y) {
            return 0;
        }
        return 2;
    }

    public int getXMin(String annotation, int x, int y, int rectcorner) {
        if (this.AnnoLines.size() <= 0) {
            this.breakLines(annotation);
        }
        int rectWidth = this.getRectWidth();
        switch (rectcorner) {
            case 1: 
            case 4: {
                return x;
            }
            case 0: 
            case 3: {
                return x - rectWidth;
            }
            case 2: {
                return x;
            }
        }
        return x;
    }

    public int getXMax(String annotation, int x, int y, int rectcorner) {
        if (this.AnnoLines.size() <= 0) {
            this.breakLines(annotation);
        }
        int rectWidth = this.getRectWidth();
        switch (rectcorner) {
            case 1: 
            case 4: {
                return x + rectWidth;
            }
            case 0: 
            case 3: {
                return x;
            }
            case 2: {
                return x + rectWidth;
            }
        }
        return x + rectWidth;
    }

    public int getYMin(String annotation, int xmouth, int ymouth, int x, int y) {
        if (this.AnnoLines.size() <= 0) {
            this.breakLines(annotation);
        }
        int rectHeight = this.getRectHeight();
        switch (this.getQuadrant(xmouth, ymouth, x, y)) {
            case 0: {
                return y;
            }
            case 2: {
                return y - rectHeight;
            }
        }
        return y;
    }

    public int getYMin2(String annotation, int xmouth, int ymouth, int x, int y) {
        if (this.AnnoLines.size() <= 0) {
            this.breakLines(annotation);
        }
        int rectHeight = this.getRectHeight();
        switch (this.getQuadrant2(xmouth, ymouth, x, y)) {
            case 0: {
                return y;
            }
            case 2: {
                return y - rectHeight;
            }
        }
        return y;
    }

    public int getYMax(String annotation, int xmouth, int ymouth, int x, int y) {
        if (this.AnnoLines.size() <= 0) {
            this.breakLines(annotation);
        }
        int rectHeight = this.getRectHeight();
        switch (this.getQuadrant(xmouth, ymouth, x, y)) {
            case 0: {
                return y + rectHeight;
            }
            case 2: {
                return y;
            }
        }
        return y;
    }

    public int getYMax2(String annotation, int xmouth, int ymouth, int x, int y) {
        if (this.AnnoLines.size() <= 0) {
            this.breakLines(annotation);
        }
        int rectHeight = this.getRectHeight();
        switch (this.getQuadrant2(xmouth, ymouth, x, y)) {
            case 0: {
                return y + rectHeight;
            }
            case 2: {
                return y;
            }
        }
        return y;
    }

    public void setMaxCharsPerLine(int c) {
        if (c > 0) {
            this.maxCharsPerLine = c;
        }
    }

    protected void breakLines(String annotation) {
        this.AnnoLines.removeAllElements();
        if (annotation.length() <= this.maxCharsPerLine) {
            this.AnnoLines.addElement(annotation);
            return;
        }
        int startindex = 0;
        int endindex = 0;
        int group = 0;
        while (group < annotation.length()) {
            while (true) {
                if (annotation.indexOf(" ", endindex) == -1) {
                    this.AnnoLines.addElement(annotation.substring(startindex));
                    return;
                }
                if (annotation.indexOf(" ", endindex) >= group + this.maxCharsPerLine) break;
                endindex = annotation.indexOf(" ", endindex);
                ++endindex;
            }
            this.AnnoLines.addElement(annotation.substring(startindex, endindex));
            startindex = endindex;
            group += this.maxCharsPerLine;
        }
    }

    protected void printAnnoLines() {
        int i = 0;
        while (i < this.AnnoLines.size()) {
            String s = (String)this.AnnoLines.elementAt(i);
            ++i;
        }
    }

    protected void drawAnno(Graphics g, int x, int y) {
        int diff = (this.LabelHeight - this.LabelAscent) / 2;
        y += diff - 1;
        int i = 0;
        while (i < this.AnnoLines.size()) {
            String s = (String)this.AnnoLines.elementAt(i);
            g.drawString(s, x, y);
            y += this.LabelAscent;
            ++i;
        }
    }

    public int getBStringConnect(String annotation, int xmouth, int ymouth, int x, int y, int rectcorner) {
        int bStringConnect = 0;
        int minbStringConnect = 10;
        int rectWidth = this.getRectWidth();
        int rmin = this.getXMin(annotation, x, y, rectcorner);
        int rmax = this.getXMax(annotation, x, y, rectcorner);
        int midpoint = (rmax + rmin) / 2;
        if (xmouth > rmin + minbStringConnect && xmouth < rmax - minbStringConnect) {
            switch (rectcorner) {
                case 1: 
                case 4: {
                    bStringConnect = xmouth - rmin;
                    break;
                }
                case 0: 
                case 3: {
                    bStringConnect = xmouth - rmax;
                    break;
                }
                case 2: {
                    bStringConnect = rectWidth / 2;
                }
            }
            return bStringConnect;
        }
        if (xmouth >= rmax - minbStringConnect) {
            bStringConnect = rectWidth - minbStringConnect - minbStringConnect;
            if (rectcorner == 1) {
                return bStringConnect;
            }
            return -minbStringConnect;
        }
        if (xmouth <= rmin + minbStringConnect) {
            bStringConnect = minbStringConnect;
            if (rectcorner == 1) {
                return bStringConnect;
            }
            return -rectWidth + 2 * minbStringConnect;
        }
        return 0;
    }

    public int getBStringWidth(int rectcorner) {
        int bStringWidth = 10;
        switch (rectcorner) {
            case 1: 
            case 4: {
                return bStringWidth;
            }
            case 0: 
            case 3: {
                return -bStringWidth;
            }
            case 2: {
                return bStringWidth;
            }
        }
        return bStringWidth;
    }

    public void setText(Graphics g, String annotation) {
        this.getFMetrics(g);
        this.LabelAscent = this.annotationFontMetrics.getAscent();
        this.LabelHeight = this.annotationFontMetrics.getHeight();
        this.breakLines(annotation);
    }

    public void drawballoon(Graphics g, String annotation, int xmouth, int ymouth, int x, int y, Color foreground, Color background, short rectcorner) {
        this.getFMetrics(g);
        this.LabelAscent = this.annotationFontMetrics.getAscent();
        this.LabelHeight = this.annotationFontMetrics.getHeight();
        this.breakLines(annotation);
        int rectWidth = this.getRectWidth();
        int rectHeight = this.getRectHeight();
        int rectRightX = x;
        int rectUpperY = y;
        int rectLeftX = 0;
        if (rectcorner != 4 && rectcorner != 3) {
            switch (this.getQuadrant(xmouth, ymouth, x, y)) {
                case 0: {
                    rectUpperY = y;
                    break;
                }
                case 2: {
                    rectUpperY = y - rectHeight;
                }
            }
        } else {
            rectUpperY = y - rectHeight;
        }
        int xdelta = 0;
        int ydelta = 0;
        switch (rectcorner) {
            case 1: 
            case 4: {
                rectRightX = x;
                xdelta = rectWidth;
                break;
            }
            case 0: 
            case 3: {
                rectRightX = x - rectWidth;
                xdelta = -rectWidth;
                break;
            }
            case 2: {
                rectRightX = x - rectWidth / 2;
            }
        }
        int numPoints = 8;
        int[] xa = new int[numPoints];
        int[] ya = new int[numPoints];
        int bStringConnect = this.getBStringConnect(annotation, xmouth, ymouth, x, y, rectcorner);
        int bStringWidth = this.getBStringWidth(rectcorner);
        switch (this.getQuadrant(xmouth, ymouth, x, y)) {
            case 0: {
                ydelta = rectHeight;
                break;
            }
            case 2: {
                ydelta = -rectHeight;
            }
        }
        int i = 0;
        int halfbStringWidth = 3;
        switch (rectcorner) {
            case 2: {
                rectLeftX = x + rectWidth / 2;
                xa[i] = rectRightX;
                ya[i++] = y;
                xa[i] = rectRightX + rectWidth / 2 - halfbStringWidth;
                ya[i++] = y;
                xa[i] = xmouth;
                ya[i++] = ymouth;
                xa[i] = rectRightX + rectWidth / 2 + halfbStringWidth;
                ya[i++] = y;
                xa[i] = rectLeftX;
                ya[i++] = y;
                xa[i] = rectLeftX;
                ya[i++] = y + ydelta;
                xa[i] = rectRightX;
                ya[i++] = y + ydelta;
                xa[i] = rectRightX;
                ya[i++] = y;
                break;
            }
            case 0: 
            case 1: {
                xa[i] = x;
                ya[i++] = y;
                xa[i] = x + bStringConnect;
                ya[i++] = y;
                xa[i] = xmouth;
                ya[i++] = ymouth;
                xa[i] = x + bStringConnect + bStringWidth;
                ya[i++] = y;
                xa[i] = x + xdelta;
                ya[i++] = y;
                xa[i] = x + xdelta;
                ya[i++] = y + ydelta;
                xa[i] = x;
                ya[i++] = y + ydelta;
                xa[i] = x;
                ya[i++] = y;
                break;
            }
            case 3: 
            case 4: {
                xa[i] = x;
                ya[i++] = y;
                xa[i] = x + xdelta;
                ya[i++] = y;
                xa[i] = x + xdelta;
                ya[i++] = y - rectHeight;
                xa[i] = x;
                ya[i++] = y - rectHeight;
                xa[i] = x;
                ya[i++] = y - rectHeight / 2 - halfbStringWidth;
                xa[i] = xmouth;
                ya[i++] = ymouth;
                xa[i] = x;
                ya[i++] = y - rectHeight / 2 + halfbStringWidth;
                xa[i] = x;
                ya[i++] = y;
            }
        }
        g.setColor(background);
        g.fillPolygon(xa, ya, 8);
        g.setColor(foreground);
        g.drawPolyline(xa, ya, 8);
        g.setFont(this.annotationFont);
        g.setColor(foreground);
        int adjust = this.LabelAscent;
        this.drawAnno(g, rectRightX + this.xoffset, rectUpperY + this.yoffset + adjust);
    }
}

