/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import oracle.i18n.util.ResourceBundleUtil;

class OraClassLoader
extends ClassLoader {
    private static final String M_SUFFIX_PROPERTIES = ".properties";
    private static final String M_SUFFIX_CLASS = ".class";
    private static final String M_LOCALE_ZH_CN = "_zh_CN";
    private static final String M_LOCALE_ZH_TW = "_zh_TW";
    private final String m_baseName;
    private final ClassLoader m_classLoader;
    private final Locale m_defLocale;

    public OraClassLoader(String string) {
        this(string, Thread.currentThread().getContextClassLoader(), null);
    }

    public OraClassLoader(String string, Locale locale) {
        this(string, Thread.currentThread().getContextClassLoader(), locale);
    }

    public OraClassLoader(String string, ClassLoader classLoader) {
        this(string, classLoader, null);
    }

    public OraClassLoader(String string, ClassLoader classLoader, Locale locale) {
        this.m_baseName = string;
        this.m_classLoader = classLoader;
        this.m_defLocale = locale;
    }

    public Class findClass(String string) throws ClassNotFoundException {
        Class clazz = OraClassLoader.findClassStrategy(string, MethodConstructResourceBundle.LIST_RESOURCE_BUNDLE, this);
        if (clazz != null) {
            return clazz;
        }
        clazz = OraClassLoader.findClassStrategy(string, MethodConstructResourceBundle.PROP_RESOURCE_BUNDLE, this);
        if (clazz != null) {
            return clazz;
        }
        throw new ClassNotFoundException(string);
    }

    static Class findClassStrategy(String string, MethodConstructResourceBundle methodConstructResourceBundle, OraClassLoader oraClassLoader) {
        String string2 = string;
        Class clazz = null;
        boolean bl = oraClassLoader.m_defLocale != null;
        String string3 = bl ? "_" + oraClassLoader.m_defLocale.toString() : "";
        for (int i = 0; i < 20 && (clazz = methodConstructResourceBundle.construct(string2, string, oraClassLoader)) == null; ++i) {
            char c;
            char c2;
            int n = string2.length();
            int n2 = string2.lastIndexOf(95);
            if (n2 < 0) {
                if (!bl) break;
                string2 = string2 + string3;
                bl = false;
            }
            bl = !string2.endsWith(string3);
            int n3 = string2.lastIndexOf(95, n2 - 1);
            if (n3 == n2 - 3 && n2 == n - 3) {
                c2 = string2.charAt(n2 + 1);
                c = string2.charAt(n2 + 2);
                char c3 = string2.charAt(n3 + 1);
                char c4 = string2.charAt(n3 + 2);
                if (c3 == 'z' && c4 == 'h') {
                    if (c2 == 'M' && c == 'O' || c2 == 'H' && c == 'K') {
                        string2 = oraClassLoader.m_baseName + M_LOCALE_ZH_TW;
                        continue;
                    }
                    if (c2 != 'C' || c != 'N') {
                        string2 = oraClassLoader.m_baseName + M_LOCALE_ZH_CN;
                        continue;
                    }
                    string2 = string2.substring(0, n2);
                    continue;
                }
                string2 = string2.substring(0, n2);
                continue;
            }
            if (n2 == n - 3) {
                c2 = string2.charAt(n2 + 1);
                c = string2.charAt(n2 + 2);
                if (c2 == 'z' && c == 'h' && i == 0) {
                    string2 = oraClassLoader.m_baseName + M_LOCALE_ZH_CN;
                    continue;
                }
                string2 = string2.substring(0, n2);
                continue;
            }
            string2 = string2.substring(0, n2);
        }
        return clazz;
    }

    static abstract class MethodConstructResourceBundle {
        public static final MethodConstructResourceBundle LIST_RESOURCE_BUNDLE = new MethodConstructResourceBundle(){

            public Class construct(String string, String string2, OraClassLoader oraClassLoader) {
                try {
                    Class<?> clazz = Class.forName(string, true, oraClassLoader.m_classLoader);
                    Class<?> clazz2 = clazz.getSuperclass();
                    if (clazz2 == null) {
                        return null;
                    }
                    Class<?> clazz3 = clazz2.getSuperclass();
                    if (ResourceBundle.class.equals(clazz3)) {
                        return clazz;
                    }
                    return null;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return null;
                }
            }
        };
        public static final MethodConstructResourceBundle PROP_RESOURCE_BUNDLE = new MethodConstructResourceBundle(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Class construct(String string, String string2, OraClassLoader oraClassLoader) {
                String string3 = string.replace('.', '/');
                InputStream inputStream = oraClassLoader.m_classLoader.getResourceAsStream(string3 + OraClassLoader.M_SUFFIX_PROPERTIES);
                if (inputStream != null) {
                    try {
                        Class clazz;
                        Properties properties = new Properties();
                        properties.load(inputStream);
                        String string4 = string2.replace('.', '/');
                        byte[] byArray = ResourceBundleUtil.getClassByteArray(string4, properties);
                        Class clazz2 = clazz = oraClassLoader.defineClass(string4, byArray, 0, byArray.length);
                        return clazz2;
                    }
                    catch (Exception exception) {
                    }
                    finally {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                return null;
            }
        };

        private MethodConstructResourceBundle() {
        }

        public abstract Class construct(String var1, String var2, OraClassLoader var3);
    }
}

