/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import sun.nio.cs.HistoricallyNamedCharset;
import sun.nio.cs.Surrogate;
import sun.nio.cs.ext.ExtendedCharsets;

public class ISCII91
extends Charset
implements HistoricallyNamedCharset {
    private static final char NUKTA_CHAR = '\u093c';
    private static final char HALANT_CHAR = '\u094d';
    private static final byte NO_CHAR = -1;
    private static final char[] directMapTable = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\u007f', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\u0901', '\u0902', '\u0903', '\u0905', '\u0906', '\u0907', '\u0908', '\u0909', '\u090a', '\u090b', '\u090e', '\u090f', '\u0910', '\u090d', '\u0912', '\u0913', '\u0914', '\u0911', '\u0915', '\u0916', '\u0917', '\u0918', '\u0919', '\u091a', '\u091b', '\u091c', '\u091d', '\u091e', '\u091f', '\u0920', '\u0921', '\u0922', '\u0923', '\u0924', '\u0925', '\u0926', '\u0927', '\u0928', '\u0929', '\u092a', '\u092b', '\u092c', '\u092d', '\u092e', '\u092f', '\u095f', '\u0930', '\u0931', '\u0932', '\u0933', '\u0934', '\u0935', '\u0936', '\u0937', '\u0938', '\u0939', '\u200d', '\u093e', '\u093f', '\u0940', '\u0941', '\u0942', '\u0943', '\u0946', '\u0947', '\u0948', '\u0945', '\u094a', '\u094b', '\u094c', '\u0949', '\u094d', '\u093c', '\u0964', '\uffff', '\uffff', '\uffff', '\uffff', '\ufffd', '\ufffd', '\u0966', '\u0967', '\u0968', '\u0969', '\u096a', '\u096b', '\u096c', '\u096d', '\u096e', '\u096f', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff'};
    private static final byte[] encoderMappingTable = new byte[]{-1, -1, -95, -1, -94, -1, -93, -1, -1, -1, -92, -1, -91, -1, -90, -1, -89, -1, -88, -1, -87, -1, -86, -1, -90, -23, -82, -1, -85, -1, -84, -1, -83, -1, -78, -1, -81, -1, -80, -1, -79, -1, -77, -1, -76, -1, -75, -1, -74, -1, -73, -1, -72, -1, -71, -1, -70, -1, -69, -1, -68, -1, -67, -1, -66, -1, -65, -1, -64, -1, -63, -1, -62, -1, -61, -1, -60, -1, -59, -1, -58, -1, -57, -1, -56, -1, -55, -1, -54, -1, -53, -1, -52, -1, -51, -1, -49, -1, -48, -1, -47, -1, -46, -1, -45, -1, -44, -1, -43, -1, -42, -1, -41, -1, -40, -1, -1, -1, -1, -1, -23, -1, -22, -23, -38, -1, -37, -1, -36, -1, -35, -1, -34, -1, -33, -1, -33, -23, -29, -1, -32, -1, -31, -1, -30, -1, -25, -1, -28, -1, -27, -1, -26, -1, -24, -1, -1, -1, -1, -1, -95, -23, -16, -75, -16, -72, -2, -1, -2, -1, -1, -1, -1, -1, -1, -1, -77, -23, -76, -23, -75, -23, -70, -23, -65, -23, -64, -23, -55, -23, -50, -1, -86, -23, -89, -23, -37, -23, -36, -23, -22, -1, -22, -22, -15, -1, -14, -1, -13, -1, -12, -1, -11, -1, -10, -1, -9, -1, -8, -1, -7, -1, -6, -1, -16, -65, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};

    public ISCII91() {
        super("x-ISCII91", ExtendedCharsets.aliasesFor("x-ISCII91"));
    }

    public String historicalName() {
        return "ISCII91";
    }

    public boolean contains(Charset charset) {
        return charset.name().equals("US-ASCII") || charset instanceof ISCII91;
    }

    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    public static char[] getDirectMapTable() {
        return directMapTable;
    }

    public static byte[] getEncoderMappingTable() {
        return encoderMappingTable;
    }

    private static class Decoder
    extends CharsetDecoder {
        private static final char ZWNJ_CHAR = '\u200c';
        private static final char ZWJ_CHAR = '\u200d';
        private static final char INVALID_CHAR = '\uffff';
        private char contextChar = (char)65535;
        private boolean needFlushing = false;

        private Decoder(Charset charset) {
            super(charset, 1.0f, 1.0f);
        }

        protected CoderResult implFlush(CharBuffer charBuffer) {
            if (this.needFlushing) {
                if (charBuffer.remaining() < 1) {
                    return CoderResult.OVERFLOW;
                }
                charBuffer.put(this.contextChar);
            }
            this.contextChar = (char)65535;
            this.needFlushing = false;
            return CoderResult.UNDERFLOW;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult decodeArrayLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            byte[] byArray = byteBuffer.array();
            int n = byteBuffer.arrayOffset() + byteBuffer.position();
            int n2 = byteBuffer.arrayOffset() + byteBuffer.limit();
            assert (n <= n2);
            n = n <= n2 ? n : n2;
            char[] cArray = charBuffer.array();
            int n3 = charBuffer.arrayOffset() + charBuffer.position();
            int n4 = charBuffer.arrayOffset() + charBuffer.limit();
            assert (n3 <= n4);
            n3 = n3 <= n4 ? n3 : n4;
            try {
                block26: while (n < n2) {
                    int n5 = byArray[n];
                    n5 = n5 < 0 ? n5 + 255 : n5;
                    char c = directMapTable[n5];
                    if (this.contextChar == '\ufffd') {
                        if (n4 - n3 < 1) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        cArray[n3++] = 65533;
                        this.contextChar = (char)65535;
                        this.needFlushing = false;
                        ++n;
                        continue;
                    }
                    block7 : switch (c) {
                        case '\u0901': 
                        case '\u0907': 
                        case '\u0908': 
                        case '\u090b': 
                        case '\u093f': 
                        case '\u0940': 
                        case '\u0943': 
                        case '\u0964': {
                            if (this.needFlushing) {
                                if (n4 - n3 < 1) {
                                    CoderResult coderResult = CoderResult.OVERFLOW;
                                    return coderResult;
                                }
                                cArray[n3++] = this.contextChar;
                                this.contextChar = c;
                                ++n;
                                continue block26;
                            }
                            this.contextChar = c;
                            this.needFlushing = true;
                            ++n;
                            continue block26;
                        }
                        case '\u093c': {
                            switch (this.contextChar) {
                                case '\u0901': {
                                    cArray[n3] = 2384;
                                    break block7;
                                }
                                case '\u0907': {
                                    cArray[n3] = 2316;
                                    break block7;
                                }
                                case '\u0908': {
                                    cArray[n3] = 2401;
                                    break block7;
                                }
                                case '\u090b': {
                                    cArray[n3] = 2400;
                                    break block7;
                                }
                                case '\u093f': {
                                    cArray[n3] = 2402;
                                    break block7;
                                }
                                case '\u0940': {
                                    cArray[n3] = 2403;
                                    break block7;
                                }
                                case '\u0943': {
                                    cArray[n3] = 2372;
                                    break block7;
                                }
                                case '\u0964': {
                                    cArray[n3] = 2365;
                                    break block7;
                                }
                                case '\u094d': {
                                    if (this.needFlushing) {
                                        cArray[n3] = this.contextChar;
                                        this.contextChar = c;
                                        continue block26;
                                    }
                                    cArray[n3] = 8205;
                                    break block7;
                                }
                            }
                            if (this.needFlushing) {
                                cArray[n3++] = this.contextChar;
                                this.contextChar = c;
                                continue block26;
                            }
                            cArray[n3] = 2364;
                            break;
                        }
                        case '\u094d': {
                            if (this.needFlushing) {
                                if (n4 - n3 < 1) {
                                    CoderResult coderResult = CoderResult.OVERFLOW;
                                    return coderResult;
                                }
                                cArray[n3++] = this.contextChar;
                                this.contextChar = c;
                                ++n;
                                continue block26;
                            }
                            if (this.contextChar == '\u094d') {
                                cArray[n3] = 8204;
                                break;
                            }
                            cArray[n3] = 2381;
                            break;
                        }
                        case '\uffff': {
                            if (this.needFlushing) {
                                if (n4 - n3 < 1) {
                                    CoderResult coderResult = CoderResult.OVERFLOW;
                                    return coderResult;
                                }
                                cArray[n3++] = this.contextChar;
                                this.contextChar = c;
                                ++n;
                                continue block26;
                            }
                            CoderResult coderResult = CoderResult.unmappableForLength(1);
                            return coderResult;
                        }
                        default: {
                            if (this.needFlushing) {
                                if (n4 - n3 < 1) {
                                    CoderResult coderResult = CoderResult.OVERFLOW;
                                    return coderResult;
                                }
                                cArray[n3++] = this.contextChar;
                                this.contextChar = c;
                                ++n;
                                continue block26;
                            }
                            cArray[n3] = c;
                        }
                    }
                    this.contextChar = c;
                    this.needFlushing = false;
                    ++n3;
                    ++n;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                byteBuffer.position(n - byteBuffer.arrayOffset());
                charBuffer.position(n3 - charBuffer.arrayOffset());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult decodeBufferLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            int n = byteBuffer.position();
            try {
                block26: while (byteBuffer.hasRemaining()) {
                    int n2 = byteBuffer.get();
                    n2 = n2 < 0 ? n2 + 255 : n2;
                    char c = directMapTable[n2];
                    if (this.contextChar == '\ufffd') {
                        if (charBuffer.remaining() < 1) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        charBuffer.put('\ufffd');
                        this.contextChar = (char)65535;
                        this.needFlushing = false;
                        continue;
                    }
                    block7 : switch (c) {
                        case '\u0901': 
                        case '\u0907': 
                        case '\u0908': 
                        case '\u090b': 
                        case '\u093f': 
                        case '\u0940': 
                        case '\u0943': 
                        case '\u0964': {
                            if (this.needFlushing) {
                                if (charBuffer.remaining() < 1) {
                                    CoderResult coderResult = CoderResult.OVERFLOW;
                                    return coderResult;
                                }
                                charBuffer.put(this.contextChar);
                                this.contextChar = c;
                                continue block26;
                            }
                            this.contextChar = c;
                            this.needFlushing = true;
                            continue block26;
                        }
                        case '\u093c': {
                            switch (this.contextChar) {
                                case '\u0901': {
                                    charBuffer.put('\u0950');
                                    break block7;
                                }
                                case '\u0907': {
                                    charBuffer.put('\u090c');
                                    break block7;
                                }
                                case '\u0908': {
                                    charBuffer.put('\u0961');
                                    break block7;
                                }
                                case '\u090b': {
                                    charBuffer.put('\u0960');
                                    break block7;
                                }
                                case '\u093f': {
                                    charBuffer.put('\u0962');
                                    break block7;
                                }
                                case '\u0940': {
                                    charBuffer.put('\u0963');
                                    break block7;
                                }
                                case '\u0943': {
                                    charBuffer.put('\u0944');
                                    break block7;
                                }
                                case '\u0964': {
                                    charBuffer.put('\u093d');
                                    break block7;
                                }
                                case '\u094d': {
                                    if (this.needFlushing) {
                                        charBuffer.put(this.contextChar);
                                        this.contextChar = c;
                                        continue block26;
                                    }
                                    charBuffer.put('\u200d');
                                    break block7;
                                }
                            }
                            if (this.needFlushing) {
                                charBuffer.put(this.contextChar);
                                this.contextChar = c;
                                continue block26;
                            }
                            charBuffer.put('\u093c');
                            break;
                        }
                        case '\u094d': {
                            if (this.needFlushing) {
                                if (charBuffer.remaining() < 1) {
                                    CoderResult coderResult = CoderResult.OVERFLOW;
                                    return coderResult;
                                }
                                charBuffer.put(this.contextChar);
                                this.contextChar = c;
                                continue block26;
                            }
                            if (this.contextChar == '\u094d') {
                                charBuffer.put('\u200c');
                                break;
                            }
                            charBuffer.put('\u094d');
                            break;
                        }
                        case '\uffff': {
                            if (this.needFlushing) {
                                if (charBuffer.remaining() < 1) {
                                    CoderResult coderResult = CoderResult.OVERFLOW;
                                    return coderResult;
                                }
                                charBuffer.put(this.contextChar);
                                this.contextChar = c;
                                continue block26;
                            }
                            CoderResult coderResult = CoderResult.unmappableForLength(1);
                            return coderResult;
                        }
                        default: {
                            if (this.needFlushing) {
                                if (charBuffer.remaining() < 1) {
                                    CoderResult coderResult = CoderResult.OVERFLOW;
                                    return coderResult;
                                }
                                charBuffer.put(this.contextChar);
                                this.contextChar = c;
                                continue block26;
                            }
                            charBuffer.put(c);
                        }
                    }
                    this.contextChar = c;
                    this.needFlushing = false;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                byteBuffer.position(n);
            }
        }

        protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            if (byteBuffer.hasArray() && charBuffer.hasArray()) {
                return this.decodeArrayLoop(byteBuffer, charBuffer);
            }
            return this.decodeBufferLoop(byteBuffer, charBuffer);
        }
    }

    private static class Encoder
    extends CharsetEncoder {
        private static final byte NO_CHAR = -1;
        private final Surrogate.Parser sgp = new Surrogate.Parser();

        private Encoder(Charset charset) {
            super(charset, 2.0f, 2.0f);
        }

        public boolean canEncode(char c) {
            return c >= '\u0900' && c <= '\u097f' || c == '\u200d' || c == '\u200c' || c >= '\u0000' && c <= '\u007f';
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult encodeArrayLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            char[] cArray = charBuffer.array();
            int n = charBuffer.arrayOffset() + charBuffer.position();
            int n2 = charBuffer.arrayOffset() + charBuffer.limit();
            assert (n <= n2);
            n = n <= n2 ? n : n2;
            byte[] byArray = byteBuffer.array();
            int n3 = byteBuffer.arrayOffset() + byteBuffer.position();
            int n4 = byteBuffer.arrayOffset() + byteBuffer.limit();
            assert (n3 <= n4);
            n3 = n3 <= n4 ? n3 : n4;
            boolean bl = false;
            try {
                while (n < n2) {
                    int n5 = Integer.MIN_VALUE;
                    char c = cArray[n];
                    if (c >= '\u0000' && c <= '\u007f') {
                        if (n4 - n3 < 1) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        byArray[n3++] = (byte)c;
                        ++n;
                        continue;
                    }
                    if (c == '\u200c') {
                        c = '\u094d';
                    } else if (c == '\u200d') {
                        c = '\u093c';
                    }
                    if (c >= '\u0900' && c <= '\u097f') {
                        n5 = (c - 2304) * 2;
                    }
                    if (c >= '\ud800' && c < '\udbff') {
                        if (this.sgp.parse(c, cArray, n, n2) < 0) {
                            CoderResult coderResult = this.sgp.error();
                            return coderResult;
                        }
                        CoderResult coderResult = this.sgp.unmappableResult();
                        return coderResult;
                    }
                    if (n5 == Integer.MIN_VALUE || encoderMappingTable[n5] == -1) {
                        CoderResult coderResult = CoderResult.unmappableForLength(1);
                        return coderResult;
                    }
                    byArray[n3++] = encoderMappingTable[n5++];
                    if (encoderMappingTable[n5] != -1 && n4 - n3 < 1) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    byArray[n3++] = encoderMappingTable[n5];
                    ++n;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                charBuffer.position(n - charBuffer.arrayOffset());
                byteBuffer.position(n3 - byteBuffer.arrayOffset());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult encodeBufferLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            int n = charBuffer.position();
            try {
                while (charBuffer.hasRemaining()) {
                    int n2 = Integer.MIN_VALUE;
                    char c = charBuffer.get();
                    if (c >= '\u0000' && c <= '\u007f') {
                        if (byteBuffer.remaining() < 1) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        byteBuffer.put((byte)c);
                        continue;
                    }
                    if (c == '\u200c') {
                        c = '\u094d';
                    } else if (c == '\u200d') {
                        c = '\u093c';
                    }
                    if (c >= '\u0900' && c <= '\u097f') {
                        n2 = (c - 2304) * 2;
                    }
                    if (c >= '\ud800' && c < '\udbff') {
                        if (this.sgp.parse(c, charBuffer) < 0) {
                            CoderResult coderResult = this.sgp.error();
                            return coderResult;
                        }
                        CoderResult coderResult = this.sgp.unmappableResult();
                        return coderResult;
                    }
                    if (n2 == Integer.MIN_VALUE || encoderMappingTable[n2] == -1) {
                        CoderResult coderResult = CoderResult.unmappableForLength(1);
                        return coderResult;
                    }
                    byteBuffer.put(encoderMappingTable[n2++]);
                    if (encoderMappingTable[n2] != -1 && byteBuffer.remaining() < 1) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    byteBuffer.put(encoderMappingTable[n2]);
                    ++n;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                charBuffer.position(n);
            }
        }

        protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            if (charBuffer.hasArray() && byteBuffer.hasArray()) {
                return this.encodeArrayLoop(charBuffer, byteBuffer);
            }
            return this.encodeBufferLoop(charBuffer, byteBuffer);
        }
    }
}

