/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.viewBuilder.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import oracle.bali.dbUI.db.Column;
import oracle.bali.dbUI.db.Table;
import oracle.bali.dbUI.dnd.DBUIDataFlavors;
import oracle.bali.dbUI.laf.DBUILookAndFeel;
import oracle.bali.dbUI.viewBuilder.RelationshipLink;
import oracle.bali.dbUI.viewBuilder.RelationshipLinkPainter;
import oracle.bali.dbUI.viewBuilder.ViewBuilder;
import oracle.bali.dbUI.viewBuilder.ViewBuilderCanvas;
import oracle.bali.dbUI.viewBuilder.ViewBuilderComponent;
import oracle.bali.dbUI.viewBuilder.ViewBuilderLink;
import oracle.bali.dbUI.viewBuilder.ViewBuilderLinkPainter;
import oracle.bali.ewt.dnd.DropTarget;
import oracle.bali.ewt.dnd.DropTargetContext;
import oracle.bali.ewt.dnd.DropTargetDragEvent;
import oracle.bali.ewt.dnd.DropTargetDropEvent;
import oracle.bali.ewt.dnd.DropTargetEvent;
import oracle.bali.ewt.dnd.DropTargetListener;
import oracle.bali.ewt.dnd.JFCSupport;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.share.datatransfer.TransferUtils;
import oracle.bali.share.thread.Task;
import oracle.bali.share.thread.TaskEvent;

public class JInternalFrameViewBuilderCanvas
extends JDesktopPane
implements ViewBuilderCanvas {
    private ViewBuilder _builder;
    private Color _color;
    private Listener _listener;
    private Vector _linkPainters = new Vector();
    private Vector _selectedLinkPainters = new Vector();
    private Vector _activeLinkPainters = new Vector();

    public JInternalFrameViewBuilderCanvas() {
        this._listener = new Listener();
        this.setBackground(Color.white);
        this._addDropTarget(this);
        this.enableEvents(16L);
        this.setDragMode(JDesktopPane.OUTLINE_DRAG_MODE);
        InputMap inputMap = this.getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke(121, 1), "ShowMenu");
        ActionMap actionMap = this.getActionMap();
        actionMap.put("ShowMenu", new MenuAction());
    }

    public void addComponent(ViewBuilderComponent viewBuilderComponent) {
        if (!(viewBuilderComponent instanceof JInternalFrame)) {
            throw new IllegalArgumentException("JInternalFrameViewBuilderCanvas must be used with JInternalFrameTableComponent");
        }
        super.add((JInternalFrame)((Object)viewBuilderComponent));
    }

    public Component getComponent() {
        return this;
    }

    public void setViewBuilder(ViewBuilder viewBuilder) {
        this._builder = viewBuilder;
    }

    public ViewBuilder getViewBuilder() {
        return this._builder;
    }

    public void setSelectedComponent(ViewBuilderComponent viewBuilderComponent) {
        if (viewBuilderComponent != null && !(viewBuilderComponent instanceof JInternalFrame)) {
            throw new IllegalArgumentException("JInternalFrameViewBuilderCanvas must be used with JInternalFrameTableComponent");
        }
        try {
            if (viewBuilderComponent == null) {
                JInternalFrame jInternalFrame = this.getSelectedFrame();
                if (jInternalFrame != null) {
                    jInternalFrame.setSelected(false);
                }
            } else {
                ((JInternalFrame)((Object)viewBuilderComponent)).setSelected(true);
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public ViewBuilderComponent getViewBuilderComponentAt(int n, int n2) {
        Component component = this.getComponentAt(n, n2);
        if (component instanceof ViewBuilderComponent) {
            return (ViewBuilderComponent)((Object)component);
        }
        return null;
    }

    public void addViewBuilderLink(ViewBuilderLink viewBuilderLink) {
        ViewBuilderLinkPainter viewBuilderLinkPainter = this.createLinkPainter(viewBuilderLink);
        if (viewBuilderLinkPainter != null) {
            this._linkPainters.addElement(viewBuilderLinkPainter);
            ViewBuilderComponent viewBuilderComponent = viewBuilderLink.getSourcePort(0).getViewBuilderComponent();
            ViewBuilderComponent viewBuilderComponent2 = viewBuilderLink.getDestinationPort(0).getViewBuilderComponent();
            boolean bl = viewBuilderComponent.isComponentSelected() || viewBuilderComponent2.isComponentSelected();
            viewBuilderLink.setActive(bl);
            if (bl) {
                this._activeLinkPainters.addElement(viewBuilderLinkPainter);
            }
            viewBuilderLinkPainter.addPropertyChangeListener(this._listener);
            viewBuilderLink.addPropertyChangeListener(this._listener);
            viewBuilderLinkPainter.invalidate();
            this._validateScrollBox();
            this.repaint();
        }
    }

    public void removeViewBuilderLink(ViewBuilderLink viewBuilderLink) {
        ViewBuilderLinkPainter viewBuilderLinkPainter = this._getPainter(viewBuilderLink);
        if (viewBuilderLinkPainter == null) {
            return;
        }
        viewBuilderLinkPainter.removePropertyChangeListener(this._listener);
        viewBuilderLink.removePropertyChangeListener(this._listener);
        viewBuilderLinkPainter.cleanup();
        this._linkPainters.removeElement((Object)viewBuilderLinkPainter);
        int n = this._selectedLinkPainters.indexOf((Object)viewBuilderLinkPainter);
        if (n != -1) {
            this._selectedLinkPainters.removeElementAt(n);
        }
        if ((n = this._activeLinkPainters.indexOf((Object)viewBuilderLinkPainter)) != -1) {
            this._activeLinkPainters.removeElementAt(n);
        }
        this._validateScrollBox();
        this.repaint();
    }

    public Dimension getDocumentSize(PaintContext paintContext, Dictionary dictionary) {
        return this.getPreferredSize();
    }

    public void printPage(PaintContext paintContext, Dictionary dictionary, Graphics graphics) {
        Shape shape = graphics.getClip();
        this._paintLinks(paintContext, graphics);
        this.print(graphics);
        graphics.setClip(shape);
    }

    public Rectangle getPageBounds(PaintContext paintContext, Dictionary dictionary, int n, int n2, int n3, int n4) {
        Component component;
        Rectangle rectangle;
        int n5 = this.getComponentCount();
        int n6 = n + n3;
        int n7 = 0;
        while (n7 < n5) {
            if (n6 < n) {
                n6 = n + n3;
            }
            if ((rectangle = (component = this.getComponent(n7)).getBounds()).contains(n6, rectangle.y)) {
                n6 = rectangle.x - 10;
                n7 = 0;
            }
            ++n7;
        }
        int n8 = n2 + n4;
        int n9 = 0;
        while (n9 < n5) {
            if (n8 < n2) {
                n6 = n2 + n4;
            }
            if ((rectangle = (component = this.getComponent(n9)).getBounds()).contains(rectangle.x, n8)) {
                n8 = rectangle.y - 10;
                n9 = 0;
            }
            ++n9;
        }
        int n10 = n6 - n;
        int n11 = n8 - n2;
        Rectangle rectangle2 = new Rectangle(n10, n11, n10, n11);
        return rectangle2;
    }

    protected void addImpl(Component component, Object object, int n) {
        super.addImpl(component, object, n);
        if (component instanceof JComponent) {
            this._addDropTarget((JComponent)component);
        }
        if (component instanceof ViewBuilderComponent) {
            ((ViewBuilderComponent)((Object)component)).addPropertyChangeListener(this._listener);
        }
        if (component instanceof JInternalFrame.JDesktopIcon) {
            component.addComponentListener(this._listener);
        }
        this._setWindowEnabled(component, this.isEnabled());
        this._validateScrollBox();
    }

    public void remove(int n) {
        Component component = this.getComponent(n);
        if (component instanceof JComponent) {
            this._removeDropTarget((JComponent)component);
        }
        if (component instanceof ViewBuilderComponent) {
            ((ViewBuilderComponent)((Object)component)).removePropertyChangeListener(this._listener);
        }
        if (component instanceof JInternalFrame.JDesktopIcon) {
            component.removeComponentListener(this._listener);
        }
        super.remove(n);
        this._validateScrollBox();
    }

    public Dimension getPreferredSize() {
        Rectangle rectangle;
        int n = this.getComponentCount();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            Component component = this.getComponent(n4);
            rectangle = component.getBounds();
            if (rectangle.x + rectangle.width > n2) {
                n2 = rectangle.x + rectangle.width;
            }
            if (rectangle.y + rectangle.height > n3) {
                n3 = rectangle.y + rectangle.height;
            }
            ++n4;
        }
        int n5 = this._linkPainters.size();
        PaintContext paintContext = this._builder.getPaintContext();
        int n6 = 0;
        while (n6 < n5) {
            ViewBuilderLinkPainter viewBuilderLinkPainter = (ViewBuilderLinkPainter)((Object)this._linkPainters.elementAt(n6));
            rectangle = viewBuilderLinkPainter.getBounds(paintContext);
            if (rectangle.x + rectangle.width > n2) {
                n2 = rectangle.x + rectangle.width;
            }
            if (rectangle.y + rectangle.height > n3) {
                n3 = rectangle.y + rectangle.height;
            }
            ++n6;
        }
        return new Dimension(n2 + 2, n3 + 2);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        int n = this.getComponentCount();
        int n2 = 0;
        while (n2 < n) {
            Component component = this.getComponent(n2);
            this._setWindowEnabled(component, this.isEnabled());
            ++n2;
        }
    }

    public void requestFocus() {
        super.requestFocus();
    }

    protected void paintComponent(Graphics graphics) {
        this._paintLinks(this._builder.getPaintContext(), graphics);
    }

    protected ViewBuilderLinkPainter createLinkPainter(ViewBuilderLink viewBuilderLink) {
        if (viewBuilderLink instanceof RelationshipLink) {
            return new RelationshipLinkPainter((RelationshipLink)viewBuilderLink);
        }
        return null;
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        if (mouseEvent.isConsumed() || !this.isEnabled()) {
            return;
        }
        if (mouseEvent.isPopupTrigger()) {
            this._editJoins(mouseEvent);
        } else if (mouseEvent.getID() == 501) {
            this._selectJoins(mouseEvent);
        }
    }

    void __changeFocus(boolean bl) {
        int n = this._linkPainters.size();
        if (n == 0) {
            ((Component)((Object)this.getViewBuilder())).transferFocus();
        } else {
            ViewBuilderLinkPainter viewBuilderLinkPainter = (ViewBuilderLinkPainter)((Object)this._linkPainters.elementAt(0));
            this.getViewBuilder().setLinkSelected(viewBuilderLinkPainter.getLink(), true);
            ((JComponent)((Object)this.getViewBuilder())).requestFocus();
        }
    }

    private void _paintLinks(PaintContext paintContext, Graphics graphics) {
        ViewBuilderLinkPainter viewBuilderLinkPainter;
        int n = this._linkPainters.size();
        if (n == 0) {
            return;
        }
        Dimension dimension = this.getSize();
        int n2 = 0;
        while (n2 < n) {
            viewBuilderLinkPainter = (ViewBuilderLinkPainter)((Object)this._linkPainters.elementAt(n2));
            if (!viewBuilderLinkPainter.getLink().isSelected() && !viewBuilderLinkPainter.getLink().isActive()) {
                viewBuilderLinkPainter.paint(paintContext, graphics, 0, 0, dimension.width, dimension.height);
            }
            ++n2;
        }
        n = this._activeLinkPainters.size();
        int n3 = 0;
        while (n3 < n) {
            viewBuilderLinkPainter = (ViewBuilderLinkPainter)((Object)this._activeLinkPainters.elementAt(n3));
            viewBuilderLinkPainter.paint(paintContext, graphics, 0, 0, dimension.width, dimension.height);
            ++n3;
        }
        n = this._selectedLinkPainters.size();
        int n4 = 0;
        while (n4 < n) {
            viewBuilderLinkPainter = (ViewBuilderLinkPainter)((Object)this._selectedLinkPainters.elementAt(n4));
            viewBuilderLinkPainter.paint(paintContext, graphics, 0, 0, dimension.width, dimension.height);
            ++n4;
        }
    }

    private void _validateScrollBox() {
        this.invalidate();
        Component component = this._getScrollBox();
        if (component != null) {
            component.validate();
        }
    }

    private Component _getScrollBox() {
        Container container = this.getParent();
        while (container != null) {
            if (container instanceof JScrollPane) {
                return container;
            }
            container = container.getParent();
        }
        return null;
    }

    private void _updateLinkSelectionState(ViewBuilderLink viewBuilderLink, boolean bl) {
        int n;
        boolean bl2 = this.accessibleContext != null;
        AccessibleContext accessibleContext = bl2 ? this.getViewBuilder().getAccessibleContext() : null;
        String string = null;
        if (accessibleContext != null) {
            string = accessibleContext.getAccessibleName();
        }
        ViewBuilderLinkPainter viewBuilderLinkPainter = this._getPainter(viewBuilderLink);
        if (bl) {
            n = this._selectedLinkPainters.indexOf((Object)viewBuilderLinkPainter);
            if (n == -1) {
                this._selectedLinkPainters.addElement(viewBuilderLinkPainter);
            }
        } else {
            n = this._selectedLinkPainters.indexOf((Object)viewBuilderLinkPainter);
            if (n != -1) {
                this._selectedLinkPainters.removeElementAt(n);
            }
        }
        if (accessibleContext != null) {
            String string2 = accessibleContext.getAccessibleName();
            accessibleContext.firePropertyChange("AccessibleName", string, string2);
        }
        this.repaint();
    }

    private void _updateLinkActiveState(ViewBuilderLink viewBuilderLink, boolean bl) {
        ViewBuilderLinkPainter viewBuilderLinkPainter = this._getPainter(viewBuilderLink);
        if (bl) {
            int n = this._activeLinkPainters.indexOf((Object)viewBuilderLinkPainter);
            if (n == -1) {
                this._activeLinkPainters.addElement(viewBuilderLinkPainter);
            }
        } else {
            int n = this._activeLinkPainters.indexOf((Object)viewBuilderLinkPainter);
            if (n != -1) {
                this._activeLinkPainters.removeElementAt(n);
            }
        }
        this.repaint();
    }

    private void _invalidateJoins(ViewBuilderComponent viewBuilderComponent) {
        ViewBuilderLink[] viewBuilderLinkArray = this.getViewBuilder().getLinks(viewBuilderComponent);
        if (viewBuilderLinkArray == null) {
            return;
        }
        int n = 0;
        while (n < viewBuilderLinkArray.length) {
            ViewBuilderLinkPainter viewBuilderLinkPainter = this._getPainter(viewBuilderLinkArray[n]);
            viewBuilderLinkPainter.invalidate();
            ++n;
        }
        this.repaint();
    }

    private void _selectJoins(MouseEvent mouseEvent) {
        try {
            ViewBuilderLinkPainter viewBuilderLinkPainter = this._findJoinPainter(mouseEvent.getX(), mouseEvent.getY());
            if (viewBuilderLinkPainter == null) {
                this.getViewBuilder().setAllLinksSelected(false);
                this.setSelectedComponent(null);
            } else {
                ViewBuilderLink viewBuilderLink = viewBuilderLinkPainter.getLink();
                int n = mouseEvent.getClickCount();
                if (n == 1) {
                    boolean bl = false;
                    if (mouseEvent.isControlDown()) {
                        bl = !viewBuilderLink.isSelected();
                    } else if (mouseEvent.isShiftDown()) {
                        bl = true;
                    } else {
                        this.getViewBuilder().setAllLinksSelected(false);
                        bl = true;
                    }
                    this.getViewBuilder().setLinkSelected(viewBuilderLink, bl);
                    mouseEvent.consume();
                    this.setSelectedComponent(null);
                    ((JComponent)((Object)this.getViewBuilder())).requestFocus();
                } else if (n == 2 && viewBuilderLink instanceof RelationshipLink) {
                    RelationshipLink relationshipLink = (RelationshipLink)viewBuilderLink;
                    relationshipLink.setUserDoubleClick(true);
                    boolean bl = !relationshipLink.isIncluded();
                    this.getViewBuilder().setRelationshipIncluded(relationshipLink.getRelationship(), bl);
                    mouseEvent.consume();
                }
            }
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            throw throwable;
        }
    }

    private void _editJoins(MouseEvent mouseEvent) {
        ViewBuilderLinkPainter viewBuilderLinkPainter = this._findJoinPainter(mouseEvent.getX(), mouseEvent.getY());
        if (viewBuilderLinkPainter == null) {
            return;
        }
        mouseEvent.consume();
        ViewBuilder viewBuilder = this.getViewBuilder();
        Point point = SwingUtilities.convertPoint(this, mouseEvent.getPoint(), (Component)((Object)viewBuilder));
        viewBuilder.showMenu(viewBuilderLinkPainter.getLink(), point.x, point.y);
    }

    private ViewBuilderLinkPainter _findJoinPainter(int n, int n2) {
        PaintContext paintContext = this._builder.getPaintContext();
        int n3 = this._linkPainters.size();
        int n4 = 0;
        while (n4 < n3) {
            ViewBuilderLinkPainter viewBuilderLinkPainter = (ViewBuilderLinkPainter)((Object)this._linkPainters.elementAt(n4));
            if (viewBuilderLinkPainter.contains(paintContext, n, n2)) {
                return viewBuilderLinkPainter;
            }
            ++n4;
        }
        return null;
    }

    private ViewBuilderLinkPainter _getPainter(ViewBuilderLink viewBuilderLink) {
        int n = this._linkPainters.size();
        int n2 = 0;
        while (n2 < n) {
            ViewBuilderLinkPainter viewBuilderLinkPainter = (ViewBuilderLinkPainter)((Object)this._linkPainters.elementAt(n2));
            if (viewBuilderLinkPainter.getLink() == viewBuilderLink) {
                return viewBuilderLinkPainter;
            }
            ++n2;
        }
        return null;
    }

    private void _setWindowEnabled(Component component, boolean bl) {
        component.setEnabled(bl);
        this._setEnabled(component, bl);
    }

    private void _setEnabled(Component component, boolean bl) {
        component.setEnabled(bl);
        if (component instanceof Container) {
            Container container = (Container)component;
            int n = 0;
            while (n < container.getComponentCount()) {
                this._setEnabled(container.getComponent(n), bl);
                ++n;
            }
        }
    }

    private void _addDropTarget(JComponent jComponent) {
        if (JFCSupport.getEWTDropTarget((JComponent)jComponent) != null) {
            return;
        }
        DropTarget dropTarget = new DropTarget((Component)jComponent, (DropTargetListener)this._listener);
        int n = jComponent.getComponentCount();
        int n2 = 0;
        while (n2 < n) {
            Component component = jComponent.getComponent(n2);
            if (component instanceof JComponent) {
                this._addDropTarget((JComponent)component);
            }
            ++n2;
        }
    }

    private void _removeDropTarget(JComponent jComponent) {
        DropTarget dropTarget = JFCSupport.getEWTDropTarget((JComponent)jComponent);
        boolean bl = true;
        try {
            dropTarget.removeDropTargetListener((DropTargetListener)this._listener);
        }
        catch (Exception exception) {
            bl = false;
        }
        if (bl) {
            JFCSupport.setEWTDropTarget((JComponent)jComponent, null);
        }
        int n = jComponent.getComponentCount();
        int n2 = 0;
        while (n2 < n) {
            Component component = jComponent.getComponent(n2);
            if (component instanceof JComponent) {
                this._removeDropTarget((JComponent)component);
            }
            ++n2;
        }
    }

    private class MenuAction
    extends AbstractAction {
        private MenuAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Rectangle rectangle;
            Accessible accessible;
            Container container = JInternalFrameViewBuilderCanvas.this.getParent();
            if (container instanceof JViewport) {
                accessible = (JViewport)container;
                rectangle = ((JViewport)accessible).getViewRect();
            } else {
                rectangle = JInternalFrameViewBuilderCanvas.this.getBounds();
            }
            accessible = JInternalFrameViewBuilderCanvas.this.getViewBuilder();
            int n = 0;
            while (n < JInternalFrameViewBuilderCanvas.this._selectedLinkPainters.size()) {
                ViewBuilderLinkPainter viewBuilderLinkPainter = (ViewBuilderLinkPainter)((Object)JInternalFrameViewBuilderCanvas.this._selectedLinkPainters.elementAt(n));
                Point point = viewBuilderLinkPainter.getPoint(accessible.getPaintContext(), rectangle);
                if (point != null) {
                    point = SwingUtilities.convertPoint(JInternalFrameViewBuilderCanvas.this, point, (Component)((Object)accessible));
                    ((ViewBuilder)accessible).showMenu(viewBuilderLinkPainter.getLink(), point.x, point.y);
                    break;
                }
                ++n;
            }
        }

        public boolean isEnabled() {
            return JInternalFrameViewBuilderCanvas.this._selectedLinkPainters.size() != 0;
        }
    }

    private class Listener
    extends ComponentAdapter
    implements PropertyChangeListener,
    DropTargetListener,
    Task {
        private Point _point;
        private Table _table;
        private Column _column;

        private Listener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            Object object = propertyChangeEvent.getSource();
            Object object2 = propertyChangeEvent.getNewValue();
            if ("selected".equals(string)) {
                if (object instanceof ViewBuilderLink) {
                    JInternalFrameViewBuilderCanvas.this._updateLinkSelectionState((ViewBuilderLink)object, (Boolean)object2);
                }
            } else if ("active".equals(string)) {
                if (object instanceof ViewBuilderLink) {
                    JInternalFrameViewBuilderCanvas.this._updateLinkActiveState((ViewBuilderLink)object, (Boolean)object2);
                }
            } else if ("invalid".equals(string)) {
                JInternalFrameViewBuilderCanvas.this.repaint();
            } else if ("bounds".equals(string)) {
                ViewBuilderComponent viewBuilderComponent = (ViewBuilderComponent)propertyChangeEvent.getSource();
                JInternalFrameViewBuilderCanvas.this._invalidateJoins(viewBuilderComponent);
                JInternalFrameViewBuilderCanvas.this._validateScrollBox();
            } else {
                JInternalFrameViewBuilderCanvas.this.repaint();
            }
        }

        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            if (this._acceptDrag(dropTargetDragEvent)) {
                JInternalFrameViewBuilderCanvas.this._color = ((Component)((Object)JInternalFrameViewBuilderCanvas.this._builder)).getBackground();
                ((JComponent)((Object)JInternalFrameViewBuilderCanvas.this._builder)).setBackground(Color.lightGray);
            } else {
                dropTargetDragEvent.rejectDrag();
            }
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            if (!this._acceptDrag(dropTargetDragEvent)) {
                dropTargetDragEvent.rejectDrag();
            }
        }

        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }

        public void dragExit(DropTargetEvent dropTargetEvent) {
            if (JInternalFrameViewBuilderCanvas.this._color != null) {
                ((JComponent)((Object)JInternalFrameViewBuilderCanvas.this._builder)).setBackground(JInternalFrameViewBuilderCanvas.this._color);
            }
            JInternalFrameViewBuilderCanvas.this._color = null;
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            Object object;
            if (JInternalFrameViewBuilderCanvas.this._color != null) {
                ((JComponent)((Object)JInternalFrameViewBuilderCanvas.this._builder)).setBackground(JInternalFrameViewBuilderCanvas.this._color);
            }
            JInternalFrameViewBuilderCanvas.this._color = null;
            DropTargetContext dropTargetContext = dropTargetDropEvent.getDropTargetContext();
            if (!JInternalFrameViewBuilderCanvas.this.isEnabled()) {
                dropTargetDropEvent.rejectDrop();
                dropTargetContext.dropComplete(false);
                return;
            }
            dropTargetDropEvent.acceptDrop(2);
            Transferable transferable = dropTargetDropEvent.getTransferable();
            Table table = null;
            Column column = null;
            if (transferable.isDataFlavorSupported(DBUIDataFlavors.COLUMN_FLAVOR)) {
                object = null;
                try {
                    object = transferable.getTransferData(DBUIDataFlavors.COLUMN_FLAVOR);
                }
                catch (IOException iOException) {
                    object = null;
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    object = null;
                }
                if (object instanceof Column && (column = (Column)object) != null) {
                    table = column.getTable();
                }
            }
            if (table == null && transferable.isDataFlavorSupported(DBUIDataFlavors.TABLE_FLAVOR)) {
                object = null;
                try {
                    object = transferable.getTransferData(DBUIDataFlavors.TABLE_FLAVOR);
                }
                catch (IOException iOException) {
                    object = null;
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    object = null;
                }
                if (object instanceof Table) {
                    table = (Table)object;
                }
            }
            if (table != null) {
                object = dropTargetDropEvent.getLocation();
                Component component = dropTargetContext.getComponent();
                while (component != JInternalFrameViewBuilderCanvas.this._builder && component != null) {
                    Point point = component.getLocation();
                    ((Point)object).x += point.x;
                    ((Point)object).y += point.y;
                    component = component.getParent();
                }
                this._table = table;
                this._column = column;
                this._point = object;
                DBUILookAndFeel.getLookAndFeel().setCursor(JInternalFrameViewBuilderCanvas.this, true);
                DBUILookAndFeel.getTaskScheduler().schedule((Task)this, 100);
            }
            dropTargetContext.dropComplete(table != null);
        }

        private boolean _acceptDrag(DropTargetDragEvent dropTargetDragEvent) {
            if (!JInternalFrameViewBuilderCanvas.this.isEnabled()) {
                return false;
            }
            DataFlavor[] dataFlavorArray = dropTargetDragEvent.getCurrentDataFlavors();
            if (dataFlavorArray == null) {
                return false;
            }
            int n = 0;
            while (n < dataFlavorArray.length) {
                if (TransferUtils.supportsDataFlavor((DataFlavor)dataFlavorArray[n], (DataFlavor)DBUIDataFlavors.TABLE_FLAVOR)) {
                    return true;
                }
                if (TransferUtils.supportsDataFlavor((DataFlavor)dataFlavorArray[n], (DataFlavor)DBUIDataFlavors.COLUMN_FLAVOR)) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        public void runTask(TaskEvent taskEvent) {
            if (!JInternalFrameViewBuilderCanvas.this._builder.isTableVisible(this._table)) {
                JInternalFrameViewBuilderCanvas.this._builder.addTable(this._table, this._point.x, this._point.y);
            }
            DBUILookAndFeel.getLookAndFeel().setCursor(JInternalFrameViewBuilderCanvas.this, false);
            if (this._column != null) {
                JInternalFrameViewBuilderCanvas.this._builder.setColumnSelected(this._column, true);
            }
            ((Component)((Object)JInternalFrameViewBuilderCanvas.this._builder)).repaint();
        }

        public void componentMoved(ComponentEvent componentEvent) {
            JInternalFrameViewBuilderCanvas.this._invalidateJoins((ViewBuilderComponent)((Object)((JInternalFrame.JDesktopIcon)componentEvent.getComponent()).getInternalFrame()));
        }
    }
}

