/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.viewBuilder;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import oracle.bali.dbUI.viewBuilder.ViewBuilderLink;
import oracle.bali.ewt.painter.AbstractPainter;
import oracle.bali.ewt.painter.PaintContext;

public abstract class ViewBuilderLinkPainter
extends AbstractPainter {
    public static final String PROPERTY_INVALID = "invalid";
    private PropertyChangeSupport _support;
    private boolean _valid;
    private ViewBuilderLink _link;
    private PropertyChangeListener _listener;

    public ViewBuilderLinkPainter(ViewBuilderLink viewBuilderLink) {
        if (viewBuilderLink == null) {
            throw new IllegalArgumentException();
        }
        this._link = viewBuilderLink;
        this._addPropertyChangeListener();
    }

    public abstract void paint(PaintContext var1, Graphics var2, int var3, int var4, int var5, int var6);

    public abstract boolean contains(PaintContext var1, int var2, int var3);

    public abstract Rectangle getBounds(PaintContext var1);

    public abstract Dimension getMinimumSize(PaintContext var1);

    public ViewBuilderLink getLink() {
        return this._link;
    }

    public void invalidate() {
        if (this._valid) {
            this._valid = false;
            this.firePropertyChange(PROPERTY_INVALID, Boolean.TRUE, Boolean.FALSE);
        }
    }

    public void validate(PaintContext paintContext) {
        if (this._valid) {
            return;
        }
        this.validatePainter(paintContext);
        this._valid = true;
    }

    public void cleanup() {
        this._removePropertyChangeListener();
        this._link = null;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._support == null) {
            this._support = new PropertyChangeSupport((Object)this);
        }
        this._support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._support != null) {
            this._support.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public Point getPoint(PaintContext paintContext, Rectangle rectangle) {
        if (rectangle == null || rectangle.isEmpty()) {
            return null;
        }
        Rectangle rectangle2 = this.getBounds(paintContext);
        if (rectangle2 == null || !rectangle.intersects(rectangle2)) {
            return null;
        }
        Rectangle rectangle3 = rectangle.intersection(rectangle2);
        int n = rectangle3.x;
        int n2 = rectangle3.y;
        if (this.contains(paintContext, n, n2)) {
            return new Point(n, n2);
        }
        n = rectangle3.x + rectangle3.width;
        n2 = rectangle3.y;
        if (this.contains(paintContext, n, n2)) {
            return new Point(n, n2);
        }
        n = rectangle3.x + rectangle3.width;
        n2 = rectangle3.y + rectangle3.height;
        if (this.contains(paintContext, n, n2)) {
            return new Point(n, n2);
        }
        n = rectangle3.x;
        n2 = rectangle3.y + rectangle3.height;
        if (this.contains(paintContext, n, n2)) {
            return new Point(n, n2);
        }
        return null;
    }

    protected void validatePainter(PaintContext paintContext) {
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (this._support != null) {
            this._support.firePropertyChange(string, object, object2);
        }
    }

    private void _addPropertyChangeListener() {
        this._listener = new Invalidate();
        int n = this.getLink().getPortCount();
        int n2 = 0;
        while (n2 < n) {
            this.getLink().getSourcePort(n2).addPropertyChangeListener(this._listener);
            this.getLink().getDestinationPort(n2).addPropertyChangeListener(this._listener);
            ++n2;
        }
    }

    private void _removePropertyChangeListener() {
        int n = this.getLink().getPortCount();
        int n2 = 0;
        while (n2 < n) {
            this.getLink().getSourcePort(n2).removePropertyChangeListener(this._listener);
            this.getLink().getDestinationPort(n2).removePropertyChangeListener(this._listener);
            ++n2;
        }
        this._listener = null;
    }

    private class Invalidate
    implements PropertyChangeListener {
        private Invalidate() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("bounds".equals(string)) {
                ViewBuilderLinkPainter.this.invalidate();
            }
        }
    }
}

