/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.viewBuilder;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import oracle.bali.dbUI.viewBuilder.ViewBuilderLinkPort;

public class ViewBuilderLink {
    public static final String PROPERTY_SELECTED = "selected";
    public static final String PROPERTY_ACTIVE = "active";
    private ViewBuilderLinkPort _source;
    private ViewBuilderLinkPort _destination;
    private ViewBuilderLinkPort[] _sources;
    private ViewBuilderLinkPort[] _destinations;
    private boolean _selected;
    private boolean _active;
    private PropertyChangeSupport _support;

    public ViewBuilderLink(ViewBuilderLinkPort viewBuilderLinkPort, ViewBuilderLinkPort viewBuilderLinkPort2) {
        if (viewBuilderLinkPort == null || viewBuilderLinkPort2 == null) {
            throw new IllegalArgumentException();
        }
        this._source = viewBuilderLinkPort;
        this._destination = viewBuilderLinkPort2;
    }

    public ViewBuilderLink(ViewBuilderLinkPort[] viewBuilderLinkPortArray, ViewBuilderLinkPort[] viewBuilderLinkPortArray2) {
        if (viewBuilderLinkPortArray == null || viewBuilderLinkPortArray2 == null || viewBuilderLinkPortArray.length != viewBuilderLinkPortArray2.length || viewBuilderLinkPortArray.length == 0) {
            throw new IllegalArgumentException();
        }
        int n = viewBuilderLinkPortArray.length;
        if (n == 1) {
            this._source = viewBuilderLinkPortArray[0];
            this._destination = viewBuilderLinkPortArray2[0];
        } else {
            this._sources = new ViewBuilderLinkPort[n];
            this._destinations = new ViewBuilderLinkPort[n];
            System.arraycopy(viewBuilderLinkPortArray, 0, this._sources, 0, n);
            System.arraycopy(viewBuilderLinkPortArray2, 0, this._destinations, 0, n);
        }
    }

    public int getPortCount() {
        return this._sources == null ? 1 : this._sources.length;
    }

    public ViewBuilderLinkPort getSourcePort(int n) {
        return this._sources == null ? this._source : this._sources[n];
    }

    public ViewBuilderLinkPort getDestinationPort(int n) {
        return this._destinations == null ? this._destination : this._destinations[n];
    }

    public void setSelected(boolean bl) {
        if (this._selected != bl) {
            this._selected = bl;
            this.fireBooleanPropertyChange(PROPERTY_SELECTED, this._selected);
        }
    }

    public boolean isSelected() {
        return this._selected;
    }

    public void setActive(boolean bl) {
        if (this._active != bl) {
            this._active = bl;
            this.fireBooleanPropertyChange(PROPERTY_ACTIVE, this._active);
        }
    }

    public boolean isActive() {
        return this._active;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._support == null) {
            this._support = new PropertyChangeSupport(this);
        }
        this._support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._support != null) {
            this._support.removePropertyChangeListener(propertyChangeListener);
        }
    }

    protected void fireBooleanPropertyChange(String string, boolean bl) {
        if (bl) {
            this.firePropertyChange(string, Boolean.FALSE, Boolean.TRUE);
        } else {
            this.firePropertyChange(string, Boolean.TRUE, Boolean.FALSE);
        }
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (this._support != null) {
            this._support.firePropertyChange(string, object, object2);
        }
    }
}

