/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.viewBuilder;

import java.awt.AWTEvent;
import oracle.bali.dbUI.db.OuterJoin;
import oracle.bali.dbUI.db.Relationship;
import oracle.bali.dbUI.db.Table;
import oracle.bali.dbUI.viewBuilder.ViewBuilder;

public class ViewBuilderEvent
extends AWTEvent {
    private static final int EVENT_START = 2000;
    public static final int TABLE_ADDING = 2000;
    public static final int TABLE_ADDED = 2001;
    public static final int TABLE_REMOVING = 2002;
    public static final int TABLE_REMOVED = 2003;
    public static final int RELATIONSHIP_ADDING = 2004;
    public static final int RELATIONSHIP_ADDED = 2005;
    public static final int RELATIONSHIP_REMOVING = 2006;
    public static final int RELATIONSHIP_REMOVED = 2007;
    public static final int OUTERJOIN_ADDED = 2008;
    public static final int OUTERJOIN_REMOVED = 2009;
    private Table _table;
    private Relationship _join;
    private OuterJoin _outerJoin;

    public ViewBuilderEvent(ViewBuilder viewBuilder, int n) {
        super(viewBuilder, n);
    }

    public ViewBuilderEvent(ViewBuilder viewBuilder, int n, Table table) {
        super(viewBuilder, n);
        this._table = table;
    }

    public ViewBuilderEvent(ViewBuilder viewBuilder, int n, Relationship relationship) {
        super(viewBuilder, n);
        this._join = relationship;
    }

    public ViewBuilderEvent(ViewBuilder viewBuilder, int n, OuterJoin outerJoin) {
        super(viewBuilder, n);
        this._outerJoin = outerJoin;
    }

    public ViewBuilder getViewBuilder() {
        return (ViewBuilder)this.getSource();
    }

    public Table getTable() {
        return this._table;
    }

    public Relationship getRelationship() {
        return this._join;
    }

    public OuterJoin getOuterJoin() {
        return this._outerJoin;
    }

    public String toString() {
        return "ViewBuilderEvent: " + this._getIDString(this.getID());
    }

    private String _getIDString(int n) {
        String string = null;
        switch (n) {
            case 2000: {
                string = "adding table: " + this.getTable().getName();
                break;
            }
            case 2001: {
                string = "added table: " + this.getTable().getName();
                break;
            }
            case 2002: {
                string = "removing table: " + this.getTable().getName();
                break;
            }
            case 2003: {
                string = "removed table: " + this.getTable().getName();
                break;
            }
            case 2004: {
                string = "adding relationship " + this.getRelationship().getName();
                break;
            }
            case 2005: {
                string = "added relationship " + this.getRelationship().getName();
                break;
            }
            case 2006: {
                string = "removing relationship " + this.getRelationship().getName();
                break;
            }
            case 2007: {
                string = "removed relationship " + this.getRelationship().getName();
                break;
            }
            case 2008: {
                string = "added outerjoin " + this.getOuterJoin().getSource().getName() + " to " + this.getOuterJoin().getDestination().getName();
                break;
            }
            case 2009: {
                string = "removed outerjoin " + this.getOuterJoin().getSource().getName() + " to " + this.getOuterJoin().getDestination().getName();
            }
        }
        return string;
    }
}

