/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.viewBuilder;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.Serializable;
import java.text.Format;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import oracle.bali.dbUI.db.Column;
import oracle.bali.dbUI.db.DynamicRelationship;
import oracle.bali.dbUI.db.DynamicTable;
import oracle.bali.dbUI.db.OuterJoin;
import oracle.bali.dbUI.db.Relationship;
import oracle.bali.dbUI.db.Table;
import oracle.bali.dbUI.db.event.DynamicRelationshipEvent;
import oracle.bali.dbUI.db.event.DynamicRelationshipListener;
import oracle.bali.dbUI.db.event.DynamicTableAdapter;
import oracle.bali.dbUI.db.event.DynamicTableEvent;
import oracle.bali.dbUI.db.impl.DynamicRelationshipImpl;
import oracle.bali.dbUI.laf.DBUILookAndFeel;
import oracle.bali.dbUI.tableComponent.TableComponent;
import oracle.bali.dbUI.viewBuilder.ColumnLinkPort;
import oracle.bali.dbUI.viewBuilder.JoinMaker;
import oracle.bali.dbUI.viewBuilder.RelationshipLink;
import oracle.bali.dbUI.viewBuilder.TableViewBuilderComponent;
import oracle.bali.dbUI.viewBuilder.VBOuterJoinListener;
import oracle.bali.dbUI.viewBuilder.VBRelationshipListener;
import oracle.bali.dbUI.viewBuilder.VBTableListener;
import oracle.bali.dbUI.viewBuilder.ViewBuilderCanvas;
import oracle.bali.dbUI.viewBuilder.ViewBuilderComponent;
import oracle.bali.dbUI.viewBuilder.ViewBuilderCustomizer;
import oracle.bali.dbUI.viewBuilder.ViewBuilderEvent;
import oracle.bali.dbUI.viewBuilder.ViewBuilderLink;
import oracle.bali.dbUI.viewBuilder.ViewBuilderLinkPort;
import oracle.bali.dbUI.viewBuilder.ViewBuilderValidateEvent;
import oracle.bali.dbUI.viewBuilder.swing.JInternalFrameTableComponent;
import oracle.bali.dbUI.viewBuilder.swing.JInternalFrameViewBuilderCanvas;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.grid.CellInputHandler;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.util.LocaleUtils;
import oracle.bali.ewt.util.StringUtils;
import oracle.bali.share.event.ListenerManager;
import oracle.bali.share.thread.Task;
import oracle.bali.share.thread.TaskEvent;

public class ViewBuilder
extends LWComponent
implements Accessible {
    public static final String PROPERTY_SELECTED_COLUMNS = "selectedColumns";
    public static final String PROPERTY_SELECTED_TABLES = "selectedTables";
    public static final String PROPERTY_SELECTED_RELATIONSHIPS = "selectedRelationships";
    public static final String PROPERTY_INCLUDED_RELATIONSHIPS = "includedRelationships";
    private static final String _KEY_EQUAL = "VIEWBUILDER.EQUAL";
    private static final String _KEY_NOT_EQUAL = "VIEWBUILDER.NOT_EQUAL";
    private static final String _KEY_GREATER = "VIEWBUILDER.GREATER";
    private static final String _KEY_LESS = "VIEWBUILDER.LESS";
    private static final String _KEY_LESSEQUAL = "VIEWBUILDER.LESSEQUAL";
    private static final String _KEY_GREATEREQUAL = "VIEWBUILDER.GREATEREQUAL";
    private static final String _OPTIONS_KEY = "OPTIONS";
    private static final String _SHOW_RELATED_TABLES_KEY = "SHOW_RELATED_TABLES";
    private static final String _HIDE_RELATED_TABLES_KEY = "HIDE_RELATED_TABLES";
    private static final String _CREATE_OUTER_JOIN_KEY = "VIEWBUILDER.CREATE_OUTER_JOIN";
    private static final String _DELETE_OUTER_JOIN_KEY = "VIEWBUILDER.DELETE_OUTER_JOIN";
    private static final String _EQUAL_KEY = "EQUAL";
    private static final String _NOT_EQUAL_KEY = "NOT_EQUAL";
    private static final String _GREATER_KEY = "GREATER";
    private static final String _LESS_KEY = "LESS";
    private static final String _GREATER_OR_EQUAL_KEY = "GREATER_OR_EQUAL";
    private static final String _LESS_OR_EQUAL_KEY = "LESS_OR_EQUAL";
    private static final String _KEY_LINKTO = "VIEWBUILDER.LINK_TO";
    private static final String _KEY_DELETELINK = "VIEWBUILDER.DELETE_LINK";
    static final String TABLES_COMMAND = "tables";
    static final String HIDE_TABLES_COMMAND = "hide_tables";
    static final String EQUAL_COMMAND = "EQUAL";
    static final String NOT_EQUAL_COMMAND = "NOT_EQUAL";
    static final String GREATER_COMMAND = "GREATER";
    static final String LESS_COMMAND = "LESS";
    static final String GREATER_OR_EQUAL_COMMAND = "GREATER_OR_EQUAL";
    static final String LESS_OR_EQUAL_COMMAND = "LESS_OR_EQUAL";
    static final String COMMAND_LINK = "LINK";
    static final String COMMAND_DELETE_LINK = "DELETE_LINK";
    static final String COMMAND_CREATE_OUTER_JOIN = "CREATE_OUTER_JOIN";
    static final String COMMAND_DELETE_OUTER_JOIN = "DELETE_OUTER_JOIN";
    static final String COMMAND_LEFT = "LEFT";
    static final String COMMAND_RIGHT = "RIGHT";
    static final String COMMAND_DELETE = "DELETE";
    static final String COMMAND_TAB = "TAB";
    static final String COMMAND_SELECT = "SELECT";
    private static final String _KEY_CANVAS_NAME = "VIEWBUILDER_CANVAS_NAME";
    private static final String _ALL = "UPDATE_ALL";
    private static final String _COLUMNS = "UPDATE_COLUMNS";
    private ViewBuilderCanvas _canvas;
    private JScrollPane _scrollBox;
    private Listener _listener;
    private ViewBuilderCustomizer _customizer;
    private Vector _links;
    private Vector _tableInfo;
    private Vector _customComponents;
    private ListenerManager _tableListeners;
    private ListenerManager _columnListeners;
    private ListenerManager _relationshipListeners;
    private ListenerManager _outerJoinListeners;
    private Relationship _menuRelationship;
    private JPopupMenu _menu;
    private ViewBuilderLinkPort _startPort;
    private ViewBuilderLinkPort _lastPort;
    private int _anchorX;
    private int _anchorY;
    private int _joinX;
    private int _joinY;
    private Column _menuColumn;
    private boolean _linkCreationAllowed;
    private boolean _linkDeletionAllowed;
    private boolean _outerJoinCreationAllowed;
    private Vector _outerJoins;

    public ViewBuilder() {
        this(null);
    }

    public ViewBuilder(Table[] tableArray) {
        ((JComponent)((Object)this)).setBackground(Color.white);
        this._tableInfo = new Vector();
        this._customComponents = new Vector();
        this._links = new Vector();
        this._listener = new Listener();
        this._linkCreationAllowed = true;
        this._linkDeletionAllowed = true;
        this._outerJoinCreationAllowed = true;
        ((Container)((Object)this)).setLayout(new BorderLayout());
        this._canvas = this.createViewBuilderCanvas();
        this._canvas.setViewBuilder(this);
        this._scrollBox = new JScrollPane(this._canvas.getComponent());
        ((Container)((Object)this)).add("Center", this._scrollBox);
        if (tableArray != null) {
            this.setTables(tableArray);
        }
        ((Component)((Object)this)).enableEvents(12L);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(9, 0);
        ((JComponent)((Object)this)).registerKeyboardAction(this._listener, COMMAND_TAB, keyStroke, 1);
        keyStroke = KeyStroke.getKeyStroke(127, 0);
        ((JComponent)((Object)this)).registerKeyboardAction(this._listener, COMMAND_DELETE, keyStroke, 1);
        keyStroke = KeyStroke.getKeyStroke(8, 0);
        ((JComponent)((Object)this)).registerKeyboardAction(this._listener, COMMAND_DELETE, keyStroke, 1);
        keyStroke = KeyStroke.getKeyStroke(37, 0);
        ((JComponent)((Object)this)).registerKeyboardAction(this._listener, COMMAND_LEFT, keyStroke, 0);
        keyStroke = KeyStroke.getKeyStroke(32, 0);
        ((JComponent)((Object)this)).registerKeyboardAction(this._listener, COMMAND_SELECT, keyStroke, 0);
        keyStroke = KeyStroke.getKeyStroke(39, 0);
        ((JComponent)((Object)this)).registerKeyboardAction(this._listener, COMMAND_RIGHT, keyStroke, 0);
    }

    public boolean isTableVisible(Table table) {
        return this._getTableInfo(table) != null;
    }

    public void addTable(Table table) {
        this.addTable(table, -1, -1);
    }

    public void addTable(Table table, int n, int n2) {
        if (this._getTableInfo(table) == null) {
            this._createUI(table, n, n2);
            this._checkForJoins(table, true);
        }
        this.scrollTableToView(table);
    }

    public void removeTable(Table table) {
        Object object;
        TableInfo tableInfo = this._getTableInfo(table);
        if (tableInfo == null) {
            return;
        }
        table = tableInfo.getTable();
        if (table instanceof DynamicTable) {
            object = (DynamicTable)table;
            ((DynamicTable)object).removePropertyChangeListener(this._listener);
            ((DynamicTable)object).removeTableListener(this._listener);
        }
        this._removeLinks(tableInfo);
        object = tableInfo.getTableComponent();
        ((Component)object).removePropertyChangeListener(this._listener);
        boolean bl = ((TableComponent)object).getSelectedColumnCount() != 0;
        ((TableComponent)object).setAllColumnsSelected(false);
        ((TableComponent)object).setTable(null);
        TableViewBuilderComponent tableViewBuilderComponent = tableInfo.getViewBuilderComponent();
        tableViewBuilderComponent.removePropertyChangeListener(this._listener);
        tableViewBuilderComponent.removeVetoableChangeListener(this._listener);
        this._tableInfo.removeElement(tableInfo);
        tableInfo.clear();
        tableViewBuilderComponent.close();
        tableViewBuilderComponent.setTableComponent(null);
        if (bl) {
            this._selectionChanged(table);
        }
        ((Container)((Object)this)).invalidate();
    }

    public void setTables(Table[] tableArray) {
        this.removeAll();
        if (tableArray != null) {
            int n = 0;
            while (n < tableArray.length) {
                Table table = tableArray[n];
                if (this._getTableInfo(table) == null) {
                    this._createUI(table, -1, -1);
                    this._checkForJoins(table, true);
                }
                ++n;
            }
        }
    }

    public Table[] getTables() {
        int n = this._tableInfo.size();
        Table[] tableArray = new Table[n];
        int n2 = 0;
        while (n2 < n) {
            tableArray[n2] = ((TableInfo)this._tableInfo.elementAt(n2)).getTable();
            ++n2;
        }
        return tableArray;
    }

    public void addRelatedTables(Table table) {
        this._addRelatedTables(table, false);
    }

    public void setTableSelected(Table table, boolean bl) {
        TableInfo tableInfo = this._getTableInfo(table);
        if (tableInfo != null) {
            tableInfo.getViewBuilderComponent().setComponentSelected(bl);
        }
    }

    public boolean isTableSelected(Table table) {
        TableInfo tableInfo = this._getTableInfo(table);
        return tableInfo == null ? false : tableInfo.getViewBuilderComponent().isComponentSelected();
    }

    public Table[] getSelectedTables() {
        Vector<Table> vector = new Vector<Table>();
        int n = this._tableInfo.size();
        int n2 = 0;
        while (n2 < n) {
            TableInfo tableInfo = (TableInfo)this._tableInfo.elementAt(n2);
            if (tableInfo.getViewBuilderComponent().isComponentSelected()) {
                vector.addElement(tableInfo.getTable());
            }
            ++n2;
        }
        Object[] objectArray = new Table[vector.size()];
        if (vector.size() != 0) {
            vector.copyInto(objectArray);
        }
        return objectArray;
    }

    public Rectangle getTableBounds(Table table) {
        TableViewBuilderComponent tableViewBuilderComponent = this.getComponent(table);
        return tableViewBuilderComponent == null ? null : tableViewBuilderComponent.getComponentBounds();
    }

    public void setTableBounds(Table table, Rectangle rectangle) {
        TableViewBuilderComponent tableViewBuilderComponent = this.getComponent(table);
        if (tableViewBuilderComponent != null) {
            tableViewBuilderComponent.setComponentBounds(rectangle);
        }
    }

    public boolean isColumnSelected(Column column) {
        boolean bl = false;
        TableInfo tableInfo = this._getTableInfo(column.getTable());
        return tableInfo == null ? false : tableInfo.getTableComponent().isColumnSelected(column);
    }

    public void setColumnSelected(Column column, boolean bl) {
        Table table = column.getTable();
        TableInfo tableInfo = this._getTableInfo(table);
        if (tableInfo != null) {
            tableInfo.getTableComponent().setColumnSelected(column, bl);
            this._selectionChanged(table);
        }
    }

    public Column[] getSelectedColumns() {
        Vector<Column> vector = new Vector<Column>();
        int n = this._tableInfo.size();
        int n2 = 0;
        while (n2 < n) {
            TableInfo tableInfo = (TableInfo)this._tableInfo.elementAt(n2);
            TableComponent tableComponent = tableInfo.getTableComponent();
            Column[] columnArray = tableComponent.getSelectedColumns();
            if (columnArray != null && columnArray.length != 0) {
                vector.addAll(Arrays.asList(columnArray));
            }
            ++n2;
        }
        int n3 = vector.size();
        Object[] objectArray = new Column[n3];
        if (n3 != 0) {
            vector.copyInto(objectArray);
        }
        return objectArray;
    }

    public void addRelationship(Relationship relationship) {
        Object object;
        if (this._getLink(relationship) != null) {
            return;
        }
        int n = relationship.getColumnCount();
        if (n <= 0) {
            throw new IllegalArgumentException("relationship is invalid");
        }
        Table table = relationship.getColumn(0).getTable();
        TableInfo tableInfo = this._getTableInfo(table);
        if (tableInfo == null) {
            throw new IllegalArgumentException(table + " must be added");
        }
        Table table2 = relationship.getReferencedColumn(0).getTable();
        TableInfo tableInfo2 = this._getTableInfo(table2);
        if (tableInfo2 == null) {
            throw new IllegalArgumentException(table2 + " table must be added");
        }
        if (relationship instanceof DynamicRelationship) {
            object = (DynamicRelationship)relationship;
            ((DynamicRelationship)object).addPropertyChangeListener(this._listener);
            ((DynamicRelationship)object).addRelationshipListener(this._listener);
        }
        object = tableInfo.getViewBuilderComponent();
        TableViewBuilderComponent tableViewBuilderComponent = tableInfo2.getViewBuilderComponent();
        TableComponent tableComponent = tableInfo.getTableComponent();
        TableComponent tableComponent2 = tableInfo2.getTableComponent();
        ColumnLinkPort[] columnLinkPortArray = new ColumnLinkPort[n];
        ColumnLinkPort[] columnLinkPortArray2 = new ColumnLinkPort[n];
        int n2 = 0;
        while (n2 < n) {
            columnLinkPortArray[n2] = object.getColumnLinkPort(relationship.getColumn(n2));
            columnLinkPortArray2[n2] = tableViewBuilderComponent.getColumnLinkPort(relationship.getReferencedColumn(n2));
            ++n2;
        }
        RelationshipLink relationshipLink = new RelationshipLink(columnLinkPortArray, columnLinkPortArray2, relationship);
        this._links.addElement(relationshipLink);
        this.getCanvas().addViewBuilderLink(relationshipLink);
        this._clearLinks();
        this._checkForOuterJoin(relationshipLink, tableInfo, tableInfo2);
    }

    public void removeRelationship(Relationship relationship) {
        RelationshipLink relationshipLink = this._getLink(relationship);
        if (relationshipLink == null) {
            return;
        }
        if (relationship instanceof DynamicRelationship) {
            DynamicRelationship dynamicRelationship = (DynamicRelationship)relationship;
            dynamicRelationship.removePropertyChangeListener(this._listener);
            dynamicRelationship.removeRelationshipListener(this._listener);
        }
        if (this.isRelationshipSelected(relationship)) {
            this.setRelationshipSelected(relationship, false);
            ((Component)((Object)this)).firePropertyChange(PROPERTY_SELECTED_RELATIONSHIPS, null, this.getSelectedRelationships());
        }
        if (this.isRelationshipIncluded(relationship)) {
            this.setRelationshipIncluded(relationship, false);
        }
        this._links.removeElement(relationshipLink);
        this.getCanvas().removeViewBuilderLink(relationshipLink);
        this._clearLinks();
    }

    public Relationship[] getRelationships() {
        Vector<Relationship> vector = new Vector<Relationship>();
        int n = this._links.size();
        int n2 = 0;
        while (n2 < n) {
            ViewBuilderLink viewBuilderLink = (ViewBuilderLink)this._links.elementAt(n2);
            if (viewBuilderLink instanceof RelationshipLink) {
                RelationshipLink relationshipLink = (RelationshipLink)viewBuilderLink;
                vector.addElement(relationshipLink.getRelationship());
            }
            ++n2;
        }
        n = vector.size();
        Object[] objectArray = new Relationship[n];
        if (n != 0) {
            vector.copyInto(objectArray);
        }
        return objectArray;
    }

    public void setRelationships(Relationship[] relationshipArray) {
        this.freezeRepaints();
        try {
            Relationship[] relationshipArray2 = this.getRelationships();
            int n = relationshipArray2.length;
            int n2 = 0;
            while (n2 < n) {
                this.removeRelationship(relationshipArray2[n2]);
                ++n2;
            }
            n = relationshipArray == null ? 0 : relationshipArray.length;
            int n3 = 0;
            while (n3 < n) {
                this.addRelationship(relationshipArray[n3]);
                ++n3;
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.unfreezeRepaints();
            throw throwable;
        }
        this.unfreezeRepaints();
    }

    public void setRelationshipSelected(Relationship relationship, boolean bl) {
        RelationshipLink relationshipLink;
        AccessibleContext accessibleContext = ((JComponent)((Object)this)).accessibleContext;
        String string = null;
        if (accessibleContext != null) {
            string = accessibleContext.getAccessibleName();
        }
        if ((relationshipLink = this._getLink(relationship)) == null) {
            return;
        }
        relationshipLink.setSelected(bl);
        this._highlightJoin(relationship, bl);
        if (accessibleContext != null) {
            String string2 = accessibleContext.getAccessibleName();
            accessibleContext.firePropertyChange("AccessibleName", string, string2);
        }
    }

    public boolean isRelationshipSelected(Relationship relationship) {
        RelationshipLink relationshipLink = this._getLink(relationship);
        return relationshipLink == null ? false : relationshipLink.isSelected();
    }

    public Relationship[] getSelectedRelationships() {
        Vector<Relationship> vector = new Vector<Relationship>();
        int n = this._links.size();
        int n2 = 0;
        while (n2 < n) {
            ViewBuilderLink viewBuilderLink = (ViewBuilderLink)this._links.elementAt(n2);
            if (viewBuilderLink.isSelected() && viewBuilderLink instanceof RelationshipLink) {
                RelationshipLink relationshipLink = (RelationshipLink)viewBuilderLink;
                vector.addElement(relationshipLink.getRelationship());
            }
            ++n2;
        }
        Object[] objectArray = new Relationship[vector.size()];
        if (vector.size() != 0) {
            vector.copyInto(objectArray);
        }
        return objectArray;
    }

    public void setAllRelationshipsSelected(boolean bl) {
        Relationship[] relationshipArray = this.getRelationships();
        this.freezeRepaints();
        try {
            int n = relationshipArray.length;
            int n2 = 0;
            while (n2 < n) {
                this.setRelationshipSelected(relationshipArray[n2], bl);
                ++n2;
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.unfreezeRepaints();
            throw throwable;
        }
        this.unfreezeRepaints();
    }

    public void setRelationshipIncluded(Relationship relationship, boolean bl) {
        RelationshipLink relationshipLink = this._getLink(relationship);
        if (relationshipLink != null) {
            relationshipLink.setIncluded(bl);
            ((Component)((Object)this)).firePropertyChange(PROPERTY_INCLUDED_RELATIONSHIPS, null, this.getIncludedRelationships());
        }
    }

    public boolean isRelationshipIncluded(Relationship relationship) {
        RelationshipLink relationshipLink = this._getLink(relationship);
        return relationshipLink == null ? false : relationshipLink.isIncluded();
    }

    public Relationship[] getIncludedRelationships() {
        Vector<Relationship> vector = new Vector<Relationship>();
        int n = this._links.size();
        int n2 = 0;
        while (n2 < n) {
            RelationshipLink relationshipLink;
            ViewBuilderLink viewBuilderLink = (ViewBuilderLink)this._links.elementAt(n2);
            if (viewBuilderLink instanceof RelationshipLink && (relationshipLink = (RelationshipLink)viewBuilderLink).isIncluded()) {
                vector.addElement(relationshipLink.getRelationship());
            }
            ++n2;
        }
        Object[] objectArray = new Relationship[vector.size()];
        if (vector.size() != 0) {
            vector.copyInto(objectArray);
        }
        return objectArray;
    }

    public final OuterJoin createOuterJoin(Table table, Table table2) {
        OuterJoin outerJoin = new OuterJoin(table, table2);
        this.addOuterJoin(outerJoin);
        return outerJoin;
    }

    public boolean isOuterJoinCreationAllowed() {
        return this._outerJoinCreationAllowed;
    }

    public void setOuterJoinCreationAllowed(boolean bl) {
        this._outerJoinCreationAllowed = bl;
    }

    public void addOuterJoin(OuterJoin outerJoin) {
        if (this._outerJoins == null) {
            this._outerJoins = new Vector(2);
        }
        if (this._indexOf(outerJoin) == -1) {
            this._outerJoins.addElement(outerJoin);
            TableInfo tableInfo = this._getTableInfo(outerJoin.getDestination());
            TableInfo tableInfo2 = this._getTableInfo(outerJoin.getSource());
            if (tableInfo != null && tableInfo2 != null) {
                ViewBuilderLink[] viewBuilderLinkArray = this._getLinks(tableInfo);
                int n = viewBuilderLinkArray == null ? 0 : viewBuilderLinkArray.length;
                int n2 = 0;
                while (n2 < n) {
                    if (viewBuilderLinkArray[n2] instanceof RelationshipLink) {
                        RelationshipLink relationshipLink = (RelationshipLink)viewBuilderLinkArray[n2];
                        if (relationshipLink.getDestinationPort(0).getViewBuilderComponent() == tableInfo2.getViewBuilderComponent()) {
                            relationshipLink.setDestinationOuterJoin(true);
                        } else if (relationshipLink.getSourcePort(0).getViewBuilderComponent() == tableInfo2.getViewBuilderComponent()) {
                            relationshipLink.setSourceOuterJoin(true);
                        }
                    }
                    ++n2;
                }
            }
            this._sendOuterJoinEvent(outerJoin, 2008);
        }
    }

    public void removeOuterJoin(OuterJoin outerJoin) {
        int n;
        if (this._outerJoins != null && (n = this._indexOf(outerJoin)) != -1) {
            this._outerJoins.removeElementAt(n);
            TableInfo tableInfo = this._getTableInfo(outerJoin.getDestination());
            TableInfo tableInfo2 = this._getTableInfo(outerJoin.getSource());
            if (tableInfo != null) {
                ViewBuilderLink[] viewBuilderLinkArray = this._getLinks(tableInfo);
                int n2 = viewBuilderLinkArray == null ? 0 : viewBuilderLinkArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    if (viewBuilderLinkArray[n3] instanceof RelationshipLink) {
                        RelationshipLink relationshipLink = (RelationshipLink)viewBuilderLinkArray[n3];
                        if (relationshipLink.getDestinationPort(0).getViewBuilderComponent() == tableInfo2.getViewBuilderComponent()) {
                            relationshipLink.setDestinationOuterJoin(false);
                        } else if (relationshipLink.getSourcePort(0).getViewBuilderComponent() == tableInfo2.getViewBuilderComponent()) {
                            relationshipLink.setSourceOuterJoin(false);
                        }
                    }
                    ++n3;
                }
            }
            this._sendOuterJoinEvent(outerJoin, 2009);
        }
    }

    public OuterJoin[] getOuterJoins() {
        if (this._outerJoins == null || this._outerJoins.size() == 0) {
            return null;
        }
        Object[] objectArray = new OuterJoin[this._outerJoins.size()];
        this._outerJoins.copyInto(objectArray);
        return objectArray;
    }

    public ViewBuilderCustomizer getCustomizer() {
        return this._customizer;
    }

    public void setCustomizer(ViewBuilderCustomizer viewBuilderCustomizer) {
        this._customizer = viewBuilderCustomizer;
    }

    public void setLinkCreationAllowed(boolean bl) {
        this._linkCreationAllowed = bl;
    }

    public boolean isLinkCreationAllowed() {
        return this._linkCreationAllowed;
    }

    public void setLinkDeletionAllowed(boolean bl) {
        this._linkDeletionAllowed = bl;
    }

    public boolean isLinkDeletionAllowed() {
        return this._linkDeletionAllowed;
    }

    public void addTableListener(VBTableListener vBTableListener) {
        if (this._tableListeners == null) {
            this._tableListeners = new ListenerManager();
        }
        this._tableListeners.addListener((EventListener)vBTableListener);
    }

    public void removeTableListener(VBTableListener vBTableListener) {
        if (this._tableListeners != null) {
            this._tableListeners.removeListener((EventListener)vBTableListener);
        }
    }

    public void addRelationshipListener(VBRelationshipListener vBRelationshipListener) {
        if (this._relationshipListeners == null) {
            this._relationshipListeners = new ListenerManager();
        }
        this._relationshipListeners.addListener((EventListener)vBRelationshipListener);
    }

    public void removeRelationshipListener(VBRelationshipListener vBRelationshipListener) {
        if (this._relationshipListeners != null) {
            this._relationshipListeners.removeListener((EventListener)vBRelationshipListener);
        }
    }

    public void addOuterJoinListener(VBOuterJoinListener vBOuterJoinListener) {
        if (this._outerJoinListeners == null) {
            this._outerJoinListeners = new ListenerManager();
        }
        this._outerJoinListeners.addListener((EventListener)vBOuterJoinListener);
    }

    public void removeOuterJoinListener(VBOuterJoinListener vBOuterJoinListener) {
        if (this._outerJoinListeners != null) {
            this._outerJoinListeners.removeListener((EventListener)vBOuterJoinListener);
        }
    }

    public ViewBuilderCanvas getCanvas() {
        return this._canvas;
    }

    public TableViewBuilderComponent getComponent(Table table) {
        TableInfo tableInfo = this._getTableInfo(table);
        return tableInfo == null ? null : tableInfo.getViewBuilderComponent();
    }

    public void addViewBuilderComponent(ViewBuilderComponent viewBuilderComponent) {
        if (this._customComponents.indexOf(viewBuilderComponent) == -1) {
            this.getCanvas().addComponent(viewBuilderComponent);
            viewBuilderComponent.addPropertyChangeListener(this._listener);
            viewBuilderComponent.addVetoableChangeListener(this._listener);
            this._customComponents.addElement(viewBuilderComponent);
        }
    }

    public void removeViewBuilderComponent(ViewBuilderComponent viewBuilderComponent) {
        int n = this._customComponents.indexOf(viewBuilderComponent);
        if (n != -1) {
            viewBuilderComponent.removePropertyChangeListener(this._listener);
            viewBuilderComponent.removeVetoableChangeListener(this._listener);
            this._removeCustomLinks(viewBuilderComponent);
            viewBuilderComponent.close();
            this._customComponents.removeElementAt(n);
        }
    }

    public void addViewBuilderLink(ViewBuilderLink viewBuilderLink) {
        if (this._links.indexOf(viewBuilderLink) == -1) {
            this._clearLinks();
            this._links.addElement(viewBuilderLink);
            this.getCanvas().addViewBuilderLink(viewBuilderLink);
        }
    }

    public void removeViewBuilderLink(ViewBuilderLink viewBuilderLink) {
        int n = this._links.indexOf(viewBuilderLink);
        if (n != -1) {
            this._clearLinks();
            this._links.removeElementAt(n);
            this.getCanvas().removeViewBuilderLink(viewBuilderLink);
        }
    }

    public void setAllLinksSelected(boolean bl) {
        this.freezeRepaints();
        try {
            int n = this._links.size();
            int n2 = 0;
            while (n2 < n) {
                this.setLinkSelected((ViewBuilderLink)this._links.elementAt(n2), bl);
                ++n2;
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.unfreezeRepaints();
            throw throwable;
        }
        this.unfreezeRepaints();
    }

    public void setLinkSelected(ViewBuilderLink viewBuilderLink, boolean bl) {
        if (viewBuilderLink.isSelected() == bl) {
            return;
        }
        AccessibleContext accessibleContext = ((JComponent)((Object)this)).accessibleContext;
        String string = null;
        if (accessibleContext != null) {
            string = accessibleContext.getAccessibleName();
        }
        this.freezeRepaints();
        try {
            Object object;
            viewBuilderLink.setSelected(bl);
            if (viewBuilderLink instanceof RelationshipLink) {
                object = (RelationshipLink)viewBuilderLink;
                this._highlightJoin(((RelationshipLink)object).getRelationship(), bl);
                ((Component)((Object)this)).firePropertyChange(PROPERTY_SELECTED_RELATIONSHIPS, null, this.getSelectedRelationships());
            }
            if (accessibleContext != null) {
                object = accessibleContext.getAccessibleName();
                accessibleContext.firePropertyChange("AccessibleName", string, object);
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.unfreezeRepaints();
            throw throwable;
        }
        this.unfreezeRepaints();
    }

    public ViewBuilderLink[] getSelectedLinks() {
        Vector<ViewBuilderLink> vector = new Vector<ViewBuilderLink>();
        int n = this._links.size();
        int n2 = 0;
        while (n2 < n) {
            ViewBuilderLink viewBuilderLink = (ViewBuilderLink)this._links.elementAt(n2);
            if (viewBuilderLink.isSelected()) {
                vector.addElement(viewBuilderLink);
            }
            ++n2;
        }
        Object[] objectArray = new ViewBuilderLink[vector.size()];
        if (vector.size() != 0) {
            vector.copyInto(objectArray);
        }
        return objectArray;
    }

    public ViewBuilderLink[] getLinks(ViewBuilderComponent viewBuilderComponent) {
        Vector<ViewBuilderLink> vector = new Vector<ViewBuilderLink>();
        int n = this._links.size();
        int n2 = 0;
        while (n2 < n) {
            ViewBuilderLink viewBuilderLink = (ViewBuilderLink)this._links.elementAt(n2);
            ViewBuilderLinkPort viewBuilderLinkPort = viewBuilderLink.getSourcePort(0);
            ViewBuilderLinkPort viewBuilderLinkPort2 = viewBuilderLink.getDestinationPort(0);
            if (viewBuilderLinkPort.getViewBuilderComponent() == viewBuilderComponent || viewBuilderLinkPort2.getViewBuilderComponent() == viewBuilderComponent) {
                vector.addElement(viewBuilderLink);
            }
            ++n2;
        }
        Object[] objectArray = null;
        n = vector.size();
        if (n != 0) {
            objectArray = new ViewBuilderLink[n];
            vector.copyInto(objectArray);
        }
        return objectArray;
    }

    public void startLinkCreation(ViewBuilderLinkPort viewBuilderLinkPort, int n, int n2) {
        this._lastPort = null;
        this._startPort = viewBuilderLinkPort;
        this._anchorX = n;
        this._anchorY = n2;
        this._joinX = n;
        this._joinY = n2;
        this._repaintFeedback();
    }

    public void continueLinkCreation(int n, int n2) {
        ViewBuilderLinkPort viewBuilderLinkPort = this._getLinkPortAt(n, n2);
        if (viewBuilderLinkPort != this._lastPort) {
            if (this._lastPort != null && this._lastPort != this._startPort) {
                this._lastPort.setHighlighted(false);
            }
            if (viewBuilderLinkPort != null && viewBuilderLinkPort != this._startPort && viewBuilderLinkPort.getViewBuilderComponent() != this._startPort.getViewBuilderComponent()) {
                viewBuilderLinkPort.setHighlighted(true);
            }
            this._lastPort = viewBuilderLinkPort;
        }
        this._joinX = n;
        this._joinY = n2;
        this._repaintFeedback();
    }

    public void finishLinkCreation(int n, int n2) {
        this._anchorX = -1;
        this._anchorY = -1;
        if (this._lastPort != null) {
            this._lastPort.setHighlighted(false);
        }
        ViewBuilderLinkPort viewBuilderLinkPort = this._getLinkPortAt(n, n2);
        try {
            ViewBuilderLink viewBuilderLink;
            if (viewBuilderLinkPort != null && viewBuilderLinkPort != this._startPort && viewBuilderLinkPort.getViewBuilderComponent() != this._startPort.getViewBuilderComponent() && (viewBuilderLink = this.createLink(this._startPort, viewBuilderLinkPort)) != null) {
                this.addViewBuilderLink(viewBuilderLink);
            }
            Object var6_5 = null;
            this._startPort = null;
            this._lastPort = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this._startPort = null;
            this._lastPort = null;
            throw throwable;
        }
        ((Component)((Object)this)).repaint();
    }

    public void showMenu(ViewBuilderLink viewBuilderLink, int n, int n2) {
        if (!(viewBuilderLink instanceof RelationshipLink)) {
            return;
        }
        this._menuRelationship = ((RelationshipLink)viewBuilderLink).getRelationship();
        this._createMenu();
        DBUILookAndFeel.getLookAndFeel().popupMenu((Component)((Object)this), this._menu, n, n2);
    }

    public void displayPopupForColumn(Column column, int n, int n2) {
        JMenuItem jMenuItem;
        Object object;
        Object object2;
        String string;
        Object object3;
        MessageFormat messageFormat;
        String string2;
        boolean bl = this.isLinkCreationAllowed();
        boolean bl2 = this.isLinkDeletionAllowed();
        if (!bl && !bl2) {
            return;
        }
        Locale locale = ((Component)((Object)this)).getLocale();
        ResourceBundle resourceBundle = ResourceBundle.getBundle("oracle.bali.dbUI.resource.DBUIBundle", locale);
        Table[] tableArray = this.getTables();
        this._menuColumn = column;
        JPopupMenu jPopupMenu = new JPopupMenu();
        if (bl) {
            string2 = resourceBundle.getString(_KEY_LINKTO);
            messageFormat = new MessageFormat(string2);
            object3 = new Object[]{column.getDisplayName(locale)};
            string = messageFormat.format(object3);
            object2 = new JMenu(string);
            jPopupMenu.add((JMenuItem)object2);
            if (tableArray.length > 1) {
                int n3 = 0;
                while (n3 < tableArray.length) {
                    Table table = tableArray[n3];
                    if (!this._tablesEqual(table, column.getTable())) {
                        object = new JMenu(table.getDisplayName(locale));
                        int n4 = 0;
                        while (n4 < table.getColumnCount()) {
                            Column column2 = table.getColumn(n4);
                            if (column2 != column) {
                                jMenuItem = new JMenuItem(column2.getDisplayName(locale));
                                jMenuItem.setActionCommand(COMMAND_LINK + table.getSchema().getName() + "." + table.getName() + "." + column2.getName());
                                jMenuItem.addActionListener(this._listener);
                                ((JMenu)object).add(jMenuItem);
                            }
                            ++n4;
                        }
                        ((JMenu)object2).add((JMenuItem)object);
                    }
                    ++n3;
                }
            }
            ((JMenuItem)object2).setEnabled(((JMenu)object2).getMenuComponentCount() != 0);
        }
        object3 = null;
        if (bl2) {
            string2 = resourceBundle.getString(_KEY_DELETELINK);
            messageFormat = new MessageFormat(string2);
            object2 = new Object[]{column.getDisplayName(locale)};
            string = messageFormat.format(object2);
            object3 = new JMenu(string);
            Relationship[] relationshipArray = this.getRelationships();
            int n5 = 0;
            while (n5 < relationshipArray.length) {
                Column column3 = null;
                object = relationshipArray[n5];
                int n6 = 0;
                while (n6 < ((Relationship)object).getColumnCount()) {
                    Column column4 = ((Relationship)object).getColumn(n6);
                    Column column5 = ((Relationship)object).getReferencedColumn(n6);
                    if (this._columnsEqual(column, column4)) {
                        column3 = column5;
                    }
                    if (this._columnsEqual(column, column5)) {
                        column3 = column4;
                    }
                    if (column3 != null && this._isJoinRemovable((Relationship)object)) {
                        jMenuItem = new JMenuItem(column3.getTable().getDisplayName(locale) + "." + column3.getDisplayName(locale));
                        jMenuItem.setActionCommand(COMMAND_DELETE_LINK + column3.getTable().getSchema().getName() + "." + column3.getTable().getName() + "." + column3.getName());
                        jMenuItem.addActionListener(this._listener);
                        ((JMenu)object3).add(jMenuItem);
                    }
                    ++n6;
                }
                ++n5;
            }
        }
        if (bl2) {
            jPopupMenu.add((JMenuItem)object3);
            ((JMenuItem)object3).setEnabled(((JMenu)object3).getMenuComponentCount() > 0);
        }
        DBUILookAndFeel.getLookAndFeel().popupMenu((Component)((Object)this), jPopupMenu, n, n2);
    }

    private boolean _columnsEqual(Column column, Column column2) {
        if (column == column2) {
            return true;
        }
        return column.getName().equals(column2.getName()) && column.getTable().getName().equals(column2.getTable().getName()) && column.getTable().getSchema().getName().equals(column2.getTable().getSchema().getName()) && column.getTable().getSchema().getDatabase().getName().equals(column2.getTable().getSchema().getDatabase().getName());
    }

    private boolean _tablesEqual(Table table, Table table2) {
        return table.equals(table2);
    }

    public Dimension getDocumentSize(PaintContext paintContext, Dictionary dictionary) {
        return this.getCanvas().getDocumentSize(paintContext, dictionary);
    }

    public void printPage(PaintContext paintContext, Dictionary dictionary, Graphics graphics) {
        this.getCanvas().printPage(paintContext, dictionary, graphics);
    }

    public Rectangle getPageBounds(PaintContext paintContext, Dictionary dictionary, int n, int n2, int n3, int n4) {
        return this.getCanvas().getPageBounds(paintContext, dictionary, n, n2, n3, n4);
    }

    public void removeAll() {
        int n;
        Object[] objectArray;
        int n2 = this._tableInfo.size();
        if (n2 != 0) {
            objectArray = new TableInfo[n2];
            this._tableInfo.copyInto(objectArray);
            n = 0;
            while (n < n2) {
                this.removeTable(((TableInfo)objectArray[n]).getTable());
                ++n;
            }
        }
        if ((n2 = this._customComponents.size()) != 0) {
            objectArray = new ViewBuilderComponent[n2];
            this._customComponents.copyInto(objectArray);
            n = 0;
            while (n < n2) {
                this.removeViewBuilderComponent((ViewBuilderComponent)objectArray[n]);
                ++n;
            }
        }
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void doLayout() {
        Rectangle rectangle;
        ViewBuilderComponent viewBuilderComponent;
        int n = this._tableInfo.size();
        int n2 = 0;
        while (n2 < n) {
            TableInfo tableInfo = (TableInfo)this._tableInfo.elementAt(n2);
            viewBuilderComponent = tableInfo.getViewBuilderComponent();
            rectangle = viewBuilderComponent.getComponentBounds();
            if (rectangle.width <= 0 || rectangle.height <= 0) {
                this._setComponentBounds(viewBuilderComponent, -1, -1);
            }
            ++n2;
        }
        n = this._customComponents.size();
        int n3 = 0;
        while (n3 < n) {
            viewBuilderComponent = (ViewBuilderComponent)this._customComponents.elementAt(n3);
            rectangle = viewBuilderComponent.getComponentBounds();
            if (rectangle.width <= 0 || rectangle.height <= 0) {
                this._setComponentBounds(viewBuilderComponent, -1, -1);
            }
            ++n3;
        }
        super.doLayout();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this._scrollBox.setEnabled(bl);
        this.getCanvas().setEnabled(bl);
        if (bl) {
            ((JComponent)((Object)this)).setBackground(Color.white);
        } else {
            ((JComponent)((Object)this)).setBackground(this.getUIDefaults().getColor("lightIntensity"));
        }
    }

    public void paintOverChildren(Graphics graphics) {
        super.paintOverChildren(graphics);
        this._paintFeedback(graphics);
    }

    public void scrollTableToView(Table table) {
        ViewBuilderCanvas viewBuilderCanvas;
        Rectangle rectangle = this.getTableBounds(table);
        if (rectangle != null && (viewBuilderCanvas = this.getCanvas()) instanceof JComponent) {
            ((JComponent)((Object)viewBuilderCanvas)).scrollRectToVisible(rectangle);
        }
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        if (!((Component)((Object)this)).isEnabled()) {
            return;
        }
        if (focusEvent.getID() == 1004) {
            if (this.getSelectedRelationships().length == 0) {
                Table[] tableArray = this.getSelectedTables();
                TableInfo tableInfo = null;
                if (tableArray.length != 0) {
                    tableInfo = this._getTableInfo(tableArray[0]);
                } else if (this._tableInfo.size() != 0) {
                    tableInfo = (TableInfo)this._tableInfo.firstElement();
                    this.setTableSelected(tableInfo.getTable(), true);
                }
                if (tableInfo != null) {
                    tableInfo.getTableComponent().getSpreadTable().requestFocus();
                }
            }
        } else {
            this.setAllRelationshipsSelected(false);
        }
    }

    protected void processEventImpl(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ViewBuilderEvent) {
            switch (aWTEvent.getID()) {
                case 2000: 
                case 2001: 
                case 2002: 
                case 2003: {
                    this.processTableEvent((ViewBuilderEvent)aWTEvent);
                    break;
                }
                case 2004: 
                case 2005: 
                case 2006: 
                case 2007: {
                    this.processRelationshipEvent((ViewBuilderEvent)aWTEvent);
                    break;
                }
                case 2008: 
                case 2009: {
                    this.processOuterJoinEvent((ViewBuilderEvent)aWTEvent);
                    break;
                }
            }
        } else {
            super.processEventImpl(aWTEvent);
        }
    }

    protected void processTableEvent(ViewBuilderEvent viewBuilderEvent) {
        if (this._tableListeners == null) {
            return;
        }
        Enumeration enumeration = this._tableListeners.getListeners();
        if (enumeration == null) {
            return;
        }
        switch (viewBuilderEvent.getID()) {
            case 2000: {
                while (enumeration.hasMoreElements()) {
                    ((VBTableListener)enumeration.nextElement()).tableAdding(viewBuilderEvent);
                }
                break;
            }
            case 2001: {
                while (enumeration.hasMoreElements()) {
                    ((VBTableListener)enumeration.nextElement()).tableAdded(viewBuilderEvent);
                }
                break;
            }
            case 2002: {
                while (enumeration.hasMoreElements()) {
                    ((VBTableListener)enumeration.nextElement()).tableRemoving(viewBuilderEvent);
                }
                break;
            }
            case 2003: {
                while (enumeration.hasMoreElements()) {
                    ((VBTableListener)enumeration.nextElement()).tableRemoved(viewBuilderEvent);
                }
                break;
            }
        }
    }

    protected void processRelationshipEvent(ViewBuilderEvent viewBuilderEvent) {
        if (this._relationshipListeners == null) {
            return;
        }
        Enumeration enumeration = this._relationshipListeners.getListeners();
        if (enumeration == null) {
            return;
        }
        switch (viewBuilderEvent.getID()) {
            case 2004: {
                while (enumeration.hasMoreElements()) {
                    ((VBRelationshipListener)enumeration.nextElement()).relationshipAdding(viewBuilderEvent);
                }
                break;
            }
            case 2005: {
                while (enumeration.hasMoreElements()) {
                    ((VBRelationshipListener)enumeration.nextElement()).relationshipAdded(viewBuilderEvent);
                }
                break;
            }
            case 2006: {
                while (enumeration.hasMoreElements()) {
                    ((VBRelationshipListener)enumeration.nextElement()).relationshipRemoving(viewBuilderEvent);
                }
                break;
            }
            case 2007: {
                while (enumeration.hasMoreElements()) {
                    ((VBRelationshipListener)enumeration.nextElement()).relationshipRemoved(viewBuilderEvent);
                }
                break;
            }
        }
    }

    protected void processOuterJoinEvent(ViewBuilderEvent viewBuilderEvent) {
        if (this._outerJoinListeners == null) {
            return;
        }
        Enumeration enumeration = this._outerJoinListeners.getListeners();
        if (enumeration == null) {
            return;
        }
        switch (viewBuilderEvent.getID()) {
            case 2008: {
                while (enumeration.hasMoreElements()) {
                    ((VBOuterJoinListener)enumeration.nextElement()).outerJoinAdded(viewBuilderEvent);
                }
                break;
            }
            case 2009: {
                while (enumeration.hasMoreElements()) {
                    ((VBOuterJoinListener)enumeration.nextElement()).outerJoinRemoved(viewBuilderEvent);
                }
                break;
            }
        }
    }

    protected JMenuBar getDefaultMenuBar(Table table, Locale locale) {
        Serializable serializable;
        ResourceBundle resourceBundle = ResourceBundle.getBundle("oracle.bali.dbUI.resource.DBUIBundle", locale);
        TableAction tableAction = new TableAction(table);
        String string = resourceBundle.getString(_OPTIONS_KEY);
        JMenu jMenu = new JMenu(StringUtils.stripMnemonic((String)string));
        jMenu.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        JMenuItem jMenuItem = new JMenuItem(resourceBundle.getString(_SHOW_RELATED_TABLES_KEY));
        jMenuItem.setActionCommand(TABLES_COMMAND);
        jMenuItem.addActionListener(tableAction);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(resourceBundle.getString(_HIDE_RELATED_TABLES_KEY));
        jMenuItem.setActionCommand(HIDE_TABLES_COMMAND);
        jMenuItem.addActionListener(tableAction);
        jMenu.add(jMenuItem);
        if (this.isOuterJoinCreationAllowed()) {
            jMenu.getPopupMenu().addPopupMenuListener(tableAction);
            string = resourceBundle.getString(_CREATE_OUTER_JOIN_KEY);
            serializable = new MessageFormat(string);
            Object[] objectArray = new Object[]{table.getDisplayName(locale)};
            String string2 = ((Format)serializable).format(objectArray);
            JMenu jMenu2 = new JMenu(string2);
            jMenu2.setActionCommand(COMMAND_CREATE_OUTER_JOIN);
            jMenu.add(jMenu2);
            string = resourceBundle.getString(_DELETE_OUTER_JOIN_KEY);
            serializable = new MessageFormat(string);
            Object[] objectArray2 = new Object[]{table.getDisplayName(locale)};
            string2 = ((Format)serializable).format(objectArray2);
            JMenu jMenu3 = new JMenu(string2);
            jMenu3.setActionCommand(COMMAND_DELETE_OUTER_JOIN);
            jMenu.add(jMenu3);
        }
        serializable = new JMenuBar();
        ((JMenuBar)serializable).add(jMenu);
        return serializable;
    }

    protected ViewBuilderCanvas createViewBuilderCanvas() {
        return new JInternalFrameViewBuilderCanvas();
    }

    protected TableViewBuilderComponent createViewBuilderComponent() {
        return new JInternalFrameTableComponent();
    }

    protected ViewBuilderLink createLink(ViewBuilderLinkPort viewBuilderLinkPort, ViewBuilderLinkPort viewBuilderLinkPort2) {
        if (!(viewBuilderLinkPort instanceof ColumnLinkPort) || !(viewBuilderLinkPort2 instanceof ColumnLinkPort)) {
            return this.createCustomLink(viewBuilderLinkPort, viewBuilderLinkPort2);
        }
        Column column = ((ColumnLinkPort)viewBuilderLinkPort).getColumn();
        Column column2 = ((ColumnLinkPort)viewBuilderLinkPort2).getColumn();
        this._createRelationship(column, column2);
        return null;
    }

    protected ViewBuilderLink createCustomLink(ViewBuilderLinkPort viewBuilderLinkPort, ViewBuilderLinkPort viewBuilderLinkPort2) {
        return new ViewBuilderLink(viewBuilderLinkPort, viewBuilderLinkPort2);
    }

    public AccessibleContext getAccessibleContext() {
        if (((JComponent)((Object)this)).accessibleContext == null) {
            ((JComponent)((Object)this)).accessibleContext = new AccessibleViewBuilder();
        }
        return ((JComponent)((Object)this)).accessibleContext;
    }

    private void _selectionChanged(Table table) {
        boolean bl = this._updateIncludedJoins(table);
        ((Component)((Object)this)).firePropertyChange(PROPERTY_SELECTED_COLUMNS, null, this.getSelectedColumns());
        if (bl) {
            ((Component)((Object)this)).firePropertyChange(PROPERTY_INCLUDED_RELATIONSHIPS, null, this.getIncludedRelationships());
        }
    }

    private void _deleteSelectedComponents() {
        Table[] tableArray = this.getSelectedTables();
        int n = 0;
        while (n < tableArray.length) {
            Table table = tableArray[n];
            if (this._sendTableValidateEvent(table, 2002)) {
                this.removeTable(table);
                this._sendTableEvent(table, 2003);
            }
            ++n;
        }
        int n2 = this._customComponents.size();
        Object[] objectArray = new ViewBuilderComponent[n2];
        this._customComponents.copyInto(objectArray);
        int n3 = 0;
        while (n3 < n2) {
            if (objectArray[n3].isComponentSelected()) {
                this.removeViewBuilderComponent((ViewBuilderComponent)objectArray[n3]);
            }
            ++n3;
        }
    }

    private TableInfo _getTableInfo(ViewBuilderComponent viewBuilderComponent) {
        int n = this._tableInfo.size();
        int n2 = 0;
        while (n2 < n) {
            TableInfo tableInfo = (TableInfo)this._tableInfo.elementAt(n2);
            if (tableInfo.getViewBuilderComponent() == viewBuilderComponent) {
                return tableInfo;
            }
            ++n2;
        }
        return null;
    }

    private TableInfo _getTableInfo(TableComponent tableComponent) {
        int n = this._tableInfo.size();
        int n2 = 0;
        while (n2 < n) {
            TableInfo tableInfo = (TableInfo)this._tableInfo.elementAt(n2);
            if (tableInfo.getTableComponent() == tableComponent) {
                return tableInfo;
            }
            ++n2;
        }
        return null;
    }

    private TableInfo _getTableInfo(Table table) {
        int n = this._tableInfo.size();
        String string = table.getName();
        int n2 = 0;
        while (n2 < n) {
            TableInfo tableInfo = (TableInfo)this._tableInfo.elementAt(n2);
            if (tableInfo.getTable() == table) {
                return tableInfo;
            }
            if (this._tablesEqual(tableInfo.getTable(), table)) {
                return tableInfo;
            }
            ++n2;
        }
        return null;
    }

    private void _closeComponent(ViewBuilderComponent viewBuilderComponent) {
        TableInfo tableInfo = this._getTableInfo(viewBuilderComponent);
        if (tableInfo != null) {
            Table table = tableInfo.getTable();
            this.removeTable(table);
            this._sendTableEvent(table, 2003);
        } else {
            this.removeViewBuilderComponent(viewBuilderComponent);
        }
        ((Container)((Object)this)).validate();
    }

    private void _activateJoins(ViewBuilderComponent viewBuilderComponent, Boolean bl) {
        TableInfo tableInfo = this._getTableInfo(viewBuilderComponent);
        ViewBuilderLink[] viewBuilderLinkArray = tableInfo == null ? this.getLinks(viewBuilderComponent) : this._getLinks(tableInfo);
        this.freezeRepaints();
        boolean bl2 = false;
        try {
            if (Boolean.TRUE.equals(bl)) {
                bl2 = this.getSelectedRelationships().length != 0;
                this.setAllLinksSelected(false);
            }
            int n = viewBuilderLinkArray == null ? 0 : viewBuilderLinkArray.length;
            int n2 = 0;
            while (n2 < n) {
                ViewBuilderLink viewBuilderLink = viewBuilderLinkArray[n2];
                ViewBuilderComponent viewBuilderComponent2 = viewBuilderLink.getSourcePort(0).getViewBuilderComponent();
                ViewBuilderComponent viewBuilderComponent3 = viewBuilderLink.getDestinationPort(0).getViewBuilderComponent();
                boolean bl3 = viewBuilderComponent2.isComponentSelected() || viewBuilderComponent3.isComponentSelected();
                viewBuilderLink.setActive(bl3);
                ++n2;
            }
            Object var13_12 = null;
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            this.unfreezeRepaints();
            throw throwable;
        }
        this.unfreezeRepaints();
        if (bl2) {
            ((Component)((Object)this)).firePropertyChange(PROPERTY_SELECTED_RELATIONSHIPS, null, this.getSelectedRelationships());
        }
        ((Component)((Object)this)).firePropertyChange(PROPERTY_SELECTED_TABLES, null, this.getSelectedTables());
    }

    private boolean _tryClose(ViewBuilderComponent viewBuilderComponent) {
        TableInfo tableInfo = this._getTableInfo(viewBuilderComponent);
        if (tableInfo == null) {
            return true;
        }
        return this._sendTableValidateEvent(tableInfo.getTable(), 2002);
    }

    private void _createUI(Table table, int n, int n2) {
        this.freezeRepaints();
        try {
            Object object;
            TableComponent tableComponent = new TableComponent(table);
            ((Container)((Object)tableComponent)).addPropertyChangeListener(this._listener);
            if (table instanceof DynamicTable) {
                object = (DynamicTable)table;
                ((DynamicTable)object).addPropertyChangeListener(this._listener);
                ((DynamicTable)object).addTableListener(this._listener);
            }
            object = this.createViewBuilderComponent();
            object.addPropertyChangeListener(this._listener);
            object.addVetoableChangeListener(this._listener);
            object.setTableComponent(tableComponent);
            tableComponent.setCellInputHandler((CellInputHandler)new JoinMaker(this, (TableViewBuilderComponent)object));
            TableInfo tableInfo = new TableInfo(table, tableComponent, (TableViewBuilderComponent)object);
            this._tableInfo.addElement(tableInfo);
            this._customizeTable(table, tableComponent, (TableViewBuilderComponent)object, _ALL);
            ViewBuilderCanvas viewBuilderCanvas = this.getCanvas();
            viewBuilderCanvas.addComponent((ViewBuilderComponent)object);
            this._setComponentBounds((ViewBuilderComponent)object, n, n2);
            object.setVisible(true);
            object.setComponentSelected(true);
            object.setEnabled(((Component)((Object)this)).isEnabled());
            ((Container)((Object)tableComponent)).invalidate();
            ((Container)((Object)tableComponent)).validate();
            tableComponent.getSpreadTable().requestFocus();
            viewBuilderCanvas.setSelectedComponent((ViewBuilderComponent)object);
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.unfreezeRepaints();
            throw throwable;
        }
        this.unfreezeRepaints();
    }

    private void _validateScrollBox() {
        this.getCanvas().getComponent().invalidate();
        this._scrollBox.validate();
    }

    private void _checkForJoins(Table table, boolean bl) {
        Table table2;
        int n;
        Relationship relationship;
        int n2;
        int n3;
        String string = table.getName();
        int n4 = this._tableInfo.size();
        int n5 = 0;
        while (n5 < n4) {
            TableInfo tableInfo = (TableInfo)this._tableInfo.elementAt(n5);
            Table table3 = tableInfo.getTable();
            if (!table3.getName().equals(string) && (n3 = table3.getForeignKeyCount()) != 0) {
                n2 = 0;
                while (n2 < n3) {
                    relationship = table3.getForeignKey(n2);
                    if (this._getLink(relationship) == null) {
                        n = relationship.getColumnCount();
                        table2 = relationship.getReferencedColumn(0).getTable();
                        if (table2.getName().equals(string) && (!bl || this._sendJoinValidateEvent(relationship, 2004))) {
                            this.addRelationship(relationship);
                            if (bl) {
                                this._sendJoinEvent(relationship, 2005);
                            }
                        }
                    }
                    ++n2;
                }
            }
            ++n5;
        }
        n3 = table.getForeignKeyCount();
        if (n3 != 0) {
            n2 = 0;
            while (n2 < n3) {
                relationship = table.getForeignKey(n2);
                if (this._getLink(relationship) == null) {
                    n = relationship.getColumnCount();
                    table2 = relationship.getReferencedColumn(0).getTable();
                    if (this._getTableInfo(table2) != null && (!bl || this._sendJoinValidateEvent(relationship, 2004))) {
                        this.addRelationship(relationship);
                        if (bl) {
                            this._sendJoinEvent(relationship, 2005);
                        }
                    }
                }
                ++n2;
            }
        }
    }

    private void _setMenuJoinType(int n) {
        if (this._menuRelationship instanceof DynamicRelationship) {
            ((DynamicRelationship)this._menuRelationship).setRelationshipType(n);
            ((Component)((Object)this)).repaint();
        }
    }

    private void _customizeTable(Table table, String string) {
        TableInfo tableInfo = this._getTableInfo(table);
        this._customizeTable(table, tableInfo.getTableComponent(), tableInfo.getViewBuilderComponent(), string);
    }

    private void _updateRelationship(Relationship relationship) {
        ((Component)((Object)this)).repaint();
    }

    private void _updateRelationships(Table table, Relationship relationship, boolean bl) {
        TableInfo tableInfo = this._getTableInfo(table);
        if (tableInfo == null) {
            return;
        }
        if (bl) {
            this.addRelationship(relationship);
        } else {
            this.removeRelationship(relationship);
        }
    }

    private void _updateRelationships(Table table, Column column) {
        TableInfo tableInfo = this._getTableInfo(table);
        if (tableInfo == null) {
            return;
        }
        ViewBuilderLink[] viewBuilderLinkArray = this._getLinks(tableInfo);
        int n = viewBuilderLinkArray == null ? 0 : viewBuilderLinkArray.length;
        int n2 = 0;
        while (n2 < n) {
            boolean bl = false;
            ViewBuilderLink viewBuilderLink = viewBuilderLinkArray[n2];
            int n3 = viewBuilderLink.getPortCount();
            int n4 = 0;
            while (n4 < n) {
                ColumnLinkPort columnLinkPort;
                ViewBuilderLinkPort viewBuilderLinkPort = viewBuilderLink.getSourcePort(n4);
                ViewBuilderLinkPort viewBuilderLinkPort2 = viewBuilderLink.getDestinationPort(n4);
                if (viewBuilderLinkPort instanceof ColumnLinkPort && (columnLinkPort = (ColumnLinkPort)viewBuilderLinkPort).getColumn() == column) {
                    bl = true;
                    break;
                }
                if (viewBuilderLinkPort2 instanceof ColumnLinkPort && (columnLinkPort = (ColumnLinkPort)viewBuilderLinkPort2).getColumn() == column) {
                    bl = true;
                    break;
                }
                ++n4;
            }
            if (bl) {
                if (viewBuilderLink instanceof RelationshipLink) {
                    RelationshipLink relationshipLink = (RelationshipLink)viewBuilderLink;
                    this.removeRelationship(relationshipLink.getRelationship());
                } else {
                    this.removeViewBuilderLink(viewBuilderLink);
                }
            }
            ++n2;
        }
    }

    private void _addRelatedTables(Table table, boolean bl) {
        this.freezeRepaints();
        try {
            this._internalAddTable(table, bl);
            this._tryAddForeignKeys(table, bl);
            this._tryAddExportedKeys(table, bl);
            ((Container)((Object)this)).validate();
            ((Component)((Object)this)).repaint();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.unfreezeRepaints();
            throw throwable;
        }
        this.unfreezeRepaints();
    }

    private void _hideRelatedTables(Table table) {
        this.freezeRepaints();
        try {
            Table table2;
            Relationship relationship;
            int n = table.getForeignKeyCount();
            int n2 = 0;
            while (n2 < n) {
                relationship = table.getForeignKey(n2);
                table2 = relationship.getReferencedColumn(0).getTable();
                if (!this._tablesEqual(table2, table)) {
                    this.removeTable(table2);
                }
                ++n2;
            }
            n = table.getExportedKeyCount();
            int n3 = 0;
            while (n3 < n) {
                relationship = table.getExportedKey(n3);
                table2 = relationship.getColumn(0).getTable();
                if (!this._tablesEqual(table2, table)) {
                    this.removeTable(table2);
                }
                ++n3;
            }
            ((Container)((Object)this)).validate();
            ((Component)((Object)this)).repaint();
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.unfreezeRepaints();
            throw throwable;
        }
        this.unfreezeRepaints();
    }

    private void _tryAddForeignKeys(Table table, boolean bl) {
        int n = table.getForeignKeyCount();
        if (n == 0) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            Relationship relationship = table.getForeignKey(n2);
            Table table2 = relationship.getReferencedColumn(0).getTable();
            if (this._internalAddTable(table2, bl) && (!bl || this._sendJoinValidateEvent(relationship, 2004))) {
                this.addRelationship(relationship);
                if (bl) {
                    this._sendJoinEvent(relationship, 2005);
                }
            }
            ++n2;
        }
    }

    private void _tryAddExportedKeys(Table table, boolean bl) {
        int n = table.getExportedKeyCount();
        if (n == 0) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            Relationship relationship = table.getExportedKey(n2);
            Table table2 = relationship.getColumn(0).getTable();
            if (this._internalAddTable(table2, bl) && (!bl || this._sendJoinValidateEvent(relationship, 2004))) {
                this.addRelationship(relationship);
                if (bl) {
                    this._sendJoinEvent(relationship, 2005);
                }
            }
            ++n2;
        }
    }

    private boolean _internalAddTable(Table table, boolean bl) {
        if (this._getTableInfo(table) != null) {
            return true;
        }
        if (bl && !this._sendTableValidateEvent(table, 2000)) {
            return false;
        }
        this._createUI(table, -1, -1);
        this._checkForJoins(table, true);
        if (bl) {
            this._sendTableEvent(table, 2001);
        }
        return true;
    }

    private RelationshipLink _getLink(Relationship relationship) {
        int n = this._links.size();
        int n2 = 0;
        while (n2 < n) {
            RelationshipLink relationshipLink;
            ViewBuilderLink viewBuilderLink = (ViewBuilderLink)this._links.elementAt(n2);
            if (viewBuilderLink instanceof RelationshipLink && this._keysEqual((relationshipLink = (RelationshipLink)viewBuilderLink).getRelationship(), relationship)) {
                return relationshipLink;
            }
            ++n2;
        }
        return null;
    }

    private boolean _keysEqual(Relationship relationship, Relationship relationship2) {
        int n;
        int n2 = relationship.getColumnCount();
        if (n2 != (n = relationship2.getColumnCount())) {
            return false;
        }
        int n3 = 0;
        while (n3 < n2) {
            Column column;
            Column column2 = relationship.getColumn(n3);
            if (!this._columnsEqual(column2, column = relationship2.getColumn(n3))) {
                return false;
            }
            column2 = relationship.getReferencedColumn(n3);
            if (!this._columnsEqual(column2, column = relationship2.getReferencedColumn(n3))) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    private void _includeLinks(ViewBuilderLink[] viewBuilderLinkArray) {
        int n = 0;
        while (n < viewBuilderLinkArray.length) {
            ViewBuilderLink viewBuilderLink = viewBuilderLinkArray[n];
            if (viewBuilderLink instanceof RelationshipLink) {
                RelationshipLink relationshipLink = (RelationshipLink)viewBuilderLink;
                boolean bl = !relationshipLink.isIncluded();
                this.setRelationshipIncluded(relationshipLink.getRelationship(), bl);
            }
            ++n;
        }
    }

    private void _deleteLinks(ViewBuilderLink[] viewBuilderLinkArray) {
        int n = 0;
        while (n < viewBuilderLinkArray.length) {
            ViewBuilderLink viewBuilderLink = viewBuilderLinkArray[n];
            if (!(viewBuilderLink instanceof RelationshipLink)) {
                this.removeViewBuilderLink(viewBuilderLink);
            } else {
                RelationshipLink relationshipLink = (RelationshipLink)viewBuilderLink;
                Relationship relationship = relationshipLink.getRelationship();
                this._deleteRelationship(relationship);
            }
            ++n;
        }
    }

    private void _deleteRelationship(Relationship relationship) {
        if (this._isJoinRemovable(relationship) && this._sendJoinValidateEvent(relationship, 2006)) {
            this.removeRelationship(relationship);
            this._sendJoinEvent(relationship, 2007);
            Table table = this._getTableFromForeignKey(relationship);
            if (table != null && table instanceof DynamicTable) {
                ((DynamicTable)table).removeForeignKey(relationship);
            }
        }
    }

    private boolean _isJoinRemovable(Relationship relationship) {
        Table table = this._getTableFromForeignKey(relationship);
        return table == null ? true : table instanceof DynamicTable;
    }

    private Table _getTableFromForeignKey(Relationship relationship) {
        int n = this._tableInfo.size();
        int n2 = 0;
        while (n2 < n) {
            TableInfo tableInfo = (TableInfo)this._tableInfo.elementAt(n2);
            Table table = tableInfo.getTable();
            int n3 = table.getForeignKeyCount();
            if (n3 != 0) {
                int n4 = 0;
                while (n4 < n3) {
                    if (this._keysEqual(relationship, table.getForeignKey(n4))) {
                        return table;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return null;
    }

    private ViewBuilderLinkPort _getLinkPortAt(int n, int n2) {
        ViewBuilderCanvas viewBuilderCanvas = this.getCanvas();
        Point point = SwingUtilities.convertPoint((Component)((Object)this), n, n2, viewBuilderCanvas.getComponent());
        ViewBuilderComponent viewBuilderComponent = viewBuilderCanvas.getViewBuilderComponentAt(point.x, point.y);
        if (viewBuilderComponent == null) {
            return null;
        }
        Rectangle rectangle = viewBuilderComponent.getComponentBounds();
        return viewBuilderComponent.getLinkPortAt(point.x - rectangle.x, point.y - rectangle.y);
    }

    private void _repaintFeedback() {
        if (this._anchorX == -1 || this._anchorY == -1) {
            return;
        }
        this.paintImmediately(0, 0, ((JComponent)((Object)this)).getWidth(), ((JComponent)((Object)this)).getHeight());
    }

    private void _paintFeedback(Graphics graphics) {
        if (this._anchorX == -1 || this._anchorY == -1) {
            return;
        }
        graphics.setColor(Color.black);
        graphics.drawLine(this._anchorX, this._anchorY, this._joinX, this._joinY);
    }

    private void _highlightJoin(Relationship relationship, boolean bl) {
        int n = relationship.getColumnCount();
        int n2 = 0;
        while (n2 < n) {
            Column column = relationship.getColumn(n2);
            TableInfo tableInfo = this._getTableInfo(column.getTable());
            TableComponent tableComponent = tableInfo.getTableComponent();
            tableComponent.setColumnHighlighted(column, bl);
            column = relationship.getReferencedColumn(n2);
            tableInfo = this._getTableInfo(column.getTable());
            tableComponent = tableInfo.getTableComponent();
            tableComponent.setColumnHighlighted(column, bl);
            ++n2;
        }
    }

    private void _removeLinks(TableInfo tableInfo) {
        ViewBuilderLink[] viewBuilderLinkArray = this._getLinks(tableInfo);
        if (viewBuilderLinkArray == null) {
            return;
        }
        this.freezeRepaints();
        try {
            int n = 0;
            while (n < viewBuilderLinkArray.length) {
                ViewBuilderLink viewBuilderLink = viewBuilderLinkArray[n];
                if (viewBuilderLink instanceof RelationshipLink) {
                    RelationshipLink relationshipLink = (RelationshipLink)viewBuilderLink;
                    Relationship relationship = relationshipLink.getRelationship();
                    this.removeRelationship(relationship);
                    this._sendJoinEvent(relationship, 2007);
                } else {
                    this.removeViewBuilderLink(viewBuilderLink);
                }
                ++n;
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.unfreezeRepaints();
            throw throwable;
        }
        this.unfreezeRepaints();
    }

    private void _clearLinks() {
        int n = this._tableInfo.size();
        int n2 = 0;
        while (n2 < n) {
            TableInfo tableInfo = (TableInfo)this._tableInfo.elementAt(n2);
            tableInfo.setLinks(null);
            ++n2;
        }
    }

    private ViewBuilderLink[] _getLinks(TableInfo tableInfo) {
        ViewBuilderLink[] viewBuilderLinkArray = tableInfo.getLinks();
        if (viewBuilderLinkArray == null) {
            viewBuilderLinkArray = this.getLinks(tableInfo.getViewBuilderComponent());
            tableInfo.setLinks(viewBuilderLinkArray);
        }
        return viewBuilderLinkArray;
    }

    private void _setComponentBounds(ViewBuilderComponent viewBuilderComponent, int n, int n2) {
        if (!((Component)((Object)this)).isDisplayable()) {
            return;
        }
        viewBuilderComponent.pack();
        Container container = (Container)this.getCanvas().getComponent();
        Rectangle rectangle = viewBuilderComponent.getComponentBounds();
        if (n >= 0 && n2 >= 0) {
            rectangle.setLocation(SwingUtilities.convertPoint((Component)((Object)this), n, n2, container));
        } else {
            boolean bl = false;
            int n3 = 0;
            int n4 = container.getWidth();
            Component[] componentArray = container.getComponents();
            rectangle.x = 10;
            rectangle.y = 10;
            block0: while (!bl) {
                bl = true;
                int n5 = 0;
                while (n5 < componentArray.length) {
                    Rectangle rectangle2 = componentArray[n5].getBounds();
                    if (viewBuilderComponent != componentArray[n5] && rectangle.intersects(rectangle2)) {
                        bl = false;
                        n3 = n3 == 0 ? rectangle2.y + rectangle2.height : Math.min(n3, rectangle2.y + rectangle2.height);
                        rectangle.x += rectangle2.width + 20;
                        if (rectangle.x + rectangle.width <= n4) continue block0;
                        rectangle.x = 10;
                        rectangle.y = n3 + 20;
                        n3 = 0;
                        continue block0;
                    }
                    ++n5;
                }
            }
        }
        viewBuilderComponent.setComponentBounds(rectangle);
    }

    private void _sendTableEvent(Table table, int n) {
        ViewBuilderEvent viewBuilderEvent = new ViewBuilderEvent(this, n, table);
        this.processEvent(viewBuilderEvent);
    }

    private boolean _sendTableValidateEvent(Table table, int n) {
        ViewBuilderValidateEvent viewBuilderValidateEvent = new ViewBuilderValidateEvent(this, n, table);
        this.processEvent(viewBuilderValidateEvent);
        return !viewBuilderValidateEvent.isCancelled();
    }

    private void _sendJoinEvent(Relationship relationship, int n) {
        ViewBuilderEvent viewBuilderEvent = new ViewBuilderEvent(this, n, relationship);
        this.processEvent(viewBuilderEvent);
    }

    private void _sendOuterJoinEvent(OuterJoin outerJoin, int n) {
        ViewBuilderEvent viewBuilderEvent = new ViewBuilderEvent(this, n, outerJoin);
        this.processEvent(viewBuilderEvent);
    }

    private boolean _sendJoinValidateEvent(Relationship relationship, int n) {
        ViewBuilderValidateEvent viewBuilderValidateEvent = new ViewBuilderValidateEvent(this, n, relationship);
        this.processEvent(viewBuilderValidateEvent);
        return !viewBuilderValidateEvent.isCancelled();
    }

    private void _deleteRelationship(Column column, Column column2) {
        Relationship[] relationshipArray = this.getRelationships();
        int n = 0;
        while (n < relationshipArray.length) {
            Relationship relationship = relationshipArray[n];
            int n2 = 0;
            while (n2 < relationship.getColumnCount()) {
                Column column3 = relationship.getColumn(n2);
                Column column4 = relationship.getReferencedColumn(n2);
                if (this._columnsEqual(column, column3) && this._columnsEqual(column2, column4)) {
                    this._deleteRelationship(relationship);
                }
                ++n2;
            }
            ++n;
        }
    }

    private void _createRelationship(Column column, Column column2) {
        Table table = column.getTable();
        DynamicRelationshipImpl dynamicRelationshipImpl = new DynamicRelationshipImpl(column, column2, null);
        if (this._getLink(dynamicRelationshipImpl) != null) {
            return;
        }
        DynamicRelationshipImpl dynamicRelationshipImpl2 = new DynamicRelationshipImpl(column2, column, null);
        if (this._getLink(dynamicRelationshipImpl2) != null) {
            return;
        }
        if (this._sendJoinValidateEvent(dynamicRelationshipImpl, 2004)) {
            if (table instanceof DynamicTable) {
                DynamicTable dynamicTable = (DynamicTable)table;
                dynamicTable.addForeignKey(dynamicRelationshipImpl, dynamicTable.getForeignKeyCount());
            } else {
                this.addRelationship(dynamicRelationshipImpl);
            }
            this._sendJoinEvent(dynamicRelationshipImpl, 2005);
        }
        if (this._updateIncludedJoins(column2.getTable()) || this._updateIncludedJoins(table)) {
            ((Component)((Object)this)).firePropertyChange(PROPERTY_INCLUDED_RELATIONSHIPS, null, this.getIncludedRelationships());
        }
    }

    private void _createMenu() {
        this._menu = new JPopupMenu();
        ResourceBundle resourceBundle = ResourceBundle.getBundle("oracle.bali.dbUI.resource.DBUIBundle", LocaleUtils.getDefaultableLocale((Component)((Object)this)));
        if (!(this._menuRelationship instanceof DynamicRelationship)) {
            int n = this._menuRelationship.getRelationshipType();
            String string = null;
            String string2 = null;
            switch (n) {
                case 0: {
                    string = resourceBundle.getString("EQUAL");
                    string2 = "EQUAL";
                    break;
                }
                case 1: {
                    string = resourceBundle.getString("NOT_EQUAL");
                    string2 = "NOT_EQUAL";
                    break;
                }
                case 2: {
                    string = resourceBundle.getString("GREATER");
                    string2 = "GREATER";
                    break;
                }
                case 3: {
                    string = resourceBundle.getString("LESS");
                    string2 = "LESS";
                    break;
                }
                case 5: {
                    string = resourceBundle.getString("GREATER_OR_EQUAL");
                    string2 = "GREATER_OR_EQUAL";
                    break;
                }
                case 4: {
                    string = resourceBundle.getString("LESS_OR_EQUAL");
                    string2 = "LESS_OR_EQUAL";
                }
            }
            if (string != null) {
                JMenuItem jMenuItem = new JMenuItem(string);
                jMenuItem.setActionCommand(string2);
                jMenuItem.addActionListener(this._listener);
                this._menu.add(jMenuItem);
            }
        } else {
            JMenuItem jMenuItem = new JMenuItem(resourceBundle.getString("EQUAL"));
            jMenuItem.setActionCommand("EQUAL");
            jMenuItem.addActionListener(this._listener);
            this._menu.add(jMenuItem);
            jMenuItem = new JMenuItem(resourceBundle.getString("NOT_EQUAL"));
            jMenuItem.setActionCommand("NOT_EQUAL");
            jMenuItem.addActionListener(this._listener);
            this._menu.add(jMenuItem);
            jMenuItem = new JMenuItem(resourceBundle.getString("GREATER"));
            jMenuItem.setActionCommand("GREATER");
            jMenuItem.addActionListener(this._listener);
            this._menu.add(jMenuItem);
            jMenuItem = new JMenuItem(resourceBundle.getString("LESS"));
            jMenuItem.setActionCommand("LESS");
            jMenuItem.addActionListener(this._listener);
            this._menu.add(jMenuItem);
            jMenuItem = new JMenuItem(resourceBundle.getString("GREATER_OR_EQUAL"));
            jMenuItem.setActionCommand("GREATER_OR_EQUAL");
            jMenuItem.addActionListener(this._listener);
            this._menu.add(jMenuItem);
            jMenuItem = new JMenuItem(resourceBundle.getString("LESS_OR_EQUAL"));
            jMenuItem.setActionCommand("LESS_OR_EQUAL");
            jMenuItem.addActionListener(this._listener);
            this._menu.add(jMenuItem);
        }
    }

    private boolean _updateIncludedJoins(Table table) {
        TableInfo tableInfo = this._getTableInfo(table);
        if (tableInfo == null) {
            return false;
        }
        ViewBuilderLink[] viewBuilderLinkArray = this._getLinks(tableInfo);
        if (viewBuilderLinkArray == null) {
            return false;
        }
        this.freezeRepaints();
        boolean bl = false;
        try {
            int n = 0;
            while (n < viewBuilderLinkArray.length) {
                RelationshipLink relationshipLink;
                ViewBuilderLink viewBuilderLink = viewBuilderLinkArray[n];
                if (viewBuilderLink instanceof RelationshipLink && !(relationshipLink = (RelationshipLink)viewBuilderLink).isUserDoubleClick()) {
                    boolean bl2;
                    ViewBuilderComponent viewBuilderComponent = viewBuilderLink.getSourcePort(0).getViewBuilderComponent();
                    ViewBuilderComponent viewBuilderComponent2 = viewBuilderLink.getDestinationPort(0).getViewBuilderComponent();
                    TableInfo tableInfo2 = this._getTableInfo(viewBuilderComponent);
                    TableInfo tableInfo3 = this._getTableInfo(viewBuilderComponent2);
                    boolean bl3 = bl2 = tableInfo2.getTableComponent().getSelectedColumnCount() != 0 && tableInfo3.getTableComponent().getSelectedColumnCount() != 0;
                    if (bl2 != relationshipLink.isIncluded()) {
                        bl = true;
                        relationshipLink.setIncluded(bl2);
                    }
                }
                ++n;
            }
            Object var14_13 = null;
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            this.unfreezeRepaints();
            throw throwable;
        }
        this.unfreezeRepaints();
        return bl;
    }

    private void _customizeTable(Table table, TableComponent tableComponent, TableViewBuilderComponent tableViewBuilderComponent, String string) {
        tableComponent.freezeRepaints();
        ViewBuilderCustomizer viewBuilderCustomizer = this.getCustomizer();
        Locale locale = LocaleUtils.getDefaultableLocale((Component)((Object)this));
        boolean bl = _ALL.equals(string);
        boolean bl2 = "name".equals(string) || "displayName".equals(string);
        boolean bl3 = _COLUMNS.equals(string);
        if (bl || bl2) {
            tableViewBuilderComponent.setTitle(table.getDisplayName(locale));
        }
        JMenuBar jMenuBar = null;
        if (bl) {
            tableViewBuilderComponent.setMenuBar(null);
            jMenuBar = this.getDefaultMenuBar(table, locale);
        }
        if (viewBuilderCustomizer != null) {
            if (bl || bl3) {
                viewBuilderCustomizer.customizeTableComponent(tableComponent, table);
            }
            if (bl) {
                viewBuilderCustomizer.customizeViewBuilderComponent(tableViewBuilderComponent, table);
                viewBuilderCustomizer.customizeMenuBar(jMenuBar, table, locale);
            }
        }
        if (bl && jMenuBar != null && jMenuBar.getMenuCount() != 0) {
            tableViewBuilderComponent.setMenuBar(jMenuBar);
        }
        tableComponent.unfreezeRepaints();
    }

    private void _removeCustomLinks(ViewBuilderComponent viewBuilderComponent) {
        ViewBuilderLink[] viewBuilderLinkArray = this.getLinks(viewBuilderComponent);
        int n = viewBuilderLinkArray == null ? 0 : viewBuilderLinkArray.length;
        int n2 = 0;
        while (n2 < n) {
            this.removeViewBuilderLink(viewBuilderLinkArray[n2]);
            ++n2;
        }
    }

    private int _indexOf(ViewBuilderLink viewBuilderLink) {
        int n = this._links.size();
        int n2 = 0;
        while (n2 < n) {
            if (this._links.elementAt(n2) == viewBuilderLink) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    private Column _getColumn(String string) {
        Column column = null;
        int n = string.indexOf(".");
        int n2 = string.indexOf(".", n + 1);
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1, n2);
        String string4 = string.substring(n2 + 1);
        Table[] tableArray = this.getTables();
        Object var11_9 = null;
        int n3 = 0;
        block0: while (n3 < tableArray.length) {
            Table table = tableArray[n3];
            if (string3.equals(table.getName()) && string2.equals(table.getSchema().getName())) {
                int n4 = 0;
                while (n4 < table.getColumnCount()) {
                    Column column2 = table.getColumn(n4);
                    if (string4.equals(column2.getName())) {
                        column = column2;
                        break block0;
                    }
                    ++n4;
                }
                break;
            }
            ++n3;
        }
        return column;
    }

    private void _addLink(Column column, String string) {
        Column column2 = this._getColumn(string);
        if (column2 != null) {
            this._createRelationship(column, column2);
        }
    }

    private void _deleteLink(Column column, String string) {
        Column column2 = this._getColumn(string);
        if (column2 != null) {
            this._deleteRelationship(column, column2);
        }
    }

    private int _indexOf(OuterJoin outerJoin) {
        int n = this._outerJoins.indexOf(outerJoin);
        if (n != -1) {
            return n;
        }
        int n2 = this._outerJoins.size();
        int n3 = 0;
        while (n3 < n2) {
            OuterJoin outerJoin2 = (OuterJoin)this._outerJoins.elementAt(n3);
            if (this._tablesEqual(outerJoin2.getSource(), outerJoin.getSource()) && this._tablesEqual(outerJoin2.getDestination(), outerJoin.getDestination())) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    private OuterJoin[] _getOuterJoins(Table table) {
        Object[] objectArray;
        if (this._outerJoins == null) {
            return null;
        }
        Vector<Object[]> vector = new Vector<Object[]>();
        int n = 0;
        while (n < this._outerJoins.size()) {
            objectArray = (Object[])this._outerJoins.elementAt(n);
            if (this._tablesEqual(objectArray.getSource(), table)) {
                vector.addElement(objectArray);
            }
            ++n;
        }
        if (vector.size() == 0) {
            return null;
        }
        objectArray = new OuterJoin[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private Table _getTable(String string) {
        Table[] tableArray = this.getTables();
        int n = string.indexOf(".");
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        int n2 = 0;
        while (n2 < tableArray.length) {
            if (tableArray[n2].getName().equals(string3) && tableArray[n2].getSchema().getName().equals(string2)) {
                return tableArray[n2];
            }
            ++n2;
        }
        return null;
    }

    private OuterJoin _getOuterJoin(Table table, Table table2) {
        if (this._outerJoins == null) {
            return null;
        }
        int n = 0;
        while (n < this._outerJoins.size()) {
            OuterJoin outerJoin = (OuterJoin)this._outerJoins.elementAt(n);
            if (this._tablesEqual(outerJoin.getSource(), table) && this._tablesEqual(outerJoin.getDestination(), table2)) {
                return outerJoin;
            }
            ++n;
        }
        return null;
    }

    private void _checkForOuterJoin(RelationshipLink relationshipLink, TableInfo tableInfo, TableInfo tableInfo2) {
        OuterJoin[] outerJoinArray = this.getOuterJoins();
        if (outerJoinArray == null) {
            return;
        }
        int n = 0;
        while (n < outerJoinArray.length) {
            OuterJoin outerJoin = outerJoinArray[n];
            if (this._tablesEqual(outerJoin.getSource(), tableInfo.getTable()) && this._tablesEqual(outerJoin.getDestination(), tableInfo2.getTable())) {
                relationshipLink.setSourceOuterJoin(true);
            } else if (this._tablesEqual(outerJoin.getSource(), tableInfo2.getTable()) && this._tablesEqual(outerJoin.getDestination(), tableInfo.getTable())) {
                relationshipLink.setDestinationOuterJoin(true);
            }
            ++n;
        }
    }

    void __firePropertyChange(String string, Object object, Object object2) {
        ((Component)((Object)this)).firePropertyChange(string, object, object2);
    }

    private class TableInfo {
        private TableViewBuilderComponent _viewBuilderComponent;
        private ViewBuilderLink[] _links;

        public TableInfo(Table table, TableComponent tableComponent, TableViewBuilderComponent tableViewBuilderComponent) {
            this._viewBuilderComponent = tableViewBuilderComponent;
        }

        public ViewBuilderLink[] getLinks() {
            return this._links;
        }

        public void setLinks(ViewBuilderLink[] viewBuilderLinkArray) {
            this._links = viewBuilderLinkArray;
        }

        public Table getTable() {
            return this.getTableComponent().getTable();
        }

        public TableComponent getTableComponent() {
            return this.getViewBuilderComponent().getTableComponent();
        }

        public TableViewBuilderComponent getViewBuilderComponent() {
            return this._viewBuilderComponent;
        }

        public void clear() {
            this.setLinks(null);
            this._viewBuilderComponent = null;
        }
    }

    private class TableAction
    implements PopupMenuListener,
    ActionListener,
    Task {
        private Table _table;
        private String _cmd;

        public TableAction(Table table) {
            this._table = table;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (ViewBuilder.TABLES_COMMAND.equals(string) || ViewBuilder.HIDE_TABLES_COMMAND.equals(string)) {
                this._cmd = string;
                DBUILookAndFeel.getTaskScheduler().schedule((Task)this, 0);
            } else if (string != null) {
                if (string.startsWith(ViewBuilder.COMMAND_CREATE_OUTER_JOIN)) {
                    String string2 = string.substring(ViewBuilder.COMMAND_CREATE_OUTER_JOIN.length());
                    Table table = ViewBuilder.this._getTable(string2);
                    OuterJoin outerJoin = ViewBuilder.this.createOuterJoin(this._table, table);
                } else if (string.startsWith(ViewBuilder.COMMAND_DELETE_OUTER_JOIN)) {
                    String string3 = string.substring(ViewBuilder.COMMAND_DELETE_OUTER_JOIN.length());
                    Table table = ViewBuilder.this._getTable(string3);
                    OuterJoin outerJoin = ViewBuilder.this._getOuterJoin(this._table, table);
                    ViewBuilder.this.removeOuterJoin(outerJoin);
                }
            }
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        }

        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            JPopupMenu jPopupMenu = (JPopupMenu)popupMenuEvent.getSource();
            OuterJoin[] outerJoinArray = ViewBuilder.this._getOuterJoins(this._table);
            JPopupMenu jPopupMenu2 = jPopupMenu;
            Locale locale = LocaleUtils.getDefaultableLocale((Component)((Object)ViewBuilder.this));
            int n = 0;
            while (n < jPopupMenu2.getComponentCount()) {
                Component component = jPopupMenu2.getComponent(n);
                if (component instanceof JMenu) {
                    JMenu jMenu = (JMenu)component;
                    String string = jMenu.getActionCommand();
                    if (ViewBuilder.COMMAND_CREATE_OUTER_JOIN.equals(string)) {
                        Table[] tableArray = ViewBuilder.this.getTables();
                        int n2 = tableArray.length;
                        jMenu.setEnabled(n2 > 1);
                        if (n2 > 0) {
                            this._addCreateOuterJoinMenu(jMenu, this._table, tableArray, outerJoinArray, locale);
                        }
                    } else if (ViewBuilder.COMMAND_DELETE_OUTER_JOIN.equals(string)) {
                        jMenu.setEnabled(outerJoinArray != null);
                        if (outerJoinArray != null) {
                            this._addDeleteOuterJoinMenu(jMenu, this._table, outerJoinArray, locale);
                        }
                    }
                }
                ++n;
            }
        }

        private void _addCreateOuterJoinMenu(JMenu jMenu, Table table, Table[] tableArray, OuterJoin[] outerJoinArray, Locale locale) {
            JPopupMenu jPopupMenu = jMenu.getPopupMenu();
            if (jPopupMenu != null) {
                this._removeListeners(jPopupMenu);
            }
            jMenu.removeAll();
            int n = outerJoinArray == null ? 0 : outerJoinArray.length;
            int n2 = 0;
            while (n2 < tableArray.length) {
                Table table2 = tableArray[n2];
                if (!ViewBuilder.this._tablesEqual(table2, table)) {
                    boolean bl = false;
                    int n3 = 0;
                    while (n3 < n) {
                        if (ViewBuilder.this._tablesEqual(outerJoinArray[n3].getDestination(), table2)) {
                            bl = true;
                            break;
                        }
                        ++n3;
                    }
                    if (!bl) {
                        JMenuItem jMenuItem = new JMenuItem(table2.getDisplayName(locale));
                        jMenuItem.setActionCommand(ViewBuilder.COMMAND_CREATE_OUTER_JOIN + table2.getSchema().getName() + "." + table2.getName());
                        jMenuItem.addActionListener(this);
                        jMenu.add(jMenuItem);
                    }
                }
                ++n2;
            }
            jMenu.setEnabled(jMenu.isEnabled() & jMenu.getMenuComponentCount() > 0);
        }

        private void _addDeleteOuterJoinMenu(JMenu jMenu, Table table, OuterJoin[] outerJoinArray, Locale locale) {
            JPopupMenu jPopupMenu = jMenu.getPopupMenu();
            if (jPopupMenu != null) {
                this._removeListeners(jPopupMenu);
            }
            jMenu.removeAll();
            int n = 0;
            while (n < outerJoinArray.length) {
                Table table2 = outerJoinArray[n].getDestination();
                JMenuItem jMenuItem = new JMenuItem(table2.getDisplayName(locale));
                jMenuItem.setActionCommand(ViewBuilder.COMMAND_DELETE_OUTER_JOIN + table2.getSchema().getName() + "." + table2.getName());
                jMenuItem.addActionListener(this);
                jMenu.add(jMenuItem);
                ++n;
            }
        }

        private void _removeListeners(JPopupMenu jPopupMenu) {
            JPopupMenu jPopupMenu2 = jPopupMenu;
            int n = 0;
            while (n < jPopupMenu2.getComponentCount()) {
                Component component = jPopupMenu2.getComponent(n);
                if (component instanceof JMenuItem) {
                    ((JMenuItem)component).removeActionListener(this);
                }
                ++n;
            }
        }

        public void runTask(TaskEvent taskEvent) {
            DBUILookAndFeel.getLookAndFeel().setCursor((Component)((Object)ViewBuilder.this), true);
            if (ViewBuilder.TABLES_COMMAND.equals(this._cmd)) {
                ViewBuilder.this._addRelatedTables(this._table, true);
            } else if (ViewBuilder.HIDE_TABLES_COMMAND.equals(this._cmd)) {
                ViewBuilder.this._hideRelatedTables(this._table);
            }
            DBUILookAndFeel.getLookAndFeel().setCursor((Component)((Object)ViewBuilder.this), false);
        }
    }

    private class Listener
    extends DynamicTableAdapter
    implements DynamicRelationshipListener,
    PropertyChangeListener,
    VetoableChangeListener,
    ActionListener {
        private Listener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("relationshipType".equals(string)) {
                ViewBuilder.this._updateRelationship((Relationship)propertyChangeEvent.getSource());
            } else if (ViewBuilder.PROPERTY_SELECTED_COLUMNS.equals(string)) {
                TableComponent tableComponent = (TableComponent)propertyChangeEvent.getSource();
                ViewBuilder.this._selectionChanged(tableComponent.getTable());
            } else if ("closed".equals(string)) {
                ViewBuilderComponent viewBuilderComponent = (ViewBuilderComponent)propertyChangeEvent.getSource();
                ViewBuilder.this._closeComponent(viewBuilderComponent);
            } else if ("componentSelected".equals(string)) {
                ViewBuilderComponent viewBuilderComponent = (ViewBuilderComponent)propertyChangeEvent.getSource();
                ViewBuilder.this._activateJoins(viewBuilderComponent, (Boolean)propertyChangeEvent.getNewValue());
            } else if (propertyChangeEvent.getSource() instanceof Table) {
                Table table = (Table)propertyChangeEvent.getSource();
                ViewBuilder.this._customizeTable(table, string);
            }
        }

        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            String string = propertyChangeEvent.getPropertyName();
            if ("closed".equals(string) && !ViewBuilder.this._tryClose((ViewBuilderComponent)propertyChangeEvent.getSource())) {
                throw new PropertyVetoException("The client canceled the close", propertyChangeEvent);
            }
        }

        public void columnAdded(DynamicRelationshipEvent dynamicRelationshipEvent) {
            ViewBuilder.this._updateRelationship(dynamicRelationshipEvent.getRelationship());
        }

        public void columnRemoved(DynamicRelationshipEvent dynamicRelationshipEvent) {
            ViewBuilder.this._updateRelationship(dynamicRelationshipEvent.getRelationship());
        }

        public void columnAdded(DynamicTableEvent dynamicTableEvent) {
            ViewBuilder.this._customizeTable(dynamicTableEvent.getTable(), ViewBuilder._COLUMNS);
        }

        public void columnRemoved(DynamicTableEvent dynamicTableEvent) {
            ViewBuilder.this._customizeTable(dynamicTableEvent.getTable(), ViewBuilder._COLUMNS);
            ViewBuilder.this._updateRelationships(dynamicTableEvent.getTable(), dynamicTableEvent.getColumn());
        }

        public void foreignKeyAdded(DynamicTableEvent dynamicTableEvent) {
            ViewBuilder.this._updateRelationships(dynamicTableEvent.getTable(), dynamicTableEvent.getForeignKey(), true);
        }

        public void foreignKeyRemoved(DynamicTableEvent dynamicTableEvent) {
            ViewBuilder.this._updateRelationships(dynamicTableEvent.getTable(), dynamicTableEvent.getForeignKey(), false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            int n = -1;
            if ("EQUAL".equals(string)) {
                n = 0;
            } else if ("NOT_EQUAL".equals(string)) {
                n = 1;
            } else if ("GREATER".equals(string)) {
                n = 2;
            } else if ("LESS".equals(string)) {
                n = 3;
            } else if ("GREATER_OR_EQUAL".equals(string)) {
                n = 5;
            } else if ("LESS_OR_EQUAL".equals(string)) {
                n = 4;
            } else if (string != null) {
                Object object;
                int n2 = -1;
                int n3 = ViewBuilder.this._links.size();
                ViewBuilderLink[] viewBuilderLinkArray = ViewBuilder.this.getSelectedLinks();
                if (ViewBuilder.COMMAND_LEFT.equals(string)) {
                    if (n3 != 0) {
                        if (viewBuilderLinkArray.length == 0) {
                            n2 = n3 - 1;
                        } else {
                            n2 = ViewBuilder.this._indexOf(viewBuilderLinkArray[0]) - 1;
                            if (n2 < 0) {
                                n2 = n3 - 1;
                            }
                        }
                    }
                } else if (ViewBuilder.COMMAND_RIGHT.equals(string)) {
                    if (n3 != 0) {
                        n2 = viewBuilderLinkArray.length == 0 ? 0 : (ViewBuilder.this._indexOf(viewBuilderLinkArray[0]) + 1) % n3;
                    }
                } else if (ViewBuilder.COMMAND_SELECT.equals(string)) {
                    if (viewBuilderLinkArray.length != 0) {
                        ViewBuilder.this._includeLinks(viewBuilderLinkArray);
                    }
                } else if (ViewBuilder.COMMAND_DELETE.equals(string)) {
                    if (viewBuilderLinkArray.length != 0 && ViewBuilder.this.isLinkDeletionAllowed()) {
                        ViewBuilder.this._deleteLinks(viewBuilderLinkArray);
                        if (ViewBuilder.this._links.size() != 0) {
                            n2 = 0;
                        }
                    } else {
                        ViewBuilder.this._deleteSelectedComponents();
                    }
                } else if (string.startsWith(ViewBuilder.COMMAND_LINK)) {
                    object = string.substring(ViewBuilder.COMMAND_LINK.length());
                    ViewBuilder.this._addLink(ViewBuilder.this._menuColumn, (String)object);
                } else if (string.startsWith(ViewBuilder.COMMAND_DELETE_LINK)) {
                    object = string.substring(ViewBuilder.COMMAND_DELETE_LINK.length());
                    ViewBuilder.this._deleteLink(ViewBuilder.this._menuColumn, (String)object);
                }
                if (n2 != -1) {
                    object = (ViewBuilderLink)ViewBuilder.this._links.elementAt(n2);
                    ViewBuilder.this.setAllLinksSelected(false);
                    ViewBuilder.this.setLinkSelected((ViewBuilderLink)object, true);
                    if (object instanceof RelationshipLink) {
                        ViewBuilder.this.__firePropertyChange(ViewBuilder.PROPERTY_SELECTED_RELATIONSHIPS, null, ViewBuilder.this.getSelectedRelationships());
                    }
                }
            }
            if (n != -1) {
                ViewBuilder.this._setMenuJoinType(n);
            }
        }
    }

    private class AccessibleViewBuilder
    extends JComponent.AccessibleJComponent {
        public AccessibleViewBuilder() {
            super((JComponent)((Object)ViewBuilder.this));
            AccessibleContext accessibleContext = ViewBuilder.this.getCanvas().getAccessibleContext();
            accessibleContext.setAccessibleParent(ViewBuilder.this);
        }

        public String getAccessibleName() {
            Relationship[] relationshipArray;
            String string = super.getAccessibleName();
            if ((string == null || string == "") && (relationshipArray = ViewBuilder.this.getSelectedRelationships()).length != 0) {
                string = this._getRelationshipName(relationshipArray[0]);
            }
            if (string == null || string == "") {
                string = this._getAccessibleString(ViewBuilder._KEY_CANVAS_NAME);
            }
            return string;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PANEL;
        }

        public int getAccessibleChildrenCount() {
            return 1;
        }

        public Accessible getAccessibleChild(int n) {
            if (n < 0 || n >= this.getAccessibleChildrenCount()) {
                return null;
            }
            return ViewBuilder.this.getCanvas();
        }

        private String _getAccessibleString(String string) {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("oracle.bali.dbUI.resource.AccessibleBundle", ((Component.AccessibleAWTComponent)this).getLocale());
            return resourceBundle.getString(string);
        }

        private String _getTypeName(int n) {
            String string = null;
            switch (n) {
                case 1: {
                    string = ViewBuilder._KEY_NOT_EQUAL;
                    break;
                }
                case 2: {
                    string = ViewBuilder._KEY_GREATER;
                    break;
                }
                case 3: {
                    string = ViewBuilder._KEY_LESS;
                    break;
                }
                case 4: {
                    string = ViewBuilder._KEY_LESSEQUAL;
                    break;
                }
                case 5: {
                    string = ViewBuilder._KEY_GREATEREQUAL;
                    break;
                }
                default: {
                    string = ViewBuilder._KEY_EQUAL;
                }
            }
            return this._getAccessibleString(string);
        }

        private String _getRelationshipName(Relationship relationship) {
            int n = relationship.getColumnCount();
            String string = relationship.getDisplayName(((Component.AccessibleAWTComponent)this).getLocale());
            String string2 = this._getTypeName(relationship.getRelationshipType());
            int n2 = 0;
            while (n2 < n) {
                Column column = relationship.getColumn(n2);
                Column column2 = relationship.getReferencedColumn(n2);
                string = string + " " + column.getTable().getName() + "." + column.getName() + " " + string2 + " " + column2.getTable().getName() + "." + column2.getName() + " ";
                ++n2;
            }
            return string;
        }
    }
}

