/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.viewBuilder;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.UIDefaults;
import oracle.bali.dbUI.db.DynamicRelationship;
import oracle.bali.dbUI.db.Relationship;
import oracle.bali.dbUI.viewBuilder.RelationshipLink;
import oracle.bali.dbUI.viewBuilder.ViewBuilderComponent;
import oracle.bali.dbUI.viewBuilder.ViewBuilderLinkPainter;
import oracle.bali.dbUI.viewBuilder.ViewBuilderLinkPort;
import oracle.bali.ewt.graphics.FontUtils;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.painter.PaintContext;

public class RelationshipLinkPainter
extends ViewBuilderLinkPainter {
    private static Frame _sIMAGE_CREATOR = new Frame();
    private static final String _IMAGE_PATH = "/oracle/bali/dbUI/viewBuilder/images/";
    private static Image _sEqualImage;
    private static Image _sNotEqualImage;
    private static Image _sLessImage;
    private static Image _sGreaterImage;
    private static Image _sLessEqualImage;
    private static Image _sGreaterEqualImage;
    private static Image _sOuterJoinImage;
    private static final int _START_OFFSET = 6;
    private static final int _OFFSET_MAX = 30;
    private static final int _OFFSET_INCREMENT = 6;
    private static final int _ATTACH_SIZE = 4;
    private static final int _NAME_OFFSET = 7;
    private static final float _FONT_FACTOR = 0.75f;
    private static final int _IMAGE_OFFSET = 12;
    private static final int _LINE_SIZE = 6;
    private static int _sJoinOffset;
    private Listener _listener;
    private int[] _joinOffset;
    private Vector _joinInfo;
    private Image _name;
    private int _x;
    private int _y;
    private int _width;
    private int _height;
    static /* synthetic */ Class class$oracle$bali$dbUI$viewBuilder$ViewBuilderLinkPainter;

    public RelationshipLinkPainter(RelationshipLink relationshipLink) {
        super(relationshipLink);
        int n = relationshipLink.getPortCount();
        this._joinOffset = new int[n];
        int n2 = 0;
        while (n2 < n) {
            this._joinOffset[n2] = _sJoinOffset;
            RelationshipLinkPainter._incrementOffset();
            ++n2;
        }
        this._joinInfo = new Vector();
        this._listener = new Listener();
        relationshipLink.addPropertyChangeListener(this._listener);
        Relationship relationship = relationshipLink.getRelationship();
        if (relationship instanceof DynamicRelationship) {
            ((DynamicRelationship)relationship).addPropertyChangeListener(this._listener);
        }
    }

    public void paint(PaintContext paintContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.validate(paintContext);
        int n5 = this.getRelationshipLink().getPortCount();
        UIDefaults uIDefaults = paintContext.getPaintUIDefaults();
        int n6 = paintContext.getPaintState();
        boolean bl = (n6 & 4) == 0 && this.getRelationshipLink().isActive();
        boolean bl2 = (n6 & 1) == 0;
        boolean bl3 = this.getRelationshipLink().isSelected();
        boolean bl4 = this.getRelationshipLink().isIncluded();
        Color color = uIDefaults.getColor("darkIntensity");
        Color color2 = uIDefaults.getColor("normalIntensity");
        Color color3 = uIDefaults.getColor("textHighlight");
        Color color4 = uIDefaults.getColor("textInactiveText");
        Color color5 = !bl2 ? color4 : (bl4 & !bl3 ? Color.black : (bl3 ? color3 : (bl ? color : color2)));
        Image image = this._getImage();
        Image image2 = this._getSourceOuterJoinImage();
        Image image3 = this._getDestOuterJoinImage();
        Image image4 = this._getName(paintContext);
        ImageObserver imageObserver = paintContext.getImageObserver();
        int n7 = 0;
        while (n7 < n5) {
            graphics.setColor(color5);
            Info info = (Info)this._joinInfo.elementAt(n7);
            graphics.drawLine(info.p1x, info.p1y, info.p2x, info.p2y);
            graphics.drawLine(info.p1x, info.p1y + 1, info.p2x, info.p2y + 1);
            graphics.drawLine(info.p2x, info.p2y, info.p3x, info.p3y);
            graphics.drawLine(info.p2x + 1, info.p2y, info.p3x + 1, info.p3y);
            graphics.drawLine(info.p3x, info.p3y, info.p4x, info.p4y);
            graphics.drawLine(info.p3x, info.p3y + 1, info.p4x, info.p4y + 1);
            if (bl3) {
                graphics.drawLine(info.p1x, info.p1y + 2, info.p2x, info.p2y + 2);
                graphics.drawLine(info.p2x + 2, info.p2y, info.p3x + 2, info.p3y);
                graphics.drawLine(info.p3x, info.p3y + 2, info.p4x, info.p4y + 2);
            }
            if (!bl3 & bl & !bl4 & bl2) {
                graphics.setColor(Color.white);
                graphics.drawLine(info.p1x, info.p1y, info.p2x, info.p2y);
                graphics.drawLine(info.p2x, info.p2y, info.p3x, info.p3y);
                graphics.drawLine(info.p3x, info.p3y, info.p4x, info.p4y);
            }
            if (bl4 & bl3 & bl2) {
                graphics.setColor(Color.black);
                graphics.drawLine(info.p1x, info.p1y + 1, info.p2x, info.p2y + 1);
                graphics.drawLine(info.p2x + 1, info.p2y, info.p3x + 1, info.p3y);
                graphics.drawLine(info.p3x, info.p3y + 1, info.p4x, info.p4y + 1);
            }
            if (info.left) {
                if (bl2) {
                    graphics.setColor(Color.black);
                } else {
                    graphics.setColor(color4);
                }
                graphics.drawLine(info.parentX - 1, info.parentY - 3, info.parentX - 1, info.parentY + 4);
                graphics.drawLine(info.parentX - 2, info.parentY - 2, info.parentX - 2, info.parentY + 3);
                graphics.drawLine(info.parentX - 3, info.parentY - 1, info.parentX - 3, info.parentY + 2);
            } else {
                if (bl2) {
                    graphics.setColor(Color.black);
                } else {
                    graphics.setColor(color4);
                }
                graphics.drawLine(info.parentX, info.parentY - 3, info.parentX, info.parentY + 4);
                graphics.drawLine(info.parentX + 1, info.parentY - 2, info.parentX + 1, info.parentY + 3);
                graphics.drawLine(info.parentX + 2, info.parentY - 1, info.parentX + 2, info.parentY + 2);
            }
            if (image != null) {
                graphics.drawImage(image, info.imageX, info.imageY, imageObserver);
            }
            if (image2 != null) {
                graphics.drawImage(image2, info.sourceImageX, info.sourceImageY, imageObserver);
            }
            if (image3 != null) {
                graphics.drawImage(image3, info.destImageX, info.destImageY, imageObserver);
            }
            if (image4 != null) {
                graphics.drawImage(image4, info.nameX, info.nameY, imageObserver);
            }
            ++n7;
        }
    }

    public boolean contains(PaintContext paintContext, int n, int n2) {
        this.validate(paintContext);
        int n3 = this.getRelationshipLink().getPortCount();
        int n4 = 3;
        ImageObserver imageObserver = paintContext.getImageObserver();
        Image image = this._getImage();
        int n5 = image == null ? 0 : image.getWidth(imageObserver);
        int n6 = image == null ? 0 : image.getHeight(imageObserver);
        Image image2 = this._getName(paintContext);
        int n7 = image2 == null ? 0 : image2.getWidth(imageObserver);
        int n8 = image2 == null ? 0 : image2.getHeight(imageObserver);
        Image image3 = this._getSourceOuterJoinImage();
        int n9 = image3 == null ? 0 : image3.getWidth(imageObserver);
        int n10 = image3 == null ? 0 : image3.getHeight(imageObserver);
        Image image4 = this._getDestOuterJoinImage();
        int n11 = image4 == null ? 0 : image4.getWidth(imageObserver);
        int n12 = image4 == null ? 0 : image4.getHeight(imageObserver);
        int n13 = 0;
        while (n13 < n3) {
            Info info = (Info)this._joinInfo.elementAt(n13);
            if (n >= info.p1x && n <= info.p2x && n2 >= info.p1y - n4 && n2 <= info.p1y + n4) {
                return true;
            }
            if (n >= info.p2x - n4 && n <= info.p2x + n4 && (n2 >= info.p2y && n2 <= info.p3y || n2 >= info.p3y && n2 <= info.p2y)) {
                return true;
            }
            if ((n >= info.p3x && n <= info.p4x || n >= info.p4x && n <= info.p3x) && n2 >= info.p3y - n4 && n2 <= info.p3y + n4) {
                return true;
            }
            if (image != null && n >= info.imageX && n <= info.imageX + n5 && n2 >= info.imageY && n2 <= info.imageY + n6) {
                return true;
            }
            if (image2 != null && n >= info.nameX && n <= info.nameX + n7 && n2 >= info.nameY && n2 <= info.nameY + n8) {
                return true;
            }
            if (image3 != null && n >= info.sourceImageX && n <= info.sourceImageX + n9 && n2 >= info.sourceImageY && n2 <= info.sourceImageY + n10) {
                return true;
            }
            if (image4 != null && n >= info.destImageX && n <= info.destImageX + n11 && n2 >= info.destImageY && n2 <= info.destImageY + n12) {
                return true;
            }
            ++n13;
        }
        return false;
    }

    public RelationshipLink getRelationshipLink() {
        return (RelationshipLink)this.getLink();
    }

    public void cleanup() {
        this._joinOffset = null;
        this._joinInfo.removeAllElements();
        this._joinInfo = null;
        this._name = null;
        this.getLink().removePropertyChangeListener(this._listener);
        Relationship relationship = this.getRelationshipLink().getRelationship();
        if (relationship instanceof DynamicRelationship) {
            ((DynamicRelationship)relationship).removePropertyChangeListener(this._listener);
        }
        super.cleanup();
    }

    public Point getPoint(PaintContext paintContext, Rectangle rectangle) {
        Info info;
        if (rectangle == null || rectangle.isEmpty()) {
            return null;
        }
        Rectangle rectangle2 = this.getBounds(paintContext);
        if (!rectangle.intersects(rectangle2)) {
            return null;
        }
        Rectangle rectangle3 = rectangle.intersection(rectangle2);
        int n = 0;
        while (n < this._joinInfo.size()) {
            info = (Info)this._joinInfo.elementAt(n);
            if (rectangle3.contains(info.p1x, info.p1y)) {
                return new Point(info.p1x, info.p1y);
            }
            if (rectangle3.contains(info.p2x, info.p2y)) {
                return new Point(info.p2x, info.p2y);
            }
            if (rectangle3.contains(info.p3x, info.p3y)) {
                return new Point(info.p3x, info.p3y);
            }
            if (rectangle3.contains(info.p4x, info.p4y)) {
                return new Point(info.p4x, info.p4y);
            }
            ++n;
        }
        Rectangle rectangle4 = new Rectangle();
        int n2 = 3;
        int n3 = 0;
        while (n3 < this._joinInfo.size()) {
            info = (Info)this._joinInfo.elementAt(n3);
            rectangle4.setBounds(info.p1x, info.p1y, info.p2x - info.p1x, n2);
            if (rectangle4.intersects(rectangle3)) {
                return rectangle4.intersection(rectangle3).getLocation();
            }
            rectangle4.setBounds(info.p2x, Math.min(info.p2y, info.p3y), n2, Math.abs(info.p2y - info.p3y));
            if (rectangle4.intersects(rectangle3)) {
                return rectangle4.intersection(rectangle3).getLocation();
            }
            rectangle4.setBounds(Math.min(info.p3x, info.p4x), info.p4y, Math.abs(info.p3x - info.p4x), n2);
            if (rectangle4.intersects(rectangle3)) {
                return rectangle4.intersection(rectangle3).getLocation();
            }
            ++n3;
        }
        return null;
    }

    public Dimension getMinimumSize(PaintContext paintContext) {
        this.validate(paintContext);
        return new Dimension(this._width, this._height);
    }

    public Rectangle getBounds(PaintContext paintContext) {
        this.validate(paintContext);
        return new Rectangle(this._x, this._y, this._width, this._height);
    }

    protected void validatePainter(PaintContext paintContext) {
        this._joinInfo.removeAllElements();
        ImageObserver imageObserver = paintContext.getImageObserver();
        Image image = this._getImage();
        int n = image == null ? 0 : image.getWidth(imageObserver);
        int n2 = image == null ? 0 : image.getHeight(imageObserver);
        Image image2 = this._getName(paintContext);
        int n3 = image2 == null ? 0 : image2.getWidth(imageObserver);
        int n4 = image2 == null ? 0 : image2.getHeight(imageObserver);
        Image image3 = this._getSourceOuterJoinImage();
        int n5 = image3 == null ? 0 : image3.getWidth(imageObserver);
        int n6 = image3 == null ? 0 : image3.getHeight(imageObserver);
        Image image4 = this._getDestOuterJoinImage();
        int n7 = image4 == null ? 0 : image4.getWidth(imageObserver);
        int n8 = image4 == null ? 0 : image4.getHeight(imageObserver);
        int n9 = Integer.MAX_VALUE;
        int n10 = Integer.MAX_VALUE;
        int n11 = 0;
        int n12 = 0;
        int n13 = this.getRelationshipLink().getPortCount();
        int n14 = 0;
        while (n14 < n13) {
            int n15;
            Info info = new Info();
            this._joinInfo.addElement(info);
            ViewBuilderLinkPort viewBuilderLinkPort = this.getRelationshipLink().getSourcePort(n14);
            Rectangle rectangle = viewBuilderLinkPort.getBounds();
            ViewBuilderComponent viewBuilderComponent = viewBuilderLinkPort.getViewBuilderComponent();
            Rectangle rectangle2 = viewBuilderComponent.getComponentBounds();
            ViewBuilderLinkPort viewBuilderLinkPort2 = this.getRelationshipLink().getDestinationPort(n14);
            Rectangle rectangle3 = viewBuilderLinkPort2.getBounds();
            ViewBuilderComponent viewBuilderComponent2 = viewBuilderLinkPort2.getViewBuilderComponent();
            Rectangle rectangle4 = viewBuilderComponent2.getComponentBounds();
            int n16 = rectangle.x + rectangle2.x;
            int n17 = rectangle.y + rectangle2.y + rectangle.height / 2;
            int n18 = rectangle3.x + rectangle4.x;
            int n19 = rectangle3.y + rectangle4.y + rectangle3.height / 2;
            if (n16 + rectangle.width + this._joinOffset[n14] + 4 < n18) {
                n15 = (n16 += rectangle.width) + this._joinOffset[n14];
                info.p1x = n16;
                info.p1y = n17;
                info.p2x = n15;
                info.p2y = n17;
                info.p3x = n15;
                info.p3y = n19;
                info.p4x = n18;
                info.p4y = n19;
                info.left = true;
                if (image != null) {
                    info.imageX = n16 + 12;
                    info.imageY = n17 - n2 / 2;
                }
                if (image2 != null) {
                    info.nameX = n18 - n3 - 7;
                    info.nameY = n19 - n4 / 2;
                }
                if (image3 != null) {
                    info.sourceImageX = n18 - n5 - 5;
                    info.sourceImageY = n19 - n6 / 2;
                }
                if (image4 != null) {
                    info.destImageX = n16 + 1;
                    info.destImageY = n17 - n8 / 2;
                }
            } else if (n16 < n18) {
                n15 = this._joinOffset[n14] + Math.max(n18 += rectangle3.width, n16 + rectangle.width);
                info.p1x = n16 + rectangle.width;
                info.p1y = n17;
                info.p2x = n15;
                info.p2y = n17;
                info.p3x = n15;
                info.p3y = n19;
                info.p4x = n18;
                info.p4y = n19;
                info.left = false;
                if (image != null) {
                    info.imageX = n16 + rectangle.width + 12;
                    info.imageY = n17 - n2 / 2;
                }
                if (image2 != null) {
                    info.nameX = n18 + 7;
                    info.nameY = n19 - n4 / 2;
                }
                if (image3 != null) {
                    info.sourceImageX = n18 + 5;
                    info.sourceImageY = n19 - n6 / 2;
                }
                if (image4 != null) {
                    info.destImageX = n16 + rectangle.width + 1;
                    info.destImageY = n17 - n8 / 2;
                }
            } else if (n18 + rectangle3.width + this._joinOffset[n14] + 4 < n16) {
                n15 = (n18 += rectangle3.width) + this._joinOffset[n14];
                info.p1x = n18;
                info.p1y = n19;
                info.p2x = n15;
                info.p2y = n19;
                info.p3x = n15;
                info.p3y = n17;
                info.p4x = n16;
                info.p4y = n17;
                info.left = false;
                if (image != null) {
                    info.imageX = n16 - n - 12;
                    info.imageY = n17 - n2 / 2;
                }
                if (image2 != null) {
                    info.nameX = n18 + 7;
                    info.nameY = n19 - n4 / 2;
                }
                if (image3 != null) {
                    info.sourceImageX = n18 + 5;
                    info.sourceImageY = n19 - n6 / 2;
                }
                if (image4 != null) {
                    info.destImageX = n16 - n7 - 1;
                    info.destImageY = n17 - n8 / 2;
                }
            } else {
                n15 = this._joinOffset[n14] + Math.max(n18 += rectangle3.width, n16 + rectangle.width);
                info.p1x = n18;
                info.p1y = n19;
                info.p2x = n15;
                info.p2y = n19;
                info.p3x = n15;
                info.p3y = n17;
                info.p4x = n16 + rectangle.width;
                info.p4y = n17;
                info.left = false;
                if (image != null) {
                    info.imageX = n16 + rectangle.width + 12;
                    info.imageY = n17 - n2 / 2;
                }
                if (image2 != null) {
                    info.nameX = n18 + 7;
                    info.nameY = n19 - n4 / 2;
                }
                if (image3 != null) {
                    info.sourceImageX = n18 + 5;
                    info.sourceImageY = n19 - n6 / 2;
                }
                if (image4 != null) {
                    info.destImageX = n16 + rectangle.width + 1;
                    info.destImageY = n17 - n8 / 2;
                }
            }
            info.parentX = n18;
            info.parentY = n19;
            n9 = Math.min(n9, Math.min(info.p1x, info.p4x));
            n10 = Math.min(n10, Math.min(info.p1y, info.p3y));
            n11 = Math.max(n11, Math.max(info.p2x, info.p4x));
            n12 = Math.max(n12, Math.max(info.p1y, info.p3y));
            ++n14;
        }
        this._x = n9;
        this._y = n10;
        this._width = n11 - n9 + 2;
        this._height = n12 - n10 + 2;
    }

    private static void _incrementOffset() {
        if ((_sJoinOffset += 6) > 30) {
            _sJoinOffset = 6;
        }
    }

    private Image _createImage(int n, int n2) {
        return _sIMAGE_CREATOR.createImage(n, n2);
    }

    private Image _getSourceOuterJoinImage() {
        RelationshipLinkPainter._loadImages();
        return this.getRelationshipLink().isSourceOuterJoin() ? _sOuterJoinImage : null;
    }

    private Image _getDestOuterJoinImage() {
        RelationshipLinkPainter._loadImages();
        return this.getRelationshipLink().isDestinationOuterJoin() ? _sOuterJoinImage : null;
    }

    private Image _getImage() {
        int n = this.getRelationshipLink().getRelationship().getRelationshipType();
        if (n == 0) {
            return null;
        }
        Image image = null;
        RelationshipLinkPainter._loadImages();
        switch (n) {
            case 1: {
                image = _sNotEqualImage;
                break;
            }
            case 2: {
                image = _sGreaterImage;
                break;
            }
            case 3: {
                image = _sLessImage;
                break;
            }
            case 5: {
                image = _sGreaterEqualImage;
                break;
            }
            case 4: {
                image = _sLessEqualImage;
            }
        }
        return image;
    }

    private Image _getName(PaintContext paintContext) {
        if (this.getRelationshipLink().getPortCount() == 1) {
            return null;
        }
        if (this._name == null) {
            this._name = this._createName(paintContext);
        }
        return this._name;
    }

    private Image _createName(PaintContext paintContext) {
        int n;
        int n2;
        String string = this.getRelationshipLink().getRelationship().getDisplayName(paintContext.getPaintLocale());
        if (string == null) {
            return null;
        }
        Font font = FontUtils.getDefaultSansSerifFont();
        int n3 = (int)((float)font.getSize() * 0.75f);
        font = new Font(font.getName(), font.getStyle(), n3);
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        int n4 = fontMetrics.stringWidth(string) + 6;
        Image image = this._createImage(n4, n2 = (n = fontMetrics.getHeight()) + 4);
        if (image != null) {
            Graphics graphics = image.getGraphics();
            graphics.setFont(font);
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, n4, n2);
            graphics.setColor(Color.black);
            graphics.drawRect(0, 0, n4 - 1, n2 - 1);
            int n5 = (n2 - n) / 2 + fontMetrics.getAscent();
            graphics.drawString(string, 2, n5);
        }
        return image;
    }

    private static void _loadImages() {
        if (_sEqualImage == null) {
            Class clazz = class$oracle$bali$dbUI$viewBuilder$ViewBuilderLinkPainter == null ? (class$oracle$bali$dbUI$viewBuilder$ViewBuilderLinkPainter = RelationshipLinkPainter.class$("oracle.bali.dbUI.viewBuilder.ViewBuilderLinkPainter")) : class$oracle$bali$dbUI$viewBuilder$ViewBuilderLinkPainter;
            _sEqualImage = ImageUtils.getImageResource((Class)clazz, (String)"/oracle/bali/dbUI/viewBuilder/images/equal.gif");
            _sNotEqualImage = ImageUtils.getImageResource((Class)clazz, (String)"/oracle/bali/dbUI/viewBuilder/images/notequal.gif");
            _sLessImage = ImageUtils.getImageResource((Class)clazz, (String)"/oracle/bali/dbUI/viewBuilder/images/less.gif");
            _sGreaterImage = ImageUtils.getImageResource((Class)clazz, (String)"/oracle/bali/dbUI/viewBuilder/images/greater.gif");
            _sLessEqualImage = ImageUtils.getImageResource((Class)clazz, (String)"/oracle/bali/dbUI/viewBuilder/images/lessequal.gif");
            _sGreaterEqualImage = ImageUtils.getImageResource((Class)clazz, (String)"/oracle/bali/dbUI/viewBuilder/images/greaterequal.gif");
            _sOuterJoinImage = ImageUtils.getImageResource((Class)clazz, (String)"/oracle/bali/dbUI/viewBuilder/images/outerjoin.gif");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        _sIMAGE_CREATOR.pack();
        _sJoinOffset = 6;
    }

    private class Listener
    implements PropertyChangeListener {
        private Listener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("relationshipType".equals(string)) {
                RelationshipLinkPainter.this.invalidate();
            } else if ("sourceOuterJoin".equals(string)) {
                RelationshipLinkPainter.this.invalidate();
            } else if ("destinationOuterJoin".equals(string)) {
                RelationshipLinkPainter.this.invalidate();
            }
        }
    }

    private class Info {
        public int p1x;
        public int p1y;
        public int p2x;
        public int p2y;
        public int p3x;
        public int p3y;
        public int p4x;
        public int p4y;
        public int parentX;
        public int parentY;
        public int imageX;
        public int imageY;
        public int sourceImageX;
        public int sourceImageY;
        public int destImageX;
        public int destImageY;
        public int nameX;
        public int nameY;
        public boolean left;

        private Info() {
        }
    }
}

