/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.viewBuilder;

import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import oracle.bali.dbUI.db.Column;
import oracle.bali.dbUI.tableComponent.TableComponent;
import oracle.bali.dbUI.viewBuilder.TableViewBuilderComponent;
import oracle.bali.dbUI.viewBuilder.ViewBuilderComponent;
import oracle.bali.dbUI.viewBuilder.ViewBuilderLinkPort;

public class ColumnLinkPort
implements ViewBuilderLinkPort {
    private TableViewBuilderComponent _component;
    private PropertyChangeSupport _support;
    private int _x;
    private int _y;
    private int _width;
    private int _height;
    private TableComponent _tableComponent;
    private Column _column;
    private PropertyChangeListener _listener;

    public ColumnLinkPort(TableViewBuilderComponent tableViewBuilderComponent, TableComponent tableComponent, Column column) {
        if (tableViewBuilderComponent == null || tableComponent == null || column == null) {
            throw new IllegalArgumentException();
        }
        this._listener = new Updater();
        this._tableComponent = tableComponent;
        ((Container)((Object)this._tableComponent)).addPropertyChangeListener(this._listener);
        this._component = tableViewBuilderComponent;
        this._component.addPropertyChangeListener(this._listener);
        this._column = column;
    }

    public ViewBuilderComponent getViewBuilderComponent() {
        return this._component;
    }

    public Column getColumn() {
        return this._column;
    }

    public TableComponent getTableComponent() {
        return this._tableComponent;
    }

    public void setHighlighted(boolean bl) {
        this.getTableComponent().setColumnHighlighted(this.getColumn(), bl);
    }

    public Rectangle getBounds() {
        if (this._width == 0 || this._height == 0) {
            this._calculateBounds();
        }
        return new Rectangle(this._x, this._y, this._width, this._height);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (this._x != n || this._y != n2 || this._width != n3 || this._height != n4) {
            Rectangle rectangle = new Rectangle(this._x, this._y, this._width, this._height);
            this._x = n;
            this._y = n2;
            this._width = n3;
            this._height = n4;
            Rectangle rectangle2 = new Rectangle(this._x, this._y, this._width, this._height);
            this.firePropertyChange("bounds", rectangle, rectangle2);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._support == null) {
            this._support = new PropertyChangeSupport(this);
        }
        this._support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._support != null) {
            this._support.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public void cleanup() {
        ((Component)((Object)this._tableComponent)).removePropertyChangeListener(this._listener);
        this._component.removePropertyChangeListener(this._listener);
        this._listener = null;
        this._component = null;
        this._tableComponent = null;
        this._column = null;
    }

    public void invalidate() {
        this._calculateBounds();
    }

    public TableViewBuilderComponent getTableViewBuilderComponent() {
        return this._component;
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (this._support != null) {
            this._support.firePropertyChange(string, object, object2);
        }
    }

    private void _calculateBounds() {
        int n;
        Rectangle rectangle = this.getViewBuilderComponent().getComponentBounds();
        int n2 = 0;
        if (((Component)((Object)this.getTableComponent())).isShowing()) {
            n2 = this.getTableComponent().getColumnLocation(this.getColumn()) + this.getTableViewBuilderComponent().getTableComponentLocation().y;
        }
        if (n2 + (n = this.getTableComponent().getSpreadTable().getDefaultRowHeight()) > rectangle.height) {
            n2 = rectangle.height - n;
        }
        this.setBounds(0, n2, rectangle.width, n);
    }

    private class Updater
    implements PropertyChangeListener {
        private Updater() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("columnLocation".equals(string)) {
                ColumnLinkPort.this._calculateBounds();
            } else if ("bounds".equals(string)) {
                ColumnLinkPort.this._calculateBounds();
            }
        }
    }
}

