/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.util.jdbc;

import java.beans.PropertyChangeListener;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Vector;
import oracle.bali.dbUI.db.Column;
import oracle.bali.dbUI.db.DataDescriptor;
import oracle.bali.dbUI.db.DataDescriptorProvider;
import oracle.bali.dbUI.db.Relationship;
import oracle.bali.dbUI.db.Schema;
import oracle.bali.dbUI.db.Table;
import oracle.bali.dbUI.db.impl.ColumnImpl;
import oracle.bali.dbUI.db.impl.RelationshipImpl;

public class JDBCTable
extends Table
implements DataDescriptorProvider {
    private static final int _COLUMN_NAME = 4;
    private static final int _DATA_TYPE = 5;
    private static final int _COLUMN_SIZE = 7;
    private static final int _DECIMAL_DIGITS = 9;
    private static final int _NULLABLE = 11;
    private static final int _ORDINAL = 17;
    private static final int _DEFAULT = 13;
    private static final int _PK_COLUMN_NAME = 4;
    private static final int _FK_COLUMN_NAME = 4;
    private static final int _FK_TABLE_NAME = 3;
    private static final int _FK_FK_COLUMN_NAME = 8;
    private static final int _FK_NAME = 12;
    private static final int _EK_COLUMN_NAME = 4;
    private static final int _EK_TABLE_NAME = 7;
    private static final int _EK_FK_COLUMN_NAME = 8;
    private static final int _EK_NAME = 12;
    private Connection _connection;
    private String _tableName;
    private Schema _schema;
    private Column[] _columns;
    private Column[] _primaryKey;
    private Relationship[] _foreignKey;
    private Relationship[] _exportedKey;
    private final Object _RESULTS_OBJECT = new Object();
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$String;

    public JDBCTable(Connection connection, Schema schema, String string) {
        this._tableName = string;
        this._connection = connection;
        this._schema = schema;
    }

    public Schema getSchema() {
        return this._schema;
    }

    public String getName() {
        return this._tableName;
    }

    public String getDisplayName(Locale locale) {
        return this.getName();
    }

    public int getColumnCount() {
        Column[] columnArray = this._getColumns();
        return columnArray == null ? 0 : columnArray.length;
    }

    public Column getColumn(int n) {
        Column[] columnArray = this._getColumns();
        return columnArray == null ? null : columnArray[n];
    }

    public Column getColumn(String string) {
        Column[] columnArray = this._getColumns();
        int n = 0;
        while (n < this.getColumnCount()) {
            if (columnArray[n].getName().equals(string)) {
                return columnArray[n];
            }
            ++n;
        }
        return null;
    }

    public String getColumnDisplayName(int n, Locale locale) {
        return this.getColumnName(n);
    }

    public String getColumnName(int n) {
        Column[] columnArray = this._getColumns();
        return columnArray == null ? null : columnArray[n].getName();
    }

    public synchronized Column[] getColumns() {
        if (this._columns == null) {
            this._columns = this.createColumns();
        }
        return this._columns;
    }

    public int getDescriptorCount() {
        return this.getColumnCount();
    }

    public DataDescriptor getDescriptor(int n) {
        return this.getColumn(n);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }

    public int getPrimaryKeyCount() {
        if (this._primaryKey == null) {
            this._primaryKey = this._createPrimaryKey();
        }
        return this._primaryKey == null ? 0 : this._primaryKey.length;
    }

    public Column getPrimaryKey(int n) {
        if (this._primaryKey == null) {
            this._primaryKey = this._createPrimaryKey();
        }
        return this._primaryKey == null ? null : this._primaryKey[n];
    }

    public int getForeignKeyCount() {
        if (this._foreignKey == null) {
            this._foreignKey = this.createForeignKey();
        }
        return this._foreignKey == null ? 0 : this._foreignKey.length;
    }

    public Relationship getForeignKey(int n) {
        if (this._foreignKey == null) {
            this._foreignKey = this.createForeignKey();
        }
        return this._foreignKey == null ? null : this._foreignKey[n];
    }

    public int getUniqueKeyCount() {
        return 0;
    }

    public Column getUniqueKey(int n) {
        return null;
    }

    public int getExportedKeyCount() {
        if (this._exportedKey == null) {
            this._exportedKey = this.createExportedKey();
        }
        return this._exportedKey == null ? 0 : this._exportedKey.length;
    }

    public Relationship getExportedKey(int n) {
        if (this._exportedKey == null) {
            this._exportedKey = this.createExportedKey();
        }
        return this._exportedKey == null ? null : this._exportedKey[n];
    }

    public Connection getConnection() {
        return this._connection;
    }

    public String toString() {
        return this.getName();
    }

    protected Column[] createColumns() {
        Object[] objectArray = null;
        try {
            ResultSet resultSet = this._connection.getMetaData().getColumns(null, this._getSchemaName(), this.getName(), null);
            Vector<ColumnImpl> vector = new Vector<ColumnImpl>();
            int n = 0;
            Object object = this._RESULTS_OBJECT;
            synchronized (object) {
                while (resultSet.next()) {
                    String string;
                    String string2 = string = resultSet.getString(4);
                    n = resultSet.getInt(5);
                    int n2 = resultSet.getInt(9);
                    Class clazz = this._getClass(n, n2);
                    int n3 = resultSet.getInt(11);
                    boolean bl = n3 == 1;
                    String string3 = resultSet.getString(13);
                    ColumnImpl columnImpl = new ColumnImpl(string, string2, clazz, bl, string3, this);
                    vector.addElement(columnImpl);
                }
            }
            objectArray = new Column[vector.size()];
            if (vector.size() != 0) {
                vector.copyInto(objectArray);
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            System.err.println("A SQLException occured " + sQLException);
        }
        return objectArray;
    }

    Relationship[] createForeignKey() {
        Relationship[] relationshipArray = null;
        try {
            int n = 0;
            DatabaseMetaData databaseMetaData = this._connection.getMetaData();
            Relationship[] relationshipArray2 = new Relationship[databaseMetaData.getMaxColumnsInTable()];
            ResultSet resultSet = databaseMetaData.getImportedKeys(null, this._getSchemaName(), this.getName());
            Object object = this._RESULTS_OBJECT;
            synchronized (object) {
                while (resultSet.next()) {
                    String string = resultSet.getString(4);
                    String string2 = resultSet.getString(3);
                    String string3 = resultSet.getString(8);
                    String string4 = resultSet.getString(12);
                    JDBCTable jDBCTable = new JDBCTable(this._connection, this.getSchema(), string2);
                    Column column = jDBCTable.getColumn(string);
                    Column column2 = this.getColumn(string3);
                    relationshipArray2[n] = new RelationshipImpl(column2, column, string4);
                    ++n;
                }
            }
            relationshipArray = new Relationship[n];
            System.arraycopy(relationshipArray2, 0, relationshipArray, 0, n);
            resultSet.close();
        }
        catch (SQLException sQLException) {
            System.err.println("A SQLException has occured: " + sQLException);
        }
        return relationshipArray;
    }

    Relationship[] createExportedKey() {
        Relationship[] relationshipArray = null;
        try {
            int n = 0;
            DatabaseMetaData databaseMetaData = this._connection.getMetaData();
            Relationship[] relationshipArray2 = new Relationship[databaseMetaData.getMaxColumnsInTable()];
            ResultSet resultSet = databaseMetaData.getExportedKeys(null, this._getSchemaName(), this.getName());
            Object object = this._RESULTS_OBJECT;
            synchronized (object) {
                while (resultSet.next()) {
                    String string = resultSet.getString(4);
                    String string2 = resultSet.getString(8);
                    String string3 = resultSet.getString(7);
                    String string4 = resultSet.getString(12);
                    JDBCTable jDBCTable = new JDBCTable(this._connection, this.getSchema(), string3);
                    Column column = this.getColumn(string);
                    Column column2 = jDBCTable.getColumn(string2);
                    relationshipArray2[n] = new RelationshipImpl(column2, column, string4);
                    ++n;
                }
            }
            relationshipArray = new Relationship[n];
            System.arraycopy(relationshipArray2, 0, relationshipArray, 0, n);
            resultSet.close();
        }
        catch (SQLException sQLException) {
            System.err.println("A SQLException has occured: " + sQLException);
        }
        return relationshipArray;
    }

    private Column[] _getColumns() {
        if (this._columns == null) {
            this._columns = this.createColumns();
        }
        return this._columns;
    }

    private Column[] _createPrimaryKey() {
        Column[] columnArray = null;
        try {
            int n = 0;
            DatabaseMetaData databaseMetaData = this._connection.getMetaData();
            Column[] columnArray2 = new Column[databaseMetaData.getMaxColumnsInTable()];
            ResultSet resultSet = databaseMetaData.getPrimaryKeys(null, this._getSchemaName(), this.getName());
            Object object = this._RESULTS_OBJECT;
            synchronized (object) {
                while (resultSet.next()) {
                    String string = resultSet.getString(4);
                    columnArray2[n] = this.getColumn(string);
                    ++n;
                }
            }
            columnArray = new Column[n];
            System.arraycopy(columnArray2, 0, columnArray, 0, n);
            resultSet.close();
        }
        catch (SQLException sQLException) {
            System.err.println("A SQLException has occured: " + sQLException);
        }
        return columnArray;
    }

    private Class _getClass(int n, int n2) {
        Class clazz;
        switch (n) {
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                clazz = class$java$lang$Long == null ? (class$java$lang$Long = JDBCTable.class$("java.lang.Long")) : class$java$lang$Long;
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 1111: {
                clazz = class$java$lang$Object == null ? (class$java$lang$Object = JDBCTable.class$("java.lang.Object")) : class$java$lang$Object;
                break;
            }
            case -7: {
                clazz = class$java$lang$Boolean == null ? (class$java$lang$Boolean = JDBCTable.class$("java.lang.Boolean")) : class$java$lang$Boolean;
                break;
            }
            case 91: {
                clazz = class$java$sql$Date == null ? (class$java$sql$Date = JDBCTable.class$("java.sql.Date")) : class$java$sql$Date;
                break;
            }
            case 92: {
                clazz = class$java$sql$Time == null ? (class$java$sql$Time = JDBCTable.class$("java.sql.Time")) : class$java$sql$Time;
                break;
            }
            case 93: {
                clazz = class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = JDBCTable.class$("java.sql.Timestamp")) : class$java$sql$Timestamp;
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                if (n2 == 0) {
                    clazz = class$java$lang$Long == null ? (class$java$lang$Long = JDBCTable.class$("java.lang.Long")) : class$java$lang$Long;
                    break;
                }
                clazz = class$java$lang$Double == null ? (class$java$lang$Double = JDBCTable.class$("java.lang.Double")) : class$java$lang$Double;
                break;
            }
            case 6: {
                clazz = class$java$lang$Float == null ? (class$java$lang$Float = JDBCTable.class$("java.lang.Float")) : class$java$lang$Float;
                break;
            }
            case 1: {
                clazz = class$java$lang$Character == null ? (class$java$lang$Character = JDBCTable.class$("java.lang.Character")) : class$java$lang$Character;
                break;
            }
            case -1: 
            case 12: {
                clazz = class$java$lang$String == null ? (class$java$lang$String = JDBCTable.class$("java.lang.String")) : class$java$lang$String;
                break;
            }
            default: {
                clazz = null;
            }
        }
        return clazz;
    }

    private String _getSchemaName() {
        Schema schema = this.getSchema();
        return schema == null ? null : schema.getName();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

